/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref.statistical;

import edu.stanford.nlp.coref.data.Dictionaries;
import edu.stanford.nlp.coref.statistical.CompressedFeatureVector;
import edu.stanford.nlp.coref.statistical.Compressor;
import edu.stanford.nlp.coref.statistical.Example;
import edu.stanford.nlp.coref.statistical.StatisticalCorefTrainer;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MetaFeatureExtractor {
    private final boolean neTypeConjuntion;
    private final boolean anaphoricityClassifier;
    private final Set<PairConjunction> pairConjunctions;
    private final Set<SingleConjunction> singleConjunctions;
    private final List<String> disallowedPrefixes;
    private final String str;

    public static Builder newBuilder() {
        return new Builder();
    }

    public MetaFeatureExtractor(Builder builder) {
        this.anaphoricityClassifier = builder.anaphoricityClassifier;
        this.pairConjunctions = this.anaphoricityClassifier ? new HashSet<PairConjunction>() : new HashSet<PairConjunction>(builder.pairConjunctions);
        this.singleConjunctions = new HashSet<SingleConjunction>(builder.singleConjunctions);
        this.disallowedPrefixes = builder.disallowedPrefixes;
        this.neTypeConjuntion = builder.useNEType;
        this.str = StatisticalCorefTrainer.fieldValues(builder);
    }

    public static MetaFeatureExtractor anaphoricityMFE() {
        return MetaFeatureExtractor.newBuilder().singleConjunctions(new SingleConjunction[]{SingleConjunction.INDEX, SingleConjunction.INDEX_LAST}).disallowedPrefixes(new String[]{"parent-word"}).anaphoricityClassifier(true).build();
    }

    public static Counter<String> filterOut(Counter<String> c, List<String> disallowedPrefixes) {
        ClassicCounter<String> c2 = new ClassicCounter<String>();
        for (Map.Entry<String, Double> e : c.entrySet()) {
            boolean allowed = true;
            for (String prefix : disallowedPrefixes) {
                allowed &= !e.getKey().startsWith(prefix);
            }
            if (!allowed) continue;
            c2.incrementCount(e.getKey(), e.getValue());
        }
        return c2;
    }

    public Counter<String> getFeatures(Example example, Map<Integer, CompressedFeatureVector> mentionFeatures, Compressor<String> compressor) {
        ClassicCounter<String> features = new ClassicCounter<String>();
        ClassicCounter<String> pairFeatures = new ClassicCounter();
        Counter<String> features1 = new ClassicCounter<String>();
        Counter<String> features2 = compressor.uncompress(mentionFeatures.get(example.mentionId2));
        if (!example.isNewLink()) {
            assert (!this.anaphoricityClassifier);
            pairFeatures = compressor.uncompress(example.pairwiseFeatures);
            features1 = compressor.uncompress(mentionFeatures.get(example.mentionId1));
        } else {
            features2.incrementCount("bias");
        }
        if (!this.disallowedPrefixes.isEmpty()) {
            features1 = MetaFeatureExtractor.filterOut(features1, this.disallowedPrefixes);
            features2 = MetaFeatureExtractor.filterOut(features2, this.disallowedPrefixes);
            pairFeatures = MetaFeatureExtractor.filterOut(pairFeatures, this.disallowedPrefixes);
        }
        ArrayList ids1 = example.isNewLink() ? new ArrayList() : this.identifiers(features1, example.mentionType1);
        List<String> ids2 = this.identifiers(features2, example.mentionType2);
        features.addAll(pairFeatures);
        for (String id1 : ids1) {
            for (String id2 : ids2) {
                if (this.pairConjunctions.contains((Object)PairConjunction.FIRST)) {
                    features.addAll(MetaFeatureExtractor.getConjunction(pairFeatures, "_m1=" + id1));
                }
                if (this.pairConjunctions.contains((Object)PairConjunction.LAST)) {
                    features.addAll(MetaFeatureExtractor.getConjunction(pairFeatures, "_m2=" + id2));
                }
                if (this.pairConjunctions.contains((Object)PairConjunction.BOTH)) {
                    features.addAll(MetaFeatureExtractor.getConjunction(pairFeatures, "_ms=" + id1 + "_" + id2));
                }
                if (this.singleConjunctions.contains((Object)SingleConjunction.INDEX)) {
                    features.addAll(MetaFeatureExtractor.getConjunction(features1, "_1"));
                    features.addAll(MetaFeatureExtractor.getConjunction(features2, "_2"));
                }
                if (this.singleConjunctions.contains((Object)SingleConjunction.INDEX_CURRENT)) {
                    features.addAll(MetaFeatureExtractor.getConjunction(features1, "_1_m=" + id1));
                    features.addAll(MetaFeatureExtractor.getConjunction(features2, "_2_m=" + id2));
                }
                if (this.singleConjunctions.contains((Object)SingleConjunction.INDEX_LAST)) {
                    features.addAll(MetaFeatureExtractor.getConjunction(features1, "_1_m2=" + id2));
                    features.addAll(MetaFeatureExtractor.getConjunction(features2, "_2_m2=" + id2));
                }
                if (this.singleConjunctions.contains((Object)SingleConjunction.INDEX_OTHER)) {
                    features.addAll(MetaFeatureExtractor.getConjunction(features1, "_1_m=" + id2));
                    features.addAll(MetaFeatureExtractor.getConjunction(features2, "_2_m=" + id1));
                }
                if (!this.singleConjunctions.contains((Object)SingleConjunction.INDEX_BOTH)) continue;
                features.addAll(MetaFeatureExtractor.getConjunction(features1, "_1_ms=" + id1 + "_" + id2));
                features.addAll(MetaFeatureExtractor.getConjunction(features2, "_2_ms=" + id1 + "_" + id2));
            }
        }
        if (example.isNewLink()) {
            features.addAll(features2);
            features.addAll(MetaFeatureExtractor.getConjunction(features2, "_m=" + ids2.get(0)));
            ClassicCounter<String> newFeatures = new ClassicCounter<String>();
            for (Map.Entry e : features.entrySet()) {
                newFeatures.incrementCount((String)e.getKey() + "_NEW", e.getValue());
            }
            features = newFeatures;
        }
        return features;
    }

    private List<String> identifiers(Counter<String> features, Dictionaries.MentionType mentionType) {
        ArrayList<String> identifiers = new ArrayList<String>();
        if (mentionType == Dictionaries.MentionType.PRONOMINAL) {
            for (String feature : features.keySet()) {
                if (!feature.startsWith("head-word=")) continue;
                identifiers.add(feature.replace("head-word=", ""));
                return identifiers;
            }
        } else if (this.neTypeConjuntion && mentionType == Dictionaries.MentionType.PROPER) {
            for (String feature : features.keySet()) {
                if (!feature.startsWith("head-ne-type=")) continue;
                identifiers.add(mentionType.toString() + "_" + feature.replace("head-ne-type=", ""));
                return identifiers;
            }
        }
        identifiers.add(mentionType.toString());
        return identifiers;
    }

    private static Counter<String> getConjunction(Counter<String> original, String suffix) {
        ClassicCounter<String> conjuction = new ClassicCounter<String>();
        for (Map.Entry<String, Double> e : original.entrySet()) {
            conjuction.incrementCount(e.getKey() + suffix, e.getValue());
        }
        return conjuction;
    }

    public String toString() {
        return this.str;
    }

    public static class Builder {
        private boolean anaphoricityClassifier = false;
        private List<PairConjunction> pairConjunctions = Arrays.asList(PairConjunction.LAST, PairConjunction.FIRST, PairConjunction.BOTH);
        private List<SingleConjunction> singleConjunctions = Arrays.asList(SingleConjunction.INDEX, SingleConjunction.INDEX_CURRENT, SingleConjunction.INDEX_BOTH);
        private List<String> disallowedPrefixes = new ArrayList<String>();
        private boolean useNEType = true;

        public Builder anaphoricityClassifier(boolean anaphoricityClassifier) {
            this.anaphoricityClassifier = anaphoricityClassifier;
            return this;
        }

        public Builder pairConjunctions(PairConjunction[] pairConjunctions) {
            this.pairConjunctions = Arrays.asList(pairConjunctions);
            return this;
        }

        public Builder singleConjunctions(SingleConjunction[] singleConjunctions) {
            this.singleConjunctions = Arrays.asList(singleConjunctions);
            return this;
        }

        public Builder disallowedPrefixes(String[] disallowedPrefixes) {
            this.disallowedPrefixes = Arrays.asList(disallowedPrefixes);
            return this;
        }

        public Builder useNEType(boolean useNEType) {
            this.useNEType = useNEType;
            return this;
        }

        public MetaFeatureExtractor build() {
            return new MetaFeatureExtractor(this);
        }
    }

    public static enum SingleConjunction {
        INDEX,
        INDEX_CURRENT,
        INDEX_OTHER,
        INDEX_BOTH,
        INDEX_LAST;

    }

    public static enum PairConjunction {
        FIRST,
        LAST,
        BOTH;

    }
}

