/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.nndep;

import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.ReflectionLoading;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;

public class Config {
    public static final String UNKNOWN = "-UNKNOWN-";
    public static final String ROOT = "-ROOT-";
    public static final String NULL = "-NULL-";
    public static final int NONEXIST = -1;
    public static final String SEPARATOR = "###################";
    public Language language = Language.UniversalEnglish;
    public int trainingThreads = 1;
    public int wordCutOff = 1;
    public double initRange = 0.01;
    public int maxIter = 20000;
    public int batchSize = 10000;
    public double adaEps = 1.0E-6;
    public double adaAlpha = 0.01;
    public double regParameter = 1.0E-8;
    public double dropProb = 0.5;
    public int hiddenSize = 200;
    public int embeddingSize = 50;
    public static final int numTokens = 48;
    public int numPreComputed = 100000;
    public int evalPerIter = 100;
    public int clearGradientsPerIter = 0;
    public boolean saveIntermediate = true;
    public boolean unlabeled = false;
    public boolean cPOS = false;
    public boolean noPunc = true;
    public boolean doWordEmbeddingGradUpdate = true;
    public TreebankLanguagePack tlp;
    public String sentenceDelimiter = null;
    public Function<List<HasWord>, List<HasWord>> escaper = null;
    public String tagger = "edu/stanford/nlp/models/pos-tagger/english-left3words/english-left3words-distsim.tagger";

    public Config(Properties properties) {
        this.setProperties(properties);
    }

    private void setProperties(Properties props) {
        this.trainingThreads = PropertiesUtils.getInt(props, "trainingThreads", this.trainingThreads);
        this.wordCutOff = PropertiesUtils.getInt(props, "wordCutOff", this.wordCutOff);
        this.initRange = PropertiesUtils.getDouble(props, "initRange", this.initRange);
        this.maxIter = PropertiesUtils.getInt(props, "maxIter", this.maxIter);
        this.batchSize = PropertiesUtils.getInt(props, "batchSize", this.batchSize);
        this.adaEps = PropertiesUtils.getDouble(props, "adaEps", this.adaEps);
        this.adaAlpha = PropertiesUtils.getDouble(props, "adaAlpha", this.adaAlpha);
        this.regParameter = PropertiesUtils.getDouble(props, "regParameter", this.regParameter);
        this.dropProb = PropertiesUtils.getDouble(props, "dropProb", this.dropProb);
        this.hiddenSize = PropertiesUtils.getInt(props, "hiddenSize", this.hiddenSize);
        this.embeddingSize = PropertiesUtils.getInt(props, "embeddingSize", this.embeddingSize);
        this.numPreComputed = PropertiesUtils.getInt(props, "numPreComputed", this.numPreComputed);
        this.evalPerIter = PropertiesUtils.getInt(props, "evalPerIter", this.evalPerIter);
        this.clearGradientsPerIter = PropertiesUtils.getInt(props, "clearGradientsPerIter", this.clearGradientsPerIter);
        this.saveIntermediate = PropertiesUtils.getBool(props, "saveIntermediate", this.saveIntermediate);
        this.unlabeled = PropertiesUtils.getBool(props, "unlabeled", this.unlabeled);
        this.cPOS = PropertiesUtils.getBool(props, "cPOS", this.cPOS);
        this.noPunc = PropertiesUtils.getBool(props, "noPunc", this.noPunc);
        this.doWordEmbeddingGradUpdate = PropertiesUtils.getBool(props, "doWordEmbeddingGradUpdate", this.doWordEmbeddingGradUpdate);
        this.sentenceDelimiter = PropertiesUtils.getString(props, "sentenceDelimiter", this.sentenceDelimiter);
        this.tagger = PropertiesUtils.getString(props, "tagger.model", this.tagger);
        String escaperClass = props.getProperty("escaper");
        this.escaper = escaperClass != null ? (Function)ReflectionLoading.loadByReflection(escaperClass, new Object[0]) : null;
        this.language = props.containsKey("language") ? Config.getLanguage(props.getProperty("language")) : this.language;
        this.tlp = this.language.params.treebankLanguagePack();
    }

    private static Language getLanguage(String languageStr) {
        for (Language l : Language.values()) {
            if (!l.name().equalsIgnoreCase(languageStr)) continue;
            return l;
        }
        return null;
    }

    public void printParameters() {
        System.err.printf("language = %s%n", new Object[]{this.language});
        System.err.printf("trainingThreads = %d%n", this.trainingThreads);
        System.err.printf("wordCutOff = %d%n", this.wordCutOff);
        System.err.printf("initRange = %.2g%n", this.initRange);
        System.err.printf("maxIter = %d%n", this.maxIter);
        System.err.printf("batchSize = %d%n", this.batchSize);
        System.err.printf("adaEps = %.2g%n", this.adaEps);
        System.err.printf("adaAlpha = %.2g%n", this.adaAlpha);
        System.err.printf("regParameter = %.2g%n", this.regParameter);
        System.err.printf("dropProb = %.2g%n", this.dropProb);
        System.err.printf("hiddenSize = %d%n", this.hiddenSize);
        System.err.printf("embeddingSize = %d%n", this.embeddingSize);
        System.err.printf("numPreComputed = %d%n", this.numPreComputed);
        System.err.printf("evalPerIter = %d%n", this.evalPerIter);
        System.err.printf("clearGradientsPerIter = %d%n", this.clearGradientsPerIter);
        System.err.printf("saveItermediate = %b%n", this.saveIntermediate);
        System.err.printf("unlabeled = %b%n", this.unlabeled);
        System.err.printf("cPOS = %b%n", this.cPOS);
        System.err.printf("noPunc = %b%n", this.noPunc);
        System.err.printf("doWordEmbeddingGradUpdate = %b%n", this.doWordEmbeddingGradUpdate);
    }
}

