/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.classify.ColumnDataClassifier;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.Datum;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.StringUtils;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;

public class ColumnDataClassifierAnnotator
implements Annotator {
    private final ColumnDataClassifier cdcClassifier;
    private final boolean verbose;
    private static final String DUMMY_LABEL_COLUMN = "DUMMY\t";

    public ColumnDataClassifierAnnotator(String propFile) {
        this.cdcClassifier = new ColumnDataClassifier(propFile);
        this.verbose = false;
    }

    public ColumnDataClassifierAnnotator(Properties props) {
        this.cdcClassifier = new ColumnDataClassifier(props);
        this.verbose = PropertiesUtils.getBool(props, "classify.verbose", false);
    }

    public ColumnDataClassifierAnnotator(String propFile, boolean verbose) {
        this.cdcClassifier = new ColumnDataClassifier(propFile);
        this.verbose = verbose;
    }

    @Override
    public void annotate(Annotation annotation) {
        if (this.verbose) {
            System.out.println("Adding column data classifier annotation...");
        }
        String text = DUMMY_LABEL_COLUMN + (String)annotation.get(CoreAnnotations.TextAnnotation.class);
        if (this.verbose) {
            System.out.println("Dummy column: " + text);
        }
        Datum<String, String> datum = this.cdcClassifier.makeDatumFromLine(text);
        if (this.verbose) {
            System.out.println("Datum: " + datum.toString());
        }
        String label = this.cdcClassifier.classOf(datum);
        annotation.set(CoreAnnotations.ColumnDataClassifierAnnotation.class, label);
        if (this.verbose) {
            System.out.println(String.format("annotation=%s", annotation.get(CoreAnnotations.ColumnDataClassifierAnnotation.class)));
        }
        if (this.verbose) {
            System.out.println("Done.");
        }
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.emptySet();
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.emptySet();
    }

    public static void main(String[] args) {
        Properties props = StringUtils.propFileToProperties("projects/core/src/edu/stanford/nlp/classify/mood.prop");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        Annotation happyAnnotation = new Annotation("I am so glad this is awesome");
        pipeline.annotate(happyAnnotation);
        Annotation sadAnnotation = new Annotation("I am so gloomy and depressed");
        pipeline.annotate(sadAnnotation);
        Annotation bothAnnotation = new Annotation("I am so gloomy gloomy gloomy gloomy glad");
        pipeline.annotate(bothAnnotation);
    }
}

