/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.ChunkAnnotationUtils;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LabeledChunkIdentifier {
    private boolean ignoreProvidedTag = false;
    private String negLabel = "O";
    private String defaultPosTag = "I";
    private String defaultNegTag = "O";
    private static final Pattern labelPattern = Pattern.compile("^([^-]*)-(.*)$");

    public List<CoreMap> getAnnotatedChunks(List<CoreLabel> tokens, int totalTokensOffset, Class textKey, Class labelKey) {
        return this.getAnnotatedChunks(tokens, totalTokensOffset, textKey, labelKey, null, null);
    }

    public List<CoreMap> getAnnotatedChunks(List<CoreLabel> tokens, int totalTokensOffset, Class textKey, Class labelKey, Function<Pair<CoreLabel, CoreLabel>, Boolean> checkTokensCompatible) {
        return this.getAnnotatedChunks(tokens, totalTokensOffset, textKey, labelKey, null, null, checkTokensCompatible);
    }

    public List<CoreMap> getAnnotatedChunks(List<CoreLabel> tokens, int totalTokensOffset, Class textKey, Class labelKey, Class tokenChunkKey, Class tokenLabelKey) {
        return this.getAnnotatedChunks(tokens, totalTokensOffset, textKey, labelKey, tokenChunkKey, tokenLabelKey, null);
    }

    public List<CoreMap> getAnnotatedChunks(List<CoreLabel> tokens, int totalTokensOffset, Class textKey, Class labelKey, Class tokenChunkKey, Class tokenLabelKey, Function<Pair<CoreLabel, CoreLabel>, Boolean> checkTokensCompatible) {
        ArrayList<CoreMap> chunks = new ArrayList<CoreMap>();
        LabelTagType prevTagType = null;
        int tokenBegin = -1;
        for (int i = 0; i < tokens.size(); ++i) {
            CoreLabel token = tokens.get(i);
            String label = (String)token.get(labelKey);
            LabelTagType curTagType = this.getTagType(label);
            boolean isCompatible = true;
            if (checkTokensCompatible != null) {
                CoreLabel prev = null;
                if (i > 0) {
                    prev = tokens.get(i - 1);
                }
                Pair<CoreLabel, Object> p = Pair.makePair(token, prev);
                isCompatible = checkTokensCompatible.apply(p);
            }
            if (LabeledChunkIdentifier.isEndOfChunk(prevTagType, curTagType) || !isCompatible) {
                int tokenEnd = i;
                if (tokenBegin >= 0 && tokenEnd > tokenBegin) {
                    Annotation chunk = ChunkAnnotationUtils.getAnnotatedChunk(tokens, tokenBegin, tokenEnd, totalTokensOffset, tokenChunkKey, textKey, tokenLabelKey);
                    chunk.set(labelKey, prevTagType.type);
                    chunks.add(chunk);
                    tokenBegin = -1;
                }
            }
            if (LabeledChunkIdentifier.isStartOfChunk(prevTagType, curTagType) || !isCompatible && LabeledChunkIdentifier.isChunk(curTagType)) {
                if (tokenBegin >= 0) {
                    throw new RuntimeException("New chunk started, prev chunk not ended yet!");
                }
                tokenBegin = i;
            }
            prevTagType = curTagType;
        }
        if (tokenBegin >= 0) {
            Annotation chunk = ChunkAnnotationUtils.getAnnotatedChunk(tokens, tokenBegin, tokens.size(), totalTokensOffset, tokenChunkKey, textKey, tokenLabelKey);
            chunk.set(labelKey, prevTagType.type);
            chunks.add(chunk);
        }
        return chunks;
    }

    private static boolean isEndOfChunk(String prevTag, String prevType, String curTag, String curType) {
        boolean chunkEnd = false;
        if ("B".equals(prevTag) && "B".equals(curTag)) {
            chunkEnd = true;
        }
        if ("B".equals(prevTag) && "O".equals(curTag)) {
            chunkEnd = true;
        }
        if ("I".equals(prevTag) && "B".equals(curTag)) {
            chunkEnd = true;
        }
        if ("I".equals(prevTag) && "O".equals(curTag)) {
            chunkEnd = true;
        }
        if ("E".equals(prevTag) || "L".equals(prevTag) || "S".equals(prevTag) || "U".equals(prevTag) || "[".equals(prevTag) || "]".equals(prevTag)) {
            chunkEnd = true;
        }
        if (!("O".equals(prevTag) || ".".equals(prevTag) || prevType.equals(curType))) {
            chunkEnd = true;
        }
        return chunkEnd;
    }

    public static boolean isEndOfChunk(LabelTagType prev, LabelTagType cur) {
        if (prev == null) {
            return false;
        }
        return LabeledChunkIdentifier.isEndOfChunk(prev.tag, prev.type, cur.tag, cur.type);
    }

    private static boolean isStartOfChunk(String prevTag, String prevType, String curTag, String curType) {
        boolean curTagE;
        boolean chunkStart = false;
        boolean prevTagE = "E".equals(prevTag) || "L".equals(prevTag) || "S".equals(prevTag) || "U".equals(prevTag);
        boolean bl = curTagE = "E".equals(curTag) || "L".equals(curTag) || "S".equals(curTag) || "U".equals(curTag);
        if (prevTagE && curTagE) {
            chunkStart = true;
        }
        if (prevTagE && "I".equals(curTag)) {
            chunkStart = true;
        }
        if ("O".equals(prevTag) && curTagE) {
            chunkStart = true;
        }
        if ("O".equals(prevTag) && "I".equals(curTag)) {
            chunkStart = true;
        }
        if ("B".equals(curTag) || "S".equals(curTag) || "U".equals(curTag) || "[".equals(curTag) || "]".equals(curTag)) {
            chunkStart = true;
        }
        if (!("O".equals(curTag) || ".".equals(curTag) || prevType.equals(curType))) {
            chunkStart = true;
        }
        return chunkStart;
    }

    public static boolean isStartOfChunk(LabelTagType prev, LabelTagType cur) {
        if (prev == null) {
            return LabeledChunkIdentifier.isStartOfChunk("O", "O", cur.tag, cur.type);
        }
        return LabeledChunkIdentifier.isStartOfChunk(prev.tag, prev.type, cur.tag, cur.type);
    }

    private static boolean isChunk(LabelTagType cur) {
        return !"O".equals(cur.tag) && !".".equals(cur.tag);
    }

    public LabelTagType getTagType(String label) {
        String tag;
        String type;
        if (label == null) {
            return new LabelTagType(this.negLabel, this.defaultNegTag, this.negLabel);
        }
        Matcher matcher = labelPattern.matcher(label);
        if (matcher.matches()) {
            if (this.ignoreProvidedTag) {
                type = matcher.group(2);
                tag = this.negLabel.equals(type) ? this.defaultNegTag : this.defaultPosTag;
            } else {
                tag = matcher.group(1);
                type = matcher.group(2);
            }
        } else {
            type = label;
            tag = this.negLabel.equals(label) ? this.defaultNegTag : this.defaultPosTag;
        }
        return new LabelTagType(label, tag, type);
    }

    public String getDefaultPosTag() {
        return this.defaultPosTag;
    }

    public void setDefaultPosTag(String defaultPosTag) {
        this.defaultPosTag = defaultPosTag;
    }

    public String getDefaultNegTag() {
        return this.defaultNegTag;
    }

    public void setDefaultNegTag(String defaultNegTag) {
        this.defaultNegTag = defaultNegTag;
    }

    public String getNegLabel() {
        return this.negLabel;
    }

    public void setNegLabel(String negLabel) {
        this.negLabel = negLabel;
    }

    public boolean isIgnoreProvidedTag() {
        return this.ignoreProvidedTag;
    }

    public void setIgnoreProvidedTag(boolean ignoreProvidedTag) {
        this.ignoreProvidedTag = ignoreProvidedTag;
    }

    public static class LabelTagType {
        public String label;
        public String tag;
        public String type;

        public LabelTagType(String label, String tag, String type) {
            this.label = label;
            this.tag = tag;
            this.type = type;
        }

        public boolean typeMatches(LabelTagType other) {
            return this.type.equals(other.type);
        }

        public String toString() {
            return '(' + this.label + ',' + this.tag + ',' + this.type + ')';
        }
    }
}

