/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.io.FileSequentialCollection;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationOutputter;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.AnnotationSerializer;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.AnnotatorImplementations;
import edu.stanford.nlp.pipeline.AnnotatorPool;
import edu.stanford.nlp.pipeline.CoNLLOutputter;
import edu.stanford.nlp.pipeline.CoNLLUOutputter;
import edu.stanford.nlp.pipeline.GenericAnnotationSerializer;
import edu.stanford.nlp.pipeline.JSONOutputter;
import edu.stanford.nlp.pipeline.TextOutputter;
import edu.stanford.nlp.trees.TreePrint;
import edu.stanford.nlp.util.ArgumentParser;
import edu.stanford.nlp.util.ArrayUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Lazy;
import edu.stanford.nlp.util.MetaClass;
import edu.stanford.nlp.util.MutableInteger;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.ReflectionLoading;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.logging.Redwood;
import edu.stanford.nlp.util.logging.StanfordRedwoodConfiguration;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.regex.Pattern;

public class StanfordCoreNLP
extends AnnotationPipeline {
    public static final String CUSTOM_ANNOTATOR_PREFIX = "customAnnotatorClass.";
    private static final String PROPS_SUFFIX = ".properties";
    public static final String NEWLINE_SPLITTER_PROPERTY = "ssplit.eolonly";
    public static final String NEWLINE_IS_SENTENCE_BREAK_PROPERTY = "ssplit.newlineIsSentenceBreak";
    public static final String DEFAULT_NEWLINE_IS_SENTENCE_BREAK = "never";
    public static final String DEFAULT_OUTPUT_FORMAT = StanfordCoreNLP.isXMLOutputPresent() ? "xml" : "text";
    private static final Redwood.RedwoodChannels logger = Redwood.channels(StanfordCoreNLP.class);
    private TreePrint constituentTreePrinter;
    private TreePrint dependencyTreePrinter;
    private int numWords;
    private long pipelineSetupTime;
    private Properties properties;
    private Semaphore availableProcessors;

    public StanfordCoreNLP() {
        this((Properties)null);
    }

    public StanfordCoreNLP(Properties props) {
        this(props, props == null || PropertiesUtils.getBool(props, "enforceRequirements", true));
    }

    public StanfordCoreNLP(Properties props, AnnotatorPool annotatorPool) {
        this(props, props == null || PropertiesUtils.getBool(props, "enforceRequirements", true), annotatorPool);
    }

    public StanfordCoreNLP(Properties props, boolean enforceRequirements) {
        this(props, enforceRequirements, null);
    }

    public StanfordCoreNLP(Properties props, boolean enforceRequirements, AnnotatorPool annotatorPool) {
        this.construct(props, enforceRequirements, this.getAnnotatorImplementations(), annotatorPool);
    }

    public StanfordCoreNLP(String propsFileNamePrefix) {
        this(propsFileNamePrefix, true);
    }

    public StanfordCoreNLP(String propsFileNamePrefix, boolean enforceRequirements) {
        Properties props = StanfordCoreNLP.loadProperties(propsFileNamePrefix);
        if (props == null) {
            throw new RuntimeIOException("ERROR: cannot find properties file \"" + propsFileNamePrefix + "\" in the classpath!");
        }
        this.construct(props, enforceRequirements, this.getAnnotatorImplementations(), null);
    }

    protected AnnotatorImplementations getAnnotatorImplementations() {
        return new AnnotatorImplementations();
    }

    private static String getRequiredProperty(Properties props, String name) {
        String val = props.getProperty(name);
        if (val == null) {
            logger.error("Missing property \"" + name + "\"!");
            StanfordCoreNLP.printRequiredProperties(System.err);
            throw new RuntimeException("Missing property: \"" + name + '\"');
        }
        return val;
    }

    private static Properties loadPropertiesFromClasspath() {
        List<String> validNames = Arrays.asList("StanfordCoreNLP", "edu.stanford.nlp.pipeline.StanfordCoreNLP");
        for (String name : validNames) {
            Properties props = StanfordCoreNLP.loadProperties(name);
            if (props == null) continue;
            return props;
        }
        throw new RuntimeException("ERROR: Could not find properties file in the classpath!");
    }

    private static Properties loadProperties(String name) {
        return StanfordCoreNLP.loadProperties(name, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String name, ClassLoader loader) {
        if (name.endsWith(PROPS_SUFFIX)) {
            name = name.substring(0, name.length() - PROPS_SUFFIX.length());
        }
        name = name.replace('.', '/');
        name = name + PROPS_SUFFIX;
        Properties result = null;
        InputStream in = loader.getResourceAsStream(name);
        try {
            if (in != null) {
                InputStreamReader reader = new InputStreamReader(in, "utf-8");
                result = new Properties();
                result.load(reader);
            }
        }
        catch (IOException e) {
            result = null;
        }
        finally {
            IOUtils.closeIgnoringExceptions(in);
        }
        if (result != null) {
            logger.info("Searching for resource: " + name + " ... found.");
        } else {
            logger.info("Searching for resource: " + name + " ... not found.");
        }
        return result;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public TreePrint getConstituentTreePrinter() {
        return this.constituentTreePrinter;
    }

    public TreePrint getDependencyTreePrinter() {
        return this.dependencyTreePrinter;
    }

    public double getBeamPrintingOption() {
        return PropertiesUtils.getDouble(this.properties, "printable.relation.beam", 0.0);
    }

    public boolean getPrettyPrint() {
        return PropertiesUtils.getBool(this.properties, "prettyPrint", true);
    }

    public String getEncoding() {
        return this.properties.getProperty("encoding", "UTF-8");
    }

    public boolean getPrintSingletons() {
        return PropertiesUtils.getBool(this.properties, "output.printSingletonEntities", false);
    }

    public static String ensurePrerequisiteAnnotators(String[] annotators, Properties props) {
        LinkedHashSet<String> unorderedAnnotators = new LinkedHashSet<String>();
        Collections.addAll(unorderedAnnotators, annotators);
        for (String annotator : annotators) {
            if (!StanfordCoreNLP.getNamedAnnotators().containsKey(annotator.toLowerCase())) {
                throw new IllegalArgumentException("Unknown annotator: " + annotator);
            }
            unorderedAnnotators.add(annotator.toLowerCase());
            if (!Annotator.DEFAULT_REQUIREMENTS.containsKey(annotator.toLowerCase())) {
                throw new IllegalArgumentException("Cannot infer requirements for annotator: " + annotator);
            }
            LinkedList fringe = new LinkedList(Annotator.DEFAULT_REQUIREMENTS.get(annotator.toLowerCase()));
            int ticks = 0;
            while (!fringe.isEmpty()) {
                if (++ticks == 1000000) {
                    throw new IllegalStateException("[INTERNAL ERROR] Annotators have a circular dependency.");
                }
                String prereq = (String)fringe.poll();
                unorderedAnnotators.add(prereq);
                fringe.addAll(Annotator.DEFAULT_REQUIREMENTS.get(prereq.toLowerCase()));
            }
        }
        ArrayList<String> orderedAnnotators = new ArrayList<String>();
        while (!unorderedAnnotators.isEmpty()) {
            boolean somethingAdded = false;
            Iterator iter = unorderedAnnotators.iterator();
            while (iter.hasNext()) {
                String candidate = (String)iter.next();
                boolean canAdd = true;
                for (String prereq : Annotator.DEFAULT_REQUIREMENTS.get(candidate.toLowerCase())) {
                    if (orderedAnnotators.contains(prereq)) continue;
                    canAdd = false;
                    break;
                }
                if (!canAdd) continue;
                orderedAnnotators.add(candidate);
                iter.remove();
                somethingAdded = true;
            }
            if (somethingAdded) continue;
            throw new IllegalArgumentException("Unsatisfiable annotator list: " + StringUtils.join(annotators, ","));
        }
        if (orderedAnnotators.contains("parse") && !ArrayUtils.contains(annotators, "depparse")) {
            orderedAnnotators.remove("depparse");
        }
        if (orderedAnnotators.contains("mention") && !orderedAnnotators.contains("parse") && !props.containsKey("coref.md.type")) {
            props.setProperty("coref.md.type", "dep");
        }
        if (orderedAnnotators.contains("ner") && orderedAnnotators.contains("regexner")) {
            orderedAnnotators.remove("regexner");
            int nerIndex = orderedAnnotators.indexOf("ner");
            orderedAnnotators.add(nerIndex + 1, "regexner");
        }
        if (orderedAnnotators.contains("coref") && orderedAnnotators.contains("openie")) {
            int maxIndex = Math.max(orderedAnnotators.indexOf("openie"), orderedAnnotators.indexOf("coref"));
            if (Objects.equals(orderedAnnotators.get(maxIndex), "openie")) {
                orderedAnnotators.add(maxIndex, "coref");
                orderedAnnotators.remove("coref");
            } else {
                orderedAnnotators.add(maxIndex + 1, "openie");
                orderedAnnotators.remove("openie");
            }
        }
        return StringUtils.join(orderedAnnotators, ",");
    }

    private static boolean isXMLOutputPresent() {
        try {
            Class.forName("edu.stanford.nlp.pipeline.XMLOutputter");
        }
        catch (ClassNotFoundException | NoClassDefFoundError ex) {
            return false;
        }
        return true;
    }

    private void construct(Properties props, boolean enforceRequirements, AnnotatorImplementations annotatorImplementations, AnnotatorPool pool) {
        Timing tim = new Timing();
        this.numWords = 0;
        this.constituentTreePrinter = new TreePrint("penn");
        this.dependencyTreePrinter = new TreePrint("typedDependenciesCollapsed");
        if (props == null) {
            props = StanfordCoreNLP.loadPropertiesFromClasspath();
        } else if (props.getProperty("annotators") == null) {
            Properties fromClassPath = StanfordCoreNLP.loadPropertiesFromClasspath();
            fromClassPath.putAll((Map<?, ?>)props);
            props = fromClassPath;
        }
        this.properties = props;
        if (pool == null) {
            pool = StanfordCoreNLP.getDefaultAnnotatorPool(props, annotatorImplementations);
        }
        if (this.properties.containsKey("threads")) {
            ArgumentParser.threads = PropertiesUtils.getInt(this.properties, "threads");
            this.availableProcessors = new Semaphore(ArgumentParser.threads);
        } else {
            this.availableProcessors = new Semaphore(1);
        }
        List<String> annoNames = Arrays.asList(StanfordCoreNLP.getRequiredProperty(props, "annotators").split("[, \t]+"));
        Set<String> alreadyAddedAnnoNames = Generics.newHashSet();
        Set<Class<? extends CoreAnnotation>> requirementsSatisfied = Generics.newHashSet();
        for (String name : annoNames) {
            if ((name = name.trim()).isEmpty()) continue;
            logger.info("Adding annotator " + name);
            Annotator an = pool.get(name);
            this.addAnnotator(an);
            if (enforceRequirements) {
                Set<Class<? extends CoreAnnotation>> allRequirements = an.requires();
                for (Class<? extends CoreAnnotation> requirement : allRequirements) {
                    if (requirementsSatisfied.contains(requirement)) continue;
                    String fmt = "annotator \"%s\" requires annotation \"%s\". The usual requirements for this annotator are: %s";
                    throw new IllegalArgumentException(String.format(fmt, name, requirement.getSimpleName(), StringUtils.join((Iterable)Annotator.DEFAULT_REQUIREMENTS.getOrDefault(name, Collections.singleton("unknown")), ",")));
                }
                requirementsSatisfied.addAll(an.requirementsSatisfied());
            }
            alreadyAddedAnnoNames.add(name);
        }
        if (!alreadyAddedAnnoNames.contains("ssplit")) {
            System.setProperty(NEWLINE_SPLITTER_PROPERTY, "false");
        }
        this.pipelineSetupTime = tim.report();
    }

    public static synchronized void clearAnnotatorPool() {
        logger.warn("Clearing CoreNLP annotation pool; this should be unnecessary in production");
        AnnotatorPool.SINGLETON.clear();
    }

    private static Map<String, BiFunction<Properties, AnnotatorImplementations, Annotator>> getNamedAnnotators() {
        HashMap<String, BiFunction<Properties, AnnotatorImplementations, Annotator>> pool = new HashMap<String, BiFunction<Properties, AnnotatorImplementations, Annotator>>();
        pool.put("tokenize", (props, impl) -> impl.tokenizer((Properties)props));
        pool.put("cleanxml", (props, impl) -> impl.cleanXML((Properties)props));
        pool.put("ssplit", (props, impl) -> impl.wordToSentences((Properties)props));
        pool.put("pos", (props, impl) -> impl.posTagger((Properties)props));
        pool.put("lemma", (props, impl) -> impl.morpha((Properties)props, false));
        pool.put("ner", (props, impl) -> impl.ner((Properties)props));
        pool.put("tokensregex", (props, impl) -> impl.tokensregex((Properties)props, "tokensregex"));
        pool.put("regexner", (props, impl) -> impl.tokensRegexNER((Properties)props, "regexner"));
        pool.put("entitymentions", (props, impl) -> impl.entityMentions((Properties)props, "entitymentions"));
        pool.put("gender", (props, impl) -> impl.gender((Properties)props, false));
        pool.put("truecase", (props, impl) -> impl.trueCase((Properties)props));
        pool.put("parse", (props, impl) -> impl.parse((Properties)props));
        pool.put("mention", (props, impl) -> impl.mention((Properties)props));
        pool.put("dcoref", (props, impl) -> impl.dcoref((Properties)props));
        pool.put("coref", (props, impl) -> impl.coref((Properties)props));
        pool.put("relation", (props, impl) -> impl.relations((Properties)props));
        pool.put("sentiment", (props, impl) -> impl.sentiment((Properties)props, "sentiment"));
        pool.put("cdc", (props, impl) -> impl.columnData((Properties)props));
        pool.put("depparse", (props, impl) -> impl.dependencies((Properties)props));
        pool.put("natlog", (props, impl) -> impl.natlog((Properties)props));
        pool.put("openie", (props, impl) -> impl.openie((Properties)props));
        pool.put("quote", (props, impl) -> impl.quote((Properties)props));
        pool.put("quoteattribution", (props, impl) -> impl.quoteattribution((Properties)props));
        pool.put("udfeats", (props, impl) -> impl.udfeats((Properties)props));
        pool.put("entitylink", (props, impl) -> impl.link((Properties)props));
        pool.put("kbp", (props, impl) -> impl.kbp((Properties)props));
        return pool;
    }

    public static synchronized AnnotatorPool getDefaultAnnotatorPool(Properties inputProps, AnnotatorImplementations annotatorImplementation) {
        AnnotatorPool pool = AnnotatorPool.SINGLETON;
        for (Map.Entry<String, BiFunction<Properties, AnnotatorImplementations, Annotator>> entry : StanfordCoreNLP.getNamedAnnotators().entrySet()) {
            pool.register(entry.getKey(), inputProps, Lazy.cache(() -> (Annotator)((BiFunction)entry.getValue()).apply(inputProps, annotatorImplementation)));
        }
        StanfordCoreNLP.registerCustomAnnotators(pool, annotatorImplementation, inputProps);
        return pool;
    }

    private static void registerCustomAnnotators(AnnotatorPool pool, AnnotatorImplementations annotatorImplementation, Properties inputProps) {
        for (String property : inputProps.stringPropertyNames()) {
            if (!property.startsWith(CUSTOM_ANNOTATOR_PREFIX)) continue;
            String customName = property.substring(CUSTOM_ANNOTATOR_PREFIX.length());
            String customClassName = inputProps.getProperty(property);
            logger.info("Registering annotator " + customName + " with class " + customClassName);
            pool.register(customName, inputProps, Lazy.cache(() -> annotatorImplementation.custom(inputProps, property)));
        }
    }

    public static AnnotatorPool constructAnnotatorPool(Properties inputProps, AnnotatorImplementations annotatorImplementation) {
        AnnotatorPool pool = AnnotatorPool.SINGLETON;
        for (Map.Entry<String, BiFunction<Properties, AnnotatorImplementations, Annotator>> entry : StanfordCoreNLP.getNamedAnnotators().entrySet()) {
            pool.register(entry.getKey(), inputProps, Lazy.cache(() -> (Annotator)((BiFunction)entry.getValue()).apply(inputProps, annotatorImplementation)));
        }
        StanfordCoreNLP.registerCustomAnnotators(pool, annotatorImplementation, inputProps);
        return pool;
    }

    public static synchronized Annotator getExistingAnnotator(String name) {
        if (AnnotatorPool.SINGLETON == null) {
            logger.error("Attempted to fetch annotator \"" + name + "\" before the annotator pool was created!");
            return null;
        }
        try {
            return AnnotatorPool.SINGLETON.get(name);
        }
        catch (IllegalArgumentException e) {
            logger.error("Attempted to fetch annotator \"" + name + "\" but the annotator pool does not store any such type!");
            return null;
        }
    }

    @Override
    public void annotate(Annotation annotation) {
        super.annotate(annotation);
        List words = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
        if (words != null) {
            this.numWords += words.size();
        }
    }

    public void annotate(Annotation annotation, Consumer<Annotation> callback) {
        if (PropertiesUtils.getInt(this.properties, "threads", 1) == 1) {
            this.annotate(annotation);
            callback.accept(annotation);
        } else {
            try {
                this.availableProcessors.acquire();
            }
            catch (InterruptedException e) {
                throw new RuntimeInterruptedException(e);
            }
            new Thread(() -> {
                try {
                    this.annotate(annotation);
                }
                catch (Throwable t) {
                    annotation.set(CoreAnnotations.ExceptionAnnotation.class, t);
                }
                callback.accept(annotation);
                this.availableProcessors.release();
            }).start();
        }
    }

    public static boolean usesBinaryTrees(Properties props) {
        Set<String> annoNames = Generics.newHashSet(Arrays.asList(props.getProperty("annotators", "").split("[, \t]+")));
        return annoNames.contains("sentiment");
    }

    public Annotation process(String text) {
        Annotation annotation = new Annotation(text);
        this.annotate(annotation);
        return annotation;
    }

    public void prettyPrint(Annotation annotation, OutputStream os) {
        TextOutputter.prettyPrint(annotation, os, this);
    }

    public void prettyPrint(Annotation annotation, PrintWriter os) {
        TextOutputter.prettyPrint(annotation, os, this);
    }

    public void xmlPrint(Annotation annotation, Writer w) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.xmlPrint(annotation, os);
        w.write(new String(os.toByteArray(), this.getEncoding()));
        w.flush();
    }

    public void jsonPrint(Annotation annotation, Writer w) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        JSONOutputter.jsonPrint(annotation, (OutputStream)os, this);
        w.write(new String(os.toByteArray(), this.getEncoding()));
        w.flush();
    }

    public void conllPrint(Annotation annotation, Writer w) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        CoNLLOutputter.conllPrint(annotation, (OutputStream)os, this);
        w.write(new String(os.toByteArray(), this.getEncoding()));
        w.flush();
    }

    public void xmlPrint(Annotation annotation, OutputStream os) throws IOException {
        try {
            Class<?> clazz = Class.forName("edu.stanford.nlp.pipeline.XMLOutputter");
            Method method = clazz.getMethod("xmlPrint", Annotation.class, OutputStream.class, StanfordCoreNLP.class);
            method.invoke(null, annotation, os, this);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void printHelp(PrintStream os, String helpTopic) {
        if (helpTopic.toLowerCase().startsWith("pars")) {
            os.println("StanfordCoreNLP currently supports the following parsers:");
            os.println("\tstanford - Stanford lexicalized parser (default)");
            os.println("\tcharniak - Charniak and Johnson reranking parser (sold separately)");
            os.println();
            os.println("General options: (all parsers)");
            os.println("\tparse.type - selects the parser to use");
            os.println("\tparse.model - path to model file for parser");
            os.println("\tparse.maxlen - maximum sentence length");
            os.println();
            os.println("Stanford Parser-specific options:");
            os.println("(In general, you shouldn't need to set this flags)");
            os.println("\tparse.flags - extra flags to the parser (default: -retainTmpSubcategories)");
            os.println("\tparse.debug - set to true to make the parser slightly more verbose");
            os.println();
            os.println("Charniak and Johnson parser-specific options:");
            os.println("\tparse.executable - path to the parseIt binary or parse.sh script");
        } else if (!helpTopic.equalsIgnoreCase("true")) {
            os.println("Unknown help topic: " + helpTopic);
            os.println("See -help for a list of all help topics.");
        } else {
            StanfordCoreNLP.printRequiredProperties(os);
        }
    }

    private static void printRequiredProperties(PrintStream os) {
        os.println("The following properties can be defined:");
        os.println("(if -props or -annotators is not passed in, default properties will be loaded via the classpath)");
        os.println("\t\"props\" - path to file with configuration properties");
        os.println("\t\"annotators\" - comma separated list of annotators");
        os.println("\tThe following annotators are supported: cleanxml, tokenize, quote, ssplit, pos, lemma, ner, truecase, parse, hcoref, relation");
        os.println();
        os.println("\tIf annotator \"tokenize\" is defined:");
        os.println("\t\"tokenize.options\" - PTBTokenizer options (see edu.stanford.nlp.process.PTBTokenizer for details)");
        os.println("\t\"tokenize.whitespace\" - If true, just use whitespace tokenization");
        os.println();
        os.println("\tIf annotator \"cleanxml\" is defined:");
        os.println("\t\"clean.xmltags\" - regex of tags to extract text from");
        os.println("\t\"clean.sentenceendingtags\" - regex of tags which mark sentence endings");
        os.println("\t\"clean.allowflawedxml\" - if set to true, don't complain about XML errors");
        os.println();
        os.println("\tIf annotator \"pos\" is defined:");
        os.println("\t\"pos.maxlen\" - maximum length of sentence to POS tag");
        os.println("\t\"pos.model\" - path towards the POS tagger model");
        os.println();
        os.println("\tIf annotator \"ner\" is defined:");
        os.println("\t\"ner.model\" - paths for the ner models.  By default, the English 3 class, 7 class, and 4 class models are used.");
        os.println("\t\"ner.useSUTime\" - Whether or not to use sutime (English specific)");
        os.println("\t\"ner.applyNumericClassifiers\" - whether or not to use any numeric classifiers (English specific)");
        os.println();
        os.println("\tIf annotator \"truecase\" is defined:");
        os.println("\t\"truecase.model\" - path towards the true-casing model; default: edu/stanford/nlp/models/truecase/truecasing.fast.caseless.qn.ser.gz");
        os.println("\t\"truecase.bias\" - class bias of the true case model; default: INIT_UPPER:-0.7,UPPER:-0.7,O:0");
        os.println("\t\"truecase.mixedcasefile\" - path towards the mixed case file; default: edu/stanford/nlp/models/truecase/MixDisambiguation.list");
        os.println();
        os.println("\tIf annotator \"relation\" is defined:");
        os.println("\t\"sup.relation.verbose\" - whether verbose or not");
        os.println("\t\"sup.relation.model\" - path towards the relation extraction model");
        os.println();
        os.println("\tIf annotator \"parse\" is defined:");
        os.println("\t\"parse.model\" - path towards the PCFG parser model");
        os.println();
        os.println("Command line properties:");
        os.println("\t\"file\" - run the pipeline on the content of this file, or on the content of the files in this directory");
        os.println("\t         XML output is generated for every input file \"file\" as file.xml");
        os.println("\t\"extension\" - if -file used with a directory, process only the files with this extension");
        os.println("\t\"filelist\" - run the pipeline on the list of files given in this file");
        os.println("\t             output is generated for every input file as file.outputExtension");
        os.println("\t\"outputDirectory\" - where to put output (defaults to the current directory)");
        os.println("\t\"outputExtension\" - extension to use for the output file (defaults to \".xml\" for XML, \".ser.gz\" for serialized).  Don't forget the dot!");
        os.println("\t\"outputFormat\" - \"xml\" (usual default), \"text\" (default for REPL or if no XML), \"json\", \"conll\", \"conllu\", \"serialized\", or \"custom\"");
        os.println("\t\"customOutputter\" - specify a class to a custom outputter instead of a pre-defined output format");
        os.println("\t\"serializer\" - Class of annotation serializer to use when outputFormat is \"serialized\".  By default, uses Java serialization.");
        os.println("\t\"replaceExtension\" - flag to chop off the last extension before adding outputExtension to file");
        os.println("\t\"noClobber\" - don't automatically override (clobber) output files that already exist");
        os.println("\t\"threads\" - multithread on this number of threads");
        os.println();
        os.println("If none of the above are present, run the pipeline in an interactive shell (default properties will be loaded from the classpath).");
        os.println("The shell accepts input from stdin and displays the output at stdout.");
        os.println();
        os.println("Run with -help [topic] for more help on a specific topic.");
        os.println("Current topics include: parser");
        os.println();
    }

    @Override
    public String timingInformation() {
        StringBuilder sb = new StringBuilder(super.timingInformation());
        if (this.numWords >= 0) {
            long total = this.getTotalTime();
            sb.append(" for ").append(this.numWords).append(" tokens at ");
            sb.append(String.format("%.1f", (double)this.numWords / ((double)total / 1000.0)));
            sb.append(" tokens/sec.");
        }
        return sb.toString();
    }

    private static void shell(StanfordCoreNLP pipeline) throws IOException {
        block9: {
            String encoding = pipeline.getEncoding();
            BufferedReader r = new BufferedReader(IOUtils.encodedInputStreamReader(System.in, encoding));
            System.err.println("Entering interactive shell. Type q RETURN or EOF to quit.");
            OutputFormat outputFormat = OutputFormat.valueOf(pipeline.properties.getProperty("outputFormat", "text").toUpperCase());
            block8: while (true) {
                System.err.print("NLP> ");
                String line = r.readLine();
                if (line == null || line.equalsIgnoreCase("q")) break block9;
                if (line.length() <= 0) continue;
                Annotation anno = pipeline.process(line);
                switch (outputFormat) {
                    case XML: {
                        pipeline.xmlPrint(anno, System.out);
                        continue block8;
                    }
                    case JSON: {
                        new JSONOutputter().print(anno, (OutputStream)System.out, pipeline);
                        System.out.println();
                        continue block8;
                    }
                    case CONLL: {
                        new CoNLLOutputter().print(anno, (OutputStream)System.out, pipeline);
                        System.out.println();
                        continue block8;
                    }
                    case CONLLU: {
                        new CoNLLUOutputter().print(anno, (OutputStream)System.out, pipeline);
                        continue block8;
                    }
                    case TEXT: {
                        pipeline.prettyPrint(anno, System.out);
                        continue block8;
                    }
                    case CUSTOM: {
                        AnnotationOutputter outputter = (AnnotationOutputter)ReflectionLoading.loadByReflection(pipeline.properties.getProperty("customOutputter"), new Object[0]);
                        outputter.print(anno, (OutputStream)System.out, pipeline);
                        continue block8;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Cannot output in format " + (Object)((Object)outputFormat) + " from the interactive shell");
        }
    }

    protected static Collection<File> readFileList(String fileName) throws IOException {
        return ObjectBank.getLineIterator(fileName, new ObjectBank.PathToFileFunction());
    }

    private static AnnotationSerializer loadSerializer(String serializerClass, String name, Properties properties) {
        AnnotationSerializer serializer;
        try {
            serializer = (AnnotationSerializer)ReflectionLoading.loadByReflection(serializerClass, name, properties);
        }
        catch (ReflectionLoading.ReflectionLoadingException ex) {
            serializer = (AnnotationSerializer)ReflectionLoading.loadByReflection(serializerClass, new Object[0]);
        }
        return serializer;
    }

    public void processFiles(String base, Collection<File> files, int numThreads, boolean clearPool) throws IOException {
        AnnotationOutputter.Options options = AnnotationOutputter.getOptions(this);
        OutputFormat outputFormat = OutputFormat.valueOf(this.properties.getProperty("outputFormat", DEFAULT_OUTPUT_FORMAT).toUpperCase());
        StanfordCoreNLP.processFiles(base, files, numThreads, this.properties, this::annotate, StanfordCoreNLP.createOutputter(this.properties, options), outputFormat, clearPool);
    }

    public static BiConsumer<Annotation, OutputStream> createOutputter(Properties properties, AnnotationOutputter.Options outputOptions) {
        String outputSerializerClass;
        OutputFormat outputFormat = OutputFormat.valueOf(properties.getProperty("outputFormat", DEFAULT_OUTPUT_FORMAT).toUpperCase());
        String serializerClass = properties.getProperty("serializer", GenericAnnotationSerializer.class.getName());
        String outputSerializerName = serializerClass.equals(outputSerializerClass = properties.getProperty("outputSerializer", serializerClass)) ? "serializer" : "outputSerializer";
        return (annotation, fos) -> {
            try {
                switch (outputFormat) {
                    case XML: {
                        AnnotationOutputter outputter = (AnnotationOutputter)MetaClass.create("edu.stanford.nlp.pipeline.XMLOutputter").createInstance(new Object[0]);
                        outputter.print((Annotation)annotation, (OutputStream)fos, outputOptions);
                        break;
                    }
                    case JSON: {
                        new JSONOutputter().print((Annotation)annotation, (OutputStream)fos, outputOptions);
                        break;
                    }
                    case CONLL: {
                        new CoNLLOutputter().print((Annotation)annotation, (OutputStream)fos, outputOptions);
                        break;
                    }
                    case TEXT: {
                        new TextOutputter().print((Annotation)annotation, (OutputStream)fos, outputOptions);
                        break;
                    }
                    case SERIALIZED: {
                        if (outputSerializerClass != null) {
                            AnnotationSerializer outputSerializer = StanfordCoreNLP.loadSerializer(outputSerializerClass, outputSerializerName, properties);
                            outputSerializer.write((Annotation)annotation, (OutputStream)fos);
                        }
                        break;
                    }
                    case CONLLU: {
                        new CoNLLUOutputter().print((Annotation)annotation, (OutputStream)fos, outputOptions);
                        break;
                    }
                    case CUSTOM: {
                        AnnotationOutputter outputter = (AnnotationOutputter)ReflectionLoading.loadByReflection(properties.getProperty("customOutputter"), new Object[0]);
                        outputter.print((Annotation)annotation, (OutputStream)fos, outputOptions);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown output format " + (Object)((Object)outputFormat));
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void processFiles(String base, Collection<File> files, int numThreads, Properties properties, BiConsumer<Annotation, Consumer<Annotation>> annotate, BiConsumer<Annotation, OutputStream> print, OutputFormat outputFormat, boolean clearPool) throws IOException {
        String defaultExtension;
        String inputSerializerClass;
        String serializerClass;
        String baseOutputDir = properties.getProperty("outputDirectory", ".");
        String baseInputDir = properties.getProperty("inputDirectory", base);
        String excludeFilesParam = properties.getProperty("excludeFiles");
        HashSet<String> excludeFiles = new HashSet<String>();
        if (excludeFilesParam != null) {
            Iterable<String> lines = IOUtils.readLines(excludeFilesParam);
            for (String line : lines) {
                String name = line.trim();
                if (name.isEmpty()) continue;
                excludeFiles.add(name);
            }
        }
        String inputSerializerName = (serializerClass = properties.getProperty("serializer", GenericAnnotationSerializer.class.getName())).equals(inputSerializerClass = properties.getProperty("inputSerializer", serializerClass)) ? "serializer" : "inputSerializer";
        switch (outputFormat) {
            case XML: {
                defaultExtension = ".xml";
                break;
            }
            case JSON: {
                defaultExtension = ".json";
                break;
            }
            case CONLL: {
                defaultExtension = ".conll";
                break;
            }
            case CONLLU: {
                defaultExtension = ".conllu";
                break;
            }
            case TEXT: {
                defaultExtension = ".out";
                break;
            }
            case SERIALIZED: {
                defaultExtension = ".ser.gz";
                break;
            }
            case CUSTOM: {
                defaultExtension = ".out";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown output format " + (Object)((Object)outputFormat));
            }
        }
        String extension = properties.getProperty("outputExtension", defaultExtension);
        boolean replaceExtension = Boolean.parseBoolean(properties.getProperty("replaceExtension", "false"));
        boolean continueOnAnnotateError = Boolean.parseBoolean(properties.getProperty("continueOnAnnotateError", "false"));
        boolean noClobber = Boolean.parseBoolean(properties.getProperty("noClobber", "false"));
        MutableInteger totalProcessed = new MutableInteger(0);
        MutableInteger totalSkipped = new MutableInteger(0);
        MutableInteger totalErrorAnnotating = new MutableInteger(0);
        for (File file : files) {
            int lastDot;
            if (excludeFiles.contains(file.getName())) {
                logger.err("Skipping excluded file " + file.getName());
                totalSkipped.incValue(1);
                continue;
            }
            String outputDir = baseOutputDir;
            if (baseInputDir != null) {
                String relDir = file.getParent().replaceFirst(Pattern.quote(baseInputDir), "");
                outputDir = outputDir + File.separator + relDir;
            }
            new File(outputDir).mkdirs();
            String outputFilename = new File(outputDir, file.getName()).getPath();
            if (replaceExtension && (lastDot = outputFilename.lastIndexOf(46)) > 0) {
                outputFilename = outputFilename.substring(0, lastDot);
            }
            if (!outputFilename.endsWith(extension)) {
                outputFilename = outputFilename + extension;
            }
            if ((outputFilename = new File(outputFilename).getCanonicalPath()).equals(file.getCanonicalPath())) {
                logger.err("Skipping " + file.getName() + ": output file " + outputFilename + " has the same filename as the input file -- assuming you don't actually want to do this.");
                totalSkipped.incValue(1);
                continue;
            }
            if (noClobber && new File(outputFilename).exists()) {
                logger.err("Skipping " + file.getName() + ": output file " + outputFilename + " as it already exists.  Don't use the noClobber option to override this.");
                totalSkipped.incValue(1);
                continue;
            }
            String finalOutputFilename = outputFilename;
            try {
                if (noClobber && new File(finalOutputFilename).exists()) {
                    logger.err("Skipping " + file.getName() + ": output file " + finalOutputFilename + " as it already exists.  Don't use the noClobber option to override this.");
                    MutableInteger mutableInteger = totalSkipped;
                    synchronized (mutableInteger) {
                        totalSkipped.incValue(1);
                    }
                    return;
                }
                logger.info("Processing file " + file.getAbsolutePath() + " ... writing to " + finalOutputFilename);
                Annotation annotation = null;
                if (file.getAbsolutePath().endsWith(".ser.gz")) {
                    try {
                        if (inputSerializerClass != null) {
                            AnnotationSerializer inputSerializer = StanfordCoreNLP.loadSerializer(inputSerializerClass, inputSerializerName, properties);
                            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                            Pair<Annotation, InputStream> pair = inputSerializer.read(is);
                            ((InputStream)pair.second).close();
                            annotation = (Annotation)pair.first;
                            IOUtils.closeIgnoringExceptions(is);
                        } else {
                            annotation = (Annotation)IOUtils.readObjectFromFile(file);
                        }
                    }
                    catch (IOException inputSerializer) {
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (annotation == null) {
                    String encoding = properties.getProperty("encoding", "UTF-8");
                    String text = IOUtils.slurpFile(file.getAbsoluteFile(), encoding);
                    annotation = new Annotation(text);
                }
                Timing timing = new Timing();
                annotate.accept(annotation, finishedAnnotation -> {
                    timing.done(logger, "Annotating file " + file.getAbsoluteFile());
                    Throwable ex = (Throwable)finishedAnnotation.get(CoreAnnotations.ExceptionAnnotation.class);
                    if (ex == null) {
                        try {
                            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(finalOutputFilename));
                            print.accept((Annotation)finishedAnnotation, fos);
                            ((OutputStream)fos).close();
                        }
                        catch (IOException e) {
                            throw new RuntimeIOException(e);
                        }
                        MutableInteger mutableInteger = totalProcessed;
                        synchronized (mutableInteger) {
                            totalProcessed.incValue(1);
                            if (totalProcessed.intValue() % 1000 == 0) {
                                logger.info("Processed " + totalProcessed + " documents");
                            }
                            if (totalProcessed.intValue() + totalErrorAnnotating.intValue() == files.size() && clearPool) {
                                AnnotatorPool.SINGLETON.clear();
                            }
                        }
                    }
                    if (continueOnAnnotateError) {
                        logger.err("Error annotating " + file.getAbsoluteFile() + ": " + ex);
                        MutableInteger mutableInteger = totalErrorAnnotating;
                        synchronized (mutableInteger) {
                            totalErrorAnnotating.incValue(1);
                            if (totalProcessed.intValue() + totalErrorAnnotating.intValue() == files.size() && clearPool) {
                                AnnotatorPool.SINGLETON.clear();
                            }
                        }
                    } else {
                        if (clearPool) {
                            AnnotatorPool.SINGLETON.clear();
                        }
                        throw new RuntimeException("Error annotating " + file.getAbsoluteFile(), ex);
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
    }

    public void processFiles(Collection<File> files, int numThreads, boolean clearPool) throws IOException {
        this.processFiles(null, files, numThreads, clearPool);
    }

    public void processFiles(Collection<File> files, boolean clearPool) throws IOException {
        this.processFiles(files, 1, clearPool);
    }

    public void run() throws IOException {
        this.run(false);
    }

    public void run(boolean clearPool) throws IOException {
        Timing tim = new Timing();
        StanfordRedwoodConfiguration.minimalSetup();
        String numThreadsString = this.properties == null ? null : this.properties.getProperty("threads");
        int numThreads = 1;
        try {
            if (numThreadsString != null) {
                numThreads = Integer.parseInt(numThreadsString);
            }
        }
        catch (NumberFormatException e) {
            logger.err("-threads [number]: was not given a valid number: " + numThreadsString);
        }
        logger.info("");
        if (this.properties.containsKey("file") || this.properties.containsKey("textFile")) {
            String fileName = this.properties.getProperty("file");
            if (fileName == null) {
                fileName = this.properties.getProperty("textFile");
            }
            FileSequentialCollection files = new FileSequentialCollection(new File(fileName), this.properties.getProperty("extension"), true);
            this.processFiles(null, files, numThreads, clearPool);
        } else if (this.properties.containsKey("filelist")) {
            String fileName = this.properties.getProperty("filelist");
            Collection<File> inputFiles = StanfordCoreNLP.readFileList(fileName);
            ArrayList<File> files = new ArrayList<File>(inputFiles.size());
            for (File file : inputFiles) {
                if (file.isDirectory()) {
                    files.addAll(new FileSequentialCollection(new File(fileName), this.properties.getProperty("extension"), true));
                    continue;
                }
                files.add(file);
            }
            this.processFiles(null, files, numThreads, clearPool);
        } else {
            StanfordCoreNLP.shell(this);
        }
        logger.info("");
        logger.info(this.timingInformation());
        logger.info("Pipeline setup: " + Timing.toSecondsString(this.pipelineSetupTime) + " sec.");
        logger.info("Total time for StanfordCoreNLP pipeline: " + Timing.toSecondsString(this.pipelineSetupTime + tim.report()) + " sec.");
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        Properties props = new Properties();
        if (args.length > 0) {
            props = StringUtils.argsToProperties(args);
            boolean hasH = props.containsKey("h");
            boolean hasHelp = props.containsKey("help");
            if (hasH || hasHelp) {
                String helpValue = hasH ? props.getProperty("h") : props.getProperty("help");
                StanfordCoreNLP.printHelp(System.err, helpValue);
                return;
            }
        }
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        pipeline.run(true);
        if (!props.containsKey("threads") || Integer.parseInt(props.getProperty("threads")) <= 1) {
            AnnotatorPool.SINGLETON.clear();
        }
    }

    public static enum OutputFormat {
        TEXT,
        XML,
        JSON,
        CONLL,
        CONLLU,
        SERIALIZED,
        CUSTOM;

    }
}

