/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.crf.CRFBiasedClassifier;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class TrueCaseAnnotator
implements Annotator {
    private static final Redwood.RedwoodChannels log = Redwood.channels(TrueCaseAnnotator.class);
    private final CRFBiasedClassifier<CoreLabel> trueCaser;
    private final Map<String, String> mixedCaseMap;
    private final boolean overwriteText;
    private final boolean verbose;
    public static final String DEFAULT_MODEL_BIAS = "INIT_UPPER:-0.7,UPPER:-0.7,O:0";
    private static final String DEFAULT_OVERWRITE_TEXT = "false";
    private static final String DEFAULT_VERBOSE = "false";

    public TrueCaseAnnotator() {
        this(true);
    }

    public TrueCaseAnnotator(boolean verbose) {
        this(System.getProperty("truecase.model", "edu/stanford/nlp/models/truecase/truecasing.fast.caseless.qn.ser.gz"), System.getProperty("truecase.bias", DEFAULT_MODEL_BIAS), System.getProperty("truecase.mixedcasefile", "edu/stanford/nlp/models/truecase/MixDisambiguation.list"), Boolean.parseBoolean(System.getProperty("truecase.overwriteText", "false")), verbose);
    }

    public TrueCaseAnnotator(Properties properties) {
        this(properties.getProperty("truecase.model", "edu/stanford/nlp/models/truecase/truecasing.fast.caseless.qn.ser.gz"), properties.getProperty("truecase.bias", DEFAULT_MODEL_BIAS), properties.getProperty("truecase.mixedcasefile", "edu/stanford/nlp/models/truecase/MixDisambiguation.list"), Boolean.parseBoolean(properties.getProperty("truecase.overwriteText", "false")), Boolean.parseBoolean(properties.getProperty("truecase.verbose", "false")));
    }

    public TrueCaseAnnotator(String modelLoc, String classBias, String mixedCaseFileName, boolean overwriteText, boolean verbose) {
        this.overwriteText = overwriteText;
        this.verbose = verbose;
        Properties props = PropertiesUtils.asProperties("loadClassifier", modelLoc, "mixedCaseMapFile", mixedCaseFileName, "classBias", classBias);
        this.trueCaser = new CRFBiasedClassifier(props);
        if (modelLoc == null) {
            throw new RuntimeException("Model location not specified for true-case classifier!");
        }
        this.trueCaser.loadClassifierNoExceptions(modelLoc, props);
        if (classBias != null) {
            StringTokenizer biases = new StringTokenizer(classBias, ",");
            while (biases.hasMoreTokens()) {
                StringTokenizer bias = new StringTokenizer(biases.nextToken(), ":");
                String cname = bias.nextToken();
                double w = Double.parseDouble(bias.nextToken());
                this.trueCaser.setBiasWeight(cname, w);
                if (!this.verbose) continue;
                log.info("Setting bias for class " + cname + " to " + w);
            }
        }
        this.mixedCaseMap = TrueCaseAnnotator.loadMixedCaseMap(mixedCaseFileName);
    }

    @Override
    public void annotate(Annotation annotation) {
        if (this.verbose) {
            log.info("Adding true-case annotation...");
        }
        if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                List output = this.trueCaser.classifySentence(tokens);
                int size = tokens.size();
                for (int i = 0; i < size; ++i) {
                    String neTag = (String)((CoreLabel)output.get(i)).get(CoreAnnotations.AnswerAnnotation.class);
                    ((CoreLabel)tokens.get(i)).set(CoreAnnotations.TrueCaseAnnotation.class, neTag);
                    this.setTrueCaseText((CoreLabel)tokens.get(i));
                }
            }
        } else {
            throw new RuntimeException("unable to find sentences in: " + annotation);
        }
    }

    private void setTrueCaseText(CoreLabel l) {
        String text;
        String trueCase = l.getString(CoreAnnotations.TrueCaseAnnotation.class);
        String trueCaseText = text = l.word();
        switch (trueCase) {
            case "UPPER": {
                trueCaseText = text.toUpperCase();
                break;
            }
            case "LOWER": {
                trueCaseText = text.toLowerCase();
                break;
            }
            case "INIT_UPPER": {
                trueCaseText = Character.toTitleCase(text.charAt(0)) + text.substring(1).toLowerCase();
                break;
            }
            case "O": {
                String lower = text.toLowerCase();
                if (!this.mixedCaseMap.containsKey(lower)) break;
                trueCaseText = this.mixedCaseMap.get(lower);
            }
        }
        l.set(CoreAnnotations.TrueCaseTextAnnotation.class, trueCaseText);
        if (this.overwriteText) {
            l.set(CoreAnnotations.TextAnnotation.class, trueCaseText);
            l.set(CoreAnnotations.ValueAnnotation.class, trueCaseText);
        }
    }

    private static Map<String, String> loadMixedCaseMap(String mapFile) {
        Map<String, String> map = Generics.newHashMap();
        try {
            BufferedReader br = IOUtils.readerFromString(mapFile);
            for (String line : ObjectBank.getLineIterator(br)) {
                String[] els = (line = line.trim()).split("\\s+");
                if (els.length != 2) {
                    throw new RuntimeException("Wrong format: " + mapFile);
                }
                map.put(els[0], els[1]);
            }
            br.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return map;
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.PositionAnnotation.class, CoreAnnotations.SentencesAnnotation.class)));
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CoreAnnotations.TrueCaseTextAnnotation.class, CoreAnnotations.TrueCaseAnnotation.class, CoreAnnotations.AnswerAnnotation.class, CoreAnnotations.ShapeAnnotation.class)));
    }
}

