/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.SentenceAnnotator;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.ud.UniversalDependenciesFeatureAnnotator;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

public class UDFeatureAnnotator
extends SentenceAnnotator {
    private UniversalDependenciesFeatureAnnotator featureAnnotator;

    public UDFeatureAnnotator() {
        try {
            this.featureAnnotator = new UniversalDependenciesFeatureAnnotator();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected int nThreads() {
        return 1;
    }

    @Override
    protected long maxTime() {
        return 0L;
    }

    @Override
    protected void doOneSentence(Annotation annotation, CoreMap sentence) {
        SemanticGraph sg = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
        Tree t = (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class);
        this.featureAnnotator.addFeatures(sg, t, false, true);
    }

    @Override
    protected void doOneFailedSentence(Annotation annotation, CoreMap sentence) {
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.singleton(CoreAnnotations.CoNLLUFeats.class);
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class)));
    }
}

