/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.POSTaggerAnnotator;
import edu.stanford.nlp.pipeline.TokenizerAnnotator;
import edu.stanford.nlp.pipeline.WordsToSentencesAnnotator;
import edu.stanford.nlp.time.SUTime;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.TimeAnnotator;
import edu.stanford.nlp.time.TimeExpression;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import java.util.List;
import java.util.Map;

public class SUTimeSimpleParser {
    private static AnnotationPipeline pipeline;
    private static Map<String, SUTime.Temporal> cache;
    public static int calls;
    public static int misses;

    private SUTimeSimpleParser() {
    }

    private static AnnotationPipeline makeNumericPipeline() {
        AnnotationPipeline pipeline = new AnnotationPipeline();
        pipeline.addAnnotator(new TokenizerAnnotator(false, "en"));
        pipeline.addAnnotator(new WordsToSentencesAnnotator(false));
        pipeline.addAnnotator(new POSTaggerAnnotator(false));
        pipeline.addAnnotator(new TimeAnnotator(true));
        return pipeline;
    }

    public static SUTime.Temporal parseOrNull(String str) {
        Annotation doc = new Annotation(str);
        pipeline.annotate(doc);
        if (doc.get(CoreAnnotations.SentencesAnnotation.class) == null) {
            return null;
        }
        if (((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).size() == 0) {
            return null;
        }
        List timexAnnotations = (List)doc.get(TimeAnnotations.TimexAnnotations.class);
        if (timexAnnotations.size() > 1) {
            return null;
        }
        if (timexAnnotations.size() == 0) {
            return null;
        }
        CoreMap timex = (CoreMap)timexAnnotations.get(0);
        if (timex.get(TimeExpression.Annotation.class) == null) {
            return null;
        }
        return ((TimeExpression)timex.get(TimeExpression.Annotation.class)).getTemporal();
    }

    public static SUTime.Temporal parse(String str) throws SUTimeParsingError {
        try {
            Annotation doc = new Annotation(str);
            pipeline.annotate(doc);
            assert (doc.get(CoreAnnotations.SentencesAnnotation.class) != null);
            assert (((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).size() > 0);
            List timexAnnotations = (List)doc.get(TimeAnnotations.TimexAnnotations.class);
            if (timexAnnotations.size() > 1) {
                throw new RuntimeException("Too many timexes for '" + str + "'");
            }
            CoreMap timex = (CoreMap)timexAnnotations.get(0);
            return ((TimeExpression)timex.get(TimeExpression.Annotation.class)).getTemporal();
        }
        catch (Exception e) {
            SUTimeParsingError parsingError = new SUTimeParsingError(str);
            parsingError.initCause(e);
            throw parsingError;
        }
    }

    public static SUTime.Temporal parseUsingCache(String str) throws SUTimeParsingError {
        ++calls;
        if (!cache.containsKey(str)) {
            ++misses;
            cache.put(str, SUTimeSimpleParser.parse(str));
        }
        return cache.get(str);
    }

    public static void main(String[] args) throws SUTimeParsingError {
        for (String s : new String[]{"1972", "1972-07-05", "0712", "1972-04"}) {
            System.out.println("String: " + s);
            SUTime.Temporal timeExpression = SUTimeSimpleParser.parse(s);
            System.out.println("Parsed: " + timeExpression);
            System.out.println();
        }
    }

    static {
        calls = 0;
        misses = 0;
        pipeline = SUTimeSimpleParser.makeNumericPipeline();
        cache = Generics.newHashMap();
    }

    public static class SUTimeParsingError
    extends Exception {
        private static final long serialVersionUID = 1L;
        public String timeExpression;

        public SUTimeParsingError(String timeExpression) {
            this.timeExpression = timeExpression;
        }

        @Override
        public String getLocalizedMessage() {
            return "Error while parsing '" + this.timeExpression + "'";
        }
    }
}

