/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.gui;

import edu.stanford.nlp.swing.TooltipJList;
import edu.stanford.nlp.trees.Constituent;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.trees.tregex.gui.FilePanel;
import edu.stanford.nlp.trees.tregex.gui.FileTreeNode;
import edu.stanford.nlp.trees.tregex.gui.HighlightUtils;
import edu.stanford.nlp.trees.tregex.gui.Tdiff;
import edu.stanford.nlp.trees.tregex.gui.TreeFromFile;
import edu.stanford.nlp.trees.tregex.gui.TregexGUI;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.Highlighter;

public class MatchesPanel
extends JPanel
implements ListSelectionListener {
    private static MatchesPanel instance = null;
    private JList list;
    private Map<TreeFromFile, List<Tree>> matchedParts;
    private List<MatchesPanelListener> listeners;
    private Color highlightColor = Color.CYAN;
    private boolean showOnlyMatchedPortion = false;
    private JTextField lastSelected = null;
    private MouseEvent firstMouseEvent = null;
    private int maxMatches = 1000;

    public static synchronized MatchesPanel getInstance() {
        if (instance == null) {
            instance = new MatchesPanel();
        }
        return instance;
    }

    private MatchesPanel() {
        DefaultListModel model = new DefaultListModel();
        this.list = new TooltipJList((ListModel)model);
        this.list.setCellRenderer(new MatchCellRenderer());
        this.list.setTransferHandler(new TreeTransferHandler());
        this.matchedParts = Generics.newHashMap();
        this.list.addListSelectionListener(this);
        MouseInputAdapter mouseListener = new MouseInputAdapter(){
            private boolean dragNDrop = false;

            @Override
            public void mousePressed(MouseEvent e) {
                if (MatchesPanel.getInstance().isEmpty()) {
                    return;
                }
                if (MatchesPanel.this.firstMouseEvent == null) {
                    MatchesPanel.this.firstMouseEvent = e;
                }
                e.consume();
                TreeFromFile selectedValue = (TreeFromFile)MatchesPanel.this.list.getSelectedValue();
                if (selectedValue == null) {
                    return;
                }
                JTextField label = selectedValue.getLabel();
                if ((e.getModifiersEx() & 0x40) == 64) {
                    this.addHighlight(label, MatchesPanel.this.firstMouseEvent, e);
                } else if (!HighlightUtils.isInHighlight(e, label, label.getHighlighter())) {
                    label.getHighlighter().removeAllHighlights();
                    MatchesPanel.this.firstMouseEvent = e;
                    this.dragNDrop = false;
                    MatchesPanel.this.list.repaint();
                } else {
                    this.dragNDrop = true;
                }
            }

            private boolean addHighlight(JTextField label, MouseEvent mouseEvent1, MouseEvent mouseEvent2) {
                boolean highlightSuccessful = HighlightUtils.addHighlight(label, mouseEvent1, mouseEvent2);
                FontMetrics fm = label.getFontMetrics(label.getFont());
                int firstXpos = mouseEvent1.getX();
                int lastXpos = mouseEvent2.getX();
                int firstOffset = this.getCharOffset(fm, label.getText(), firstXpos);
                int lastOffset = this.getCharOffset(fm, label.getText(), lastXpos);
                if (lastOffset != firstOffset) {
                    if (firstOffset > lastOffset) {
                        int tmp = firstOffset;
                        firstOffset = lastOffset;
                        lastOffset = tmp;
                    }
                    Rectangle curVisible = MatchesPanel.this.list.getVisibleRect();
                    if (lastXpos > curVisible.x + curVisible.width) {
                        MatchesPanel.this.list.scrollRectToVisible(new Rectangle(new Point(lastXpos - curVisible.width, curVisible.y), curVisible.getSize()));
                    } else if (lastXpos < curVisible.x) {
                        MatchesPanel.this.list.scrollRectToVisible(new Rectangle(new Point(lastXpos, curVisible.y), curVisible.getSize()));
                    }
                    MatchesPanel.this.list.repaint();
                    return highlightSuccessful;
                }
                return false;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (MatchesPanel.getInstance().isEmpty()) {
                    return;
                }
                if (MatchesPanel.this.firstMouseEvent != null) {
                    e.consume();
                    JTextField label = ((TreeFromFile)MatchesPanel.this.list.getSelectedValue()).getLabel();
                    if (this.dragNDrop) {
                        if (label == null) {
                            return;
                        }
                        if (Point2D.distanceSq(e.getX(), e.getY(), MatchesPanel.this.firstMouseEvent.getX(), MatchesPanel.this.firstMouseEvent.getY()) > 25.0) {
                            MatchesPanel.this.list.getTransferHandler().exportAsDrag((JComponent)e.getSource(), MatchesPanel.this.firstMouseEvent, 1);
                        }
                    } else {
                        this.addHighlight(label, MatchesPanel.this.firstMouseEvent, e);
                    }
                }
            }

            private int getCharOffset(FontMetrics fm, String characters, int xPos) {
                int i;
                StringBuilder s = new StringBuilder();
                char[] sArray = characters.toCharArray();
                for (i = 0; i < characters.length() && fm.stringWidth(s.toString()) < xPos; ++i) {
                    s.append(sArray[i]);
                }
                return i;
            }
        };
        this.list.addMouseMotionListener(mouseListener);
        this.list.addMouseListener(mouseListener);
        this.listeners = new ArrayList<MatchesPanelListener>();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Matches: "));
        JScrollPane scroller = new JScrollPane(this.list);
        this.add((Component)scroller, "Center");
    }

    public void removeAllMatches() {
        this.setMatchedParts(Generics.newHashMap());
        ((DefaultListModel)this.list.getModel()).removeAllElements();
        this.list.setSelectedIndex(-1);
        this.sendToListeners();
    }

    private static List<Tree> getTreebankAsList(Treebank tb) {
        ArrayList<Tree> treeList = new ArrayList<Tree>();
        if (tb != null) {
            treeList.addAll(tb);
        }
        return treeList;
    }

    public void setMatches(List<TreeFromFile> matches, Map<TreeFromFile, List<Tree>> matchedParts) {
        this.removeAllMatches();
        DefaultListModel<TreeFromFile> newModel = new DefaultListModel<TreeFromFile>();
        newModel.ensureCapacity(matches.size());
        if (TregexGUI.getInstance().isTdiffEnabled()) {
            FileTreeNode refTreebank = FilePanel.getInstance().getActiveTreebanks().get(0);
            String refFileName = refTreebank.getFilename();
            List<Tree> treeList = null;
            Map<TreeFromFile, List<Tree>> filteredMatchedParts = Generics.newHashMap();
            for (TreeFromFile t2 : matches) {
                if (t2.getFilename() == null || t2.getSentenceId() < 0) {
                    newModel.addElement(t2);
                    filteredMatchedParts.put(t2, matchedParts.get(t2));
                } else if (!t2.getFilename().equals(refFileName)) {
                    int treeId;
                    if (treeList == null) {
                        treeList = MatchesPanel.getTreebankAsList(refTreebank.getTreebank());
                    }
                    if ((treeId = t2.getSentenceId() - 1) >= treeList.size()) continue;
                    Tree t1 = treeList.get(treeId);
                    Tree treeT2 = t2.getTree();
                    Set<Constituent> inT1notT2 = Tdiff.markDiff(t1, treeT2);
                    t2.setDiffConstituents(inT1notT2);
                    t2.setDiffDecoratedTree(treeT2);
                    newModel.addElement(t2);
                    if (matchedParts != null && matchedParts.containsKey(t2)) {
                        filteredMatchedParts.put(t2, matchedParts.get(t2));
                    }
                }
                if (newModel.size() < this.maxMatches) continue;
                break;
            }
            matchedParts = filteredMatchedParts;
        } else if (!this.showOnlyMatchedPortion || matchedParts == null) {
            int i = 0;
            for (TreeFromFile t : matches) {
                newModel.addElement(t);
                if (++i < this.maxMatches) continue;
                break;
            }
        } else {
            int i = 0;
            block2: for (TreeFromFile t : matchedParts.keySet()) {
                List<Tree> curMatches = matchedParts.get(t);
                for (Tree match : curMatches) {
                    newModel.addElement(new TreeFromFile(match, t.getFilename()));
                    if (++i < this.maxMatches) continue;
                    continue block2;
                }
            }
        }
        if (!newModel.isEmpty()) {
            SwingUtilities.invokeLater(() -> {
                this.list.setModel(newModel);
                this.list.setSelectedIndex(0);
                this.sendToListeners();
            });
        }
        this.setMatchedParts(matchedParts);
        this.setPreferredSize(this.getSize());
    }

    public Pair<TreeFromFile, List<Tree>> getSelectedMatch() {
        if (!this.isEmpty()) {
            TreeFromFile selectedTree = (TreeFromFile)this.list.getSelectedValue();
            return new Pair<TreeFromFile, List<Tree>>(selectedTree, this.matchedParts.get(selectedTree));
        }
        return null;
    }

    public String getMatches() {
        StringBuilder sb = new StringBuilder();
        int sz = this.list.getModel().getSize();
        for (int i = 0; i < sz; ++i) {
            Tree t = ((TreeFromFile)this.list.getModel().getElementAt(i)).getTree();
            sb.append(t.pennString());
            sb.append("\n\n");
        }
        return sb.toString();
    }

    public String getMatchedSentences() {
        StringBuilder sb = new StringBuilder();
        int sz = this.list.getModel().getSize();
        for (int i = 0; i < sz; ++i) {
            String t = ((TreeFromFile)this.list.getModel().getElementAt(i)).getLabel().getText();
            sb.append(t);
            sb.append("\n");
        }
        return sb.toString();
    }

    public void selectPreviousMatch() {
        int idx = Math.max(0, this.list.getSelectedIndex() - 1);
        this.list.setSelectedIndex(idx);
    }

    public void selectNextMatch() {
        int idx = Math.min(this.list.getModel().getSize() - 1, this.list.getSelectedIndex() + 1);
        this.list.setSelectedIndex(idx);
    }

    public boolean isEmpty() {
        return ((DefaultListModel)this.list.getModel()).isEmpty();
    }

    public void addListener(MatchesPanelListener l) {
        this.listeners.add(l);
    }

    public void addListener(ListSelectionListener l) {
        this.list.addListSelectionListener(l);
    }

    private void sendToListeners() {
        for (MatchesPanelListener l : this.listeners) {
            l.matchesChanged();
        }
    }

    public Map<TreeFromFile, List<Tree>> getMatchedParts() {
        return this.matchedParts;
    }

    private void setMatchedParts(Map<TreeFromFile, List<Tree>> matchedParts) {
        this.matchedParts = matchedParts == null ? Generics.newHashMap() : matchedParts;
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
    }

    public boolean isShowOnlyMatchedPortion() {
        return this.showOnlyMatchedPortion;
    }

    public void setShowOnlyMatchedPortion(boolean showOnlyMatchedPortion) {
        this.showOnlyMatchedPortion = showOnlyMatchedPortion;
    }

    public void setFontName(String fontName) {
        Font curFont = this.getFont();
        Font newFont = new Font(fontName, curFont.getStyle(), curFont.getSize());
        this.list.setFont(newFont);
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        TreeFromFile t = (TreeFromFile)this.list.getSelectedValue();
        if (t == null) {
            this.lastSelected = null;
            return;
        }
        JTextField curSelected = t.getLabel();
        if (this.lastSelected != null) {
            if (this.lastSelected != curSelected) {
                this.lastSelected.getHighlighter().removeAllHighlights();
                this.lastSelected = curSelected;
                this.firstMouseEvent = null;
                this.lastSelected.repaint();
            }
        } else {
            this.lastSelected = curSelected;
        }
    }

    public void setMaxMatches(int maxMatches) {
        this.maxMatches = maxMatches;
    }

    public void focusOnList() {
        this.list.requestFocusInWindow();
    }

    private static class TreeTransferHandler
    extends TransferHandler {
        private static String exportString(JComponent c) {
            JList list = (JList)c;
            Object[] values = list.getSelectedValues();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                TreeFromFile val = (TreeFromFile)values[i];
                Highlighter h = val.getLabel().getHighlighter();
                Highlighter.Highlight[] highlights = h.getHighlights();
                if (highlights == null || highlights.length == 0) {
                    sb.append(val.getLabel().getText());
                    continue;
                }
                int j = 0;
                while (i < highlights.length) {
                    sb.append(val.getLabel().getText().substring(highlights[j].getStartOffset(), highlights[j].getEndOffset()));
                    ++i;
                }
            }
            return sb.toString();
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            return new StringSelection(TreeTransferHandler.exportString(c));
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }
    }

    private class MatchCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MatchCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JTextField l = ((TreeFromFile)value).getLabel();
            l.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            l.setOpaque(true);
            if (cellHasFocus || isSelected) {
                l.setBackground(MatchesPanel.this.highlightColor);
            } else {
                l.setBackground(Color.WHITE);
            }
            return l;
        }
    }

    public static interface MatchesPanelListener {
        public void matchesChanged();
    }
}

