/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.gui;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasIndex;
import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.trees.Constituent;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.gui.FileTreeModel;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JTextField;

public class TreeFromFile {
    private static Redwood.RedwoodChannels log = Redwood.channels(TreeFromFile.class);
    private final String treeString;
    private String filename;
    private String sentence = "";
    private int sentId = -1;
    private JTextField label;
    private Set<Constituent> diffSet;
    private Tree markedTree;

    public TreeFromFile(Tree t) {
        this.treeString = t.toString();
        this.sentence = SentenceUtils.listToString(t.yield());
        if (t.label() instanceof HasIndex) {
            this.sentId = ((CoreLabel)t.label()).sentIndex();
            this.filename = ((CoreLabel)t.label()).docID();
            if (this.sentId != -1 && this.filename != null && !this.filename.equals("")) {
                this.sentence = String.format("%s-%d   %s", this.filename, this.sentId, this.sentence);
            }
        }
    }

    public TreeFromFile(Tree t, String filename) {
        this(t);
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public int getSentenceId() {
        return this.sentId;
    }

    public Tree getTree() {
        try {
            return Tree.valueOf(this.treeString, FileTreeModel.getTRF());
        }
        catch (Exception e) {
            System.err.printf("%s: Could not recover tree from internal string:\n%s\n", this.getClass().getName(), this.treeString);
            return null;
        }
    }

    public JTextField getLabel() {
        if (this.label == null) {
            this.label = new JTextField(this.toString());
            this.label.setBorder(BorderFactory.createEmptyBorder());
        }
        return this.label;
    }

    public String toString() {
        if (this.sentence.length() == 0) {
            this.sentence = "* deleted *";
        }
        return this.sentence;
    }

    public void setDiffConstituents(Set<Constituent> lessConstituents) {
        this.diffSet = lessConstituents;
    }

    public Set<Constituent> getDiffConstituents() {
        return this.diffSet;
    }

    public void setDiffDecoratedTree(Tree decoratedTree) {
        this.markedTree = decoratedTree;
    }

    public Tree getDiffDecoratedTree() {
        return this.markedTree;
    }
}

