/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.MetaClass;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;

public class ArgumentParser {
    private static final String[] IGNORED_JARS = new String[0];
    private static final Class[] BOOTSTRAP_CLASSES = new Class[]{ArgumentParser.class};
    @Option(name="option_classes", gloss="Fill options from these classes")
    public static Class<?>[] optionClasses = null;
    @Option(name="threads", gloss="Number of threads on machine")
    public static int threads = Runtime.getRuntime().availableProcessors();
    @Option(name="host", gloss="Name of computer we are running on")
    public static String host = "(unknown)";
    @Option(name="strict", gloss="If true, make sure that all options passed in are used somewhere")
    private static boolean strict = false;
    @Option(name="exec.verbose", gloss="If true, print options as they are set.")
    private static boolean verbose = false;

    private ArgumentParser() {
    }

    private static void fillField(Object instance, Field f, String value) {
        if (verbose) {
            Option opt = f.getAnnotation(Option.class);
            StringBuilder b = new StringBuilder("setting ").append(f.getDeclaringClass().getName()).append("#").append(f.getName()).append(" ");
            if (opt != null) {
                b.append("[").append(opt.name()).append("] ");
            }
            b.append("to: ").append(value);
            Redwood.Util.log(b.toString());
        }
        try {
            Object objVal;
            boolean accessState = true;
            if (Modifier.isFinal(f.getModifiers())) {
                Redwood.Util.runtimeException("Option cannot be final: " + f);
            }
            if (!f.isAccessible()) {
                accessState = false;
                f.setAccessible(true);
            }
            if ((objVal = MetaClass.cast(value, f.getGenericType())) != null) {
                if (objVal.getClass().isArray()) {
                    Object[] array = (Object[])objVal;
                    if (!f.getType().isArray()) {
                        Redwood.Util.runtimeException("Setting an array to a non-array field. field: " + f + " value: " + Arrays.toString(array) + " src: " + value);
                    }
                    Object toSet = Array.newInstance(f.getType().getComponentType(), array.length);
                    for (int i = 0; i < array.length; ++i) {
                        Array.set(toSet, i, array[i]);
                    }
                    f.set(instance, toSet);
                } else {
                    f.set(instance, objVal);
                }
            } else {
                Redwood.Util.runtimeException("Cannot assign option field: " + f + " value: " + value + "; invalid type");
            }
            if (!accessState) {
                f.setAccessible(false);
            }
        }
        catch (IllegalArgumentException e) {
            Redwood.Util.err(e);
            Redwood.Util.runtimeException("Cannot assign option field: " + f.getDeclaringClass().getCanonicalName() + "." + f.getName() + " value: " + value + " cause: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            Redwood.Util.err(e);
            Redwood.Util.runtimeException("Cannot access option field: " + f.getDeclaringClass().getCanonicalName() + "." + f.getName());
        }
        catch (Exception e) {
            Redwood.Util.err(e);
            Redwood.Util.runtimeException("Cannot assign option field: " + f.getDeclaringClass().getCanonicalName() + "." + f.getName() + " value: " + value + " cause: " + e.getMessage());
        }
    }

    private static Class filePathToClass(String cpEntry, String path) {
        if (path.length() <= cpEntry.length()) {
            throw new IllegalArgumentException("Illegal path: cp=" + cpEntry + " path=" + path);
        }
        if (path.charAt(cpEntry.length()) != '/') {
            throw new IllegalArgumentException("Illegal path: cp=" + cpEntry + " path=" + path);
        }
        path = path.substring(cpEntry.length() + 1);
        path = path.replaceAll("/", ".").substring(0, path.length() - 6);
        try {
            return Class.forName(path, false, ClassLoader.getSystemClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw Redwood.Util.fail("Could not load class at path: " + path);
        }
        catch (NoClassDefFoundError ex) {
            Redwood.Util.warn("Class at path " + path + " is unloadable");
            return null;
        }
    }

    private static boolean isIgnored(String path) {
        for (String ignore : IGNORED_JARS) {
            if (!path.endsWith(ignore)) continue;
            return true;
        }
        return false;
    }

    private static Class<?>[] getVisibleClasses() {
        String[] cp;
        ArrayList classes = new ArrayList();
        String pathSep = System.getProperty("path.separator");
        for (String entry : cp = System.getProperties().getProperty("java.class.path", null).split(pathSep)) {
            Redwood.Util.log("Checking cp " + entry);
            if (entry.equals(".") || entry.trim().length() == 0) continue;
            File f = new File(entry);
            if (f.isDirectory()) {
                LazyFileIterator iter = new LazyFileIterator(f, ".*class$");
                while (iter.hasNext()) {
                    Class clazz = ArgumentParser.filePathToClass(entry, iter.next().getPath());
                    if (clazz == null) continue;
                    classes.add(clazz);
                }
                continue;
            }
            if (ArgumentParser.isIgnored(entry)) continue;
            try {
                JarFile jar = new JarFile(f);
                Enumeration<JarEntry> e = jar.entries();
                while (e.hasMoreElements()) {
                    JarEntry jarEntry = e.nextElement();
                    String clazz = jarEntry.getName();
                    if (!clazz.matches(".*class$")) continue;
                    clazz = clazz.substring(0, clazz.length() - 6).replaceAll("/", ".");
                    try {
                        classes.add(Class.forName(clazz, false, ClassLoader.getSystemClassLoader()));
                    }
                    catch (ClassNotFoundException ex) {
                        Redwood.Util.warn("Could not load class in jar: " + f + " at path: " + clazz);
                    }
                    catch (NoClassDefFoundError ex) {
                        Redwood.Util.debug("Could not scan class: " + clazz + " (in jar: " + f + ")");
                    }
                }
            }
            catch (IOException e) {
                Redwood.Util.warn("Could not open jar file: " + f + "(are you sure the file exists?)");
            }
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static Field[] scrapeFields(Class<?> clazz) throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null && !clazz.equals(Object.class)) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fields.toArray(new Field[fields.size()]);
    }

    private static String threadRootClass() {
        int i;
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        for (i = trace.length - 1; i > 0 && (trace[i].getClassName().startsWith("com.intellij") || trace[i].getClassName().startsWith("java.") || trace[i].getClassName().startsWith("sun.")); --i) {
        }
        StackTraceElement elem = trace[i];
        return elem.getClassName();
    }

    private static String bufferString(String raw, int minLength) {
        StringBuilder b = new StringBuilder(raw);
        for (int i = raw.length(); i < minLength; ++i) {
            b.append(" ");
        }
        return b.toString();
    }

    private static Map<String, Field> fillOptionsImpl(Object[] instances, Class<?>[] classes, Properties options, boolean ensureAllOptions, boolean isBootstrap) {
        String key;
        if (!isBootstrap && ("true".equalsIgnoreCase(options.getProperty("usage", "false")) || "true".equalsIgnoreCase(options.getProperty("help", "false")))) {
            HashSet allClasses = new HashSet();
            Collections.addAll(allClasses, classes);
            if (instances != null) {
                for (Object o : instances) {
                    allClasses.add(o.getClass());
                }
            }
            System.err.println(ArgumentParser.usage((Class[])allClasses.stream().toArray(Class[]::new)));
            System.exit(0);
        }
        HashMap class2object = new HashMap();
        if (instances != null) {
            for (int i = 0; i < classes.length; ++i) {
                assert (instances[i].getClass() == classes[i]);
                class2object.put(classes[i], instances[i]);
                for (Class<?> mySuper = instances[i].getClass().getSuperclass(); mySuper != null && !mySuper.equals(Object.class); mySuper = mySuper.getSuperclass()) {
                    if (class2object.containsKey(mySuper)) continue;
                    class2object.put(mySuper, instances[i]);
                }
            }
        }
        HashMap<String, Field> canFill = new HashMap<String, Field>();
        HashMap<String, Pair<Boolean, Boolean>> required = new HashMap<String, Pair<Boolean, Boolean>>();
        HashMap<String, String> interner = new HashMap<String, String>();
        for (Class<?> c : classes) {
            Field[] fields;
            try {
                fields = ArgumentParser.scrapeFields(c);
            }
            catch (Throwable e) {
                Redwood.Util.debug("Could not check fields for class: " + c.getName() + "  (caused by " + e.getClass() + ": " + e.getMessage() + ")");
                continue;
            }
            boolean someOptionFilled = false;
            boolean someOptionFound = false;
            for (Field f : fields) {
                String name;
                Option o = f.getAnnotation(Option.class);
                if (o == null) continue;
                someOptionFound = true;
                if ((f.getModifiers() & 8) == 0 && instances == null) continue;
                someOptionFilled = true;
                Pair<Boolean, Boolean> mark = Pair.makePair(false, false);
                if (o.required()) {
                    mark = Pair.makePair(true, false);
                }
                if ((name = o.name().toLowerCase()).equals("")) {
                    name = f.getName().toLowerCase();
                }
                if (canFill.containsKey(name)) {
                    String name2;
                    String name1 = ((Field)canFill.get(name)).getDeclaringClass().getCanonicalName() + "." + ((Field)canFill.get(name)).getName();
                    if (!name1.equals(name2 = f.getDeclaringClass().getCanonicalName() + "." + f.getName())) {
                        Redwood.Util.runtimeException("Multiple declarations of option " + name + ": " + name1 + " and " + name2);
                    } else {
                        Redwood.Util.err("Class is in classpath multiple times: " + ((Field)canFill.get(name)).getDeclaringClass().getCanonicalName());
                    }
                }
                canFill.put(name, f);
                required.put(name, mark);
                interner.put(name, name);
                if (o.alt().equals("")) continue;
                for (String alt : o.alt().split(" *, *")) {
                    if (canFill.containsKey(alt = alt.toLowerCase()) && !alt.equals(name)) {
                        throw new IllegalArgumentException("Multiple declarations of option " + alt + ": " + canFill.get(alt) + " and " + f);
                    }
                    canFill.put(alt, f);
                    if (((Boolean)mark.first).booleanValue()) {
                        required.put(alt, mark);
                    }
                    interner.put(alt, name);
                }
            }
            if (!someOptionFound || someOptionFilled) continue;
            Redwood.Util.warn("found @Option annotations in class " + c + ", but didn't set any of them (all options were instance variables and no instance given?)");
        }
        for (Map.Entry entry : options.entrySet()) {
            String rawKeyStr = entry.getKey().toString();
            key = rawKeyStr.toLowerCase();
            String value = entry.getValue().toString();
            assert (value != null);
            Field target = (Field)canFill.get(key);
            Pair mark = (Pair)required.get(key);
            if (mark != null && ((Boolean)mark.first).booleanValue()) {
                required.put(key, Pair.makePair(true, true));
            }
            if (target != null) {
                ArgumentParser.fillField(class2object.get(target.getDeclaringClass()), target, value);
                continue;
            }
            if (!ensureAllOptions) continue;
            int lastDotIndex = rawKeyStr.lastIndexOf(46);
            if (lastDotIndex < 0) {
                Redwood.Util.err("Unrecognized option: " + key);
                continue;
            }
            if (rawKeyStr.startsWith("log.")) continue;
            String className = rawKeyStr.substring(0, lastDotIndex);
            String fieldName = rawKeyStr.substring(lastDotIndex + 1);
            Class<?> clazz = null;
            try {
                clazz = ClassLoader.getSystemClassLoader().loadClass(className);
            }
            catch (Exception e) {
                Redwood.Util.err("Could not set option: " + entry.getKey() + "; either the option is mistyped, not defined, or the class " + className + " does not exist.");
            }
            if (clazz == null) continue;
            try {
                target = clazz.getField(fieldName);
            }
            catch (Exception e) {
                Redwood.Util.err("Could not set option: " + entry.getKey() + "; no such field: " + fieldName + " in class: " + className);
            }
            if (target != null) {
                Redwood.Util.log("option overrides " + target + " to '" + value + "'");
                ArgumentParser.fillField(class2object.get(target.getDeclaringClass()), target, value);
                continue;
            }
            Redwood.Util.err("Could not set option: " + entry.getKey() + "; no such field: " + fieldName + " in class: " + className);
        }
        boolean good = true;
        for (Map.Entry entry : required.entrySet()) {
            key = (String)entry.getKey();
            Pair mark = (Pair)entry.getValue();
            if (!((Boolean)mark.first).booleanValue() || ((Boolean)mark.second).booleanValue()) continue;
            Redwood.Util.err("Missing required option: " + (String)interner.get(key) + "   <in class: " + ((Field)canFill.get(key)).getDeclaringClass() + ">");
            required.put(key, Pair.makePair(true, true));
            good = false;
        }
        if (!good) {
            throw new RuntimeException("Not able to parse properties!!!");
        }
        return canFill;
    }

    private static Map<String, Field> fillOptionsImpl(Object[] instances, Class<?>[] classes, Properties options) {
        return ArgumentParser.fillOptionsImpl(instances, classes, options, strict, false);
    }

    public static void fillOptions(Class<?>[] classes, Properties options) {
        ArgumentParser.fillOptionsImpl(null, classes, options);
    }

    public static void fillOptions(Class<?>[] optionClasses, Properties props, String ... args) {
        ArgumentParser.optionClasses = optionClasses;
        ArgumentParser.fillOptions(props, args);
    }

    public static void fillOptions(Class<?>[] classes, String ... args) {
        Properties options = StringUtils.argsToProperties(args);
        ArgumentParser.fillOptionsImpl(null, BOOTSTRAP_CLASSES, options, false, true);
        ArgumentParser.fillOptionsImpl(null, classes, options);
    }

    public static void fillOptions(Class<?> clazz, Properties options) {
        ArgumentParser.fillOptionsImpl(null, new Class[]{clazz}, options);
    }

    public static void fillOptions(Class<?> clazz, String ... args) {
        Class[] classes = new Class[]{clazz};
        ArgumentParser.fillOptions(classes, args);
    }

    public static void fillOptions(Properties props) {
        ArgumentParser.fillOptions(props, StringUtils.EMPTY_STRING_ARRAY);
    }

    public static void fillOptions(String ... args) {
        ArgumentParser.fillOptions(StringUtils.argsToProperties(args), StringUtils.EMPTY_STRING_ARRAY);
    }

    public static void fillOptions(Properties props, String ... args) {
        Properties options = StringUtils.argsToProperties(args);
        for (String key : props.stringPropertyNames()) {
            options.setProperty(key, props.getProperty(key));
        }
        Map<String, Field> bootstrapMap = ArgumentParser.fillOptionsImpl(null, BOOTSTRAP_CLASSES, options, false, true);
        bootstrapMap.keySet().forEach(options::remove);
        Class<?>[] visibleClasses = optionClasses;
        if (visibleClasses == null) {
            visibleClasses = ArgumentParser.getVisibleClasses();
        }
        ArgumentParser.fillOptionsImpl(null, visibleClasses, options);
    }

    public static void fillOptions(Object[] instances, Properties options) {
        Class[] classes = new Class[instances.length];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = instances[i].getClass();
        }
        ArgumentParser.fillOptionsImpl(instances, classes, options);
    }

    public static void fillOptions(Object[] instances, String[] args) {
        Properties options = StringUtils.argsToProperties(args);
        ArgumentParser.fillOptionsImpl(null, BOOTSTRAP_CLASSES, options, false, true);
        Class[] classes = new Class[instances.length];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = instances[i].getClass();
        }
        ArgumentParser.fillOptionsImpl(instances, classes, options);
    }

    public static void fillOptions(Object instance, Properties options) {
        ArgumentParser.fillOptions(new Object[]{instance}, options);
    }

    public static void fillOptions(Object instance, String[] args) {
        ArgumentParser.fillOptions(new Object[]{instance}, args);
    }

    public static void fillOptions(Annotator annotator, String annotatorName, Properties props) {
        ArgumentParser.fillOptions((Object)annotator, props);
        Properties withoutPrefix = new Properties();
        String prefixString = annotatorName + '.';
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = entry.getKey().toString();
            withoutPrefix.setProperty(key.replace(prefixString, ""), entry.getValue().toString());
        }
        ArgumentParser.fillOptions((Object)annotator, withoutPrefix);
    }

    public static String usage(Class[] optionsClasses) {
        String mainClass = ArgumentParser.threadRootClass();
        StringBuilder b = new StringBuilder();
        b.append("Usage: ").append(mainClass).append(' ');
        ArrayList options = new ArrayList();
        for (Class clazz : optionsClasses) {
            try {
                options.addAll(Arrays.stream(ArgumentParser.scrapeFields(clazz)).map(field -> {
                    Annotation[] annotations = field.getAnnotationsByType(Option.class);
                    if (annotations.length > 0) {
                        return Pair.makePair((Option)annotations[0], field);
                    }
                    return null;
                }).filter(x -> x != null).collect(Collectors.toList()));
            }
            catch (Exception e) {
                return b.append("<unknown>").toString();
            }
        }
        int longestOptionName = options.stream().map(x -> ((Option)x.first).name().length()).max(Comparator.comparingInt(x -> x)).orElse(10);
        int longestOptionType = options.stream().map(x -> ((Field)x.second).getType().getSimpleName().length()).max(Comparator.comparingInt(x -> x)).orElse(10) + 1;
        options.stream().filter(x -> ((Option)x.first).required()).forEach(optionPair -> {
            Option option = (Option)optionPair.first;
            Field field = (Field)optionPair.second;
            b.append("\n\t-").append(ArgumentParser.bufferString(option.name(), longestOptionName)).append("   <").append(ArgumentParser.bufferString(field.getType().getSimpleName() + ">", longestOptionType)).append("   [required] ").append(option.gloss());
        });
        options.stream().filter(x -> !((Option)x.first).required()).forEach(optionPair -> {
            Option option = (Option)optionPair.first;
            Field field = (Field)optionPair.second;
            b.append("\n\t-").append(ArgumentParser.bufferString(option.name(), longestOptionName)).append("   <").append(ArgumentParser.bufferString(field.getType().getSimpleName() + ">", longestOptionType)).append("   ").append(option.gloss());
        });
        return b.toString();
    }

    public static String usage(Object[] optionsClasses) {
        return ArgumentParser.usage((Class[])Arrays.stream(optionsClasses).map(Object::getClass).toArray(Class[]::new));
    }

    public static String usage(Class<?> optionsClass) {
        return ArgumentParser.usage(new Class[]{optionsClass});
    }

    public static String usage(Object optionsClass) {
        return ArgumentParser.usage(new Class[]{optionsClass.getClass()});
    }

    static {
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class LazyFileIterator
    implements Iterator<File> {
        private FilenameFilter filter;
        private File[] dir;
        private Stack<File[]> parents = new Stack();
        private Stack<Integer> indices = new Stack();
        private int toReturn = -1;

        public LazyFileIterator(File path, String filter) {
            this(path, (File file, String name) -> {
                String filePath = file.getPath() + "/" + name;
                return new File(filePath).isDirectory() || filePath.matches(filter);
            });
        }

        public LazyFileIterator(File dir, FilenameFilter filter) {
            if (!dir.exists()) {
                throw new IllegalArgumentException("Could not find directory: " + dir.getPath());
            }
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException("Not a directory: " + dir.getPath());
            }
            this.filter = filter;
            this.dir = dir.listFiles(filter);
            this.enqueue();
        }

        private void enqueue() {
            boolean good;
            ++this.toReturn;
            boolean bl = good = this.toReturn < this.dir.length && !this.dir[this.toReturn].isDirectory();
            while (!good) {
                if (this.toReturn >= this.dir.length) {
                    if (this.parents.isEmpty()) {
                        this.toReturn = -1;
                        return;
                    }
                    this.dir = this.parents.pop();
                    this.toReturn = this.indices.pop();
                } else if (this.dir[this.toReturn].isDirectory()) {
                    this.parents.push(this.dir);
                    this.indices.push(this.toReturn + 1);
                    this.dir = this.dir[this.toReturn].listFiles(this.filter);
                    this.toReturn = 0;
                } else {
                    throw new IllegalStateException("File is invalid, but in range and not a directory: " + this.dir[this.toReturn]);
                }
                good = this.toReturn < this.dir.length && !this.dir[this.toReturn].isDirectory();
            }
        }

        @Override
        public boolean hasNext() {
            return this.toReturn >= 0;
        }

        @Override
        public File next() {
            if (this.toReturn >= this.dir.length || this.toReturn < 0) {
                throw new NoSuchElementException("No more elements!");
            }
            File rtn = this.dir[this.toReturn];
            this.enqueue();
            return rtn;
        }

        @Override
        public void remove() {
            throw new IllegalArgumentException("NOT IMPLEMENTED");
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Option {
        public String name() default "";

        public String gloss() default "";

        public boolean required() default false;

        public String alt() default "";
    }
}

