/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.ArrayMap;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.Generics;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public abstract class MapFactory<K, V>
implements Serializable {
    private static final long serialVersionUID = 4529666940763477360L;
    public static final MapFactory HASH_MAP_FACTORY = new HashMapFactory();
    public static final MapFactory IDENTITY_HASH_MAP_FACTORY = new IdentityHashMapFactory();
    private static final MapFactory WEAK_HASH_MAP_FACTORY = new WeakHashMapFactory();
    private static final MapFactory TREE_MAP_FACTORY = new TreeMapFactory();
    private static final MapFactory LINKED_HASH_MAP_FACTORY = new LinkedHashMapFactory();
    private static final MapFactory ARRAY_MAP_FACTORY = new ArrayMapFactory();
    public static final MapFactory CONCURRENT_MAP_FACTORY = new ConcurrentMapFactory();

    protected MapFactory() {
    }

    public static <K, V> MapFactory<K, V> hashMapFactory() {
        return HASH_MAP_FACTORY;
    }

    public static <K, V> MapFactory<K, V> identityHashMapFactory() {
        return IDENTITY_HASH_MAP_FACTORY;
    }

    public static <K, V> MapFactory<K, V> weakHashMapFactory() {
        return WEAK_HASH_MAP_FACTORY;
    }

    public static <K, V> MapFactory<K, V> treeMapFactory() {
        return TREE_MAP_FACTORY;
    }

    public static <K, V> MapFactory<K, V> treeMapFactory(Comparator<? super K> comparator) {
        return new TreeMapFactory(comparator);
    }

    public static <K, V> MapFactory<K, V> linkedHashMapFactory() {
        return LINKED_HASH_MAP_FACTORY;
    }

    public static <K, V> MapFactory<K, V> arrayMapFactory() {
        return ARRAY_MAP_FACTORY;
    }

    public abstract Map<K, V> newMap();

    public abstract Map<K, V> newMap(int var1);

    public abstract Set<K> newSet();

    public abstract Set<K> newSet(Collection<K> var1);

    public abstract <K1, V1> Map<K1, V1> setMap(Map<K1, V1> var1);

    public abstract <K1, V1> Map<K1, V1> setMap(Map<K1, V1> var1, int var2);

    private static class ConcurrentMapFactory<K, V>
    extends MapFactory<K, V> {
        private static final long serialVersionUID = -5855812734715185523L;

        private ConcurrentMapFactory() {
        }

        @Override
        public Map<K, V> newMap() {
            return new ConcurrentHashMap();
        }

        @Override
        public Map<K, V> newMap(int initCapacity) {
            return new ConcurrentHashMap(initCapacity);
        }

        @Override
        public Set<K> newSet() {
            return Collections.newSetFromMap(new ConcurrentHashMap());
        }

        @Override
        public Set<K> newSet(Collection<K> init) {
            Set set = Collections.newSetFromMap(new ConcurrentHashMap());
            set.addAll(init);
            return set;
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map) {
            return new ConcurrentHashMap();
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map, int initCapacity) {
            map = new ConcurrentHashMap<K1, V1>(initCapacity);
            return map;
        }
    }

    private static class ArrayMapFactory<K, V>
    extends MapFactory<K, V> {
        private static final long serialVersionUID = -5855812734715185523L;

        private ArrayMapFactory() {
        }

        @Override
        public Map<K, V> newMap() {
            return new ArrayMap();
        }

        @Override
        public Map<K, V> newMap(int initCapacity) {
            return new ArrayMap(initCapacity);
        }

        @Override
        public Set<K> newSet() {
            return new ArraySet();
        }

        @Override
        public Set<K> newSet(Collection<K> init) {
            return new ArraySet();
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map) {
            return new ArrayMap();
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map, int initCapacity) {
            map = new ArrayMap<K1, V1>(initCapacity);
            return map;
        }
    }

    private static class LinkedHashMapFactory<K, V>
    extends MapFactory<K, V> {
        private static final long serialVersionUID = -9138736068025818671L;

        private LinkedHashMapFactory() {
        }

        @Override
        public Map<K, V> newMap() {
            return new LinkedHashMap();
        }

        @Override
        public Map<K, V> newMap(int initCapacity) {
            return this.newMap();
        }

        @Override
        public Set<K> newSet() {
            return new LinkedHashSet();
        }

        @Override
        public Set<K> newSet(Collection<K> init) {
            return new LinkedHashSet<K>(init);
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map) {
            map = new LinkedHashMap<K1, V1>();
            return map;
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map, int initCapacity) {
            map = new LinkedHashMap<K1, V1>();
            return map;
        }
    }

    private static class TreeMapFactory<K, V>
    extends MapFactory<K, V> {
        private static final long serialVersionUID = -9138736068025818670L;
        private final Comparator<? super K> comparator;

        public TreeMapFactory() {
            this.comparator = null;
        }

        public TreeMapFactory(Comparator<? super K> comparator) {
            this.comparator = comparator;
        }

        @Override
        public Map<K, V> newMap() {
            return this.comparator == null ? new TreeMap() : new TreeMap(this.comparator);
        }

        @Override
        public Map<K, V> newMap(int initCapacity) {
            return this.newMap();
        }

        @Override
        public Set<K> newSet() {
            return this.comparator == null ? new TreeSet() : new TreeSet<K>(this.comparator);
        }

        @Override
        public Set<K> newSet(Collection<K> init) {
            return new TreeSet<K>(init);
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map) {
            if (this.comparator == null) {
                throw new UnsupportedOperationException();
            }
            map = new TreeMap<K1, V1>();
            return map;
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map, int initCapacity) {
            if (this.comparator == null) {
                throw new UnsupportedOperationException();
            }
            map = new TreeMap<K1, V1>();
            return map;
        }
    }

    private static class WeakHashMapFactory<K, V>
    extends MapFactory<K, V> {
        private static final long serialVersionUID = 4790014244304941000L;

        private WeakHashMapFactory() {
        }

        @Override
        public Map<K, V> newMap() {
            return new WeakHashMap();
        }

        @Override
        public Map<K, V> newMap(int initCapacity) {
            return new WeakHashMap(initCapacity);
        }

        @Override
        public Set<K> newSet() {
            return Collections.newSetFromMap(new WeakHashMap());
        }

        @Override
        public Set<K> newSet(Collection<K> init) {
            Set set = Collections.newSetFromMap(new WeakHashMap());
            set.addAll(init);
            return set;
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map) {
            map = new WeakHashMap<K1, V1>();
            return map;
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map, int initCapacity) {
            map = new WeakHashMap<K1, V1>(initCapacity);
            return map;
        }
    }

    private static class IdentityHashMapFactory<K, V>
    extends MapFactory<K, V> {
        private static final long serialVersionUID = -9222344631596580863L;

        private IdentityHashMapFactory() {
        }

        @Override
        public Map<K, V> newMap() {
            return new IdentityHashMap();
        }

        @Override
        public Map<K, V> newMap(int initCapacity) {
            return new IdentityHashMap(initCapacity);
        }

        @Override
        public Set<K> newSet() {
            return Collections.newSetFromMap(new IdentityHashMap());
        }

        @Override
        public Set<K> newSet(Collection<K> init) {
            Set set = Collections.newSetFromMap(new IdentityHashMap());
            set.addAll(init);
            return set;
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map) {
            map = new IdentityHashMap<K1, V1>();
            return map;
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map, int initCapacity) {
            map = new IdentityHashMap<K1, V1>(initCapacity);
            return map;
        }
    }

    private static class HashMapFactory<K, V>
    extends MapFactory<K, V> {
        private static final long serialVersionUID = -9222344631596580863L;

        private HashMapFactory() {
        }

        @Override
        public Map<K, V> newMap() {
            return Generics.newHashMap();
        }

        @Override
        public Map<K, V> newMap(int initCapacity) {
            return Generics.newHashMap(initCapacity);
        }

        @Override
        public Set<K> newSet() {
            return Generics.newHashSet();
        }

        @Override
        public Set<K> newSet(Collection<K> init) {
            return Generics.newHashSet(init);
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map) {
            map = Generics.newHashMap();
            return map;
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map, int initCapacity) {
            map = Generics.newHashMap(initCapacity);
            return map;
        }
    }
}

