#!/usr/bin/env python3
import os
import locale

from setuptools import find_packages, setup


try:
    locale.getlocale()
except (ValueError, UnicodeError):
    locale.setlocale(locale.LC_ALL, 'en_US.UTF-8')

required = ""
if os.path.exists('requirements.txt'):
    with open('requirements.txt') as requirements:
        required = requirements.read().splitlines()

if __name__ == "__main__":
    try:
        setup(name='BootLintBear',
              version='0.9.0.1472802302',
              description="'BootLintBear' bear for coala (http://coala.rtfd.org/)",
              authors={'The coala developers'},
              authors_emails={'coala-devel@googlegroups.com'},
              maintainers={'The coala developers'},
              maintainers_emails={'coala-devel@googlegroups.com'},
              platforms={'any'},
              license='AGPL-3.0',
              packages=find_packages(exclude=["build.*"]),
              install_requires=required,
              long_description="""
    Raise several common HTML mistakes in html files that are using
    Bootstrap in a fairly "vanilla" way. Vanilla Bootstrap's components/widgets
    require their parts of the DOM to conform to certain structures that is
    checked. Also, raises issues about certain <meta> tags, HTML5 doctype
    declaration, etc. to use bootstrap properly.

    For more about the analysis, check Bootlint
    <https://github.com/twbs/bootlint#bootlint>.
    """,
              entry_points={"coalabears": ["BootLintBear = coalaBootLintBear"]},
              classifiers=[
                   "Development Status :: 4 - Beta",
                   "Environment :: Console",
                   "Environment :: Win32 (MS Windows)",
                   "Intended Audience :: Science/Research",
                   "Intended Audience :: Developers",
                   "Programming Language :: "
                        "Python :: Implementation :: CPython",
                   "Programming Language :: Python :: 3.4",
                   "Programming Language :: Python :: 3.5",
                   "Programming Language :: Python :: 3 :: Only",
                   "Topic :: Scientific/Engineering :: Information Analysis",
                   "Topic :: Software Development :: Quality Assurance",
                   "Topic :: Text Processing :: Linguistic"])

    finally:
        print('[WARN] If you do not install the bears using the coala '
              'installation tool, there may be problems with the dependencies '
              'and they may not work.')
