# YACC (Yet another case converter) [![PyPI version](https://badge.fury.io/py/yascc.svg)](https://badge.fury.io/py/yascc)

Just wanted to shave off extra seconds from standard regex based camelcase to snakecase conversion implementation

```
pip install yascc
```

example usage:

```
>>> from yascc import camelcase
>>> camelcase.to_snake_case('yetAnotherCaseConverter')
'yet_another_case_converter'
>>> from yascc import snakecase
>>> snakecase.to_camel_case('yet_another_case_converter')
'yetAnotherCaseConverter'
>>>
```

benchmarks (against drf implementation of camelization):
```

---------------------------------------------------------------------------------------------------------------------------- benchmark: 12 tests -----------------------------------------------------------------------------------------------------------------------------
Name (time in ns)                                               Min                           Max                       Mean                     StdDev                     Median                       IQR            Outliers             OPS            Rounds  Iterations
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
test_camelize_benchmark[c]                                 408.3500 (1.09)       118,569,181.2541 (>1000.0)       2,770.5177 (3.81)        464,263.3929 (510.25)          541.6980 (1.08)           102.0439 (1.25)      2;11971    360,943.3668 (0.26)      94859          20
test_camelize_benchmark[drf]                             5,540.9037 (14.78)           91,916.9979 (1.0)           5,846.6371 (8.04)            909.8678 (1.0)           5,749.9856 (11.50)          167.0560 (2.04)     215;1826    171,038.4919 (0.12)      27875           1
test_camelize_list_benchmark[c]                          1,041.4515 (2.78)       432,991,187.4956 (>1000.0)       4,742.0071 (6.52)      1,124,950.7602 (>1000.0)       1,187.4945 (2.37)           625.0339 (7.63)       1;7629    210,881.1684 (0.15)     148149           2
test_camelize_list_benchmark[drf]                       14,333.0544 (38.22)          103,958.9988 (1.13)         15,051.4398 (20.70)         2,064.2514 (2.27)         14,708.9595 (29.42)          499.8874 (6.10)     432;1465     66,438.8267 (0.05)      28743           1
test_camelize_list_benchmark_1000_nested[c]          1,214,542.0769 (>1000.0)  1,374,871,624.9829 (>1000.0)   5,337,910.4512 (>1000.0)  69,312,343.7479 (>1000.0)   1,463,687.5130 (>1000.0)     88,250.9630 (>1000.0)      2;69        187.3392 (0.00)        642           1
test_camelize_list_benchmark_1000_nested[drf]       14,500,834.0478 (>1000.0)     15,766,833.9089 (171.53)   14,920,121.8119 (>1000.0)     359,482.6800 (395.09)   14,775,895.5136 (>1000.0)    430,124.9282 (>1000.0)      19;0         67.0236 (0.00)         64           1
test_decamelize_benchmark[c]                               374.9738 (1.0)            290,416.9960 (3.16)            726.9863 (1.0)           3,587.3747 (3.94)            500.0038 (1.0)             81.9564 (1.0)      630;5728  1,375,541.7008 (1.0)       77173           1
test_decamelize_benchmark[drf]                           2,624.9327 (7.00)           154,834.0078 (1.68)          2,963.5381 (4.08)          1,522.9844 (1.67)          2,874.9928 (5.75)           166.9396 (2.04)      262;993    337,434.5008 (0.25)      46603           1
test_decamelize_list_benchmark[c]                        1,000.0076 (2.67)        77,625,915.9902 (844.52)        5,246.6607 (7.22)        431,820.9940 (474.60)        1,166.0159 (2.33)            83.9354 (1.02)      8;14646    190,597.4204 (0.14)      79472           1
test_decamelize_list_benchmark[drf]                     27,167.0287 (72.45)          113,375.0193 (1.23)         27,898.9601 (38.38)         1,686.7357 (1.85)         27,667.0326 (55.33)          292.0860 (3.56)       98;446     35,843.6298 (0.03)       3539           1
test_decamelize_list_benchmark_1000_nested[c]        1,185,750.0067 (>1000.0)    709,811,916.9241 (>1000.0)   5,369,670.2647 (>1000.0)  41,215,551.4726 (>1000.0)   1,403,291.9426 (>1000.0)     85,583.6843 (>1000.0)     10;88        186.2312 (0.00)        815           1
test_decamelize_list_benchmark_1000_nested[drf]     27,148,582.9726 (>1000.0)     29,370,459.0295 (319.53)   28,241,048.7699 (>1000.0)     680,167.0803 (747.54)   28,381,165.9319 (>1000.0)  1,155,896.6944 (>1000.0)      14;0         35.4094 (0.00)         35           1
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Legend:
  Outliers: 1 Standard Deviation from Mean; 1.5 IQR (InterQuartile Range) from 1st Quartile and 3rd Quartile.
  OPS: Operations Per Second, computed as 1 / Mean
```
