# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['zenml',
 'zenml.annotations',
 'zenml.artifact_stores',
 'zenml.artifacts',
 'zenml.cli',
 'zenml.config',
 'zenml.core',
 'zenml.io',
 'zenml.materializers',
 'zenml.metadata',
 'zenml.orchestrators',
 'zenml.orchestrators.airflow',
 'zenml.orchestrators.local',
 'zenml.pipelines',
 'zenml.stacks',
 'zenml.steps',
 'zenml.utils']

package_data = \
{'': ['*']}

install_requires = \
['analytics-python>=1.4.0,<2.0.0',
 'apache-beam>=2.30.0,<3.0.0',
 'click>=8.0.1,<9.0.0',
 'distro>=1.6.0,<2.0.0',
 'gitpython>=3.1.18,<4.0.0',
 'ml-pipelines-sdk>=1.2.0,<2.0.0',
 'pandas>=1.1.5,<2.0.0',
 'panel>=0.11.3,<0.12.0',
 'pydantic>=1.8.2,<2.0.0',
 'python-dateutil>=2.8.1,<3.0.0',
 'pyyaml>=5.4.1,<6.0.0']

extras_require = \
{'airflow': ['apache-airflow>=2.1.4,<3.0.0'],
 'all': ['apache-airflow>=2.1.4,<3.0.0'],
 'gcp': ['gcsfs>=2021.9.0,<2022.0.0']}

entry_points = \
{'console_scripts': ['zenml = zenml.cli.cli:cli']}

setup_kwargs = {
    'name': 'zenml',
    'version': '0.5.0rc1',
    'description': 'ZenML: Write production-ready ML code.',
    'long_description': '<div align="center">\n\n<img src="https://zenml.io/assets/social/github.svg">\n\n<p align="center">\n  <a href="https://zenml.io">zenml.io</a> •\n  <a href="https://docs.zenml.io">docs.zenml.io</a> •\n  <a href="#quickstart">Quickstart</a> •\n  <a href="#community">Community</a> •\n  <a href="https://zenml.io/roadmap">Roadmap</a> •\n  <a href="https://zenml.io/slack-invite/">Join Slack</a>\n</p>\n\n[![PyPI - ZenML Version](https://img.shields.io/pypi/v/zenml.svg?label=pip&logo=PyPI&logoColor=white)](https://pypi.org/project/zenml/)\n[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/zenml)](https://pypi.org/project/zenml/)\n[![PyPI Status](https://pepy.tech/badge/zenml)](https://pepy.tech/project/zenml)\n![GitHub](https://img.shields.io/github/license/zenml-io/zenml)\n[![Codecov](https://codecov.io/gh/zenml-io/zenml/branch/main/graph/badge.svg)](https://codecov.io/gh/zenml-io/zenml)\n[![Interrogate](docs/interrogate.svg)](https://interrogate.readthedocs.io/en/latest/)\n![Main Workflow Tests](https://github.com/zenml-io/zenml/actions/workflows/main.yml/badge.svg)\n\n</div>\n\n<div align="center"> Join our\n<a href="https://zenml.io/slack-invite" target="_blank">\n    <img width="25" src="https://cdn3.iconfinder.com/data/icons/logos-and-brands-adobe/512/306_Slack-512.png" alt="Slack"/>\n<b>Slack Community</b> </a> and become part of the ZenML family\n</div>\n<div align="center"> Give us a \n    <img width="25" src="https://cdn.iconscout.com/icon/free/png-256/github-153-675523.png" alt="Slack"/>\n<b>GitHub star</b> to show your love\n</div>\n\n## What is ZenML?\n\n**ZenML** is an extensible, open-source MLOps framework to create production-ready machine learning pipelines. It has a simple, flexible syntax, \nis cloud and tool agnostic, and has interfaces/abstractions that are catered towards ML workflows.\n\nAt its core, ZenML  pipelines execute ML-specific workflows from sourcing data to splitting, preprocessing, training, all the way to the evaluation of \nresults and even serving. There are many built-in batteries as things progress in ML development. ZenML is not here to replace the great tools that \nsolve these individual problems. Rather, it integrates natively with many popular ML tooling, and gives standard abstraction to write your workflows.\n\n## Why do I need it?\n\n_**Ichi Wa Zen, Zen Wa Ichi.**_\n\nWe built ZenML because we could not find an easy framework that translates the patterns observed in the research phase with Jupyter notebooks into a production-ready ML environment.\nZenML follows the paradigm of [`Pipelines As Experiments` (PaE)](https://docs.zenml.io/why/why-zenml#pipelines-as-experiments-pae), meaning ZenML pipelines are designed to be written early on the development lifecycle, where the users can explore their \npipelines as they develop towards production.\n\nBy using ZenML at the early stages of development, you get the following features:\n\n* **Reproducibility** of training and inference workflows.\n* Managing ML **metadata**, including versioning data, code, and models.\n* Getting an **overview** of your ML development, with a reliable link between training and deployment.\n* Maintaining **comparability** between ML models.\n* **Scaling** ML training/inference to large datasets.\n* Retaining code **quality** alongside development velocity. \n* **Reusing** code/data and reducing waste.\n* Keeping up with the **ML tooling landscape** with standard abstractions and interfaces.\n\n\n## Who is it for?\nZenML is built for ML practitioners who are ramping up their ML workflows towards production. \nIt is created for data science / machine learning teams that are engaged in not only training models, but also putting them out in production. Production can mean many things, but examples would be:\n\n* If you are using a model to generate analysis periodically for any business process.\n* If you are using models as a software service to serve predictions and are consistently improving the model over time.\n* If you are trying to understand patterns using machine learning for any business process.\n\n* In all of the above, there will be team that is engaged with creating, deploying, managing and improving the entire process. You always want the best results, the best models, and the most robust and reliable results. This is where ZenML can help.\nIn terms of user persona, ZenML is created for producers of the models. This role is classically known as \'data scientist\' in the industry and can range from research-minded individuals to more engineering-driven people. The goal of ZenML is to enable these practitioners to own their models until deployment and beyond.\n\n\n## Release 0.5.0 and what lies ahead\nThe current release is bare bones (as it is a complete rewrite).\nWe are missing some basic features which used to be part of ZenML 0.3.8 (the previous release):\n\n* Standard interfaces for `TrainingPipeline`.\n* Individual step interfaces like `PreprocesserStep`, `TrainerStep`, `DeployerStep` etc. need to be rewritten from within the new paradigm. They should\nbe included in the non-RC version of this release.\n* A proper production setup with an orchestrator like Airflow.\n* A post-execution workflow to analyze and inspect pipeline runs.\n* The concept of `Backends` will evolve into a simple mechanism of transitioning individual steps into different runners.\n* Support for `KubernetesOrchestrator`, `KubeflowOrchestrator`, `GCPOrchestrator` and `AWSOrchestrator` are also planned.\n* Dependency management including Docker support is planned.\n\nHowever, bare with us: Adding those features back in should be relatively faster as we now have a solid foundation to build on. Look out for the next email!\n\nFrom this point onwards, the README is intended to give a glimpse as to what lies ahead. We have redesigned our [public roadmap](https://zenml.io/roadmap) \nto showcase better the timeline in which these features will be complete.\n\n## Quickstart\n\nThe quickest way to get started is to create a simple pipeline.\n\n#### Step 0: Installation\n\nZenML is available for easy installation into your environment via PyPI:\n\n```bash\npip install zenml\n```\n\nAlternatively, if you’re feeling brave, feel free to install the bleeding edge:\n**NOTE:** Do so on your own risk, no guarantees given!\n\n```bash\npip install git+https://github.com/zenml-io/zenml.git@main --upgrade\n```\n\n#### Step 1: Initialize a ZenML repo from within a git repo\n\n```bash\ngit init\nzenml init\n```\n\n#### Step 2: Assemble, run and evaluate your pipeline locally\n\n```python\nfrom zenml.pipelines import TrainingPipeline\nfrom zenml.steps.evaluator import TFMAEvaluator\nfrom zenml.steps.split import RandomSplit\nfrom zenml.steps.preprocesser import StandardPreprocesser\nfrom zenml.steps.trainer import TFFeedForwardTrainer\n\n\n@step.trainer\ndef TFFeedForwardTrainer():\n    pass\n\n@pipeline(name="my_pipeline")\ndef SplitPipeline(simple_step: Step[SimplestStepEver],\n                  data_step: Step[DataIngestionStep],\n                  split_step: Step[DistSplitStep],\n                  preprocesser_step: Step[InMemPreprocesserStep]):\n    data_step(input_random_number=simple_step.outputs["return_output"])\n    split_step(input_artifact=data_step.outputs["output_artifact"])\n    preprocesser_step(input_artifact=split_step.outputs["output_artifact"])\n\n\npipeline = TrainingPipeline(\n    data_step=ImportDataStep(uri=\'gs://zenml_quickstart/diabetes.csv\'),\n    split_step=RandomSplit(split_map={\'train\': 0.7, \'test\': 0.3}),\n    preprocesser_step=StandardPreprocesser(),\n    trainer_step=TFFeedForwardTrainer(),\n    evaluator_step=TFMAEvaluator()\n)\n\n# Run the pipeline locally\npipeline.run()\n```\n\n## Leverage powerful integrations\n\nOnce code is organized into a ZenML pipeline, you can supercharge your ML development with powerful integrations and \non multiple [MLOps stacks].\n\n### Work locally but switch seamlessly to the cloud\n\nSwitching from local experiments to cloud-based pipelines doesn\'t need to be complex.\n\n```\npipeline.run(\'airflow_gcp_stack\')\n```\n\n### Versioning galore\n\nZenML makes sure for every pipeline you can trust that:\n\n✅ Code is versioned  \n✅ Data is versioned  \n✅ Models are versioned  \n✅ Configurations are versioned  \n![ZenML declarative config](docs/versioning.png)\n\n### Automatically detect schema\n\n```python\n# See the schema of your data\npipeline.view_schema()\n```\n\n![Automatic schema dection](docs/schema.png)\n\n### View statistics\n\n```python\n# See statistics of train and eval\npipeline.view_statistics()\n```\n\n<img src="docs/statistics.png" alt="ZenML statistics visualization" />\n\n### Evaluate the model using built-in evaluators\n\n```python\n# Creates a notebook for evaluation\ntraining_pipeline.evaluate()\n```\n\n<img src="docs/tensorboard_inline.png" alt="Tensorboard built-in"   />\n\n### Compare training pipelines\n\n```python\nrepo.compare_training_runs()\n```\n\n![ZenML built-in pipeline comparison](docs/compare.png)\n\n### Distribute preprocessing to the cloud\n\nLeverage distributed compute powered by [Apache Beam](https://beam.apache.org/):\n\n```python\ntraining_pipeline.add_preprocesser(\n    StandardPreprocesser(...).with_backend(\n      ProcessingDataFlowBackend(\n        project=GCP_PROJECT,\n        num_workers=10,\n    ))\n)\n```\n\n<img src="docs/zenml_distribute.png" alt="ZenML distributed processing"   />\n\n### Deploy models automatically\n\nAutomatically deploy each model with powerful Deployment integrations like [Cortex](examples/cortex).\n\n```python\npipeline.add_deployment(\n    CortexDeployerStep(\n        api_spec=api_spec,\n        predictor=PythonPredictor,\n    )\n)\n```\n\nThe best part is that ZenML is extensible easily, and can be molded to your use-case. You can create your own custom logic or create a PR and contribute to the ZenML community, so that everyone can benefit.\n\n## Roadmap\nMissing a feature/integration? Our roadmap is public, and hosted on Notion. \nCheck it out [here](https://zenml.io/roadmap).\n\n## Community\n\nOur community is the backbone of making ZenML a success! We are currently actively maintaining two main channels for community discussions:\n\n- Our Slack Channel: Chat with us [here](https://zenml.io/slack-invite/).\n\n## Contributing\n\nWe would love to receive your contributions! Check our [Contributing Guide](CONTRIBUTING.md) for more details on how best to contribute.\n\n## Copyright\n\nZenML is distributed under the terms of the Apache License Version 2.0. A complete version of the license is available in the [LICENSE.md](LICENSE.md) in this repository.\n\nAny contribution made to this project will be licensed under the Apache License Version 2.0.\n\n## Credit\n\nZenML is built on the shoulders of giants: we leverage, and would like to give credit to, existing open-source libraries like [TFX](https://github.com/tensorflow/tfx/). The goal of our framework is neither to replace these libraries, nor to diminish their usage. ZenML is simply an opinionated, higher-level interface with the focus being purely on easy-of-use and coherent intuitive design.\nYou can read more about why we actually started building ZenML at our [blog](https://blog.zenml.io/why-zenml/).\n',
    'author': 'ZenML GmbH',
    'author_email': 'info@zenml.io',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://zenml.io',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6.2,<3.9',
}


setup(**setup_kwargs)
