/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.segment.srx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.loomchild.segment.TextIterator;
import net.loomchild.segment.srx.LanguageRule;
import net.loomchild.segment.srx.Rule;
import net.loomchild.segment.srx.SrxDocument;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractSrxTextIteratorTest {
    public static final String[] SIMPLE_RESULT = new String[]{"Ala ma kota.", " Prof. Kot nie wie kim jest.", " Ech.", "\nA inny prof. to ju\u017c w ogole.", " Uch"};
    public static final String SIMPLE_LANGUAGE = "pl";
    public static final SrxDocument SIMPLE_DOCUMENT = AbstractSrxTextIteratorTest.createSimpleDocument();
    public static final String[] EMPTY_RESULT = new String[0];
    public static final SrxDocument EMPTY_DOCUMENT = AbstractSrxTextIteratorTest.createEmptyDocument();
    public static final String[] ALTERNATIVE_RULE_RESULT = new String[]{"W 59 n. e. Julek nie zrobi\u0142 nic ciekawego.", " Drugie dn. to: Ja te\u017c nie"};
    public static final SrxDocument ALTERNATIVE_RULE_DOCUMENT = AbstractSrxTextIteratorTest.createAlternativeRuleDocument();
    public static final String[] OVERLAPPING_RULES_RESULT = new String[]{"W 59 n.e. Julek nie zrobi\u0142 nic ciekawego.", " Ja te\u017c nie"};
    public static final SrxDocument OVERLAPPING_RULES_DOCUMENT = AbstractSrxTextIteratorTest.createOverlappingRulesDocument();
    public static final String[] INTERLACED_RULES_RESULT = new String[]{"a? b? a. b.", " c.", " d."};
    public static final SrxDocument INTERLACED_RULES_DOCUMENT = AbstractSrxTextIteratorTest.createInterlacedRulesDocument();
    public static final String[] NO_BREAK_RULES_RESULT = new String[]{"abcab"};
    public static final SrxDocument NO_BREAK_RULES_DOCUMENT = AbstractSrxTextIteratorTest.createNoBreakRulesDocument();
    public static final String[] INFINITE_NEGATIVE_RULE_RESULT = new String[]{"Abc 99. Def.", " Xyz."};
    public static final SrxDocument INFINITE_NEGATIVE_RULE_DOCUMENT = AbstractSrxTextIteratorTest.createInfiniteNegativeRuleDocument();
    public static final String[] ONLY_BREAK_RULES_RESULT = new String[]{"Abc 99.", " Def.", " Xyz."};
    public static final SrxDocument ONLY_BREAK_RULES_DOCUMENT = AbstractSrxTextIteratorTest.createOnlyBreakRulesDocument();
    public static final String[] BREAK_AT_THE_END_RESULT = new String[]{"a."};
    public static final SrxDocument BREAK_AT_THE_END_DOCUMENT = AbstractSrxTextIteratorTest.createBreakAtTheEndDocument();
    public static final String[] EMPTY_EXCEPTION_RULE_RESULT = new String[]{"a. b. c"};
    public static final SrxDocument EMPTY_EXCEPTION_RULE_DOCUMENT = AbstractSrxTextIteratorTest.createEmptyExceptionRuleDocument();
    public static final String[] EMPTY_BREAK_RULE_RESULT = new String[]{"a", " ", "b", "c"};
    public static final SrxDocument EMPTY_BREAK_RULE_DOCUMENT = AbstractSrxTextIteratorTest.createEmptyBreakRuleDocument();
    public static final String[] WORD_BOUNDARY_RESULT = new String[]{"Don't split strings like U.S.A. please."};
    public static final String WORD_BOUNDARY_LANGUAGE = "en";
    public static final SrxDocument WORD_BOUNDARY_DOCUMENT = AbstractSrxTextIteratorTest.createWordBoundaryDocument();
    public static final String[] EXCEPTION_RULE_LONGER_THAN_BREAK_RULE_RESULT = new String[]{"Ala ma kota.", " "};
    public static final SrxDocument EXCEPTION_RULE_LONGER_THAN_BREAK_RULE_DOCUMENT = AbstractSrxTextIteratorTest.createExceptionRuleLongerThanBreakRuleDocument();
    public static final String[] MATCHING_END_RESULT = new String[]{"A.", "."};
    public static final SrxDocument MATCHING_END_DOCUMENT = AbstractSrxTextIteratorTest.createMatchingEndDocument();
    public static final String[] MATCHING_ALL_RESULT = new String[]{"A", " B.", " C", " "};
    public static final SrxDocument MATCHING_ALL_DOCUMENT = AbstractSrxTextIteratorTest.createMatchingAllDocument();
    public static final String[] OVERLAPPING_BREAK_RULES_RESULT = new String[]{"A..", ".B"};
    public static final SrxDocument OVERLAPPING_BREAK_RULES_DOCUMENT = AbstractSrxTextIteratorTest.createOverlappingBreakRulesDocument();
    public static final String[] MIXED_BREAK_RULES_RESULT = new String[]{"xabc", "d"};
    public static final SrxDocument MIXED_BREAK_RULES_DOCUMENT = AbstractSrxTextIteratorTest.createMixedBreakRulesDocument();
    public static final String[] TEXT_LONGER_THAN_BUFFER_RESULT = AbstractSrxTextIteratorTest.createTextLongerThanBufferResult();
    public static final SrxDocument TEXT_LONGER_THAN_BUFFER_DOCUMENT = AbstractSrxTextIteratorTest.createTextLongerThanBufferDocument();
    public static final String[] TICKET_1_RESULT = new String[]{"This is a sentence. "};
    public static final SrxDocument TICKET_1_DOCUMENT = AbstractSrxTextIteratorTest.createTicket1Document();
    public static final String[] SPECIFICATION_EXAMPLE_RESULT = new String[]{"The U.K. Prime Minister, Mr. Blair, was seen out today."};
    public static final SrxDocument SPECIFICATION_EXAMPLE_DOCUMENT = AbstractSrxTextIteratorTest.createSpecificationExampleDocument();

    public static SrxDocument createSimpleDocument() {
        LanguageRule languageRulePL = new LanguageRule("Polish");
        languageRulePL.addRule(new Rule(false, "[Pp]rof\\.", "\\s"));
        LanguageRule languageRuleEN = new LanguageRule("English");
        languageRuleEN.addRule(new Rule(false, "Mr\\.", "\\s"));
        LanguageRule languageRuleDEF = new LanguageRule("Default");
        languageRuleDEF.addRule(new Rule(true, "\\.", "\\s"));
        languageRuleDEF.addRule(new Rule(true, "", "\\n"));
        SrxDocument document = new SrxDocument();
        document.addLanguageMap("pl.*", languageRulePL);
        document.addLanguageMap("en.*", languageRuleEN);
        document.addLanguageMap(".*", languageRuleDEF);
        return document;
    }

    @Test
    public void testSimpleSplit() {
        this.performTest(SIMPLE_RESULT, SIMPLE_DOCUMENT, SIMPLE_LANGUAGE);
    }

    public static SrxDocument createEmptyDocument() {
        LanguageRule languageRule = new LanguageRule("");
        languageRule.addRule(new Rule(true, ".", " "));
        SrxDocument document = new SrxDocument();
        document.addLanguageMap(".*", languageRule);
        return document;
    }

    @Test
    public void testEmptyText() {
        this.performTest(EMPTY_RESULT, EMPTY_DOCUMENT);
    }

    public static SrxDocument createAlternativeRuleDocument() {
        LanguageRule languageRule = new LanguageRule("Deafult");
        languageRule.addRule(new Rule(false, "(n\\.)|(e\\.)|(dn\\.)", " "));
        languageRule.addRule(new Rule(true, "\\.", " "));
        SrxDocument document = new SrxDocument();
        document.addLanguageMap(".*", languageRule);
        return document;
    }

    @Test
    public void testAlternativeRuleSplit() {
        this.performTest(ALTERNATIVE_RULE_RESULT, ALTERNATIVE_RULE_DOCUMENT);
    }

    public static SrxDocument createOverlappingRulesDocument() {
        LanguageRule languageRule = new LanguageRule("");
        languageRule.addRule(new Rule(false, "n\\.", ""));
        languageRule.addRule(new Rule(false, "n\\.e\\.", ""));
        languageRule.addRule(new Rule(true, "\\.", ""));
        SrxDocument document = new SrxDocument();
        document.addLanguageMap(".*", languageRule);
        return document;
    }

    @Test
    public void testOverlappingRulesSplit() {
        this.performTest(OVERLAPPING_RULES_RESULT, OVERLAPPING_RULES_DOCUMENT);
    }

    public static SrxDocument createInterlacedRulesDocument() {
        LanguageRule languageRule = new LanguageRule("");
        languageRule.addRule(new Rule(false, "a[\\.\\?]", " "));
        languageRule.addRule(new Rule(true, "\\.", " "));
        languageRule.addRule(new Rule(false, "(b[\\.\\?])", " "));
        languageRule.addRule(new Rule(true, "\\?", " "));
        languageRule.addRule(new Rule(false, "c[\\.\\?]", " "));
        SrxDocument document = new SrxDocument();
        document.addLanguageMap(".*", languageRule);
        return document;
    }

    @Test
    public void testInterlacedRulesSplit() throws IOException {
        this.performTest(INTERLACED_RULES_RESULT, INTERLACED_RULES_DOCUMENT);
    }

    public static SrxDocument createNoBreakRulesDocument() {
        LanguageRule languageRule = new LanguageRule("");
        languageRule.addRule(new Rule(false, "a", " "));
        SrxDocument document = new SrxDocument();
        document.addLanguageMap(".*", languageRule);
        return document;
    }

    @Test
    public void testNoBreakRules() {
        this.performTest(NO_BREAK_RULES_RESULT, NO_BREAK_RULES_DOCUMENT);
    }

    public static SrxDocument createInfiniteNegativeRuleDocument() {
        LanguageRule languageRule = new LanguageRule("");
        languageRule.addRule(new Rule(false, "([0-9]+\\.|[0-9]{1,}\\.|[0-9][0-9]*\\.)", "\\s"));
        languageRule.addRule(new Rule(true, "\\.", "\\s"));
        SrxDocument document = new SrxDocument();
        document.addLanguageMap(".*", languageRule);
        return document;
    }

    @Test
    public void testInfiniteNegativeRule() {
        this.performTest(INFINITE_NEGATIVE_RULE_RESULT, INFINITE_NEGATIVE_RULE_DOCUMENT);
    }

    public static SrxDocument createOnlyBreakRulesDocument() {
        LanguageRule languageRule = new LanguageRule("");
        languageRule.addRule(new Rule(true, "\\.", "\\s"));
        languageRule.addRule(new Rule(true, "", "\\n"));
        SrxDocument document = new SrxDocument();
        document.addLanguageMap(".*", languageRule);
        return document;
    }

    @Test
    public void testOnlyBreakRules() {
        this.performTest(ONLY_BREAK_RULES_RESULT, ONLY_BREAK_RULES_DOCUMENT);
    }

    public static SrxDocument createBreakAtTheEndDocument() {
        LanguageRule languageRule = new LanguageRule("");
        languageRule.addRule(new Rule(true, "\\.", ""));
        SrxDocument document = new SrxDocument();
        document.addLanguageMap(".*", languageRule);
        return document;
    }

    @Test
    public void testBreakAtTheEndOfText() {
        this.performTest(BREAK_AT_THE_END_RESULT, BREAK_AT_THE_END_DOCUMENT);
    }

    public static SrxDocument createEmptyExceptionRuleDocument() {
        LanguageRule languageRule = new LanguageRule("");
        languageRule.addRule(new Rule(false, "", ""));
        languageRule.addRule(new Rule(true, "\\.", " "));
        SrxDocument document = new SrxDocument();
        document.addLanguageMap(".*", languageRule);
        return document;
    }

    @Test
    public void testEmptyExceptionRule() {
        this.performTest(EMPTY_EXCEPTION_RULE_RESULT, EMPTY_EXCEPTION_RULE_DOCUMENT);
    }

    public static SrxDocument createEmptyBreakRuleDocument() {
        LanguageRule languageRule = new LanguageRule("");
        languageRule.addRule(new Rule(true, "", ""));
        SrxDocument document = new SrxDocument();
        document.addLanguageMap(".*", languageRule);
        return document;
    }

    @Test
    public void testEmptyBreakRule() {
        this.performTest(EMPTY_BREAK_RULE_RESULT, EMPTY_BREAK_RULE_DOCUMENT);
    }

    public static SrxDocument createWordBoundaryDocument() {
        LanguageRule languageRule = new LanguageRule("");
        languageRule.addRule(new Rule(false, "\\b\\p{L}\\.", ""));
        languageRule.addRule(new Rule(true, "\\.", ""));
        SrxDocument document = new SrxDocument();
        document.addLanguageMap(".*", languageRule);
        return document;
    }

    @Test
    public void testWordBoundary() {
        this.performTest(WORD_BOUNDARY_RESULT, WORD_BOUNDARY_DOCUMENT, WORD_BOUNDARY_LANGUAGE);
    }

    public static SrxDocument createExceptionRuleLongerThanBreakRuleDocument() {
        LanguageRule languageRule = new LanguageRule("");
        languageRule.addRule(new Rule(false, "\\.", "\\sa"));
        languageRule.addRule(new Rule(true, "\\.", "\\s"));
        SrxDocument document = new SrxDocument();
        document.addLanguageMap(".*", languageRule);
        return document;
    }

    @Test
    public void testExceptionRuleLongerThanBreakRule() {
        this.performTest(EXCEPTION_RULE_LONGER_THAN_BREAK_RULE_RESULT, EXCEPTION_RULE_LONGER_THAN_BREAK_RULE_DOCUMENT);
    }

    public static SrxDocument createMatchingEndDocument() {
        LanguageRule languageRule = new LanguageRule("");
        languageRule.addRule(new Rule(true, "\\.\\.\\.", ""));
        languageRule.addRule(new Rule(true, "\\.", ""));
        SrxDocument document = new SrxDocument();
        document.addLanguageMap(".*", languageRule);
        return document;
    }

    @Test
    public void testMatchingEnd() {
        this.performTest(MATCHING_END_RESULT, MATCHING_END_DOCUMENT);
    }

    public static SrxDocument createMatchingAllDocument() {
        LanguageRule languageRule = new LanguageRule("");
        languageRule.addRule(new Rule(true, "[^\\s]*", "\\s"));
        languageRule.addRule(new Rule(true, "\\.", "\\s"));
        SrxDocument document = new SrxDocument();
        document.addLanguageMap(".*", languageRule);
        return document;
    }

    @Test
    public void testMatchingAll() {
        this.performTest(MATCHING_ALL_RESULT, MATCHING_ALL_DOCUMENT);
    }

    public static SrxDocument createOverlappingBreakRulesDocument() {
        LanguageRule languageRule = new LanguageRule("");
        languageRule.addRule(new Rule(true, "\\.\\.\\.", ""));
        languageRule.addRule(new Rule(true, "\\.\\.", ""));
        SrxDocument document = new SrxDocument();
        document.addLanguageMap(".*", languageRule);
        return document;
    }

    @Test
    public void testOverlappingBreakRules() {
        this.performTest(OVERLAPPING_BREAK_RULES_RESULT, OVERLAPPING_BREAK_RULES_DOCUMENT);
    }

    public static SrxDocument createMixedBreakRulesDocument() {
        LanguageRule languageRule = new LanguageRule("");
        languageRule.addRule(new Rule(false, "b", "c"));
        languageRule.addRule(new Rule(true, "b", ""));
        languageRule.addRule(new Rule(true, "abc", ""));
        SrxDocument document = new SrxDocument();
        document.addLanguageMap(".*", languageRule);
        return document;
    }

    @Test
    public void testMixedBreakRules() {
        this.performTest(MIXED_BREAK_RULES_RESULT, MIXED_BREAK_RULES_DOCUMENT);
    }

    private static String[] createTextLongerThanBufferResult() {
        int length = 104877;
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            result[i] = "AAAAAAAAA.";
        }
        return result;
    }

    private static SrxDocument createTextLongerThanBufferDocument() {
        LanguageRule languageRule = new LanguageRule("");
        languageRule.addRule(new Rule(false, "Mr\\.", ""));
        languageRule.addRule(new Rule(true, "\\.", ""));
        SrxDocument document = new SrxDocument();
        document.addLanguageMap(".*", languageRule);
        return document;
    }

    public void testTextLongerThanBufferRules() {
        this.performTest(TEXT_LONGER_THAN_BUFFER_RESULT, TEXT_LONGER_THAN_BUFFER_DOCUMENT);
    }

    public static SrxDocument createTicket1Document() {
        LanguageRule languageRule = new LanguageRule("");
        languageRule.addRule(new Rule(false, "[A-Z]\\.\\s", ""));
        languageRule.addRule(new Rule(true, "\\.\\s", ""));
        SrxDocument document = new SrxDocument();
        document.addLanguageMap(".*", languageRule);
        return document;
    }

    @Test
    public void testTicket1Rule() {
        this.performTest(TICKET_1_RESULT, TICKET_1_DOCUMENT);
    }

    public static SrxDocument createSpecificationExampleDocument() {
        LanguageRule languageRule = new LanguageRule("");
        languageRule.addRule(new Rule(false, "\\sU\\.K\\.", "\\s"));
        languageRule.addRule(new Rule(false, "Mr\\.", "\\s"));
        languageRule.addRule(new Rule(true, "[\\.\\?!]+", "\\s"));
        SrxDocument document = new SrxDocument();
        document.addLanguageMap(".*", languageRule);
        return document;
    }

    @Test
    public void testSpecificationExample() {
        this.performTest(SPECIFICATION_EXAMPLE_RESULT, SPECIFICATION_EXAMPLE_DOCUMENT);
    }

    protected abstract TextIterator getTextIterator(SrxDocument var1, String var2, String var3);

    private void performTest(String[] expectedResult, SrxDocument document) {
        this.performTest(expectedResult, document, "");
    }

    private void performTest(String[] expectedResult, SrxDocument document, String languageCode) {
        String text = this.merge(expectedResult);
        TextIterator textIterator = this.getTextIterator(document, languageCode, text);
        List<String> segmentList = this.segment(textIterator);
        Object[] segmentArray = segmentList.toArray(new String[segmentList.size()]);
        Assert.assertEquals((Object[])expectedResult, (Object[])segmentArray);
    }

    protected List<String> segment(TextIterator textIterator) {
        ArrayList<String> segmentList = new ArrayList<String>();
        while (textIterator.hasNext()) {
            segmentList.add(textIterator.next());
        }
        return segmentList;
    }

    protected String merge(String[] stringArray) {
        StringBuilder builder = new StringBuilder();
        for (String string : stringArray) {
            builder.append(string);
        }
        return builder.toString();
    }
}

