/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.segment.srx;

import java.util.HashMap;
import java.util.List;
import net.loomchild.segment.TextIterator;
import net.loomchild.segment.srx.AbstractSrxTextIteratorTest;
import net.loomchild.segment.srx.LanguageRule;
import net.loomchild.segment.srx.Rule;
import net.loomchild.segment.srx.SrxDocument;
import net.loomchild.segment.srx.SrxTextIterator;
import org.junit.Assert;
import org.junit.Test;

public class SrxTextIteratorStringTest
extends AbstractSrxTextIteratorTest {
    public static final String[] MAX_LOOKBEHIND_CONSTRUCT_LENGTH_RESULT = new String[]{"XAAA.", "XBB.XC"};
    public static final SrxDocument MAX_LOOKBEHIND_CONSTRUCT_LENGTH_DOCUMENT = SrxTextIteratorStringTest.createMaxLookbehindConstructLengthDocument();

    @Override
    protected TextIterator getTextIterator(SrxDocument document, String languageCode, String text) {
        return new SrxTextIterator(document, languageCode, (CharSequence)text);
    }

    public static SrxDocument createMaxLookbehindConstructLengthDocument() {
        LanguageRule languageRule = new LanguageRule("");
        languageRule.addRule(new Rule(false, "XA+\\.", ""));
        languageRule.addRule(new Rule(false, "XB+\\.", ""));
        languageRule.addRule(new Rule(true, "\\.", ""));
        SrxDocument document = new SrxDocument();
        document.addLanguageMap(".*", languageRule);
        return document;
    }

    @Test
    public void testMaxLookbehindConstructLength() {
        HashMap<String, Integer> parameterMap = new HashMap<String, Integer>();
        parameterMap.put("maxLookbehindConstructLength", 2);
        String text = this.merge(MAX_LOOKBEHIND_CONSTRUCT_LENGTH_RESULT);
        SrxTextIterator textIterator = new SrxTextIterator(MAX_LOOKBEHIND_CONSTRUCT_LENGTH_DOCUMENT, "", (CharSequence)text, parameterMap);
        List<String> segmentList = this.segment((TextIterator)textIterator);
        Object[] segmentArray = segmentList.toArray(new String[segmentList.size()]);
        Assert.assertEquals((Object[])MAX_LOOKBEHIND_CONSTRUCT_LENGTH_RESULT, (Object[])segmentArray);
    }
}

