/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.segment.srx;

import java.io.Reader;
import java.io.StringReader;
import net.loomchild.segment.srx.TextManager;
import org.junit.Assert;
import org.junit.Test;

public class TextManagerTest {
    @Test
    public void testCharSequence() {
        TextManager manager = new TextManager((CharSequence)"text");
        Assert.assertEquals((Object)"text", (Object)manager.getText().toString());
        Assert.assertEquals((long)4L, (long)manager.getBufferLength());
        Assert.assertEquals((Object)false, (Object)manager.hasMoreText());
    }

    @Test
    public void testEmptyString() {
        TextManager manager = new TextManager((CharSequence)"");
        Assert.assertEquals((Object)"", (Object)manager.getText().toString());
        Assert.assertEquals((long)0L, (long)manager.getBufferLength());
        Assert.assertEquals((Object)false, (Object)manager.hasMoreText());
    }

    @Test(expected=IllegalStateException.class)
    public void testCannotReadCharSequence() {
        TextManager manager = new TextManager((CharSequence)"text");
        manager.readText(1);
    }

    @Test
    public void testReader() {
        StringReader reader = new StringReader("text");
        TextManager manager = new TextManager((Reader)reader, 2);
        Assert.assertEquals((long)2L, (long)manager.getBufferLength());
        Assert.assertEquals((Object)"te", (Object)manager.getText().toString());
        Assert.assertEquals((Object)true, (Object)manager.hasMoreText());
        manager.readText(1);
        Assert.assertEquals((Object)"ex", (Object)manager.getText().toString());
        Assert.assertEquals((Object)true, (Object)manager.hasMoreText());
        manager.readText(1);
        Assert.assertEquals((Object)"xt", (Object)manager.getText().toString());
        Assert.assertEquals((Object)false, (Object)manager.hasMoreText());
    }

    @Test
    public void testEmptyReader() {
        StringReader reader = new StringReader("");
        TextManager manager = new TextManager((Reader)reader, 2);
        Assert.assertEquals((Object)"", (Object)manager.getText().toString());
        Assert.assertEquals((long)2L, (long)manager.getBufferLength());
        Assert.assertEquals((Object)false, (Object)manager.hasMoreText());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBufferZeroLength() {
        StringReader reader = new StringReader("");
        new TextManager((Reader)reader, 0);
    }
}

