/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.segment.srx.io;

import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import net.loomchild.segment.srx.LanguageMap;
import net.loomchild.segment.srx.LanguageRule;
import net.loomchild.segment.srx.Rule;
import net.loomchild.segment.srx.SrxDocument;
import net.loomchild.segment.srx.SrxParser;
import net.loomchild.segment.srx.io.Srx1Parser;
import net.loomchild.segment.srx.io.Srx2Parser;
import net.loomchild.segment.srx.io.Srx2SaxParser;
import net.loomchild.segment.srx.io.Srx2StaxParser;
import net.loomchild.segment.srx.io.SrxAnyParser;
import net.loomchild.segment.util.Util;
import net.loomchild.segment.util.XmlException;
import org.junit.Assert;
import org.junit.Test;

public class SrxParsersTest {
    private static final SrxParser ONE = new Srx1Parser();
    private static final SrxParser TWO = new Srx2Parser();
    private static final SrxParser ANY = new SrxAnyParser();
    private static final SrxParser SAX = new Srx2SaxParser();
    private static final SrxParser STAX = new Srx2StaxParser();
    private static final String SRX_1_DOCUMENT_NAME = "net/loomchild/segment/res/test/example1.srx";
    private static final String SRX_2_DOCUMENT_NAME = "net/loomchild/segment/res/test/example.srx";
    public static final String INVALID_DOCUMENT_NAME = "net/loomchild/segment/res/test/invalid.srx";
    public static final String TICKET_1_DOCUMENT_NAME = "net/loomchild/segment/res/test/ticket1.srx";

    @Test
    public void testSrx1One() {
        this.testSrx1(ONE);
    }

    @Test
    public void testSrx1Any() {
        this.testSrx1(ANY);
    }

    @Test
    public void testSrx1Compare() {
        this.testCompare(SRX_1_DOCUMENT_NAME, new SrxParser[]{ONE, ANY});
    }

    private void testSrx1(SrxParser parser) {
        Reader reader = Util.getReader((InputStream)Util.getResourceStream((String)SRX_1_DOCUMENT_NAME));
        SrxDocument document = parser.parse(reader);
        Assert.assertFalse((boolean)document.getCascade());
        List languageRuleList = document.getLanguageRuleList("en");
        Assert.assertEquals((long)1L, (long)languageRuleList.size());
        LanguageRule languageRule = (LanguageRule)languageRuleList.get(0);
        Assert.assertEquals((Object)"Default", (Object)languageRule.getName());
        List ruleList = languageRule.getRuleList();
        Assert.assertEquals((long)5L, (long)ruleList.size());
        Rule rule = (Rule)ruleList.get(1);
        Assert.assertEquals((Object)"[Ee][Tt][Cc]\\.", (Object)rule.getBeforePattern());
        Assert.assertEquals((Object)"\\s[a-z]", (Object)rule.getAfterPattern());
    }

    @Test
    public void testSrx2Two() {
        this.testSrx2(TWO);
    }

    @Test
    public void testSrx2Sax() {
        this.testSrx2(SAX);
    }

    @Test
    public void testSrx2Stax() {
        this.testSrx2(STAX);
    }

    @Test
    public void testSrx2Any() {
        this.testSrx2(ANY);
    }

    @Test
    public void testSrx2Compare() {
        this.testCompare(SRX_2_DOCUMENT_NAME, new SrxParser[]{TWO, SAX, STAX, ANY});
    }

    private void testSrx2(SrxParser parser) {
        Reader reader = Util.getReader((InputStream)Util.getResourceStream((String)SRX_2_DOCUMENT_NAME));
        SrxDocument document = parser.parse(reader);
        Assert.assertTrue((boolean)document.getCascade());
        List languageRuleList = document.getLanguageRuleList("fr_FR");
        Assert.assertEquals((long)2L, (long)languageRuleList.size());
        LanguageRule languageRule = (LanguageRule)languageRuleList.get(0);
        Assert.assertEquals((Object)"French", (Object)languageRule.getName());
        List ruleList = languageRule.getRuleList();
        Assert.assertEquals((long)4L, (long)ruleList.size());
        Rule rule0 = (Rule)ruleList.get(0);
        Assert.assertEquals((Object)" [Mm]lle\\.", (Object)rule0.getBeforePattern());
        Assert.assertEquals((Object)"\\s", (Object)rule0.getAfterPattern());
        Rule rule1 = (Rule)ruleList.get(1);
        Assert.assertEquals((Object)"\\s[Mm]lles\\.", (Object)rule1.getBeforePattern());
        Assert.assertEquals((Object)"\\s", (Object)rule1.getAfterPattern());
    }

    @Test(expected=XmlException.class)
    public void testSrx2InvalidTwo() {
        this.testSrx2Invalid(TWO);
    }

    @Test(expected=XmlException.class)
    public void testSrx2InvalidSax() {
        this.testSrx2Invalid(SAX);
    }

    @Test(expected=XmlException.class)
    public void testSrx2InvalidAny() {
        this.testSrx2Invalid(ANY);
    }

    private void testSrx2Invalid(SrxParser parser) {
        Reader reader = Util.getReader((InputStream)Util.getResourceStream((String)INVALID_DOCUMENT_NAME));
        parser.parse(reader);
    }

    @Test
    public void testSrx2Ticket1Two() {
        this.testSrx2Ticket1(TWO);
    }

    @Test
    public void testSrx2Ticket1Sax() {
        this.testSrx2Ticket1(SAX);
    }

    @Test
    public void testSrx2Ticket1Stax() {
        this.testSrx2Ticket1(STAX);
    }

    @Test
    public void testSrx2Ticket1Any() {
        this.testSrx2Ticket1(ANY);
    }

    @Test
    public void testSrx2Ticket1Compare() {
        this.testCompare(TICKET_1_DOCUMENT_NAME, new SrxParser[]{TWO, SAX, STAX, ANY});
    }

    private void testSrx2Ticket1(SrxParser parser) {
        Reader reader = Util.getReader((InputStream)Util.getResourceStream((String)TICKET_1_DOCUMENT_NAME));
        SrxDocument document = parser.parse(reader);
        Assert.assertTrue((boolean)document.getCascade());
        List languageRuleList = document.getLanguageRuleList("en");
        LanguageRule languageRule = (LanguageRule)languageRuleList.get(0);
        Assert.assertEquals((Object)"Default", (Object)languageRule.getName());
        List ruleList = languageRule.getRuleList();
        Assert.assertEquals((long)1L, (long)ruleList.size());
        Rule rule = (Rule)ruleList.get(0);
        Assert.assertEquals((Object)"[\\.!?\u2026]['\u00bb\"\u201d\\)\\]\\}]?\\u0002?\\s", (Object)rule.getBeforePattern());
        Assert.assertEquals((Object)"", (Object)rule.getAfterPattern());
    }

    public void testCompare(String documentName, SrxParser[] parsers) {
        SrxDocument previousDocument = null;
        for (SrxParser parser : parsers) {
            Reader reader = Util.getReader((InputStream)Util.getResourceStream((String)documentName));
            SrxDocument document = parser.parse(reader);
            if (previousDocument != null) {
                this.assertSrxDocumentEquals(previousDocument, document);
            }
            previousDocument = document;
        }
    }

    private void assertSrxDocumentEquals(SrxDocument leftDocument, SrxDocument rightDocument) {
        Assert.assertEquals((Object)leftDocument.getCascade(), (Object)rightDocument.getCascade());
        List leftLanguageMapList = leftDocument.getLanguageMapList();
        List rightLanguageMapList = rightDocument.getLanguageMapList();
        Assert.assertEquals((long)leftLanguageMapList.size(), (long)rightLanguageMapList.size());
        for (int i = 0; i < leftLanguageMapList.size(); ++i) {
            LanguageMap leftLanguageMap = (LanguageMap)leftLanguageMapList.get(i);
            LanguageMap rightLanguageMap = (LanguageMap)rightLanguageMapList.get(i);
            Assert.assertEquals((Object)leftLanguageMap.getLanguagePattern().pattern(), (Object)rightLanguageMap.getLanguagePattern().pattern());
            LanguageRule leftLanguageRule = leftLanguageMap.getLanguageRule();
            LanguageRule rightLanguageRule = rightLanguageMap.getLanguageRule();
            Assert.assertEquals((Object)leftLanguageRule.getName(), (Object)rightLanguageRule.getName());
            List leftRuleList = leftLanguageRule.getRuleList();
            List rightRuleList = rightLanguageRule.getRuleList();
            Assert.assertEquals((long)leftRuleList.size(), (long)rightRuleList.size());
            for (int k = 0; k < leftRuleList.size(); ++k) {
                Rule leftRule = (Rule)leftRuleList.get(k);
                Rule rightRule = (Rule)rightRuleList.get(k);
                Assert.assertEquals((Object)leftRule.isBreak(), (Object)rightRule.isBreak());
                Assert.assertEquals((Object)leftRule.getBeforePattern(), (Object)rightRule.getBeforePattern());
                Assert.assertEquals((Object)leftRule.getAfterPattern(), (Object)rightRule.getAfterPattern());
            }
        }
    }
}

