/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.segment.srx.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Templates;
import junit.framework.TestCase;
import net.loomchild.segment.srx.SrxTransformer;
import net.loomchild.segment.srx.io.Srx1Transformer;
import net.loomchild.segment.srx.io.Srx2Transformer;
import net.loomchild.segment.util.IORuntimeException;
import net.loomchild.segment.util.Util;

public class SrxTransformersTest
extends TestCase {
    public static final String SRX_1_DOCUMENT_NAME = "net/loomchild/segment/res/test/example1.srx";
    public static final String SRX_2_DOCUMENT_NAME = "net/loomchild/segment/res/test/example2.srx";
    public static final String STYLESHEET = "net/loomchild/segment/res/xml/strip-space.xsl";
    private static final Templates templates = Util.getTemplates((Reader)Util.getReader((InputStream)Util.getResourceStream((String)"net/loomchild/segment/res/xml/strip-space.xsl")));

    public void testSrx1Transformer() {
        Srx1Transformer transformer = new Srx1Transformer();
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        this.testTransformer(SRX_2_DOCUMENT_NAME, SRX_1_DOCUMENT_NAME, (SrxTransformer)transformer, parameterMap);
        parameterMap.put("maprulename", "Default");
        this.testTransformer(SRX_2_DOCUMENT_NAME, SRX_1_DOCUMENT_NAME, (SrxTransformer)transformer, parameterMap);
    }

    public void testSrx2Transformer() {
        Srx2Transformer transformer = new Srx2Transformer();
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        this.testTransformer(SRX_2_DOCUMENT_NAME, SRX_2_DOCUMENT_NAME, (SrxTransformer)transformer, parameterMap);
    }

    private void testTransformer(String expectedDocumentName, String sourceDocumentName, SrxTransformer transformer, Map<String, Object> parameterMap) {
        Reader reader = Util.getReader((InputStream)Util.getResourceStream((String)expectedDocumentName));
        String expectedDocument = this.removeWhitespaces(reader);
        reader = Util.getReader((InputStream)Util.getResourceStream((String)sourceDocumentName));
        reader = transformer.transform(reader, parameterMap);
        String actualDocument = this.removeWhitespaces(reader);
        SrxTransformersTest.assertEquals((String)expectedDocument, (String)actualDocument);
        reader = Util.getReader((InputStream)Util.getResourceStream((String)sourceDocumentName));
        StringWriter writer = new StringWriter();
        transformer.transform(reader, (Writer)writer, parameterMap);
        reader = new StringReader(((Object)writer).toString());
        actualDocument = this.removeWhitespaces(reader);
        SrxTransformersTest.assertEquals((String)expectedDocument, (String)actualDocument);
    }

    private String removeWhitespaces(Reader reader) {
        StringWriter writer = new StringWriter();
        Util.transform((Templates)templates, (Reader)reader, (Writer)writer);
        StringReader stringReader = new StringReader(writer.toString());
        StringBuilder builder = new StringBuilder();
        try {
            int i;
            while ((i = stringReader.read()) != -1) {
                char c = (char)i;
                if (c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\f') continue;
                builder.append(c);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return builder.toString();
    }
}

