/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.segment.srx.io;

import java.io.BufferedReader;
import java.io.InputStream;
import junit.framework.TestCase;
import net.loomchild.segment.srx.io.SrxVersion;
import net.loomchild.segment.util.Util;
import net.loomchild.segment.util.XmlException;

public class SrxVersionTest
extends TestCase {
    public static final String SRX_1_DOCUMENT_NAME = "net/loomchild/segment/res/test/example1.srx";
    public static final String SRX_2_DOCUMENT_NAME = "net/loomchild/segment/res/test/example2.srx";
    public static final String NO_SRX_DOCUMENT_NAME = "net/loomchild/segment/res/test/some.xml";
    public static final String SRX_NOVERSION_DOCUMENT_NAME = "net/loomchild/segment/res/test/invalid.srx";

    public void testGetSrxVersion() {
        BufferedReader reader = new BufferedReader(Util.getReader((InputStream)Util.getResourceStream((String)SRX_1_DOCUMENT_NAME)));
        SrxVersion version = SrxVersion.parse((BufferedReader)reader);
        SrxVersionTest.assertEquals((Object)SrxVersion.VERSION_1_0, (Object)version);
        reader = new BufferedReader(Util.getReader((InputStream)Util.getResourceStream((String)SRX_2_DOCUMENT_NAME)));
        version = SrxVersion.parse((BufferedReader)reader);
        SrxVersionTest.assertEquals((Object)SrxVersion.VERSION_2_0, (Object)version);
        try {
            reader = new BufferedReader(Util.getReader((InputStream)Util.getResourceStream((String)NO_SRX_DOCUMENT_NAME)));
            SrxVersion.parse((BufferedReader)reader);
            SrxVersionTest.fail((String)"Recognized version of non SRX document.");
        }
        catch (XmlException xmlException) {
            // empty catch block
        }
        try {
            reader = new BufferedReader(Util.getReader((InputStream)Util.getResourceStream((String)SRX_NOVERSION_DOCUMENT_NAME)));
            SrxVersion.parse((BufferedReader)reader);
            SrxVersionTest.fail((String)"Recognized version of SRX document without version.");
        }
        catch (XmlException xmlException) {
            // empty catch block
        }
    }
}

