/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.segment.srx.legacy;

import java.io.Reader;
import java.io.StringReader;
import net.loomchild.segment.srx.legacy.ReaderCharSequence;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReaderCharSequenceTest {
    private static final String DATA = "abcde";
    private ReaderCharSequence sequence;

    @Before
    public void setUp() {
        StringReader reader = new StringReader(DATA);
        this.sequence = new ReaderCharSequence((Reader)reader, 3, DATA.length());
    }

    @Test
    public void testWorking() {
        Assert.assertEquals((long)5L, (long)this.sequence.length());
        Assert.assertEquals((long)97L, (long)this.sequence.charAt(0));
        Assert.assertEquals((long)98L, (long)this.sequence.charAt(1));
        Assert.assertEquals((long)99L, (long)this.sequence.charAt(2));
        Assert.assertEquals((long)100L, (long)this.sequence.charAt(3));
        Assert.assertEquals((Object)"cde", (Object)this.sequence.subSequence(2, 5).toString());
        Assert.assertEquals((long)101L, (long)this.sequence.charAt(4));
        Assert.assertEquals((Object)"de", (Object)this.sequence.subSequence(3, 5).toString());
        Assert.assertEquals((long)100L, (long)this.sequence.charAt(3));
    }

    public void testZeroLengthSubsequence() {
        Assert.assertEquals((long)0L, (long)this.sequence.subSequence(1, 1).length());
    }

    @Test(expected=IllegalStateException.class)
    public void testSubsequenceLongerThanBuffer() {
        Assert.assertEquals((Object)DATA, (Object)this.sequence.subSequence(0, 5).toString());
    }

    @Test(expected=IllegalStateException.class)
    public void testReadBack() {
        this.sequence.charAt(4);
        this.sequence.charAt(0);
    }

    @Test(expected=IllegalStateException.class)
    public void testWindowTooNarrow() {
        this.sequence.subSequence(0, 5);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testIndexPastEnd() {
        this.sequence.charAt(5);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testIndexNegative() {
        this.sequence.charAt(-1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testEndBeforeStart() {
        this.sequence.subSequence(2, 1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testStartNegative() {
        this.sequence.subSequence(-1, 1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testEndPastEnd() {
        this.sequence.subSequence(1, 6);
    }

    @Test
    public void testInfiniteStream() {
        StringReader reader = new StringReader(DATA);
        ReaderCharSequence infiniteSequence = new ReaderCharSequence((Reader)reader, 3, 0x7FFFFFF7, 2);
        Assert.assertEquals((long)99L, (long)infiniteSequence.charAt(2));
        Assert.assertEquals((long)101L, (long)infiniteSequence.charAt(4));
        Assert.assertEquals((long)5L, (long)infiniteSequence.length());
        try {
            infiniteSequence.charAt(5);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testAllSubsequence() {
        StringReader reader = new StringReader(DATA);
        ReaderCharSequence infiniteSequence = new ReaderCharSequence((Reader)reader, 5, 0x7FFFFFF7, 2);
        CharSequence subsequence = infiniteSequence.subSequence(0, infiniteSequence.length());
        Assert.assertEquals((Object)DATA, (Object)subsequence.toString());
    }

    @Test
    public void testIterate() {
        StringReader reader = new StringReader(DATA);
        ReaderCharSequence infiniteSequence = new ReaderCharSequence((Reader)reader, 3);
        for (int i = 0; i < infiniteSequence.length(); ++i) {
            Assert.assertEquals((long)DATA.charAt(i), (long)infiniteSequence.charAt(i));
        }
    }
}

