/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.segment.srx.legacy;

import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Pattern;
import net.loomchild.segment.srx.legacy.ReaderCharSequence;
import net.loomchild.segment.srx.legacy.ReaderMatcher;
import org.junit.Assert;
import org.junit.Test;

public class ReaderMatcherTest {
    private static final String REGEX_DATA = "abcde - fghijklmno pqrstuvw - x -";
    private static final Pattern REGEX = Pattern.compile(" - ");
    private static final Pattern REGEX_WHOLE = Pattern.compile(".*");
    private static final Pattern REGEX_ALTERNATIVE = Pattern.compile("b|bc");
    private static final Pattern REGEX_LOOKING_AT = Pattern.compile("bcd");

    @Test
    public void testSimple() {
        StringReader reader = new StringReader(REGEX_DATA);
        ReaderCharSequence text = new ReaderCharSequence((Reader)reader);
        ReaderMatcher matcher = new ReaderMatcher(REGEX, (CharSequence)text);
        boolean found = matcher.find();
        Assert.assertTrue((boolean)found);
        Assert.assertEquals((long)5L, (long)matcher.start());
        found = matcher.find();
        Assert.assertTrue((boolean)found);
        Assert.assertEquals((long)27L, (long)matcher.start());
        found = matcher.find();
        Assert.assertFalse((boolean)found);
        Assert.assertTrue((boolean)matcher.hitEnd());
    }

    @Test
    public void testWhole() {
        StringReader reader = new StringReader(REGEX_DATA);
        ReaderCharSequence text = new ReaderCharSequence((Reader)reader);
        ReaderMatcher matcher = new ReaderMatcher(REGEX_WHOLE, (CharSequence)text);
        boolean found = matcher.find();
        Assert.assertTrue((boolean)found);
        Assert.assertEquals((Object)REGEX_DATA, (Object)matcher.group());
    }

    @Test
    public void testAlternative() {
        StringReader reader = new StringReader(REGEX_DATA);
        ReaderCharSequence text = new ReaderCharSequence((Reader)reader);
        ReaderMatcher matcher = new ReaderMatcher(REGEX_ALTERNATIVE, (CharSequence)text);
        boolean found = matcher.find();
        Assert.assertTrue((boolean)found);
        Assert.assertEquals((long)1L, (long)matcher.start());
        Assert.assertEquals((long)2L, (long)matcher.end());
        found = matcher.find();
        Assert.assertFalse((boolean)found);
    }

    @Test
    public void testLookingAt() {
        StringReader reader = new StringReader(REGEX_DATA);
        ReaderCharSequence text = new ReaderCharSequence((Reader)reader);
        ReaderMatcher matcher = new ReaderMatcher(REGEX_LOOKING_AT, (CharSequence)text);
        matcher.region(1, text.length());
        Assert.assertTrue((boolean)matcher.lookingAt());
        matcher.region(2, text.length());
        Assert.assertFalse((boolean)matcher.lookingAt());
    }
}

