/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.segment.util;

import junit.framework.TestCase;
import net.loomchild.segment.util.Util;

public class UtilTest
extends TestCase {
    public static final String QUOTED_PATTERN = "\\Q\\a\\Qaa\\\\Ebb\\Q\\E\\Qcc\\Edd";
    public static final String EXPECTED_UNQUOTED_PATTERN = "\\\\\\a\\\\\\Q\\a\\a\\\\bb\\c\\cdd";
    public static final String INFINITE_PATTERN = "a*b\\*\\\\+c+d\\+\\\\\\\\*e++f{1,4}+g{3,}+h{1}+\\Qa+\\E";
    public static final String EXPECTED_FINITE_PATTERN = "a{0,100}b\\*\\\\{1,100}c{1,100}d\\+\\\\\\\\{0,100}e{1,100}+f{1,4}+g{3,100}+h{1}+\\a\\+";
    public static final String CAPTURING_GROUPS_PATTERN = "(aa)\\(bb\\\\(cc(dd))ee(?:ff)\\Q()\\E";
    public static final String EXPECTED_NONCAPTURING_GROUPS_PATTERN = "(?:aa)\\(bb\\\\(?:cc(?:dd))ee(?:ff)\\(\\)";

    public void testRemoveBlockQuotes() {
        String unqotedPattern = Util.removeBlockQuotes((String)QUOTED_PATTERN);
        UtilTest.assertEquals((String)EXPECTED_UNQUOTED_PATTERN, (String)unqotedPattern);
    }

    public void testFinitize() {
        String finitePattern = Util.finitize((String)INFINITE_PATTERN, (int)100);
        UtilTest.assertEquals((String)EXPECTED_FINITE_PATTERN, (String)finitePattern);
    }

    public void testRemoveCapturingGroups() {
        String noncapturingGroupsPattern = Util.removeCapturingGroups((String)CAPTURING_GROUPS_PATTERN);
        UtilTest.assertEquals((String)EXPECTED_NONCAPTURING_GROUPS_PATTERN, (String)noncapturingGroupsPattern);
    }
}

