/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.segment.ui.console;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.loomchild.segment.TextIterator;
import net.loomchild.segment.srx.LanguageRule;
import net.loomchild.segment.srx.Rule;
import net.loomchild.segment.srx.SrxDocument;
import net.loomchild.segment.srx.SrxParser;
import net.loomchild.segment.srx.SrxTextIterator;
import net.loomchild.segment.srx.io.Srx2Parser;
import net.loomchild.segment.srx.io.Srx2SaxParser;
import net.loomchild.segment.srx.io.Srx2StaxParser;
import net.loomchild.segment.srx.io.SrxAnyParser;
import net.loomchild.segment.srx.io.SrxAnyTransformer;
import net.loomchild.segment.srx.legacy.AccurateSrxTextIterator;
import net.loomchild.segment.srx.legacy.FastTextIterator;
import net.loomchild.segment.srx.legacy.ScannerSrxTextIterator;
import net.loomchild.segment.util.NullWriter;
import net.loomchild.segment.util.Util;
import net.loomchild.segment.util.Version;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.notification.RunListener;

public class Segment {
    private static final Log log = LogFactory.getLog(Segment.class);
    public static final String DEFAULT_SRX = "net/loomchild/segment/res/xml/default.srx";
    public static final String EOLN;
    public static final String DEFAULT_BEGIN_SEGMENT = "";
    public static final String DEFAULT_END_SEGMENT;
    public static final int WORD_LENGTH = 2;
    public static final int SENTENCE_LENGTH = 5;
    public static final String TEST_SUITE_CLASS_NAME = "net.loomchild.segment.SegmentTestSuite";
    private Random random = new Random();
    private String text;
    private boolean stdinReader;
    private boolean stdoutWriter;

    public static void main(String[] args) {
        try {
            Segment main = new Segment();
            main.run(args);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void run(String[] args) throws Exception {
        Options options = this.createOptions();
        HelpFormatter helpFormatter = new HelpFormatter();
        PosixParser parser = new PosixParser();
        CommandLine commandLine = null;
        try {
            commandLine = parser.parse(options, args);
            if (commandLine.hasOption('h')) {
                this.printHelp(options, helpFormatter);
            } else if (commandLine.hasOption('z')) {
                this.test();
            } else if (commandLine.hasOption('t')) {
                this.transform(commandLine);
            } else if (commandLine.hasOption('c')) {
                this.sentenceSegment(commandLine);
            } else {
                this.segment(commandLine);
            }
        }
        catch (ParseException e) {
            this.printUsage(helpFormatter);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
        }
    }

    private void sentenceSegment(CommandLine commandLine) {
        Reader reader = null;
        InputStreamReader isr = new InputStreamReader(System.in);
        BufferedReader br = new BufferedReader(isr);
        try {
            SrxDocument document = this.createSrxDocument(commandLine, false);
            String sent = null;
            while ((sent = br.readLine()) != null) {
                if (DEFAULT_BEGIN_SEGMENT.equals(sent)) continue;
                this.text = sent;
                ArrayList segments = this.doSentenceSegment(commandLine, document, reader);
                String segments_json = new Gson().toJson((Object)segments);
                System.out.println(segments_json);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Segment.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private ArrayList doSentenceSegment(CommandLine commandLine, SrxDocument document, Reader reader) throws IOException {
        TextIterator textIterator = this.createTextIterator(commandLine, document, reader, false);
        ArrayList<String> segments = new ArrayList<String>();
        while (textIterator.hasNext()) {
            String segment = textIterator.next();
            if ((segment = segment.trim()).equals(DEFAULT_BEGIN_SEGMENT)) continue;
            segments.add(segment);
        }
        return segments;
    }

    private Options createOptions() {
        Options options = new Options();
        options.addOption("s", "srx", true, "SRX file.");
        options.addOption("l", "language", true, "Language code.");
        options.addOption("m", "map", true, "Map rule name in SRX 1.0.");
        options.addOption("b", "begin", true, "Output segment prefix.");
        options.addOption("e", "end", true, "Output segment suffix.");
        options.addOption("a", "algorithm", true, "Algorithm. Can be accurate, fast or ultimate (default).");
        options.addOption("d", "parser", true, "Parser. Can be sax, stax or jaxb (default).");
        options.addOption("i", "input", true, "Use given input file instead of standard input.");
        options.addOption("o", "output", true, "Use given output file instead of standard output.");
        options.addOption("t", "transform", false, "Convert old SRX to current version.");
        options.addOption("p", "profile", false, "Print profile information.");
        options.addOption("r", "preload", false, "Preload document into memory before segmentation.");
        options.addOption("2", "twice", false, "Repeat the whole process twice.");
        options.addOption("z", "test", false, "Test the application by running a test suite.");
        options.addOption(null, "lookbehind", true, "Maximum length of a regular expression construct that occurs in lookbehind. Default: 100.");
        options.addOption(null, "buffer-length", true, "Length of a buffer when reading text as a stream. Default: 1048576.");
        options.addOption(null, "margin", true, "If rule is matched but its position is in the margin (position > bufferLength - margin) then the matching is ignored. Default 128.");
        options.addOption(null, "generate-text", true, "Generate random input with given length in KB.");
        options.addOption(null, "generate-srx", true, "Generate random segmentation rules with given rule count and rule length separated by a comma.");
        options.addOption("h", "help", false, "Print this help.");
        options.addOption("c", "custom", false, "Custom sentence segmenter");
        return options;
    }

    private void printUsage(HelpFormatter helpFormatter) {
        System.out.println("Unknown command. Use segment -h for help.");
    }

    private void printHelp(Options options, HelpFormatter helpFormatter) {
        String signature = "Segment";
        if (Version.getInstance().getVersion() != null) {
            signature = signature + " " + Version.getInstance().getVersion();
        }
        if (Version.getInstance().getDate() != null) {
            signature = signature + ", " + Version.getInstance().getDate();
        }
        signature = signature + ".";
        System.out.println(signature);
        helpFormatter.printHelp("segment", options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void segment(CommandLine commandLine) throws IOException {
        Reader reader = null;
        Writer writer = null;
        try {
            boolean profile = commandLine.hasOption('p');
            boolean twice = commandLine.hasOption('2');
            boolean preload = commandLine.hasOption('r');
            if (twice && !profile) {
                throw new RuntimeException("Can only repeat segmentation twice in profile mode.");
            }
            reader = this.createTextReader(commandLine, profile, twice, preload);
            writer = this.createTextWriter(commandLine);
            if (preload) {
                this.preloadText(reader, profile);
            }
            SrxDocument document = this.createSrxDocument(commandLine, profile);
            this.createAndSegment(commandLine, document, reader, writer, profile);
            if (twice) {
                reader = this.createTextReader(commandLine, profile, twice, preload);
                this.createAndSegment(commandLine, document, reader, writer, profile);
            }
            this.cleanupReader(reader);
            this.cleanupWriter(writer);
        }
        catch (Throwable throwable) {
            this.cleanupReader(reader);
            this.cleanupWriter(writer);
            throw throwable;
        }
    }

    private void test() {
        JUnitCore core = new JUnitCore();
        core.addListener((RunListener)new TextListener(System.out));
        try {
            Class<?> klass = Class.forName(TEST_SUITE_CLASS_NAME);
            core.run(new Class[]{klass});
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to find test suite class: net.loomchild.segment.SegmentTestSuite. Check that you have tests JAR in your classpath.", e);
        }
    }

    private Reader createTextReader(CommandLine commandLine, boolean profile, boolean twice, boolean preload) throws IOException {
        Reader reader;
        if (commandLine.hasOption("generate-text")) {
            reader = this.createRandomTextReader(commandLine.getOptionValue("generate-text"), profile);
        } else if (commandLine.hasOption('i')) {
            reader = this.createFileReader(commandLine.getOptionValue('i'));
        } else {
            if (twice && !preload) {
                throw new RuntimeException("Cannot read standard input twice. Preload text (-r), provide an input file (-i) or generate input text (-x).");
            }
            reader = this.createStandardInputReader();
        }
        return reader;
    }

    private Reader createStandardInputReader() {
        Reader reader = Util.getReader((InputStream)System.in);
        this.stdinReader = true;
        return reader;
    }

    private Reader createFileReader(String fileName) throws IOException {
        FileInputStream inputStream = Util.getFileInputStream((String)fileName);
        Reader reader = Util.getReader((InputStream)inputStream);
        return reader;
    }

    private Reader createRandomTextReader(String generateTextOption, boolean profile) {
        if (this.text == null) {
            long start = System.currentTimeMillis();
            if (profile) {
                System.out.print("Generating text... ");
            }
            this.text = this.generateText(generateTextOption);
            if (profile) {
                System.out.println(System.currentTimeMillis() - start + " ms.");
            }
        }
        StringReader reader = new StringReader(this.text);
        return reader;
    }

    private String generateText(String generateTextOption) {
        int textLength = Integer.parseInt(generateTextOption);
        if (textLength < 1) {
            throw new RuntimeException("Text too short: " + textLength + "K.");
        }
        int wordCount = textLength * 1024 / 3;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < wordCount; ++i) {
            stringBuilder.append(' ');
            String word = this.generateWord(2);
            stringBuilder.append(word);
            if (i % 5 != 0) continue;
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }

    private String generateWord(int length) {
        StringBuilder word = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char character = this.generateCharacter();
            word.append(character);
        }
        return word.toString();
    }

    private char generateCharacter() {
        int character = this.random.nextInt(26) + 65;
        return (char)character;
    }

    private Writer createTextWriter(CommandLine commandLine) {
        Object writer = commandLine.hasOption('p') ? new NullWriter() : (commandLine.hasOption('o') ? this.createFileWriter(commandLine.getOptionValue('o')) : this.createStandardOutputWriter());
        return writer;
    }

    private Writer createStandardOutputWriter() {
        Writer writer = Util.getWriter((OutputStream)System.out);
        this.stdoutWriter = true;
        return writer;
    }

    private Writer createFileWriter(String fileName) {
        FileOutputStream outputStream = Util.getFileOutputStream((String)fileName);
        Writer writer = Util.getWriter((OutputStream)outputStream);
        return writer;
    }

    private SrxDocument createSrxDocument(CommandLine commandLine, boolean profile) throws IOException {
        SrxDocument document = commandLine.hasOption("generate-srx") ? this.generateSrxDocument(commandLine, profile) : this.readSrxDocument(commandLine, profile);
        return document;
    }

    private SrxDocument readSrxDocument(CommandLine commandLine, boolean profile) throws IOException {
        if (profile) {
            System.out.print("Reading rules... ");
        }
        long start = System.currentTimeMillis();
        String fileName = commandLine.getOptionValue('s');
        Reader srxReader = fileName != null ? Util.getReader((InputStream)Util.getFileInputStream((String)fileName)) : Util.getReader((InputStream)Util.getResourceStream((String)DEFAULT_SRX));
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        String mapRule = commandLine.getOptionValue('m');
        if (mapRule != null) {
            parameterMap.put("maprulename", mapRule);
        }
        if (parameterMap.size() > 0) {
            SrxAnyTransformer transformer = new SrxAnyTransformer();
            srxReader = transformer.transform(srxReader, parameterMap);
        }
        SrxParser srxParser = this.createParser(commandLine, profile);
        SrxDocument document = srxParser.parse(srxReader);
        srxReader.close();
        if (profile) {
            System.out.println(System.currentTimeMillis() - start + " ms.");
        }
        return document;
    }

    private SrxParser createParser(CommandLine commandLine, boolean profile) {
        Srx2Parser srxParser;
        Parser parser = Parser.jaxb;
        String parserString = commandLine.getOptionValue('d');
        if (parserString != null) {
            parser = Parser.valueOf(parserString);
        }
        switch (parser) {
            case jaxb: {
                srxParser = new Srx2Parser();
                break;
            }
            case sax: {
                srxParser = new Srx2SaxParser();
                break;
            }
            case stax: {
                srxParser = new Srx2StaxParser();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown parser: " + (Object)((Object)parser) + ".");
            }
        }
        srxParser = new SrxAnyParser((SrxParser)srxParser);
        return srxParser;
    }

    private SrxDocument generateSrxDocument(CommandLine commandLine, boolean profile) {
        if (profile) {
            System.out.print("Generating rules... ");
        }
        long start = System.currentTimeMillis();
        String generateSrxOption = commandLine.getOptionValue("generate-srx");
        String[] parts = generateSrxOption.split(",");
        if (parts.length != 2) {
            throw new RuntimeException("Cannot parse rule count and length.");
        }
        int ruleCount = Integer.parseInt(parts[0]);
        if (ruleCount < 0) {
            throw new RuntimeException("Rule count must be positive: " + ruleCount + ".");
        }
        int ruleLength = Integer.parseInt(parts[1]);
        if (ruleLength < 1) {
            throw new RuntimeException("Rule length must be greater or equal to one: " + ruleCount + ".");
        }
        SrxDocument srxDocument = new SrxDocument();
        LanguageRule languageRule = this.generateLanguageRule(ruleCount, ruleLength);
        srxDocument.addLanguageMap(".*", languageRule);
        if (profile) {
            System.out.println(System.currentTimeMillis() - start + " ms.");
        }
        return srxDocument;
    }

    private LanguageRule generateLanguageRule(int ruleCount, int ruleLenght) {
        LanguageRule languageRule = new LanguageRule(DEFAULT_BEGIN_SEGMENT);
        for (int i = 0; i < ruleCount; ++i) {
            Rule rule = this.generateRule(ruleLenght);
            languageRule.addRule(rule);
        }
        languageRule.addRule(new Rule(true, "\\.", " "));
        return languageRule;
    }

    private Rule generateRule(int length) {
        StringBuilder regex = new StringBuilder();
        regex.append('(');
        for (int i = 0; i < length; ++i) {
            String word = this.generateWord(2);
            regex.append(word);
            if (i == length - 1) continue;
            regex.append('|');
        }
        regex.append(')');
        Rule rule = new Rule(false, regex + "\\.", " ");
        return rule;
    }

    private void createAndSegment(CommandLine commandLine, SrxDocument document, Reader reader, Writer writer, boolean profile) throws IOException {
        if (profile) {
            System.out.println("Segmenting... ");
        }
        long start = System.currentTimeMillis();
        TextIterator textIterator = this.createTextIterator(commandLine, document, reader, profile);
        this.performSegment(commandLine, textIterator, writer, profile);
        if (profile) {
            System.out.println(System.currentTimeMillis() - start + " ms.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TextIterator createTextIterator(CommandLine commandLine, SrxDocument document, Reader reader, boolean profile) {
        AccurateSrxTextIterator textIterator;
        String languageCode = commandLine.getOptionValue('l');
        if (languageCode == null) {
            languageCode = DEFAULT_BEGIN_SEGMENT;
        }
        String algorithmString = commandLine.getOptionValue('a');
        Algorithm algorithm = Algorithm.ultimate;
        if (algorithmString != null) {
            algorithm = Algorithm.valueOf(algorithmString);
        }
        HashMap<String, Integer> parameterMap = new HashMap<String, Integer>();
        if (commandLine.hasOption("lookbehind")) {
            if (algorithm != Algorithm.ultimate && algorithm != Algorithm.fast) {
                throw new IllegalArgumentException("--lookbehind parameter can be only used with ultimate or fast algorithm.");
            }
            parameterMap.put("maxLookbehindConstructLength", Integer.parseInt(commandLine.getOptionValue("lookbehind")));
        }
        if (commandLine.hasOption("buffer-length")) {
            if (commandLine.hasOption('r')) {
                throw new IllegalArgumentException("--buffer-length can be only used when reading text from a stream (--preload option not allowed).");
            }
            parameterMap.put("bufferLength", Integer.parseInt(commandLine.getOptionValue("buffer-length")));
        }
        if (commandLine.hasOption("margin")) {
            if (algorithm != Algorithm.ultimate) {
                throw new IllegalArgumentException("--margin parameter can be only used with ultimate algorithm.");
            }
            parameterMap.put("margin", Integer.parseInt(commandLine.getOptionValue("margin")));
        }
        if (profile) {
            System.out.print("    Creating text iterator... ");
        }
        long start = System.currentTimeMillis();
        if (algorithm == Algorithm.accurate) {
            if (this.text == null) throw new IllegalArgumentException("For accurate algorithm preload option (-r) is mandatory.");
            textIterator = new AccurateSrxTextIterator(document, languageCode, (CharSequence)this.text);
        } else if (algorithm == Algorithm.ultimate) {
            textIterator = this.text != null ? new SrxTextIterator(document, languageCode, (CharSequence)this.text, parameterMap) : new SrxTextIterator(document, languageCode, reader, parameterMap);
        } else if (algorithm == Algorithm.fast) {
            textIterator = this.text != null ? new FastTextIterator(document, languageCode, (CharSequence)this.text, parameterMap) : new FastTextIterator(document, languageCode, reader, parameterMap);
        } else {
            if (algorithm != Algorithm.scanner) throw new IllegalArgumentException("Unknown algorithm: " + (Object)((Object)algorithm) + ".");
            textIterator = this.text != null ? new ScannerSrxTextIterator(document, languageCode, this.text, parameterMap) : new ScannerSrxTextIterator(document, languageCode, reader, parameterMap);
        }
        if (!profile) return textIterator;
        System.out.println(System.currentTimeMillis() - start + " ms.");
        return textIterator;
    }

    private void performSegment(CommandLine commandLine, TextIterator textIterator, Writer writer, boolean profile) throws IOException {
        String endSegment;
        String beginSegment = commandLine.getOptionValue('b');
        if (beginSegment == null) {
            beginSegment = DEFAULT_BEGIN_SEGMENT;
        }
        if ((endSegment = commandLine.getOptionValue('e')) == null) {
            endSegment = DEFAULT_END_SEGMENT;
        }
        if (profile) {
            System.out.print("    Performing segmentation... ");
        }
        long start = System.currentTimeMillis();
        while (textIterator.hasNext()) {
            String segment = textIterator.next();
            writer.write(beginSegment);
            writer.write(segment.trim());
            writer.write(endSegment);
        }
        if (profile) {
            System.out.println(System.currentTimeMillis() - start + " ms.");
        }
    }

    private String preloadText(Reader reader, boolean profile) {
        if (this.text == null) {
            if (profile) {
                System.out.print("Preloading text... ");
            }
            long start = System.currentTimeMillis();
            this.text = Util.readAll((Reader)reader);
            if (profile) {
                System.out.println(System.currentTimeMillis() - start + " ms.");
            }
        }
        return this.text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transform(CommandLine commandLine) throws IOException {
        Reader reader = commandLine.hasOption('i') ? this.createFileReader(commandLine.getOptionValue('i')) : this.createStandardInputReader();
        Writer writer = commandLine.hasOption('o') ? this.createFileWriter(commandLine.getOptionValue('o')) : this.createStandardOutputWriter();
        String mapRule = commandLine.getOptionValue("m");
        try {
            SrxAnyTransformer transformer = new SrxAnyTransformer();
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            if (mapRule != null) {
                parameterMap.put("maprulename", mapRule);
            }
            transformer.transform(reader, writer, parameterMap);
        }
        finally {
            this.cleanupReader(reader);
            this.cleanupWriter(writer);
        }
    }

    private void cleanupReader(Reader reader) {
        try {
            if (reader != null && !this.stdinReader) {
                reader.close();
            }
        }
        catch (IOException e) {
            log.error((Object)"Error cleaning up reader.", (Throwable)e);
        }
    }

    private void cleanupWriter(Writer writer) {
        try {
            if (writer != null) {
                writer.flush();
                if (!this.stdoutWriter) {
                    writer.close();
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"Error cleaning up writer.", (Throwable)e);
        }
    }

    static {
        DEFAULT_END_SEGMENT = EOLN = System.getProperty("line.separator");
    }

    private static enum Parser {
        jaxb,
        sax,
        stax;

    }

    private static enum Algorithm {
        accurate,
        fast,
        ultimate,
        scanner;

    }
}

