import { Construct } from 'constructs';
export interface HugoDeployProps {
    /**
     * Path to Hugo public directory, which is generated after running the `hugo` command
     *
     * By default, this will be the `public` directory in your hugo project
     */
    readonly publicDir: string;
    /**
     * Domain name of the site deploying to
     *
     * You should already have a hosted zone in the account you're deploying to with this domain name
     */
    readonly domainName: string;
    /**
     * Region deploying to
     *
     * @default - us-east-1
     */
    readonly region?: string;
}
export declare class HugoDeploy extends Construct {
    readonly publicDir: string;
    readonly domainName: string;
    readonly region?: string;
    constructor(scope: Construct, id: string, props: HugoDeployProps);
}
