# rbf-otp

    RobotFramework tools provided by QA team

## Documentation
    https://packaging.python.org/en/latest/tutorials/packaging-projects/ 

## Configuration .pypirc 
    File in ~/.pypirc
    https://packaging.python.org/en/latest/specifications/pypirc/
    https://python-packaging.readthedocs.io/en/latest/dependencies.html

## Packaging
### Prerequisite (first install)
    Configure python virtual env
    - python -m venv .venv
    Activate pyhton virtual env
    - .venv\Scripts\activate
    Update pip
    - %CD%\.venv\Scripts\python.exe -m pip install --upgrade pip
    Install/Update setuptools
    - pip install --upgrade setuptools
    Intall build package
    - pip install --upgrade build
    Install twine package
    - pip install --upgrade twine

#### Intall package associated to the tools
    Need by biuldOTP.py (repository: https://pypi.org/project/pyotp/)
    - pip install pyotp==2.6.0
#### Save the packages installed
    pip freeze > requirements.txt

#### Prerequisite (clone from git)
    pip install -r requirements

### Build the package
    Change version in files:
        - setup.cfg
        - setup.py
    Remove files or Directory
        - rm -rf dist/*
        - rm -rf 
    Environment variable should not set
        - http_proxy
        - https_proxy
        - ftp_proxy
    Build the package
        - python -m build
    Will create files .tar.gz and .whl in ./dist directory

### Upload package
    In current terminal define proxy your proxy
        - set proxy=http://[username]:[password]@[proxy machine]:[port]
        - set http_proxy=%proxy%
        - set https_proxy=%proxy%
        - set ftp_proxy=%proxy%

    Execute commande
    - python -m twine upload --repository pypi dist/*
    Or
    - twine upload --repository pypi dist/*

### pip installation
    pip install rbf-otp==0.1.0

### pdm installation
    pdm add --save-exact rbf-otp==0.1.0

## Project configuration

### Use library in robot file.
    Add the library in robot file
    - Library   rbf_otp

    Use the library in robot file
    - ${GENERATE_KEY} Get Otp ${SECRET}

    ${SECRET} is extract from the QR Code as follow:
    QR Code as URI => otpauth://[URL]?secret=[SECRET]&issuer=[TEXTE]
    Extract [SECRET] and use it in statement of your robot file
    - ${SECRET} [SECRET]

    ${GENERATE_KEY} is the variable with the 6 digits code generated.

## Update Version
    Update files:
    - pyproject.toml
    - setup.cfg
    - setup.py

## Documentation
    https://towardsdatascience.com/setuptools-python-571e7d5500f2
### Setuptools Keywords
    For file setup.py
    https://setuptools.pypa.io/en/latest/references/keywords.html
### File: setup.cfg
    Is an ini file containing option defaults for setup.py commands.



