"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import abc
import google.protobuf.empty_pb2
import grpc
import ...thirdparty.kfpbackend.pipeline_pb2

class PipelineServiceStub:
    def __init__(self, channel: grpc.Channel) -> None: ...
    CreatePipeline: grpc.UnaryUnaryMultiCallable[
        thirdparty.kfpbackend.pipeline_pb2.CreatePipelineRequest,
        thirdparty.kfpbackend.pipeline_pb2.Pipeline]
    """Creates a pipeline."""

    GetPipeline: grpc.UnaryUnaryMultiCallable[
        thirdparty.kfpbackend.pipeline_pb2.GetPipelineRequest,
        thirdparty.kfpbackend.pipeline_pb2.Pipeline]
    """Finds a specific pipeline by ID."""

    GetPipelineByName: grpc.UnaryUnaryMultiCallable[
        thirdparty.kfpbackend.pipeline_pb2.GetPipelineByNameRequest,
        thirdparty.kfpbackend.pipeline_pb2.Pipeline]
    """
    Finds a pipeline by Name (and namespace)
    """

    ListPipelines: grpc.UnaryUnaryMultiCallable[
        thirdparty.kfpbackend.pipeline_pb2.ListPipelinesRequest,
        thirdparty.kfpbackend.pipeline_pb2.ListPipelinesResponse]
    """Finds all pipelines."""

    DeletePipeline: grpc.UnaryUnaryMultiCallable[
        thirdparty.kfpbackend.pipeline_pb2.DeletePipelineRequest,
        google.protobuf.empty_pb2.Empty]
    """Deletes a pipeline and its pipeline versions."""

    GetTemplate: grpc.UnaryUnaryMultiCallable[
        thirdparty.kfpbackend.pipeline_pb2.GetTemplateRequest,
        thirdparty.kfpbackend.pipeline_pb2.GetTemplateResponse]
    """Returns a single YAML template that contains the description, parameters, and metadata associated with the pipeline provided."""

    CreatePipelineVersion: grpc.UnaryUnaryMultiCallable[
        thirdparty.kfpbackend.pipeline_pb2.CreatePipelineVersionRequest,
        thirdparty.kfpbackend.pipeline_pb2.PipelineVersion]
    """Adds a pipeline version to the specified pipeline."""

    GetPipelineVersion: grpc.UnaryUnaryMultiCallable[
        thirdparty.kfpbackend.pipeline_pb2.GetPipelineVersionRequest,
        thirdparty.kfpbackend.pipeline_pb2.PipelineVersion]
    """Gets a pipeline version by pipeline version ID."""

    ListPipelineVersions: grpc.UnaryUnaryMultiCallable[
        thirdparty.kfpbackend.pipeline_pb2.ListPipelineVersionsRequest,
        thirdparty.kfpbackend.pipeline_pb2.ListPipelineVersionsResponse]
    """Lists all pipeline versions of a given pipeline."""

    DeletePipelineVersion: grpc.UnaryUnaryMultiCallable[
        thirdparty.kfpbackend.pipeline_pb2.DeletePipelineVersionRequest,
        google.protobuf.empty_pb2.Empty]
    """Deletes a pipeline version by pipeline version ID. If the deleted pipeline
    version is the default pipeline version, the pipeline's default version
    changes to the pipeline's most recent pipeline version. If there are no
    remaining pipeline versions, the pipeline will have no default version.
    Examines the run_service_api.ipynb notebook to learn more about creating a
    run using a pipeline version (https://github.com/kubeflow/pipelines/blob/master/tools/benchmarks/run_service_api.ipynb).
    """

    GetPipelineVersionTemplate: grpc.UnaryUnaryMultiCallable[
        thirdparty.kfpbackend.pipeline_pb2.GetPipelineVersionTemplateRequest,
        thirdparty.kfpbackend.pipeline_pb2.GetTemplateResponse]
    """Returns a YAML template that contains the specified pipeline version's description, parameters and metadata."""

    UpdatePipelineDefaultVersion: grpc.UnaryUnaryMultiCallable[
        thirdparty.kfpbackend.pipeline_pb2.UpdatePipelineDefaultVersionRequest,
        google.protobuf.empty_pb2.Empty]
    """Update the default pipeline version of a specific pipeline."""


class PipelineServiceServicer(metaclass=abc.ABCMeta):
    @abc.abstractmethod
    def CreatePipeline(self,
        request: thirdparty.kfpbackend.pipeline_pb2.CreatePipelineRequest,
        context: grpc.ServicerContext,
    ) -> thirdparty.kfpbackend.pipeline_pb2.Pipeline:
        """Creates a pipeline."""
        pass

    @abc.abstractmethod
    def GetPipeline(self,
        request: thirdparty.kfpbackend.pipeline_pb2.GetPipelineRequest,
        context: grpc.ServicerContext,
    ) -> thirdparty.kfpbackend.pipeline_pb2.Pipeline:
        """Finds a specific pipeline by ID."""
        pass

    @abc.abstractmethod
    def GetPipelineByName(self,
        request: thirdparty.kfpbackend.pipeline_pb2.GetPipelineByNameRequest,
        context: grpc.ServicerContext,
    ) -> thirdparty.kfpbackend.pipeline_pb2.Pipeline:
        """
        Finds a pipeline by Name (and namespace)
        """
        pass

    @abc.abstractmethod
    def ListPipelines(self,
        request: thirdparty.kfpbackend.pipeline_pb2.ListPipelinesRequest,
        context: grpc.ServicerContext,
    ) -> thirdparty.kfpbackend.pipeline_pb2.ListPipelinesResponse:
        """Finds all pipelines."""
        pass

    @abc.abstractmethod
    def DeletePipeline(self,
        request: thirdparty.kfpbackend.pipeline_pb2.DeletePipelineRequest,
        context: grpc.ServicerContext,
    ) -> google.protobuf.empty_pb2.Empty:
        """Deletes a pipeline and its pipeline versions."""
        pass

    @abc.abstractmethod
    def GetTemplate(self,
        request: thirdparty.kfpbackend.pipeline_pb2.GetTemplateRequest,
        context: grpc.ServicerContext,
    ) -> thirdparty.kfpbackend.pipeline_pb2.GetTemplateResponse:
        """Returns a single YAML template that contains the description, parameters, and metadata associated with the pipeline provided."""
        pass

    @abc.abstractmethod
    def CreatePipelineVersion(self,
        request: thirdparty.kfpbackend.pipeline_pb2.CreatePipelineVersionRequest,
        context: grpc.ServicerContext,
    ) -> thirdparty.kfpbackend.pipeline_pb2.PipelineVersion:
        """Adds a pipeline version to the specified pipeline."""
        pass

    @abc.abstractmethod
    def GetPipelineVersion(self,
        request: thirdparty.kfpbackend.pipeline_pb2.GetPipelineVersionRequest,
        context: grpc.ServicerContext,
    ) -> thirdparty.kfpbackend.pipeline_pb2.PipelineVersion:
        """Gets a pipeline version by pipeline version ID."""
        pass

    @abc.abstractmethod
    def ListPipelineVersions(self,
        request: thirdparty.kfpbackend.pipeline_pb2.ListPipelineVersionsRequest,
        context: grpc.ServicerContext,
    ) -> thirdparty.kfpbackend.pipeline_pb2.ListPipelineVersionsResponse:
        """Lists all pipeline versions of a given pipeline."""
        pass

    @abc.abstractmethod
    def DeletePipelineVersion(self,
        request: thirdparty.kfpbackend.pipeline_pb2.DeletePipelineVersionRequest,
        context: grpc.ServicerContext,
    ) -> google.protobuf.empty_pb2.Empty:
        """Deletes a pipeline version by pipeline version ID. If the deleted pipeline
        version is the default pipeline version, the pipeline's default version
        changes to the pipeline's most recent pipeline version. If there are no
        remaining pipeline versions, the pipeline will have no default version.
        Examines the run_service_api.ipynb notebook to learn more about creating a
        run using a pipeline version (https://github.com/kubeflow/pipelines/blob/master/tools/benchmarks/run_service_api.ipynb).
        """
        pass

    @abc.abstractmethod
    def GetPipelineVersionTemplate(self,
        request: thirdparty.kfpbackend.pipeline_pb2.GetPipelineVersionTemplateRequest,
        context: grpc.ServicerContext,
    ) -> thirdparty.kfpbackend.pipeline_pb2.GetTemplateResponse:
        """Returns a YAML template that contains the specified pipeline version's description, parameters and metadata."""
        pass

    @abc.abstractmethod
    def UpdatePipelineDefaultVersion(self,
        request: thirdparty.kfpbackend.pipeline_pb2.UpdatePipelineDefaultVersionRequest,
        context: grpc.ServicerContext,
    ) -> google.protobuf.empty_pb2.Empty:
        """Update the default pipeline version of a specific pipeline."""
        pass


def add_PipelineServiceServicer_to_server(servicer: PipelineServiceServicer, server: grpc.Server) -> None: ...
