"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import ...thirdparty.kfpbackend.pipeline_spec_pb2
import ...thirdparty.kfpbackend.resource_reference_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class CreateRunRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    RUN_FIELD_NUMBER: builtins.int
    @property
    def run(self) -> global___Run: ...
    def __init__(self,
        *,
        run: typing.Optional[global___Run] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["run",b"run"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["run",b"run"]) -> None: ...
global___CreateRunRequest = CreateRunRequest

class GetRunRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    RUN_ID_FIELD_NUMBER: builtins.int
    run_id: typing.Text
    """The ID of the run to be retrieved."""

    def __init__(self,
        *,
        run_id: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["run_id",b"run_id"]) -> None: ...
global___GetRunRequest = GetRunRequest

class ListRunsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    SORT_BY_FIELD_NUMBER: builtins.int
    RESOURCE_REFERENCE_KEY_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    page_token: typing.Text
    """A page token to request the next page of results. The token is acquried
    from the nextPageToken field of the response from the previous
    ListRuns call or can be omitted when fetching the first page.
    """

    page_size: builtins.int
    """The number of runs to be listed per page. If there are more runs than this
    number, the response message will contain a nextPageToken field you can use
    to fetch the next page.
    """

    sort_by: typing.Text
    """Can be format of "field_name", "field_name asc" or "field_name desc"
    (Example, "name asc" or "id desc"). Ascending by default.
    """

    @property
    def resource_reference_key(self) -> thirdparty.kfpbackend.resource_reference_pb2.ResourceKey:
        """What resource reference to filter on.
        E.g. If listing run for an experiment, the query string would be
        resource_reference_key.type=EXPERIMENT&resource_reference_key.id=123
        """
        pass
    filter: typing.Text
    """A url-encoded, JSON-serialized Filter protocol buffer (see
    [filter.proto](https://github.com/kubeflow/pipelines/blob/master/backend/api/filter.proto)).
    """

    def __init__(self,
        *,
        page_token: typing.Text = ...,
        page_size: builtins.int = ...,
        sort_by: typing.Text = ...,
        resource_reference_key: typing.Optional[thirdparty.kfpbackend.resource_reference_pb2.ResourceKey] = ...,
        filter: typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["resource_reference_key",b"resource_reference_key"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["filter",b"filter","page_size",b"page_size","page_token",b"page_token","resource_reference_key",b"resource_reference_key","sort_by",b"sort_by"]) -> None: ...
global___ListRunsRequest = ListRunsRequest

class TerminateRunRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    RUN_ID_FIELD_NUMBER: builtins.int
    run_id: typing.Text
    """The ID of the run to be terminated."""

    def __init__(self,
        *,
        run_id: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["run_id",b"run_id"]) -> None: ...
global___TerminateRunRequest = TerminateRunRequest

class RetryRunRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    RUN_ID_FIELD_NUMBER: builtins.int
    run_id: typing.Text
    """The ID of the run to be retried."""

    def __init__(self,
        *,
        run_id: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["run_id",b"run_id"]) -> None: ...
global___RetryRunRequest = RetryRunRequest

class ListRunsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    RUNS_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    @property
    def runs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Run]: ...
    total_size: builtins.int
    """The total number of runs for the given query."""

    next_page_token: typing.Text
    """The token to list the next page of runs."""

    def __init__(self,
        *,
        runs: typing.Optional[typing.Iterable[global___Run]] = ...,
        total_size: builtins.int = ...,
        next_page_token: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token",b"next_page_token","runs",b"runs","total_size",b"total_size"]) -> None: ...
global___ListRunsResponse = ListRunsResponse

class ArchiveRunRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    id: typing.Text
    """The ID of the run to be archived."""

    def __init__(self,
        *,
        id: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id",b"id"]) -> None: ...
global___ArchiveRunRequest = ArchiveRunRequest

class UnarchiveRunRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    id: typing.Text
    """The ID of the run to be restored."""

    def __init__(self,
        *,
        id: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id",b"id"]) -> None: ...
global___UnarchiveRunRequest = UnarchiveRunRequest

class DeleteRunRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    id: typing.Text
    """The ID of the run to be deleted."""

    def __init__(self,
        *,
        id: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id",b"id"]) -> None: ...
global___DeleteRunRequest = DeleteRunRequest

class Run(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _StorageState:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _StorageStateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Run._StorageState.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STORAGESTATE_AVAILABLE: Run._StorageState.ValueType  # 0
        STORAGESTATE_ARCHIVED: Run._StorageState.ValueType  # 1
    class StorageState(_StorageState, metaclass=_StorageStateEnumTypeWrapper):
        pass

    STORAGESTATE_AVAILABLE: Run.StorageState.ValueType  # 0
    STORAGESTATE_ARCHIVED: Run.StorageState.ValueType  # 1

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    STORAGE_STATE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    PIPELINE_SPEC_FIELD_NUMBER: builtins.int
    RESOURCE_REFERENCES_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    SCHEDULED_AT_FIELD_NUMBER: builtins.int
    FINISHED_AT_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    METRICS_FIELD_NUMBER: builtins.int
    id: typing.Text
    """Output. Unique run ID. Generated by API server."""

    name: typing.Text
    """Required input field. Name provided by user,
    or auto generated if run is created by scheduled job. Not unique.
    """

    storage_state: global___Run.StorageState.ValueType
    """Output. Specify whether this run is in archived or available mode."""

    description: typing.Text
    """Optional input field. Describing the purpose of the run"""

    @property
    def pipeline_spec(self) -> thirdparty.kfpbackend.pipeline_spec_pb2.PipelineSpec:
        """Required input field.
        Describing what the pipeline manifest and parameters to use for the run.
        """
        pass
    @property
    def resource_references(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[thirdparty.kfpbackend.resource_reference_pb2.ResourceReference]:
        """Optional input field. Specify which resource this run belongs to.
        When creating a run from a particular pipeline version, the pipeline
        version can be specified here.
        """
        pass
    service_account: typing.Text
    """Optional input field. Specify which Kubernetes service account this run uses."""

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Output. The time that the run created."""
        pass
    @property
    def scheduled_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Output. When this run is scheduled to run. This could be different from
        created_at. For example, if a run is from a backfilling job that was
        supposed to run 2 month ago, the scheduled_at is 2 month ago,
        v.s. created_at is the current time.
        """
        pass
    @property
    def finished_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Output. The time this run is finished."""
        pass
    status: typing.Text
    """Output. The status of the run.
    One of [Pending, Running, Succeeded, Skipped, Failed, Error]
    """

    error: typing.Text
    """In case any error happens retrieving a run field, only run ID
    and the error message is returned. Client has the flexibility of choosing
    how to handle error. This is especially useful during listing call.
    """

    @property
    def metrics(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RunMetric]:
        """Output. The metrics of the run. The metrics are reported by ReportMetrics
        API.
        """
        pass
    def __init__(self,
        *,
        id: typing.Text = ...,
        name: typing.Text = ...,
        storage_state: global___Run.StorageState.ValueType = ...,
        description: typing.Text = ...,
        pipeline_spec: typing.Optional[thirdparty.kfpbackend.pipeline_spec_pb2.PipelineSpec] = ...,
        resource_references: typing.Optional[typing.Iterable[thirdparty.kfpbackend.resource_reference_pb2.ResourceReference]] = ...,
        service_account: typing.Text = ...,
        created_at: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        scheduled_at: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        finished_at: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        status: typing.Text = ...,
        error: typing.Text = ...,
        metrics: typing.Optional[typing.Iterable[global___RunMetric]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["created_at",b"created_at","finished_at",b"finished_at","pipeline_spec",b"pipeline_spec","scheduled_at",b"scheduled_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["created_at",b"created_at","description",b"description","error",b"error","finished_at",b"finished_at","id",b"id","metrics",b"metrics","name",b"name","pipeline_spec",b"pipeline_spec","resource_references",b"resource_references","scheduled_at",b"scheduled_at","service_account",b"service_account","status",b"status","storage_state",b"storage_state"]) -> None: ...
global___Run = Run

class PipelineRuntime(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PIPELINE_MANIFEST_FIELD_NUMBER: builtins.int
    WORKFLOW_MANIFEST_FIELD_NUMBER: builtins.int
    pipeline_manifest: typing.Text
    """Output. The runtime JSON manifest of the pipeline, including the status
    of pipeline steps and fields need for UI visualization etc.
    """

    workflow_manifest: typing.Text
    """Output. The runtime JSON manifest of the argo workflow.
    This is deprecated after pipeline_runtime_manifest is in use.
    """

    def __init__(self,
        *,
        pipeline_manifest: typing.Text = ...,
        workflow_manifest: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline_manifest",b"pipeline_manifest","workflow_manifest",b"workflow_manifest"]) -> None: ...
global___PipelineRuntime = PipelineRuntime

class RunDetail(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    RUN_FIELD_NUMBER: builtins.int
    PIPELINE_RUNTIME_FIELD_NUMBER: builtins.int
    @property
    def run(self) -> global___Run: ...
    @property
    def pipeline_runtime(self) -> global___PipelineRuntime: ...
    def __init__(self,
        *,
        run: typing.Optional[global___Run] = ...,
        pipeline_runtime: typing.Optional[global___PipelineRuntime] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline_runtime",b"pipeline_runtime","run",b"run"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline_runtime",b"pipeline_runtime","run",b"run"]) -> None: ...
global___RunDetail = RunDetail

class RunMetric(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _Format:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _FormatEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[RunMetric._Format.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNSPECIFIED: RunMetric._Format.ValueType  # 0
        """Default value if not present."""

        RAW: RunMetric._Format.ValueType  # 1
        """Display value as its raw format."""

        PERCENTAGE: RunMetric._Format.ValueType  # 2
        """Display value in percentage format."""

    class Format(_Format, metaclass=_FormatEnumTypeWrapper):
        pass

    UNSPECIFIED: RunMetric.Format.ValueType  # 0
    """Default value if not present."""

    RAW: RunMetric.Format.ValueType  # 1
    """Display value as its raw format."""

    PERCENTAGE: RunMetric.Format.ValueType  # 2
    """Display value in percentage format."""


    NAME_FIELD_NUMBER: builtins.int
    NODE_ID_FIELD_NUMBER: builtins.int
    NUMBER_VALUE_FIELD_NUMBER: builtins.int
    FORMAT_FIELD_NUMBER: builtins.int
    name: typing.Text
    """Required. The user defined name of the metric. It must between 1 and 63
    characters long and must conform to the following regular expression:
    `[a-z]([-a-z0-9]*[a-z0-9])?`.
    """

    node_id: typing.Text
    """Required. The runtime node ID which reports the metric. The node ID can be
    found in the RunDetail.workflow.Status. Metric with same (node_id, name)
    are considerd as duplicate. Only the first reporting will be recorded. Max
    length is 128.
    """

    number_value: builtins.float
    """The number value of the metric."""

    format: global___RunMetric.Format.ValueType
    """The display format of metric."""

    def __init__(self,
        *,
        name: typing.Text = ...,
        node_id: typing.Text = ...,
        number_value: builtins.float = ...,
        format: global___RunMetric.Format.ValueType = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["number_value",b"number_value","value",b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["format",b"format","name",b"name","node_id",b"node_id","number_value",b"number_value","value",b"value"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["value",b"value"]) -> typing.Optional[typing_extensions.Literal["number_value"]]: ...
global___RunMetric = RunMetric

class ReportRunMetricsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    RUN_ID_FIELD_NUMBER: builtins.int
    METRICS_FIELD_NUMBER: builtins.int
    run_id: typing.Text
    """Required. The parent run ID of the metric."""

    @property
    def metrics(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RunMetric]:
        """List of metrics to report."""
        pass
    def __init__(self,
        *,
        run_id: typing.Text = ...,
        metrics: typing.Optional[typing.Iterable[global___RunMetric]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["metrics",b"metrics","run_id",b"run_id"]) -> None: ...
global___ReportRunMetricsRequest = ReportRunMetricsRequest

class ReportRunMetricsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class ReportRunMetricResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        class _Status:
            ValueType = typing.NewType('ValueType', builtins.int)
            V: typing_extensions.TypeAlias = ValueType
        class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ReportRunMetricsResponse.ReportRunMetricResult._Status.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            UNSPECIFIED: ReportRunMetricsResponse.ReportRunMetricResult._Status.ValueType  # 0
            """Default value if not present."""

            OK: ReportRunMetricsResponse.ReportRunMetricResult._Status.ValueType  # 1
            """Indicates successful reporting."""

            INVALID_ARGUMENT: ReportRunMetricsResponse.ReportRunMetricResult._Status.ValueType  # 2
            """Indicates that the payload of the metric is invalid."""

            DUPLICATE_REPORTING: ReportRunMetricsResponse.ReportRunMetricResult._Status.ValueType  # 3
            """Indicates that the metric has been reported before."""

            INTERNAL_ERROR: ReportRunMetricsResponse.ReportRunMetricResult._Status.ValueType  # 4
            """Indicates that something went wrong in the server."""

        class Status(_Status, metaclass=_StatusEnumTypeWrapper):
            pass

        UNSPECIFIED: ReportRunMetricsResponse.ReportRunMetricResult.Status.ValueType  # 0
        """Default value if not present."""

        OK: ReportRunMetricsResponse.ReportRunMetricResult.Status.ValueType  # 1
        """Indicates successful reporting."""

        INVALID_ARGUMENT: ReportRunMetricsResponse.ReportRunMetricResult.Status.ValueType  # 2
        """Indicates that the payload of the metric is invalid."""

        DUPLICATE_REPORTING: ReportRunMetricsResponse.ReportRunMetricResult.Status.ValueType  # 3
        """Indicates that the metric has been reported before."""

        INTERNAL_ERROR: ReportRunMetricsResponse.ReportRunMetricResult.Status.ValueType  # 4
        """Indicates that something went wrong in the server."""


        METRIC_NAME_FIELD_NUMBER: builtins.int
        METRIC_NODE_ID_FIELD_NUMBER: builtins.int
        STATUS_FIELD_NUMBER: builtins.int
        MESSAGE_FIELD_NUMBER: builtins.int
        metric_name: typing.Text
        """Output. The name of the metric."""

        metric_node_id: typing.Text
        """Output. The ID of the node which reports the metric."""

        status: global___ReportRunMetricsResponse.ReportRunMetricResult.Status.ValueType
        """Output. The status of the metric reporting."""

        message: typing.Text
        """Output. The detailed message of the error of the reporting."""

        def __init__(self,
            *,
            metric_name: typing.Text = ...,
            metric_node_id: typing.Text = ...,
            status: global___ReportRunMetricsResponse.ReportRunMetricResult.Status.ValueType = ...,
            message: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["message",b"message","metric_name",b"metric_name","metric_node_id",b"metric_node_id","status",b"status"]) -> None: ...

    RESULTS_FIELD_NUMBER: builtins.int
    @property
    def results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ReportRunMetricsResponse.ReportRunMetricResult]: ...
    def __init__(self,
        *,
        results: typing.Optional[typing.Iterable[global___ReportRunMetricsResponse.ReportRunMetricResult]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["results",b"results"]) -> None: ...
global___ReportRunMetricsResponse = ReportRunMetricsResponse

class ReadArtifactRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    RUN_ID_FIELD_NUMBER: builtins.int
    NODE_ID_FIELD_NUMBER: builtins.int
    ARTIFACT_NAME_FIELD_NUMBER: builtins.int
    run_id: typing.Text
    """The ID of the run."""

    node_id: typing.Text
    """The ID of the running node."""

    artifact_name: typing.Text
    """The name of the artifact."""

    def __init__(self,
        *,
        run_id: typing.Text = ...,
        node_id: typing.Text = ...,
        artifact_name: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["artifact_name",b"artifact_name","node_id",b"node_id","run_id",b"run_id"]) -> None: ...
global___ReadArtifactRequest = ReadArtifactRequest

class ReadArtifactResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    DATA_FIELD_NUMBER: builtins.int
    data: builtins.bytes
    """The bytes of the artifact content."""

    def __init__(self,
        *,
        data: builtins.bytes = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["data",b"data"]) -> None: ...
global___ReadArtifactResponse = ReadArtifactResponse
