# SPDX-FileCopyrightText: 2025 David ML Brown Jr
#
# SPDX-License-Identifier: MIT
"""Pin definitions for the Banana Pi P2 Pro."""

from adafruit_blinka.microcontroller.rockchip.rk3308 import pin

# GPIO Pin Definitions
GPIO2_A5 = pin.GPIO2_A5  # pin 5
GPIO0_C1 = pin.GPIO0_C1  # pin 6
GPIO2_A6 = pin.GPIO2_A6  # pin 7
GPIO2_A7 = pin.GPIO2_A7  # pin 8
GPIO2_A4 = pin.GPIO2_A4  # pin 9
GPIO2_B0 = pin.GPIO2_B0  # pin 10
GPIO2_B1 = pin.GPIO2_B1  # pin 11
GPIO2_B5 = pin.GPIO2_B5  # pin 12
GPIO2_B2 = pin.GPIO2_B2  # pin 13
GPIO2_B6 = pin.GPIO2_B6  # pin 14
GPIO2_B3 = pin.GPIO2_B3  # pin 15
GPIO2_B7 = pin.GPIO2_B7  # pin 16
GPIO2_B4 = pin.GPIO2_B4  # pin 17
GPIO2_C0 = pin.GPIO2_C0  # pin 18

I2S0_SCLK_TX = GPIO2_A5
SPDIF_TX = GPIO0_C1
I2S0_8CH_RX = GPIO2_A6
PDM_CLK = GPIO2_A6
I2S0_LRCK_TX = GPIO2_A7
I2S0_8CH_MCLK = GPIO2_A4
I2S0_MCLK = GPIO2_A4
I2S0_LRCK_RX = GPIO2_B0
I2S0_SDO0 = GPIO2_B1
PDM_SDI0 = GPIO2_B5
I2S0_SDO1 = GPIO2_B2
PDM_SDI1 = GPIO2_B6
I2S0_SDO2 = GPIO2_B3
PDM_SDI2 = GPIO2_B7
I2S0_SDO3 = GPIO2_B4
PDM_SDI3 = GPIO2_C0

# 12 pin board header GPIO
GPIO2_A1 = pin.GPIO2_A1  # pin 1
GPIO0_B3 = pin.GPIO0_B3  # pin 2
GPIO2_A0 = pin.GPIO2_A0  # pin 3
GPIO0_B4 = pin.GPIO0_B4  # pin 4
GPIO1_D1 = pin.GPIO1_D1  # pin 5
# Pin 6 is VCC IO
GPIO1_D0 = pin.GPIO1_D0  # pin 7
# Pin 8 is GND
GPIO1_C7 = pin.GPIO1_C7  # pin 9
GPIO0_B7 = pin.GPIO0_B7  # pin 10
GPIO1_C6 = pin.GPIO1_C6  # pin 11
GPIO0_C0 = pin.GPIO0_C0  # pin 12

SPI0_TX = GPIO2_A1
UART0_TX = GPIO2_A1
I2C1_SDA = GPIO0_B3
SPI0_RX = GPIO2_A0
UART0_RX = GPIO2_A0
I2C1_SCL = GPIO0_B4
UART1_TX = GPIO1_D1
I2C0_SCL = GPIO1_D1
SPI2_CS = GPIO1_D1
UART1_TX = GPIO1_D0
I2C0_SDA = GPIO1_D0
SPI2_CLK = GPIO1_D0
SPI2_TX = GPIO1_C7
UART2_TX_M0 = GPIO1_C7
JTAG_TMS = GPIO1_C7
PWM2 = GPIO0_B7
I2C3_SDA = GPIO0_B7
SPI2_RX = GPIO1_C6
UART2_RX_M0 = GPIO1_C6
JTAG_TCK = GPIO1_C6
PWM3 = GPIO0_C0
IR_RX = GPIO0_C0
