# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['redis_benchmarks_specification',
 'redis_benchmarks_specification.__api__',
 'redis_benchmarks_specification.__builder__',
 'redis_benchmarks_specification.__cli__',
 'redis_benchmarks_specification.__common__',
 'redis_benchmarks_specification.__self_contained_coordinator__',
 'redis_benchmarks_specification.__setups__',
 'redis_benchmarks_specification.__watchdog__']

package_data = \
{'': ['*'],
 'redis_benchmarks_specification': ['setups/builders/*',
                                    'setups/platforms/*',
                                    'setups/topologies/*',
                                    'test-suites/*']}

install_requires = \
['Flask-HTTPAuth>=4.4.0,<5.0.0',
 'Flask>=2.0.1,<3.0.0',
 'GitPython>=3.1.20,<4.0.0',
 'PyGithub>=1.55,<2.0',
 'PyYAML>=5.4.1,<6.0.0',
 'Werkzeug>=2.0.1,<3.0.0',
 'argparse>=1.4.0,<2.0.0',
 'docker>=5.0.0,<6.0.0',
 'flask-restx>=0.5.0,<0.6.0',
 'marshmallow>=3.12.2,<4.0.0',
 'node-semver>=0.8.1,<0.9.0',
 'psutil>=5.8.0,<6.0.0',
 'redis>=3.5.3,<4.0.0',
 'redisbench-admin>=0.5.27,<0.6.0',
 'redistimeseries==1.4.3',
 'semver>=2.13.0,<3.0.0',
 'tox-docker>=3.1.0,<4.0.0',
 'typed-ast>=1.5.0,<2.0.0']

entry_points = \
{'console_scripts': ['redis-benchmarks-spec-api = '
                     'redis_benchmarks_specification.__api__.api:main',
                     'redis-benchmarks-spec-builder = '
                     'redis_benchmarks_specification.__builder__.builder:main',
                     'redis-benchmarks-spec-cli = '
                     'redis_benchmarks_specification.__cli__.cli:main',
                     'redis-benchmarks-spec-sc-coordinator = '
                     'redis_benchmarks_specification.__self_contained_coordinator__.self_contained_coordinator:main',
                     'redis-benchmarks-spec-watchdog = '
                     'redis_benchmarks_specification.__watchdog__.watchdog:main']}

setup_kwargs = {
    'name': 'redis-benchmarks-specification',
    'version': '0.1.18',
    'description': 'The Redis benchmarks specification describes the cross-language/tools requirements and expectations to foster performance and observability standards around redis related technologies. Members from both industry and academia, including organizations and individuals are encouraged to contribute.',
    'long_description': '\n[![codecov](https://codecov.io/gh/redis/redis-benchmarks-specification/branch/main/graph/badge.svg?token=GS64MV1H4W)](https://codecov.io/gh/redis/redis-benchmarks-specification)\n[![CI tests](https://github.com/redis/redis-benchmarks-specification/actions/workflows/tox.yml/badge.svg)](https://github.com/redis/redis-benchmarks-specification/actions/workflows/tox.yml)\n[![PyPI version](https://badge.fury.io/py/redis-benchmarks-specification.svg)](https://pypi.org/project/redis-benchmarks-specification)\n\n## Installation\n\nTo have access to the latest SPEC and Tooling impletamtion you only need to install one python package.\n\nInstallation is done using pip, the package installer for Python, in the following manner:\n\n```bash\npython3 -m pip install redis-benchmarks-specification --ignore-installed PyYAML\n```\n\n\n## Benchmark specifications goal\n\nThe Redis benchmarks specification describes the cross-language/tools requirements and expectations to foster performance and observability standards around redis related technologies. \n\nMembers from both industry and academia, including organizations and individuals are encouraged to contribute. \n\nCurrently, the following members actively support this project:\n\n- [Redis Ltd.](https://redis.com/) via the Redis Performance Group: providing steady-stable infrastructure platform to run the benchmark suite. Supporting the active development of this project within the company.\n\n\n## Scope \n\nThis repo aims to provide Redis related benchmark standards and methodologies for:\n\n- Management of benchmark data and specifications across different setups\n\n- Running benchmarks and recording results\n\n- Exporting performance results in several formats (CSV, RedisTimeSeries, JSON)\n\n- **[SOON]** Finding on-cpu, off-cpu, io, and threading performance problems by attaching profiling tools/probers ( perf (a.k.a. perf_events), bpf tooling, vtune )\n\n- **[SOON]** Finding performance problems by attaching telemetry probes\n\nCurrent supported benchmark tools:\n\n- [redis-benchmark](https://github.com/redis/redis)\n- [memtier_benchmark](https://github.com/RedisLabs/memtier_benchmark)\n- [SOON][redis-benchmark-go](https://github.com/filipecosta90/redis-benchmark-go)\n\n\n## Installing Redis benchmarks specification implementations\n\nThe Redis benchmarks specification and implementations is developed for Unix and is actively tested on it.\n\nInstallation is done using pip, the package installer for Python, in the following manner:\n\n```bash\npython3 -m pip install redis-benchmarks-specification\n```\n\n## Architecture diagram\n\n```                                                                                    \n                                                                                      \n                                                                                      \n┌──────────────────────────────────────┐                                              \n│1) gh.com/redis/redis update          │                                              \n│   - git_repo: github.com/redis/redis │                                              \n│   - git_hash: 459c3a                 │                                              \n│   - git_branch: unstable             │                                              \n└─────────────────┬────────────────────┘                                              \n                  │                                                                   \n                  │      ┌───────────────────────────────────┐                        \n                  │      │HTTP POST                          │                        \n                  └──────┤<domain>/api/gh/redis/redis/commit │──┐                     \n                         └───────────────────────────────────┘  │                     \n                                                                │                     \n                                                                ▼                     \n                                          ┌──────────────────────────────────────────┐\n                                          │2) api                                    │\n                                          │  - Converts the HTTP info into an stream │\n                                          │entry                                     │\n                                          │  - XADD stream:redis:redis:commit <...>  │\n                                          │                                          │\n                                          └─────────────────────┬────────────────────┘\n                                                                │                     \n                                                                │                     \n                                                                │                     \n                                                                │ ┌────┐              \n                    .─────────────────────────────────────.     │ │push│              \n        ┌─────┐ ┌ ▶(  2.1 ) stream of build events         )◀───┘ └────┘              \n        │pull │     `─────────────────────────────────────\'                           \n        └─────┘ │                                                                     \n                                                                                      \n                │                       ┌────────────────────────────────────────────┐\n                 ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─│2.2) build_agent                            │\n                                        │   - based on setup platforms               │\n                                        │   - build different required redis         │\n                                        │artifacts                                   │\n                                        └───────────────────────┬────────────────────┘\n                                                                │                     \n                                                                │                     \n                                                                │ ┌────┐              \n                   .─────────────────────────────────────.      │ │push│              \n        ┌─────┐ ─▶(   2.3 ) stream of artifact benchmarks )◀────┘ └────┘              \n        │pull ││   `─────────────────────────────────────\'                            \n        └─────┘                                                                       \n               │                                                                      \n                                        ┌────────────────────────────────────────────┐\n               │                        │                                            │\n                                        │3) benchmark_coordinator                    │\n               │                        │   - based on test-suites and setups:       │\n                                        │      - Trigger env setup                   │\n               └ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─│      - 3.1 ) Trigger topology setup        │\n                                        │      - 3.2 ) Run benchmarks                │\n                                        │      - Record results into datasinks       │\n                                        │                                            │\n                                        └────────────────────────────────────────────┘\n```                                              \n\nIn a very brief description, github.com/redis/redis upstream changes trigger an HTTP API call containing the\nrelevant git information. \n\nThe HTTP request is then converted into an event ( tracked within redis ) that will trigger multiple build variants requests based upon the distinct platforms described in [`platforms`](redis_benchmarks_specification/setups/platforms/). \n\nAs soon as a new build variant request is received, the build agent ([`redis-benchmarks-spec-builder`](https://github.com/filipecosta90/redis-benchmarks-specification/tree/main/redis_benchmarks_specification/__builder__/)) \nprepares the artifact(s) and proceeds into adding an artifact benchmark event so that the benchmark coordinator ([`redis-benchmarks-spec-sc-coordinator`](https://github.com/filipecosta90/redis-benchmarks-specification/tree/main/redis_benchmarks_specification/__self_contained_coordinator__/))  can deploy/manage the required infrastructure and DB topologies, run the benchmark, and export the performance results.\n## Directory layout\n\n### Specifications \n\n  The following is a high level status report for currently available specs.\n\n* `redis_benchmarks_specification`\n  * [`test-suites`](https://github.com/filipecosta90/redis-benchmarks-specification/tree/main/redis_benchmarks_specification/test-suites/): contains the benchmark suites definitions, specifying the target redis topology, the tested commands, the benchmark utility to use (the client), and if required the preloading dataset steps.\n  \n* `redis_benchmarks_specification/setups`\n  * [`platforms`](https://github.com/filipecosta90/redis-benchmarks-specification/tree/main/redis_benchmarks_specification/setups/platforms/): contains the standard platforms considered to provide steady stable results, and to represent common deployment targets.\n  * [`topologies`](https://github.com/filipecosta90/redis-benchmarks-specification/tree/main/redis_benchmarks_specification/setups/topologies/): contains the standard deployment topologies definition with the associated minimum specs to enable the topology definition.\n  * [`builders`](https://github.com/filipecosta90/redis-benchmarks-specification/tree/main/redis_benchmarks_specification/setups/builders/): contains the build environment variations, that enable to build Redis with different compilers, compiler flags, libraries, etc...\n\n### Spec tool implementations\n\n  The following is a high level status report for currently available spec implementations.\n\n* **STATUS: Experimental** [`redis-benchmarks-spec-api`](https://github.com/filipecosta90/redis-benchmarks-specification/tree/main/redis_benchmarks_specification/__api__/) : contains the API that translates the POST HTTP request that was triggered by github.com/redis/redis upstream changes, and fetches the relevant git/source info and coverts it into an event ( tracked within redis ).\n\n* **STATUS: Experimental** [`redis-benchmarks-spec-builder`](https://github.com/filipecosta90/redis-benchmarks-specification/tree/main/redis_benchmarks_specification/__builder__/): contains the benchmark build agent utility that receives an event indicating a new build variant, generates the required redis binaries to test, and triggers the benchmark run on the listening agents.\n* **STATUS: Experimental** [`redis-benchmarks-spec-sc-coordinator`](https://github.com/filipecosta90/redis-benchmarks-specification/tree/main/redis_benchmarks_specification/__self_contained_coordinator__/): contains the coordinator utility that listens for benchmark suite run requests and setups the required steps to spin the actual benchmark topologies and to trigger the actual benchmarks.\n\n\n## Contributing guidelines\n\n### Adding new test suites\n\nTBD\n\n### Adding new topologies\n\nTBD\n\n### Joining the performance initiative and adding a continuous benchmark platform\n\n#### Joining the performance initiative \nIn order to join the performance initiative the only requirement is that you provide a steady-stable infrastructure \nplatform to run the benchmark suites, and you reach out to one of the Redis Performance Initiative member via \n`performance <at> redis <dot> com` so that we can provide you with the required secrets to actively listen for benchmark events.\n\nIf you check the above "Architecture diagram", this means you only need to run the last moving part of the arch, meaning you will have\none or more benchmark coordinator machines actively running benchmarks and pushing the results back to our datasink.\n\n#### Adding a continuous benchmark platform\n\nIn order to be able to run the benchmarks on the platform you need pip installer for python3, and docker.\nApart from it, we recommend you manage the `redis-benchmarks-spec-sc-coordinator` process(es) state via a process monitoring tool like \nsupervisorctl, lauchd, daemon tools, or other. \n\nFor this example we relly uppon `supervisorctl` for process managing.\n\n##### Installing package requirements\n\n```bash\n# install pip installer for python3\nsudo apt install python3-pip -y\nsudo pip3 install --upgrade pip\n\n# install docker\nsudo apt install docker.io -y\n\n# install supervisord \nsudo apt install supervisor -y\n\n# install benchmark specs\npython3 -m pip install redis-benchmarks-specification --ignore-installed PyYAML\n```\n\n\n##### Testing out redis-benchmarks-spec-sc-coordinator\n\nYou should now be able to print the following installed benchmark runner help:\n\n```bash\n$ redis-benchmarks-spec-sc-coordinator -h\nusage: redis-benchmarks-spec-sc-coordinator [-h] --event_stream_host\n                                            EVENT_STREAM_HOST\n                                            --event_stream_port\n                                            EVENT_STREAM_PORT\n                                            --event_stream_pass\n                                            EVENT_STREAM_PASS\n                                            --event_stream_user\n                                            EVENT_STREAM_USER\n                                            [--cpu-count CPU_COUNT]\n                                            [--platform-name PLATFORM_NAME]\n                                            [--logname LOGNAME]\n                                            [--consumer-start-id CONSUMER_START_ID]\n                                            [--setups-folder SETUPS_FOLDER]\n                                            [--test-suites-folder TEST_SUITES_FOLDER]\n                                            [--datasink_redistimeseries_host DATASINK_REDISTIMESERIES_HOST]\n                                            [--datasink_redistimeseries_port DATASINK_REDISTIMESERIES_PORT]\n                                            [--datasink_redistimeseries_pass DATASINK_REDISTIMESERIES_PASS]\n                                            [--datasink_redistimeseries_user DATASINK_REDISTIMESERIES_USER]\n                                            [--datasink_push_results_redistimeseries]\n\nredis-benchmarks-spec runner(self-contained) 0.1.13\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --event_stream_host EVENT_STREAM_HOST\n  --event_stream_port EVENT_STREAM_PORT\n  --event_stream_pass EVENT_STREAM_PASS\n  --event_stream_user EVENT_STREAM_USER\n  --cpu-count CPU_COUNT\n                        Specify how much of the available CPU resources the\n                        coordinator can use. (default: 8)\n  --platform-name PLATFORM_NAME\n                        Specify the running platform name. By default it will\n                        use the machine name. (default: fco-ThinkPad-T490)\n  --logname LOGNAME     logname to write the logs to (default: None)\n  --consumer-start-id CONSUMER_START_ID\n  --setups-folder SETUPS_FOLDER\n                        Setups folder, containing the build environment\n                        variations sub-folder that we use to trigger different\n                        build artifacts (default: /home/fco/redislabs/redis-\n                        benchmarks-\n                        specification/redis_benchmarks_specification/setups)\n  --test-suites-folder TEST_SUITES_FOLDER\n                        Test suites folder, containing the different test\n                        variations (default: /home/fco/redislabs/redis-\n                        benchmarks-\n                        specification/redis_benchmarks_specification/test-\n                        suites)\n  --datasink_redistimeseries_host DATASINK_REDISTIMESERIES_HOST\n  --datasink_redistimeseries_port DATASINK_REDISTIMESERIES_PORT\n  --datasink_redistimeseries_pass DATASINK_REDISTIMESERIES_PASS\n  --datasink_redistimeseries_user DATASINK_REDISTIMESERIES_USER\n  --datasink_push_results_redistimeseries\n                        uploads the results to RedisTimeSeries. Proper\n                        credentials are required (default: False)\n```\n\nNote that the minimum arguments to run the benchmark coordinator are: `--event_stream_host`, `--event_stream_port`, `--event_stream_pass`, `--event_stream_user`\nYou should use the provided credentials to be able to access the event streams.\nApart from it, you will need to discuss with the Performance Group the unique platform name that will be used to showcase results, coordinate work, among other thigs.\n\nIf all runs accordingly you should see the following sample log when you run the tool with the credentials:\n\n```bash\n$ poetry run redis-benchmarks-spec-sc-coordinator --platform-name example-platform \\\n                                                  --event_stream_host <...> \\\n                                                  --event_stream_port <...> \\\n                                                  --event_stream_pass <...> \\\n                                                  --event_stream_user <...>\n2021-09-22 10:47:12 INFO redis-benchmarks-spec runner(self-contained) 0.1.13\n2021-09-22 10:47:12 INFO Using topologies folder dir /home/fco/redislabs/redis-benchmarks-specification/redis_benchmarks_specification/setups/topologies\n2021-09-22 10:47:12 INFO Reading topologies specifications from: /home/fco/redislabs/redis-benchmarks-specification/redis_benchmarks_specification/setups/topologies/topologies.yml\n2021-09-22 10:47:12 INFO Using test-suites folder dir /home/fco/redislabs/redis-benchmarks-specification/redis_benchmarks_specification/test-suites\n2021-09-22 10:47:12 INFO Running all specified benchmarks: /home/fco/redislabs/redis-benchmarks-specification/redis_benchmarks_specification/test-suites/redis-benchmark-full-suite-1Mkeys-100B.yml\n2021-09-22 10:47:12 INFO There are a total of 1 test-suites in folder /home/fco/redislabs/redis-benchmarks-specification/redis_benchmarks_specification/test-suites\n2021-09-22 10:47:12 INFO Reading event streams from: <...>:<...> with user <...>\n2021-09-22 10:47:12 INFO checking build spec requirements\n2021-09-22 10:47:12 INFO Will use consumer group named runners-cg:redis/redis/commits-example-platform.\n2021-09-22 10:47:12 INFO Created consumer group named runners-cg:redis/redis/commits-example-platform to distribute work.\n2021-09-22 10:47:12 INFO Entering blocking read waiting for work.\n```\n\nYou\'re now actively listening for benchmarks requests to Redis!\n\n##### Adding redis-benchmarks-spec-sc-coordinator to supervisord\n\nLet\'s add a supervisord entry as follow\n```\nvi /etc/supervisor/conf.d/redis-benchmarks-spec-sc-coordinator-1.conf\n```\nYou can use the following template and update according to your credentials:\n\n```bash\n[supervisord]\nloglevel = debug\n\n[program:redis-benchmarks-spec-sc-coordinator]\ncommand = redis-benchmarks-spec-sc-coordinator --platform-name bicx02 \\\n                                                  --event_stream_host <...> \\\n                                                  --event_stream_port <...> \\\n                                                  --event_stream_pass <...> \\\n                                                  --event_stream_user <...> \\\n                                                  --datasink_push_results_redistimeseries \\\n                                                  --datasink_redistimeseries_host <...> \\\n                                                  --datasink_redistimeseries_port <...> \\\n                                                  --datasink_redistimeseries_pass <...> \\\n                                                  --logname /var/opt/redis-benchmarks-spec-sc-coordinator-1.log\nstartsecs = 0\nautorestart = true\nstartretries = 1\n```\n\nAfter editing the conf, you just need to reload and confirm that the benchmark runner is active:\n\n```bash\n:~# supervisorctl reload\nRestarted supervisord\n:~# supervisorctl status\nredis-benchmarks-spec-sc-coordinator   RUNNING   pid 27842, uptime 0:00:00\n```\n\n\n## License\n\nredis-benchmark-specifications is distributed under the Apache 2 license - see [LICENSE](LICENSE)',
    'author': 'filipecosta90',
    'author_email': 'filipecosta.90@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
