# Copyright 2019 Fortinet, Inc.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Ansible.  If not, see <https://www.gnu.org/licenses/>.

# Make coding more python3-ish
from __future__ import (absolute_import, division, print_function)
__metaclass__ = type

import os
import json
import pytest
from mock import ANY
from ansible.module_utils.network.fortios.fortios import FortiOSHandler

try:
    from ansible.modules.network.fortios import fortios_wireless_controller_vap
except ImportError:
    pytest.skip("Could not load required modules for testing", allow_module_level=True)


@pytest.fixture(autouse=True)
def connection_mock(mocker):
    connection_class_mock = mocker.patch('ansible.modules.network.fortios.fortios_wireless_controller_vap.Connection')
    return connection_class_mock


fos_instance = FortiOSHandler(connection_mock)


def test_wireless_controller_vap_creation(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'success', 'http_method': 'POST', 'http_status': 200}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'wireless_controller_vap': {
            'acct_interim_interval': '3',
            'alias': 'test_value_4',
            'auth': 'psk',
            'broadcast_ssid': 'enable',
            'broadcast_suppression': 'dhcp-up',
            'captive_portal_ac_name': 'test_value_8',
            'captive_portal_macauth_radius_secret': 'test_value_9',
            'captive_portal_macauth_radius_server': 'test_value_10',
            'captive_portal_radius_secret': 'test_value_11',
            'captive_portal_radius_server': 'test_value_12',
            'captive_portal_session_timeout_interval': '13',
            'dhcp_lease_time': '14',
            'dhcp_option82_circuit_id_insertion': 'style-1',
            'dhcp_option82_insertion': 'enable',
            'dhcp_option82_remote_id_insertion': 'style-1',
            'dynamic_vlan': 'enable',
            'eap_reauth': 'enable',
            'eap_reauth_intv': '20',
            'eapol_key_retries': 'disable',
            'encrypt': 'TKIP',
            'external_fast_roaming': 'enable',
            'external_logout': 'test_value_24',
            'external_web': 'test_value_25',
            'fast_bss_transition': 'disable',
            'fast_roaming': 'enable',
            'ft_mobility_domain': '28',
            'ft_over_ds': 'disable',
            'ft_r0_key_lifetime': '30',
            'gtk_rekey': 'enable',
            'gtk_rekey_intv': '32',
            'hotspot20_profile': 'test_value_33',
            'intra_vap_privacy': 'enable',
            'ip': 'test_value_35',
            'key': 'test_value_36',
            'keyindex': '37',
            'ldpc': 'disable',
            'local_authentication': 'enable',
            'local_bridging': 'enable',
            'local_lan': 'allow',
            'local_standalone': 'enable',
            'local_standalone_nat': 'enable',
            'mac_auth_bypass': 'enable',
            'mac_filter': 'enable',
            'mac_filter_policy_other': 'allow',
            'max_clients': '47',
            'max_clients_ap': '48',
            'me_disable_thresh': '49',
            'mesh_backhaul': 'enable',
            'mpsk': 'enable',
            'mpsk_concurrent_clients': '52',
            'multicast_enhance': 'enable',
            'multicast_rate': '0',
            'name': 'default_name_55',
            'okc': 'disable',
            'passphrase': 'test_value_57',
            'pmf': 'disable',
            'pmf_assoc_comeback_timeout': '59',
            'pmf_sa_query_retry_timeout': '60',
            'portal_message_override_group': 'test_value_61',
            'portal_type': 'auth',
            'probe_resp_suppression': 'enable',
            'probe_resp_threshold': 'test_value_64',
            'ptk_rekey': 'enable',
            'ptk_rekey_intv': '66',
            'qos_profile': 'test_value_67',
            'quarantine': 'enable',
            'radio_2g_threshold': 'test_value_69',
            'radio_5g_threshold': 'test_value_70',
            'radio_sensitivity': 'enable',
            'radius_mac_auth': 'enable',
            'radius_mac_auth_server': 'test_value_73',
            'radius_server': 'test_value_74',
            'rates_11a': '1',
            'rates_11ac_ss12': 'mcs0/1',
            'rates_11ac_ss34': 'mcs0/3',
            'rates_11bg': '1',
            'rates_11n_ss12': 'mcs0/1',
            'rates_11n_ss34': 'mcs16/3',
            'schedule': 'test_value_81',
            'security': 'open',
            'security_exempt_list': 'test_value_83',
            'security_obsolete_option': 'enable',
            'security_redirect_url': 'test_value_85',
            'split_tunneling': 'enable',
            'ssid': 'test_value_87',
            'tkip_counter_measure': 'enable',
            'utm_profile': 'test_value_89',
            'vdom': 'test_value_90',
            'vlan_auto': 'enable',
            'vlan_pooling': 'wtp-group',
            'vlanid': '93',
            'voice_enterprise': 'disable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_wireless_controller_vap.fortios_wireless_controller(input_data, fos_instance)

    expected_data = {
        'acct-interim-interval': '3',
        'alias': 'test_value_4',
        'auth': 'psk',
                'broadcast-ssid': 'enable',
                'broadcast-suppression': 'dhcp-up',
                'captive-portal-ac-name': 'test_value_8',
                'captive-portal-macauth-radius-secret': 'test_value_9',
                'captive-portal-macauth-radius-server': 'test_value_10',
                'captive-portal-radius-secret': 'test_value_11',
                'captive-portal-radius-server': 'test_value_12',
                'captive-portal-session-timeout-interval': '13',
                'dhcp-lease-time': '14',
                'dhcp-option82-circuit-id-insertion': 'style-1',
                'dhcp-option82-insertion': 'enable',
                'dhcp-option82-remote-id-insertion': 'style-1',
                'dynamic-vlan': 'enable',
                'eap-reauth': 'enable',
                'eap-reauth-intv': '20',
                'eapol-key-retries': 'disable',
                'encrypt': 'TKIP',
                'external-fast-roaming': 'enable',
                'external-logout': 'test_value_24',
                'external-web': 'test_value_25',
                'fast-bss-transition': 'disable',
                'fast-roaming': 'enable',
                'ft-mobility-domain': '28',
                'ft-over-ds': 'disable',
                'ft-r0-key-lifetime': '30',
                'gtk-rekey': 'enable',
                'gtk-rekey-intv': '32',
                'hotspot20-profile': 'test_value_33',
                'intra-vap-privacy': 'enable',
                'ip': 'test_value_35',
                'key': 'test_value_36',
                'keyindex': '37',
                'ldpc': 'disable',
                'local-authentication': 'enable',
                'local-bridging': 'enable',
                'local-lan': 'allow',
                'local-standalone': 'enable',
                'local-standalone-nat': 'enable',
                'mac-auth-bypass': 'enable',
                'mac-filter': 'enable',
                'mac-filter-policy-other': 'allow',
                'max-clients': '47',
                'max-clients-ap': '48',
                'me-disable-thresh': '49',
                'mesh-backhaul': 'enable',
                'mpsk': 'enable',
                'mpsk-concurrent-clients': '52',
                'multicast-enhance': 'enable',
                'multicast-rate': '0',
                'name': 'default_name_55',
                'okc': 'disable',
                'passphrase': 'test_value_57',
                'pmf': 'disable',
                'pmf-assoc-comeback-timeout': '59',
                'pmf-sa-query-retry-timeout': '60',
                'portal-message-override-group': 'test_value_61',
                'portal-type': 'auth',
                'probe-resp-suppression': 'enable',
                'probe-resp-threshold': 'test_value_64',
                'ptk-rekey': 'enable',
                'ptk-rekey-intv': '66',
                'qos-profile': 'test_value_67',
                'quarantine': 'enable',
                'radio-2g-threshold': 'test_value_69',
                'radio-5g-threshold': 'test_value_70',
                'radio-sensitivity': 'enable',
                'radius-mac-auth': 'enable',
                'radius-mac-auth-server': 'test_value_73',
                'radius-server': 'test_value_74',
                'rates-11a': '1',
                'rates-11ac-ss12': 'mcs0/1',
                'rates-11ac-ss34': 'mcs0/3',
                'rates-11bg': '1',
                'rates-11n-ss12': 'mcs0/1',
                'rates-11n-ss34': 'mcs16/3',
                'schedule': 'test_value_81',
                'security': 'open',
                'security-exempt-list': 'test_value_83',
                'security-obsolete-option': 'enable',
                'security-redirect-url': 'test_value_85',
                'split-tunneling': 'enable',
                'ssid': 'test_value_87',
                'tkip-counter-measure': 'enable',
                'utm-profile': 'test_value_89',
                'vdom': 'test_value_90',
                'vlan-auto': 'enable',
                'vlan-pooling': 'wtp-group',
                'vlanid': '93',
                'voice-enterprise': 'disable'
    }

    set_method_mock.assert_called_with('wireless-controller', 'vap', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert changed
    assert response['status'] == 'success'
    assert response['http_status'] == 200


def test_wireless_controller_vap_creation_fails(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'error', 'http_method': 'POST', 'http_status': 500}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'wireless_controller_vap': {
            'acct_interim_interval': '3',
            'alias': 'test_value_4',
            'auth': 'psk',
            'broadcast_ssid': 'enable',
            'broadcast_suppression': 'dhcp-up',
            'captive_portal_ac_name': 'test_value_8',
            'captive_portal_macauth_radius_secret': 'test_value_9',
            'captive_portal_macauth_radius_server': 'test_value_10',
            'captive_portal_radius_secret': 'test_value_11',
            'captive_portal_radius_server': 'test_value_12',
            'captive_portal_session_timeout_interval': '13',
            'dhcp_lease_time': '14',
            'dhcp_option82_circuit_id_insertion': 'style-1',
            'dhcp_option82_insertion': 'enable',
            'dhcp_option82_remote_id_insertion': 'style-1',
            'dynamic_vlan': 'enable',
            'eap_reauth': 'enable',
            'eap_reauth_intv': '20',
            'eapol_key_retries': 'disable',
            'encrypt': 'TKIP',
            'external_fast_roaming': 'enable',
            'external_logout': 'test_value_24',
            'external_web': 'test_value_25',
            'fast_bss_transition': 'disable',
            'fast_roaming': 'enable',
            'ft_mobility_domain': '28',
            'ft_over_ds': 'disable',
            'ft_r0_key_lifetime': '30',
            'gtk_rekey': 'enable',
            'gtk_rekey_intv': '32',
            'hotspot20_profile': 'test_value_33',
            'intra_vap_privacy': 'enable',
            'ip': 'test_value_35',
            'key': 'test_value_36',
            'keyindex': '37',
            'ldpc': 'disable',
            'local_authentication': 'enable',
            'local_bridging': 'enable',
            'local_lan': 'allow',
            'local_standalone': 'enable',
            'local_standalone_nat': 'enable',
            'mac_auth_bypass': 'enable',
            'mac_filter': 'enable',
            'mac_filter_policy_other': 'allow',
            'max_clients': '47',
            'max_clients_ap': '48',
            'me_disable_thresh': '49',
            'mesh_backhaul': 'enable',
            'mpsk': 'enable',
            'mpsk_concurrent_clients': '52',
            'multicast_enhance': 'enable',
            'multicast_rate': '0',
            'name': 'default_name_55',
            'okc': 'disable',
            'passphrase': 'test_value_57',
            'pmf': 'disable',
            'pmf_assoc_comeback_timeout': '59',
            'pmf_sa_query_retry_timeout': '60',
            'portal_message_override_group': 'test_value_61',
            'portal_type': 'auth',
            'probe_resp_suppression': 'enable',
            'probe_resp_threshold': 'test_value_64',
            'ptk_rekey': 'enable',
            'ptk_rekey_intv': '66',
            'qos_profile': 'test_value_67',
            'quarantine': 'enable',
            'radio_2g_threshold': 'test_value_69',
            'radio_5g_threshold': 'test_value_70',
            'radio_sensitivity': 'enable',
            'radius_mac_auth': 'enable',
            'radius_mac_auth_server': 'test_value_73',
            'radius_server': 'test_value_74',
            'rates_11a': '1',
            'rates_11ac_ss12': 'mcs0/1',
            'rates_11ac_ss34': 'mcs0/3',
            'rates_11bg': '1',
            'rates_11n_ss12': 'mcs0/1',
            'rates_11n_ss34': 'mcs16/3',
            'schedule': 'test_value_81',
            'security': 'open',
            'security_exempt_list': 'test_value_83',
            'security_obsolete_option': 'enable',
            'security_redirect_url': 'test_value_85',
            'split_tunneling': 'enable',
            'ssid': 'test_value_87',
            'tkip_counter_measure': 'enable',
            'utm_profile': 'test_value_89',
            'vdom': 'test_value_90',
            'vlan_auto': 'enable',
            'vlan_pooling': 'wtp-group',
            'vlanid': '93',
            'voice_enterprise': 'disable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_wireless_controller_vap.fortios_wireless_controller(input_data, fos_instance)

    expected_data = {
        'acct-interim-interval': '3',
        'alias': 'test_value_4',
        'auth': 'psk',
                'broadcast-ssid': 'enable',
                'broadcast-suppression': 'dhcp-up',
                'captive-portal-ac-name': 'test_value_8',
                'captive-portal-macauth-radius-secret': 'test_value_9',
                'captive-portal-macauth-radius-server': 'test_value_10',
                'captive-portal-radius-secret': 'test_value_11',
                'captive-portal-radius-server': 'test_value_12',
                'captive-portal-session-timeout-interval': '13',
                'dhcp-lease-time': '14',
                'dhcp-option82-circuit-id-insertion': 'style-1',
                'dhcp-option82-insertion': 'enable',
                'dhcp-option82-remote-id-insertion': 'style-1',
                'dynamic-vlan': 'enable',
                'eap-reauth': 'enable',
                'eap-reauth-intv': '20',
                'eapol-key-retries': 'disable',
                'encrypt': 'TKIP',
                'external-fast-roaming': 'enable',
                'external-logout': 'test_value_24',
                'external-web': 'test_value_25',
                'fast-bss-transition': 'disable',
                'fast-roaming': 'enable',
                'ft-mobility-domain': '28',
                'ft-over-ds': 'disable',
                'ft-r0-key-lifetime': '30',
                'gtk-rekey': 'enable',
                'gtk-rekey-intv': '32',
                'hotspot20-profile': 'test_value_33',
                'intra-vap-privacy': 'enable',
                'ip': 'test_value_35',
                'key': 'test_value_36',
                'keyindex': '37',
                'ldpc': 'disable',
                'local-authentication': 'enable',
                'local-bridging': 'enable',
                'local-lan': 'allow',
                'local-standalone': 'enable',
                'local-standalone-nat': 'enable',
                'mac-auth-bypass': 'enable',
                'mac-filter': 'enable',
                'mac-filter-policy-other': 'allow',
                'max-clients': '47',
                'max-clients-ap': '48',
                'me-disable-thresh': '49',
                'mesh-backhaul': 'enable',
                'mpsk': 'enable',
                'mpsk-concurrent-clients': '52',
                'multicast-enhance': 'enable',
                'multicast-rate': '0',
                'name': 'default_name_55',
                'okc': 'disable',
                'passphrase': 'test_value_57',
                'pmf': 'disable',
                'pmf-assoc-comeback-timeout': '59',
                'pmf-sa-query-retry-timeout': '60',
                'portal-message-override-group': 'test_value_61',
                'portal-type': 'auth',
                'probe-resp-suppression': 'enable',
                'probe-resp-threshold': 'test_value_64',
                'ptk-rekey': 'enable',
                'ptk-rekey-intv': '66',
                'qos-profile': 'test_value_67',
                'quarantine': 'enable',
                'radio-2g-threshold': 'test_value_69',
                'radio-5g-threshold': 'test_value_70',
                'radio-sensitivity': 'enable',
                'radius-mac-auth': 'enable',
                'radius-mac-auth-server': 'test_value_73',
                'radius-server': 'test_value_74',
                'rates-11a': '1',
                'rates-11ac-ss12': 'mcs0/1',
                'rates-11ac-ss34': 'mcs0/3',
                'rates-11bg': '1',
                'rates-11n-ss12': 'mcs0/1',
                'rates-11n-ss34': 'mcs16/3',
                'schedule': 'test_value_81',
                'security': 'open',
                'security-exempt-list': 'test_value_83',
                'security-obsolete-option': 'enable',
                'security-redirect-url': 'test_value_85',
                'split-tunneling': 'enable',
                'ssid': 'test_value_87',
                'tkip-counter-measure': 'enable',
                'utm-profile': 'test_value_89',
                'vdom': 'test_value_90',
                'vlan-auto': 'enable',
                'vlan-pooling': 'wtp-group',
                'vlanid': '93',
                'voice-enterprise': 'disable'
    }

    set_method_mock.assert_called_with('wireless-controller', 'vap', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert is_error
    assert not changed
    assert response['status'] == 'error'
    assert response['http_status'] == 500


def test_wireless_controller_vap_removal(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    delete_method_result = {'status': 'success', 'http_method': 'POST', 'http_status': 200}
    delete_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.delete', return_value=delete_method_result)

    input_data = {
        'username': 'admin',
        'state': 'absent',
        'wireless_controller_vap': {
            'acct_interim_interval': '3',
            'alias': 'test_value_4',
            'auth': 'psk',
            'broadcast_ssid': 'enable',
            'broadcast_suppression': 'dhcp-up',
            'captive_portal_ac_name': 'test_value_8',
            'captive_portal_macauth_radius_secret': 'test_value_9',
            'captive_portal_macauth_radius_server': 'test_value_10',
            'captive_portal_radius_secret': 'test_value_11',
            'captive_portal_radius_server': 'test_value_12',
            'captive_portal_session_timeout_interval': '13',
            'dhcp_lease_time': '14',
            'dhcp_option82_circuit_id_insertion': 'style-1',
            'dhcp_option82_insertion': 'enable',
            'dhcp_option82_remote_id_insertion': 'style-1',
            'dynamic_vlan': 'enable',
            'eap_reauth': 'enable',
            'eap_reauth_intv': '20',
            'eapol_key_retries': 'disable',
            'encrypt': 'TKIP',
            'external_fast_roaming': 'enable',
            'external_logout': 'test_value_24',
            'external_web': 'test_value_25',
            'fast_bss_transition': 'disable',
            'fast_roaming': 'enable',
            'ft_mobility_domain': '28',
            'ft_over_ds': 'disable',
            'ft_r0_key_lifetime': '30',
            'gtk_rekey': 'enable',
            'gtk_rekey_intv': '32',
            'hotspot20_profile': 'test_value_33',
            'intra_vap_privacy': 'enable',
            'ip': 'test_value_35',
            'key': 'test_value_36',
            'keyindex': '37',
            'ldpc': 'disable',
            'local_authentication': 'enable',
            'local_bridging': 'enable',
            'local_lan': 'allow',
            'local_standalone': 'enable',
            'local_standalone_nat': 'enable',
            'mac_auth_bypass': 'enable',
            'mac_filter': 'enable',
            'mac_filter_policy_other': 'allow',
            'max_clients': '47',
            'max_clients_ap': '48',
            'me_disable_thresh': '49',
            'mesh_backhaul': 'enable',
            'mpsk': 'enable',
            'mpsk_concurrent_clients': '52',
            'multicast_enhance': 'enable',
            'multicast_rate': '0',
            'name': 'default_name_55',
            'okc': 'disable',
            'passphrase': 'test_value_57',
            'pmf': 'disable',
            'pmf_assoc_comeback_timeout': '59',
            'pmf_sa_query_retry_timeout': '60',
            'portal_message_override_group': 'test_value_61',
            'portal_type': 'auth',
            'probe_resp_suppression': 'enable',
            'probe_resp_threshold': 'test_value_64',
            'ptk_rekey': 'enable',
            'ptk_rekey_intv': '66',
            'qos_profile': 'test_value_67',
            'quarantine': 'enable',
            'radio_2g_threshold': 'test_value_69',
            'radio_5g_threshold': 'test_value_70',
            'radio_sensitivity': 'enable',
            'radius_mac_auth': 'enable',
            'radius_mac_auth_server': 'test_value_73',
            'radius_server': 'test_value_74',
            'rates_11a': '1',
            'rates_11ac_ss12': 'mcs0/1',
            'rates_11ac_ss34': 'mcs0/3',
            'rates_11bg': '1',
            'rates_11n_ss12': 'mcs0/1',
            'rates_11n_ss34': 'mcs16/3',
            'schedule': 'test_value_81',
            'security': 'open',
            'security_exempt_list': 'test_value_83',
            'security_obsolete_option': 'enable',
            'security_redirect_url': 'test_value_85',
            'split_tunneling': 'enable',
            'ssid': 'test_value_87',
            'tkip_counter_measure': 'enable',
            'utm_profile': 'test_value_89',
            'vdom': 'test_value_90',
            'vlan_auto': 'enable',
            'vlan_pooling': 'wtp-group',
            'vlanid': '93',
            'voice_enterprise': 'disable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_wireless_controller_vap.fortios_wireless_controller(input_data, fos_instance)

    delete_method_mock.assert_called_with('wireless-controller', 'vap', mkey=ANY, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert changed
    assert response['status'] == 'success'
    assert response['http_status'] == 200


def test_wireless_controller_vap_deletion_fails(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    delete_method_result = {'status': 'error', 'http_method': 'POST', 'http_status': 500}
    delete_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.delete', return_value=delete_method_result)

    input_data = {
        'username': 'admin',
        'state': 'absent',
        'wireless_controller_vap': {
            'acct_interim_interval': '3',
            'alias': 'test_value_4',
            'auth': 'psk',
            'broadcast_ssid': 'enable',
            'broadcast_suppression': 'dhcp-up',
            'captive_portal_ac_name': 'test_value_8',
            'captive_portal_macauth_radius_secret': 'test_value_9',
            'captive_portal_macauth_radius_server': 'test_value_10',
            'captive_portal_radius_secret': 'test_value_11',
            'captive_portal_radius_server': 'test_value_12',
            'captive_portal_session_timeout_interval': '13',
            'dhcp_lease_time': '14',
            'dhcp_option82_circuit_id_insertion': 'style-1',
            'dhcp_option82_insertion': 'enable',
            'dhcp_option82_remote_id_insertion': 'style-1',
            'dynamic_vlan': 'enable',
            'eap_reauth': 'enable',
            'eap_reauth_intv': '20',
            'eapol_key_retries': 'disable',
            'encrypt': 'TKIP',
            'external_fast_roaming': 'enable',
            'external_logout': 'test_value_24',
            'external_web': 'test_value_25',
            'fast_bss_transition': 'disable',
            'fast_roaming': 'enable',
            'ft_mobility_domain': '28',
            'ft_over_ds': 'disable',
            'ft_r0_key_lifetime': '30',
            'gtk_rekey': 'enable',
            'gtk_rekey_intv': '32',
            'hotspot20_profile': 'test_value_33',
            'intra_vap_privacy': 'enable',
            'ip': 'test_value_35',
            'key': 'test_value_36',
            'keyindex': '37',
            'ldpc': 'disable',
            'local_authentication': 'enable',
            'local_bridging': 'enable',
            'local_lan': 'allow',
            'local_standalone': 'enable',
            'local_standalone_nat': 'enable',
            'mac_auth_bypass': 'enable',
            'mac_filter': 'enable',
            'mac_filter_policy_other': 'allow',
            'max_clients': '47',
            'max_clients_ap': '48',
            'me_disable_thresh': '49',
            'mesh_backhaul': 'enable',
            'mpsk': 'enable',
            'mpsk_concurrent_clients': '52',
            'multicast_enhance': 'enable',
            'multicast_rate': '0',
            'name': 'default_name_55',
            'okc': 'disable',
            'passphrase': 'test_value_57',
            'pmf': 'disable',
            'pmf_assoc_comeback_timeout': '59',
            'pmf_sa_query_retry_timeout': '60',
            'portal_message_override_group': 'test_value_61',
            'portal_type': 'auth',
            'probe_resp_suppression': 'enable',
            'probe_resp_threshold': 'test_value_64',
            'ptk_rekey': 'enable',
            'ptk_rekey_intv': '66',
            'qos_profile': 'test_value_67',
            'quarantine': 'enable',
            'radio_2g_threshold': 'test_value_69',
            'radio_5g_threshold': 'test_value_70',
            'radio_sensitivity': 'enable',
            'radius_mac_auth': 'enable',
            'radius_mac_auth_server': 'test_value_73',
            'radius_server': 'test_value_74',
            'rates_11a': '1',
            'rates_11ac_ss12': 'mcs0/1',
            'rates_11ac_ss34': 'mcs0/3',
            'rates_11bg': '1',
            'rates_11n_ss12': 'mcs0/1',
            'rates_11n_ss34': 'mcs16/3',
            'schedule': 'test_value_81',
            'security': 'open',
            'security_exempt_list': 'test_value_83',
            'security_obsolete_option': 'enable',
            'security_redirect_url': 'test_value_85',
            'split_tunneling': 'enable',
            'ssid': 'test_value_87',
            'tkip_counter_measure': 'enable',
            'utm_profile': 'test_value_89',
            'vdom': 'test_value_90',
            'vlan_auto': 'enable',
            'vlan_pooling': 'wtp-group',
            'vlanid': '93',
            'voice_enterprise': 'disable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_wireless_controller_vap.fortios_wireless_controller(input_data, fos_instance)

    delete_method_mock.assert_called_with('wireless-controller', 'vap', mkey=ANY, vdom='root')
    schema_method_mock.assert_not_called()
    assert is_error
    assert not changed
    assert response['status'] == 'error'
    assert response['http_status'] == 500


def test_wireless_controller_vap_idempotent(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'error', 'http_method': 'DELETE', 'http_status': 404}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'wireless_controller_vap': {
            'acct_interim_interval': '3',
            'alias': 'test_value_4',
            'auth': 'psk',
            'broadcast_ssid': 'enable',
            'broadcast_suppression': 'dhcp-up',
            'captive_portal_ac_name': 'test_value_8',
            'captive_portal_macauth_radius_secret': 'test_value_9',
            'captive_portal_macauth_radius_server': 'test_value_10',
            'captive_portal_radius_secret': 'test_value_11',
            'captive_portal_radius_server': 'test_value_12',
            'captive_portal_session_timeout_interval': '13',
            'dhcp_lease_time': '14',
            'dhcp_option82_circuit_id_insertion': 'style-1',
            'dhcp_option82_insertion': 'enable',
            'dhcp_option82_remote_id_insertion': 'style-1',
            'dynamic_vlan': 'enable',
            'eap_reauth': 'enable',
            'eap_reauth_intv': '20',
            'eapol_key_retries': 'disable',
            'encrypt': 'TKIP',
            'external_fast_roaming': 'enable',
            'external_logout': 'test_value_24',
            'external_web': 'test_value_25',
            'fast_bss_transition': 'disable',
            'fast_roaming': 'enable',
            'ft_mobility_domain': '28',
            'ft_over_ds': 'disable',
            'ft_r0_key_lifetime': '30',
            'gtk_rekey': 'enable',
            'gtk_rekey_intv': '32',
            'hotspot20_profile': 'test_value_33',
            'intra_vap_privacy': 'enable',
            'ip': 'test_value_35',
            'key': 'test_value_36',
            'keyindex': '37',
            'ldpc': 'disable',
            'local_authentication': 'enable',
            'local_bridging': 'enable',
            'local_lan': 'allow',
            'local_standalone': 'enable',
            'local_standalone_nat': 'enable',
            'mac_auth_bypass': 'enable',
            'mac_filter': 'enable',
            'mac_filter_policy_other': 'allow',
            'max_clients': '47',
            'max_clients_ap': '48',
            'me_disable_thresh': '49',
            'mesh_backhaul': 'enable',
            'mpsk': 'enable',
            'mpsk_concurrent_clients': '52',
            'multicast_enhance': 'enable',
            'multicast_rate': '0',
            'name': 'default_name_55',
            'okc': 'disable',
            'passphrase': 'test_value_57',
            'pmf': 'disable',
            'pmf_assoc_comeback_timeout': '59',
            'pmf_sa_query_retry_timeout': '60',
            'portal_message_override_group': 'test_value_61',
            'portal_type': 'auth',
            'probe_resp_suppression': 'enable',
            'probe_resp_threshold': 'test_value_64',
            'ptk_rekey': 'enable',
            'ptk_rekey_intv': '66',
            'qos_profile': 'test_value_67',
            'quarantine': 'enable',
            'radio_2g_threshold': 'test_value_69',
            'radio_5g_threshold': 'test_value_70',
            'radio_sensitivity': 'enable',
            'radius_mac_auth': 'enable',
            'radius_mac_auth_server': 'test_value_73',
            'radius_server': 'test_value_74',
            'rates_11a': '1',
            'rates_11ac_ss12': 'mcs0/1',
            'rates_11ac_ss34': 'mcs0/3',
            'rates_11bg': '1',
            'rates_11n_ss12': 'mcs0/1',
            'rates_11n_ss34': 'mcs16/3',
            'schedule': 'test_value_81',
            'security': 'open',
            'security_exempt_list': 'test_value_83',
            'security_obsolete_option': 'enable',
            'security_redirect_url': 'test_value_85',
            'split_tunneling': 'enable',
            'ssid': 'test_value_87',
            'tkip_counter_measure': 'enable',
            'utm_profile': 'test_value_89',
            'vdom': 'test_value_90',
            'vlan_auto': 'enable',
            'vlan_pooling': 'wtp-group',
            'vlanid': '93',
            'voice_enterprise': 'disable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_wireless_controller_vap.fortios_wireless_controller(input_data, fos_instance)

    expected_data = {
        'acct-interim-interval': '3',
        'alias': 'test_value_4',
        'auth': 'psk',
                'broadcast-ssid': 'enable',
                'broadcast-suppression': 'dhcp-up',
                'captive-portal-ac-name': 'test_value_8',
                'captive-portal-macauth-radius-secret': 'test_value_9',
                'captive-portal-macauth-radius-server': 'test_value_10',
                'captive-portal-radius-secret': 'test_value_11',
                'captive-portal-radius-server': 'test_value_12',
                'captive-portal-session-timeout-interval': '13',
                'dhcp-lease-time': '14',
                'dhcp-option82-circuit-id-insertion': 'style-1',
                'dhcp-option82-insertion': 'enable',
                'dhcp-option82-remote-id-insertion': 'style-1',
                'dynamic-vlan': 'enable',
                'eap-reauth': 'enable',
                'eap-reauth-intv': '20',
                'eapol-key-retries': 'disable',
                'encrypt': 'TKIP',
                'external-fast-roaming': 'enable',
                'external-logout': 'test_value_24',
                'external-web': 'test_value_25',
                'fast-bss-transition': 'disable',
                'fast-roaming': 'enable',
                'ft-mobility-domain': '28',
                'ft-over-ds': 'disable',
                'ft-r0-key-lifetime': '30',
                'gtk-rekey': 'enable',
                'gtk-rekey-intv': '32',
                'hotspot20-profile': 'test_value_33',
                'intra-vap-privacy': 'enable',
                'ip': 'test_value_35',
                'key': 'test_value_36',
                'keyindex': '37',
                'ldpc': 'disable',
                'local-authentication': 'enable',
                'local-bridging': 'enable',
                'local-lan': 'allow',
                'local-standalone': 'enable',
                'local-standalone-nat': 'enable',
                'mac-auth-bypass': 'enable',
                'mac-filter': 'enable',
                'mac-filter-policy-other': 'allow',
                'max-clients': '47',
                'max-clients-ap': '48',
                'me-disable-thresh': '49',
                'mesh-backhaul': 'enable',
                'mpsk': 'enable',
                'mpsk-concurrent-clients': '52',
                'multicast-enhance': 'enable',
                'multicast-rate': '0',
                'name': 'default_name_55',
                'okc': 'disable',
                'passphrase': 'test_value_57',
                'pmf': 'disable',
                'pmf-assoc-comeback-timeout': '59',
                'pmf-sa-query-retry-timeout': '60',
                'portal-message-override-group': 'test_value_61',
                'portal-type': 'auth',
                'probe-resp-suppression': 'enable',
                'probe-resp-threshold': 'test_value_64',
                'ptk-rekey': 'enable',
                'ptk-rekey-intv': '66',
                'qos-profile': 'test_value_67',
                'quarantine': 'enable',
                'radio-2g-threshold': 'test_value_69',
                'radio-5g-threshold': 'test_value_70',
                'radio-sensitivity': 'enable',
                'radius-mac-auth': 'enable',
                'radius-mac-auth-server': 'test_value_73',
                'radius-server': 'test_value_74',
                'rates-11a': '1',
                'rates-11ac-ss12': 'mcs0/1',
                'rates-11ac-ss34': 'mcs0/3',
                'rates-11bg': '1',
                'rates-11n-ss12': 'mcs0/1',
                'rates-11n-ss34': 'mcs16/3',
                'schedule': 'test_value_81',
                'security': 'open',
                'security-exempt-list': 'test_value_83',
                'security-obsolete-option': 'enable',
                'security-redirect-url': 'test_value_85',
                'split-tunneling': 'enable',
                'ssid': 'test_value_87',
                'tkip-counter-measure': 'enable',
                'utm-profile': 'test_value_89',
                'vdom': 'test_value_90',
                'vlan-auto': 'enable',
                'vlan-pooling': 'wtp-group',
                'vlanid': '93',
                'voice-enterprise': 'disable'
    }

    set_method_mock.assert_called_with('wireless-controller', 'vap', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert not changed
    assert response['status'] == 'error'
    assert response['http_status'] == 404


def test_wireless_controller_vap_filter_foreign_attributes(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'success', 'http_method': 'POST', 'http_status': 200}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'wireless_controller_vap': {
            'random_attribute_not_valid': 'tag',
            'acct_interim_interval': '3',
            'alias': 'test_value_4',
            'auth': 'psk',
            'broadcast_ssid': 'enable',
            'broadcast_suppression': 'dhcp-up',
            'captive_portal_ac_name': 'test_value_8',
            'captive_portal_macauth_radius_secret': 'test_value_9',
            'captive_portal_macauth_radius_server': 'test_value_10',
            'captive_portal_radius_secret': 'test_value_11',
            'captive_portal_radius_server': 'test_value_12',
            'captive_portal_session_timeout_interval': '13',
            'dhcp_lease_time': '14',
            'dhcp_option82_circuit_id_insertion': 'style-1',
            'dhcp_option82_insertion': 'enable',
            'dhcp_option82_remote_id_insertion': 'style-1',
            'dynamic_vlan': 'enable',
            'eap_reauth': 'enable',
            'eap_reauth_intv': '20',
            'eapol_key_retries': 'disable',
            'encrypt': 'TKIP',
            'external_fast_roaming': 'enable',
            'external_logout': 'test_value_24',
            'external_web': 'test_value_25',
            'fast_bss_transition': 'disable',
            'fast_roaming': 'enable',
            'ft_mobility_domain': '28',
            'ft_over_ds': 'disable',
            'ft_r0_key_lifetime': '30',
            'gtk_rekey': 'enable',
            'gtk_rekey_intv': '32',
            'hotspot20_profile': 'test_value_33',
            'intra_vap_privacy': 'enable',
            'ip': 'test_value_35',
            'key': 'test_value_36',
            'keyindex': '37',
            'ldpc': 'disable',
            'local_authentication': 'enable',
            'local_bridging': 'enable',
            'local_lan': 'allow',
            'local_standalone': 'enable',
            'local_standalone_nat': 'enable',
            'mac_auth_bypass': 'enable',
            'mac_filter': 'enable',
            'mac_filter_policy_other': 'allow',
            'max_clients': '47',
            'max_clients_ap': '48',
            'me_disable_thresh': '49',
            'mesh_backhaul': 'enable',
            'mpsk': 'enable',
            'mpsk_concurrent_clients': '52',
            'multicast_enhance': 'enable',
            'multicast_rate': '0',
            'name': 'default_name_55',
            'okc': 'disable',
            'passphrase': 'test_value_57',
            'pmf': 'disable',
            'pmf_assoc_comeback_timeout': '59',
            'pmf_sa_query_retry_timeout': '60',
            'portal_message_override_group': 'test_value_61',
            'portal_type': 'auth',
            'probe_resp_suppression': 'enable',
            'probe_resp_threshold': 'test_value_64',
            'ptk_rekey': 'enable',
            'ptk_rekey_intv': '66',
            'qos_profile': 'test_value_67',
            'quarantine': 'enable',
            'radio_2g_threshold': 'test_value_69',
            'radio_5g_threshold': 'test_value_70',
            'radio_sensitivity': 'enable',
            'radius_mac_auth': 'enable',
            'radius_mac_auth_server': 'test_value_73',
            'radius_server': 'test_value_74',
            'rates_11a': '1',
            'rates_11ac_ss12': 'mcs0/1',
            'rates_11ac_ss34': 'mcs0/3',
            'rates_11bg': '1',
            'rates_11n_ss12': 'mcs0/1',
            'rates_11n_ss34': 'mcs16/3',
            'schedule': 'test_value_81',
            'security': 'open',
            'security_exempt_list': 'test_value_83',
            'security_obsolete_option': 'enable',
            'security_redirect_url': 'test_value_85',
            'split_tunneling': 'enable',
            'ssid': 'test_value_87',
            'tkip_counter_measure': 'enable',
            'utm_profile': 'test_value_89',
            'vdom': 'test_value_90',
            'vlan_auto': 'enable',
            'vlan_pooling': 'wtp-group',
            'vlanid': '93',
            'voice_enterprise': 'disable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_wireless_controller_vap.fortios_wireless_controller(input_data, fos_instance)

    expected_data = {
        'acct-interim-interval': '3',
        'alias': 'test_value_4',
        'auth': 'psk',
                'broadcast-ssid': 'enable',
                'broadcast-suppression': 'dhcp-up',
                'captive-portal-ac-name': 'test_value_8',
                'captive-portal-macauth-radius-secret': 'test_value_9',
                'captive-portal-macauth-radius-server': 'test_value_10',
                'captive-portal-radius-secret': 'test_value_11',
                'captive-portal-radius-server': 'test_value_12',
                'captive-portal-session-timeout-interval': '13',
                'dhcp-lease-time': '14',
                'dhcp-option82-circuit-id-insertion': 'style-1',
                'dhcp-option82-insertion': 'enable',
                'dhcp-option82-remote-id-insertion': 'style-1',
                'dynamic-vlan': 'enable',
                'eap-reauth': 'enable',
                'eap-reauth-intv': '20',
                'eapol-key-retries': 'disable',
                'encrypt': 'TKIP',
                'external-fast-roaming': 'enable',
                'external-logout': 'test_value_24',
                'external-web': 'test_value_25',
                'fast-bss-transition': 'disable',
                'fast-roaming': 'enable',
                'ft-mobility-domain': '28',
                'ft-over-ds': 'disable',
                'ft-r0-key-lifetime': '30',
                'gtk-rekey': 'enable',
                'gtk-rekey-intv': '32',
                'hotspot20-profile': 'test_value_33',
                'intra-vap-privacy': 'enable',
                'ip': 'test_value_35',
                'key': 'test_value_36',
                'keyindex': '37',
                'ldpc': 'disable',
                'local-authentication': 'enable',
                'local-bridging': 'enable',
                'local-lan': 'allow',
                'local-standalone': 'enable',
                'local-standalone-nat': 'enable',
                'mac-auth-bypass': 'enable',
                'mac-filter': 'enable',
                'mac-filter-policy-other': 'allow',
                'max-clients': '47',
                'max-clients-ap': '48',
                'me-disable-thresh': '49',
                'mesh-backhaul': 'enable',
                'mpsk': 'enable',
                'mpsk-concurrent-clients': '52',
                'multicast-enhance': 'enable',
                'multicast-rate': '0',
                'name': 'default_name_55',
                'okc': 'disable',
                'passphrase': 'test_value_57',
                'pmf': 'disable',
                'pmf-assoc-comeback-timeout': '59',
                'pmf-sa-query-retry-timeout': '60',
                'portal-message-override-group': 'test_value_61',
                'portal-type': 'auth',
                'probe-resp-suppression': 'enable',
                'probe-resp-threshold': 'test_value_64',
                'ptk-rekey': 'enable',
                'ptk-rekey-intv': '66',
                'qos-profile': 'test_value_67',
                'quarantine': 'enable',
                'radio-2g-threshold': 'test_value_69',
                'radio-5g-threshold': 'test_value_70',
                'radio-sensitivity': 'enable',
                'radius-mac-auth': 'enable',
                'radius-mac-auth-server': 'test_value_73',
                'radius-server': 'test_value_74',
                'rates-11a': '1',
                'rates-11ac-ss12': 'mcs0/1',
                'rates-11ac-ss34': 'mcs0/3',
                'rates-11bg': '1',
                'rates-11n-ss12': 'mcs0/1',
                'rates-11n-ss34': 'mcs16/3',
                'schedule': 'test_value_81',
                'security': 'open',
                'security-exempt-list': 'test_value_83',
                'security-obsolete-option': 'enable',
                'security-redirect-url': 'test_value_85',
                'split-tunneling': 'enable',
                'ssid': 'test_value_87',
                'tkip-counter-measure': 'enable',
                'utm-profile': 'test_value_89',
                'vdom': 'test_value_90',
                'vlan-auto': 'enable',
                'vlan-pooling': 'wtp-group',
                'vlanid': '93',
                'voice-enterprise': 'disable'
    }

    set_method_mock.assert_called_with('wireless-controller', 'vap', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert changed
    assert response['status'] == 'success'
    assert response['http_status'] == 200
