import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GcpSecretStaticAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Path where the GCP secrets engine is mounted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_static_account#backend GcpSecretStaticAccount#backend}
    */
    readonly backend: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_static_account#id GcpSecretStaticAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_static_account#namespace GcpSecretStaticAccount#namespace}
    */
    readonly namespace?: string;
    /**
    * Type of secret generated for this static account. Defaults to `access_token`. Accepted values: `access_token`, `service_account_key`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_static_account#secret_type GcpSecretStaticAccount#secret_type}
    */
    readonly secretType?: string;
    /**
    * Email of the GCP service account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_static_account#service_account_email GcpSecretStaticAccount#service_account_email}
    */
    readonly serviceAccountEmail: string;
    /**
    * Name of the Static Account to create
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_static_account#static_account GcpSecretStaticAccount#static_account}
    */
    readonly staticAccount: string;
    /**
    * List of OAuth scopes to assign to `access_token` secrets generated under this static account (`access_token` static accounts only)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_static_account#token_scopes GcpSecretStaticAccount#token_scopes}
    */
    readonly tokenScopes?: string[];
    /**
    * binding block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_static_account#binding GcpSecretStaticAccount#binding}
    */
    readonly binding?: GcpSecretStaticAccountBinding[] | cdktf.IResolvable;
}
export interface GcpSecretStaticAccountBinding {
    /**
    * Resource name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_static_account#resource GcpSecretStaticAccount#resource}
    */
    readonly resource: string;
    /**
    * List of roles to apply to the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_static_account#roles GcpSecretStaticAccount#roles}
    */
    readonly roles: string[];
}
export declare function gcpSecretStaticAccountBindingToTerraform(struct?: GcpSecretStaticAccountBinding | cdktf.IResolvable): any;
export declare class GcpSecretStaticAccountBindingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GcpSecretStaticAccountBinding | cdktf.IResolvable | undefined;
    set internalValue(value: GcpSecretStaticAccountBinding | cdktf.IResolvable | undefined);
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
    private _roles?;
    get roles(): string[];
    set roles(value: string[]);
    get rolesInput(): string[] | undefined;
}
export declare class GcpSecretStaticAccountBindingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GcpSecretStaticAccountBinding[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GcpSecretStaticAccountBindingOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_static_account vault_gcp_secret_static_account}
*/
export declare class GcpSecretStaticAccount extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_gcp_secret_static_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_static_account vault_gcp_secret_static_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GcpSecretStaticAccountConfig
    */
    constructor(scope: Construct, id: string, config: GcpSecretStaticAccountConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _secretType?;
    get secretType(): string;
    set secretType(value: string);
    resetSecretType(): void;
    get secretTypeInput(): string | undefined;
    private _serviceAccountEmail?;
    get serviceAccountEmail(): string;
    set serviceAccountEmail(value: string);
    get serviceAccountEmailInput(): string | undefined;
    get serviceAccountProject(): string;
    private _staticAccount?;
    get staticAccount(): string;
    set staticAccount(value: string);
    get staticAccountInput(): string | undefined;
    private _tokenScopes?;
    get tokenScopes(): string[];
    set tokenScopes(value: string[]);
    resetTokenScopes(): void;
    get tokenScopesInput(): string[] | undefined;
    private _binding;
    get binding(): GcpSecretStaticAccountBindingList;
    putBinding(value: GcpSecretStaticAccountBinding[] | cdktf.IResolvable): void;
    resetBinding(): void;
    get bindingInput(): cdktf.IResolvable | GcpSecretStaticAccountBinding[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
