"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesAuthBackendConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_auth_backend_config vault_kubernetes_auth_backend_config}
*/
class KubernetesAuthBackendConfig extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_auth_backend_config vault_kubernetes_auth_backend_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KubernetesAuthBackendConfigConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_kubernetes_auth_backend_config',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.8.2',
                providerVersionConstraint: '~> 3.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._backend = config.backend;
        this._disableIssValidation = config.disableIssValidation;
        this._disableLocalCaJwt = config.disableLocalCaJwt;
        this._id = config.id;
        this._issuer = config.issuer;
        this._kubernetesCaCert = config.kubernetesCaCert;
        this._kubernetesHost = config.kubernetesHost;
        this._namespace = config.namespace;
        this._pemKeys = config.pemKeys;
        this._tokenReviewerJwt = config.tokenReviewerJwt;
    }
    get backend() {
        return this.getStringAttribute('backend');
    }
    set backend(value) {
        this._backend = value;
    }
    resetBackend() {
        this._backend = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backendInput() {
        return this._backend;
    }
    get disableIssValidation() {
        return this.getBooleanAttribute('disable_iss_validation');
    }
    set disableIssValidation(value) {
        this._disableIssValidation = value;
    }
    resetDisableIssValidation() {
        this._disableIssValidation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableIssValidationInput() {
        return this._disableIssValidation;
    }
    get disableLocalCaJwt() {
        return this.getBooleanAttribute('disable_local_ca_jwt');
    }
    set disableLocalCaJwt(value) {
        this._disableLocalCaJwt = value;
    }
    resetDisableLocalCaJwt() {
        this._disableLocalCaJwt = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableLocalCaJwtInput() {
        return this._disableLocalCaJwt;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get issuer() {
        return this.getStringAttribute('issuer');
    }
    set issuer(value) {
        this._issuer = value;
    }
    resetIssuer() {
        this._issuer = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuerInput() {
        return this._issuer;
    }
    get kubernetesCaCert() {
        return this.getStringAttribute('kubernetes_ca_cert');
    }
    set kubernetesCaCert(value) {
        this._kubernetesCaCert = value;
    }
    resetKubernetesCaCert() {
        this._kubernetesCaCert = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get kubernetesCaCertInput() {
        return this._kubernetesCaCert;
    }
    get kubernetesHost() {
        return this.getStringAttribute('kubernetes_host');
    }
    set kubernetesHost(value) {
        this._kubernetesHost = value;
    }
    // Temporarily expose input value. Use with caution.
    get kubernetesHostInput() {
        return this._kubernetesHost;
    }
    get namespace() {
        return this.getStringAttribute('namespace');
    }
    set namespace(value) {
        this._namespace = value;
    }
    resetNamespace() {
        this._namespace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInput() {
        return this._namespace;
    }
    get pemKeys() {
        return this.getListAttribute('pem_keys');
    }
    set pemKeys(value) {
        this._pemKeys = value;
    }
    resetPemKeys() {
        this._pemKeys = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pemKeysInput() {
        return this._pemKeys;
    }
    get tokenReviewerJwt() {
        return this.getStringAttribute('token_reviewer_jwt');
    }
    set tokenReviewerJwt(value) {
        this._tokenReviewerJwt = value;
    }
    resetTokenReviewerJwt() {
        this._tokenReviewerJwt = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenReviewerJwtInput() {
        return this._tokenReviewerJwt;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            backend: cdktf.stringToTerraform(this._backend),
            disable_iss_validation: cdktf.booleanToTerraform(this._disableIssValidation),
            disable_local_ca_jwt: cdktf.booleanToTerraform(this._disableLocalCaJwt),
            id: cdktf.stringToTerraform(this._id),
            issuer: cdktf.stringToTerraform(this._issuer),
            kubernetes_ca_cert: cdktf.stringToTerraform(this._kubernetesCaCert),
            kubernetes_host: cdktf.stringToTerraform(this._kubernetesHost),
            namespace: cdktf.stringToTerraform(this._namespace),
            pem_keys: cdktf.listMapper(cdktf.stringToTerraform, false)(this._pemKeys),
            token_reviewer_jwt: cdktf.stringToTerraform(this._tokenReviewerJwt),
        };
    }
}
exports.KubernetesAuthBackendConfig = KubernetesAuthBackendConfig;
_a = JSII_RTTI_SYMBOL_1;
KubernetesAuthBackendConfig[_a] = { fqn: "@cdktf/provider-vault.KubernetesAuthBackendConfig", version: "2.0.53" };
// =================
// STATIC PROPERTIES
// =================
KubernetesAuthBackendConfig.tfResourceType = "vault_kubernetes_auth_backend_config";
//# sourceMappingURL=data:application/json;base64,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