# Copyright (c) 2017-2022 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# fmt: off
# isort: skip_file
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from . import package_management_service_pb2 as com_dot_daml_dot_ledger_dot_api_dot_v1_dot_admin_dot_package__management__service__pb2


class PackageManagementServiceStub(object):
    """Status: experimental interface, will change before it is deemed production
    ready

    Query the Daml-LF packages supported by the ledger participant and upload
    DAR files. We use 'backing participant' to refer to this specific participant
    in the methods of this API.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.ListKnownPackages = channel.unary_unary(
                '/com.daml.ledger.api.v1.admin.PackageManagementService/ListKnownPackages',
                request_serializer=com_dot_daml_dot_ledger_dot_api_dot_v1_dot_admin_dot_package__management__service__pb2.ListKnownPackagesRequest.SerializeToString,
                response_deserializer=com_dot_daml_dot_ledger_dot_api_dot_v1_dot_admin_dot_package__management__service__pb2.ListKnownPackagesResponse.FromString,
                )
        self.UploadDarFile = channel.unary_unary(
                '/com.daml.ledger.api.v1.admin.PackageManagementService/UploadDarFile',
                request_serializer=com_dot_daml_dot_ledger_dot_api_dot_v1_dot_admin_dot_package__management__service__pb2.UploadDarFileRequest.SerializeToString,
                response_deserializer=com_dot_daml_dot_ledger_dot_api_dot_v1_dot_admin_dot_package__management__service__pb2.UploadDarFileResponse.FromString,
                )


class PackageManagementServiceServicer(object):
    """Status: experimental interface, will change before it is deemed production
    ready

    Query the Daml-LF packages supported by the ledger participant and upload
    DAR files. We use 'backing participant' to refer to this specific participant
    in the methods of this API.
    """

    def ListKnownPackages(self, request, context):
        """Returns the details of all Daml-LF packages known to the backing participant.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UploadDarFile(self, request, context):
        """Upload a DAR file to the backing participant.
        Depending on the ledger implementation this might also make the package 
        available on the whole ledger. This call might not be supported by some 
        ledger implementations. Canton could be an example, where uploading a DAR
        is not sufficient to render it usable, it must be activated first.
        This call may:
        - Succeed, if the package was successfully uploaded, or if the same package
        was already uploaded before.
        - Respond with a gRPC error
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_PackageManagementServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'ListKnownPackages': grpc.unary_unary_rpc_method_handler(
                    servicer.ListKnownPackages,
                    request_deserializer=com_dot_daml_dot_ledger_dot_api_dot_v1_dot_admin_dot_package__management__service__pb2.ListKnownPackagesRequest.FromString,
                    response_serializer=com_dot_daml_dot_ledger_dot_api_dot_v1_dot_admin_dot_package__management__service__pb2.ListKnownPackagesResponse.SerializeToString,
            ),
            'UploadDarFile': grpc.unary_unary_rpc_method_handler(
                    servicer.UploadDarFile,
                    request_deserializer=com_dot_daml_dot_ledger_dot_api_dot_v1_dot_admin_dot_package__management__service__pb2.UploadDarFileRequest.FromString,
                    response_serializer=com_dot_daml_dot_ledger_dot_api_dot_v1_dot_admin_dot_package__management__service__pb2.UploadDarFileResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'com.daml.ledger.api.v1.admin.PackageManagementService', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class PackageManagementService(object):
    """Status: experimental interface, will change before it is deemed production
    ready

    Query the Daml-LF packages supported by the ledger participant and upload
    DAR files. We use 'backing participant' to refer to this specific participant
    in the methods of this API.
    """

    @staticmethod
    def ListKnownPackages(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.daml.ledger.api.v1.admin.PackageManagementService/ListKnownPackages',
            com_dot_daml_dot_ledger_dot_api_dot_v1_dot_admin_dot_package__management__service__pb2.ListKnownPackagesRequest.SerializeToString,
            com_dot_daml_dot_ledger_dot_api_dot_v1_dot_admin_dot_package__management__service__pb2.ListKnownPackagesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def UploadDarFile(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.daml.ledger.api.v1.admin.PackageManagementService/UploadDarFile',
            com_dot_daml_dot_ledger_dot_api_dot_v1_dot_admin_dot_package__management__service__pb2.UploadDarFileRequest.SerializeToString,
            com_dot_daml_dot_ledger_dot_api_dot_v1_dot_admin_dot_package__management__service__pb2.UploadDarFileResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
