# Copyright (c) 2017-2022 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# fmt: off
# isort: skip_file

import builtins as _builtins, sys, typing as _typing

from google.protobuf.field_mask_pb2 import FieldMask
from google.protobuf.internal.containers import RepeatedCompositeFieldContainer
from google.protobuf.message import Message as _Message

from .object_meta_pb2 import ObjectMeta

if sys.version_info >= (3, 8):
    from typing import Literal as _L
else:
    from typing_extensions import Literal as _L

__all__ = [
    "User",
    "Right",
    "CreateUserRequest",
    "CreateUserResponse",
    "GetUserRequest",
    "GetUserResponse",
    "UpdateUserRequest",
    "UpdateUserResponse",
    "DeleteUserRequest",
    "DeleteUserResponse",
    "ListUsersRequest",
    "ListUsersResponse",
    "GrantUserRightsRequest",
    "GrantUserRightsResponse",
    "RevokeUserRightsRequest",
    "RevokeUserRightsResponse",
    "ListUserRightsRequest",
    "ListUserRightsResponse",
]


class User(_Message):
    id: _builtins.str
    primary_party: _builtins.str
    is_deactivated: _builtins.bool
    @property
    def metadata(self) -> ObjectMeta: ...
    def __init__(self, *, id: _typing.Optional[_builtins.str] = ..., primary_party: _typing.Optional[_builtins.str] = ..., is_deactivated: _typing.Optional[_builtins.bool] = ..., metadata: _typing.Optional[ObjectMeta] = ...): ...
    def HasField(self, field_name: _L["id", "primary_party", "is_deactivated", "metadata"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["id", "primary_party", "is_deactivated", "metadata"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class Right(_Message):
    
    class ParticipantAdmin(_Message):
        def __init__(self): ...
        def HasField(self, field_name: _typing.NoReturn) -> _typing.NoReturn: ...
        def ClearField(self, field_name: _typing.NoReturn) -> _typing.NoReturn: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class CanActAs(_Message):
        party: _builtins.str
        def __init__(self, *, party: _typing.Optional[_builtins.str] = ...): ...
        def HasField(self, field_name: _L["party"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["party"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class CanReadAs(_Message):
        party: _builtins.str
        def __init__(self, *, party: _typing.Optional[_builtins.str] = ...): ...
        def HasField(self, field_name: _L["party"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["party"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    @property
    def participant_admin(self) -> Right.ParticipantAdmin: ...
    @property
    def can_act_as(self) -> Right.CanActAs: ...
    @property
    def can_read_as(self) -> Right.CanReadAs: ...
    @_typing.overload
    def __init__(self): ...
    @_typing.overload
    def __init__(self, *, participant_admin: Right.ParticipantAdmin = ...): ...
    @_typing.overload
    def __init__(self, *, can_act_as: Right.CanActAs = ...): ...
    @_typing.overload
    def __init__(self, *, can_read_as: Right.CanReadAs = ...): ...
    def HasField(self, field_name: _L["kind", "participant_admin", "can_act_as", "can_read_as"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["kind", "participant_admin", "can_act_as", "can_read_as"]) -> None: ...
    def WhichOneof(self, oneof_group: _L["kind"]) -> _L[None, "participant_admin", "can_act_as", "can_read_as"]: ...

class CreateUserRequest(_Message):
    @property
    def user(self) -> User: ...
    @property
    def rights(self) -> RepeatedCompositeFieldContainer[Right]: ...
    def __init__(self, *, user: _typing.Optional[User] = ..., rights: _typing.Optional[_typing.Iterable[Right]] = ...): ...
    def HasField(self, field_name: _L["user", "rights"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["user", "rights"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class CreateUserResponse(_Message):
    @property
    def user(self) -> User: ...
    def __init__(self, *, user: _typing.Optional[User] = ...): ...
    def HasField(self, field_name: _L["user"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["user"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class GetUserRequest(_Message):
    user_id: _builtins.str
    def __init__(self, *, user_id: _typing.Optional[_builtins.str] = ...): ...
    def HasField(self, field_name: _L["user_id"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["user_id"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class GetUserResponse(_Message):
    @property
    def user(self) -> User: ...
    def __init__(self, *, user: _typing.Optional[User] = ...): ...
    def HasField(self, field_name: _L["user"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["user"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class UpdateUserRequest(_Message):
    @property
    def user(self) -> User: ...
    @property
    def update_mask(self) -> FieldMask: ...
    def __init__(self, *, user: _typing.Optional[User] = ..., update_mask: _typing.Optional[FieldMask] = ...): ...
    def HasField(self, field_name: _L["user", "update_mask"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["user", "update_mask"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class UpdateUserResponse(_Message):
    @property
    def user(self) -> User: ...
    def __init__(self, *, user: _typing.Optional[User] = ...): ...
    def HasField(self, field_name: _L["user"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["user"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class DeleteUserRequest(_Message):
    user_id: _builtins.str
    def __init__(self, *, user_id: _typing.Optional[_builtins.str] = ...): ...
    def HasField(self, field_name: _L["user_id"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["user_id"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class DeleteUserResponse(_Message):
    def __init__(self): ...
    def HasField(self, field_name: _typing.NoReturn) -> _typing.NoReturn: ...
    def ClearField(self, field_name: _typing.NoReturn) -> _typing.NoReturn: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class ListUsersRequest(_Message):
    page_token: _builtins.str
    page_size: _builtins.int
    def __init__(self, *, page_token: _typing.Optional[_builtins.str] = ..., page_size: _typing.Optional[_builtins.int] = ...): ...
    def HasField(self, field_name: _L["page_token", "page_size"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["page_token", "page_size"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class ListUsersResponse(_Message):
    @property
    def users(self) -> RepeatedCompositeFieldContainer[User]: ...
    next_page_token: _builtins.str
    def __init__(self, *, users: _typing.Optional[_typing.Iterable[User]] = ..., next_page_token: _typing.Optional[_builtins.str] = ...): ...
    def HasField(self, field_name: _L["users", "next_page_token"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["users", "next_page_token"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class GrantUserRightsRequest(_Message):
    user_id: _builtins.str
    @property
    def rights(self) -> RepeatedCompositeFieldContainer[Right]: ...
    def __init__(self, *, user_id: _typing.Optional[_builtins.str] = ..., rights: _typing.Optional[_typing.Iterable[Right]] = ...): ...
    def HasField(self, field_name: _L["user_id", "rights"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["user_id", "rights"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class GrantUserRightsResponse(_Message):
    @property
    def newly_granted_rights(self) -> RepeatedCompositeFieldContainer[Right]: ...
    def __init__(self, *, newly_granted_rights: _typing.Optional[_typing.Iterable[Right]] = ...): ...
    def HasField(self, field_name: _L["newly_granted_rights"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["newly_granted_rights"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class RevokeUserRightsRequest(_Message):
    user_id: _builtins.str
    @property
    def rights(self) -> RepeatedCompositeFieldContainer[Right]: ...
    def __init__(self, *, user_id: _typing.Optional[_builtins.str] = ..., rights: _typing.Optional[_typing.Iterable[Right]] = ...): ...
    def HasField(self, field_name: _L["user_id", "rights"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["user_id", "rights"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class RevokeUserRightsResponse(_Message):
    @property
    def newly_revoked_rights(self) -> RepeatedCompositeFieldContainer[Right]: ...
    def __init__(self, *, newly_revoked_rights: _typing.Optional[_typing.Iterable[Right]] = ...): ...
    def HasField(self, field_name: _L["newly_revoked_rights"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["newly_revoked_rights"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class ListUserRightsRequest(_Message):
    user_id: _builtins.str
    def __init__(self, *, user_id: _typing.Optional[_builtins.str] = ...): ...
    def HasField(self, field_name: _L["user_id"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["user_id"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class ListUserRightsResponse(_Message):
    @property
    def rights(self) -> RepeatedCompositeFieldContainer[Right]: ...
    def __init__(self, *, rights: _typing.Optional[_typing.Iterable[Right]] = ...): ...
    def HasField(self, field_name: _L["rights"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["rights"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
