# Copyright (c) 2017-2022 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# fmt: off
# isort: skip_file
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from . import command_completion_service_pb2 as com_dot_daml_dot_ledger_dot_api_dot_v1_dot_command__completion__service__pb2


class CommandCompletionServiceStub(object):
    """Allows clients to observe the status of their submissions.
    Commands may be submitted via the Command Submission Service.
    The on-ledger effects of their submissions are disclosed by the Transaction Service.

    Commands may fail in 2 distinct manners:

    1. Failure communicated synchronously in the gRPC error of the submission.
    2. Failure communicated asynchronously in a Completion, see ``completion.proto``.

    Note that not only successfully submitted commands MAY produce a completion event. For example, the participant MAY
    choose to produce a completion event for a rejection of a duplicate command.

    Clients that do not receive a successful completion about their submission MUST NOT assume that it was successful.
    Clients SHOULD subscribe to the CompletionStream before starting to submit commands to prevent race conditions.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.CompletionStream = channel.unary_stream(
                '/com.daml.ledger.api.v1.CommandCompletionService/CompletionStream',
                request_serializer=com_dot_daml_dot_ledger_dot_api_dot_v1_dot_command__completion__service__pb2.CompletionStreamRequest.SerializeToString,
                response_deserializer=com_dot_daml_dot_ledger_dot_api_dot_v1_dot_command__completion__service__pb2.CompletionStreamResponse.FromString,
                )
        self.CompletionEnd = channel.unary_unary(
                '/com.daml.ledger.api.v1.CommandCompletionService/CompletionEnd',
                request_serializer=com_dot_daml_dot_ledger_dot_api_dot_v1_dot_command__completion__service__pb2.CompletionEndRequest.SerializeToString,
                response_deserializer=com_dot_daml_dot_ledger_dot_api_dot_v1_dot_command__completion__service__pb2.CompletionEndResponse.FromString,
                )


class CommandCompletionServiceServicer(object):
    """Allows clients to observe the status of their submissions.
    Commands may be submitted via the Command Submission Service.
    The on-ledger effects of their submissions are disclosed by the Transaction Service.

    Commands may fail in 2 distinct manners:

    1. Failure communicated synchronously in the gRPC error of the submission.
    2. Failure communicated asynchronously in a Completion, see ``completion.proto``.

    Note that not only successfully submitted commands MAY produce a completion event. For example, the participant MAY
    choose to produce a completion event for a rejection of a duplicate command.

    Clients that do not receive a successful completion about their submission MUST NOT assume that it was successful.
    Clients SHOULD subscribe to the CompletionStream before starting to submit commands to prevent race conditions.
    """

    def CompletionStream(self, request, context):
        """Subscribe to command completion events.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CompletionEnd(self, request, context):
        """Returns the offset after the latest completion.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_CommandCompletionServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'CompletionStream': grpc.unary_stream_rpc_method_handler(
                    servicer.CompletionStream,
                    request_deserializer=com_dot_daml_dot_ledger_dot_api_dot_v1_dot_command__completion__service__pb2.CompletionStreamRequest.FromString,
                    response_serializer=com_dot_daml_dot_ledger_dot_api_dot_v1_dot_command__completion__service__pb2.CompletionStreamResponse.SerializeToString,
            ),
            'CompletionEnd': grpc.unary_unary_rpc_method_handler(
                    servicer.CompletionEnd,
                    request_deserializer=com_dot_daml_dot_ledger_dot_api_dot_v1_dot_command__completion__service__pb2.CompletionEndRequest.FromString,
                    response_serializer=com_dot_daml_dot_ledger_dot_api_dot_v1_dot_command__completion__service__pb2.CompletionEndResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'com.daml.ledger.api.v1.CommandCompletionService', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class CommandCompletionService(object):
    """Allows clients to observe the status of their submissions.
    Commands may be submitted via the Command Submission Service.
    The on-ledger effects of their submissions are disclosed by the Transaction Service.

    Commands may fail in 2 distinct manners:

    1. Failure communicated synchronously in the gRPC error of the submission.
    2. Failure communicated asynchronously in a Completion, see ``completion.proto``.

    Note that not only successfully submitted commands MAY produce a completion event. For example, the participant MAY
    choose to produce a completion event for a rejection of a duplicate command.

    Clients that do not receive a successful completion about their submission MUST NOT assume that it was successful.
    Clients SHOULD subscribe to the CompletionStream before starting to submit commands to prevent race conditions.
    """

    @staticmethod
    def CompletionStream(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/com.daml.ledger.api.v1.CommandCompletionService/CompletionStream',
            com_dot_daml_dot_ledger_dot_api_dot_v1_dot_command__completion__service__pb2.CompletionStreamRequest.SerializeToString,
            com_dot_daml_dot_ledger_dot_api_dot_v1_dot_command__completion__service__pb2.CompletionStreamResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def CompletionEnd(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/com.daml.ledger.api.v1.CommandCompletionService/CompletionEnd',
            com_dot_daml_dot_ledger_dot_api_dot_v1_dot_command__completion__service__pb2.CompletionEndRequest.SerializeToString,
            com_dot_daml_dot_ledger_dot_api_dot_v1_dot_command__completion__service__pb2.CompletionEndResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
