# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'ServiceACLEntriesv1Entry',
    'ServiceComputeBackend',
    'ServiceComputeBigquerylogging',
    'ServiceComputeBlobstoragelogging',
    'ServiceComputeDictionary',
    'ServiceComputeDirector',
    'ServiceComputeDomain',
    'ServiceComputeGcslogging',
    'ServiceComputeHealthcheck',
    'ServiceComputeHttpslogging',
    'ServiceComputeLogentry',
    'ServiceComputeLoggingCloudfile',
    'ServiceComputeLoggingDatadog',
    'ServiceComputeLoggingDigitalocean',
    'ServiceComputeLoggingElasticsearch',
    'ServiceComputeLoggingFtp',
    'ServiceComputeLoggingGooglepubsub',
    'ServiceComputeLoggingHeroku',
    'ServiceComputeLoggingHoneycomb',
    'ServiceComputeLoggingKafka',
    'ServiceComputeLoggingKinese',
    'ServiceComputeLoggingLoggly',
    'ServiceComputeLoggingLogshuttle',
    'ServiceComputeLoggingNewrelic',
    'ServiceComputeLoggingOpenstack',
    'ServiceComputeLoggingScalyr',
    'ServiceComputeLoggingSftp',
    'ServiceComputePackage',
    'ServiceComputePapertrail',
    'ServiceComputeS3logging',
    'ServiceComputeSplunk',
    'ServiceComputeSumologic',
    'ServiceComputeSyslog',
    'ServiceWafConfigurationRule',
    'ServiceWafConfigurationRuleExclusion',
    'Servicev1Acl',
    'Servicev1Backend',
    'Servicev1Bigquerylogging',
    'Servicev1Blobstoragelogging',
    'Servicev1CacheSetting',
    'Servicev1Condition',
    'Servicev1Dictionary',
    'Servicev1Director',
    'Servicev1Domain',
    'Servicev1Dynamicsnippet',
    'Servicev1Gcslogging',
    'Servicev1Gzip',
    'Servicev1Header',
    'Servicev1Healthcheck',
    'Servicev1Httpslogging',
    'Servicev1Logentry',
    'Servicev1LoggingCloudfile',
    'Servicev1LoggingDatadog',
    'Servicev1LoggingDigitalocean',
    'Servicev1LoggingElasticsearch',
    'Servicev1LoggingFtp',
    'Servicev1LoggingGooglepubsub',
    'Servicev1LoggingHeroku',
    'Servicev1LoggingHoneycomb',
    'Servicev1LoggingKafka',
    'Servicev1LoggingKinese',
    'Servicev1LoggingLoggly',
    'Servicev1LoggingLogshuttle',
    'Servicev1LoggingNewrelic',
    'Servicev1LoggingOpenstack',
    'Servicev1LoggingScalyr',
    'Servicev1LoggingSftp',
    'Servicev1Papertrail',
    'Servicev1RequestSetting',
    'Servicev1ResponseObject',
    'Servicev1S3logging',
    'Servicev1Snippet',
    'Servicev1Splunk',
    'Servicev1Sumologic',
    'Servicev1Syslog',
    'Servicev1Vcl',
    'Servicev1Waf',
    'TlsSubscriptionManagedDnsChallenge',
    'TlsSubscriptionManagedHttpChallenge',
    'GetTlsConfigurationDnsRecordResult',
    'GetWafRulesRuleResult',
]

@pulumi.output_type
class ServiceACLEntriesv1Entry(dict):
    def __init__(__self__, *,
                 ip: str,
                 comment: Optional[str] = None,
                 id: Optional[str] = None,
                 negated: Optional[bool] = None,
                 subnet: Optional[str] = None):
        """
        :param str ip: An IP address that is the focus for the ACL
        :param str comment: A personal freeform descriptive note
        :param str id: The unique ID of the entry
        :param bool negated: A boolean that will negate the match if true
        :param str subnet: An optional subnet mask applied to the IP address
        """
        pulumi.set(__self__, "ip", ip)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if negated is not None:
            pulumi.set(__self__, "negated", negated)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def ip(self) -> str:
        """
        An IP address that is the focus for the ACL
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        """
        A personal freeform descriptive note
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The unique ID of the entry
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def negated(self) -> Optional[bool]:
        """
        A boolean that will negate the match if true
        """
        return pulumi.get(self, "negated")

    @property
    @pulumi.getter
    def subnet(self) -> Optional[str]:
        """
        An optional subnet mask applied to the IP address
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class ServiceComputeBackend(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoLoadbalance":
            suggest = "auto_loadbalance"
        elif key == "betweenBytesTimeout":
            suggest = "between_bytes_timeout"
        elif key == "connectTimeout":
            suggest = "connect_timeout"
        elif key == "errorThreshold":
            suggest = "error_threshold"
        elif key == "firstByteTimeout":
            suggest = "first_byte_timeout"
        elif key == "maxConn":
            suggest = "max_conn"
        elif key == "maxTlsVersion":
            suggest = "max_tls_version"
        elif key == "minTlsVersion":
            suggest = "min_tls_version"
        elif key == "overrideHost":
            suggest = "override_host"
        elif key == "sslCaCert":
            suggest = "ssl_ca_cert"
        elif key == "sslCertHostname":
            suggest = "ssl_cert_hostname"
        elif key == "sslCheckCert":
            suggest = "ssl_check_cert"
        elif key == "sslCiphers":
            suggest = "ssl_ciphers"
        elif key == "sslClientCert":
            suggest = "ssl_client_cert"
        elif key == "sslClientKey":
            suggest = "ssl_client_key"
        elif key == "sslHostname":
            suggest = "ssl_hostname"
        elif key == "sslSniHostname":
            suggest = "ssl_sni_hostname"
        elif key == "useSsl":
            suggest = "use_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeBackend. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeBackend.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeBackend.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 name: str,
                 auto_loadbalance: Optional[bool] = None,
                 between_bytes_timeout: Optional[int] = None,
                 connect_timeout: Optional[int] = None,
                 error_threshold: Optional[int] = None,
                 first_byte_timeout: Optional[int] = None,
                 healthcheck: Optional[str] = None,
                 max_conn: Optional[int] = None,
                 max_tls_version: Optional[str] = None,
                 min_tls_version: Optional[str] = None,
                 override_host: Optional[str] = None,
                 port: Optional[int] = None,
                 shield: Optional[str] = None,
                 ssl_ca_cert: Optional[str] = None,
                 ssl_cert_hostname: Optional[str] = None,
                 ssl_check_cert: Optional[bool] = None,
                 ssl_ciphers: Optional[str] = None,
                 ssl_client_cert: Optional[str] = None,
                 ssl_client_key: Optional[str] = None,
                 ssl_hostname: Optional[str] = None,
                 ssl_sni_hostname: Optional[str] = None,
                 use_ssl: Optional[bool] = None,
                 weight: Optional[int] = None):
        """
        :param str address: An IPv4, hostname, or IPv6 address for the Backend
        :param str name: Name for this Backend. Must be unique to this Service. It is important to note that changing this attribute will delete and recreate the resource
        :param bool auto_loadbalance: Denotes if this Backend should be included in the pool of backends that requests are load balanced against. Default `true`
        :param int between_bytes_timeout: How long to wait between bytes in milliseconds. Default `10000`
        :param int connect_timeout: How long to wait for a timeout in milliseconds. Default `1000`
        :param int error_threshold: Number of errors to allow before the Backend is marked as down. Default `0`
        :param int first_byte_timeout: How long to wait for the first bytes in milliseconds. Default `15000`
        :param str healthcheck: Name of a defined `healthcheck` to assign to this backend
        :param int max_conn: Maximum number of connections for this Backend. Default `200`
        :param str max_tls_version: Maximum allowed TLS version on SSL connections to this backend.
        :param str min_tls_version: Minimum allowed TLS version on SSL connections to this backend.
        :param str override_host: The hostname to override the Host header
        :param int port: The port number on which the Backend responds. Default `80`
        :param str shield: The POP of the shield designated to reduce inbound load. Valid values for `shield` are included in the `GET /datacenters` API response
        :param str ssl_ca_cert: CA certificate attached to origin.
        :param str ssl_cert_hostname: Overrides ssl_hostname, but only for cert verification. Does not affect SNI at all
        :param bool ssl_check_cert: Be strict about checking SSL certs. Default `true`
        :param str ssl_ciphers: Comma separated list of OpenSSL Ciphers to try when negotiating to the backend
        :param str ssl_client_cert: Client certificate attached to origin. Used when connecting to the backend
        :param str ssl_client_key: Client key attached to origin. Used when connecting to the backend
        :param str ssl_hostname: Used for both SNI during the TLS handshake and to validate the cert
        :param str ssl_sni_hostname: Overrides ssl_hostname, but only for SNI in the handshake. Does not affect cert validation at all
        :param bool use_ssl: Whether or not to use SSL to reach the Backend. Default `false`
        :param int weight: The [portion of traffic](https://docs.fastly.com/en/guides/load-balancing-configuration#how-weight-affects-load-balancing) to send to this Backend. Each Backend receives weight / total of the traffic. Default `100`
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        if auto_loadbalance is not None:
            pulumi.set(__self__, "auto_loadbalance", auto_loadbalance)
        if between_bytes_timeout is not None:
            pulumi.set(__self__, "between_bytes_timeout", between_bytes_timeout)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if error_threshold is not None:
            pulumi.set(__self__, "error_threshold", error_threshold)
        if first_byte_timeout is not None:
            pulumi.set(__self__, "first_byte_timeout", first_byte_timeout)
        if healthcheck is not None:
            pulumi.set(__self__, "healthcheck", healthcheck)
        if max_conn is not None:
            pulumi.set(__self__, "max_conn", max_conn)
        if max_tls_version is not None:
            pulumi.set(__self__, "max_tls_version", max_tls_version)
        if min_tls_version is not None:
            pulumi.set(__self__, "min_tls_version", min_tls_version)
        if override_host is not None:
            pulumi.set(__self__, "override_host", override_host)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if shield is not None:
            pulumi.set(__self__, "shield", shield)
        if ssl_ca_cert is not None:
            pulumi.set(__self__, "ssl_ca_cert", ssl_ca_cert)
        if ssl_cert_hostname is not None:
            pulumi.set(__self__, "ssl_cert_hostname", ssl_cert_hostname)
        if ssl_check_cert is not None:
            pulumi.set(__self__, "ssl_check_cert", ssl_check_cert)
        if ssl_ciphers is not None:
            pulumi.set(__self__, "ssl_ciphers", ssl_ciphers)
        if ssl_client_cert is not None:
            pulumi.set(__self__, "ssl_client_cert", ssl_client_cert)
        if ssl_client_key is not None:
            pulumi.set(__self__, "ssl_client_key", ssl_client_key)
        if ssl_hostname is not None:
            pulumi.set(__self__, "ssl_hostname", ssl_hostname)
        if ssl_sni_hostname is not None:
            pulumi.set(__self__, "ssl_sni_hostname", ssl_sni_hostname)
        if use_ssl is not None:
            pulumi.set(__self__, "use_ssl", use_ssl)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        An IPv4, hostname, or IPv6 address for the Backend
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name for this Backend. Must be unique to this Service. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="autoLoadbalance")
    def auto_loadbalance(self) -> Optional[bool]:
        """
        Denotes if this Backend should be included in the pool of backends that requests are load balanced against. Default `true`
        """
        return pulumi.get(self, "auto_loadbalance")

    @property
    @pulumi.getter(name="betweenBytesTimeout")
    def between_bytes_timeout(self) -> Optional[int]:
        """
        How long to wait between bytes in milliseconds. Default `10000`
        """
        return pulumi.get(self, "between_bytes_timeout")

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[int]:
        """
        How long to wait for a timeout in milliseconds. Default `1000`
        """
        return pulumi.get(self, "connect_timeout")

    @property
    @pulumi.getter(name="errorThreshold")
    def error_threshold(self) -> Optional[int]:
        """
        Number of errors to allow before the Backend is marked as down. Default `0`
        """
        return pulumi.get(self, "error_threshold")

    @property
    @pulumi.getter(name="firstByteTimeout")
    def first_byte_timeout(self) -> Optional[int]:
        """
        How long to wait for the first bytes in milliseconds. Default `15000`
        """
        return pulumi.get(self, "first_byte_timeout")

    @property
    @pulumi.getter
    def healthcheck(self) -> Optional[str]:
        """
        Name of a defined `healthcheck` to assign to this backend
        """
        return pulumi.get(self, "healthcheck")

    @property
    @pulumi.getter(name="maxConn")
    def max_conn(self) -> Optional[int]:
        """
        Maximum number of connections for this Backend. Default `200`
        """
        return pulumi.get(self, "max_conn")

    @property
    @pulumi.getter(name="maxTlsVersion")
    def max_tls_version(self) -> Optional[str]:
        """
        Maximum allowed TLS version on SSL connections to this backend.
        """
        return pulumi.get(self, "max_tls_version")

    @property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> Optional[str]:
        """
        Minimum allowed TLS version on SSL connections to this backend.
        """
        return pulumi.get(self, "min_tls_version")

    @property
    @pulumi.getter(name="overrideHost")
    def override_host(self) -> Optional[str]:
        """
        The hostname to override the Host header
        """
        return pulumi.get(self, "override_host")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port number on which the Backend responds. Default `80`
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def shield(self) -> Optional[str]:
        """
        The POP of the shield designated to reduce inbound load. Valid values for `shield` are included in the `GET /datacenters` API response
        """
        return pulumi.get(self, "shield")

    @property
    @pulumi.getter(name="sslCaCert")
    def ssl_ca_cert(self) -> Optional[str]:
        """
        CA certificate attached to origin.
        """
        return pulumi.get(self, "ssl_ca_cert")

    @property
    @pulumi.getter(name="sslCertHostname")
    def ssl_cert_hostname(self) -> Optional[str]:
        """
        Overrides ssl_hostname, but only for cert verification. Does not affect SNI at all
        """
        return pulumi.get(self, "ssl_cert_hostname")

    @property
    @pulumi.getter(name="sslCheckCert")
    def ssl_check_cert(self) -> Optional[bool]:
        """
        Be strict about checking SSL certs. Default `true`
        """
        return pulumi.get(self, "ssl_check_cert")

    @property
    @pulumi.getter(name="sslCiphers")
    def ssl_ciphers(self) -> Optional[str]:
        """
        Comma separated list of OpenSSL Ciphers to try when negotiating to the backend
        """
        return pulumi.get(self, "ssl_ciphers")

    @property
    @pulumi.getter(name="sslClientCert")
    def ssl_client_cert(self) -> Optional[str]:
        """
        Client certificate attached to origin. Used when connecting to the backend
        """
        return pulumi.get(self, "ssl_client_cert")

    @property
    @pulumi.getter(name="sslClientKey")
    def ssl_client_key(self) -> Optional[str]:
        """
        Client key attached to origin. Used when connecting to the backend
        """
        return pulumi.get(self, "ssl_client_key")

    @property
    @pulumi.getter(name="sslHostname")
    def ssl_hostname(self) -> Optional[str]:
        """
        Used for both SNI during the TLS handshake and to validate the cert
        """
        return pulumi.get(self, "ssl_hostname")

    @property
    @pulumi.getter(name="sslSniHostname")
    def ssl_sni_hostname(self) -> Optional[str]:
        """
        Overrides ssl_hostname, but only for SNI in the handshake. Does not affect cert validation at all
        """
        return pulumi.get(self, "ssl_sni_hostname")

    @property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> Optional[bool]:
        """
        Whether or not to use SSL to reach the Backend. Default `false`
        """
        return pulumi.get(self, "use_ssl")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        """
        The [portion of traffic](https://docs.fastly.com/en/guides/load-balancing-configuration#how-weight-affects-load-balancing) to send to this Backend. Each Backend receives weight / total of the traffic. Default `100`
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ServiceComputeBigquerylogging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"
        elif key == "secretKey":
            suggest = "secret_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeBigquerylogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeBigquerylogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeBigquerylogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset: str,
                 email: str,
                 name: str,
                 project_id: str,
                 secret_key: str,
                 table: str,
                 template: Optional[str] = None):
        """
        :param str dataset: The ID of your BigQuery dataset
        :param str email: The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable
        :param str name: A unique name to identify this BigQuery logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str project_id: The ID of your GCP project
        :param str secret_key: The secret key associated with the service account that has write access to your BigQuery table. If not provided, this will be pulled from the `FASTLY_BQ_SECRET_KEY` environment variable. Typical format for this is a private key in a string with newlines
        :param str table: The ID of your BigQuery table
        :param str template: BigQuery table name suffix template
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret_key", secret_key)
        pulumi.set(__self__, "table", table)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter
    def dataset(self) -> str:
        """
        The ID of your BigQuery dataset
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this BigQuery logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of your GCP project
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        """
        The secret key associated with the service account that has write access to your BigQuery table. If not provided, this will be pulled from the `FASTLY_BQ_SECRET_KEY` environment variable. Typical format for this is a private key in a string with newlines
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        The ID of your BigQuery table
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter
    def template(self) -> Optional[str]:
        """
        BigQuery table name suffix template
        """
        return pulumi.get(self, "template")


@pulumi.output_type
class ServiceComputeBlobstoragelogging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "sasToken":
            suggest = "sas_token"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "fileMaxBytes":
            suggest = "file_max_bytes"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeBlobstoragelogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeBlobstoragelogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeBlobstoragelogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_name: str,
                 container: str,
                 name: str,
                 sas_token: str,
                 compression_codec: Optional[str] = None,
                 file_max_bytes: Optional[int] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[int] = None,
                 public_key: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str account_name: The unique Azure Blob Storage namespace in which your data objects are stored
        :param str container: The name of the Azure Blob Storage container in which to store logs
        :param str name: A unique name to identify the Azure Blob Storage endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str sas_token: The Azure shared access signature providing write access to the blob service objects. Be sure to update your token before it expires or the logging functionality will not work
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param int file_max_bytes: Maximum size of an uploaded log file, if non-zero.
        :param int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default `classic`
        :param str path: The path to upload logs to. Must end with a trailing slash. If this field is left empty, the files will be saved in the container's root path
        :param int period: How frequently the logs should be transferred in seconds. Default `3600`
        :param str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str timestamp_format: `strftime` specified timestamp formatting. Default `%Y-%m-%dT%H:%M:%S.000`
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sas_token", sas_token)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if file_max_bytes is not None:
            pulumi.set(__self__, "file_max_bytes", file_max_bytes)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        """
        The unique Azure Blob Storage namespace in which your data objects are stored
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter
    def container(self) -> str:
        """
        The name of the Azure Blob Storage container in which to store logs
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify the Azure Blob Storage endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> str:
        """
        The Azure shared access signature providing write access to the blob service objects. Be sure to update your token before it expires or the logging functionality will not work
        """
        return pulumi.get(self, "sas_token")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter(name="fileMaxBytes")
    def file_max_bytes(self) -> Optional[int]:
        """
        Maximum size of an uploaded log file, if non-zero.
        """
        return pulumi.get(self, "file_max_bytes")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to upload logs to. Must end with a trailing slash. If this field is left empty, the files will be saved in the container's root path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently the logs should be transferred in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        `strftime` specified timestamp formatting. Default `%Y-%m-%dT%H:%M:%S.000`
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeDictionary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dictionaryId":
            suggest = "dictionary_id"
        elif key == "forceDestroy":
            suggest = "force_destroy"
        elif key == "writeOnly":
            suggest = "write_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeDictionary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeDictionary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeDictionary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 dictionary_id: Optional[str] = None,
                 force_destroy: Optional[bool] = None,
                 write_only: Optional[bool] = None):
        """
        :param str name: A unique name to identify this dictionary. It is important to note that changing this attribute will delete and recreate the dictionary, and discard the current items in the dictionary
        :param str dictionary_id: The ID of the dictionary
        :param bool force_destroy: Allow the dictionary to be deleted, even if it contains entries. Defaults to false.
        :param bool write_only: If `true`, the dictionary is a private dictionary, and items are not readable in the UI or via API. Default is `false`. It is important to note that changing this attribute will delete and recreate the dictionary, and discard the current items in the dictionary. Using a write-only/private dictionary should only be done if the items are managed outside of this provider
        """
        pulumi.set(__self__, "name", name)
        if dictionary_id is not None:
            pulumi.set(__self__, "dictionary_id", dictionary_id)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if write_only is not None:
            pulumi.set(__self__, "write_only", write_only)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary. It is important to note that changing this attribute will delete and recreate the dictionary, and discard the current items in the dictionary
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="dictionaryId")
    def dictionary_id(self) -> Optional[str]:
        """
        The ID of the dictionary
        """
        return pulumi.get(self, "dictionary_id")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[bool]:
        """
        Allow the dictionary to be deleted, even if it contains entries. Defaults to false.
        """
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter(name="writeOnly")
    def write_only(self) -> Optional[bool]:
        """
        If `true`, the dictionary is a private dictionary, and items are not readable in the UI or via API. Default is `false`. It is important to note that changing this attribute will delete and recreate the dictionary, and discard the current items in the dictionary. Using a write-only/private dictionary should only be done if the items are managed outside of this provider
        """
        return pulumi.get(self, "write_only")


@pulumi.output_type
class ServiceComputeDirector(dict):
    def __init__(__self__, *,
                 backends: Sequence[str],
                 name: str,
                 capacity: Optional[int] = None,
                 comment: Optional[str] = None,
                 quorum: Optional[int] = None,
                 retries: Optional[int] = None,
                 shield: Optional[str] = None,
                 type: Optional[int] = None):
        """
        :param Sequence[str] backends: Names of defined backends to map the director to. Example: `[ "origin1", "origin2" ]`
        :param str name: Unique name for this Director. It is important to note that changing this attribute will delete and recreate the resource
        :param int capacity: Load balancing weight for the backends. Default `100`
        :param str comment: An optional comment about the Director
        :param int quorum: Percentage of capacity that needs to be up for the director itself to be considered up. Default `75`
        :param int retries: How many backends to search if it fails. Default `5`
        :param str shield: Selected POP to serve as a "shield" for backends. Valid values for `shield` are included in the [`GET /datacenters`](https://developer.fastly.com/reference/api/utils/datacenter/) API response
        :param int type: Type of load balance group to use. Integer, 1 to 4. Values: `1` (random), `3` (hash), `4` (client). Default `1`
        """
        pulumi.set(__self__, "backends", backends)
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if quorum is not None:
            pulumi.set(__self__, "quorum", quorum)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if shield is not None:
            pulumi.set(__self__, "shield", shield)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def backends(self) -> Sequence[str]:
        """
        Names of defined backends to map the director to. Example: `[ "origin1", "origin2" ]`
        """
        return pulumi.get(self, "backends")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique name for this Director. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        Load balancing weight for the backends. Default `100`
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        """
        An optional comment about the Director
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def quorum(self) -> Optional[int]:
        """
        Percentage of capacity that needs to be up for the director itself to be considered up. Default `75`
        """
        return pulumi.get(self, "quorum")

    @property
    @pulumi.getter
    def retries(self) -> Optional[int]:
        """
        How many backends to search if it fails. Default `5`
        """
        return pulumi.get(self, "retries")

    @property
    @pulumi.getter
    def shield(self) -> Optional[str]:
        """
        Selected POP to serve as a "shield" for backends. Valid values for `shield` are included in the [`GET /datacenters`](https://developer.fastly.com/reference/api/utils/datacenter/) API response
        """
        return pulumi.get(self, "shield")

    @property
    @pulumi.getter
    def type(self) -> Optional[int]:
        """
        Type of load balance group to use. Integer, 1 to 4. Values: `1` (random), `3` (hash), `4` (client). Default `1`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceComputeDomain(dict):
    def __init__(__self__, *,
                 name: str,
                 comment: Optional[str] = None):
        """
        :param str name: The domain that this Service will respond to. It is important to note that changing this attribute will delete and recreate the resource.
        :param str comment: An optional comment about the Domain.
        """
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The domain that this Service will respond to. It is important to note that changing this attribute will delete and recreate the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        """
        An optional comment about the Domain.
        """
        return pulumi.get(self, "comment")


@pulumi.output_type
class ServiceComputeGcslogging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeGcslogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeGcslogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeGcslogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 name: str,
                 compression_codec: Optional[str] = None,
                 email: Optional[str] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[int] = None,
                 secret_key: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str bucket_name: The name of the bucket in which to store the logs
        :param str name: A unique name to identify this GCS endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param str email: The email address associated with the target GCS bucket on your account. You may optionally provide this secret via an environment variable, `FASTLY_GCS_EMAIL`
        :param int gzip_level: Level of Gzip compression, from `0-9`. `0` is no compression. `1` is fastest and least compressed, `9` is slowest and most compressed. Default `0`
        :param str message_type: How the message should be formatted; one of: `classic`, `loggly`, `logplex` or `blank`. Default `classic`. [Fastly Documentation](https://developer.fastly.com/reference/api/logging/gcs/)
        :param str path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param int period: How frequently the logs should be transferred, in seconds (Default 3600)
        :param str secret_key: The secret key associated with the target gcs bucket on your account. You may optionally provide this secret via an environment variable, `FASTLY_GCS_SECRET_KEY`. A typical format for the key is PEM format, containing actual newline characters where required
        :param str timestamp_format: specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of the bucket in which to store the logs
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this GCS endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        The email address associated with the target GCS bucket on your account. You may optionally provide this secret via an environment variable, `FASTLY_GCS_EMAIL`
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        Level of Gzip compression, from `0-9`. `0` is no compression. `1` is fastest and least compressed, `9` is slowest and most compressed. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted; one of: `classic`, `loggly`, `logplex` or `blank`. Default `classic`. [Fastly Documentation](https://developer.fastly.com/reference/api/logging/gcs/)
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently the logs should be transferred, in seconds (Default 3600)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[str]:
        """
        The secret key associated with the target gcs bucket on your account. You may optionally provide this secret via an environment variable, `FASTLY_GCS_SECRET_KEY`. A typical format for the key is PEM format, containing actual newline characters where required
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeHealthcheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "checkInterval":
            suggest = "check_interval"
        elif key == "expectedResponse":
            suggest = "expected_response"
        elif key == "httpVersion":
            suggest = "http_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeHealthcheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeHealthcheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeHealthcheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: str,
                 name: str,
                 path: str,
                 check_interval: Optional[int] = None,
                 expected_response: Optional[int] = None,
                 http_version: Optional[str] = None,
                 initial: Optional[int] = None,
                 method: Optional[str] = None,
                 threshold: Optional[int] = None,
                 timeout: Optional[int] = None,
                 window: Optional[int] = None):
        """
        :param str host: The Host header to send for this Healthcheck
        :param str name: A unique name to identify this Healthcheck. It is important to note that changing this attribute will delete and recreate the resource
        :param str path: The path to check
        :param int check_interval: How often to run the Healthcheck in milliseconds. Default `5000`
        :param int expected_response: The status code expected from the host. Default `200`
        :param str http_version: Whether to use version 1.0 or 1.1 HTTP. Default `1.1`
        :param int initial: When loading a config, the initial number of probes to be seen as OK. Default `3`
        :param str method: Which HTTP method to use. Default `HEAD`
        :param int threshold: How many Healthchecks must succeed to be considered healthy. Default `3`
        :param int timeout: Timeout in milliseconds. Default `500`
        :param int window: The number of most recent Healthcheck queries to keep for this Healthcheck. Default `5`
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        if check_interval is not None:
            pulumi.set(__self__, "check_interval", check_interval)
        if expected_response is not None:
            pulumi.set(__self__, "expected_response", expected_response)
        if http_version is not None:
            pulumi.set(__self__, "http_version", http_version)
        if initial is not None:
            pulumi.set(__self__, "initial", initial)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if window is not None:
            pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The Host header to send for this Healthcheck
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this Healthcheck. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path to check
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> Optional[int]:
        """
        How often to run the Healthcheck in milliseconds. Default `5000`
        """
        return pulumi.get(self, "check_interval")

    @property
    @pulumi.getter(name="expectedResponse")
    def expected_response(self) -> Optional[int]:
        """
        The status code expected from the host. Default `200`
        """
        return pulumi.get(self, "expected_response")

    @property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> Optional[str]:
        """
        Whether to use version 1.0 or 1.1 HTTP. Default `1.1`
        """
        return pulumi.get(self, "http_version")

    @property
    @pulumi.getter
    def initial(self) -> Optional[int]:
        """
        When loading a config, the initial number of probes to be seen as OK. Default `3`
        """
        return pulumi.get(self, "initial")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        Which HTTP method to use. Default `HEAD`
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def threshold(self) -> Optional[int]:
        """
        How many Healthchecks must succeed to be considered healthy. Default `3`
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        Timeout in milliseconds. Default `500`
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def window(self) -> Optional[int]:
        """
        The number of most recent Healthcheck queries to keep for this Healthcheck. Default `5`
        """
        return pulumi.get(self, "window")


@pulumi.output_type
class ServiceComputeHttpslogging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "headerName":
            suggest = "header_name"
        elif key == "headerValue":
            suggest = "header_value"
        elif key == "jsonFormat":
            suggest = "json_format"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "requestMaxBytes":
            suggest = "request_max_bytes"
        elif key == "requestMaxEntries":
            suggest = "request_max_entries"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeHttpslogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeHttpslogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeHttpslogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 url: str,
                 content_type: Optional[str] = None,
                 header_name: Optional[str] = None,
                 header_value: Optional[str] = None,
                 json_format: Optional[str] = None,
                 message_type: Optional[str] = None,
                 method: Optional[str] = None,
                 request_max_bytes: Optional[int] = None,
                 request_max_entries: Optional[int] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None):
        """
        :param str name: The unique name of the HTTPS logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str url: URL that log data will be sent to. Must use the https protocol
        :param str content_type: Value of the `Content-Type` header sent with the request
        :param str header_name: Custom header sent with the request
        :param str header_value: Value of the custom header sent with the request
        :param str json_format: Formats log entries as JSON. Can be either disabled (`0`), array of json (`1`), or newline delimited json (`2`)
        :param str message_type: How the message should be formatted; one of: `classic`, `loggly`, `logplex` or `blank`. Default `blank`
        :param str method: HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`
        :param int request_max_bytes: The maximum number of bytes sent in one request
        :param int request_max_entries: The maximum number of logs sent in one request
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param str tls_hostname: Used during the TLS handshake to validate the certificate
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if header_name is not None:
            pulumi.set(__self__, "header_name", header_name)
        if header_value is not None:
            pulumi.set(__self__, "header_value", header_value)
        if json_format is not None:
            pulumi.set(__self__, "json_format", json_format)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if request_max_entries is not None:
            pulumi.set(__self__, "request_max_entries", request_max_entries)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the HTTPS logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        URL that log data will be sent to. Must use the https protocol
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[str]:
        """
        Value of the `Content-Type` header sent with the request
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> Optional[str]:
        """
        Custom header sent with the request
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> Optional[str]:
        """
        Value of the custom header sent with the request
        """
        return pulumi.get(self, "header_value")

    @property
    @pulumi.getter(name="jsonFormat")
    def json_format(self) -> Optional[str]:
        """
        Formats log entries as JSON. Can be either disabled (`0`), array of json (`1`), or newline delimited json (`2`)
        """
        return pulumi.get(self, "json_format")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted; one of: `classic`, `loggly`, `logplex` or `blank`. Default `blank`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[int]:
        """
        The maximum number of bytes sent in one request
        """
        return pulumi.get(self, "request_max_bytes")

    @property
    @pulumi.getter(name="requestMaxEntries")
    def request_max_entries(self) -> Optional[int]:
        """
        The maximum number of logs sent in one request
        """
        return pulumi.get(self, "request_max_entries")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        Used during the TLS handshake to validate the certificate
        """
        return pulumi.get(self, "tls_hostname")


@pulumi.output_type
class ServiceComputeLogentry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLogentry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLogentry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLogentry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 token: str,
                 port: Optional[int] = None,
                 use_tls: Optional[bool] = None):
        """
        :param str name: The unique name of the Logentries logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: Use token based authentication (https://logentries.com/doc/input-token/)
        :param int port: The port number configured in Logentries
        :param bool use_tls: Whether to use TLS for secure logging
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Logentries logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        Use token based authentication (https://logentries.com/doc/input-token/)
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port number configured in Logentries
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[bool]:
        """
        Whether to use TLS for secure logging
        """
        return pulumi.get(self, "use_tls")


@pulumi.output_type
class ServiceComputeLoggingCloudfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingCloudfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingCloudfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingCloudfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: str,
                 bucket_name: str,
                 name: str,
                 user: str,
                 compression_codec: Optional[str] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[int] = None,
                 public_key: Optional[str] = None,
                 region: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str access_key: Your Cloud File account access key
        :param str bucket_name: The name of your Cloud Files container
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str user: The username for your Cloud Files account
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param int gzip_level: What level of GZIP encoding to have when dumping logs (default `0`, no compression)
        :param str message_type: How the message should be formatted. One of: `classic` (default), `loggly`, `logplex` or `blank`
        :param str path: The path to upload logs to
        :param int period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str region: The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong)
        :param str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> str:
        """
        Your Cloud File account access key
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of your Cloud Files container
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for your Cloud Files account
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        What level of GZIP encoding to have when dumping logs (default `0`, no compression)
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: `classic` (default), `loggly`, `logplex` or `blank`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to upload logs to
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong)
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeLoggingDatadog(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str,
                 region: Optional[str] = None):
        """
        :param str name: The unique name of the Datadog logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The API key from your Datadog account
        :param str region: The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Datadog logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The API key from your Datadog account
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class ServiceComputeLoggingDigitalocean(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingDigitalocean. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingDigitalocean.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingDigitalocean.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: str,
                 bucket_name: str,
                 name: str,
                 secret_key: str,
                 compression_codec: Optional[str] = None,
                 domain: Optional[str] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[int] = None,
                 public_key: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str access_key: Your DigitalOcean Spaces account access key
        :param str bucket_name: The name of the DigitalOcean Space
        :param str name: The unique name of the DigitalOcean Spaces logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str secret_key: Your DigitalOcean Spaces account secret key
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param str domain: The domain of the DigitalOcean Spaces endpoint (default `nyc3.digitaloceanspaces.com`)
        :param int gzip_level: What level of Gzip encoding to have when dumping logs (default `0`, no compression)
        :param str message_type: How the message should be formatted. One of: `classic` (default), `loggly`, `logplex` or `blank`
        :param str path: The path to upload logs to
        :param int period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str timestamp_format: `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret_key", secret_key)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> str:
        """
        Your DigitalOcean Spaces account access key
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of the DigitalOcean Space
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the DigitalOcean Spaces logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        """
        Your DigitalOcean Spaces account secret key
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        The domain of the DigitalOcean Spaces endpoint (default `nyc3.digitaloceanspaces.com`)
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        What level of Gzip encoding to have when dumping logs (default `0`, no compression)
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: `classic` (default), `loggly`, `logplex` or `blank`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to upload logs to
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeLoggingElasticsearch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requestMaxBytes":
            suggest = "request_max_bytes"
        elif key == "requestMaxEntries":
            suggest = "request_max_entries"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingElasticsearch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingElasticsearch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingElasticsearch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index: str,
                 name: str,
                 url: str,
                 password: Optional[str] = None,
                 pipeline: Optional[str] = None,
                 request_max_bytes: Optional[int] = None,
                 request_max_entries: Optional[int] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None,
                 user: Optional[str] = None):
        """
        :param str index: The name of the Elasticsearch index to send documents (logs) to
        :param str name: The unique name of the Elasticsearch logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str url: The Elasticsearch URL to stream logs to
        :param str password: BasicAuth password for Elasticsearch
        :param str pipeline: The ID of the Elasticsearch ingest pipeline to apply pre-process transformations to before indexing
        :param int request_max_bytes: The maximum number of logs sent in one request. Defaults to `0` for unbounded
        :param int request_max_entries: The maximum number of bytes sent in one request. Defaults to `0` for unbounded
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name (CN) or a Subject Alternative Name (SAN)
        :param str user: BasicAuth username for Elasticsearch
        """
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pipeline is not None:
            pulumi.set(__self__, "pipeline", pipeline)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if request_max_entries is not None:
            pulumi.set(__self__, "request_max_entries", request_max_entries)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def index(self) -> str:
        """
        The name of the Elasticsearch index to send documents (logs) to
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Elasticsearch logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The Elasticsearch URL to stream logs to
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        BasicAuth password for Elasticsearch
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def pipeline(self) -> Optional[str]:
        """
        The ID of the Elasticsearch ingest pipeline to apply pre-process transformations to before indexing
        """
        return pulumi.get(self, "pipeline")

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[int]:
        """
        The maximum number of logs sent in one request. Defaults to `0` for unbounded
        """
        return pulumi.get(self, "request_max_bytes")

    @property
    @pulumi.getter(name="requestMaxEntries")
    def request_max_entries(self) -> Optional[int]:
        """
        The maximum number of bytes sent in one request. Defaults to `0` for unbounded
        """
        return pulumi.get(self, "request_max_entries")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name (CN) or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        BasicAuth username for Elasticsearch
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceComputeLoggingFtp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingFtp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingFtp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingFtp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 name: str,
                 password: str,
                 path: str,
                 user: str,
                 compression_codec: Optional[str] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 period: Optional[int] = None,
                 port: Optional[int] = None,
                 public_key: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str address: The FTP address to stream logs to
        :param str name: The unique name of the FTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str password: The password for the server (for anonymous use an email address)
        :param str path: The path to upload log files to. If the path ends in `/` then it is treated as a directory
        :param str user: The username for the server (can be `anonymous`)
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param int gzip_level: Gzip Compression level. Default `0`
        :param str message_type: How the message should be formatted (default: `classic`)
        :param int period: How frequently the logs should be transferred, in seconds (Default `3600`)
        :param int port: The port number. Default: `21`
        :param str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str timestamp_format: specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The FTP address to stream logs to
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the FTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password for the server (for anonymous use an email address)
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path to upload log files to. If the path ends in `/` then it is treated as a directory
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for the server (can be `anonymous`)
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        Gzip Compression level. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted (default: `classic`)
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently the logs should be transferred, in seconds (Default `3600`)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port number. Default: `21`
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeLoggingGooglepubsub(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"
        elif key == "secretKey":
            suggest = "secret_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingGooglepubsub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingGooglepubsub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingGooglepubsub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 project_id: str,
                 secret_key: str,
                 topic: str,
                 user: str):
        """
        :param str name: The unique name of the Google Cloud Pub/Sub logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str project_id: The ID of your Google Cloud Platform project
        :param str secret_key: Your Google Cloud Platform account secret key. The `private_key` field in your service account authentication JSON. You may optionally provide this secret via an environment variable, `FASTLY_GOOGLE_PUBSUB_SECRET_KEY`.
        :param str topic: The Google Cloud Pub/Sub topic to which logs will be published
        :param str user: Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GOOGLE_PUBSUB_EMAIL`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret_key", secret_key)
        pulumi.set(__self__, "topic", topic)
        pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Google Cloud Pub/Sub logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of your Google Cloud Platform project
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        """
        Your Google Cloud Platform account secret key. The `private_key` field in your service account authentication JSON. You may optionally provide this secret via an environment variable, `FASTLY_GOOGLE_PUBSUB_SECRET_KEY`.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The Google Cloud Pub/Sub topic to which logs will be published
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GOOGLE_PUBSUB_EMAIL`.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceComputeLoggingHeroku(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str,
                 url: str):
        """
        :param str name: The unique name of the Heroku logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The token to use for authentication (https://www.heroku.com/docs/customer-token-authentication-token/)
        :param str url: The URL to stream logs to
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Heroku logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The token to use for authentication (https://www.heroku.com/docs/customer-token-authentication-token/)
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL to stream logs to
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ServiceComputeLoggingHoneycomb(dict):
    def __init__(__self__, *,
                 dataset: str,
                 name: str,
                 token: str):
        """
        :param str dataset: The Honeycomb Dataset you want to log to
        :param str name: The unique name of the Honeycomb logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The Write Key from the Account page of your Honeycomb account
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def dataset(self) -> str:
        """
        The Honeycomb Dataset you want to log to
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Honeycomb logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The Write Key from the Account page of your Honeycomb account
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class ServiceComputeLoggingKafka(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authMethod":
            suggest = "auth_method"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "parseLogKeyvals":
            suggest = "parse_log_keyvals"
        elif key == "requestMaxBytes":
            suggest = "request_max_bytes"
        elif key == "requiredAcks":
            suggest = "required_acks"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingKafka. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingKafka.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingKafka.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 brokers: str,
                 name: str,
                 topic: str,
                 auth_method: Optional[str] = None,
                 compression_codec: Optional[str] = None,
                 parse_log_keyvals: Optional[bool] = None,
                 password: Optional[str] = None,
                 request_max_bytes: Optional[int] = None,
                 required_acks: Optional[str] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None,
                 use_tls: Optional[bool] = None,
                 user: Optional[str] = None):
        """
        :param str brokers: A comma-separated list of IP addresses or hostnames of Kafka brokers
        :param str name: The unique name of the Kafka logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str topic: The Kafka topic to send logs to
        :param str auth_method: SASL authentication method. One of: plain, scram-sha-256, scram-sha-512
        :param str compression_codec: The codec used for compression of your logs. One of: `gzip`, `snappy`, `lz4`
        :param bool parse_log_keyvals: Enables parsing of key=value tuples from the beginning of a logline, turning them into record headers
        :param str password: SASL Pass
        :param int request_max_bytes: Maximum size of log batch, if non-zero. Defaults to 0 for unbounded
        :param str required_acks: The Number of acknowledgements a leader must receive before a write is considered successful. One of: `1` (default) One server needs to respond. `0` No servers need to respond. `-1`	Wait for all in-sync replicas to respond
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        :param bool use_tls: Whether to use TLS for secure logging. Can be either `true` or `false`
        :param str user: SASL User
        """
        pulumi.set(__self__, "brokers", brokers)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "topic", topic)
        if auth_method is not None:
            pulumi.set(__self__, "auth_method", auth_method)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if parse_log_keyvals is not None:
            pulumi.set(__self__, "parse_log_keyvals", parse_log_keyvals)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if required_acks is not None:
            pulumi.set(__self__, "required_acks", required_acks)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def brokers(self) -> str:
        """
        A comma-separated list of IP addresses or hostnames of Kafka brokers
        """
        return pulumi.get(self, "brokers")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Kafka logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The Kafka topic to send logs to
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> Optional[str]:
        """
        SASL authentication method. One of: plain, scram-sha-256, scram-sha-512
        """
        return pulumi.get(self, "auth_method")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. One of: `gzip`, `snappy`, `lz4`
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter(name="parseLogKeyvals")
    def parse_log_keyvals(self) -> Optional[bool]:
        """
        Enables parsing of key=value tuples from the beginning of a logline, turning them into record headers
        """
        return pulumi.get(self, "parse_log_keyvals")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        SASL Pass
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[int]:
        """
        Maximum size of log batch, if non-zero. Defaults to 0 for unbounded
        """
        return pulumi.get(self, "request_max_bytes")

    @property
    @pulumi.getter(name="requiredAcks")
    def required_acks(self) -> Optional[str]:
        """
        The Number of acknowledgements a leader must receive before a write is considered successful. One of: `1` (default) One server needs to respond. `0` No servers need to respond. `-1`	Wait for all in-sync replicas to respond
        """
        return pulumi.get(self, "required_acks")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[bool]:
        """
        Whether to use TLS for secure logging. Can be either `true` or `false`
        """
        return pulumi.get(self, "use_tls")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        SASL User
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceComputeLoggingKinese(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "iamRole":
            suggest = "iam_role"
        elif key == "secretKey":
            suggest = "secret_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingKinese. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingKinese.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingKinese.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 topic: str,
                 access_key: Optional[str] = None,
                 iam_role: Optional[str] = None,
                 region: Optional[str] = None,
                 secret_key: Optional[str] = None):
        """
        :param str name: The unique name of the Kinesis logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str topic: The Kinesis stream name
        :param str access_key: The AWS access key to be used to write to the stream
        :param str iam_role: The Amazon Resource Name (ARN) for the IAM role granting Fastly access to Kinesis. Not required if `access_key` and `secret_key` are provided.
        :param str region: The AWS region the stream resides in. (Default: `us-east-1`)
        :param str secret_key: The AWS secret access key to authenticate with
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "topic", topic)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if iam_role is not None:
            pulumi.set(__self__, "iam_role", iam_role)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Kinesis logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The Kinesis stream name
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[str]:
        """
        The AWS access key to be used to write to the stream
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) for the IAM role granting Fastly access to Kinesis. Not required if `access_key` and `secret_key` are provided.
        """
        return pulumi.get(self, "iam_role")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The AWS region the stream resides in. (Default: `us-east-1`)
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[str]:
        """
        The AWS secret access key to authenticate with
        """
        return pulumi.get(self, "secret_key")


@pulumi.output_type
class ServiceComputeLoggingLoggly(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str):
        """
        :param str name: The unique name of the Loggly logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The token to use for authentication (https://www.loggly.com/docs/customer-token-authentication-token/).
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Loggly logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The token to use for authentication (https://www.loggly.com/docs/customer-token-authentication-token/).
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class ServiceComputeLoggingLogshuttle(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str,
                 url: str):
        """
        :param str name: The unique name of the Log Shuttle logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The data authentication token associated with this endpoint
        :param str url: Your Log Shuttle endpoint URL
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Log Shuttle logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The data authentication token associated with this endpoint
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Your Log Shuttle endpoint URL
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ServiceComputeLoggingNewrelic(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str):
        """
        :param str name: The unique name of the New Relic logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The Insert API key from the Account page of your New Relic account
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the New Relic logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The Insert API key from the Account page of your New Relic account
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class ServiceComputeLoggingOpenstack(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingOpenstack. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingOpenstack.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingOpenstack.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: str,
                 bucket_name: str,
                 name: str,
                 url: str,
                 user: str,
                 compression_codec: Optional[str] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[int] = None,
                 public_key: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str access_key: Your OpenStack account access key
        :param str bucket_name: The name of your OpenStack container
        :param str name: The unique name of the OpenStack logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str url: Your OpenStack auth url
        :param str user: The username for your OpenStack account
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param int gzip_level: What level of Gzip encoding to have when dumping logs (default `0`, no compression)
        :param str message_type: How the message should be formatted; one of: `classic`, `loggly`, `logplex` or `blank`. Default `classic`. [Fastly Documentation](https://developer.fastly.com/reference/api/logging/gcs/)
        :param str path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param int period: How frequently the logs should be transferred, in seconds. Default `3600`
        :param str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str timestamp_format: specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> str:
        """
        Your OpenStack account access key
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of your OpenStack container
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the OpenStack logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Your OpenStack auth url
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for your OpenStack account
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        What level of Gzip encoding to have when dumping logs (default `0`, no compression)
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted; one of: `classic`, `loggly`, `logplex` or `blank`. Default `classic`. [Fastly Documentation](https://developer.fastly.com/reference/api/logging/gcs/)
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently the logs should be transferred, in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeLoggingScalyr(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str,
                 region: Optional[str] = None):
        """
        :param str name: The unique name of the Scalyr logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The token to use for authentication (https://www.scalyr.com/keys)
        :param str region: The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Scalyr logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The token to use for authentication (https://www.scalyr.com/keys)
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class ServiceComputeLoggingSftp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshKnownHosts":
            suggest = "ssh_known_hosts"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeLoggingSftp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeLoggingSftp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeLoggingSftp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 name: str,
                 path: str,
                 ssh_known_hosts: str,
                 user: str,
                 compression_codec: Optional[str] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 password: Optional[str] = None,
                 period: Optional[int] = None,
                 port: Optional[int] = None,
                 public_key: Optional[str] = None,
                 secret_key: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str address: The SFTP address to stream logs to
        :param str name: The unique name of the SFTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str path: The path to upload log files to. If the path ends in `/` then it is treated as a directory
        :param str ssh_known_hosts: A list of host keys for all hosts we can connect to over SFTP
        :param str user: The username for the server
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param int gzip_level: What level of Gzip encoding to have when dumping logs (default `0`, no compression)
        :param str message_type: How the message should be formatted. One of: `classic` (default), `loggly`, `logplex` or `blank`
        :param str password: The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        :param int period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param int port: The port the SFTP service listens on. (Default: `22`)
        :param str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str secret_key: The SSH private key for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        :param str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "ssh_known_hosts", ssh_known_hosts)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The SFTP address to stream logs to
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the SFTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path to upload log files to. If the path ends in `/` then it is treated as a directory
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="sshKnownHosts")
    def ssh_known_hosts(self) -> str:
        """
        A list of host keys for all hosts we can connect to over SFTP
        """
        return pulumi.get(self, "ssh_known_hosts")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for the server
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        What level of Gzip encoding to have when dumping logs (default `0`, no compression)
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: `classic` (default), `loggly`, `logplex` or `blank`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port the SFTP service listens on. (Default: `22`)
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[str]:
        """
        The SSH private key for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputePackage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceCodeHash":
            suggest = "source_code_hash"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputePackage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputePackage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputePackage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filename: str,
                 source_code_hash: Optional[str] = None):
        """
        :param str filename: The path to the Wasm deployment package within your local filesystem
        :param str source_code_hash: Used to trigger updates. Must be set to a SHA512 hash of the package file specified with the filename.
        """
        pulumi.set(__self__, "filename", filename)
        if source_code_hash is not None:
            pulumi.set(__self__, "source_code_hash", source_code_hash)

    @property
    @pulumi.getter
    def filename(self) -> str:
        """
        The path to the Wasm deployment package within your local filesystem
        """
        return pulumi.get(self, "filename")

    @property
    @pulumi.getter(name="sourceCodeHash")
    def source_code_hash(self) -> Optional[str]:
        """
        Used to trigger updates. Must be set to a SHA512 hash of the package file specified with the filename.
        """
        return pulumi.get(self, "source_code_hash")


@pulumi.output_type
class ServiceComputePapertrail(dict):
    def __init__(__self__, *,
                 address: str,
                 name: str,
                 port: int):
        """
        :param str address: The address of the Papertrail endpoint
        :param str name: A unique name to identify this Papertrail endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param int port: The port associated with the address where the Papertrail endpoint can be accessed
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The address of the Papertrail endpoint
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this Papertrail endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port associated with the address where the Papertrail endpoint can be accessed
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServiceComputeS3logging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "s3AccessKey":
            suggest = "s3_access_key"
        elif key == "s3IamRole":
            suggest = "s3_iam_role"
        elif key == "s3SecretKey":
            suggest = "s3_secret_key"
        elif key == "serverSideEncryption":
            suggest = "server_side_encryption"
        elif key == "serverSideEncryptionKmsKeyId":
            suggest = "server_side_encryption_kms_key_id"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeS3logging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeS3logging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeS3logging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 name: str,
                 acl: Optional[str] = None,
                 compression_codec: Optional[str] = None,
                 domain: Optional[str] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[int] = None,
                 public_key: Optional[str] = None,
                 redundancy: Optional[str] = None,
                 s3_access_key: Optional[str] = None,
                 s3_iam_role: Optional[str] = None,
                 s3_secret_key: Optional[str] = None,
                 server_side_encryption: Optional[str] = None,
                 server_side_encryption_kms_key_id: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str bucket_name: The name of the bucket in which to store the logs
        :param str name: The unique name of the S3 logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str acl: The AWS [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) to use for objects uploaded to the S3 bucket. Options are: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param str domain: If you created the S3 bucket outside of `us-east-1`, then specify the corresponding bucket endpoint. Example: `s3-us-west-2.amazonaws.com`
        :param int gzip_level: Level of Gzip compression, from `0-9`. `0` is no compression. `1` is fastest and least compressed, `9` is slowest and most compressed. Default `0`
        :param str message_type: How the message should be formatted; one of: `classic`, `loggly`, `logplex` or `blank`. Default `classic`
        :param str path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param int period: How frequently the logs should be transferred, in seconds. Default `3600`
        :param str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str redundancy: The S3 storage class (redundancy level). Should be one of: `standard`, `reduced_redundancy`, `standard_ia`, or `onezone_ia`
        :param str s3_access_key: AWS Access Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This key will be not be encrypted. Not required if `iam_role` is provided. You can provide this key via an environment variable, `FASTLY_S3_ACCESS_KEY`
        :param str s3_iam_role: The Amazon Resource Name (ARN) for the IAM role granting Fastly access to S3. Not required if `access_key` and `secret_key` are provided. You can provide this value via an environment variable, `FASTLY_S3_IAM_ROLE`
        :param str s3_secret_key: AWS Secret Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This secret will be not be encrypted. Not required if `iam_role` is provided. You can provide this secret via an environment variable, `FASTLY_S3_SECRET_KEY`
        :param str server_side_encryption: Specify what type of server side encryption should be used. Can be either `AES256` or `aws:kms`
        :param str server_side_encryption_kms_key_id: Optional server-side KMS Key Id. Must be set if server*side*encryption is set to `aws:kms`
        :param str timestamp_format: `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if redundancy is not None:
            pulumi.set(__self__, "redundancy", redundancy)
        if s3_access_key is not None:
            pulumi.set(__self__, "s3_access_key", s3_access_key)
        if s3_iam_role is not None:
            pulumi.set(__self__, "s3_iam_role", s3_iam_role)
        if s3_secret_key is not None:
            pulumi.set(__self__, "s3_secret_key", s3_secret_key)
        if server_side_encryption is not None:
            pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        if server_side_encryption_kms_key_id is not None:
            pulumi.set(__self__, "server_side_encryption_kms_key_id", server_side_encryption_kms_key_id)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of the bucket in which to store the logs
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the S3 logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def acl(self) -> Optional[str]:
        """
        The AWS [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) to use for objects uploaded to the S3 bucket. Options are: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        If you created the S3 bucket outside of `us-east-1`, then specify the corresponding bucket endpoint. Example: `s3-us-west-2.amazonaws.com`
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        Level of Gzip compression, from `0-9`. `0` is no compression. `1` is fastest and least compressed, `9` is slowest and most compressed. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted; one of: `classic`, `loggly`, `logplex` or `blank`. Default `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently the logs should be transferred, in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def redundancy(self) -> Optional[str]:
        """
        The S3 storage class (redundancy level). Should be one of: `standard`, `reduced_redundancy`, `standard_ia`, or `onezone_ia`
        """
        return pulumi.get(self, "redundancy")

    @property
    @pulumi.getter(name="s3AccessKey")
    def s3_access_key(self) -> Optional[str]:
        """
        AWS Access Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This key will be not be encrypted. Not required if `iam_role` is provided. You can provide this key via an environment variable, `FASTLY_S3_ACCESS_KEY`
        """
        return pulumi.get(self, "s3_access_key")

    @property
    @pulumi.getter(name="s3IamRole")
    def s3_iam_role(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) for the IAM role granting Fastly access to S3. Not required if `access_key` and `secret_key` are provided. You can provide this value via an environment variable, `FASTLY_S3_IAM_ROLE`
        """
        return pulumi.get(self, "s3_iam_role")

    @property
    @pulumi.getter(name="s3SecretKey")
    def s3_secret_key(self) -> Optional[str]:
        """
        AWS Secret Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This secret will be not be encrypted. Not required if `iam_role` is provided. You can provide this secret via an environment variable, `FASTLY_S3_SECRET_KEY`
        """
        return pulumi.get(self, "s3_secret_key")

    @property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[str]:
        """
        Specify what type of server side encryption should be used. Can be either `AES256` or `aws:kms`
        """
        return pulumi.get(self, "server_side_encryption")

    @property
    @pulumi.getter(name="serverSideEncryptionKmsKeyId")
    def server_side_encryption_kms_key_id(self) -> Optional[str]:
        """
        Optional server-side KMS Key Id. Must be set if server*side*encryption is set to `aws:kms`
        """
        return pulumi.get(self, "server_side_encryption_kms_key_id")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class ServiceComputeSplunk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeSplunk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeSplunk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeSplunk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 token: str,
                 url: str,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None):
        """
        :param str name: A unique name to identify the Splunk endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The Splunk token to be used for authentication
        :param str url: The Splunk URL to stream logs to
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SPLUNK_CA_CERT`
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format.
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format.
        :param str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify the Splunk endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The Splunk token to be used for authentication
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The Splunk URL to stream logs to
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SPLUNK_CA_CERT`
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")


@pulumi.output_type
class ServiceComputeSumologic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageType":
            suggest = "message_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeSumologic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeSumologic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeSumologic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 url: str,
                 message_type: Optional[str] = None):
        """
        :param str name: A unique name to identify this Sumologic endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str url: The URL to Sumologic collector endpoint
        :param str message_type: How the message should be formatted; one of: `classic`, `loggly`, `logplex` or `blank`. Default `classic`. See [Fastly's Documentation on Sumologic](https://developer.fastly.com/reference/api/logging/sumologic/)
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this Sumologic endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL to Sumologic collector endpoint
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted; one of: `classic`, `loggly`, `logplex` or `blank`. Default `classic`. See [Fastly's Documentation on Sumologic](https://developer.fastly.com/reference/api/logging/sumologic/)
        """
        return pulumi.get(self, "message_type")


@pulumi.output_type
class ServiceComputeSyslog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageType":
            suggest = "message_type"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceComputeSyslog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceComputeSyslog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceComputeSyslog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 name: str,
                 message_type: Optional[str] = None,
                 port: Optional[int] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None,
                 token: Optional[str] = None,
                 use_tls: Optional[bool] = None):
        """
        :param str address: A hostname or IPv4 address of the Syslog endpoint
        :param str name: A unique name to identify this Syslog endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str message_type: How the message should be formatted; one of: `classic`, `loggly`, `logplex` or `blank`. Default `classic`
        :param int port: The port associated with the address where the Syslog endpoint can be accessed. Default `514`
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CA_CERT`
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CLIENT_CERT`
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format. You can provide this key via an environment variable, `FASTLY_SYSLOG_CLIENT_KEY`
        :param str tls_hostname: Used during the TLS handshake to validate the certificate
        :param str token: Whether to prepend each message with a specific token
        :param bool use_tls: Whether to use TLS for secure logging. Default `false`
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        A hostname or IPv4 address of the Syslog endpoint
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this Syslog endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted; one of: `classic`, `loggly`, `logplex` or `blank`. Default `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port associated with the address where the Syslog endpoint can be accessed. Default `514`
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CA_CERT`
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CLIENT_CERT`
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format. You can provide this key via an environment variable, `FASTLY_SYSLOG_CLIENT_KEY`
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        Used during the TLS handshake to validate the certificate
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter
    def token(self) -> Optional[str]:
        """
        Whether to prepend each message with a specific token
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[bool]:
        """
        Whether to use TLS for secure logging. Default `false`
        """
        return pulumi.get(self, "use_tls")


@pulumi.output_type
class ServiceWafConfigurationRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "modsecRuleId":
            suggest = "modsec_rule_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceWafConfigurationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceWafConfigurationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceWafConfigurationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 modsec_rule_id: int,
                 status: str,
                 revision: Optional[int] = None):
        """
        :param int modsec_rule_id: The Web Application Firewall rule's modsecurity ID
        :param str status: The Web Application Firewall rule's status. Allowed values are (`log`, `block` and `score`)
        :param int revision: The Web Application Firewall rule's revision. The latest revision will be used if this is not provided
        """
        pulumi.set(__self__, "modsec_rule_id", modsec_rule_id)
        pulumi.set(__self__, "status", status)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)

    @property
    @pulumi.getter(name="modsecRuleId")
    def modsec_rule_id(self) -> int:
        """
        The Web Application Firewall rule's modsecurity ID
        """
        return pulumi.get(self, "modsec_rule_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The Web Application Firewall rule's status. Allowed values are (`log`, `block` and `score`)
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def revision(self) -> Optional[int]:
        """
        The Web Application Firewall rule's revision. The latest revision will be used if this is not provided
        """
        return pulumi.get(self, "revision")


@pulumi.output_type
class ServiceWafConfigurationRuleExclusion(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exclusionType":
            suggest = "exclusion_type"
        elif key == "modsecRuleIds":
            suggest = "modsec_rule_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceWafConfigurationRuleExclusion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceWafConfigurationRuleExclusion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceWafConfigurationRuleExclusion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition: str,
                 exclusion_type: str,
                 name: str,
                 modsec_rule_ids: Optional[Sequence[int]] = None,
                 number: Optional[int] = None):
        """
        :param str condition: A conditional expression in VCL used to determine if the condition is met
        :param str exclusion_type: The type of rule exclusion. Values are `rule` to exclude the specified rule(s), or `waf` to disable the Web Application Firewall
        :param str name: The name of rule exclusion
        :param Sequence[int] modsec_rule_ids: Set of modsecurity IDs to be excluded. No rules should be provided when `exclusion_type` is `waf`. The rules need to be configured on the Web Application Firewall to be excluded
        :param int number: The numeric ID assigned to the WAF Rule Exclusion
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "exclusion_type", exclusion_type)
        pulumi.set(__self__, "name", name)
        if modsec_rule_ids is not None:
            pulumi.set(__self__, "modsec_rule_ids", modsec_rule_ids)
        if number is not None:
            pulumi.set(__self__, "number", number)

    @property
    @pulumi.getter
    def condition(self) -> str:
        """
        A conditional expression in VCL used to determine if the condition is met
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="exclusionType")
    def exclusion_type(self) -> str:
        """
        The type of rule exclusion. Values are `rule` to exclude the specified rule(s), or `waf` to disable the Web Application Firewall
        """
        return pulumi.get(self, "exclusion_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of rule exclusion
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="modsecRuleIds")
    def modsec_rule_ids(self) -> Optional[Sequence[int]]:
        """
        Set of modsecurity IDs to be excluded. No rules should be provided when `exclusion_type` is `waf`. The rules need to be configured on the Web Application Firewall to be excluded
        """
        return pulumi.get(self, "modsec_rule_ids")

    @property
    @pulumi.getter
    def number(self) -> Optional[int]:
        """
        The numeric ID assigned to the WAF Rule Exclusion
        """
        return pulumi.get(self, "number")


@pulumi.output_type
class Servicev1Acl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aclId":
            suggest = "acl_id"
        elif key == "forceDestroy":
            suggest = "force_destroy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1Acl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1Acl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1Acl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 acl_id: Optional[str] = None,
                 force_destroy: Optional[bool] = None):
        """
        :param str name: A unique name to identify this ACL. It is important to note that changing this attribute will delete and recreate the ACL, and discard the current items in the ACL
        :param str acl_id: The ID of the ACL
        :param bool force_destroy: Allow the ACL to be deleted, even if it contains entries. Defaults to false.
        """
        pulumi.set(__self__, "name", name)
        if acl_id is not None:
            pulumi.set(__self__, "acl_id", acl_id)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this ACL. It is important to note that changing this attribute will delete and recreate the ACL, and discard the current items in the ACL
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> Optional[str]:
        """
        The ID of the ACL
        """
        return pulumi.get(self, "acl_id")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[bool]:
        """
        Allow the ACL to be deleted, even if it contains entries. Defaults to false.
        """
        return pulumi.get(self, "force_destroy")


@pulumi.output_type
class Servicev1Backend(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoLoadbalance":
            suggest = "auto_loadbalance"
        elif key == "betweenBytesTimeout":
            suggest = "between_bytes_timeout"
        elif key == "connectTimeout":
            suggest = "connect_timeout"
        elif key == "errorThreshold":
            suggest = "error_threshold"
        elif key == "firstByteTimeout":
            suggest = "first_byte_timeout"
        elif key == "maxConn":
            suggest = "max_conn"
        elif key == "maxTlsVersion":
            suggest = "max_tls_version"
        elif key == "minTlsVersion":
            suggest = "min_tls_version"
        elif key == "overrideHost":
            suggest = "override_host"
        elif key == "requestCondition":
            suggest = "request_condition"
        elif key == "sslCaCert":
            suggest = "ssl_ca_cert"
        elif key == "sslCertHostname":
            suggest = "ssl_cert_hostname"
        elif key == "sslCheckCert":
            suggest = "ssl_check_cert"
        elif key == "sslCiphers":
            suggest = "ssl_ciphers"
        elif key == "sslClientCert":
            suggest = "ssl_client_cert"
        elif key == "sslClientKey":
            suggest = "ssl_client_key"
        elif key == "sslHostname":
            suggest = "ssl_hostname"
        elif key == "sslSniHostname":
            suggest = "ssl_sni_hostname"
        elif key == "useSsl":
            suggest = "use_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1Backend. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1Backend.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1Backend.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 name: str,
                 auto_loadbalance: Optional[bool] = None,
                 between_bytes_timeout: Optional[int] = None,
                 connect_timeout: Optional[int] = None,
                 error_threshold: Optional[int] = None,
                 first_byte_timeout: Optional[int] = None,
                 healthcheck: Optional[str] = None,
                 max_conn: Optional[int] = None,
                 max_tls_version: Optional[str] = None,
                 min_tls_version: Optional[str] = None,
                 override_host: Optional[str] = None,
                 port: Optional[int] = None,
                 request_condition: Optional[str] = None,
                 shield: Optional[str] = None,
                 ssl_ca_cert: Optional[str] = None,
                 ssl_cert_hostname: Optional[str] = None,
                 ssl_check_cert: Optional[bool] = None,
                 ssl_ciphers: Optional[str] = None,
                 ssl_client_cert: Optional[str] = None,
                 ssl_client_key: Optional[str] = None,
                 ssl_hostname: Optional[str] = None,
                 ssl_sni_hostname: Optional[str] = None,
                 use_ssl: Optional[bool] = None,
                 weight: Optional[int] = None):
        """
        :param str address: An IPv4, hostname, or IPv6 address for the Backend
        :param str name: Name for this Backend. Must be unique to this Service. It is important to note that changing this attribute will delete and recreate the resource
        :param bool auto_loadbalance: Denotes if this Backend should be included in the pool of backends that requests are load balanced against. Default `true`
        :param int between_bytes_timeout: How long to wait between bytes in milliseconds. Default `10000`
        :param int connect_timeout: How long to wait for a timeout in milliseconds. Default `1000`
        :param int error_threshold: Number of errors to allow before the Backend is marked as down. Default `0`
        :param int first_byte_timeout: How long to wait for the first bytes in milliseconds. Default `15000`
        :param str healthcheck: Name of a defined `healthcheck` to assign to this backend
        :param int max_conn: Maximum number of connections for this Backend. Default `200`
        :param str max_tls_version: Maximum allowed TLS version on SSL connections to this backend.
        :param str min_tls_version: Minimum allowed TLS version on SSL connections to this backend.
        :param str override_host: The hostname to override the Host header
        :param int port: The port number on which the Backend responds. Default `80`
        :param str request_condition: Name of a condition, which if met, will select this backend during a request.
        :param str shield: The POP of the shield designated to reduce inbound load. Valid values for `shield` are included in the `GET /datacenters` API response
        :param str ssl_ca_cert: CA certificate attached to origin.
        :param str ssl_cert_hostname: Overrides ssl_hostname, but only for cert verification. Does not affect SNI at all
        :param bool ssl_check_cert: Be strict about checking SSL certs. Default `true`
        :param str ssl_ciphers: Comma separated list of OpenSSL Ciphers to try when negotiating to the backend
        :param str ssl_client_cert: Client certificate attached to origin. Used when connecting to the backend
        :param str ssl_client_key: Client key attached to origin. Used when connecting to the backend
        :param str ssl_hostname: Used for both SNI during the TLS handshake and to validate the cert
        :param str ssl_sni_hostname: Overrides ssl_hostname, but only for SNI in the handshake. Does not affect cert validation at all
        :param bool use_ssl: Whether or not to use SSL to reach the Backend. Default `false`
        :param int weight: The [portion of traffic](https://docs.fastly.com/en/guides/load-balancing-configuration#how-weight-affects-load-balancing) to send to this Backend. Each Backend receives weight / total of the traffic. Default `100`
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        if auto_loadbalance is not None:
            pulumi.set(__self__, "auto_loadbalance", auto_loadbalance)
        if between_bytes_timeout is not None:
            pulumi.set(__self__, "between_bytes_timeout", between_bytes_timeout)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if error_threshold is not None:
            pulumi.set(__self__, "error_threshold", error_threshold)
        if first_byte_timeout is not None:
            pulumi.set(__self__, "first_byte_timeout", first_byte_timeout)
        if healthcheck is not None:
            pulumi.set(__self__, "healthcheck", healthcheck)
        if max_conn is not None:
            pulumi.set(__self__, "max_conn", max_conn)
        if max_tls_version is not None:
            pulumi.set(__self__, "max_tls_version", max_tls_version)
        if min_tls_version is not None:
            pulumi.set(__self__, "min_tls_version", min_tls_version)
        if override_host is not None:
            pulumi.set(__self__, "override_host", override_host)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if request_condition is not None:
            pulumi.set(__self__, "request_condition", request_condition)
        if shield is not None:
            pulumi.set(__self__, "shield", shield)
        if ssl_ca_cert is not None:
            pulumi.set(__self__, "ssl_ca_cert", ssl_ca_cert)
        if ssl_cert_hostname is not None:
            pulumi.set(__self__, "ssl_cert_hostname", ssl_cert_hostname)
        if ssl_check_cert is not None:
            pulumi.set(__self__, "ssl_check_cert", ssl_check_cert)
        if ssl_ciphers is not None:
            pulumi.set(__self__, "ssl_ciphers", ssl_ciphers)
        if ssl_client_cert is not None:
            pulumi.set(__self__, "ssl_client_cert", ssl_client_cert)
        if ssl_client_key is not None:
            pulumi.set(__self__, "ssl_client_key", ssl_client_key)
        if ssl_hostname is not None:
            pulumi.set(__self__, "ssl_hostname", ssl_hostname)
        if ssl_sni_hostname is not None:
            pulumi.set(__self__, "ssl_sni_hostname", ssl_sni_hostname)
        if use_ssl is not None:
            pulumi.set(__self__, "use_ssl", use_ssl)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        An IPv4, hostname, or IPv6 address for the Backend
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name for this Backend. Must be unique to this Service. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="autoLoadbalance")
    def auto_loadbalance(self) -> Optional[bool]:
        """
        Denotes if this Backend should be included in the pool of backends that requests are load balanced against. Default `true`
        """
        return pulumi.get(self, "auto_loadbalance")

    @property
    @pulumi.getter(name="betweenBytesTimeout")
    def between_bytes_timeout(self) -> Optional[int]:
        """
        How long to wait between bytes in milliseconds. Default `10000`
        """
        return pulumi.get(self, "between_bytes_timeout")

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[int]:
        """
        How long to wait for a timeout in milliseconds. Default `1000`
        """
        return pulumi.get(self, "connect_timeout")

    @property
    @pulumi.getter(name="errorThreshold")
    def error_threshold(self) -> Optional[int]:
        """
        Number of errors to allow before the Backend is marked as down. Default `0`
        """
        return pulumi.get(self, "error_threshold")

    @property
    @pulumi.getter(name="firstByteTimeout")
    def first_byte_timeout(self) -> Optional[int]:
        """
        How long to wait for the first bytes in milliseconds. Default `15000`
        """
        return pulumi.get(self, "first_byte_timeout")

    @property
    @pulumi.getter
    def healthcheck(self) -> Optional[str]:
        """
        Name of a defined `healthcheck` to assign to this backend
        """
        return pulumi.get(self, "healthcheck")

    @property
    @pulumi.getter(name="maxConn")
    def max_conn(self) -> Optional[int]:
        """
        Maximum number of connections for this Backend. Default `200`
        """
        return pulumi.get(self, "max_conn")

    @property
    @pulumi.getter(name="maxTlsVersion")
    def max_tls_version(self) -> Optional[str]:
        """
        Maximum allowed TLS version on SSL connections to this backend.
        """
        return pulumi.get(self, "max_tls_version")

    @property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> Optional[str]:
        """
        Minimum allowed TLS version on SSL connections to this backend.
        """
        return pulumi.get(self, "min_tls_version")

    @property
    @pulumi.getter(name="overrideHost")
    def override_host(self) -> Optional[str]:
        """
        The hostname to override the Host header
        """
        return pulumi.get(self, "override_host")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port number on which the Backend responds. Default `80`
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="requestCondition")
    def request_condition(self) -> Optional[str]:
        """
        Name of a condition, which if met, will select this backend during a request.
        """
        return pulumi.get(self, "request_condition")

    @property
    @pulumi.getter
    def shield(self) -> Optional[str]:
        """
        The POP of the shield designated to reduce inbound load. Valid values for `shield` are included in the `GET /datacenters` API response
        """
        return pulumi.get(self, "shield")

    @property
    @pulumi.getter(name="sslCaCert")
    def ssl_ca_cert(self) -> Optional[str]:
        """
        CA certificate attached to origin.
        """
        return pulumi.get(self, "ssl_ca_cert")

    @property
    @pulumi.getter(name="sslCertHostname")
    def ssl_cert_hostname(self) -> Optional[str]:
        """
        Overrides ssl_hostname, but only for cert verification. Does not affect SNI at all
        """
        return pulumi.get(self, "ssl_cert_hostname")

    @property
    @pulumi.getter(name="sslCheckCert")
    def ssl_check_cert(self) -> Optional[bool]:
        """
        Be strict about checking SSL certs. Default `true`
        """
        return pulumi.get(self, "ssl_check_cert")

    @property
    @pulumi.getter(name="sslCiphers")
    def ssl_ciphers(self) -> Optional[str]:
        """
        Comma separated list of OpenSSL Ciphers to try when negotiating to the backend
        """
        return pulumi.get(self, "ssl_ciphers")

    @property
    @pulumi.getter(name="sslClientCert")
    def ssl_client_cert(self) -> Optional[str]:
        """
        Client certificate attached to origin. Used when connecting to the backend
        """
        return pulumi.get(self, "ssl_client_cert")

    @property
    @pulumi.getter(name="sslClientKey")
    def ssl_client_key(self) -> Optional[str]:
        """
        Client key attached to origin. Used when connecting to the backend
        """
        return pulumi.get(self, "ssl_client_key")

    @property
    @pulumi.getter(name="sslHostname")
    def ssl_hostname(self) -> Optional[str]:
        """
        Used for both SNI during the TLS handshake and to validate the cert
        """
        return pulumi.get(self, "ssl_hostname")

    @property
    @pulumi.getter(name="sslSniHostname")
    def ssl_sni_hostname(self) -> Optional[str]:
        """
        Overrides ssl_hostname, but only for SNI in the handshake. Does not affect cert validation at all
        """
        return pulumi.get(self, "ssl_sni_hostname")

    @property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> Optional[bool]:
        """
        Whether or not to use SSL to reach the Backend. Default `false`
        """
        return pulumi.get(self, "use_ssl")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        """
        The [portion of traffic](https://docs.fastly.com/en/guides/load-balancing-configuration#how-weight-affects-load-balancing) to send to this Backend. Each Backend receives weight / total of the traffic. Default `100`
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class Servicev1Bigquerylogging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1Bigquerylogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1Bigquerylogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1Bigquerylogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset: str,
                 email: str,
                 name: str,
                 project_id: str,
                 secret_key: str,
                 table: str,
                 format: Optional[str] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 template: Optional[str] = None):
        """
        :param str dataset: The ID of your BigQuery dataset
        :param str email: The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable
        :param str name: A unique name to identify this BigQuery logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str project_id: The ID of your GCP project
        :param str secret_key: The secret key associated with the service account that has write access to your BigQuery table. If not provided, this will be pulled from the `FASTLY_BQ_SECRET_KEY` environment variable. Typical format for this is a private key in a string with newlines
        :param str table: The ID of your BigQuery table
        :param str format: The logging format desired.
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param str response_condition: Name of a condition to apply this logging.
        :param str template: BigQuery table name suffix template
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret_key", secret_key)
        pulumi.set(__self__, "table", table)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter
    def dataset(self) -> str:
        """
        The ID of your BigQuery dataset
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this BigQuery logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of your GCP project
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        """
        The secret key associated with the service account that has write access to your BigQuery table. If not provided, this will be pulled from the `FASTLY_BQ_SECRET_KEY` environment variable. Typical format for this is a private key in a string with newlines
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        The ID of your BigQuery table
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        The logging format desired.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        Name of a condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter
    def template(self) -> Optional[str]:
        """
        BigQuery table name suffix template
        """
        return pulumi.get(self, "template")


@pulumi.output_type
class Servicev1Blobstoragelogging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "sasToken":
            suggest = "sas_token"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "fileMaxBytes":
            suggest = "file_max_bytes"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1Blobstoragelogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1Blobstoragelogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1Blobstoragelogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_name: str,
                 container: str,
                 name: str,
                 sas_token: str,
                 compression_codec: Optional[str] = None,
                 file_max_bytes: Optional[int] = None,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[int] = None,
                 placement: Optional[str] = None,
                 public_key: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str account_name: The unique Azure Blob Storage namespace in which your data objects are stored
        :param str container: The name of the Azure Blob Storage container in which to store logs
        :param str name: A unique name to identify the Azure Blob Storage endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str sas_token: The Azure shared access signature providing write access to the blob service objects. Be sure to update your token before it expires or the logging functionality will not work
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param int file_max_bytes: Maximum size of an uploaded log file, if non-zero.
        :param str format: Apache-style string or VCL variables to use for log formatting (default: `%h %l %u %t "%r" %>s %b`)
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        :param int gzip_level: Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        :param str message_type: How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default `classic`
        :param str path: The path to upload logs to. Must end with a trailing slash. If this field is left empty, the files will be saved in the container's root path
        :param int period: How frequently the logs should be transferred in seconds. Default `3600`
        :param str placement: Where in the generated VCL the logging call should be placed
        :param str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str response_condition: The name of the condition to apply
        :param str timestamp_format: `strftime` specified timestamp formatting. Default `%Y-%m-%dT%H:%M:%S.000`
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sas_token", sas_token)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if file_max_bytes is not None:
            pulumi.set(__self__, "file_max_bytes", file_max_bytes)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        """
        The unique Azure Blob Storage namespace in which your data objects are stored
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter
    def container(self) -> str:
        """
        The name of the Azure Blob Storage container in which to store logs
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify the Azure Blob Storage endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> str:
        """
        The Azure shared access signature providing write access to the blob service objects. Be sure to update your token before it expires or the logging functionality will not work
        """
        return pulumi.get(self, "sas_token")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter(name="fileMaxBytes")
    def file_max_bytes(self) -> Optional[int]:
        """
        Maximum size of an uploaded log file, if non-zero.
        """
        return pulumi.get(self, "file_max_bytes")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting (default: `%h %l %u %t "%r" %>s %b`)
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        Level of Gzip compression from `0-9`. `0` means no compression. `1` is the fastest and the least compressed version, `9` is the slowest and the most compressed version. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. Can be either `classic`, `loggly`, `logplex` or `blank`. Default `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to upload logs to. Must end with a trailing slash. If this field is left empty, the files will be saved in the container's root path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently the logs should be transferred in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of the condition to apply
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        `strftime` specified timestamp formatting. Default `%Y-%m-%dT%H:%M:%S.000`
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class Servicev1CacheSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheCondition":
            suggest = "cache_condition"
        elif key == "staleTtl":
            suggest = "stale_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1CacheSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1CacheSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1CacheSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 action: Optional[str] = None,
                 cache_condition: Optional[str] = None,
                 stale_ttl: Optional[int] = None,
                 ttl: Optional[int] = None):
        """
        :param str name: Unique name for this Cache Setting. It is important to note that changing this attribute will delete and recreate the resource
        :param str action: One of cache, pass, or restart, as defined on Fastly's documentation under "[Caching action descriptions](https://docs.fastly.com/en/guides/controlling-caching#caching-action-descriptions)"
        :param str cache_condition: Name of already defined `condition` used to test whether this settings object should be used. This `condition` must be of type `CACHE`
        :param int stale_ttl: Max "Time To Live" for stale (unreachable) objects
        :param int ttl: The Time-To-Live (TTL) for the object
        """
        pulumi.set(__self__, "name", name)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if cache_condition is not None:
            pulumi.set(__self__, "cache_condition", cache_condition)
        if stale_ttl is not None:
            pulumi.set(__self__, "stale_ttl", stale_ttl)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique name for this Cache Setting. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        One of cache, pass, or restart, as defined on Fastly's documentation under "[Caching action descriptions](https://docs.fastly.com/en/guides/controlling-caching#caching-action-descriptions)"
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="cacheCondition")
    def cache_condition(self) -> Optional[str]:
        """
        Name of already defined `condition` used to test whether this settings object should be used. This `condition` must be of type `CACHE`
        """
        return pulumi.get(self, "cache_condition")

    @property
    @pulumi.getter(name="staleTtl")
    def stale_ttl(self) -> Optional[int]:
        """
        Max "Time To Live" for stale (unreachable) objects
        """
        return pulumi.get(self, "stale_ttl")

    @property
    @pulumi.getter
    def ttl(self) -> Optional[int]:
        """
        The Time-To-Live (TTL) for the object
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class Servicev1Condition(dict):
    def __init__(__self__, *,
                 name: str,
                 statement: str,
                 type: str,
                 priority: Optional[int] = None):
        """
        :param str name: The unique name for the condition. It is important to note that changing this attribute will delete and recreate the resource
        :param str statement: The statement used to determine if the condition is met
        :param str type: Type of condition, either `REQUEST` (req), `RESPONSE` (req, resp), or `CACHE` (req, beresp)
        :param int priority: A number used to determine the order in which multiple conditions execute. Lower numbers execute first. Default `10`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "statement", statement)
        pulumi.set(__self__, "type", type)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name for the condition. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def statement(self) -> str:
        """
        The statement used to determine if the condition is met
        """
        return pulumi.get(self, "statement")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of condition, either `REQUEST` (req), `RESPONSE` (req, resp), or `CACHE` (req, beresp)
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        A number used to determine the order in which multiple conditions execute. Lower numbers execute first. Default `10`
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class Servicev1Dictionary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dictionaryId":
            suggest = "dictionary_id"
        elif key == "forceDestroy":
            suggest = "force_destroy"
        elif key == "writeOnly":
            suggest = "write_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1Dictionary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1Dictionary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1Dictionary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 dictionary_id: Optional[str] = None,
                 force_destroy: Optional[bool] = None,
                 write_only: Optional[bool] = None):
        """
        :param str name: A unique name to identify this dictionary. It is important to note that changing this attribute will delete and recreate the dictionary, and discard the current items in the dictionary
        :param str dictionary_id: The ID of the dictionary
        :param bool force_destroy: Allow the dictionary to be deleted, even if it contains entries. Defaults to false.
        :param bool write_only: If `true`, the dictionary is a private dictionary, and items are not readable in the UI or via API. Default is `false`. It is important to note that changing this attribute will delete and recreate the dictionary, and discard the current items in the dictionary. Using a write-only/private dictionary should only be done if the items are managed outside of the provider
        """
        pulumi.set(__self__, "name", name)
        if dictionary_id is not None:
            pulumi.set(__self__, "dictionary_id", dictionary_id)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if write_only is not None:
            pulumi.set(__self__, "write_only", write_only)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary. It is important to note that changing this attribute will delete and recreate the dictionary, and discard the current items in the dictionary
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="dictionaryId")
    def dictionary_id(self) -> Optional[str]:
        """
        The ID of the dictionary
        """
        return pulumi.get(self, "dictionary_id")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[bool]:
        """
        Allow the dictionary to be deleted, even if it contains entries. Defaults to false.
        """
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter(name="writeOnly")
    def write_only(self) -> Optional[bool]:
        """
        If `true`, the dictionary is a private dictionary, and items are not readable in the UI or via API. Default is `false`. It is important to note that changing this attribute will delete and recreate the dictionary, and discard the current items in the dictionary. Using a write-only/private dictionary should only be done if the items are managed outside of the provider
        """
        return pulumi.get(self, "write_only")


@pulumi.output_type
class Servicev1Director(dict):
    def __init__(__self__, *,
                 backends: Sequence[str],
                 name: str,
                 capacity: Optional[int] = None,
                 comment: Optional[str] = None,
                 quorum: Optional[int] = None,
                 retries: Optional[int] = None,
                 shield: Optional[str] = None,
                 type: Optional[int] = None):
        """
        :param Sequence[str] backends: Names of defined backends to map the director to. Example: `[ "origin1", "origin2" ]`
        :param str name: Unique name for this Director. It is important to note that changing this attribute will delete and recreate the resource
        :param int capacity: Load balancing weight for the backends. Default `100`
        :param str comment: An optional comment about the Director
        :param int quorum: Percentage of capacity that needs to be up for the director itself to be considered up. Default `75`
        :param int retries: How many backends to search if it fails. Default `5`
        :param str shield: Selected POP to serve as a "shield" for backends. Valid values for `shield` are included in the [`GET /datacenters`](https://developer.fastly.com/reference/api/utils/datacenter/) API response
        :param int type: Type of load balance group to use. Integer, 1 to 4. Values: `1` (random), `3` (hash), `4` (client). Default `1`
        """
        pulumi.set(__self__, "backends", backends)
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if quorum is not None:
            pulumi.set(__self__, "quorum", quorum)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if shield is not None:
            pulumi.set(__self__, "shield", shield)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def backends(self) -> Sequence[str]:
        """
        Names of defined backends to map the director to. Example: `[ "origin1", "origin2" ]`
        """
        return pulumi.get(self, "backends")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique name for this Director. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        Load balancing weight for the backends. Default `100`
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        """
        An optional comment about the Director
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def quorum(self) -> Optional[int]:
        """
        Percentage of capacity that needs to be up for the director itself to be considered up. Default `75`
        """
        return pulumi.get(self, "quorum")

    @property
    @pulumi.getter
    def retries(self) -> Optional[int]:
        """
        How many backends to search if it fails. Default `5`
        """
        return pulumi.get(self, "retries")

    @property
    @pulumi.getter
    def shield(self) -> Optional[str]:
        """
        Selected POP to serve as a "shield" for backends. Valid values for `shield` are included in the [`GET /datacenters`](https://developer.fastly.com/reference/api/utils/datacenter/) API response
        """
        return pulumi.get(self, "shield")

    @property
    @pulumi.getter
    def type(self) -> Optional[int]:
        """
        Type of load balance group to use. Integer, 1 to 4. Values: `1` (random), `3` (hash), `4` (client). Default `1`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class Servicev1Domain(dict):
    def __init__(__self__, *,
                 name: str,
                 comment: Optional[str] = None):
        """
        :param str name: The domain that this Service will respond to. It is important to note that changing this attribute will delete and recreate the resource.
        :param str comment: An optional comment about the Domain.
        """
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The domain that this Service will respond to. It is important to note that changing this attribute will delete and recreate the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        """
        An optional comment about the Domain.
        """
        return pulumi.get(self, "comment")


@pulumi.output_type
class Servicev1Dynamicsnippet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snippetId":
            suggest = "snippet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1Dynamicsnippet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1Dynamicsnippet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1Dynamicsnippet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 type: str,
                 priority: Optional[int] = None,
                 snippet_id: Optional[str] = None):
        """
        :param str name: A name that is unique across "regular" and "dynamic" VCL Snippet configuration blocks. It is important to note that changing this attribute will delete and recreate the resource
        :param str type: The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`)
        :param int priority: Priority determines the ordering for multiple snippets. Lower numbers execute first. Defaults to `100`
        :param str snippet_id: The ID of the dynamic snippet
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if snippet_id is not None:
            pulumi.set(__self__, "snippet_id", snippet_id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A name that is unique across "regular" and "dynamic" VCL Snippet configuration blocks. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`)
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Priority determines the ordering for multiple snippets. Lower numbers execute first. Defaults to `100`
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="snippetId")
    def snippet_id(self) -> Optional[str]:
        """
        The ID of the dynamic snippet
        """
        return pulumi.get(self, "snippet_id")


@pulumi.output_type
class Servicev1Gcslogging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1Gcslogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1Gcslogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1Gcslogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 name: str,
                 compression_codec: Optional[str] = None,
                 email: Optional[str] = None,
                 format: Optional[str] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[int] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 secret_key: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str bucket_name: The name of the bucket in which to store the logs
        :param str name: A unique name to identify this GCS endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param str email: The email address associated with the target GCS bucket on your account. You may optionally provide this secret via an environment variable, `FASTLY_GCS_EMAIL`
        :param str format: Apache-style string or VCL variables to use for log formatting
        :param int gzip_level: Level of Gzip compression, from `0-9`. `0` is no compression. `1` is fastest and least compressed, `9` is slowest and most compressed. Default `0`
        :param str message_type: How the message should be formatted; one of: `classic`, `loggly`, `logplex` or `blank`. Default `classic`. [Fastly Documentation](https://developer.fastly.com/reference/api/logging/gcs/)
        :param str path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param int period: How frequently the logs should be transferred, in seconds (Default 3600)
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param str response_condition: Name of a condition to apply this logging.
        :param str secret_key: The secret key associated with the target gcs bucket on your account. You may optionally provide this secret via an environment variable, `FASTLY_GCS_SECRET_KEY`. A typical format for the key is PEM format, containing actual newline characters where required
        :param str timestamp_format: specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of the bucket in which to store the logs
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this GCS endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        The email address associated with the target GCS bucket on your account. You may optionally provide this secret via an environment variable, `FASTLY_GCS_EMAIL`
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        Level of Gzip compression, from `0-9`. `0` is no compression. `1` is fastest and least compressed, `9` is slowest and most compressed. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted; one of: `classic`, `loggly`, `logplex` or `blank`. Default `classic`. [Fastly Documentation](https://developer.fastly.com/reference/api/logging/gcs/)
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently the logs should be transferred, in seconds (Default 3600)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        Name of a condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[str]:
        """
        The secret key associated with the target gcs bucket on your account. You may optionally provide this secret via an environment variable, `FASTLY_GCS_SECRET_KEY`. A typical format for the key is PEM format, containing actual newline characters where required
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class Servicev1Gzip(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheCondition":
            suggest = "cache_condition"
        elif key == "contentTypes":
            suggest = "content_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1Gzip. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1Gzip.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1Gzip.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 cache_condition: Optional[str] = None,
                 content_types: Optional[Sequence[str]] = None,
                 extensions: Optional[Sequence[str]] = None):
        """
        :param str name: A name to refer to this gzip condition. It is important to note that changing this attribute will delete and recreate the resource
        :param str cache_condition: Name of already defined `condition` controlling when this gzip configuration applies. This `condition` must be of type `CACHE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        :param Sequence[str] content_types: The content-type for each type of content you wish to have dynamically gzip'ed. Example: `["text/html", "text/css"]`
        :param Sequence[str] extensions: File extensions for each file type to dynamically gzip. Example: `["css", "js"]`
        """
        pulumi.set(__self__, "name", name)
        if cache_condition is not None:
            pulumi.set(__self__, "cache_condition", cache_condition)
        if content_types is not None:
            pulumi.set(__self__, "content_types", content_types)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A name to refer to this gzip condition. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="cacheCondition")
    def cache_condition(self) -> Optional[str]:
        """
        Name of already defined `condition` controlling when this gzip configuration applies. This `condition` must be of type `CACHE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        """
        return pulumi.get(self, "cache_condition")

    @property
    @pulumi.getter(name="contentTypes")
    def content_types(self) -> Optional[Sequence[str]]:
        """
        The content-type for each type of content you wish to have dynamically gzip'ed. Example: `["text/html", "text/css"]`
        """
        return pulumi.get(self, "content_types")

    @property
    @pulumi.getter
    def extensions(self) -> Optional[Sequence[str]]:
        """
        File extensions for each file type to dynamically gzip. Example: `["css", "js"]`
        """
        return pulumi.get(self, "extensions")


@pulumi.output_type
class Servicev1Header(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheCondition":
            suggest = "cache_condition"
        elif key == "ignoreIfSet":
            suggest = "ignore_if_set"
        elif key == "requestCondition":
            suggest = "request_condition"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1Header. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1Header.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1Header.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 destination: str,
                 name: str,
                 type: str,
                 cache_condition: Optional[str] = None,
                 ignore_if_set: Optional[bool] = None,
                 priority: Optional[int] = None,
                 regex: Optional[str] = None,
                 request_condition: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 source: Optional[str] = None,
                 substitution: Optional[str] = None):
        """
        :param str action: The Header manipulation action to take; must be one of `set`, `append`, `delete`, `regex`, or `regex_repeat`
        :param str destination: The name of the header that is going to be affected by the Action
        :param str name: Unique name for this header attribute. It is important to note that changing this attribute will delete and recreate the resource
        :param str type: The Request type on which to apply the selected Action; must be one of `request`, `fetch`, `cache` or `response`
        :param str cache_condition: Name of already defined `condition` to apply. This `condition` must be of type `CACHE`
        :param bool ignore_if_set: Don't add the header if it is already. (Only applies to `set` action.). Default `false`
        :param int priority: Lower priorities execute first. Default: `100`
        :param str regex: Regular expression to use (Only applies to `regex` and `regex_repeat` actions.)
        :param str request_condition: Name of already defined `condition` to apply. This `condition` must be of type `REQUEST`
        :param str response_condition: Name of already defined `condition` to apply. This `condition` must be of type `RESPONSE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        :param str source: Variable to be used as a source for the header content (Does not apply to `delete` action.)
        :param str substitution: Value to substitute in place of regular expression. (Only applies to `regex` and `regex_repeat`.)
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if cache_condition is not None:
            pulumi.set(__self__, "cache_condition", cache_condition)
        if ignore_if_set is not None:
            pulumi.set(__self__, "ignore_if_set", ignore_if_set)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)
        if request_condition is not None:
            pulumi.set(__self__, "request_condition", request_condition)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if substitution is not None:
            pulumi.set(__self__, "substitution", substitution)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The Header manipulation action to take; must be one of `set`, `append`, `delete`, `regex`, or `regex_repeat`
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        The name of the header that is going to be affected by the Action
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique name for this header attribute. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The Request type on which to apply the selected Action; must be one of `request`, `fetch`, `cache` or `response`
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="cacheCondition")
    def cache_condition(self) -> Optional[str]:
        """
        Name of already defined `condition` to apply. This `condition` must be of type `CACHE`
        """
        return pulumi.get(self, "cache_condition")

    @property
    @pulumi.getter(name="ignoreIfSet")
    def ignore_if_set(self) -> Optional[bool]:
        """
        Don't add the header if it is already. (Only applies to `set` action.). Default `false`
        """
        return pulumi.get(self, "ignore_if_set")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Lower priorities execute first. Default: `100`
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def regex(self) -> Optional[str]:
        """
        Regular expression to use (Only applies to `regex` and `regex_repeat` actions.)
        """
        return pulumi.get(self, "regex")

    @property
    @pulumi.getter(name="requestCondition")
    def request_condition(self) -> Optional[str]:
        """
        Name of already defined `condition` to apply. This `condition` must be of type `REQUEST`
        """
        return pulumi.get(self, "request_condition")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        Name of already defined `condition` to apply. This `condition` must be of type `RESPONSE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        Variable to be used as a source for the header content (Does not apply to `delete` action.)
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def substitution(self) -> Optional[str]:
        """
        Value to substitute in place of regular expression. (Only applies to `regex` and `regex_repeat`.)
        """
        return pulumi.get(self, "substitution")


@pulumi.output_type
class Servicev1Healthcheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "checkInterval":
            suggest = "check_interval"
        elif key == "expectedResponse":
            suggest = "expected_response"
        elif key == "httpVersion":
            suggest = "http_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1Healthcheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1Healthcheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1Healthcheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: str,
                 name: str,
                 path: str,
                 check_interval: Optional[int] = None,
                 expected_response: Optional[int] = None,
                 http_version: Optional[str] = None,
                 initial: Optional[int] = None,
                 method: Optional[str] = None,
                 threshold: Optional[int] = None,
                 timeout: Optional[int] = None,
                 window: Optional[int] = None):
        """
        :param str host: The Host header to send for this Healthcheck
        :param str name: A unique name to identify this Healthcheck. It is important to note that changing this attribute will delete and recreate the resource
        :param str path: The path to check
        :param int check_interval: How often to run the Healthcheck in milliseconds. Default `5000`
        :param int expected_response: The status code expected from the host. Default `200`
        :param str http_version: Whether to use version 1.0 or 1.1 HTTP. Default `1.1`
        :param int initial: When loading a config, the initial number of probes to be seen as OK. Default `3`
        :param str method: Which HTTP method to use. Default `HEAD`
        :param int threshold: How many Healthchecks must succeed to be considered healthy. Default `3`
        :param int timeout: Timeout in milliseconds. Default `500`
        :param int window: The number of most recent Healthcheck queries to keep for this Healthcheck. Default `5`
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        if check_interval is not None:
            pulumi.set(__self__, "check_interval", check_interval)
        if expected_response is not None:
            pulumi.set(__self__, "expected_response", expected_response)
        if http_version is not None:
            pulumi.set(__self__, "http_version", http_version)
        if initial is not None:
            pulumi.set(__self__, "initial", initial)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if window is not None:
            pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The Host header to send for this Healthcheck
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this Healthcheck. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path to check
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> Optional[int]:
        """
        How often to run the Healthcheck in milliseconds. Default `5000`
        """
        return pulumi.get(self, "check_interval")

    @property
    @pulumi.getter(name="expectedResponse")
    def expected_response(self) -> Optional[int]:
        """
        The status code expected from the host. Default `200`
        """
        return pulumi.get(self, "expected_response")

    @property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> Optional[str]:
        """
        Whether to use version 1.0 or 1.1 HTTP. Default `1.1`
        """
        return pulumi.get(self, "http_version")

    @property
    @pulumi.getter
    def initial(self) -> Optional[int]:
        """
        When loading a config, the initial number of probes to be seen as OK. Default `3`
        """
        return pulumi.get(self, "initial")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        Which HTTP method to use. Default `HEAD`
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def threshold(self) -> Optional[int]:
        """
        How many Healthchecks must succeed to be considered healthy. Default `3`
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        Timeout in milliseconds. Default `500`
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def window(self) -> Optional[int]:
        """
        The number of most recent Healthcheck queries to keep for this Healthcheck. Default `5`
        """
        return pulumi.get(self, "window")


@pulumi.output_type
class Servicev1Httpslogging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "headerName":
            suggest = "header_name"
        elif key == "headerValue":
            suggest = "header_value"
        elif key == "jsonFormat":
            suggest = "json_format"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "requestMaxBytes":
            suggest = "request_max_bytes"
        elif key == "requestMaxEntries":
            suggest = "request_max_entries"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1Httpslogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1Httpslogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1Httpslogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 url: str,
                 content_type: Optional[str] = None,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 header_name: Optional[str] = None,
                 header_value: Optional[str] = None,
                 json_format: Optional[str] = None,
                 message_type: Optional[str] = None,
                 method: Optional[str] = None,
                 placement: Optional[str] = None,
                 request_max_bytes: Optional[int] = None,
                 request_max_entries: Optional[int] = None,
                 response_condition: Optional[str] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None):
        """
        :param str name: The unique name of the HTTPS logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str url: URL that log data will be sent to. Must use the https protocol
        :param str content_type: Value of the `Content-Type` header sent with the request
        :param str format: Apache-style string or VCL variables to use for log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        :param str header_name: Custom header sent with the request
        :param str header_value: Value of the custom header sent with the request
        :param str json_format: Formats log entries as JSON. Can be either disabled (`0`), array of json (`1`), or newline delimited json (`2`)
        :param str message_type: How the message should be formatted; one of: `classic`, `loggly`, `logplex` or `blank`. Default `blank`
        :param str method: HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`
        :param str placement: Where in the generated VCL the logging call should be placed
        :param int request_max_bytes: The maximum number of bytes sent in one request
        :param int request_max_entries: The maximum number of logs sent in one request
        :param str response_condition: The name of the condition to apply
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param str tls_hostname: Used during the TLS handshake to validate the certificate
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if header_name is not None:
            pulumi.set(__self__, "header_name", header_name)
        if header_value is not None:
            pulumi.set(__self__, "header_value", header_value)
        if json_format is not None:
            pulumi.set(__self__, "json_format", json_format)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if request_max_entries is not None:
            pulumi.set(__self__, "request_max_entries", request_max_entries)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the HTTPS logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        URL that log data will be sent to. Must use the https protocol
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[str]:
        """
        Value of the `Content-Type` header sent with the request
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> Optional[str]:
        """
        Custom header sent with the request
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> Optional[str]:
        """
        Value of the custom header sent with the request
        """
        return pulumi.get(self, "header_value")

    @property
    @pulumi.getter(name="jsonFormat")
    def json_format(self) -> Optional[str]:
        """
        Formats log entries as JSON. Can be either disabled (`0`), array of json (`1`), or newline delimited json (`2`)
        """
        return pulumi.get(self, "json_format")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted; one of: `classic`, `loggly`, `logplex` or `blank`. Default `blank`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[int]:
        """
        The maximum number of bytes sent in one request
        """
        return pulumi.get(self, "request_max_bytes")

    @property
    @pulumi.getter(name="requestMaxEntries")
    def request_max_entries(self) -> Optional[int]:
        """
        The maximum number of logs sent in one request
        """
        return pulumi.get(self, "request_max_entries")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of the condition to apply
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        Used during the TLS handshake to validate the certificate
        """
        return pulumi.get(self, "tls_hostname")


@pulumi.output_type
class Servicev1Logentry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1Logentry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1Logentry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1Logentry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 token: str,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 placement: Optional[str] = None,
                 port: Optional[int] = None,
                 response_condition: Optional[str] = None,
                 use_tls: Optional[bool] = None):
        """
        :param str name: The unique name of the Logentries logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: Use token based authentication (https://logentries.com/doc/input-token/)
        :param str format: Apache-style string or VCL variables to use for log formatting
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 1)
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param int port: The port number configured in Logentries
        :param str response_condition: Name of blockAttributes condition to apply this logging.
        :param bool use_tls: Whether to use TLS for secure logging
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Logentries logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        Use token based authentication (https://logentries.com/doc/input-token/)
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 1)
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port number configured in Logentries
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        Name of blockAttributes condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[bool]:
        """
        Whether to use TLS for secure logging
        """
        return pulumi.get(self, "use_tls")


@pulumi.output_type
class Servicev1LoggingCloudfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1LoggingCloudfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1LoggingCloudfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1LoggingCloudfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: str,
                 bucket_name: str,
                 name: str,
                 user: str,
                 compression_codec: Optional[str] = None,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[int] = None,
                 placement: Optional[str] = None,
                 public_key: Optional[str] = None,
                 region: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str access_key: Your Cloud File account access key
        :param str bucket_name: The name of your Cloud Files container
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str user: The username for your Cloud Files account
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param str format: Apache style log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param int gzip_level: What level of GZIP encoding to have when dumping logs (default `0`, no compression)
        :param str message_type: How the message should be formatted. One of: `classic` (default), `loggly`, `logplex` or `blank`
        :param str path: The path to upload logs to
        :param int period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str region: The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong)
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> str:
        """
        Your Cloud File account access key
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of your Cloud Files container
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for your Cloud Files account
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        What level of GZIP encoding to have when dumping logs (default `0`, no compression)
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: `classic` (default), `loggly`, `logplex` or `blank`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to upload logs to
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong)
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class Servicev1LoggingDatadog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1LoggingDatadog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1LoggingDatadog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1LoggingDatadog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 token: str,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 placement: Optional[str] = None,
                 region: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str name: The unique name of the Datadog logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The API key from your Datadog account
        :param str format: Apache-style string or VCL variables to use for log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param str region: The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        :param str response_condition: The name of the condition to apply.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Datadog logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The API key from your Datadog account
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of the condition to apply.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class Servicev1LoggingDigitalocean(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1LoggingDigitalocean. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1LoggingDigitalocean.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1LoggingDigitalocean.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: str,
                 bucket_name: str,
                 name: str,
                 secret_key: str,
                 compression_codec: Optional[str] = None,
                 domain: Optional[str] = None,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[int] = None,
                 placement: Optional[str] = None,
                 public_key: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str access_key: Your DigitalOcean Spaces account access key
        :param str bucket_name: The name of the DigitalOcean Space
        :param str name: The unique name of the DigitalOcean Spaces logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str secret_key: Your DigitalOcean Spaces account secret key
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param str domain: The domain of the DigitalOcean Spaces endpoint (default `nyc3.digitaloceanspaces.com`)
        :param str format: Apache style log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param int gzip_level: What level of Gzip encoding to have when dumping logs (default `0`, no compression)
        :param str message_type: How the message should be formatted. One of: `classic` (default), `loggly`, `logplex` or `blank`
        :param str path: The path to upload logs to
        :param int period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param str timestamp_format: `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret_key", secret_key)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> str:
        """
        Your DigitalOcean Spaces account access key
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of the DigitalOcean Space
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the DigitalOcean Spaces logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        """
        Your DigitalOcean Spaces account secret key
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        The domain of the DigitalOcean Spaces endpoint (default `nyc3.digitaloceanspaces.com`)
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        What level of Gzip encoding to have when dumping logs (default `0`, no compression)
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: `classic` (default), `loggly`, `logplex` or `blank`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to upload logs to
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class Servicev1LoggingElasticsearch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "requestMaxBytes":
            suggest = "request_max_bytes"
        elif key == "requestMaxEntries":
            suggest = "request_max_entries"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1LoggingElasticsearch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1LoggingElasticsearch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1LoggingElasticsearch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index: str,
                 name: str,
                 url: str,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 password: Optional[str] = None,
                 pipeline: Optional[str] = None,
                 placement: Optional[str] = None,
                 request_max_bytes: Optional[int] = None,
                 request_max_entries: Optional[int] = None,
                 response_condition: Optional[str] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None,
                 user: Optional[str] = None):
        """
        :param str index: The name of the Elasticsearch index to send documents (logs) to
        :param str name: The unique name of the Elasticsearch logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str url: The Elasticsearch URL to stream logs to
        :param str format: Apache-style string or VCL variables to use for log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param str password: BasicAuth password for Elasticsearch
        :param str pipeline: The ID of the Elasticsearch ingest pipeline to apply pre-process transformations to before indexing
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param int request_max_bytes: The maximum number of logs sent in one request. Defaults to `0` for unbounded
        :param int request_max_entries: The maximum number of bytes sent in one request. Defaults to `0` for unbounded
        :param str response_condition: The name of the condition to apply
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name (CN) or a Subject Alternative Name (SAN)
        :param str user: BasicAuth username for Elasticsearch
        """
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pipeline is not None:
            pulumi.set(__self__, "pipeline", pipeline)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if request_max_entries is not None:
            pulumi.set(__self__, "request_max_entries", request_max_entries)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def index(self) -> str:
        """
        The name of the Elasticsearch index to send documents (logs) to
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Elasticsearch logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The Elasticsearch URL to stream logs to
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        BasicAuth password for Elasticsearch
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def pipeline(self) -> Optional[str]:
        """
        The ID of the Elasticsearch ingest pipeline to apply pre-process transformations to before indexing
        """
        return pulumi.get(self, "pipeline")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[int]:
        """
        The maximum number of logs sent in one request. Defaults to `0` for unbounded
        """
        return pulumi.get(self, "request_max_bytes")

    @property
    @pulumi.getter(name="requestMaxEntries")
    def request_max_entries(self) -> Optional[int]:
        """
        The maximum number of bytes sent in one request. Defaults to `0` for unbounded
        """
        return pulumi.get(self, "request_max_entries")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of the condition to apply
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name (CN) or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        BasicAuth username for Elasticsearch
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class Servicev1LoggingFtp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1LoggingFtp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1LoggingFtp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1LoggingFtp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 name: str,
                 password: str,
                 path: str,
                 user: str,
                 compression_codec: Optional[str] = None,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 period: Optional[int] = None,
                 placement: Optional[str] = None,
                 port: Optional[int] = None,
                 public_key: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str address: The FTP address to stream logs to
        :param str name: The unique name of the FTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str password: The password for the server (for anonymous use an email address)
        :param str path: The path to upload log files to. If the path ends in `/` then it is treated as a directory
        :param str user: The username for the server (can be `anonymous`)
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param str format: Apache-style string or VCL variables to use for log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param int gzip_level: Gzip Compression level. Default `0`
        :param str message_type: How the message should be formatted (default: `classic`)
        :param int period: How frequently the logs should be transferred, in seconds (Default `3600`)
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param int port: The port number. Default: `21`
        :param str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str response_condition: The name of the condition to apply.
        :param str timestamp_format: specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The FTP address to stream logs to
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the FTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password for the server (for anonymous use an email address)
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path to upload log files to. If the path ends in `/` then it is treated as a directory
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for the server (can be `anonymous`)
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        Gzip Compression level. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted (default: `classic`)
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently the logs should be transferred, in seconds (Default `3600`)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port number. Default: `21`
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of the condition to apply.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class Servicev1LoggingGooglepubsub(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1LoggingGooglepubsub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1LoggingGooglepubsub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1LoggingGooglepubsub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 project_id: str,
                 secret_key: str,
                 topic: str,
                 user: str,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str name: The unique name of the Google Cloud Pub/Sub logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str project_id: The ID of your Google Cloud Platform project
        :param str secret_key: Your Google Cloud Platform account secret key. The `private_key` field in your service account authentication JSON. You may optionally provide this secret via an environment variable, `FASTLY_GOOGLE_PUBSUB_SECRET_KEY`.
        :param str topic: The Google Cloud Pub/Sub topic to which logs will be published
        :param str user: Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GOOGLE_PUBSUB_EMAIL`.
        :param str format: Apache style log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret_key", secret_key)
        pulumi.set(__self__, "topic", topic)
        pulumi.set(__self__, "user", user)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Google Cloud Pub/Sub logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of your Google Cloud Platform project
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        """
        Your Google Cloud Platform account secret key. The `private_key` field in your service account authentication JSON. You may optionally provide this secret via an environment variable, `FASTLY_GOOGLE_PUBSUB_SECRET_KEY`.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The Google Cloud Pub/Sub topic to which logs will be published
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        Your Google Cloud Platform service account email address. The `client_email` field in your service account authentication JSON. You may optionally provide this via an environment variable, `FASTLY_GOOGLE_PUBSUB_EMAIL`.
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class Servicev1LoggingHeroku(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1LoggingHeroku. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1LoggingHeroku.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1LoggingHeroku.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 token: str,
                 url: str,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str name: The unique name of the Heroku logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The token to use for authentication (https://www.heroku.com/docs/customer-token-authentication-token/)
        :param str url: The URL to stream logs to
        :param str format: Apache-style string or VCL variables to use for log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Heroku logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The token to use for authentication (https://www.heroku.com/docs/customer-token-authentication-token/)
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL to stream logs to
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class Servicev1LoggingHoneycomb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1LoggingHoneycomb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1LoggingHoneycomb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1LoggingHoneycomb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset: str,
                 name: str,
                 token: str,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str dataset: The Honeycomb Dataset you want to log to
        :param str name: The unique name of the Honeycomb logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The Write Key from the Account page of your Honeycomb account
        :param str format: Apache style log formatting. Your log must produce valid JSON that Honeycomb can ingest.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def dataset(self) -> str:
        """
        The Honeycomb Dataset you want to log to
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Honeycomb logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The Write Key from the Account page of your Honeycomb account
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting. Your log must produce valid JSON that Honeycomb can ingest.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class Servicev1LoggingKafka(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authMethod":
            suggest = "auth_method"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "parseLogKeyvals":
            suggest = "parse_log_keyvals"
        elif key == "requestMaxBytes":
            suggest = "request_max_bytes"
        elif key == "requiredAcks":
            suggest = "required_acks"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1LoggingKafka. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1LoggingKafka.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1LoggingKafka.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 brokers: str,
                 name: str,
                 topic: str,
                 auth_method: Optional[str] = None,
                 compression_codec: Optional[str] = None,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 parse_log_keyvals: Optional[bool] = None,
                 password: Optional[str] = None,
                 placement: Optional[str] = None,
                 request_max_bytes: Optional[int] = None,
                 required_acks: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None,
                 use_tls: Optional[bool] = None,
                 user: Optional[str] = None):
        """
        :param str brokers: A comma-separated list of IP addresses or hostnames of Kafka brokers
        :param str name: The unique name of the Kafka logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str topic: The Kafka topic to send logs to
        :param str auth_method: SASL authentication method. One of: plain, scram-sha-256, scram-sha-512
        :param str compression_codec: The codec used for compression of your logs. One of: `gzip`, `snappy`, `lz4`
        :param str format: Apache style log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param bool parse_log_keyvals: Enables parsing of key=value tuples from the beginning of a logline, turning them into record headers
        :param str password: SASL Pass
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param int request_max_bytes: Maximum size of log batch, if non-zero. Defaults to 0 for unbounded
        :param str required_acks: The Number of acknowledgements a leader must receive before a write is considered successful. One of: `1` (default) One server needs to respond. `0` No servers need to respond. `-1`	Wait for all in-sync replicas to respond
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format
        :param str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        :param bool use_tls: Whether to use TLS for secure logging. Can be either `true` or `false`
        :param str user: SASL User
        """
        pulumi.set(__self__, "brokers", brokers)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "topic", topic)
        if auth_method is not None:
            pulumi.set(__self__, "auth_method", auth_method)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if parse_log_keyvals is not None:
            pulumi.set(__self__, "parse_log_keyvals", parse_log_keyvals)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if required_acks is not None:
            pulumi.set(__self__, "required_acks", required_acks)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def brokers(self) -> str:
        """
        A comma-separated list of IP addresses or hostnames of Kafka brokers
        """
        return pulumi.get(self, "brokers")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Kafka logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The Kafka topic to send logs to
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> Optional[str]:
        """
        SASL authentication method. One of: plain, scram-sha-256, scram-sha-512
        """
        return pulumi.get(self, "auth_method")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. One of: `gzip`, `snappy`, `lz4`
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="parseLogKeyvals")
    def parse_log_keyvals(self) -> Optional[bool]:
        """
        Enables parsing of key=value tuples from the beginning of a logline, turning them into record headers
        """
        return pulumi.get(self, "parse_log_keyvals")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        SASL Pass
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[int]:
        """
        Maximum size of log batch, if non-zero. Defaults to 0 for unbounded
        """
        return pulumi.get(self, "request_max_bytes")

    @property
    @pulumi.getter(name="requiredAcks")
    def required_acks(self) -> Optional[str]:
        """
        The Number of acknowledgements a leader must receive before a write is considered successful. One of: `1` (default) One server needs to respond. `0` No servers need to respond. `-1`	Wait for all in-sync replicas to respond
        """
        return pulumi.get(self, "required_acks")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[bool]:
        """
        Whether to use TLS for secure logging. Can be either `true` or `false`
        """
        return pulumi.get(self, "use_tls")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        SASL User
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class Servicev1LoggingKinese(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "iamRole":
            suggest = "iam_role"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "secretKey":
            suggest = "secret_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1LoggingKinese. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1LoggingKinese.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1LoggingKinese.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 topic: str,
                 access_key: Optional[str] = None,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 iam_role: Optional[str] = None,
                 placement: Optional[str] = None,
                 region: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 secret_key: Optional[str] = None):
        """
        :param str name: The unique name of the Kinesis logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str topic: The Kinesis stream name
        :param str access_key: The AWS access key to be used to write to the stream
        :param str format: Apache style log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str iam_role: The Amazon Resource Name (ARN) for the IAM role granting Fastly access to Kinesis. Not required if `access_key` and `secret_key` are provided.
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str region: The AWS region the stream resides in. (Default: `us-east-1`)
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param str secret_key: The AWS secret access key to authenticate with
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "topic", topic)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if iam_role is not None:
            pulumi.set(__self__, "iam_role", iam_role)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Kinesis logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The Kinesis stream name
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[str]:
        """
        The AWS access key to be used to write to the stream
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) for the IAM role granting Fastly access to Kinesis. Not required if `access_key` and `secret_key` are provided.
        """
        return pulumi.get(self, "iam_role")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The AWS region the stream resides in. (Default: `us-east-1`)
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[str]:
        """
        The AWS secret access key to authenticate with
        """
        return pulumi.get(self, "secret_key")


@pulumi.output_type
class Servicev1LoggingLoggly(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1LoggingLoggly. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1LoggingLoggly.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1LoggingLoggly.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 token: str,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str name: The unique name of the Loggly logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The token to use for authentication (https://www.loggly.com/docs/customer-token-authentication-token/).
        :param str format: Apache-style string or VCL variables to use for log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Loggly logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The token to use for authentication (https://www.loggly.com/docs/customer-token-authentication-token/).
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class Servicev1LoggingLogshuttle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1LoggingLogshuttle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1LoggingLogshuttle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1LoggingLogshuttle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 token: str,
                 url: str,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str name: The unique name of the Log Shuttle logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The data authentication token associated with this endpoint
        :param str url: Your Log Shuttle endpoint URL
        :param str format: Apache style log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Log Shuttle logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The data authentication token associated with this endpoint
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Your Log Shuttle endpoint URL
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class Servicev1LoggingNewrelic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1LoggingNewrelic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1LoggingNewrelic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1LoggingNewrelic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 token: str,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str name: The unique name of the New Relic logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The Insert API key from the Account page of your New Relic account
        :param str format: Apache style log formatting. Your log must produce valid JSON that New Relic Logs can ingest.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param str response_condition: The name of the condition to apply.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the New Relic logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The Insert API key from the Account page of your New Relic account
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting. Your log must produce valid JSON that New Relic Logs can ingest.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of the condition to apply.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class Servicev1LoggingOpenstack(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1LoggingOpenstack. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1LoggingOpenstack.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1LoggingOpenstack.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: str,
                 bucket_name: str,
                 name: str,
                 url: str,
                 user: str,
                 compression_codec: Optional[str] = None,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[int] = None,
                 placement: Optional[str] = None,
                 public_key: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str access_key: Your OpenStack account access key
        :param str bucket_name: The name of your OpenStack container
        :param str name: The unique name of the OpenStack logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str url: Your OpenStack auth url
        :param str user: The username for your OpenStack account
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param str format: Apache style log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param int gzip_level: What level of Gzip encoding to have when dumping logs (default `0`, no compression)
        :param str message_type: How the message should be formatted; one of: `classic`, `loggly`, `logplex` or `blank`. Default `classic`. [Fastly Documentation](https://developer.fastly.com/reference/api/logging/gcs/)
        :param str path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param int period: How frequently the logs should be transferred, in seconds. Default `3600`
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param str timestamp_format: specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> str:
        """
        Your OpenStack account access key
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of your OpenStack container
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the OpenStack logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Your OpenStack auth url
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for your OpenStack account
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        What level of Gzip encoding to have when dumping logs (default `0`, no compression)
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted; one of: `classic`, `loggly`, `logplex` or `blank`. Default `classic`. [Fastly Documentation](https://developer.fastly.com/reference/api/logging/gcs/)
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently the logs should be transferred, in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class Servicev1LoggingScalyr(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1LoggingScalyr. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1LoggingScalyr.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1LoggingScalyr.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 token: str,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 placement: Optional[str] = None,
                 region: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str name: The unique name of the Scalyr logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The token to use for authentication (https://www.scalyr.com/keys)
        :param str format: Apache style log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param str region: The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Scalyr logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The token to use for authentication (https://www.scalyr.com/keys)
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region that log data will be sent to. One of `US` or `EU`. Defaults to `US` if undefined
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class Servicev1LoggingSftp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshKnownHosts":
            suggest = "ssh_known_hosts"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1LoggingSftp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1LoggingSftp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1LoggingSftp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 name: str,
                 path: str,
                 ssh_known_hosts: str,
                 user: str,
                 compression_codec: Optional[str] = None,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 password: Optional[str] = None,
                 period: Optional[int] = None,
                 placement: Optional[str] = None,
                 port: Optional[int] = None,
                 public_key: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 secret_key: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str address: The SFTP address to stream logs to
        :param str name: The unique name of the SFTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str path: The path to upload log files to. If the path ends in `/` then it is treated as a directory
        :param str ssh_known_hosts: A list of host keys for all hosts we can connect to over SFTP
        :param str user: The username for the server
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param str format: Apache-style string or VCL variables to use for log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        :param int gzip_level: What level of Gzip encoding to have when dumping logs (default `0`, no compression)
        :param str message_type: How the message should be formatted. One of: `classic` (default), `loggly`, `logplex` or `blank`
        :param str password: The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        :param int period: How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param int port: The port the SFTP service listens on. (Default: `22`)
        :param str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str response_condition: The name of the condition to apply.
        :param str secret_key: The SSH private key for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        :param str timestamp_format: The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "ssh_known_hosts", ssh_known_hosts)
        pulumi.set(__self__, "user", user)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The SFTP address to stream logs to
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the SFTP logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path to upload log files to. If the path ends in `/` then it is treated as a directory
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="sshKnownHosts")
    def ssh_known_hosts(self) -> str:
        """
        A list of host keys for all hosts we can connect to over SFTP
        """
        return pulumi.get(self, "ssh_known_hosts")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for the server
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        What level of Gzip encoding to have when dumping logs (default `0`, no compression)
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: `classic` (default), `loggly`, `logplex` or `blank`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default `3600`)
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port the SFTP service listens on. (Default: `22`)
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of the condition to apply.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[str]:
        """
        The SSH private key for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class Servicev1Papertrail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1Papertrail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1Papertrail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1Papertrail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 name: str,
                 port: int,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str address: The address of the Papertrail endpoint
        :param str name: A unique name to identify this Papertrail endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param int port: The port associated with the address where the Papertrail endpoint can be accessed
        :param str format: A Fastly [log format string](https://docs.fastly.com/en/guides/custom-log-formats)
        :param int format_version: The version of the custom logging format used for the configured endpoint. The logging call gets placed by default in `vcl_log` if `format_version` is set to `2` and in `vcl_deliver` if `format_version` is set to `1`
        :param str placement: Where in the generated VCL the logging call should be placed. If not set, endpoints with `format_version` of 2 are placed in `vcl_log` and those with `format_version` of 1 are placed in `vcl_deliver`
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The address of the Papertrail endpoint
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this Papertrail endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port associated with the address where the Papertrail endpoint can be accessed
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        A Fastly [log format string](https://docs.fastly.com/en/guides/custom-log-formats)
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. The logging call gets placed by default in `vcl_log` if `format_version` is set to `2` and in `vcl_deliver` if `format_version` is set to `1`
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. If not set, endpoints with `format_version` of 2 are placed in `vcl_log` and those with `format_version` of 1 are placed in `vcl_deliver`
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class Servicev1RequestSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bypassBusyWait":
            suggest = "bypass_busy_wait"
        elif key == "defaultHost":
            suggest = "default_host"
        elif key == "forceMiss":
            suggest = "force_miss"
        elif key == "forceSsl":
            suggest = "force_ssl"
        elif key == "geoHeaders":
            suggest = "geo_headers"
        elif key == "hashKeys":
            suggest = "hash_keys"
        elif key == "maxStaleAge":
            suggest = "max_stale_age"
        elif key == "requestCondition":
            suggest = "request_condition"
        elif key == "timerSupport":
            suggest = "timer_support"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1RequestSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1RequestSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1RequestSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 action: Optional[str] = None,
                 bypass_busy_wait: Optional[bool] = None,
                 default_host: Optional[str] = None,
                 force_miss: Optional[bool] = None,
                 force_ssl: Optional[bool] = None,
                 geo_headers: Optional[bool] = None,
                 hash_keys: Optional[str] = None,
                 max_stale_age: Optional[int] = None,
                 request_condition: Optional[str] = None,
                 timer_support: Optional[bool] = None,
                 xff: Optional[str] = None):
        """
        :param str name: Unique name to refer to this Request Setting. It is important to note that changing this attribute will delete and recreate the resource
        :param str action: Allows you to terminate request handling and immediately perform an action. When set it can be `lookup` or `pass` (Ignore the cache completely)
        :param bool bypass_busy_wait: Disable collapsed forwarding, so you don't wait for other objects to origin
        :param str default_host: Sets the host header
        :param bool force_miss: Force a cache miss for the request. If specified, can be `true` or `false`
        :param bool force_ssl: Forces the request to use SSL (Redirects a non-SSL request to SSL)
        :param bool geo_headers: Injects Fastly-Geo-Country, Fastly-Geo-City, and Fastly-Geo-Region into the request headers
        :param str hash_keys: Comma separated list of varnish request object fields that should be in the hash key
        :param int max_stale_age: How old an object is allowed to be to serve `stale-if-error` or `stale-while-revalidate`, in seconds
        :param str request_condition: Name of already defined `condition` to determine if this request setting should be applied
        :param bool timer_support: Injects the X-Timer info into the request for viewing origin fetch durations
        :param str xff: X-Forwarded-For, should be `clear`, `leave`, `append`, `append_all`, or `overwrite`. Default `append`
        """
        pulumi.set(__self__, "name", name)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if bypass_busy_wait is not None:
            pulumi.set(__self__, "bypass_busy_wait", bypass_busy_wait)
        if default_host is not None:
            pulumi.set(__self__, "default_host", default_host)
        if force_miss is not None:
            pulumi.set(__self__, "force_miss", force_miss)
        if force_ssl is not None:
            pulumi.set(__self__, "force_ssl", force_ssl)
        if geo_headers is not None:
            pulumi.set(__self__, "geo_headers", geo_headers)
        if hash_keys is not None:
            pulumi.set(__self__, "hash_keys", hash_keys)
        if max_stale_age is not None:
            pulumi.set(__self__, "max_stale_age", max_stale_age)
        if request_condition is not None:
            pulumi.set(__self__, "request_condition", request_condition)
        if timer_support is not None:
            pulumi.set(__self__, "timer_support", timer_support)
        if xff is not None:
            pulumi.set(__self__, "xff", xff)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique name to refer to this Request Setting. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        Allows you to terminate request handling and immediately perform an action. When set it can be `lookup` or `pass` (Ignore the cache completely)
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="bypassBusyWait")
    def bypass_busy_wait(self) -> Optional[bool]:
        """
        Disable collapsed forwarding, so you don't wait for other objects to origin
        """
        return pulumi.get(self, "bypass_busy_wait")

    @property
    @pulumi.getter(name="defaultHost")
    def default_host(self) -> Optional[str]:
        """
        Sets the host header
        """
        return pulumi.get(self, "default_host")

    @property
    @pulumi.getter(name="forceMiss")
    def force_miss(self) -> Optional[bool]:
        """
        Force a cache miss for the request. If specified, can be `true` or `false`
        """
        return pulumi.get(self, "force_miss")

    @property
    @pulumi.getter(name="forceSsl")
    def force_ssl(self) -> Optional[bool]:
        """
        Forces the request to use SSL (Redirects a non-SSL request to SSL)
        """
        return pulumi.get(self, "force_ssl")

    @property
    @pulumi.getter(name="geoHeaders")
    def geo_headers(self) -> Optional[bool]:
        """
        Injects Fastly-Geo-Country, Fastly-Geo-City, and Fastly-Geo-Region into the request headers
        """
        return pulumi.get(self, "geo_headers")

    @property
    @pulumi.getter(name="hashKeys")
    def hash_keys(self) -> Optional[str]:
        """
        Comma separated list of varnish request object fields that should be in the hash key
        """
        return pulumi.get(self, "hash_keys")

    @property
    @pulumi.getter(name="maxStaleAge")
    def max_stale_age(self) -> Optional[int]:
        """
        How old an object is allowed to be to serve `stale-if-error` or `stale-while-revalidate`, in seconds
        """
        return pulumi.get(self, "max_stale_age")

    @property
    @pulumi.getter(name="requestCondition")
    def request_condition(self) -> Optional[str]:
        """
        Name of already defined `condition` to determine if this request setting should be applied
        """
        return pulumi.get(self, "request_condition")

    @property
    @pulumi.getter(name="timerSupport")
    def timer_support(self) -> Optional[bool]:
        """
        Injects the X-Timer info into the request for viewing origin fetch durations
        """
        return pulumi.get(self, "timer_support")

    @property
    @pulumi.getter
    def xff(self) -> Optional[str]:
        """
        X-Forwarded-For, should be `clear`, `leave`, `append`, `append_all`, or `overwrite`. Default `append`
        """
        return pulumi.get(self, "xff")


@pulumi.output_type
class Servicev1ResponseObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheCondition":
            suggest = "cache_condition"
        elif key == "contentType":
            suggest = "content_type"
        elif key == "requestCondition":
            suggest = "request_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1ResponseObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1ResponseObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1ResponseObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 cache_condition: Optional[str] = None,
                 content: Optional[str] = None,
                 content_type: Optional[str] = None,
                 request_condition: Optional[str] = None,
                 response: Optional[str] = None,
                 status: Optional[int] = None):
        """
        :param str name: A unique name to identify this Response Object. It is important to note that changing this attribute will delete and recreate the resource
        :param str cache_condition: Name of already defined `condition` to check after we have retrieved an object. If the condition passes then deliver this Request Object instead. This `condition` must be of type `CACHE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        :param str content: The content to deliver for the response object
        :param str content_type: The MIME type of the content
        :param str request_condition: Name of already defined `condition` to be checked during the request phase. If the condition passes then this object will be delivered. This `condition` must be of type `REQUEST`
        :param str response: The HTTP Response. Default `OK`
        :param int status: The HTTP Status Code. Default `200`
        """
        pulumi.set(__self__, "name", name)
        if cache_condition is not None:
            pulumi.set(__self__, "cache_condition", cache_condition)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if request_condition is not None:
            pulumi.set(__self__, "request_condition", request_condition)
        if response is not None:
            pulumi.set(__self__, "response", response)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this Response Object. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="cacheCondition")
    def cache_condition(self) -> Optional[str]:
        """
        Name of already defined `condition` to check after we have retrieved an object. If the condition passes then deliver this Request Object instead. This `condition` must be of type `CACHE`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        """
        return pulumi.get(self, "cache_condition")

    @property
    @pulumi.getter
    def content(self) -> Optional[str]:
        """
        The content to deliver for the response object
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[str]:
        """
        The MIME type of the content
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="requestCondition")
    def request_condition(self) -> Optional[str]:
        """
        Name of already defined `condition` to be checked during the request phase. If the condition passes then this object will be delivered. This `condition` must be of type `REQUEST`
        """
        return pulumi.get(self, "request_condition")

    @property
    @pulumi.getter
    def response(self) -> Optional[str]:
        """
        The HTTP Response. Default `OK`
        """
        return pulumi.get(self, "response")

    @property
    @pulumi.getter
    def status(self) -> Optional[int]:
        """
        The HTTP Status Code. Default `200`
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class Servicev1S3logging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "compressionCodec":
            suggest = "compression_codec"
        elif key == "formatVersion":
            suggest = "format_version"
        elif key == "gzipLevel":
            suggest = "gzip_level"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "s3AccessKey":
            suggest = "s3_access_key"
        elif key == "s3IamRole":
            suggest = "s3_iam_role"
        elif key == "s3SecretKey":
            suggest = "s3_secret_key"
        elif key == "serverSideEncryption":
            suggest = "server_side_encryption"
        elif key == "serverSideEncryptionKmsKeyId":
            suggest = "server_side_encryption_kms_key_id"
        elif key == "timestampFormat":
            suggest = "timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1S3logging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1S3logging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1S3logging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 name: str,
                 acl: Optional[str] = None,
                 compression_codec: Optional[str] = None,
                 domain: Optional[str] = None,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 gzip_level: Optional[int] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[int] = None,
                 placement: Optional[str] = None,
                 public_key: Optional[str] = None,
                 redundancy: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 s3_access_key: Optional[str] = None,
                 s3_iam_role: Optional[str] = None,
                 s3_secret_key: Optional[str] = None,
                 server_side_encryption: Optional[str] = None,
                 server_side_encryption_kms_key_id: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str bucket_name: The name of the bucket in which to store the logs
        :param str name: The unique name of the S3 logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str acl: The AWS [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) to use for objects uploaded to the S3 bucket. Options are: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`
        :param str compression_codec: The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        :param str domain: If you created the S3 bucket outside of `us-east-1`, then specify the corresponding bucket endpoint. Example: `s3-us-west-2.amazonaws.com`
        :param str format: Apache-style string or VCL variables to use for log formatting.
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 1).
        :param int gzip_level: Level of Gzip compression, from `0-9`. `0` is no compression. `1` is fastest and least compressed, `9` is slowest and most compressed. Default `0`
        :param str message_type: How the message should be formatted; one of: `classic`, `loggly`, `logplex` or `blank`. Default `classic`
        :param str path: Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        :param int period: How frequently the logs should be transferred, in seconds. Default `3600`
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param str public_key: A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        :param str redundancy: The S3 storage class (redundancy level). Should be one of: `standard`, `reduced_redundancy`, `standard_ia`, or `onezone_ia`
        :param str response_condition: Name of blockAttributes condition to apply this logging.
        :param str s3_access_key: AWS Access Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This key will be not be encrypted. Not required if `iam_role` is provided. You can provide this key via an environment variable, `FASTLY_S3_ACCESS_KEY`
        :param str s3_iam_role: The Amazon Resource Name (ARN) for the IAM role granting Fastly access to S3. Not required if `access_key` and `secret_key` are provided. You can provide this value via an environment variable, `FASTLY_S3_IAM_ROLE`
        :param str s3_secret_key: AWS Secret Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This secret will be not be encrypted. Not required if `iam_role` is provided. You can provide this secret via an environment variable, `FASTLY_S3_SECRET_KEY`
        :param str server_side_encryption: Specify what type of server side encryption should be used. Can be either `AES256` or `aws:kms`
        :param str server_side_encryption_kms_key_id: Optional server-side KMS Key Id. Must be set if server*side*encryption is set to `aws:kms`
        :param str timestamp_format: `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if redundancy is not None:
            pulumi.set(__self__, "redundancy", redundancy)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if s3_access_key is not None:
            pulumi.set(__self__, "s3_access_key", s3_access_key)
        if s3_iam_role is not None:
            pulumi.set(__self__, "s3_iam_role", s3_iam_role)
        if s3_secret_key is not None:
            pulumi.set(__self__, "s3_secret_key", s3_secret_key)
        if server_side_encryption is not None:
            pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        if server_side_encryption_kms_key_id is not None:
            pulumi.set(__self__, "server_side_encryption_kms_key_id", server_side_encryption_kms_key_id)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of the bucket in which to store the logs
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the S3 logging endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def acl(self) -> Optional[str]:
        """
        The AWS [Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl) to use for objects uploaded to the S3 bucket. Options are: `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, `bucket-owner-read`, `bucket-owner-full-control`
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. Valid values are zstd, snappy, and gzip. If the specified codec is "gzip", gzip*level will default to 3. To specify a different level, leave compression*codec blank and explicitly set the level using gzip*level. Specifying both compression*codec and gzip_level in the same API request will result in an error.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        If you created the S3 bucket outside of `us-east-1`, then specify the corresponding bucket endpoint. Example: `s3-us-west-2.amazonaws.com`
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 1).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[int]:
        """
        Level of Gzip compression, from `0-9`. `0` is no compression. `1` is fastest and least compressed, `9` is slowest and most compressed. Default `0`
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted; one of: `classic`, `loggly`, `logplex` or `blank`. Default `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path to store the files. Must end with a trailing slash. If this field is left empty, the files will be saved in the bucket's root path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        How frequently the logs should be transferred, in seconds. Default `3600`
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        A PGP public key that Fastly will use to encrypt your log files before writing them to disk
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def redundancy(self) -> Optional[str]:
        """
        The S3 storage class (redundancy level). Should be one of: `standard`, `reduced_redundancy`, `standard_ia`, or `onezone_ia`
        """
        return pulumi.get(self, "redundancy")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        Name of blockAttributes condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="s3AccessKey")
    def s3_access_key(self) -> Optional[str]:
        """
        AWS Access Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This key will be not be encrypted. Not required if `iam_role` is provided. You can provide this key via an environment variable, `FASTLY_S3_ACCESS_KEY`
        """
        return pulumi.get(self, "s3_access_key")

    @property
    @pulumi.getter(name="s3IamRole")
    def s3_iam_role(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) for the IAM role granting Fastly access to S3. Not required if `access_key` and `secret_key` are provided. You can provide this value via an environment variable, `FASTLY_S3_IAM_ROLE`
        """
        return pulumi.get(self, "s3_iam_role")

    @property
    @pulumi.getter(name="s3SecretKey")
    def s3_secret_key(self) -> Optional[str]:
        """
        AWS Secret Key of an account with the required permissions to post logs. It is **strongly** recommended you create a separate IAM user with permissions to only operate on this Bucket. This secret will be not be encrypted. Not required if `iam_role` is provided. You can provide this secret via an environment variable, `FASTLY_S3_SECRET_KEY`
        """
        return pulumi.get(self, "s3_secret_key")

    @property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[str]:
        """
        Specify what type of server side encryption should be used. Can be either `AES256` or `aws:kms`
        """
        return pulumi.get(self, "server_side_encryption")

    @property
    @pulumi.getter(name="serverSideEncryptionKmsKeyId")
    def server_side_encryption_kms_key_id(self) -> Optional[str]:
        """
        Optional server-side KMS Key Id. Must be set if server*side*encryption is set to `aws:kms`
        """
        return pulumi.get(self, "server_side_encryption_kms_key_id")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        `strftime` specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`)
        """
        return pulumi.get(self, "timestamp_format")


@pulumi.output_type
class Servicev1Snippet(dict):
    def __init__(__self__, *,
                 content: str,
                 name: str,
                 type: str,
                 priority: Optional[int] = None):
        """
        :param str content: The VCL code that specifies exactly what the snippet does
        :param str name: A name that is unique across "regular" and "dynamic" VCL Snippet configuration blocks. It is important to note that changing this attribute will delete and recreate the resource
        :param str type: The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`)
        :param int priority: Priority determines the ordering for multiple snippets. Lower numbers execute first. Defaults to `100`
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The VCL code that specifies exactly what the snippet does
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A name that is unique across "regular" and "dynamic" VCL Snippet configuration blocks. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`)
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Priority determines the ordering for multiple snippets. Lower numbers execute first. Defaults to `100`
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class Servicev1Splunk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1Splunk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1Splunk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1Splunk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 token: str,
                 url: str,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None):
        """
        :param str name: A unique name to identify the Splunk endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str token: The Splunk token to be used for authentication
        :param str url: The Splunk URL to stream logs to
        :param str format: Apache-style string or VCL variables to use for log formatting (default: `%h %l %u %t "%r" %>s %b`)
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        :param str placement: Where in the generated VCL the logging call should be placed
        :param str response_condition: The name of the condition to apply
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SPLUNK_CA_CERT`
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format.
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format.
        :param str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify the Splunk endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The Splunk token to be used for authentication
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The Splunk URL to stream logs to
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting (default: `%h %l %u %t "%r" %>s %b`)
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (default: 2)
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of the condition to apply
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SPLUNK_CA_CERT`
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN)
        """
        return pulumi.get(self, "tls_hostname")


@pulumi.output_type
class Servicev1Sumologic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "responseCondition":
            suggest = "response_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1Sumologic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1Sumologic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1Sumologic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 url: str,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 message_type: Optional[str] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str name: A unique name to identify this Sumologic endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str url: The URL to Sumologic collector endpoint
        :param str format: Apache-style string or VCL variables to use for log formatting
        :param int format_version: The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 1)
        :param str message_type: How the message should be formatted; one of: `classic`, `loggly`, `logplex` or `blank`. Default `classic`. See [Fastly's Documentation on Sumologic](https://developer.fastly.com/reference/api/logging/sumologic/)
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param str response_condition: Name of blockAttributes condition to apply this logging.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this Sumologic endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL to Sumologic collector endpoint
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either 1 or 2. (Default: 1)
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted; one of: `classic`, `loggly`, `logplex` or `blank`. Default `classic`. See [Fastly's Documentation on Sumologic](https://developer.fastly.com/reference/api/logging/sumologic/)
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        Name of blockAttributes condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")


@pulumi.output_type
class Servicev1Syslog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatVersion":
            suggest = "format_version"
        elif key == "messageType":
            suggest = "message_type"
        elif key == "responseCondition":
            suggest = "response_condition"
        elif key == "tlsCaCert":
            suggest = "tls_ca_cert"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsHostname":
            suggest = "tls_hostname"
        elif key == "useTls":
            suggest = "use_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1Syslog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1Syslog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1Syslog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 name: str,
                 format: Optional[str] = None,
                 format_version: Optional[int] = None,
                 message_type: Optional[str] = None,
                 placement: Optional[str] = None,
                 port: Optional[int] = None,
                 response_condition: Optional[str] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None,
                 token: Optional[str] = None,
                 use_tls: Optional[bool] = None):
        """
        :param str address: A hostname or IPv4 address of the Syslog endpoint
        :param str name: A unique name to identify this Syslog endpoint. It is important to note that changing this attribute will delete and recreate the resource
        :param str format: Apache-style string or VCL variables to use for log formatting
        :param int format_version: The version of the custom logging format. Can be either 1 or 2. (Default: 1)
        :param str message_type: How the message should be formatted; one of: `classic`, `loggly`, `logplex` or `blank`. Default `classic`
        :param str placement: Where in the generated VCL the logging call should be placed.
        :param int port: The port associated with the address where the Syslog endpoint can be accessed. Default `514`
        :param str response_condition: Name of blockAttributes condition to apply this logging.
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CA_CERT`
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CLIENT_CERT`
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format. You can provide this key via an environment variable, `FASTLY_SYSLOG_CLIENT_KEY`
        :param str tls_hostname: Used during the TLS handshake to validate the certificate
        :param str token: Whether to prepend each message with a specific token
        :param bool use_tls: Whether to use TLS for secure logging. Default `false`
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        A hostname or IPv4 address of the Syslog endpoint
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this Syslog endpoint. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache-style string or VCL variables to use for log formatting
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[int]:
        """
        The version of the custom logging format. Can be either 1 or 2. (Default: 1)
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted; one of: `classic`, `loggly`, `logplex` or `blank`. Default `classic`
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port associated with the address where the Syslog endpoint can be accessed. Default `514`
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        Name of blockAttributes condition to apply this logging.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CA_CERT`
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format. You can provide this certificate via an environment variable, `FASTLY_SYSLOG_CLIENT_CERT`
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format. You can provide this key via an environment variable, `FASTLY_SYSLOG_CLIENT_KEY`
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        Used during the TLS handshake to validate the certificate
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter
    def token(self) -> Optional[str]:
        """
        Whether to prepend each message with a specific token
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[bool]:
        """
        Whether to use TLS for secure logging. Default `false`
        """
        return pulumi.get(self, "use_tls")


@pulumi.output_type
class Servicev1Vcl(dict):
    def __init__(__self__, *,
                 content: str,
                 name: str,
                 main: Optional[bool] = None):
        """
        :param str content: The custom VCL code to upload
        :param str name: A unique name for this configuration block. It is important to note that changing this attribute will delete and recreate the resource
        :param bool main: If `true`, use this block as the main configuration. If `false`, use this block as an includable library. Only a single VCL block can be marked as the main block. Default is `false`
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "name", name)
        if main is not None:
            pulumi.set(__self__, "main", main)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The custom VCL code to upload
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name for this configuration block. It is important to note that changing this attribute will delete and recreate the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def main(self) -> Optional[bool]:
        """
        If `true`, use this block as the main configuration. If `false`, use this block as an includable library. Only a single VCL block can be marked as the main block. Default is `false`
        """
        return pulumi.get(self, "main")


@pulumi.output_type
class Servicev1Waf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "responseObject":
            suggest = "response_object"
        elif key == "prefetchCondition":
            suggest = "prefetch_condition"
        elif key == "wafId":
            suggest = "waf_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Servicev1Waf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Servicev1Waf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Servicev1Waf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 response_object: str,
                 disabled: Optional[bool] = None,
                 prefetch_condition: Optional[str] = None,
                 waf_id: Optional[str] = None):
        """
        :param str response_object: The name of the response object used by the Web Application Firewall
        :param bool disabled: A flag used to completely disable a Web Application Firewall. This is intended to only be used in an emergency
        :param str prefetch_condition: The `condition` to determine which requests will be run past your Fastly WAF. This `condition` must be of type `PREFETCH`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        :param str waf_id: The ID of the WAF
        """
        pulumi.set(__self__, "response_object", response_object)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if prefetch_condition is not None:
            pulumi.set(__self__, "prefetch_condition", prefetch_condition)
        if waf_id is not None:
            pulumi.set(__self__, "waf_id", waf_id)

    @property
    @pulumi.getter(name="responseObject")
    def response_object(self) -> str:
        """
        The name of the response object used by the Web Application Firewall
        """
        return pulumi.get(self, "response_object")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        A flag used to completely disable a Web Application Firewall. This is intended to only be used in an emergency
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="prefetchCondition")
    def prefetch_condition(self) -> Optional[str]:
        """
        The `condition` to determine which requests will be run past your Fastly WAF. This `condition` must be of type `PREFETCH`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals](https://docs.fastly.com/en/guides/using-conditions)
        """
        return pulumi.get(self, "prefetch_condition")

    @property
    @pulumi.getter(name="wafId")
    def waf_id(self) -> Optional[str]:
        """
        The ID of the WAF
        """
        return pulumi.get(self, "waf_id")


@pulumi.output_type
class TlsSubscriptionManagedDnsChallenge(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordName":
            suggest = "record_name"
        elif key == "recordType":
            suggest = "record_type"
        elif key == "recordValue":
            suggest = "record_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TlsSubscriptionManagedDnsChallenge. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TlsSubscriptionManagedDnsChallenge.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TlsSubscriptionManagedDnsChallenge.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 record_name: Optional[str] = None,
                 record_type: Optional[str] = None,
                 record_value: Optional[str] = None):
        """
        :param str record_name: The name of the DNS record to add. For example `example.com`. Best accessed through a `for` expression to filter the relevant record.
        :param str record_type: The type of DNS record to add, e.g. `A`, or `CNAME`.
        :param str record_value: The value to which the DNS record should point, e.g. `xxxxx.fastly-validations.com`.
        """
        if record_name is not None:
            pulumi.set(__self__, "record_name", record_name)
        if record_type is not None:
            pulumi.set(__self__, "record_type", record_type)
        if record_value is not None:
            pulumi.set(__self__, "record_value", record_value)

    @property
    @pulumi.getter(name="recordName")
    def record_name(self) -> Optional[str]:
        """
        The name of the DNS record to add. For example `example.com`. Best accessed through a `for` expression to filter the relevant record.
        """
        return pulumi.get(self, "record_name")

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[str]:
        """
        The type of DNS record to add, e.g. `A`, or `CNAME`.
        """
        return pulumi.get(self, "record_type")

    @property
    @pulumi.getter(name="recordValue")
    def record_value(self) -> Optional[str]:
        """
        The value to which the DNS record should point, e.g. `xxxxx.fastly-validations.com`.
        """
        return pulumi.get(self, "record_value")


@pulumi.output_type
class TlsSubscriptionManagedHttpChallenge(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordName":
            suggest = "record_name"
        elif key == "recordType":
            suggest = "record_type"
        elif key == "recordValues":
            suggest = "record_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TlsSubscriptionManagedHttpChallenge. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TlsSubscriptionManagedHttpChallenge.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TlsSubscriptionManagedHttpChallenge.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 record_name: Optional[str] = None,
                 record_type: Optional[str] = None,
                 record_values: Optional[Sequence[str]] = None):
        """
        :param str record_name: The name of the DNS record to add. For example `example.com`. Best accessed through a `for` expression to filter the relevant record.
        :param str record_type: The type of DNS record to add, e.g. `A`, or `CNAME`.
        :param Sequence[str] record_values: A list with the value(s) to which the DNS record should point.
        """
        if record_name is not None:
            pulumi.set(__self__, "record_name", record_name)
        if record_type is not None:
            pulumi.set(__self__, "record_type", record_type)
        if record_values is not None:
            pulumi.set(__self__, "record_values", record_values)

    @property
    @pulumi.getter(name="recordName")
    def record_name(self) -> Optional[str]:
        """
        The name of the DNS record to add. For example `example.com`. Best accessed through a `for` expression to filter the relevant record.
        """
        return pulumi.get(self, "record_name")

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[str]:
        """
        The type of DNS record to add, e.g. `A`, or `CNAME`.
        """
        return pulumi.get(self, "record_type")

    @property
    @pulumi.getter(name="recordValues")
    def record_values(self) -> Optional[Sequence[str]]:
        """
        A list with the value(s) to which the DNS record should point.
        """
        return pulumi.get(self, "record_values")


@pulumi.output_type
class GetTlsConfigurationDnsRecordResult(dict):
    def __init__(__self__, *,
                 record_type: str,
                 record_value: str,
                 region: str):
        pulumi.set(__self__, "record_type", record_type)
        pulumi.set(__self__, "record_value", record_value)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> str:
        return pulumi.get(self, "record_type")

    @property
    @pulumi.getter(name="recordValue")
    def record_value(self) -> str:
        return pulumi.get(self, "record_value")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")


@pulumi.output_type
class GetWafRulesRuleResult(dict):
    def __init__(__self__, *,
                 latest_revision_number: int,
                 modsec_rule_id: int,
                 type: str):
        """
        :param int latest_revision_number: The rule's latest revision.
        :param int modsec_rule_id: The rule's modsecurity ID.
        :param str type: The rule's type.
        """
        pulumi.set(__self__, "latest_revision_number", latest_revision_number)
        pulumi.set(__self__, "modsec_rule_id", modsec_rule_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="latestRevisionNumber")
    def latest_revision_number(self) -> int:
        """
        The rule's latest revision.
        """
        return pulumi.get(self, "latest_revision_number")

    @property
    @pulumi.getter(name="modsecRuleId")
    def modsec_rule_id(self) -> int:
        """
        The rule's modsecurity ID.
        """
        return pulumi.get(self, "modsec_rule_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The rule's type.
        """
        return pulumi.get(self, "type")


