# ConverterPro
A python library to convert units and currencies

![Hex.pm](https://img.shields.io/hexpm/l/apa?style=flat&color=brightgreen)
![GitHub issues](https://img.shields.io/github/issues/oforiwaasam/converterpro)
[![Build Status](https://img.shields.io/github/actions/workflow/status/oforiwaasam/converterpro/build.yml)](https://github.com/oforiwaasam/converterpro/actions/workflows/build.yml)
[![Coverage Status](https://coveralls.io/repos/github/oforiwaasam/converterpro/badge.svg?branch=main&kill_cache=1)](https://coveralls.io/github/oforiwaasam/converterpro?branch=main)
[![black](https://img.shields.io/badge/code%20style-black-000000)](https://github.com/psf/black)
[![poetry](https://img.shields.io/badge/packaging-poetry-008adf)](https://python-poetry.org/)

## 🔭 Overview
This python library will allow developers to easily incorporate conversions into their programs without having to write all the logic for it. The library currently has the following functionalities:
- Converting Metric System, Imperial System and US System Measurements

## Installation

Install **converterpro** with `pip`:

```bash
pip install converterpro
```

## 📝 Details
This library project is a pure python project using modern tooling. It uses a `Makefile` as a command registry, with the following commands:
- `make`: list available commands
- `make install`: install and build this library and its dependencies using `poetry`
- `make lint`: perform static analysis of this library with `ruff` and `black`
- `make format`: autoformat this library using `black` and `ruff`
- `make test`: run automated tests with `pytest`
- `make coverage`: run automated tests with `pytest` and collect coverage information

## 👩🏾‍💻👨🏾‍ Contributing

Please see [CONTRIBUTING](CONTRIBUTING.md) for more information.

## License

This software is licensed under the Apache 2.0 license. Please see [LICENSE](LICENSE) for more information.

## 🙎🏾‍ Author
Main Maintainer: Lily Sam

