# This file is automatically generated by generate.py using api.json

class _Tags:
    def __init__(self, client=None):
        self.client = client

    def create(self, params={}, **options):
        """Creates a new tag."""
        return self.client.post('/tags', params, **options)

    def update(self, tag_id, params={}, **options):
        """Update a tag."""
        path = '/tags/%s' % (tag_id)
        return self.client.put(path, params, **options)

    def find_by_id(self, tag_id, params={}, **options):
        """Returns the tag."""
        path = '/tags/%s' % (tag_id)
        return self.client.get(path, params, **options)

    def find_by_workspace(self, workspace_id, params={}, **options):
        """Finds a tag by workspace."""
        path = '/workspaces/%s/tags' % (workspace_id)
        return self.client.get_collection(path, params, **options)

    def find_all(self, params={}, **options):
        """Returns all tags that the dispatcher has access to."""
        return self.client.get_collection('/tags', params, **options)

    def create_in_workspace(self, workspace_id, params={}, **options):
        """Creates a new tag in the workspace."""
        path = '/workspaces/%s/tags' % (workspace_id)
        return self.client.post(path, params, **options)
