/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.BooleanArrayList;
import ai.h2o.com.google.protobuf.ByteString;
import ai.h2o.com.google.protobuf.CheckReturnValue;
import ai.h2o.com.google.protobuf.CodedInputStream;
import ai.h2o.com.google.protobuf.DoubleArrayList;
import ai.h2o.com.google.protobuf.ExtensionRegistryLite;
import ai.h2o.com.google.protobuf.FieldSet;
import ai.h2o.com.google.protobuf.FloatArrayList;
import ai.h2o.com.google.protobuf.GeneratedMessageLite;
import ai.h2o.com.google.protobuf.IntArrayList;
import ai.h2o.com.google.protobuf.Internal;
import ai.h2o.com.google.protobuf.InvalidProtocolBufferException;
import ai.h2o.com.google.protobuf.LongArrayList;
import ai.h2o.com.google.protobuf.MessageLite;
import ai.h2o.com.google.protobuf.MessageSchema;
import ai.h2o.com.google.protobuf.Protobuf;
import ai.h2o.com.google.protobuf.Schema;
import ai.h2o.com.google.protobuf.SchemaUtil;
import ai.h2o.com.google.protobuf.UnknownFieldSchema;
import ai.h2o.com.google.protobuf.UnknownFieldSetLite;
import ai.h2o.com.google.protobuf.Utf8;
import ai.h2o.com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.List;

@CheckReturnValue
final class ArrayDecoders {
    private ArrayDecoders() {
    }

    static int decodeVarint32(byte[] data, int position, Registers registers) {
        int n2;
        if ((n2 = data[position++]) >= 0) {
            registers.int1 = n2;
            return position;
        }
        return ArrayDecoders.decodeVarint32(n2, data, position, registers);
    }

    static int decodeVarint32(int firstByte, byte[] data, int position, Registers registers) {
        byte by;
        byte by2;
        byte by3;
        byte by4;
        int n2 = firstByte & 0x7F;
        if ((by4 = data[position++]) >= 0) {
            registers.int1 = n2 | by4 << 7;
            return position;
        }
        n2 |= (by4 & 0x7F) << 7;
        if ((by3 = data[position++]) >= 0) {
            registers.int1 = n2 | by3 << 14;
            return position;
        }
        n2 |= (by3 & 0x7F) << 14;
        if ((by2 = data[position++]) >= 0) {
            registers.int1 = n2 | by2 << 21;
            return position;
        }
        n2 |= (by2 & 0x7F) << 21;
        if ((by = data[position++]) >= 0) {
            registers.int1 = n2 | by << 28;
            return position;
        }
        n2 |= (by & 0x7F) << 28;
        while (data[position++] < 0) {
        }
        registers.int1 = n2;
        return position;
    }

    static int decodeVarint64(byte[] data, int position, Registers registers) {
        long l2;
        if ((l2 = (long)data[position++]) >= 0L) {
            registers.long1 = l2;
            return position;
        }
        return ArrayDecoders.decodeVarint64(l2, data, position, registers);
    }

    static int decodeVarint64(long firstByte, byte[] data, int position, Registers registers) {
        long l2 = firstByte & 0x7FL;
        byte by = data[position++];
        int n2 = 7;
        l2 |= (long)(by & 0x7F) << 7;
        while (by < 0) {
            by = data[position++];
            l2 |= (long)(by & 0x7F) << (n2 += 7);
        }
        registers.long1 = l2;
        return position;
    }

    static int decodeFixed32(byte[] data, int position) {
        return data[position] & 0xFF | (data[position + 1] & 0xFF) << 8 | (data[position + 2] & 0xFF) << 16 | (data[position + 3] & 0xFF) << 24;
    }

    static long decodeFixed64(byte[] data, int position) {
        return (long)data[position] & 0xFFL | ((long)data[position + 1] & 0xFFL) << 8 | ((long)data[position + 2] & 0xFFL) << 16 | ((long)data[position + 3] & 0xFFL) << 24 | ((long)data[position + 4] & 0xFFL) << 32 | ((long)data[position + 5] & 0xFFL) << 40 | ((long)data[position + 6] & 0xFFL) << 48 | ((long)data[position + 7] & 0xFFL) << 56;
    }

    static double decodeDouble(byte[] data, int position) {
        return Double.longBitsToDouble(ArrayDecoders.decodeFixed64(data, position));
    }

    static float decodeFloat(byte[] data, int position) {
        return Float.intBitsToFloat(ArrayDecoders.decodeFixed32(data, position));
    }

    static int decodeString(byte[] data, int position, Registers registers) throws InvalidProtocolBufferException {
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int n2 = registers.int1;
        if (n2 < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (n2 == 0) {
            registers.object1 = "";
            return position;
        }
        registers.object1 = new String(data, position, n2, Internal.UTF_8);
        return position + n2;
    }

    static int decodeStringRequireUtf8(byte[] data, int position, Registers registers) throws InvalidProtocolBufferException {
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int n2 = registers.int1;
        if (n2 < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (n2 == 0) {
            registers.object1 = "";
            return position;
        }
        registers.object1 = Utf8.decodeUtf8(data, position, n2);
        return position + n2;
    }

    static int decodeBytes(byte[] data, int position, Registers registers) throws InvalidProtocolBufferException {
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int n2 = registers.int1;
        if (n2 < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (n2 > data.length - position) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        if (n2 == 0) {
            registers.object1 = ByteString.EMPTY;
            return position;
        }
        registers.object1 = ByteString.copyFrom(data, position, n2);
        return position + n2;
    }

    static int decodeMessageField(Schema schema, byte[] data, int position, int limit, Registers registers) throws IOException {
        Object t2 = schema.newInstance();
        int n2 = ArrayDecoders.mergeMessageField(t2, schema, data, position, limit, registers);
        schema.makeImmutable(t2);
        registers.object1 = t2;
        return n2;
    }

    static int decodeGroupField(Schema schema, byte[] data, int position, int limit, int endGroup, Registers registers) throws IOException {
        Object t2 = schema.newInstance();
        int n2 = ArrayDecoders.mergeGroupField(t2, schema, data, position, limit, endGroup, registers);
        schema.makeImmutable(t2);
        registers.object1 = t2;
        return n2;
    }

    static int mergeMessageField(Object msg, Schema schema, byte[] data, int position, int limit, Registers registers) throws IOException {
        int n2;
        if ((n2 = data[position++]) < 0) {
            position = ArrayDecoders.decodeVarint32(n2, data, position, registers);
            n2 = registers.int1;
        }
        if (n2 < 0 || n2 > limit - position) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        int n3 = position;
        schema.mergeFrom(msg, data, n3, n3 + n2, registers);
        registers.object1 = msg;
        return position + n2;
    }

    static int mergeGroupField(Object msg, Schema schema, byte[] data, int position, int limit, int endGroup, Registers registers) throws IOException {
        MessageSchema messageSchema = (MessageSchema)schema;
        int n2 = messageSchema.parseProto2Message(msg, data, position, limit, endGroup, registers);
        registers.object1 = msg;
        return n2;
    }

    static int decodeVarint32List(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        IntArrayList intArrayList = (IntArrayList)list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        intArrayList.addInt(registers.int1);
        while (position < limit) {
            int n2 = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint32(data, n2, registers);
            intArrayList.addInt(registers.int1);
        }
        return position;
    }

    static int decodeVarint64List(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        LongArrayList longArrayList = (LongArrayList)list;
        position = ArrayDecoders.decodeVarint64(data, position, registers);
        longArrayList.addLong(registers.long1);
        while (position < limit) {
            int n2 = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint64(data, n2, registers);
            longArrayList.addLong(registers.long1);
        }
        return position;
    }

    static int decodeFixed32List(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        IntArrayList intArrayList = (IntArrayList)list;
        intArrayList.addInt(ArrayDecoders.decodeFixed32(data, position));
        position += 4;
        while (position < limit) {
            int n2 = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            intArrayList.addInt(ArrayDecoders.decodeFixed32(data, n2));
            position = n2 + 4;
        }
        return position;
    }

    static int decodeFixed64List(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        LongArrayList longArrayList = (LongArrayList)list;
        longArrayList.addLong(ArrayDecoders.decodeFixed64(data, position));
        position += 8;
        while (position < limit) {
            int n2 = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            longArrayList.addLong(ArrayDecoders.decodeFixed64(data, n2));
            position = n2 + 8;
        }
        return position;
    }

    static int decodeFloatList(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        FloatArrayList floatArrayList = (FloatArrayList)list;
        floatArrayList.addFloat(ArrayDecoders.decodeFloat(data, position));
        position += 4;
        while (position < limit) {
            int n2 = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            floatArrayList.addFloat(ArrayDecoders.decodeFloat(data, n2));
            position = n2 + 4;
        }
        return position;
    }

    static int decodeDoubleList(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        DoubleArrayList doubleArrayList = (DoubleArrayList)list;
        doubleArrayList.addDouble(ArrayDecoders.decodeDouble(data, position));
        position += 8;
        while (position < limit) {
            int n2 = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            doubleArrayList.addDouble(ArrayDecoders.decodeDouble(data, n2));
            position = n2 + 8;
        }
        return position;
    }

    static int decodeBoolList(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        BooleanArrayList booleanArrayList = (BooleanArrayList)list;
        position = ArrayDecoders.decodeVarint64(data, position, registers);
        booleanArrayList.addBoolean(registers.long1 != 0L);
        while (position < limit) {
            int n2 = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint64(data, n2, registers);
            booleanArrayList.addBoolean(registers.long1 != 0L);
        }
        return position;
    }

    static int decodeSInt32List(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        IntArrayList intArrayList = (IntArrayList)list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        intArrayList.addInt(CodedInputStream.decodeZigZag32(registers.int1));
        while (position < limit) {
            int n2 = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint32(data, n2, registers);
            intArrayList.addInt(CodedInputStream.decodeZigZag32(registers.int1));
        }
        return position;
    }

    static int decodeSInt64List(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) {
        LongArrayList longArrayList = (LongArrayList)list;
        position = ArrayDecoders.decodeVarint64(data, position, registers);
        longArrayList.addLong(CodedInputStream.decodeZigZag64(registers.long1));
        while (position < limit) {
            int n2 = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint64(data, n2, registers);
            longArrayList.addLong(CodedInputStream.decodeZigZag64(registers.long1));
        }
        return position;
    }

    static int decodePackedVarint32List(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        IntArrayList intArrayList = (IntArrayList)list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int n2 = position + registers.int1;
        while (position < n2) {
            position = ArrayDecoders.decodeVarint32(data, position, registers);
            intArrayList.addInt(registers.int1);
        }
        if (position != n2) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodePackedVarint64List(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        LongArrayList longArrayList = (LongArrayList)list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int n2 = position + registers.int1;
        while (position < n2) {
            position = ArrayDecoders.decodeVarint64(data, position, registers);
            longArrayList.addLong(registers.long1);
        }
        if (position != n2) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodePackedFixed32List(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        IntArrayList intArrayList = (IntArrayList)list;
        int n2 = position + registers.int1;
        for (position = ArrayDecoders.decodeVarint32(data, position, registers); position < n2; position += 4) {
            intArrayList.addInt(ArrayDecoders.decodeFixed32(data, position));
        }
        if (position != n2) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodePackedFixed64List(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        LongArrayList longArrayList = (LongArrayList)list;
        int n2 = position + registers.int1;
        for (position = ArrayDecoders.decodeVarint32(data, position, registers); position < n2; position += 8) {
            longArrayList.addLong(ArrayDecoders.decodeFixed64(data, position));
        }
        if (position != n2) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodePackedFloatList(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        FloatArrayList floatArrayList = (FloatArrayList)list;
        int n2 = position + registers.int1;
        for (position = ArrayDecoders.decodeVarint32(data, position, registers); position < n2; position += 4) {
            floatArrayList.addFloat(ArrayDecoders.decodeFloat(data, position));
        }
        if (position != n2) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodePackedDoubleList(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        DoubleArrayList doubleArrayList = (DoubleArrayList)list;
        int n2 = position + registers.int1;
        for (position = ArrayDecoders.decodeVarint32(data, position, registers); position < n2; position += 8) {
            doubleArrayList.addDouble(ArrayDecoders.decodeDouble(data, position));
        }
        if (position != n2) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodePackedBoolList(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        BooleanArrayList booleanArrayList = (BooleanArrayList)list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int n2 = position + registers.int1;
        while (position < n2) {
            position = ArrayDecoders.decodeVarint64(data, position, registers);
            booleanArrayList.addBoolean(registers.long1 != 0L);
        }
        if (position != n2) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodePackedSInt32List(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        IntArrayList intArrayList = (IntArrayList)list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int n2 = position + registers.int1;
        while (position < n2) {
            position = ArrayDecoders.decodeVarint32(data, position, registers);
            intArrayList.addInt(CodedInputStream.decodeZigZag32(registers.int1));
        }
        if (position != n2) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodePackedSInt64List(byte[] data, int position, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        LongArrayList longArrayList = (LongArrayList)list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int n2 = position + registers.int1;
        while (position < n2) {
            position = ArrayDecoders.decodeVarint64(data, position, registers);
            longArrayList.addLong(CodedInputStream.decodeZigZag64(registers.long1));
        }
        if (position != n2) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return position;
    }

    static int decodeStringList(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) throws InvalidProtocolBufferException {
        Internal.ProtobufList<?> protobufList = list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int n2 = registers.int1;
        if (n2 < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (n2 == 0) {
            protobufList.add("");
        } else {
            String string = new String(data, position, n2, Internal.UTF_8);
            protobufList.add(string);
            position += n2;
        }
        while (position < limit) {
            int n3 = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint32(data, n3, registers);
            int n4 = registers.int1;
            if (n4 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (n4 == 0) {
                protobufList.add("");
                continue;
            }
            String string = new String(data, position, n4, Internal.UTF_8);
            protobufList.add(string);
            position += n4;
        }
        return position;
    }

    static int decodeStringListRequireUtf8(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) throws InvalidProtocolBufferException {
        Internal.ProtobufList<?> protobufList = list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int n2 = registers.int1;
        if (n2 < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (n2 == 0) {
            protobufList.add("");
        } else {
            int n3 = position;
            if (!Utf8.isValidUtf8(data, n3, n3 + n2)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            String string = new String(data, position, n2, Internal.UTF_8);
            protobufList.add(string);
            position += n2;
        }
        while (position < limit) {
            int n4 = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint32(data, n4, registers);
            int n5 = registers.int1;
            if (n5 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (n5 == 0) {
                protobufList.add("");
                continue;
            }
            int n6 = position;
            if (!Utf8.isValidUtf8(data, n6, n6 + n5)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            String string = new String(data, position, n5, Internal.UTF_8);
            protobufList.add(string);
            position += n5;
        }
        return position;
    }

    static int decodeBytesList(int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) throws InvalidProtocolBufferException {
        Internal.ProtobufList<?> protobufList = list;
        position = ArrayDecoders.decodeVarint32(data, position, registers);
        int n2 = registers.int1;
        if (n2 < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (n2 > data.length - position) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        if (n2 == 0) {
            protobufList.add(ByteString.EMPTY);
        } else {
            protobufList.add(ByteString.copyFrom(data, position, n2));
            position += n2;
        }
        while (position < limit) {
            int n3 = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeVarint32(data, n3, registers);
            int n4 = registers.int1;
            if (n4 < 0) {
                throw InvalidProtocolBufferException.negativeSize();
            }
            if (n4 > data.length - position) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            if (n4 == 0) {
                protobufList.add(ByteString.EMPTY);
                continue;
            }
            protobufList.add(ByteString.copyFrom(data, position, n4));
            position += n4;
        }
        return position;
    }

    static int decodeMessageList(Schema<?> schema, int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        Internal.ProtobufList<?> protobufList = list;
        position = ArrayDecoders.decodeMessageField(schema, data, position, limit, registers);
        protobufList.add(registers.object1);
        while (position < limit) {
            int n2 = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeMessageField(schema, data, n2, limit, registers);
            protobufList.add(registers.object1);
        }
        return position;
    }

    static int decodeGroupList(Schema schema, int tag, byte[] data, int position, int limit, Internal.ProtobufList<?> list, Registers registers) throws IOException {
        Internal.ProtobufList<?> protobufList = list;
        int n2 = tag & 0xFFFFFFF8 | 4;
        position = ArrayDecoders.decodeGroupField(schema, data, position, limit, n2, registers);
        protobufList.add(registers.object1);
        while (position < limit) {
            int n3 = ArrayDecoders.decodeVarint32(data, position, registers);
            if (tag != registers.int1) break;
            position = ArrayDecoders.decodeGroupField(schema, data, n3, limit, n2, registers);
            protobufList.add(registers.object1);
        }
        return position;
    }

    static int decodeExtensionOrUnknownField(int tag, byte[] data, int position, int limit, Object message, MessageLite defaultInstance, UnknownFieldSchema<UnknownFieldSetLite, UnknownFieldSetLite> unknownFieldSchema, Registers registers) throws IOException {
        int n2 = tag >>> 3;
        GeneratedMessageLite.GeneratedExtension<MessageLite, ?> generatedExtension = registers.extensionRegistry.findLiteExtensionByNumber(defaultInstance, n2);
        if (generatedExtension == null) {
            return ArrayDecoders.decodeUnknownField(tag, data, position, limit, MessageSchema.getMutableUnknownFields(message), registers);
        }
        ((GeneratedMessageLite.ExtendableMessage)message).ensureExtensionsAreMutable();
        return ArrayDecoders.decodeExtension(tag, data, position, limit, (GeneratedMessageLite.ExtendableMessage)message, generatedExtension, unknownFieldSchema, registers);
    }

    /*
     * Enabled aggressive block sorting
     */
    static int decodeExtension(int tag, byte[] data, int position, int limit, GeneratedMessageLite.ExtendableMessage<?, ?> message, GeneratedMessageLite.GeneratedExtension<?, ?> extension, UnknownFieldSchema<UnknownFieldSetLite, UnknownFieldSetLite> unknownFieldSchema, Registers registers) throws IOException {
        Object object;
        FieldSet<GeneratedMessageLite.ExtensionDescriptor> fieldSet;
        block35: {
            int n2;
            block34: {
                fieldSet = message.extensions;
                n2 = tag >>> 3;
                if (!extension.descriptor.isRepeated() || !extension.descriptor.isPacked()) break block34;
                switch (extension.getLiteType()) {
                    case DOUBLE: {
                        object = new DoubleArrayList();
                        position = ArrayDecoders.decodePackedDoubleList(data, position, object, registers);
                        break block35;
                    }
                    case FLOAT: {
                        object = new FloatArrayList();
                        position = ArrayDecoders.decodePackedFloatList(data, position, object, registers);
                        break block35;
                    }
                    case INT64: 
                    case UINT64: {
                        object = new LongArrayList();
                        position = ArrayDecoders.decodePackedVarint64List(data, position, object, registers);
                        break block35;
                    }
                    case INT32: 
                    case UINT32: {
                        object = new IntArrayList();
                        position = ArrayDecoders.decodePackedVarint32List(data, position, object, registers);
                        break block35;
                    }
                    case FIXED64: 
                    case SFIXED64: {
                        object = new LongArrayList();
                        position = ArrayDecoders.decodePackedFixed64List(data, position, object, registers);
                        break block35;
                    }
                    case FIXED32: 
                    case SFIXED32: {
                        object = new IntArrayList();
                        position = ArrayDecoders.decodePackedFixed32List(data, position, object, registers);
                        break block35;
                    }
                    case BOOL: {
                        object = new BooleanArrayList();
                        position = ArrayDecoders.decodePackedBoolList(data, position, object, registers);
                        break block35;
                    }
                    case SINT32: {
                        object = new IntArrayList();
                        position = ArrayDecoders.decodePackedSInt32List(data, position, object, registers);
                        break block35;
                    }
                    case SINT64: {
                        object = new LongArrayList();
                        position = ArrayDecoders.decodePackedSInt64List(data, position, object, registers);
                        break block35;
                    }
                    case ENUM: {
                        object = new IntArrayList();
                        position = ArrayDecoders.decodePackedVarint32List(data, position, object, registers);
                        SchemaUtil.filterUnknownEnumList(message, n2, (List<Integer>)object, extension.descriptor.getEnumType(), null, unknownFieldSchema);
                        break block35;
                    }
                    default: {
                        throw new IllegalStateException("Type cannot be packed: " + (Object)((Object)extension.descriptor.getLiteType()));
                    }
                }
            }
            object = null;
            if (extension.getLiteType() == WireFormat.FieldType.ENUM) {
                position = ArrayDecoders.decodeVarint32(data, position, registers);
                Object obj = extension.descriptor.getEnumType().findValueByNumber(registers.int1);
                if (obj == null) {
                    SchemaUtil.storeUnknownEnum(message, n2, registers.int1, null, unknownFieldSchema);
                    return position;
                }
                object = registers.int1;
            } else {
                switch (extension.getLiteType()) {
                    case DOUBLE: {
                        object = ArrayDecoders.decodeDouble(data, position);
                        position += 8;
                        break;
                    }
                    case FLOAT: {
                        object = Float.valueOf(ArrayDecoders.decodeFloat(data, position));
                        position += 4;
                        break;
                    }
                    case INT64: 
                    case UINT64: {
                        position = ArrayDecoders.decodeVarint64(data, position, registers);
                        object = registers.long1;
                        break;
                    }
                    case INT32: 
                    case UINT32: {
                        position = ArrayDecoders.decodeVarint32(data, position, registers);
                        object = registers.int1;
                        break;
                    }
                    case FIXED64: 
                    case SFIXED64: {
                        object = ArrayDecoders.decodeFixed64(data, position);
                        position += 8;
                        break;
                    }
                    case FIXED32: 
                    case SFIXED32: {
                        object = ArrayDecoders.decodeFixed32(data, position);
                        position += 4;
                        break;
                    }
                    case BOOL: {
                        position = ArrayDecoders.decodeVarint64(data, position, registers);
                        object = registers.long1 != 0L;
                        break;
                    }
                    case BYTES: {
                        position = ArrayDecoders.decodeBytes(data, position, registers);
                        object = registers.object1;
                        break;
                    }
                    case SINT32: {
                        position = ArrayDecoders.decodeVarint32(data, position, registers);
                        object = CodedInputStream.decodeZigZag32(registers.int1);
                        break;
                    }
                    case SINT64: {
                        position = ArrayDecoders.decodeVarint64(data, position, registers);
                        object = CodedInputStream.decodeZigZag64(registers.long1);
                        break;
                    }
                    case STRING: {
                        position = ArrayDecoders.decodeString(data, position, registers);
                        object = registers.object1;
                        break;
                    }
                    case GROUP: {
                        int n3 = n2 << 3 | 4;
                        Schema<Class<?>> schema = Protobuf.getInstance().schemaFor(extension.getMessageDefaultInstance().getClass());
                        if (extension.isRepeated()) {
                            position = ArrayDecoders.decodeGroupField(schema, data, position, limit, n3, registers);
                            fieldSet.addRepeatedField(extension.descriptor, registers.object1);
                            return position;
                        }
                        Class<?> clazz = fieldSet.getField(extension.descriptor);
                        if (clazz != null) return ArrayDecoders.mergeGroupField(clazz, schema, data, position, limit, n3, registers);
                        clazz = schema.newInstance();
                        fieldSet.setField(extension.descriptor, clazz);
                        return ArrayDecoders.mergeGroupField(clazz, schema, data, position, limit, n3, registers);
                    }
                    case MESSAGE: {
                        Schema<Class<?>> schema = Protobuf.getInstance().schemaFor(extension.getMessageDefaultInstance().getClass());
                        if (extension.isRepeated()) {
                            position = ArrayDecoders.decodeMessageField(schema, data, position, limit, registers);
                            fieldSet.addRepeatedField(extension.descriptor, registers.object1);
                            return position;
                        }
                        Class<?> clazz = fieldSet.getField(extension.descriptor);
                        if (clazz != null) return ArrayDecoders.mergeMessageField(clazz, schema, data, position, limit, registers);
                        clazz = schema.newInstance();
                        fieldSet.setField(extension.descriptor, clazz);
                        return ArrayDecoders.mergeMessageField(clazz, schema, data, position, limit, registers);
                    }
                    case ENUM: {
                        throw new IllegalStateException("Shouldn't reach here.");
                    }
                }
            }
            if (extension.isRepeated()) {
                fieldSet.addRepeatedField(extension.descriptor, object);
                return position;
            }
        }
        fieldSet.setField(extension.descriptor, object);
        return position;
    }

    static int decodeUnknownField(int tag, byte[] data, int position, int limit, UnknownFieldSetLite unknownFields, Registers registers) throws InvalidProtocolBufferException {
        if (WireFormat.getTagFieldNumber(tag) == 0) {
            throw InvalidProtocolBufferException.invalidTag();
        }
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                position = ArrayDecoders.decodeVarint64(data, position, registers);
                unknownFields.storeField(tag, registers.long1);
                return position;
            }
            case 5: {
                unknownFields.storeField(tag, ArrayDecoders.decodeFixed32(data, position));
                return position + 4;
            }
            case 1: {
                unknownFields.storeField(tag, ArrayDecoders.decodeFixed64(data, position));
                return position + 8;
            }
            case 2: {
                position = ArrayDecoders.decodeVarint32(data, position, registers);
                int n2 = registers.int1;
                if (n2 < 0) {
                    throw InvalidProtocolBufferException.negativeSize();
                }
                if (n2 > data.length - position) {
                    throw InvalidProtocolBufferException.truncatedMessage();
                }
                if (n2 == 0) {
                    unknownFields.storeField(tag, ByteString.EMPTY);
                } else {
                    unknownFields.storeField(tag, ByteString.copyFrom(data, position, n2));
                }
                return position + n2;
            }
            case 3: {
                UnknownFieldSetLite unknownFieldSetLite = UnknownFieldSetLite.newInstance();
                int n3 = tag & 0xFFFFFFF8 | 4;
                int n4 = 0;
                while (position < limit) {
                    position = ArrayDecoders.decodeVarint32(data, position, registers);
                    n4 = registers.int1;
                    if (n4 == n3) break;
                    position = ArrayDecoders.decodeUnknownField(n4, data, position, limit, unknownFieldSetLite, registers);
                }
                if (position > limit || n4 != n3) {
                    throw InvalidProtocolBufferException.parseFailure();
                }
                unknownFields.storeField(tag, unknownFieldSetLite);
                return position;
            }
        }
        throw InvalidProtocolBufferException.invalidTag();
    }

    static int skipField(int tag, byte[] data, int position, int limit, Registers registers) throws InvalidProtocolBufferException {
        if (WireFormat.getTagFieldNumber(tag) == 0) {
            throw InvalidProtocolBufferException.invalidTag();
        }
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                position = ArrayDecoders.decodeVarint64(data, position, registers);
                return position;
            }
            case 5: {
                return position + 4;
            }
            case 1: {
                return position + 8;
            }
            case 2: {
                position = ArrayDecoders.decodeVarint32(data, position, registers);
                return position + registers.int1;
            }
            case 3: {
                int n2 = tag & 0xFFFFFFF8 | 4;
                int n3 = 0;
                while (position < limit) {
                    position = ArrayDecoders.decodeVarint32(data, position, registers);
                    n3 = registers.int1;
                    if (n3 == n2) break;
                    position = ArrayDecoders.skipField(n3, data, position, limit, registers);
                }
                if (position > limit || n3 != n2) {
                    throw InvalidProtocolBufferException.parseFailure();
                }
                return position;
            }
        }
        throw InvalidProtocolBufferException.invalidTag();
    }

    static final class Registers {
        public int int1;
        public long long1;
        public Object object1;
        public final ExtensionRegistryLite extensionRegistry;

        Registers() {
            this.extensionRegistry = ExtensionRegistryLite.getEmptyRegistry();
        }

        Registers(ExtensionRegistryLite extensionRegistry) {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            this.extensionRegistry = extensionRegistry;
        }
    }
}

