/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.AbstractProtobufList;
import ai.h2o.com.google.protobuf.Internal;
import ai.h2o.com.google.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class IntArrayList
extends AbstractProtobufList<Integer>
implements Internal.IntList,
PrimitiveNonBoxingCollection,
RandomAccess {
    private static final IntArrayList EMPTY_LIST = new IntArrayList(new int[0], 0);
    private int[] array;
    private int size;

    public static IntArrayList emptyList() {
        return EMPTY_LIST;
    }

    IntArrayList() {
        this(new int[10], 0);
    }

    private IntArrayList(int[] other, int size) {
        this.array = other;
        this.size = size;
    }

    @Override
    protected final void removeRange(int fromIndex, int toIndex) {
        this.ensureIsMutable();
        if (toIndex < fromIndex) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.array, toIndex, this.array, fromIndex, this.size - toIndex);
        this.size -= toIndex - fromIndex;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof IntArrayList)) {
            return super.equals(o2);
        }
        IntArrayList intArrayList = (IntArrayList)o2;
        if (this.size != intArrayList.size) {
            return false;
        }
        int[] nArray = intArrayList.array;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.array[i2] == nArray[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n2 = 1;
        for (int i2 = 0; i2 < this.size; ++i2) {
            n2 = n2 * 31 + this.array[i2];
        }
        return n2;
    }

    @Override
    public final Internal.IntList mutableCopyWithCapacity(int capacity) {
        if (capacity < this.size) {
            throw new IllegalArgumentException();
        }
        return new IntArrayList(Arrays.copyOf(this.array, capacity), this.size);
    }

    @Override
    public final Integer get(int index) {
        return this.getInt(index);
    }

    @Override
    public final int getInt(int index) {
        this.ensureIndexInRange(index);
        return this.array[index];
    }

    @Override
    public final int indexOf(Object element) {
        if (!(element instanceof Integer)) {
            return -1;
        }
        int n2 = (Integer)element;
        int n3 = this.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (this.array[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object element) {
        return this.indexOf(element) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final Integer set(int index, Integer element) {
        return this.setInt(index, element);
    }

    @Override
    public final int setInt(int index, int element) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index);
        int n2 = this.array[index];
        this.array[index] = element;
        return n2;
    }

    @Override
    public final boolean add(Integer element) {
        this.addInt(element);
        return true;
    }

    @Override
    public final void add(int index, Integer element) {
        this.addInt(index, element);
    }

    @Override
    public final void addInt(int element) {
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            int n2 = this.size * 3 / 2 + 1;
            int[] nArray = new int[n2];
            System.arraycopy(this.array, 0, nArray, 0, this.size);
            this.array = nArray;
        }
        this.array[this.size++] = element;
    }

    private void addInt(int index, int element) {
        this.ensureIsMutable();
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        } else {
            int n2 = this.size * 3 / 2 + 1;
            int[] nArray = new int[n2];
            System.arraycopy(this.array, 0, nArray, 0, index);
            System.arraycopy(this.array, index, nArray, index + 1, this.size - index);
            this.array = nArray;
        }
        this.array[index] = element;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof IntArrayList)) {
            return super.addAll(collection);
        }
        IntArrayList intArrayList = (IntArrayList)collection;
        if (intArrayList.size == 0) {
            return false;
        }
        int n2 = Integer.MAX_VALUE - this.size;
        if (n2 < intArrayList.size) {
            throw new OutOfMemoryError();
        }
        int n3 = this.size + intArrayList.size;
        if (n3 > this.array.length) {
            this.array = Arrays.copyOf(this.array, n3);
        }
        System.arraycopy(intArrayList.array, 0, this.array, this.size, intArrayList.size);
        this.size = n3;
        ++this.modCount;
        return true;
    }

    @Override
    public final Integer remove(int index) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index);
        int n2 = this.array[index];
        if (index < this.size - 1) {
            System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
        }
        --this.size;
        ++this.modCount;
        return n2;
    }

    private void ensureIndexInRange(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int index) {
        return "Index:" + index + ", Size:" + this.size;
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

