/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.CheckReturnValue;
import ai.h2o.com.google.protobuf.Internal;
import ai.h2o.com.google.protobuf.LazyStringArrayList;
import ai.h2o.com.google.protobuf.LazyStringList;
import ai.h2o.com.google.protobuf.PrimitiveNonBoxingCollection;
import ai.h2o.com.google.protobuf.UnmodifiableLazyStringList;
import ai.h2o.com.google.protobuf.UnsafeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@CheckReturnValue
abstract class ListFieldSchema {
    private static final ListFieldSchema FULL_INSTANCE = new ListFieldSchemaFull();
    private static final ListFieldSchema LITE_INSTANCE = new ListFieldSchemaLite();

    private ListFieldSchema() {
    }

    abstract <L> List<L> mutableListAt(Object var1, long var2);

    abstract void makeImmutableListAt(Object var1, long var2);

    abstract <L> void mergeListsAt(Object var1, Object var2, long var3);

    static ListFieldSchema full() {
        return FULL_INSTANCE;
    }

    static ListFieldSchema lite() {
        return LITE_INSTANCE;
    }

    private static final class ListFieldSchemaLite
    extends ListFieldSchema {
        private ListFieldSchemaLite() {
        }

        @Override
        final <L> List<L> mutableListAt(Object message, long offset) {
            Internal.ProtobufList protobufList = ListFieldSchemaLite.getProtobufList(message, offset);
            if (!protobufList.isModifiable()) {
                int n2 = protobufList.size();
                protobufList = protobufList.mutableCopyWithCapacity(n2 == 0 ? 10 : n2 << 1);
                UnsafeUtil.putObject(message, offset, protobufList);
            }
            return protobufList;
        }

        @Override
        final void makeImmutableListAt(Object message, long offset) {
            Internal.ProtobufList protobufList = ListFieldSchemaLite.getProtobufList(message, offset);
            protobufList.makeImmutable();
        }

        @Override
        final <E> void mergeListsAt(Object msg, Object otherMsg, long offset) {
            Internal.ProtobufList<E> protobufList = ListFieldSchemaLite.getProtobufList(msg, offset);
            Internal.ProtobufList<E> protobufList2 = ListFieldSchemaLite.getProtobufList(otherMsg, offset);
            int n2 = protobufList.size();
            int n3 = protobufList2.size();
            if (n2 > 0 && n3 > 0) {
                if (!protobufList.isModifiable()) {
                    protobufList = protobufList.mutableCopyWithCapacity(n2 + n3);
                }
                protobufList.addAll(protobufList2);
            }
            Internal.ProtobufList<E> protobufList3 = n2 > 0 ? protobufList : protobufList2;
            UnsafeUtil.putObject(msg, offset, protobufList3);
        }

        static <E> Internal.ProtobufList<E> getProtobufList(Object message, long offset) {
            return (Internal.ProtobufList)UnsafeUtil.getObject(message, offset);
        }
    }

    private static final class ListFieldSchemaFull
    extends ListFieldSchema {
        private static final Class<?> UNMODIFIABLE_LIST_CLASS = Collections.unmodifiableList(Collections.emptyList()).getClass();

        private ListFieldSchemaFull() {
        }

        @Override
        final <L> List<L> mutableListAt(Object message, long offset) {
            return ListFieldSchemaFull.mutableListAt(message, offset, 10);
        }

        @Override
        final void makeImmutableListAt(Object message, long offset) {
            List<String> list;
            List list2 = (List)UnsafeUtil.getObject(message, offset);
            if (list2 instanceof LazyStringList) {
                list = ((LazyStringList)list2).getUnmodifiableView();
            } else {
                if (UNMODIFIABLE_LIST_CLASS.isAssignableFrom(list2.getClass())) {
                    return;
                }
                if (list2 instanceof PrimitiveNonBoxingCollection && list2 instanceof Internal.ProtobufList) {
                    if (((Internal.ProtobufList)list2).isModifiable()) {
                        ((Internal.ProtobufList)list2).makeImmutable();
                    }
                    return;
                }
                list = Collections.unmodifiableList(list2);
            }
            UnsafeUtil.putObject(message, offset, (Object)list);
        }

        private static <L> List<L> mutableListAt(Object message, long offset, int additionalCapacity) {
            List<String> list = ListFieldSchemaFull.getList(message, offset);
            if (list.isEmpty()) {
                list = list instanceof LazyStringList ? new LazyStringArrayList(additionalCapacity) : (list instanceof PrimitiveNonBoxingCollection && list instanceof Internal.ProtobufList ? ((Internal.ProtobufList)list).mutableCopyWithCapacity(additionalCapacity) : new ArrayList(additionalCapacity));
                UnsafeUtil.putObject(message, offset, (Object)list);
            } else if (UNMODIFIABLE_LIST_CLASS.isAssignableFrom(list.getClass())) {
                ArrayList<String> arrayList = new ArrayList<String>(list.size() + additionalCapacity);
                arrayList.addAll(list);
                list = arrayList;
                UnsafeUtil.putObject(message, offset, list);
            } else if (list instanceof UnmodifiableLazyStringList) {
                LazyStringArrayList lazyStringArrayList = new LazyStringArrayList(list.size() + additionalCapacity);
                lazyStringArrayList.addAll((UnmodifiableLazyStringList)list);
                list = lazyStringArrayList;
                UnsafeUtil.putObject(message, offset, list);
            } else if (list instanceof PrimitiveNonBoxingCollection && list instanceof Internal.ProtobufList && !((Internal.ProtobufList)list).isModifiable()) {
                list = ((Internal.ProtobufList)list).mutableCopyWithCapacity(list.size() + additionalCapacity);
                UnsafeUtil.putObject(message, offset, list);
            }
            return list;
        }

        @Override
        final <E> void mergeListsAt(Object msg, Object otherMsg, long offset) {
            List<E> list = ListFieldSchemaFull.getList(otherMsg, offset);
            List list2 = ListFieldSchemaFull.mutableListAt(msg, offset, list.size());
            int n2 = list2.size();
            int n3 = list.size();
            if (n2 > 0 && n3 > 0) {
                list2.addAll(list);
            }
            List<Object> list3 = n2 > 0 ? list2 : list;
            UnsafeUtil.putObject(msg, offset, list3);
        }

        static <E> List<E> getList(Object message, long offset) {
            return (List)UnsafeUtil.getObject(message, offset);
        }
    }
}

