# Generated by Django 2.0.2 on 2018-11-29 21:04

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('quartet_capture', '0003_auto_20181127_1120'),
    ]

    operations = [
        migrations.CreateModel(
            name='Filter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='A step is a piece of logic that runs within a rule.', max_length=100, unique=True, verbose_name='Step')),
                ('description', models.CharField(help_text='A short description.', max_length=500, null=True, verbose_name='Description')),
            ],
        ),
        migrations.CreateModel(
            name='RuleFilter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('search_value', models.CharField(help_text='This is either a generic search term or a regular expression used to determine if a Rule should be executed.', max_length=2000, verbose_name='Search Value')),
                ('search_type', models.CharField(choices=[('regex', 'Regular Expression'), ('search', 'Text Search')], default='regex', help_text='Regular Expression (regex) or Text Search (text). A regular expression that matches something in the inbound data or a plain text search value containing a string that can be matched within the inbound data.', max_length=10, verbose_name='Search Type')),
                ('reverse', models.BooleanField(default=False, help_text="Set this to true if you'd like the search logic to act in 'reverse' in that any messages matching the defined value will not trigger the rule and all others will.", verbose_name='Reverse')),
                ('order', models.IntegerField(default=1, help_text='The order in which this filter should be applied.', verbose_name='Order')),
                ('filter', models.ForeignKey(help_text='The filter to associate this search value with.', on_delete=django.db.models.deletion.CASCADE, to='quartet_capture.Filter', verbose_name='Filter')),
                ('rule', models.ForeignKey(help_text='The rule to execute if the search term executes.', on_delete=django.db.models.deletion.CASCADE, to='quartet_capture.Rule', verbose_name='Rule')),
            ],
            options={
                'ordering': ['order'],
            },
        ),
        migrations.AlterUniqueTogether(
            name='rulefilter',
            unique_together={('order', 'filter')},
        ),
    ]
