trade_metadata = {
    "x_prod_val": {
        "cols": "D:ZZZ",
        "currency": "USD",
        "unit": "Millones",
        "colnames": {
            "TOTAL EXPORTACIONES ": "Total exportaciones",
            "ACTIVIDADES PRIMARIAS": "Actividades primarias: total",
            "Agricultura, Ganadería, Caza y actividades de servicios conexas": "Act. primarias: agricultura, ganadería y caza",
            "Cultivos en general; horticultura; servicios agrícolas aplicados a estos cultivos": "Act. primarias: agricultura",
            "Cría de animales; caza ordinaria y servicios conexos; producción de pieles finas mediante actividades de caza ordinaria y con trampas; servicios ganaderos": "Act. primarias: ganadería y caza",
            "Silvicultura, extracción de madera y actividades de servicios conexas": "Act. primarias: silvicultura",
            "INDUSTRIAS MANUFACTURERAS": "Industrias manufactureras: total",
            "Elaboración de productos alimenticios y bebidas": "Ind. manufacturera: alimentos y bebidas",
            "Producción, procesamiento y conservación de carne y productos cárnicos": "Ind. manufacturera: alimentos y bebidas - carnes",
            "Elaboración y conservación de pescado y productos de pescado": "Ind. manufacturera: alimentos y bebidas - pescado",
            "Elaboración de productos lácteos": "Ind. manufacturera: alimentos y bebidas - lácteos",
            "Elaboración de arroz y productos derivados del arroz": "Ind. manufacturera: alimentos y bebidas - arroz",
            "Elaboración de bebidas malteadas y de malta": "Ind. manufacturera: alimentos y bebidas - malta",
            "Elaboración de productos alimenticios y bebidas - Resto ": "Ind. manufacturera: alimentos y bebidas - otros",
            "Elaboración de Productos de Tabaco": "Ind. manufacturera: tabaco",
            "Fabricación de productos textiles": "Ind. manufacturera: textiles",
            "Preparación, hilandería, tejeduría y acabado de productos textiles": "Ind. manufacturera: textiles - hilandería y tejeduria",
            "Fabricación de prendas de vestir; adobo y  teñido de pieles": "Ind. manufacturera: prendas de vestir",
            "Curtido y adobo de cueros; fabricación de maletas, bolsos de mano, artículos de talabartería y guarnicionería, y calzado": "Ind. manufacturera: cueros",
            "Curtido y adobo de cueros; fabricación de maletas, bolsos de mano y artículos de talabartería y guarnicionería": "Ind. manufacturera: cueros - curtidos, adobos, derivados",
            "Producción de madera y fabricación de productos de madera y corcho excepto muebles; fabricación de artículos de paja y de materiales trenzables": "Ind. manufacturera: madera",
            "Fabricación de papel y de productos de papel; Actividades de edición e impresión y de reproducción de grabaciones": "Ind. manufacturera: papel",
            "Fabricación de coque, productos de la refinación del petróleo y combustible nuclear": "Ind. manufacturera: refinación de petróleo",
            "Fabricación de sustancias y productos químicos": "Ind. manufacturera: químicos",
            "Fabricación de sustancias químicas básicas, excepto abonos y compuestos de nitrógeno; fabricación de plásticos en formas primarias y de caucho sintético": "Ind. manufacturera: químicos - básicos excepto abonos",
            "Fabricación de abonos y compuestos de nitrógeno; Fabricación de plaguicidas y otros productos químicos de uso agropecuario": "Ind. manufacturera: químicos - abonos",
            "Fabricación de productos farmaceúticos, sustancias químicas medicinales y productos botánicos": "Ind. manufacturera: químicos - farmacéuticos",
            "Fabricación de jabones y detergentes, preparados para limpiar y pulir, perfumes y preparados de tocador": "Ind. manufacturera: químicos - jabones y detergentes",
            "Fabricación de productos de caucho y plástico": "Ind. manufacturera: caucho y plástico",
            "Fabricación de metales comunes; Fabricación de otros productos minerales no metálicos": "Ind. manufacturera: metales y minerales no metálicos",
            "Fabricación de vehículos automotores, remolques y semirremolques; Fabricación de otros tipos de equipo de transporte": "Ind. manufacturera: automotores",
            "INDUSTRIAS MANUFACTURERAS - Resto": "Ind. manufacturera: otros",
            "ELECTRICIDAD, GAS Y AGUA": "Electricidad, gas y agua: total",
        },
    },
    "x_prod_vol": {
        "cols": "D:ZZZ",
        "currency": "-",
        "unit": "2005=100",
        "colnames": {
            "TOTAL EXPORTACIONES ": "Total exportaciones",
            "AGRICULTURA, GANADERIA, CAZA Y SILVICULTURA": "Actividades primarias: total",
            "Trigo; servicios agrícolas aplicados al cultivo de trigo": "Actividades primarias: trigo",
            "Soja; girasol; servicios agrícolas aplicados al cultivo de soja y girasol": "Actividades primarias: soja y girasol",
            "Productos de árboles frutales, uvas, y plantas cuyas hojas o frutas se utilizan para preparar bebidas o especias; servicios agrícolas aplicados a estos cultivos": "Actividades primarias: prod. árboles frutales",
            "Productos de la cría de ganado vacuno, ovino, caprino, caballar, excepto producción de leche, lana y cueros; servicios ganaderos aplicados a esta actividad": "Actividades primarias: ganadería",
            "Madera y otros productos de la silvicultura. Servicios conexos": "Actividades primarias: silvicultura",
            "INDUSTRIAS MANUFACTURERAS": "Industrias manufactureras: total",
            "Carnes y productos del procesamiento y conservación de carne": "Ind. manufacturera: alimentos y bebidas - carnes",
            "Productos de la elaboración y conservación de pescado": "Ind. manufacturera: alimentos y bebidas - pescado",
            "Productos lácteos": "Ind. manufacturera: alimentos y bebidas - lácteos",
            "Arroz elaborado y otros productos derivados del arroz": "Ind. manufacturera: alimentos y bebidas - arroz",
            "Productos de la elaboración de cacao, chocolate, productos de confitería y otros productos alimenticios n.c.p.\n": "Ind. manufacturera: alimentos y bebidas - cacao",
            "Bebidas malteadas y malta": "Ind. manufacturera: alimentos y bebidas - malta",
            "Productos de lavaderos; hilados y tejidos; otros productos de la hilandería, tejeduría y acabado de productos textiles": "Ind. manufacturera: textiles",
            "Prendas de vestir; adobo y teñido de pieles": "Ind. manufacturera: prendas de vestir",
            "Cueros elaborados; artículos de talabartería y guarnicionería": "Ind. manufacturera: cueros - curtidos, adobos, derivados",
            "Productos de aserrado y otros artículos de madera, excepto muebles": "Ind. manufacturera: madera",
            "Papel, cartón y subproductos": "Ind. manufacturera: papel",
            "Productos de la refinación del petróleo y combustible nuclear": "Ind. manufacturera: refinación de petróleo",
            "Abonos y compuestos de nitrógeno": "Ind. manufacturera: químicos - abonos",
            "Sustancias químicas básicas, excepto abonos": "Ind. manufacturera: químicos - básicos excepto abonos",
            "Productos farmacéuticos, sustancias químicas medicinales y productos botánicos, de uso humano y animal": "Ind. manufacturera: químicos - farmacéuticos",
            "Productos de limpieza y tocador, primarias y de caucho sintético": "Ind. manufacturera: químicos - jabones y detergentes",
            "Productos de caucho y plástico": "Ind. manufacturera: caucho y plástico",
            "Productos de fundición de hierro y acero; aluminio y otros metales no ferrosos": "Ind. manufacturera: metales y minerales no metálicos",
            "Vehículos automotores, remolques, semiremolques y contenedores; partes y piezas elaboradas para los mismos": "Ind. manufacturera: automotores",
        },
    },
    "x_prod_pri": {
        "cols": "D:ZZZ",
        "currency": "USD",
        "unit": "2005=100",
        "colnames": {
            "TOTAL EXPORTACIONES ": "Total exportaciones",
            "AGRICULTURA, GANADERIA, CAZA Y SILVICULTURA": "Actividades primarias: total",
            "Trigo; servicios agrícolas aplicados al cultivo de trigo": "Actividades primarias: trigo",
            "Soja; girasol; servicios agrícolas aplicados al cultivo de soja y girasol": "Actividades primarias: soja y girasol",
            "Productos de árboles frutales, uvas, y plantas cuyas hojas o frutas se utilizan para preparar bebidas o especias; servicios agrícolas aplicados a estos cultivos": "Actividades primarias: prod. árboles frutales",
            "Productos de la cría de ganado vacuno, ovino, caprino, caballar, excepto producción de leche, lana y cueros; servicios ganaderos aplicados a esta actividad": "Actividades primarias: ganadería",
            "Madera y otros productos de la silvicultura. Servicios conexos": "Actividades primarias: silvicultura",
            "INDUSTRIAS MANUFACTURERAS": "Industrias manufactureras: total",
            "Carnes y productos del procesamiento y conservación de carne": "Ind. manufacturera: alimentos y bebidas - carnes",
            "Productos de la elaboración y conservación de pescado": "Ind. manufacturera: alimentos y bebidas - pescado",
            "Productos lácteos": "Ind. manufacturera: alimentos y bebidas - lácteos",
            "Arroz elaborado y otros productos derivados del arroz": "Ind. manufacturera: alimentos y bebidas - arroz",
            "Productos de la elaboración de cacao, chocolate, productos de confitería y otros productos alimenticios n.c.p.": "Ind. manufacturera: alimentos y bebidas - cacao",
            "Bebidas malteadas y malta": "Ind. manufacturera: alimentos y bebidas - malta",
            "Productos de lavaderos; hilados y tejidos; otros productos de la hilandería, tejeduría y acabado de productos textiles": "Ind. manufacturera: textiles",
            "Prendas de vestir; adobo y teñido de pieles": "Ind. manufacturera: prendas de vestir",
            "Cueros elaborados; artículos de talabartería y guarnicionería": "Ind. manufacturera: cueros - curtidos, adobos, derivados",
            "Productos de aserrado y otros artículos de madera, excepto muebles": "Ind. manufacturera: madera",
            "Papel, cartón y subproductos": "Ind. manufacturera: papel",
            "Productos de la refinación del petróleo y combustible nuclear": "Ind. manufacturera: refinación de petróleo",
            "Abonos y compuestos de nitrógeno": "Ind. manufacturera: químicos - abonos",
            "Sustancias químicas básicas, excepto abonos": "Ind. manufacturera: químicos - básicos excepto abonos",
            "Productos farmacéuticos, sustancias químicas medicinales y productos botánicos, de uso humano y animal": "Ind. manufacturera: químicos - farmacéuticos",
            "Productos de limpieza y tocador, primarias y de caucho sintético": "Ind. manufacturera: químicos - jabones y detergentes",
            "Productos de caucho y plástico": "Ind. manufacturera: caucho y plástico",
            "Productos de fundición de hierro y acero; aluminio y otros metales no ferrosos": "Ind. manufacturera: metales y minerales no metálicos",
            "Vehículos automotores, remolques, semiremolques y contenedores; partes y piezas elaboradas para los mismos": "Ind. manufacturera: automotores",
        },
    },
    "x_dest_val": {
        "cols": "B:ZZZ",
        "currency": "USD",
        "unit": "Millones",
        "colnames": {
            "TOTAL EXPORTACIONES": "Total exportaciones",
            "AMERICA": "América: total",
            "ALADI 2/": "América: ALADI",
            "Argentina": "América: Argentina",
            "Brasil": "América: Brasil",
            "Paraguay": "América: Paraguay",
            "Sub-total MERCOSUR (4 PAISES)": "América: MERCOSUR 4 países",
            "Venezuela": "América: Venezuela",
            "Sub-total MERCOSUR (5 PAISES)": "América: MERCOSUR 5 países",
            "Bolivia": "América: Bolivia",
            "Chile": "América: Chile",
            "México": "América: México",
            "Otros de Aladi": "América: otros ALADI",
            "CANADA": "América: Canadá",
            "ESTADOS UNIDOS": "América: Estados Unidos",
            "RESTO DE AMERICA": "América: otros",
            "EUROPA": "Europa: total",
            "U.E. (UNION EUROPEA)": "Europa: Unión Europea - total",
            "Alemania": "Europa: UE - Alemania",
            "España": "Europa: UE - España",
            "Francia": "Europa: UE - Francia",
            "Italia": "Europa: UE - Italia",
            "Países Bajos": "Europa: UE - Países Bajos",
            "Reino Unido": "Europa: UE - Reino Unido",
            "Otros de la U.E.": "Europa: UE - otros",
            "AELC (EFTA)1/": "Europa: EFTA",
            "RESTO DE EUROPA": "Europa: otros",
            "Rusia": "Europa: otros - Rusia",
            "RESTO DEL MUNDO": "Resto del mundo: total",
            "AFRICA": "Resto del mundo: África",
            "ASIA (excl. M. Oriente)": "Resto del mundo: Asia - total",
            "China (Continental)": "Resto del mundo: Asia - China",
            "Corea del Sur": "Resto del mundo: Asia - Corea del Sur",
            "Taiwán": "Resto del mundo: Asia - Taiwán",
            "Hong Kong": "Resto del mundo: Asia - Hong Kong",
            "Japón": "Resto del mundo: Asia - Japón",
            "Otros de Asia": "Resto del mundo: Asia - otros",
            "MEDIO ORIENTE": "Resto del mundo: Medio Oriente - total",
            "Arabia": "Resto del mundo: Medio Oriente - Arabia",
            "Irán": "Resto del mundo: Medio Oriente - Irán",
            "Israel": "Resto del mundo: Medio Oriente - Israel",
            "Otros del Medio Oriente": "Resto del mundo: Medio Oriente - otros",
            "OTROS PAISES": "Resto del mundo: otros",
        },
    },
    "x_dest_vol": {
        "cols": "B:ZZZ",
        "currency": "-",
        "unit": "2005=100",
        "colnames": {
            "TOTAL EXPORTACIONES": "Total exportaciones",
            "AMERICA": "América: total",
            "ALADI 1/": "América: ALADI",
            "Argentina": "América: Argentina",
            "Brasil": "América: Brasil",
            "Paraguay": "América: Paraguay",
            "SUB-TOTAL  MERCOSUR (4 PAISES)": "América: MERCOSUR 4 países",
            "Venezuela": "América: Venezuela",
            "SUB-TOTAL  MERCOSUR (5 PAISES)": "América: MERCOSUR 5 países",
            "Chile": "América: Chile",
            "México": "América: México",
            "CANADA": "América: Canadá",
            "ESTADOS UNIDOS": "América: Estados Unidos",
            "EUROPA": "Europa: total",
            "U.E. (UNION EUROPEA)": "Europa: Unión Europea - total",
            "Alemania": "Europa: UE - Alemania",
            "España": "Europa: UE - España",
            "Francia": "Europa: UE - Francia",
            "Italia": "Europa: UE - Italia",
            "Países Bajos": "Europa: UE - Países Bajos",
            "Reino Unido": "Europa: UE - Reino Unido",
            "RESTO DE EUROPA": "Europa: otros",
            "Rusia": "Europa: otros - Rusia",
            "RESTO DEL MUNDO": "Resto del mundo: total",
        },
    },
    "x_dest_pri": {
        "cols": "B:ZZZ",
        "currency": "USD",
        "unit": "2005=100",
        "colnames": {
            "TOTAL EXPORTACIONES": "Total exportaciones",
            "AMERICA": "América: total",
            "ALADI 1/": "América: ALADI",
            "Argentina": "América: Argentina",
            "Brasil": "América: Brasil",
            "Paraguay": "América: Paraguay",
            "Sub-total MERCOSUR (4 PAISES)": "América: MERCOSUR 4 países",
            "Venezuela": "América: Venezuela",
            "SUB-TOTAL  MERCOSUR (5 PAISES)": "América: MERCOSUR 5 países",
            "Chile": "América: Chile",
            "México": "América: México",
            "CANADA": "América: Canadá",
            "ESTADOS UNIDOS": "América: Estados Unidos",
            "EUROPA": "Europa: total",
            "U.E. (UNION EUROPEA)": "Europa: Unión Europea - total",
            "Alemania": "Europa: UE - Alemania",
            "España": "Europa: UE - España",
            "Francia": "Europa: UE - Francia",
            "Italia": "Europa: UE - Italia",
            "Países Bajos": "Europa: UE - Países Bajos",
            "Reino Unido": "Europa: UE - Reino Unido",
            "RESTO DE EUROPA": "Europa: otros",
            "Rusia": "Europa: otros - Rusia",
            "RESTO DEL MUNDO": "Resto del mundo: total",
        },
    },
    "m_sect_val": {
        "cols": "C:ZZZ",
        "currency": "USD",
        "unit": "Millones",
        "old_colnames": [
            "TOTAL IMPORTACIONES FOB ",
            "TOTAL IMPORTACIONES CIF ",
            "TOTAL IMPORTACIONES CIF SIN PETRÓLEO, DESTILADOS Y ENERGÍA ELÉCTRICA",
            "CONSUMO",
            "Alimentos y bebidas",
            "Automotores y otros de transporte",
            "Duraderos",
            "Otros de consumo",
            "CAPITAL",
            "Maquinaria y equipos",
            "Público",
            "Privado",
            "Equipos de transporte",
            "Público",
            "Privado",
            "INTERMEDIOS ",
            "Petróleo y destilados ",
            "Energía eléctrica",
            "Intermedios sin petróleo, destilados y energía eléctrica",
            "Alimentos y bebidas",
            "Piezas y accesorios de transporte",
            "Otros insumos intermedios",
            "Suministros industriales básicos",
            "Suministros industriales elaborados",
            "Resto",
        ],
        "new_colnames": [
            "Total importaciones: FOB",
            "Total importaciones: CIF ",
            "Total importaciones: CIF sin petróleo y energía eléct.",
            "Consumo: total",
            "Consumo: alimentos y bebidas",
            "Consumo: automotores",
            "Consumo: duraderos",
            "Consumo: otros",
            "Capital: total",
            "Capital: maquinaria y equipos",
            "Capital: maquinaria y equipos - público",
            "Capital: maquinaria y equipos - privado",
            "Capital: equipos de transporte",
            "Capital: equipos de transporte - público",
            "Capital: equipos de transporte - privado",
            "Intermedios: total",
            "Intermedios: petróleo y destilados",
            "Intermedios: energía eléctrica",
            "Intermedios: total sin petróleo y energía eléctrica",
            "Intermedios: alimentos y bebidas",
            "Intermedios: piezas de transporte",
            "Intermedios: otros",
            "Intermedios: otros - industriales básicos",
            "Intermedios: otros - industriales elaborados",
            "Intermedios: otros - resto",
        ],
    },
    "m_sect_vol": {
        "cols": "B:ZZZ",
        "currency": "-",
        "unit": "2005=100",
        "colnames": {
            "TOTAL IMPORTACIONES": "Total importaciones",
            "CONSUMO": "Consumo: total",
            "ALIMENTOS Y BEBIDAS PARA LOS HOGARES": "Consumo: alimentos y bebidas",
            "AUTOMOTORES Y OTROS DE TRANSPORTE": "Consumo: automotores",
            "CONSUMO DURADERO": "Consumo: duraderos",
            "OTROS DE CONSUMO": "Consumo: otros",
            "CAPITAL": "Capital: total",
            "INTERMEDIOS": "Intermedios: total",
            "PETROLEO Y DESTILADOS": "Intermedios: petróleo",
            "INTERMEDIOS SIN PETROLEO, DESTILADOS Y ENERGIA ELECTRICA": "Intermedios: total sin petróleo y energía eléctrica",
            "ALIMENTOS Y BEBIDAS PARA LA INDUSTRIA": "Intermedios: alimentos y bebidas",
            "PIEZAS Y ACCESORIOS DE TRANSPORTE": "Intermedios: transporte",
            "OTROS INSUMOS INTERMEDIOS": "Intermedios: otros",
        },
    },
    "m_sect_pri": {
        "cols": "B:ZZZ",
        "currency": "USD",
        "unit": "2005=100",
        "colnames": {
            "TOTAL IMPORTACIONES": "Total importaciones",
            "CONSUMO": "Consumo: total",
            "ALIMENTOS Y BEBIDAS PARA LOS HOGARES": "Consumo: alimentos y bebidas",
            "AUTOMOTORES Y OTROS DE TRANSPORTE": "Consumo: automotores",
            "CONSUMO DURADERO": "Consumo: duraderos",
            "OTROS DE CONSUMO": "Consumo: otros",
            "CAPITAL": "Capital: total",
            "INTERMEDIOS": "Intermedios: total",
            "PETROLEO Y DESTILADOS": "Intermedios: petróleo",
            "INTERMEDIOS SIN PETROLEO, DESTILADOS Y ENERGIA ELECTRICA": "Intermedios: total sin petróleo y energía eléctrica",
            "ALIMENTOS Y BEBIDAS PARA LA INDUSTRIA": "Intermedios: alimentos y bebidas",
            "PIEZAS Y ACCESORIOS DE TRANSPORTE": "Intermedios: transporte",
            "OTROS INSUMOS INTERMEDIOS": "Intermedios: otros",
        },
    },
    "m_orig_val": {
        "cols": "B:ZZZ",
        "currency": "USD",
        "unit": "Millones",
        "colnames": {
            "TOTAL IMPORTACIONES CIF ": "Total importaciones",
            "AMERICA": "América: total",
            "ALADI 2/": "América: ALADI",
            "Argentina": "América: Argentina",
            "Brasil": "América: Brasil",
            "Paraguay": "América: Paraguay",
            "Sub-total MERCOSUR (4 PAISES)": "América: MERCOSUR 4 países",
            "Venezuela": "América: Venezuela",
            "Sub-total MERCOSUR (5 PAISES)": "América: MERCOSUR 5 países",
            "Bolivia": "América: Bolivia",
            "Chile": "América: Chile",
            "México": "América: México",
            "Otros de Aladi": "América: otros ALADI",
            "CANADA": "América: Canadá",
            "ESTADOS UNIDOS": "América: Estados Unidos",
            "RESTO DE AMERICA": "América: otros",
            "EUROPA": "Europa: total",
            "U.E. (UNION EUROPEA)": "Europa: Unión Europea - total",
            "Alemania": "Europa: UE - Alemania",
            "España": "Europa: UE - España",
            "Francia": "Europa: UE - Francia",
            "Italia": "Europa: UE - Italia",
            "Países Bajos": "Europa: UE - Países Bajos",
            "Reino Unido": "Europa: UE - Reino Unido",
            "Otros de la U.E.": "Europa: UE - otros",
            "AELC (EFTA)1/": "Europa: EFTA",
            "RESTO DE EUROPA": "Europa: otros",
            "Rusia": "Europa: otros - Rusia",
            "RESTO DEL MUNDO": "Resto del mundo: total",
            "AFRICA": "Resto del mundo: África",
            "ASIA (excl. M. Oriente)": "Resto del mundo: Asia - total",
            "China (Continental)": "Resto del mundo: Asia - China",
            "Corea del Sur": "Resto del mundo: Asia - Corea del Sur",
            "Taiwán": "Resto del mundo: Asia - Taiwán",
            "Hong Kong": "Resto del mundo: Asia - Hong Kong",
            "Japón": "Resto del mundo: Asia - Japón",
            "Otros de Asia": "Resto del mundo: Asia - otros",
            "MEDIO ORIENTE": "Resto del mundo: Medio Oriente - total",
            "Arabia": "Resto del mundo: Medio Oriente - Arabia",
            "Irán": "Resto del mundo: Medio Oriente - Irán",
            "Israel": "Resto del mundo: Medio Oriente - Israel",
            "Otros del Medio Oriente": "Resto del mundo: Medio Oriente - otros",
            "OTROS PAISES": "Resto del mundo: otros",
        },
    },
    "m_orig_vol": {
        "cols": "B:ZZZ",
        "currency": "-",
        "unit": "2005=100",
        "colnames": {
            "TOTAL IMPORTACIONES": "Total importaciones",
            "AMERICA": "América: total",
            "ALADI 1/": "América: ALADI",
            "Argentina": "América: Argentina",
            "Brasil": "América: Brasil",
            "Paraguay": "América: Paraguay",
            "Sub-total MERCOSUR (4 PAISES)": "América: MERCOSUR 4 países",
            "Venezuela": "América: Venezuela",
            "SUB-TOTAL  MERCOSUR (5 PAISES)": "América: MERCOSUR 5 países",
            "Chile": "América: Chile",
            "México": "América: México",
            "CANADA": "América: Canadá",
            "ESTADOS UNIDOS": "América: Estados Unidos",
            "EUROPA": "Europa: total",
            "U.E. (UNION EUROPEA)": "Europa: Unión Europea - total",
            "Alemania": "Europa: UE - Alemania",
            "España": "Europa: UE - España",
            "Francia": "Europa: UE - Francia",
            "Italia": "Europa: UE - Italia",
            "Países Bajos": "Europa: UE - Países Bajos",
            "Reino Unido": "Europa: UE - Reino Unido",
            "RUSIA": "Europa: Rusia",
            "RESTO DEL MUNDO": "Resto del mundo: total",
            "China (Continental)": "Resto del mundo: China",
        },
    },
    "m_orig_pri": {
        "cols": "B:ZZZ",
        "currency": "USD",
        "unit": "2005=100",
        "colnames": {
            "TOTAL IMPORTACIONES": "Total importaciones",
            "AMERICA": "América: total",
            "ALADI 1/": "América: ALADI",
            "Argentina": "América: Argentina",
            "Brasil": "América: Brasil",
            "Paraguay": "América: Paraguay",
            "Sub-total MERCOSUR (4 PAISES)": "América: MERCOSUR 4 países",
            "Venezuela": "América: Venezuela",
            "SUB-TOTAL  MERCOSUR (5 PAISES)": "América: MERCOSUR 5 países",
            "Chile": "América: Chile",
            "México": "América: México",
            "CANADA": "América: Canadá",
            "ESTADOS UNIDOS": "América: Estados Unidos",
            "EUROPA": "Europa: total",
            "U.E. (UNION EUROPEA)": "Europa: Unión Europea - total",
            "Alemania": "Europa: UE - Alemania",
            "España": "Europa: UE - España",
            "Francia": "Europa: UE - Francia",
            "Italia": "Europa: UE - Italia",
            "Países Bajos": "Europa: UE - Países Bajos",
            "Reino Unido": "Europa: UE - Reino Unido",
            "RUSIA": "Europa: Rusia",
            "RESTO DEL MUNDO": "Resto del mundo: total",
            "China (Continental)": "Resto del mundo: China",
        },
    },
}
fiscal_sheets = {
    "nfps": {
        "sheet": "Sector Público No Monetario",
        "colnames": [
            "Ingresos: SPNF",
            "Ingresos: Gobierno central",
            "Ingresos: DGI",
            "Ingresos: IRP",
            "Ingresos: Comercio ext.",
            "Ingresos: Otros",
            "Ingresos: BPS",
            "Ingresos: Res. primario corriente EEPP",
            "Egresos: Primarios SPNF",
            "Egresos: Primarios corrientes GC-BPS",
            "Egresos: Remuneraciones",
            "Egresos: No personales",
            "Egresos: Pasividades",
            "Egresos: Transferencias",
            "Egresos: Inversiones",
            "Resultado: Primario intendencias",
            "Resultado: Primario BSE",
            "Resultado: Primario SPNF",
            "Intereses: Totales",
            "Intereses: GC-BPS",
            "Intereses: EEPP",
            "Intereses: Intendencias",
            "Intereses: BSE",
            "Resultado: Global SPNF",
        ],
    },
    "gps": {
        "sheet": "Sector Público Consolidado",
        "colnames": [
            "Resultado: Primario SPNF",
            "Intereses: SPNF",
            "Resultado: Global SPNF",
            "Resultado: Primario BCU",
            "Intereses: BCU",
            "Resultado: Global BCU",
            "Resultado: Primario SPC",
            "Resultado: Global SPC",
        ],
    },
    "cg-bps": {
        "sheet": "Gobierno Central - BPS",
        "colnames": [
            "Ingresos: GC-BPS",
            "Ingresos: GC",
            "Ingresos: Comercio ext.",
            "Ingresos: DGI",
            "Ingresos: DGI bruto",
            "Ingresos: DGI CDI",
            "Ingresos: Loterías",
            "Ingresos: Venta energía",
            "Ingresos: TGN/otros",
            "Ingresos: FIMTOP",
            "Ingresos: Aportes EEPP",
            "Ingresos: IRP",
            "Ingresos: Rec. Lib. Disp",
            "Ingresos: BPS neto",
            "Ingresos: BPS bruto",
            "Ingresos: FSS - Cincuentones",
            "Ingresos: BPS CDI",
            "Ingresos: BPS otros",
            "Egresos: GC-BPS",
            "Egresos: Remuneraciones",
            "Egresos: Remuneraciones adm. central",
            "Egresos: Remuneraciones org. docentes",
            "Egresos: Remuneraciones retenc./otros",
            "Egresos: Remuneraciones BPS",
            "Egresos: Pasividades",
            "Egresos: Pasividades Caja Policial",
            "Egresos: Pasividades Caja Militar",
            "Egresos: Pasividades BPS",
            "Egresos: No personales",
            "Egresos: No personales adm. central",
            "Egresos: No personales org. docentes",
            "Egresos: No personales suministros",
            "Egresos: No personales plan emergencia",
            "Egresos: No personales BPS",
            "Egresos: Transferencias",
            "Egresos: Transferencias GC",
            "Egresos: Transferencias GC Entes",
            "Egresos: Transferencias GC deuda",
            "Egresos: Transferencias GC otros org.",
            "Egresos: Transferencias GC rentas afectadas",
            "Egresos: Transferencias BPS",
            "Egresos: Transferencias BPS enfermedad",
            "Egresos: Transferencias BPS AFAM y otras prestaciones",
            "Egresos: Transferencias BPS desempleo",
            "Egresos: Transferencias BPS 2",
            "Egresos: Transferencias BPS -IRP/IRPF",
            "Egresos: Transferencias BPS AFAP",
            "Egresos: Transferencias BPS otros",
            "Egresos: Transferencias otros",
            "Egresos: Inversión",
            "Egresos: Inversión MTOP",
            "Egresos: Inversión MVOTMA",
            "Egresos: Inversión Presidencia",
            "Egresos: Inversión org. docentes",
            "Egresos: Inversión resto",
            "Intereses: Total",
            "Intereses: GC",
            "Intereses: FSS - Cincuentones",
            "Resultado: Global GC-BPS",
        ],
    },
    "pe": {
        "sheet": "Empresas Públicas Consolidado",
        "colnames": [
            "Ingresos",
            "Ingresos: Venta bienes y servicios",
            "Ingresos: Otros",
            "Ingresos: Transferencias GC",
            "Egresos",
            "Egresos: Corrientes",
            "Egresos: Remuneraciones",
            "Egresos: Compras bienes y servicios",
            "Intereses",
            "Egresos: DGI",
            "Egresos: BPS",
            "Egresos: No corrientes",
            "Egresos: Inversiones",
            "Egresos: Dividendo",
            "Resultado: Global",
        ],
    },
    "ancap": {
        "sheet": "ANCAP",
        "colnames": [
            "Ingresos",
            "Ingresos: Venta bienes y servicios",
            "Ingresos: Otros",
            "Ingresos: Transferencias GC",
            "Egresos",
            "Egresos: Corrientes",
            "Egresos: Remuneraciones",
            "Egresos: Compras bienes y servicios",
            "Intereses",
            "Egresos: DGI",
            "Egresos: BPS",
            "Egresos: No corrientes",
            "Egresos: Inversiones",
            "Egresos: Var. stock petróleo",
            "Egresos: Otros",
            "Egresos: Dividendo",
            "Resultado: Global",
        ],
    },
    "antel": {
        "sheet": "ANTEL",
        "colnames": [
            "Ingresos",
            "Ingresos: Venta bienes y servicios",
            "Ingresos: Otros",
            "Ingresos: Transferencias GC",
            "Egresos",
            "Egresos: Corrientes",
            "Egresos: Remuneraciones",
            "Egresos: Compras bienes y servicios",
            "Intereses",
            "Egresos: DGI",
            "Egresos: BPS",
            "Egresos: No corrientes",
            "Egresos: Inversiones",
            "Egresos: Dividendo",
            "Resultado: Global",
        ],
    },
    "ose": {
        "sheet": "OSE",
        "colnames": [
            "Ingresos",
            "Ingresos: Venta bienes y servicios",
            "Ingresos: Otros",
            "Ingresos: Transferencias GC",
            "Egresos",
            "Egresos: Corrientes",
            "Egresos: Remuneraciones",
            "Egresos: Compras bienes y servicios",
            "Intereses",
            "Egresos: DGI",
            "Egresos: BPS",
            "Egresos: No corrientes",
            "Egresos: Inversiones",
            "Egresos: Dividendo",
            "Resultado: Global",
        ],
    },
    "ute": {
        "sheet": "UTE",
        "colnames": [
            "Ingresos",
            "Ingresos: Venta bienes y servicios",
            "Ingresos: Otros",
            "Ingresos: Transferencias GC",
            "Egresos",
            "Egresos: Corrientes",
            "Egresos: Remuneraciones",
            "Egresos: Compras bienes y servicios",
            "Intereses",
            "Egresos: DGI",
            "Egresos: BPS",
            "Egresos: No corrientes",
            "Egresos: Inversiones",
            "Egresos: Dividendo",
            "Resultado: Global",
        ],
    },
}
reserves_cols = [
    "Saldo al inicio del período",
    "1. Compras netas de moneda extranjera",
    "1.1. Compras netas en el mercado",
    "1.2. Integración en dólares de valores del BCU",
    "1.3. Prefinanciación de exportaciones",
    "1.4. Cancelación de contratos forward",
    "1.5. Gobierno Central",
    "1.5.1. Utilizaciones de préstamos internacionales",
    "1.5.2. Otras compras netas al Gobierno Central",
    "1.6. Otros",
    "2. Depósitos del Sistema Bancario en el Banco Central",
    "2.1. Banca pública",
    "2.2. Banca privada",
    "3. Otros Depósitos en el Banco Central",
    "3.1. Depósitos de otras empresas de intermediación fin.",
    "3.2. Depósitos de casas de cambio y otras inst.",
    "3.3. Depósitos de empresas públicas y gob. dptales.",
    "4. Divisas de exportación a liquidar",
    "5. Obligaciones netas en ME con gob. central",
    "5.1. Colocación neta de bonos y letras",
    "5.1.1. Colocación bruta",
    "5.1.2. Amortizaciones",
    "5.1.3. Intereses y comisiones",
    "5.2. Otras obligaciones netas en ME",
    "5.2.1. Desembolsos de préstamos internacionales",
    "5.2.2. Servicio neto de préstamos internacionales",
    "5.3.3. Utilizaciones de préstamos internacionales",
    "5.4.5. Aporte de entes a cuenta de resultados",
    "5.4.6.  Compras de moneda extranjera",
    "5.4.7. Giros hacia y desde el BROU",
    "5.4.8. Integración en USD de títulos en UI y pesos-neto",
    "5.4.9. Otros",
    "6. Intereses netos",
    "6.1.Intereses pagados sobre depósitos del sist. fin.",
    "6.2. Intereses cobrados sobre fondos en el exterior",
    "6.3. Otros intereses y comisiones netos",
    "7. Otros",
    "7.1.  Préstamos y financiamientos EEPP",
    "7.2. Cuentas con organismos internacionales",
    "7.3. Fondos administrados",
    "7.4. Diferencias de arbitraje",
    "7.5. Diferencias de cotización e intereses devengados",
    "7.6. Depósitos especiales Clearstream Banking",
    "7.7. Solicitudes de giro al exterior en trámite",
    "7.8. Otros",
    "Variación total del período - 1+2+3+4+5+6+7",
    "Saldo al final del período",
]

cpi_details = {
    "2010_base": {
        "Pan y cereales": {"Tradable": True, "Core": True},
        "Carne": {"Tradable": True, "Core": False},
        "Pescado": {"Tradable": True, "Core": True},
        "Leche, queso y huevos": {"Tradable": True, "Core": True},
        "Aceites y grasas": {"Tradable": True, "Core": True},
        "Frutas": {"Tradable": True, "Core": False},
        "Legumbres y Hortalizas": {"Tradable": True, "Core": False},
        "Azúcar, mermelada, miel, chocolate y dulces de azúcar": {"Tradable": True, "Core": True},
        "Productos alimenticios n.e.p.": {"Tradable": True, "Core": True},
        "Bebidas no alcohólicas": {"Tradable": True, "Core": True},
        "Bebidas alcohólicas": {"Tradable": True, "Core": True},
        "Tabaco": {"Tradable": True, "Core": False},
        "PRENDAS DE VESTIR Y CALZADO": {"Tradable": True, "Core": True},
        "Alquileres efectivos del alojamiento": {"Tradable": False, "Core": True},
        "Conservación y reparación de la vivienda": {"Tradable": False, "Core": True},
        "Suministro de agua y servicios diversos relacionados con la vivienda": {
            "Tradable": False,
            "Core": False,
        },
        "Electricidad, gas y otros combustibles": {"Tradable": False, "Core": False},
        "Muebles y accesorios, alfombras y otros materiales para pisos": {
            "Tradable": True,
            "Core": True,
        },
        "Productos textiles para el hogar": {"Tradable": True, "Core": True},
        "Artefactos para el hogar grandes, eléctricos o no": {"Tradable": True, "Core": True},
        "Reparación de artefactos para el hogar": {"Tradable": False, "Core": True},
        "Artículos de vidrio y cristal, vajilla y utensilios para el hogar": {
            "Tradable": True,
            "Core": True,
        },
        "Herramientas y equipo para el hogar y el jardín": {"Tradable": True, "Core": True},
        "Bienes para el hogar no duraderos": {"Tradable": True, "Core": True},
        "Servicios domésticos y para el hogar": {"Tradable": False, "Core": True},
        "Productos, artefactos y equipo médicos": {"Tradable": True, "Core": True},
        "Servicios para pacientes externos": {"Tradable": False, "Core": False},
        "Servicios de hospital": {"Tradable": False, "Core": False},
        "Servicios médicos mutuales y colectivos": {"Tradable": False, "Core": False},
        "Adquisición de vehículos": {"Tradable": True, "Core": True},
        "Funcionamiento de equipo de transporte personal": {"Tradable": False, "Core": True},
        "Servicios de transporte": {"Tradable": False, "Core": False},
        "Servicios postales": {"Tradable": False, "Core": False},
        "Equipo telefónico y de facsímile": {"Tradable": True, "Core": True},
        "Servicios telefónicos y de facsímile": {"Tradable": False, "Core": False},
        "Equipo audiovisual, fotográfico y de procesamiento de información": {
            "Tradable": True,
            "Core": True,
        },
        "Otros artículos y equipo para recreación, jardines y animales domésticos": {
            "Tradable": True,
            "Core": True,
        },
        "Servicios de recreación y culturales": {"Tradable": False, "Core": False},
        "Periódicos, libros y papeles y útiles de oficina": {"Tradable": True, "Core": True},
        "Paquetes turísticos": {"Tradable": True, "Core": True},
        "EDUCACIÓN": {"Tradable": False, "Core": True},
        "Servicios de alojamiento": {"Tradable": False, "Core": True},
        "Servicios de suministro de comidas por contrato": {"Tradable": False, "Core": True},
        "Cuidado personal": {"Tradable": False, "Core": True},
        "Efectos personales n.e.p.": {"Tradable": False, "Core": True},
        "Seguros": {"Tradable": False, "Core": True},
        "Otros servicios n.e.p.": {"Tradable": False, "Core": True},
    },
    "1997_base": {
        "    Panes Y Cereales": {"Tradable": True, "Core": True},
        "    Carnes Y Derivados": {"Tradable": True, "Core": False},
        "    Lacteos Y Huevos": {"Tradable": True, "Core": True},
        "    Aceites Y Grasas": {"Tradable": True, "Core": True},
        "    Frutas": {"Tradable": True, "Core": False},
        "    Verduras, Legumbres Y Tuberculos": {"Tradable": True, "Core": False},
        "    Azucar, Cafe, Te, Yerba Y Cacao": {"Tradable": True, "Core": True},
        "    Otros Alimentos": {"Tradable": True, "Core": True},
        "    Bebidas No Alcoholicas": {"Tradable": True, "Core": True},
        "    Bebidas Alcoholicas": {"Tradable": True, "Core": True},
        "  Comidas Semielaboradas, Elaboradas": {"Tradable": True, "Core": True},
        "Vestimenta Y Calzado": {"Tradable": True, "Core": True},
        "  Alquileres, Mantenimiento, Gastos Comunes": {"Tradable": False, "Core": True},
        "  Combustible, Alumbrado Y Agua Corriente": {"Tradable": False, "Core": False},
        "  Muebles, Acc. Fijos Y Reparaciones": {"Tradable": True, "Core": True},
        "  Tejidos Para El Hogar Y Otros Accesorios": {"Tradable": True, "Core": True},
        "  Artefactos, Electrodomesticos, Cristaleria": {"Tradable": True, "Core": True},
        "  Servicios Para El Hogar Exc. Servicio Domestico": {"Tradable": False, "Core": True},
        "  Servicio Domestico Y Reparaciones ": {"Tradable": False, "Core": True},
        "  Productos Medicinales Y Farmaceuticos": {"Tradable": True, "Core": True},
        "  Aparatos Y Equipos Terapeuticos": {"Tradable": True, "Core": True},
        "  Servicios Medicos": {"Tradable": False, "Core": False},
        "  Equipo De Transporte Personal": {"Tradable": True, "Core": True},
        "  Mantenimiento Y Utilizacion De Equipo Tpte.": {"Tradable": False, "Core": True},
        "  Servicios De Transporte": {"Tradable": False, "Core": False},
        "  Comunicaciones": {"Tradable": False, "Core": False},
        "  Equipos Accesorios Y Reparaciones": {"Tradable": True, "Core": True},
        "  Servicios De Esparcimiento": {"Tradable": False, "Core": True},
        "  Libros, Periodicos Y Revistas": {"Tradable": True, "Core": True},
        "  Turismo Y Alojamiento": {"Tradable": True, "Core": True},
        "Enseñanza": {"Tradable": False, "Core": False},
        "  Cuidados Y Efectos Personales": {"Tradable": False, "Core": True},
        "  Tabaco": {"Tradable": True, "Core": False},
        "  Servicios Diversos": {"Tradable": False, "Core": True},
    },
    "1997_weights": [
        "PAN Y CEREALES",
        "CARNES Y DERIVADOS",
        "LÁCTEOS Y HUEVOS",
        "ACEITES Y GRASAS",
        "FRUTAS",
        "VERDURAS, LEGUMBRES Y TUBÉRCULOS",
        "AZÚCAR, CAFÉ, TÉ, YERBA MATE Y CACAO",
        "OTROS ALIMENTOS",
        "BEBIDAS NO ALCOHÓLICAS",
        "BEBIDAS ALCOHÓLICAS",
        "COMIDAS SEMIELABORADAS, ELABORADAS Y FUERA DEL HOGAR",
        "VESTIMENTA Y CALZADO",
        "ALQUILER, MANTENIMIENTO, GASTOS COMUNES E IMPUESTOS",
        "COMBUSTIBLE, ALUMBRADO Y AGUA CORRIENTE",
        "MUEBLES, ACCESORIOS FIJOS Y REPARACIONES",
        "TEJIDOS PARA EL HOGAR Y OTROS ACCESORIOS",
        "ELECTRODOMÉSTICOS, CRISTALERÍA, VAJILLA Y UTENSILIOS DOMÉSTICOS",
        "SERVICIOS PARA EL HOGAR (EXCEPTO SERVICIO DOMÉSTICO)",
        "SERVICIO DOMÉSTICO Y REPARACIONES DEL HOGAR",
        "PRODUCTOS MEDICINALES Y FARMACÉUTICOS",
        "APARATOS Y EQUIPOS TERAPÉUTICOS",
        "SERVICIOS MÉDICOS",
        "EQUIPO DE TRANSPORTE PERSONAL",
        "MANTENIMIENTO Y UTILIZACIÓN DE EQUIPO DE TRANSPORTE PERSONAL",
        "SERVICIOS DE TRANSPORTE",
        "COMUNICACIONES",
        "EQUIPOS, ACCESORIOS Y REPARACIONES",
        "SERVICIO DE ESPARCIMIENTO",
        "LIBROS, PERIÓDICOS Y REVISTAS",
        "TURISMO Y ALOJAMIENTO",
        "ENSEÑANZA",
        "CUIDADOS Y EFECTOS PERSONALES",
        "TABACO",
        "SERVICIOS DIVERSOS",
    ],
}
taxes_columns = [
    "IRAE - Rentas de Actividades Económicas",
    "IMEBA - Enajenación de Bienes Agropecuarios",
    "IRPF Cat I - Renta de las Personas Físicas",
    "IRPF Cat II - Rentas de las Personas Físicas",
    "IRNR - Rentas de No Residentes",
    "IASS - Asistencia a la Seguridad Social",
    "ISAFI - SA Financieras de Inversión",
    "IP Personas Jurídicas - Patrimonio",
    "IP Explotaciones Agropecuarias - Patrimonio",
    "IP Sobretasa - IP",
    "ICOSA - Control de las SA",
    "IP Personas Físicas - Patrimonio",
    "ITP - Transferencias Patrimoniales",
    "ITP Adicional - Transferencias Patrimoniales",
    "IVA - Valor Agregado",
    "IVA Mínimo - Pequeña Empresa",
    "IMESI - Específico Interno",
    "IMEBA Ad. MEVIR - Enajernación de Bienes Agropecuarios",
    "IMEBA Ad. INIA - Enajernación de Bienes Agropecuarios",
    "Impuesto a los Ingresos de las Compañías de Seguros",
    "FIS - Fondo de Inspección Sanitaria",
    "IRIC - Rentas de Industria Comercio",
    "COFIS - Contribución al Financiamiento Seguridad Social",
    "IMESSA - Específico a los Servicios de Salud",
    "Impuesto a las Comisiones",
    "Impuesto a las Ventas Forzadas",
    "Impuesto a las Tarjetas de Crédito",
    "ITEL - Telecomunicaciones",
    "Impuesto a los Ingresos le Los Organizadores de Sorteos",
    "ICOME - Compra de Moneda Extranjera",
    "Impuesto a la Compra - Venta de Bienes Remate Público",
    "Impuesto a las Cesiones de Derechos sobre Deportistas",
    "IMABA - Activos de las Empresas Bancarias",
    "ICOSIFI - Control del Sistema Financiero",
    "IRA - Rentas Agropecuarias",
    "IMAGRO - Actividades Agropecuaria",
    "Impuesto de Educación Primaria",
    "Recaudación Total de la DGI",
]
investing_headers = {
    "User-Agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_6) "
    "AppleWebKit/537.36 (KHTML, like Gecko) "
    "Chrome/86.0.4240.111 Safari/537.36",
    "X-Requested-With": "XMLHttpRequest",
    "Accept": "text/html",
    "Accept-Encoding": "gzip, deflate",
    "Connection": "keep-alive",
}

bop_cols = [
    "Cuenta Corriente",
    "Bienes y Servicios",
    "Bienes",
    "Bienes - Crédito",
    "Bienes - Crédito - Mercancías generales",
    "Bienes - Crédito - Mercancías generales - Compraventa",
    "Bienes - Crédito - Exp netas de bienes en compra venta",
    "Bienes - Crédito - Exp netas - Compras por Compraventa",
    "Bienes - Crédito - Exp netas - Ventas por compraventa",
    "Bienes - Crédito - Exp netas - Soc. Compraventa",
    "Bienes - Débito",
    "Bienes - Débito - Mercancías generales",
    "Bienes - Débito - Mercancías generales - Compraventa",
    "Servicios",
    "Servicios - Crédito",
    "Servicios - Crédito - Transportes",
    "Servicios - Crédito - Viajes",
    "Servicios - Crédito - Otros Servicios",
    "Servicios - Crédito - Otros - Compraventa",
    "Servicios - Débito",
    "Servicios - Débito - Transportes",
    "Servicios - Débito - Viajes",
    "Servicios - Débito - Otros Servicios",
    "Servicios - Débito - Otros -  Compraventa",
    "Ingreso Primario",
    "Ingreso Primario - Crédito",
    "Ingreso Primario - Crédito - Institucional, Sector Público",
    "Ingreso Primario - Crédito - Institucional, Sector Privado",
    "Ingreso Primario - Crédito - Inst, Priv - Soc. Compraventa",
    "Ingreso Primario - Crédito - Funcional, Inversión Directa",
    "Ingreso Primario - Crédito - Funcional, Inversión de Cartera",
    "Ingreso Primario - Crédito - Funcional, Otra Inversión",
    "Ingreso Primario - Crédito - Funcional, Activos de Reserva",
    "Ingreso Primario - Débito",
    "Ingreso Primario - Débito - Institucional, Sector Público",
    "Ingreso Primario - Débito - Institucional, Sector Privado",
    "Ingreso Primario - Débito - Inst, Priv - Soc. Compraventa",
    "Ingreso Primario - Débito - Funcional, Inversión Directa",
    "Ingreso Primario - Débito - Funcional, Inversión de Cartera ",
    "Ingreso Primario - Débito - Funcional, Otra Inversión",
    "Ingreso Secundario",
    "Ingreso Secundario - Crédito",
    "Ingreso Secundario - Débito",
    "Cuenta Capital",
    "Cuenta Capital - Crédito",
    "Cuenta Capital - Débito",
    "Saldo de las cuentas corriente y de capital",
    "Cuenta Financiera",
    "Inversión directa",
    "Inversión directa - Adquisición neta de activos financieros",
    "Inversión directa - Activos - Institucional, Sector Público",
    "Inversión directa - Activos - Institucional, Sector Privado",
    "Inversión directa - Activos - Inst, Priv - Soc. Compraventa",
    "Inversión directa - Activos - Instrumento, Part Capital",
    "Inversión directa - Activos - Instrumento, Deuda",
    "Inversión directa - Pasivos netos incurridos",
    "Inversión directa - Pasivos - Institucional, Sector Público",
    "Inversión directa - Pasivos - Institucional, Sector Privado",
    "Inversión directa - Pasivos - Inst, Priv - Soc. Compraventa",
    "Inversión directa - Pasivos - Instrumento, Part Capital",
    "Inversión directa - Pasivos - Instrumento, Deuda",
    "Inversión de cartera",
    "Inversión de cartera - Adquisición neta de activos fin",
    "Inversión de cartera - Activos - Inst, Sector Público",
    "Inversión de cartera - Activos - Inst, Sector Privado",
    "Inversión de cartera - Activos - Inst, Privado - Soc Comprav",
    "Inversión de cartera - Activos - Instrumento, Part Capital",
    "Inversión de cartera - Activos - Instrumento, Deuda",
    "Inversión de cartera - Pasivos netos incurridos",
    "Inversión de cartera - Pasivos - Inst, Sector Público",
    "Inversión de cartera - Pasivos - Inst, Sector Privado",
    "Inversión de cartera - Pasivos - Inst Priv - Soc Compraventa",
    "Inversión de cartera - Pasivos - Instrumento, Part Capital",
    "Inversión de cartera - Pasivos - Instrumento, Deuda",
    "Derivados financieros - distintos de reservas",
    "Derivados financieros - Sector Público neto",
    "Derivados financieros - Sector Privado neto",
    "Derivados financieros - Privado, Soc. Compraventa",
    "Otra inversión",
    "Otra inversión - Adquisición neta de activos financieros",
    "Otra inversión - Activos - Institucional, Sector Público",
    "Otra inversión - Activos - Institucional, Sector Privado",
    "Otra inversión - Activos - Inst, Priv - Soc. Compraventa",
    "Otra inversión - Activos - Instrumento, Moneda y Depósitos",
    "Otra inversión - Activos - Instrumento, M&D - Banco Central",
    "Otra inversión - Activos - Instrumento, M&D - Bancos",
    "Otra inversión - Activos - Instrumento, M&D - Gob Gral",
    "Otra inversión - Activos - Instrumento, M&D - Otros Sectores",
    "Otra inversión - Activos - Instrumento, Préstamos",
    "Otra inversión - Activos - Instrumento, Préstamos - BC",
    "Otra inversión - Activos - Instrumento, Préstamos - Bancos",
    "Otra inversión - Activos - Instrumento, Préstamos - Gob Gral",
    "Otra inversión - Activos - Instrumento, Préstamos - Otros",
    "Otra inversión - Activos - Instrumento, Créditos y anticipos",
    "Otra inversión - Activos - Instrumento, Créditos - Gob Gral",
    "Otra inversión - Activos - Instrumento, Créditos - Otros",
    "Otra inversión - Activos - Instrumento, Otras cuentas",
    "Otra inversión - Activos - Instrumento, Otras - BC",
    "Otra inversión - Activos - Instrumento, Otras - Bancos",
    "Otra inversión - Activos - Instrumento, Otras - Gob Gral",
    "Otra inversión - Activos - Instrumento, Otras - Otros",
    "Otra inversión - Pasivos netos incurridos",
    "Otra inversión - Pasivos - Institucional, Sector Público",
    "Otra inversión - Pasivos - Institucional, Sector Privado",
    "Otra inversión - Pasivos - Inst, Priv - Soc. Compraventa",
    "Otra inversión - Pasivos - Instrumento, Moneda y Depósitos",
    "Otra inversión - Pasivos - Instrumento, M&D - Banco Central",
    "Otra inversión - Pasivos - Instrumento, M&D - Bancos",
    "Otra inversión - Pasivos - Instrumento, M&D - Gob Gral",
    "Otra inversión - Pasivos - Instrumento, M&D - Otros Sectores",
    "Otra inversión - Pasivos - Instrumento, Préstamos",
    "Otra inversión - Pasivos - Instrumento, Préstamos - BC",
    "Otra inversión - Pasivos - Instrumento, Préstamos - Bancos",
    "Otra inversión - Pasivos - Instrumento, Préstamos - Gob Gral",
    "Otra inversión - Pasivos - Instrumento, Préstamos - Otros",
    "Otra inversión - Pasivos - Instrumento, Créditos y anticipos",
    "Otra inversión - Pasivos - Instrumento, Créditos - Gob Gral",
    "Otra inversión - Pasivos - Instrumento, Créditos - Otros",
    "Otra inversión - Pasivos - Instrumento, Otras cuentas",
    "Otra inversión - Pasivos - Instrumento, Otras - BC",
    "Otra inversión - Pasivos - Instrumento, Otras - Bancos",
    "Otra inversión - Pasivos - Instrumento, Otras - Gob Gral",
    "Otra inversión - Pasivos - Instrumento, Otras - Otros",
    "Derechos Especiales de Giro",
    "Activos de Reserva BCU",
    "Errores y Omisiones",
]
