# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EnvironmentArgs', 'Environment']

@pulumi.input_type
class EnvironmentArgs:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input['EnvironmentConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Environment resource.
        :param pulumi.Input['EnvironmentConfigArgs'] config: Configuration parameters for this environment  Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels for this environment. The labels map can contain
               no more than 64 entries. Entries of the labels map are UTF8 strings
               that comply with the following restrictions:
               Label keys must be between 1 and 63 characters long and must conform
               to the following regular expression: `a-z?`.
               Label values must be between 0 and 63 characters long and must
               conform to the regular expression `(a-z?)?`.
               No more than 64 labels can be associated with a given environment.
               Both keys and values must be <= 128 bytes in size.
        :param pulumi.Input[str] name: Name of the environment
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: The location or Compute Engine region for the environment.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['EnvironmentConfigArgs']]:
        """
        Configuration parameters for this environment  Structure is documented below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['EnvironmentConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        User-defined labels for this environment. The labels map can contain
        no more than 64 entries. Entries of the labels map are UTF8 strings
        that comply with the following restrictions:
        Label keys must be between 1 and 63 characters long and must conform
        to the following regular expression: `a-z?`.
        Label values must be between 0 and 63 characters long and must
        conform to the regular expression `(a-z?)?`.
        No more than 64 labels can be associated with a given environment.
        Both keys and values must be <= 128 bytes in size.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the environment
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The location or Compute Engine region for the environment.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _EnvironmentState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input['EnvironmentConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Environment resources.
        :param pulumi.Input['EnvironmentConfigArgs'] config: Configuration parameters for this environment  Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels for this environment. The labels map can contain
               no more than 64 entries. Entries of the labels map are UTF8 strings
               that comply with the following restrictions:
               Label keys must be between 1 and 63 characters long and must conform
               to the following regular expression: `a-z?`.
               Label values must be between 0 and 63 characters long and must
               conform to the regular expression `(a-z?)?`.
               No more than 64 labels can be associated with a given environment.
               Both keys and values must be <= 128 bytes in size.
        :param pulumi.Input[str] name: Name of the environment
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: The location or Compute Engine region for the environment.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['EnvironmentConfigArgs']]:
        """
        Configuration parameters for this environment  Structure is documented below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['EnvironmentConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        User-defined labels for this environment. The labels map can contain
        no more than 64 entries. Entries of the labels map are UTF8 strings
        that comply with the following restrictions:
        Label keys must be between 1 and 63 characters long and must conform
        to the following regular expression: `a-z?`.
        Label values must be between 0 and 63 characters long and must
        conform to the regular expression `(a-z?)?`.
        No more than 64 labels can be associated with a given environment.
        Both keys and values must be <= 128 bytes in size.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the environment
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The location or Compute Engine region for the environment.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


class Environment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[pulumi.InputType['EnvironmentConfigArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        An environment for running orchestration tasks.

        Environments run Apache Airflow software on Google infrastructure.

        To get more information about Environments, see:

        * [API documentation](https://cloud.google.com/composer/docs/reference/rest/v1/projects.locations.environments)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/composer/docs)
            * [Configuring Shared VPC for Composer Environments](https://cloud.google.com/composer/docs/how-to/managing/configuring-shared-vpc)
        * [Apache Airflow Documentation](http://airflow.apache.org/)

        > **Warning:** We **STRONGLY** recommend you read the [GCP guides](https://cloud.google.com/composer/docs/how-to)
          as the Environment resource requires a long deployment process and involves several layers of GCP infrastructure,
          including a Kubernetes Engine cluster, Cloud Storage, and Compute networking resources. Due to limitations of the API,
          This provider will not be able to automatically find or manage many of these underlying resources. In particular:
          * It can take up to one hour to create or update an environment resource. In addition, GCP may only detect some
            errors in configuration when they are used (e.g. ~40-50 minutes into the creation process), and is prone to limited
            error reporting. If you encounter confusing or uninformative errors, please verify your configuration is valid
            against GCP Cloud Composer before filing bugs against this provider.
          * **Environments create Google Cloud Storage buckets that do not get cleaned up automatically** on environment
            deletion. [More about Composer's use of Cloud Storage](https://cloud.google.com/composer/docs/concepts/cloud-storage).
          * Please review the [known issues](https://cloud.google.com/composer/docs/known-issues) for Composer if you are having problems.

        ## Example Usage
        ### Basic Usage
        ```python
        import pulumi
        import pulumi_gcp as gcp

        test = gcp.composer.Environment("test", region="us-central1")
        ```
        ### With GKE and Compute Resource Dependencies

        **NOTE** To use custom service accounts, you need to give at least `role/composer.worker` to the service account being used by the GKE Nodes on the Composer project.
        You may need to assign additional roles depending on what the Airflow DAGs will be running.

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_network = gcp.compute.Network("testNetwork", auto_create_subnetworks=False)
        test_subnetwork = gcp.compute.Subnetwork("testSubnetwork",
            ip_cidr_range="10.2.0.0/16",
            region="us-central1",
            network=test_network.id)
        test_account = gcp.service_account.Account("testAccount",
            account_id="composer-env-account",
            display_name="Test Service Account for Composer Environment")
        test_environment = gcp.composer.Environment("testEnvironment",
            region="us-central1",
            config=gcp.composer.EnvironmentConfigArgs(
                node_count=4,
                node_config=gcp.composer.EnvironmentConfigNodeConfigArgs(
                    zone="us-central1-a",
                    machine_type="e2-medium",
                    network=test_network.id,
                    subnetwork=test_subnetwork.id,
                    service_account=test_account.name,
                ),
            ))
        composer_worker = gcp.projects.IAMMember("composer-worker",
            role="roles/composer.worker",
            member=test_account.email.apply(lambda email: f"serviceAccount:{email}"))
        ```
        ### With Software (Airflow) Config
        ```python
        import pulumi
        import pulumi_gcp as gcp

        test = gcp.composer.Environment("test",
            config=gcp.composer.EnvironmentConfigArgs(
                software_config=gcp.composer.EnvironmentConfigSoftwareConfigArgs(
                    airflow_config_overrides={
                        "core-loadExample": "True",
                    },
                    env_variables={
                        "FOO": "bar",
                    },
                    pypi_packages={
                        "numpy": "",
                        "scipy": "==1.1.0",
                    },
                ),
            ),
            region="us-central1")
        ```

        ## Import

        Environment can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:composer/environment:Environment default projects/{{project}}/locations/{{region}}/environments/{{name}}
        ```

        ```sh
         $ pulumi import gcp:composer/environment:Environment default {{project}}/{{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:composer/environment:Environment default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['EnvironmentConfigArgs']] config: Configuration parameters for this environment  Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels for this environment. The labels map can contain
               no more than 64 entries. Entries of the labels map are UTF8 strings
               that comply with the following restrictions:
               Label keys must be between 1 and 63 characters long and must conform
               to the following regular expression: `a-z?`.
               Label values must be between 0 and 63 characters long and must
               conform to the regular expression `(a-z?)?`.
               No more than 64 labels can be associated with a given environment.
               Both keys and values must be <= 128 bytes in size.
        :param pulumi.Input[str] name: Name of the environment
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: The location or Compute Engine region for the environment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[EnvironmentArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An environment for running orchestration tasks.

        Environments run Apache Airflow software on Google infrastructure.

        To get more information about Environments, see:

        * [API documentation](https://cloud.google.com/composer/docs/reference/rest/v1/projects.locations.environments)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/composer/docs)
            * [Configuring Shared VPC for Composer Environments](https://cloud.google.com/composer/docs/how-to/managing/configuring-shared-vpc)
        * [Apache Airflow Documentation](http://airflow.apache.org/)

        > **Warning:** We **STRONGLY** recommend you read the [GCP guides](https://cloud.google.com/composer/docs/how-to)
          as the Environment resource requires a long deployment process and involves several layers of GCP infrastructure,
          including a Kubernetes Engine cluster, Cloud Storage, and Compute networking resources. Due to limitations of the API,
          This provider will not be able to automatically find or manage many of these underlying resources. In particular:
          * It can take up to one hour to create or update an environment resource. In addition, GCP may only detect some
            errors in configuration when they are used (e.g. ~40-50 minutes into the creation process), and is prone to limited
            error reporting. If you encounter confusing or uninformative errors, please verify your configuration is valid
            against GCP Cloud Composer before filing bugs against this provider.
          * **Environments create Google Cloud Storage buckets that do not get cleaned up automatically** on environment
            deletion. [More about Composer's use of Cloud Storage](https://cloud.google.com/composer/docs/concepts/cloud-storage).
          * Please review the [known issues](https://cloud.google.com/composer/docs/known-issues) for Composer if you are having problems.

        ## Example Usage
        ### Basic Usage
        ```python
        import pulumi
        import pulumi_gcp as gcp

        test = gcp.composer.Environment("test", region="us-central1")
        ```
        ### With GKE and Compute Resource Dependencies

        **NOTE** To use custom service accounts, you need to give at least `role/composer.worker` to the service account being used by the GKE Nodes on the Composer project.
        You may need to assign additional roles depending on what the Airflow DAGs will be running.

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_network = gcp.compute.Network("testNetwork", auto_create_subnetworks=False)
        test_subnetwork = gcp.compute.Subnetwork("testSubnetwork",
            ip_cidr_range="10.2.0.0/16",
            region="us-central1",
            network=test_network.id)
        test_account = gcp.service_account.Account("testAccount",
            account_id="composer-env-account",
            display_name="Test Service Account for Composer Environment")
        test_environment = gcp.composer.Environment("testEnvironment",
            region="us-central1",
            config=gcp.composer.EnvironmentConfigArgs(
                node_count=4,
                node_config=gcp.composer.EnvironmentConfigNodeConfigArgs(
                    zone="us-central1-a",
                    machine_type="e2-medium",
                    network=test_network.id,
                    subnetwork=test_subnetwork.id,
                    service_account=test_account.name,
                ),
            ))
        composer_worker = gcp.projects.IAMMember("composer-worker",
            role="roles/composer.worker",
            member=test_account.email.apply(lambda email: f"serviceAccount:{email}"))
        ```
        ### With Software (Airflow) Config
        ```python
        import pulumi
        import pulumi_gcp as gcp

        test = gcp.composer.Environment("test",
            config=gcp.composer.EnvironmentConfigArgs(
                software_config=gcp.composer.EnvironmentConfigSoftwareConfigArgs(
                    airflow_config_overrides={
                        "core-loadExample": "True",
                    },
                    env_variables={
                        "FOO": "bar",
                    },
                    pypi_packages={
                        "numpy": "",
                        "scipy": "==1.1.0",
                    },
                ),
            ),
            region="us-central1")
        ```

        ## Import

        Environment can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:composer/environment:Environment default projects/{{project}}/locations/{{region}}/environments/{{name}}
        ```

        ```sh
         $ pulumi import gcp:composer/environment:Environment default {{project}}/{{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:composer/environment:Environment default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param EnvironmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[pulumi.InputType['EnvironmentConfigArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentArgs.__new__(EnvironmentArgs)

            __props__.__dict__["config"] = config
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
        super(Environment, __self__).__init__(
            'gcp:composer/environment:Environment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[pulumi.InputType['EnvironmentConfigArgs']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None) -> 'Environment':
        """
        Get an existing Environment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['EnvironmentConfigArgs']] config: Configuration parameters for this environment  Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels for this environment. The labels map can contain
               no more than 64 entries. Entries of the labels map are UTF8 strings
               that comply with the following restrictions:
               Label keys must be between 1 and 63 characters long and must conform
               to the following regular expression: `a-z?`.
               Label values must be between 0 and 63 characters long and must
               conform to the regular expression `(a-z?)?`.
               No more than 64 labels can be associated with a given environment.
               Both keys and values must be <= 128 bytes in size.
        :param pulumi.Input[str] name: Name of the environment
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: The location or Compute Engine region for the environment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvironmentState.__new__(_EnvironmentState)

        __props__.__dict__["config"] = config
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        return Environment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output['outputs.EnvironmentConfig']:
        """
        Configuration parameters for this environment  Structure is documented below.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        User-defined labels for this environment. The labels map can contain
        no more than 64 entries. Entries of the labels map are UTF8 strings
        that comply with the following restrictions:
        Label keys must be between 1 and 63 characters long and must conform
        to the following regular expression: `a-z?`.
        Label values must be between 0 and 63 characters long and must
        conform to the regular expression `(a-z?)?`.
        No more than 64 labels can be associated with a given environment.
        Both keys and values must be <= 128 bytes in size.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the environment
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        The location or Compute Engine region for the environment.
        """
        return pulumi.get(self, "region")

