# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ForwardingRuleArgs', 'ForwardingRule']

@pulumi.input_type
class ForwardingRuleArgs:
    def __init__(__self__, *,
                 all_ports: Optional[pulumi.Input[bool]] = None,
                 allow_global_access: Optional[pulumi.Input[bool]] = None,
                 backend_service: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 ip_protocol: Optional[pulumi.Input[str]] = None,
                 is_mirroring_collector: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 network_tier: Optional[pulumi.Input[str]] = None,
                 port_range: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_label: Optional[pulumi.Input[str]] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ForwardingRule resource.
        :param pulumi.Input[bool] all_ports: This field can be used with internal load balancer or network load balancer
               when the forwarding rule references a backend service, or with the target
               field when it references a TargetInstance. Set this to true to
               allow packets addressed to any ports to be forwarded to the backends configured
               with this forwarding rule. This can be used when the protocol is TCP/UDP, and it
               must be set to true when the protocol is set to L3_DEFAULT.
               Cannot be set if port or portRange are set.
        :param pulumi.Input[bool] allow_global_access: If true, clients can access ILB from all regions.
               Otherwise only allows from the local region the ILB is located at.
        :param pulumi.Input[str] backend_service: A BackendService to receive the matched traffic. This is used only
               for INTERNAL load balancing.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[str] ip_address: The IP address that this forwarding rule serves. When a client sends
               traffic to this IP address, the forwarding rule directs the traffic to
               the target that you specify in the forwarding rule. The
               loadBalancingScheme and the forwarding rule's target determine the
               type of IP address that you can use. For detailed information, refer
               to [IP address specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               An address can be specified either by a literal IP address or a
               reference to an existing Address resource. If you don't specify a
               reserved IP address, an ephemeral IP address is assigned.
               The value must be set to 0.0.0.0 when the target is a targetGrpcProxy
               that has validateForProxyless field set to true.
               For Private Service Connect forwarding rules that forward traffic to
               Google APIs, IP address must be provided.
        :param pulumi.Input[str] ip_protocol: The IP protocol to which this rule applies.
               When the load balancing scheme is INTERNAL, only TCP and UDP are
               valid.
               Possible values are `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`, and `L3_DEFAULT`.
        :param pulumi.Input[bool] is_mirroring_collector: Indicates whether or not this load balancer can be used
               as a collector for packet mirroring. To prevent mirroring loops,
               instances behind this load balancer will not have their traffic
               mirrored even if a PacketMirroring rule applies to them. This
               can only be set to true for load balancers that have their
               loadBalancingScheme set to INTERNAL.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this forwarding rule.  A list of key->value pairs.
        :param pulumi.Input[str] load_balancing_scheme: This signifies what the ForwardingRule will be used for and can be
               EXTERNAL, INTERNAL, or INTERNAL_MANAGED. EXTERNAL is used for Classic
               Cloud VPN gateways, protocol forwarding to VMs from an external IP address,
               and HTTP(S), SSL Proxy, TCP Proxy, and Network TCP/UDP load balancers.
               INTERNAL is used for protocol forwarding to VMs from an internal IP address,
               and internal TCP/UDP load balancers.
               INTERNAL_MANAGED is used for internal HTTP(S) load balancers.
               Default value is `EXTERNAL`.
               Possible values are `EXTERNAL`, `INTERNAL`, and `INTERNAL_MANAGED`.
        :param pulumi.Input[str] name: Name of the resource; provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[str] network: For internal load balancing, this field identifies the network that
               the load balanced IP should belong to for this Forwarding Rule. If
               this field is not specified, the default network will be used.
               This field is only used for INTERNAL load balancing.
        :param pulumi.Input[str] network_tier: The networking tier used for configuring this address. If this field is not
               specified, it is assumed to be PREMIUM.
               Possible values are `PREMIUM` and `STANDARD`.
        :param pulumi.Input[str] port_range: This field is used along with the target field for TargetHttpProxy,
               TargetHttpsProxy, TargetSslProxy, TargetTcpProxy, TargetVpnGateway,
               TargetPool, TargetInstance.
               Applicable only when IPProtocol is TCP, UDP, or SCTP, only packets
               addressed to ports in the specified range will be forwarded to target.
               Forwarding rules with the same [IPAddress, IPProtocol] pair must have
               disjoint port ranges.
               Some types of forwarding target have constraints on the acceptable
               ports:
               * TargetHttpProxy: 80, 8080
               * TargetHttpsProxy: 443
               * TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
               1883, 5222
               * TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
               1883, 5222
               * TargetVpnGateway: 500, 4500
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ports: This field is used along with internal load balancing and network
               load balancer when the forwarding rule references a backend service
               and when protocol is not L3_DEFAULT.
               A single port or a comma separated list of ports can be configured.
               Only packets addressed to these ports will be forwarded to the backends
               configured with this forwarding rule.
               You can only use one of ports and portRange, or allPorts.
               The three are mutually exclusive.
               You may specify a maximum of up to 5 ports, which can be non-contiguous.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: A reference to the region where the regional forwarding rule resides.
               This field is not applicable to global forwarding rules.
        :param pulumi.Input[str] service_label: An optional prefix to the service name for this Forwarding Rule.
               If specified, will be the first label of the fully qualified service
               name.
               The label must be 1-63 characters long, and comply with RFC1035.
               Specifically, the label must be 1-63 characters long and match the
               regular expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters
               must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
               This field is only used for INTERNAL load balancing.
        :param pulumi.Input[str] subnetwork: The subnetwork that the load balanced IP should belong to for this
               Forwarding Rule.  This field is only used for INTERNAL load balancing.
               If the network specified is in auto subnet mode, this field is
               optional. However, if the network is in custom subnet mode, a
               subnetwork must be specified.
        :param pulumi.Input[str] target: The URL of the target resource to receive the matched traffic.
               The target must live in the same region as the forwarding rule.
               The forwarded traffic must be of a type appropriate to the target
               object.
        """
        if all_ports is not None:
            pulumi.set(__self__, "all_ports", all_ports)
        if allow_global_access is not None:
            pulumi.set(__self__, "allow_global_access", allow_global_access)
        if backend_service is not None:
            pulumi.set(__self__, "backend_service", backend_service)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_protocol is not None:
            pulumi.set(__self__, "ip_protocol", ip_protocol)
        if is_mirroring_collector is not None:
            pulumi.set(__self__, "is_mirroring_collector", is_mirroring_collector)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if load_balancing_scheme is not None:
            pulumi.set(__self__, "load_balancing_scheme", load_balancing_scheme)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if network_tier is not None:
            pulumi.set(__self__, "network_tier", network_tier)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_label is not None:
            pulumi.set(__self__, "service_label", service_label)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="allPorts")
    def all_ports(self) -> Optional[pulumi.Input[bool]]:
        """
        This field can be used with internal load balancer or network load balancer
        when the forwarding rule references a backend service, or with the target
        field when it references a TargetInstance. Set this to true to
        allow packets addressed to any ports to be forwarded to the backends configured
        with this forwarding rule. This can be used when the protocol is TCP/UDP, and it
        must be set to true when the protocol is set to L3_DEFAULT.
        Cannot be set if port or portRange are set.
        """
        return pulumi.get(self, "all_ports")

    @all_ports.setter
    def all_ports(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "all_ports", value)

    @property
    @pulumi.getter(name="allowGlobalAccess")
    def allow_global_access(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, clients can access ILB from all regions.
        Otherwise only allows from the local region the ILB is located at.
        """
        return pulumi.get(self, "allow_global_access")

    @allow_global_access.setter
    def allow_global_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_global_access", value)

    @property
    @pulumi.getter(name="backendService")
    def backend_service(self) -> Optional[pulumi.Input[str]]:
        """
        A BackendService to receive the matched traffic. This is used only
        for INTERNAL load balancing.
        """
        return pulumi.get(self, "backend_service")

    @backend_service.setter
    def backend_service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend_service", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address that this forwarding rule serves. When a client sends
        traffic to this IP address, the forwarding rule directs the traffic to
        the target that you specify in the forwarding rule. The
        loadBalancingScheme and the forwarding rule's target determine the
        type of IP address that you can use. For detailed information, refer
        to [IP address specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
        An address can be specified either by a literal IP address or a
        reference to an existing Address resource. If you don't specify a
        reserved IP address, an ephemeral IP address is assigned.
        The value must be set to 0.0.0.0 when the target is a targetGrpcProxy
        that has validateForProxyless field set to true.
        For Private Service Connect forwarding rules that forward traffic to
        Google APIs, IP address must be provided.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The IP protocol to which this rule applies.
        When the load balancing scheme is INTERNAL, only TCP and UDP are
        valid.
        Possible values are `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`, and `L3_DEFAULT`.
        """
        return pulumi.get(self, "ip_protocol")

    @ip_protocol.setter
    def ip_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_protocol", value)

    @property
    @pulumi.getter(name="isMirroringCollector")
    def is_mirroring_collector(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether or not this load balancer can be used
        as a collector for packet mirroring. To prevent mirroring loops,
        instances behind this load balancer will not have their traffic
        mirrored even if a PacketMirroring rule applies to them. This
        can only be set to true for load balancers that have their
        loadBalancingScheme set to INTERNAL.
        """
        return pulumi.get(self, "is_mirroring_collector")

    @is_mirroring_collector.setter
    def is_mirroring_collector(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_mirroring_collector", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels to apply to this forwarding rule.  A list of key->value pairs.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> Optional[pulumi.Input[str]]:
        """
        This signifies what the ForwardingRule will be used for and can be
        EXTERNAL, INTERNAL, or INTERNAL_MANAGED. EXTERNAL is used for Classic
        Cloud VPN gateways, protocol forwarding to VMs from an external IP address,
        and HTTP(S), SSL Proxy, TCP Proxy, and Network TCP/UDP load balancers.
        INTERNAL is used for protocol forwarding to VMs from an internal IP address,
        and internal TCP/UDP load balancers.
        INTERNAL_MANAGED is used for internal HTTP(S) load balancers.
        Default value is `EXTERNAL`.
        Possible values are `EXTERNAL`, `INTERNAL`, and `INTERNAL_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @load_balancing_scheme.setter
    def load_balancing_scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancing_scheme", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource; provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        For internal load balancing, this field identifies the network that
        the load balanced IP should belong to for this Forwarding Rule. If
        this field is not specified, the default network will be used.
        This field is only used for INTERNAL load balancing.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="networkTier")
    def network_tier(self) -> Optional[pulumi.Input[str]]:
        """
        The networking tier used for configuring this address. If this field is not
        specified, it is assumed to be PREMIUM.
        Possible values are `PREMIUM` and `STANDARD`.
        """
        return pulumi.get(self, "network_tier")

    @network_tier.setter
    def network_tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_tier", value)

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input[str]]:
        """
        This field is used along with the target field for TargetHttpProxy,
        TargetHttpsProxy, TargetSslProxy, TargetTcpProxy, TargetVpnGateway,
        TargetPool, TargetInstance.
        Applicable only when IPProtocol is TCP, UDP, or SCTP, only packets
        addressed to ports in the specified range will be forwarded to target.
        Forwarding rules with the same [IPAddress, IPProtocol] pair must have
        disjoint port ranges.
        Some types of forwarding target have constraints on the acceptable
        ports:
        * TargetHttpProxy: 80, 8080
        * TargetHttpsProxy: 443
        * TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
        1883, 5222
        * TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
        1883, 5222
        * TargetVpnGateway: 500, 4500
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_range", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        This field is used along with internal load balancing and network
        load balancer when the forwarding rule references a backend service
        and when protocol is not L3_DEFAULT.
        A single port or a comma separated list of ports can be configured.
        Only packets addressed to these ports will be forwarded to the backends
        configured with this forwarding rule.
        You can only use one of ports and portRange, or allPorts.
        The three are mutually exclusive.
        You may specify a maximum of up to 5 ports, which can be non-contiguous.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        A reference to the region where the regional forwarding rule resides.
        This field is not applicable to global forwarding rules.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="serviceLabel")
    def service_label(self) -> Optional[pulumi.Input[str]]:
        """
        An optional prefix to the service name for this Forwarding Rule.
        If specified, will be the first label of the fully qualified service
        name.
        The label must be 1-63 characters long, and comply with RFC1035.
        Specifically, the label must be 1-63 characters long and match the
        regular expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters
        must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        This field is only used for INTERNAL load balancing.
        """
        return pulumi.get(self, "service_label")

    @service_label.setter
    def service_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_label", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[str]]:
        """
        The subnetwork that the load balanced IP should belong to for this
        Forwarding Rule.  This field is only used for INTERNAL load balancing.
        If the network specified is in auto subnet mode, this field is
        optional. However, if the network is in custom subnet mode, a
        subnetwork must be specified.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the target resource to receive the matched traffic.
        The target must live in the same region as the forwarding rule.
        The forwarded traffic must be of a type appropriate to the target
        object.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class _ForwardingRuleState:
    def __init__(__self__, *,
                 all_ports: Optional[pulumi.Input[bool]] = None,
                 allow_global_access: Optional[pulumi.Input[bool]] = None,
                 backend_service: Optional[pulumi.Input[str]] = None,
                 creation_timestamp: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 ip_protocol: Optional[pulumi.Input[str]] = None,
                 is_mirroring_collector: Optional[pulumi.Input[bool]] = None,
                 label_fingerprint: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 network_tier: Optional[pulumi.Input[str]] = None,
                 port_range: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 service_label: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ForwardingRule resources.
        :param pulumi.Input[bool] all_ports: This field can be used with internal load balancer or network load balancer
               when the forwarding rule references a backend service, or with the target
               field when it references a TargetInstance. Set this to true to
               allow packets addressed to any ports to be forwarded to the backends configured
               with this forwarding rule. This can be used when the protocol is TCP/UDP, and it
               must be set to true when the protocol is set to L3_DEFAULT.
               Cannot be set if port or portRange are set.
        :param pulumi.Input[bool] allow_global_access: If true, clients can access ILB from all regions.
               Otherwise only allows from the local region the ILB is located at.
        :param pulumi.Input[str] backend_service: A BackendService to receive the matched traffic. This is used only
               for INTERNAL load balancing.
        :param pulumi.Input[str] creation_timestamp: [Output Only] Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[str] ip_address: The IP address that this forwarding rule serves. When a client sends
               traffic to this IP address, the forwarding rule directs the traffic to
               the target that you specify in the forwarding rule. The
               loadBalancingScheme and the forwarding rule's target determine the
               type of IP address that you can use. For detailed information, refer
               to [IP address specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               An address can be specified either by a literal IP address or a
               reference to an existing Address resource. If you don't specify a
               reserved IP address, an ephemeral IP address is assigned.
               The value must be set to 0.0.0.0 when the target is a targetGrpcProxy
               that has validateForProxyless field set to true.
               For Private Service Connect forwarding rules that forward traffic to
               Google APIs, IP address must be provided.
        :param pulumi.Input[str] ip_protocol: The IP protocol to which this rule applies.
               When the load balancing scheme is INTERNAL, only TCP and UDP are
               valid.
               Possible values are `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`, and `L3_DEFAULT`.
        :param pulumi.Input[bool] is_mirroring_collector: Indicates whether or not this load balancer can be used
               as a collector for packet mirroring. To prevent mirroring loops,
               instances behind this load balancer will not have their traffic
               mirrored even if a PacketMirroring rule applies to them. This
               can only be set to true for load balancers that have their
               loadBalancingScheme set to INTERNAL.
        :param pulumi.Input[str] label_fingerprint: Used internally during label updates.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this forwarding rule.  A list of key->value pairs.
        :param pulumi.Input[str] load_balancing_scheme: This signifies what the ForwardingRule will be used for and can be
               EXTERNAL, INTERNAL, or INTERNAL_MANAGED. EXTERNAL is used for Classic
               Cloud VPN gateways, protocol forwarding to VMs from an external IP address,
               and HTTP(S), SSL Proxy, TCP Proxy, and Network TCP/UDP load balancers.
               INTERNAL is used for protocol forwarding to VMs from an internal IP address,
               and internal TCP/UDP load balancers.
               INTERNAL_MANAGED is used for internal HTTP(S) load balancers.
               Default value is `EXTERNAL`.
               Possible values are `EXTERNAL`, `INTERNAL`, and `INTERNAL_MANAGED`.
        :param pulumi.Input[str] name: Name of the resource; provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[str] network: For internal load balancing, this field identifies the network that
               the load balanced IP should belong to for this Forwarding Rule. If
               this field is not specified, the default network will be used.
               This field is only used for INTERNAL load balancing.
        :param pulumi.Input[str] network_tier: The networking tier used for configuring this address. If this field is not
               specified, it is assumed to be PREMIUM.
               Possible values are `PREMIUM` and `STANDARD`.
        :param pulumi.Input[str] port_range: This field is used along with the target field for TargetHttpProxy,
               TargetHttpsProxy, TargetSslProxy, TargetTcpProxy, TargetVpnGateway,
               TargetPool, TargetInstance.
               Applicable only when IPProtocol is TCP, UDP, or SCTP, only packets
               addressed to ports in the specified range will be forwarded to target.
               Forwarding rules with the same [IPAddress, IPProtocol] pair must have
               disjoint port ranges.
               Some types of forwarding target have constraints on the acceptable
               ports:
               * TargetHttpProxy: 80, 8080
               * TargetHttpsProxy: 443
               * TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
               1883, 5222
               * TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
               1883, 5222
               * TargetVpnGateway: 500, 4500
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ports: This field is used along with internal load balancing and network
               load balancer when the forwarding rule references a backend service
               and when protocol is not L3_DEFAULT.
               A single port or a comma separated list of ports can be configured.
               Only packets addressed to these ports will be forwarded to the backends
               configured with this forwarding rule.
               You can only use one of ports and portRange, or allPorts.
               The three are mutually exclusive.
               You may specify a maximum of up to 5 ports, which can be non-contiguous.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: A reference to the region where the regional forwarding rule resides.
               This field is not applicable to global forwarding rules.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] service_label: An optional prefix to the service name for this Forwarding Rule.
               If specified, will be the first label of the fully qualified service
               name.
               The label must be 1-63 characters long, and comply with RFC1035.
               Specifically, the label must be 1-63 characters long and match the
               regular expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters
               must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
               This field is only used for INTERNAL load balancing.
        :param pulumi.Input[str] service_name: [Output Only] The internal fully qualified service name for this Forwarding Rule. This field is only used for internal
               load balancing.
        :param pulumi.Input[str] subnetwork: The subnetwork that the load balanced IP should belong to for this
               Forwarding Rule.  This field is only used for INTERNAL load balancing.
               If the network specified is in auto subnet mode, this field is
               optional. However, if the network is in custom subnet mode, a
               subnetwork must be specified.
        :param pulumi.Input[str] target: The URL of the target resource to receive the matched traffic.
               The target must live in the same region as the forwarding rule.
               The forwarded traffic must be of a type appropriate to the target
               object.
        """
        if all_ports is not None:
            pulumi.set(__self__, "all_ports", all_ports)
        if allow_global_access is not None:
            pulumi.set(__self__, "allow_global_access", allow_global_access)
        if backend_service is not None:
            pulumi.set(__self__, "backend_service", backend_service)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_protocol is not None:
            pulumi.set(__self__, "ip_protocol", ip_protocol)
        if is_mirroring_collector is not None:
            pulumi.set(__self__, "is_mirroring_collector", is_mirroring_collector)
        if label_fingerprint is not None:
            pulumi.set(__self__, "label_fingerprint", label_fingerprint)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if load_balancing_scheme is not None:
            pulumi.set(__self__, "load_balancing_scheme", load_balancing_scheme)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if network_tier is not None:
            pulumi.set(__self__, "network_tier", network_tier)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if service_label is not None:
            pulumi.set(__self__, "service_label", service_label)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="allPorts")
    def all_ports(self) -> Optional[pulumi.Input[bool]]:
        """
        This field can be used with internal load balancer or network load balancer
        when the forwarding rule references a backend service, or with the target
        field when it references a TargetInstance. Set this to true to
        allow packets addressed to any ports to be forwarded to the backends configured
        with this forwarding rule. This can be used when the protocol is TCP/UDP, and it
        must be set to true when the protocol is set to L3_DEFAULT.
        Cannot be set if port or portRange are set.
        """
        return pulumi.get(self, "all_ports")

    @all_ports.setter
    def all_ports(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "all_ports", value)

    @property
    @pulumi.getter(name="allowGlobalAccess")
    def allow_global_access(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, clients can access ILB from all regions.
        Otherwise only allows from the local region the ILB is located at.
        """
        return pulumi.get(self, "allow_global_access")

    @allow_global_access.setter
    def allow_global_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_global_access", value)

    @property
    @pulumi.getter(name="backendService")
    def backend_service(self) -> Optional[pulumi.Input[str]]:
        """
        A BackendService to receive the matched traffic. This is used only
        for INTERNAL load balancing.
        """
        return pulumi.get(self, "backend_service")

    @backend_service.setter
    def backend_service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend_service", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        [Output Only] Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address that this forwarding rule serves. When a client sends
        traffic to this IP address, the forwarding rule directs the traffic to
        the target that you specify in the forwarding rule. The
        loadBalancingScheme and the forwarding rule's target determine the
        type of IP address that you can use. For detailed information, refer
        to [IP address specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
        An address can be specified either by a literal IP address or a
        reference to an existing Address resource. If you don't specify a
        reserved IP address, an ephemeral IP address is assigned.
        The value must be set to 0.0.0.0 when the target is a targetGrpcProxy
        that has validateForProxyless field set to true.
        For Private Service Connect forwarding rules that forward traffic to
        Google APIs, IP address must be provided.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The IP protocol to which this rule applies.
        When the load balancing scheme is INTERNAL, only TCP and UDP are
        valid.
        Possible values are `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`, and `L3_DEFAULT`.
        """
        return pulumi.get(self, "ip_protocol")

    @ip_protocol.setter
    def ip_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_protocol", value)

    @property
    @pulumi.getter(name="isMirroringCollector")
    def is_mirroring_collector(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether or not this load balancer can be used
        as a collector for packet mirroring. To prevent mirroring loops,
        instances behind this load balancer will not have their traffic
        mirrored even if a PacketMirroring rule applies to them. This
        can only be set to true for load balancers that have their
        loadBalancingScheme set to INTERNAL.
        """
        return pulumi.get(self, "is_mirroring_collector")

    @is_mirroring_collector.setter
    def is_mirroring_collector(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_mirroring_collector", value)

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        Used internally during label updates.
        """
        return pulumi.get(self, "label_fingerprint")

    @label_fingerprint.setter
    def label_fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label_fingerprint", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels to apply to this forwarding rule.  A list of key->value pairs.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> Optional[pulumi.Input[str]]:
        """
        This signifies what the ForwardingRule will be used for and can be
        EXTERNAL, INTERNAL, or INTERNAL_MANAGED. EXTERNAL is used for Classic
        Cloud VPN gateways, protocol forwarding to VMs from an external IP address,
        and HTTP(S), SSL Proxy, TCP Proxy, and Network TCP/UDP load balancers.
        INTERNAL is used for protocol forwarding to VMs from an internal IP address,
        and internal TCP/UDP load balancers.
        INTERNAL_MANAGED is used for internal HTTP(S) load balancers.
        Default value is `EXTERNAL`.
        Possible values are `EXTERNAL`, `INTERNAL`, and `INTERNAL_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @load_balancing_scheme.setter
    def load_balancing_scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancing_scheme", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource; provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        For internal load balancing, this field identifies the network that
        the load balanced IP should belong to for this Forwarding Rule. If
        this field is not specified, the default network will be used.
        This field is only used for INTERNAL load balancing.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="networkTier")
    def network_tier(self) -> Optional[pulumi.Input[str]]:
        """
        The networking tier used for configuring this address. If this field is not
        specified, it is assumed to be PREMIUM.
        Possible values are `PREMIUM` and `STANDARD`.
        """
        return pulumi.get(self, "network_tier")

    @network_tier.setter
    def network_tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_tier", value)

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input[str]]:
        """
        This field is used along with the target field for TargetHttpProxy,
        TargetHttpsProxy, TargetSslProxy, TargetTcpProxy, TargetVpnGateway,
        TargetPool, TargetInstance.
        Applicable only when IPProtocol is TCP, UDP, or SCTP, only packets
        addressed to ports in the specified range will be forwarded to target.
        Forwarding rules with the same [IPAddress, IPProtocol] pair must have
        disjoint port ranges.
        Some types of forwarding target have constraints on the acceptable
        ports:
        * TargetHttpProxy: 80, 8080
        * TargetHttpsProxy: 443
        * TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
        1883, 5222
        * TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
        1883, 5222
        * TargetVpnGateway: 500, 4500
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_range", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        This field is used along with internal load balancing and network
        load balancer when the forwarding rule references a backend service
        and when protocol is not L3_DEFAULT.
        A single port or a comma separated list of ports can be configured.
        Only packets addressed to these ports will be forwarded to the backends
        configured with this forwarding rule.
        You can only use one of ports and portRange, or allPorts.
        The three are mutually exclusive.
        You may specify a maximum of up to 5 ports, which can be non-contiguous.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        A reference to the region where the regional forwarding rule resides.
        This field is not applicable to global forwarding rules.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="serviceLabel")
    def service_label(self) -> Optional[pulumi.Input[str]]:
        """
        An optional prefix to the service name for this Forwarding Rule.
        If specified, will be the first label of the fully qualified service
        name.
        The label must be 1-63 characters long, and comply with RFC1035.
        Specifically, the label must be 1-63 characters long and match the
        regular expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters
        must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        This field is only used for INTERNAL load balancing.
        """
        return pulumi.get(self, "service_label")

    @service_label.setter
    def service_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_label", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        [Output Only] The internal fully qualified service name for this Forwarding Rule. This field is only used for internal
        load balancing.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[str]]:
        """
        The subnetwork that the load balanced IP should belong to for this
        Forwarding Rule.  This field is only used for INTERNAL load balancing.
        If the network specified is in auto subnet mode, this field is
        optional. However, if the network is in custom subnet mode, a
        subnetwork must be specified.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the target resource to receive the matched traffic.
        The target must live in the same region as the forwarding rule.
        The forwarded traffic must be of a type appropriate to the target
        object.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)


class ForwardingRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 all_ports: Optional[pulumi.Input[bool]] = None,
                 allow_global_access: Optional[pulumi.Input[bool]] = None,
                 backend_service: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 ip_protocol: Optional[pulumi.Input[str]] = None,
                 is_mirroring_collector: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 network_tier: Optional[pulumi.Input[str]] = None,
                 port_range: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_label: Optional[pulumi.Input[str]] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A ForwardingRule resource. A ForwardingRule resource specifies which pool
        of target virtual machines to forward a packet to if it matches the given
        [IPAddress, IPProtocol, portRange] tuple.

        To get more information about ForwardingRule, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/v1/forwardingRules)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/compute/docs/load-balancing/network/forwarding-rules)

        ## Example Usage
        ### Internal Http Lb With Mig Backend

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # Internal HTTP load balancer with a managed instance group backend
        # VPC
        ilb_network = gcp.compute.Network("ilbNetwork", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        # proxy-only subnet
        proxy_subnet = gcp.compute.Subnetwork("proxySubnet",
            ip_cidr_range="10.0.0.0/24",
            region="europe-west1",
            purpose="INTERNAL_HTTPS_LOAD_BALANCER",
            role="ACTIVE",
            network=ilb_network.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        # backed subnet
        ilb_subnet = gcp.compute.Subnetwork("ilbSubnet",
            ip_cidr_range="10.0.1.0/24",
            region="europe-west1",
            network=ilb_network.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        # health check
        default_region_health_check = gcp.compute.RegionHealthCheck("defaultRegionHealthCheck",
            region="europe-west1",
            http_health_check=gcp.compute.RegionHealthCheckHttpHealthCheckArgs(
                port_specification="USE_SERVING_PORT",
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        # instance template
        instance_template = gcp.compute.InstanceTemplate("instanceTemplate",
            machine_type="e2-small",
            tags=["http-server"],
            network_interfaces=[gcp.compute.InstanceTemplateNetworkInterfaceArgs(
                network=ilb_network.id,
                subnetwork=ilb_subnet.id,
                access_configs=[gcp.compute.InstanceTemplateNetworkInterfaceAccessConfigArgs()],
            )],
            disks=[gcp.compute.InstanceTemplateDiskArgs(
                source_image="debian-cloud/debian-10",
                auto_delete=True,
                boot=True,
            )],
            metadata={
                "startup-script": \"\"\"#! /bin/bash
        set -euo pipefail

        export DEBIAN_FRONTEND=noninteractive
        apt-get update
        apt-get install -y nginx-light jq

        NAME=$(curl -H "Metadata-Flavor: Google" "http://metadata.google.internal/computeMetadata/v1/instance/hostname")
        IP=$(curl -H "Metadata-Flavor: Google" "http://metadata.google.internal/computeMetadata/v1/instance/network-interfaces/0/ip")
        METADATA=$(curl -f -H "Metadata-Flavor: Google" "http://metadata.google.internal/computeMetadata/v1/instance/attributes/?recursive=True" | jq 'del(.["startup-script"])')

        cat <<EOF > /var/www/html/index.html
        <pre>
        Name: $NAME
        IP: $IP
        Metadata: $METADATA
        </pre>
        EOF
        \"\"\",
            },
            opts=pulumi.ResourceOptions(provider=google_beta))
        # MIG
        mig = gcp.compute.RegionInstanceGroupManager("mig",
            region="europe-west1",
            versions=[gcp.compute.RegionInstanceGroupManagerVersionArgs(
                instance_template=instance_template.id,
                name="primary",
            )],
            base_instance_name="vm",
            target_size=2,
            opts=pulumi.ResourceOptions(provider=google_beta))
        # backend service
        default_region_backend_service = gcp.compute.RegionBackendService("defaultRegionBackendService",
            region="europe-west1",
            protocol="HTTP",
            load_balancing_scheme="INTERNAL_MANAGED",
            timeout_sec=10,
            health_checks=[default_region_health_check.id],
            backends=[gcp.compute.RegionBackendServiceBackendArgs(
                group=mig.instance_group,
                balancing_mode="UTILIZATION",
                capacity_scaler=1,
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        # url map
        default_region_url_map = gcp.compute.RegionUrlMap("defaultRegionUrlMap",
            region="europe-west1",
            default_service=default_region_backend_service.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        # http proxy
        default_region_target_http_proxy = gcp.compute.RegionTargetHttpProxy("defaultRegionTargetHttpProxy",
            region="europe-west1",
            url_map=default_region_url_map.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        # forwarding rule
        google_compute_forwarding_rule = gcp.compute.ForwardingRule("googleComputeForwardingRule",
            region="europe-west1",
            ip_protocol="TCP",
            load_balancing_scheme="INTERNAL_MANAGED",
            port_range="80",
            target=default_region_target_http_proxy.id,
            network=ilb_network.id,
            subnetwork=ilb_subnet.id,
            network_tier="PREMIUM",
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[proxy_subnet]))
        # allow all access from IAP and health check ranges
        fw_iap = gcp.compute.Firewall("fw-iap",
            direction="INGRESS",
            network=ilb_network.id,
            source_ranges=[
                "130.211.0.0/22",
                "35.191.0.0/16",
                "35.235.240.0/20",
            ],
            allows=[gcp.compute.FirewallAllowArgs(
                protocol="tcp",
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        # allow http from proxy subnet to backends
        fw_ilb_to_backends = gcp.compute.Firewall("fw-ilb-to-backends",
            direction="INGRESS",
            network=ilb_network.id,
            source_ranges=["10.0.0.0/24"],
            target_tags=["http-server"],
            allows=[gcp.compute.FirewallAllowArgs(
                protocol="tcp",
                ports=[
                    "80",
                    "443",
                    "8080",
                ],
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        # test instance
        vm_test = gcp.compute.Instance("vm-test",
            zone="europe-west1-b",
            machine_type="e2-small",
            network_interfaces=[gcp.compute.InstanceNetworkInterfaceArgs(
                network=ilb_network.id,
                subnetwork=ilb_subnet.id,
            )],
            boot_disk=gcp.compute.InstanceBootDiskArgs(
                initialize_params=gcp.compute.InstanceBootDiskInitializeParamsArgs(
                    image="debian-cloud/debian-10",
                ),
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Internal Tcp Udp Lb With Mig Backend

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # Internal TCP/UDP load balancer with a managed instance group backend
        # VPC
        ilb_network = gcp.compute.Network("ilbNetwork", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        # backed subnet
        ilb_subnet = gcp.compute.Subnetwork("ilbSubnet",
            ip_cidr_range="10.0.1.0/24",
            region="europe-west1",
            network=ilb_network.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        # health check
        default_region_health_check = gcp.compute.RegionHealthCheck("defaultRegionHealthCheck",
            region="europe-west1",
            http_health_check=gcp.compute.RegionHealthCheckHttpHealthCheckArgs(
                port=80,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        # instance template
        instance_template = gcp.compute.InstanceTemplate("instanceTemplate",
            machine_type="e2-small",
            tags=[
                "allow-ssh",
                "allow-health-check",
            ],
            network_interfaces=[gcp.compute.InstanceTemplateNetworkInterfaceArgs(
                network=ilb_network.id,
                subnetwork=ilb_subnet.id,
                access_configs=[gcp.compute.InstanceTemplateNetworkInterfaceAccessConfigArgs()],
            )],
            disks=[gcp.compute.InstanceTemplateDiskArgs(
                source_image="debian-cloud/debian-10",
                auto_delete=True,
                boot=True,
            )],
            metadata={
                "startup-script": \"\"\"#! /bin/bash
        set -euo pipefail

        export DEBIAN_FRONTEND=noninteractive
        apt-get update
        apt-get install -y nginx-light jq

        NAME=$(curl -H "Metadata-Flavor: Google" "http://metadata.google.internal/computeMetadata/v1/instance/hostname")
        IP=$(curl -H "Metadata-Flavor: Google" "http://metadata.google.internal/computeMetadata/v1/instance/network-interfaces/0/ip")
        METADATA=$(curl -f -H "Metadata-Flavor: Google" "http://metadata.google.internal/computeMetadata/v1/instance/attributes/?recursive=True" | jq 'del(.["startup-script"])')

        cat <<EOF > /var/www/html/index.html
        <pre>
        Name: $NAME
        IP: $IP
        Metadata: $METADATA
        </pre>
        EOF
        \"\"\",
            },
            opts=pulumi.ResourceOptions(provider=google_beta))
        # MIG
        mig = gcp.compute.RegionInstanceGroupManager("mig",
            region="europe-west1",
            versions=[gcp.compute.RegionInstanceGroupManagerVersionArgs(
                instance_template=instance_template.id,
                name="primary",
            )],
            base_instance_name="vm",
            target_size=2,
            opts=pulumi.ResourceOptions(provider=google_beta))
        # backend service
        default_region_backend_service = gcp.compute.RegionBackendService("defaultRegionBackendService",
            region="europe-west1",
            protocol="TCP",
            load_balancing_scheme="INTERNAL",
            health_checks=[default_region_health_check.id],
            backends=[gcp.compute.RegionBackendServiceBackendArgs(
                group=mig.instance_group,
                balancing_mode="CONNECTION",
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        # forwarding rule
        google_compute_forwarding_rule = gcp.compute.ForwardingRule("googleComputeForwardingRule",
            backend_service=default_region_backend_service.id,
            region="europe-west1",
            ip_protocol="TCP",
            load_balancing_scheme="INTERNAL",
            all_ports=True,
            allow_global_access=True,
            network=ilb_network.id,
            subnetwork=ilb_subnet.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        # allow all access from health check ranges
        fw_hc = gcp.compute.Firewall("fwHc",
            direction="INGRESS",
            network=ilb_network.id,
            source_ranges=[
                "130.211.0.0/22",
                "35.191.0.0/16",
                "35.235.240.0/20",
            ],
            allows=[gcp.compute.FirewallAllowArgs(
                protocol="tcp",
            )],
            source_tags=["allow-health-check"],
            opts=pulumi.ResourceOptions(provider=google_beta))
        # allow communication within the subnet 
        fw_ilb_to_backends = gcp.compute.Firewall("fwIlbToBackends",
            direction="INGRESS",
            network=ilb_network.id,
            source_ranges=["10.0.1.0/24"],
            allows=[
                gcp.compute.FirewallAllowArgs(
                    protocol="tcp",
                ),
                gcp.compute.FirewallAllowArgs(
                    protocol="udp",
                ),
                gcp.compute.FirewallAllowArgs(
                    protocol="icmp",
                ),
            ],
            opts=pulumi.ResourceOptions(provider=google_beta))
        # allow SSH
        fw_ilb_ssh = gcp.compute.Firewall("fwIlbSsh",
            direction="INGRESS",
            network=ilb_network.id,
            allows=[gcp.compute.FirewallAllowArgs(
                protocol="tcp",
                ports=["22"],
            )],
            source_tags=["allow-ssh"],
            opts=pulumi.ResourceOptions(provider=google_beta))
        # test instance
        vm_test = gcp.compute.Instance("vmTest",
            zone="europe-west1-b",
            machine_type="e2-small",
            network_interfaces=[gcp.compute.InstanceNetworkInterfaceArgs(
                network=ilb_network.id,
                subnetwork=ilb_subnet.id,
            )],
            boot_disk=gcp.compute.InstanceBootDiskArgs(
                initialize_params=gcp.compute.InstanceBootDiskInitializeParamsArgs(
                    image="debian-cloud/debian-10",
                ),
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Forwarding Rule Externallb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        hc = gcp.compute.RegionHealthCheck("hc",
            check_interval_sec=1,
            timeout_sec=1,
            region="us-central1",
            tcp_health_check=gcp.compute.RegionHealthCheckTcpHealthCheckArgs(
                port=80,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        backend = gcp.compute.RegionBackendService("backend",
            region="us-central1",
            load_balancing_scheme="EXTERNAL",
            health_checks=[hc.id],
            opts=pulumi.ResourceOptions(provider=google_beta))
        # Forwarding rule for External Network Load Balancing using Backend Services
        default = gcp.compute.ForwardingRule("default",
            region="us-central1",
            port_range="80",
            backend_service=backend.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Forwarding Rule Global Internallb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        hc = gcp.compute.HealthCheck("hc",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check=gcp.compute.HealthCheckTcpHealthCheckArgs(
                port=80,
            ))
        backend = gcp.compute.RegionBackendService("backend",
            region="us-central1",
            health_checks=[hc.id])
        default_network = gcp.compute.Network("defaultNetwork", auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("defaultSubnetwork",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=default_network.id)
        # Forwarding rule for Internal Load Balancing
        default_forwarding_rule = gcp.compute.ForwardingRule("defaultForwardingRule",
            region="us-central1",
            load_balancing_scheme="INTERNAL",
            backend_service=backend.id,
            all_ports=True,
            allow_global_access=True,
            network=default_network.name,
            subnetwork=default_subnetwork.name)
        ```
        ### Forwarding Rule Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_target_pool = gcp.compute.TargetPool("defaultTargetPool")
        default_forwarding_rule = gcp.compute.ForwardingRule("defaultForwardingRule",
            target=default_target_pool.id,
            port_range="80")
        ```
        ### Forwarding Rule L3 Default

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.RegionHealthCheck("healthCheck",
            region="us-central1",
            tcp_health_check=gcp.compute.RegionHealthCheckTcpHealthCheckArgs(
                port=80,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        service = gcp.compute.RegionBackendService("service",
            region="us-central1",
            health_checks=[health_check.id],
            protocol="UNSPECIFIED",
            load_balancing_scheme="EXTERNAL",
            opts=pulumi.ResourceOptions(provider=google_beta))
        fwd_rule = gcp.compute.ForwardingRule("fwdRule",
            backend_service=service.id,
            ip_protocol="L3_DEFAULT",
            all_ports=True,
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Forwarding Rule Internallb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        hc = gcp.compute.HealthCheck("hc",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check=gcp.compute.HealthCheckTcpHealthCheckArgs(
                port=80,
            ))
        backend = gcp.compute.RegionBackendService("backend",
            region="us-central1",
            health_checks=[hc.id])
        default_network = gcp.compute.Network("defaultNetwork", auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("defaultSubnetwork",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=default_network.id)
        # Forwarding rule for Internal Load Balancing
        default_forwarding_rule = gcp.compute.ForwardingRule("defaultForwardingRule",
            region="us-central1",
            load_balancing_scheme="INTERNAL",
            backend_service=backend.id,
            all_ports=True,
            network=default_network.name,
            subnetwork=default_subnetwork.name)
        ```
        ### Forwarding Rule Http Lb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        debian_image = gcp.compute.get_image(family="debian-9",
            project="debian-cloud")
        default_network = gcp.compute.Network("defaultNetwork",
            auto_create_subnetworks=False,
            routing_mode="REGIONAL",
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_subnetwork = gcp.compute.Subnetwork("defaultSubnetwork",
            ip_cidr_range="10.1.2.0/24",
            region="us-central1",
            network=default_network.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        instance_template = gcp.compute.InstanceTemplate("instanceTemplate",
            machine_type="e2-medium",
            network_interfaces=[gcp.compute.InstanceTemplateNetworkInterfaceArgs(
                network=default_network.id,
                subnetwork=default_subnetwork.id,
            )],
            disks=[gcp.compute.InstanceTemplateDiskArgs(
                source_image=debian_image.self_link,
                auto_delete=True,
                boot=True,
            )],
            tags=[
                "allow-ssh",
                "load-balanced-backend",
            ],
            opts=pulumi.ResourceOptions(provider=google_beta))
        rigm = gcp.compute.RegionInstanceGroupManager("rigm",
            region="us-central1",
            versions=[gcp.compute.RegionInstanceGroupManagerVersionArgs(
                instance_template=instance_template.id,
                name="primary",
            )],
            base_instance_name="internal-glb",
            target_size=1,
            opts=pulumi.ResourceOptions(provider=google_beta))
        fw1 = gcp.compute.Firewall("fw1",
            network=default_network.id,
            source_ranges=["10.1.2.0/24"],
            allows=[
                gcp.compute.FirewallAllowArgs(
                    protocol="tcp",
                ),
                gcp.compute.FirewallAllowArgs(
                    protocol="udp",
                ),
                gcp.compute.FirewallAllowArgs(
                    protocol="icmp",
                ),
            ],
            direction="INGRESS",
            opts=pulumi.ResourceOptions(provider=google_beta))
        fw2 = gcp.compute.Firewall("fw2",
            network=default_network.id,
            source_ranges=["0.0.0.0/0"],
            allows=[gcp.compute.FirewallAllowArgs(
                protocol="tcp",
                ports=["22"],
            )],
            target_tags=["allow-ssh"],
            direction="INGRESS",
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[fw1]))
        fw3 = gcp.compute.Firewall("fw3",
            network=default_network.id,
            source_ranges=[
                "130.211.0.0/22",
                "35.191.0.0/16",
            ],
            allows=[gcp.compute.FirewallAllowArgs(
                protocol="tcp",
            )],
            target_tags=["load-balanced-backend"],
            direction="INGRESS",
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[fw2]))
        fw4 = gcp.compute.Firewall("fw4",
            network=default_network.id,
            source_ranges=["10.129.0.0/26"],
            target_tags=["load-balanced-backend"],
            allows=[
                gcp.compute.FirewallAllowArgs(
                    protocol="tcp",
                    ports=["80"],
                ),
                gcp.compute.FirewallAllowArgs(
                    protocol="tcp",
                    ports=["443"],
                ),
                gcp.compute.FirewallAllowArgs(
                    protocol="tcp",
                    ports=["8000"],
                ),
            ],
            direction="INGRESS",
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[fw3]))
        default_region_health_check = gcp.compute.RegionHealthCheck("defaultRegionHealthCheck",
            region="us-central1",
            http_health_check=gcp.compute.RegionHealthCheckHttpHealthCheckArgs(
                port_specification="USE_SERVING_PORT",
            ),
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[fw4]))
        default_region_backend_service = gcp.compute.RegionBackendService("defaultRegionBackendService",
            load_balancing_scheme="INTERNAL_MANAGED",
            backends=[gcp.compute.RegionBackendServiceBackendArgs(
                group=rigm.instance_group,
                balancing_mode="UTILIZATION",
                capacity_scaler=1,
            )],
            region="us-central1",
            protocol="HTTP",
            timeout_sec=10,
            health_checks=[default_region_health_check.id],
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_region_url_map = gcp.compute.RegionUrlMap("defaultRegionUrlMap",
            region="us-central1",
            default_service=default_region_backend_service.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_region_target_http_proxy = gcp.compute.RegionTargetHttpProxy("defaultRegionTargetHttpProxy",
            region="us-central1",
            url_map=default_region_url_map.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        proxy = gcp.compute.Subnetwork("proxy",
            ip_cidr_range="10.129.0.0/26",
            region="us-central1",
            network=default_network.id,
            purpose="INTERNAL_HTTPS_LOAD_BALANCER",
            role="ACTIVE",
            opts=pulumi.ResourceOptions(provider=google_beta))
        # Forwarding rule for Internal Load Balancing
        default_forwarding_rule = gcp.compute.ForwardingRule("defaultForwardingRule",
            region="us-central1",
            ip_protocol="TCP",
            load_balancing_scheme="INTERNAL_MANAGED",
            port_range="80",
            target=default_region_target_http_proxy.id,
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            network_tier="PREMIUM",
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[proxy]))
        ```

        ## Import

        ForwardingRule can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/forwardingRule:ForwardingRule default projects/{{project}}/regions/{{region}}/forwardingRules/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/forwardingRule:ForwardingRule default {{project}}/{{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/forwardingRule:ForwardingRule default {{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/forwardingRule:ForwardingRule default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] all_ports: This field can be used with internal load balancer or network load balancer
               when the forwarding rule references a backend service, or with the target
               field when it references a TargetInstance. Set this to true to
               allow packets addressed to any ports to be forwarded to the backends configured
               with this forwarding rule. This can be used when the protocol is TCP/UDP, and it
               must be set to true when the protocol is set to L3_DEFAULT.
               Cannot be set if port or portRange are set.
        :param pulumi.Input[bool] allow_global_access: If true, clients can access ILB from all regions.
               Otherwise only allows from the local region the ILB is located at.
        :param pulumi.Input[str] backend_service: A BackendService to receive the matched traffic. This is used only
               for INTERNAL load balancing.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[str] ip_address: The IP address that this forwarding rule serves. When a client sends
               traffic to this IP address, the forwarding rule directs the traffic to
               the target that you specify in the forwarding rule. The
               loadBalancingScheme and the forwarding rule's target determine the
               type of IP address that you can use. For detailed information, refer
               to [IP address specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               An address can be specified either by a literal IP address or a
               reference to an existing Address resource. If you don't specify a
               reserved IP address, an ephemeral IP address is assigned.
               The value must be set to 0.0.0.0 when the target is a targetGrpcProxy
               that has validateForProxyless field set to true.
               For Private Service Connect forwarding rules that forward traffic to
               Google APIs, IP address must be provided.
        :param pulumi.Input[str] ip_protocol: The IP protocol to which this rule applies.
               When the load balancing scheme is INTERNAL, only TCP and UDP are
               valid.
               Possible values are `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`, and `L3_DEFAULT`.
        :param pulumi.Input[bool] is_mirroring_collector: Indicates whether or not this load balancer can be used
               as a collector for packet mirroring. To prevent mirroring loops,
               instances behind this load balancer will not have their traffic
               mirrored even if a PacketMirroring rule applies to them. This
               can only be set to true for load balancers that have their
               loadBalancingScheme set to INTERNAL.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this forwarding rule.  A list of key->value pairs.
        :param pulumi.Input[str] load_balancing_scheme: This signifies what the ForwardingRule will be used for and can be
               EXTERNAL, INTERNAL, or INTERNAL_MANAGED. EXTERNAL is used for Classic
               Cloud VPN gateways, protocol forwarding to VMs from an external IP address,
               and HTTP(S), SSL Proxy, TCP Proxy, and Network TCP/UDP load balancers.
               INTERNAL is used for protocol forwarding to VMs from an internal IP address,
               and internal TCP/UDP load balancers.
               INTERNAL_MANAGED is used for internal HTTP(S) load balancers.
               Default value is `EXTERNAL`.
               Possible values are `EXTERNAL`, `INTERNAL`, and `INTERNAL_MANAGED`.
        :param pulumi.Input[str] name: Name of the resource; provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[str] network: For internal load balancing, this field identifies the network that
               the load balanced IP should belong to for this Forwarding Rule. If
               this field is not specified, the default network will be used.
               This field is only used for INTERNAL load balancing.
        :param pulumi.Input[str] network_tier: The networking tier used for configuring this address. If this field is not
               specified, it is assumed to be PREMIUM.
               Possible values are `PREMIUM` and `STANDARD`.
        :param pulumi.Input[str] port_range: This field is used along with the target field for TargetHttpProxy,
               TargetHttpsProxy, TargetSslProxy, TargetTcpProxy, TargetVpnGateway,
               TargetPool, TargetInstance.
               Applicable only when IPProtocol is TCP, UDP, or SCTP, only packets
               addressed to ports in the specified range will be forwarded to target.
               Forwarding rules with the same [IPAddress, IPProtocol] pair must have
               disjoint port ranges.
               Some types of forwarding target have constraints on the acceptable
               ports:
               * TargetHttpProxy: 80, 8080
               * TargetHttpsProxy: 443
               * TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
               1883, 5222
               * TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
               1883, 5222
               * TargetVpnGateway: 500, 4500
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ports: This field is used along with internal load balancing and network
               load balancer when the forwarding rule references a backend service
               and when protocol is not L3_DEFAULT.
               A single port or a comma separated list of ports can be configured.
               Only packets addressed to these ports will be forwarded to the backends
               configured with this forwarding rule.
               You can only use one of ports and portRange, or allPorts.
               The three are mutually exclusive.
               You may specify a maximum of up to 5 ports, which can be non-contiguous.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: A reference to the region where the regional forwarding rule resides.
               This field is not applicable to global forwarding rules.
        :param pulumi.Input[str] service_label: An optional prefix to the service name for this Forwarding Rule.
               If specified, will be the first label of the fully qualified service
               name.
               The label must be 1-63 characters long, and comply with RFC1035.
               Specifically, the label must be 1-63 characters long and match the
               regular expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters
               must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
               This field is only used for INTERNAL load balancing.
        :param pulumi.Input[str] subnetwork: The subnetwork that the load balanced IP should belong to for this
               Forwarding Rule.  This field is only used for INTERNAL load balancing.
               If the network specified is in auto subnet mode, this field is
               optional. However, if the network is in custom subnet mode, a
               subnetwork must be specified.
        :param pulumi.Input[str] target: The URL of the target resource to receive the matched traffic.
               The target must live in the same region as the forwarding rule.
               The forwarded traffic must be of a type appropriate to the target
               object.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ForwardingRuleArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A ForwardingRule resource. A ForwardingRule resource specifies which pool
        of target virtual machines to forward a packet to if it matches the given
        [IPAddress, IPProtocol, portRange] tuple.

        To get more information about ForwardingRule, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/v1/forwardingRules)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/compute/docs/load-balancing/network/forwarding-rules)

        ## Example Usage
        ### Internal Http Lb With Mig Backend

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # Internal HTTP load balancer with a managed instance group backend
        # VPC
        ilb_network = gcp.compute.Network("ilbNetwork", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        # proxy-only subnet
        proxy_subnet = gcp.compute.Subnetwork("proxySubnet",
            ip_cidr_range="10.0.0.0/24",
            region="europe-west1",
            purpose="INTERNAL_HTTPS_LOAD_BALANCER",
            role="ACTIVE",
            network=ilb_network.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        # backed subnet
        ilb_subnet = gcp.compute.Subnetwork("ilbSubnet",
            ip_cidr_range="10.0.1.0/24",
            region="europe-west1",
            network=ilb_network.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        # health check
        default_region_health_check = gcp.compute.RegionHealthCheck("defaultRegionHealthCheck",
            region="europe-west1",
            http_health_check=gcp.compute.RegionHealthCheckHttpHealthCheckArgs(
                port_specification="USE_SERVING_PORT",
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        # instance template
        instance_template = gcp.compute.InstanceTemplate("instanceTemplate",
            machine_type="e2-small",
            tags=["http-server"],
            network_interfaces=[gcp.compute.InstanceTemplateNetworkInterfaceArgs(
                network=ilb_network.id,
                subnetwork=ilb_subnet.id,
                access_configs=[gcp.compute.InstanceTemplateNetworkInterfaceAccessConfigArgs()],
            )],
            disks=[gcp.compute.InstanceTemplateDiskArgs(
                source_image="debian-cloud/debian-10",
                auto_delete=True,
                boot=True,
            )],
            metadata={
                "startup-script": \"\"\"#! /bin/bash
        set -euo pipefail

        export DEBIAN_FRONTEND=noninteractive
        apt-get update
        apt-get install -y nginx-light jq

        NAME=$(curl -H "Metadata-Flavor: Google" "http://metadata.google.internal/computeMetadata/v1/instance/hostname")
        IP=$(curl -H "Metadata-Flavor: Google" "http://metadata.google.internal/computeMetadata/v1/instance/network-interfaces/0/ip")
        METADATA=$(curl -f -H "Metadata-Flavor: Google" "http://metadata.google.internal/computeMetadata/v1/instance/attributes/?recursive=True" | jq 'del(.["startup-script"])')

        cat <<EOF > /var/www/html/index.html
        <pre>
        Name: $NAME
        IP: $IP
        Metadata: $METADATA
        </pre>
        EOF
        \"\"\",
            },
            opts=pulumi.ResourceOptions(provider=google_beta))
        # MIG
        mig = gcp.compute.RegionInstanceGroupManager("mig",
            region="europe-west1",
            versions=[gcp.compute.RegionInstanceGroupManagerVersionArgs(
                instance_template=instance_template.id,
                name="primary",
            )],
            base_instance_name="vm",
            target_size=2,
            opts=pulumi.ResourceOptions(provider=google_beta))
        # backend service
        default_region_backend_service = gcp.compute.RegionBackendService("defaultRegionBackendService",
            region="europe-west1",
            protocol="HTTP",
            load_balancing_scheme="INTERNAL_MANAGED",
            timeout_sec=10,
            health_checks=[default_region_health_check.id],
            backends=[gcp.compute.RegionBackendServiceBackendArgs(
                group=mig.instance_group,
                balancing_mode="UTILIZATION",
                capacity_scaler=1,
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        # url map
        default_region_url_map = gcp.compute.RegionUrlMap("defaultRegionUrlMap",
            region="europe-west1",
            default_service=default_region_backend_service.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        # http proxy
        default_region_target_http_proxy = gcp.compute.RegionTargetHttpProxy("defaultRegionTargetHttpProxy",
            region="europe-west1",
            url_map=default_region_url_map.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        # forwarding rule
        google_compute_forwarding_rule = gcp.compute.ForwardingRule("googleComputeForwardingRule",
            region="europe-west1",
            ip_protocol="TCP",
            load_balancing_scheme="INTERNAL_MANAGED",
            port_range="80",
            target=default_region_target_http_proxy.id,
            network=ilb_network.id,
            subnetwork=ilb_subnet.id,
            network_tier="PREMIUM",
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[proxy_subnet]))
        # allow all access from IAP and health check ranges
        fw_iap = gcp.compute.Firewall("fw-iap",
            direction="INGRESS",
            network=ilb_network.id,
            source_ranges=[
                "130.211.0.0/22",
                "35.191.0.0/16",
                "35.235.240.0/20",
            ],
            allows=[gcp.compute.FirewallAllowArgs(
                protocol="tcp",
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        # allow http from proxy subnet to backends
        fw_ilb_to_backends = gcp.compute.Firewall("fw-ilb-to-backends",
            direction="INGRESS",
            network=ilb_network.id,
            source_ranges=["10.0.0.0/24"],
            target_tags=["http-server"],
            allows=[gcp.compute.FirewallAllowArgs(
                protocol="tcp",
                ports=[
                    "80",
                    "443",
                    "8080",
                ],
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        # test instance
        vm_test = gcp.compute.Instance("vm-test",
            zone="europe-west1-b",
            machine_type="e2-small",
            network_interfaces=[gcp.compute.InstanceNetworkInterfaceArgs(
                network=ilb_network.id,
                subnetwork=ilb_subnet.id,
            )],
            boot_disk=gcp.compute.InstanceBootDiskArgs(
                initialize_params=gcp.compute.InstanceBootDiskInitializeParamsArgs(
                    image="debian-cloud/debian-10",
                ),
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Internal Tcp Udp Lb With Mig Backend

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # Internal TCP/UDP load balancer with a managed instance group backend
        # VPC
        ilb_network = gcp.compute.Network("ilbNetwork", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        # backed subnet
        ilb_subnet = gcp.compute.Subnetwork("ilbSubnet",
            ip_cidr_range="10.0.1.0/24",
            region="europe-west1",
            network=ilb_network.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        # health check
        default_region_health_check = gcp.compute.RegionHealthCheck("defaultRegionHealthCheck",
            region="europe-west1",
            http_health_check=gcp.compute.RegionHealthCheckHttpHealthCheckArgs(
                port=80,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        # instance template
        instance_template = gcp.compute.InstanceTemplate("instanceTemplate",
            machine_type="e2-small",
            tags=[
                "allow-ssh",
                "allow-health-check",
            ],
            network_interfaces=[gcp.compute.InstanceTemplateNetworkInterfaceArgs(
                network=ilb_network.id,
                subnetwork=ilb_subnet.id,
                access_configs=[gcp.compute.InstanceTemplateNetworkInterfaceAccessConfigArgs()],
            )],
            disks=[gcp.compute.InstanceTemplateDiskArgs(
                source_image="debian-cloud/debian-10",
                auto_delete=True,
                boot=True,
            )],
            metadata={
                "startup-script": \"\"\"#! /bin/bash
        set -euo pipefail

        export DEBIAN_FRONTEND=noninteractive
        apt-get update
        apt-get install -y nginx-light jq

        NAME=$(curl -H "Metadata-Flavor: Google" "http://metadata.google.internal/computeMetadata/v1/instance/hostname")
        IP=$(curl -H "Metadata-Flavor: Google" "http://metadata.google.internal/computeMetadata/v1/instance/network-interfaces/0/ip")
        METADATA=$(curl -f -H "Metadata-Flavor: Google" "http://metadata.google.internal/computeMetadata/v1/instance/attributes/?recursive=True" | jq 'del(.["startup-script"])')

        cat <<EOF > /var/www/html/index.html
        <pre>
        Name: $NAME
        IP: $IP
        Metadata: $METADATA
        </pre>
        EOF
        \"\"\",
            },
            opts=pulumi.ResourceOptions(provider=google_beta))
        # MIG
        mig = gcp.compute.RegionInstanceGroupManager("mig",
            region="europe-west1",
            versions=[gcp.compute.RegionInstanceGroupManagerVersionArgs(
                instance_template=instance_template.id,
                name="primary",
            )],
            base_instance_name="vm",
            target_size=2,
            opts=pulumi.ResourceOptions(provider=google_beta))
        # backend service
        default_region_backend_service = gcp.compute.RegionBackendService("defaultRegionBackendService",
            region="europe-west1",
            protocol="TCP",
            load_balancing_scheme="INTERNAL",
            health_checks=[default_region_health_check.id],
            backends=[gcp.compute.RegionBackendServiceBackendArgs(
                group=mig.instance_group,
                balancing_mode="CONNECTION",
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        # forwarding rule
        google_compute_forwarding_rule = gcp.compute.ForwardingRule("googleComputeForwardingRule",
            backend_service=default_region_backend_service.id,
            region="europe-west1",
            ip_protocol="TCP",
            load_balancing_scheme="INTERNAL",
            all_ports=True,
            allow_global_access=True,
            network=ilb_network.id,
            subnetwork=ilb_subnet.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        # allow all access from health check ranges
        fw_hc = gcp.compute.Firewall("fwHc",
            direction="INGRESS",
            network=ilb_network.id,
            source_ranges=[
                "130.211.0.0/22",
                "35.191.0.0/16",
                "35.235.240.0/20",
            ],
            allows=[gcp.compute.FirewallAllowArgs(
                protocol="tcp",
            )],
            source_tags=["allow-health-check"],
            opts=pulumi.ResourceOptions(provider=google_beta))
        # allow communication within the subnet 
        fw_ilb_to_backends = gcp.compute.Firewall("fwIlbToBackends",
            direction="INGRESS",
            network=ilb_network.id,
            source_ranges=["10.0.1.0/24"],
            allows=[
                gcp.compute.FirewallAllowArgs(
                    protocol="tcp",
                ),
                gcp.compute.FirewallAllowArgs(
                    protocol="udp",
                ),
                gcp.compute.FirewallAllowArgs(
                    protocol="icmp",
                ),
            ],
            opts=pulumi.ResourceOptions(provider=google_beta))
        # allow SSH
        fw_ilb_ssh = gcp.compute.Firewall("fwIlbSsh",
            direction="INGRESS",
            network=ilb_network.id,
            allows=[gcp.compute.FirewallAllowArgs(
                protocol="tcp",
                ports=["22"],
            )],
            source_tags=["allow-ssh"],
            opts=pulumi.ResourceOptions(provider=google_beta))
        # test instance
        vm_test = gcp.compute.Instance("vmTest",
            zone="europe-west1-b",
            machine_type="e2-small",
            network_interfaces=[gcp.compute.InstanceNetworkInterfaceArgs(
                network=ilb_network.id,
                subnetwork=ilb_subnet.id,
            )],
            boot_disk=gcp.compute.InstanceBootDiskArgs(
                initialize_params=gcp.compute.InstanceBootDiskInitializeParamsArgs(
                    image="debian-cloud/debian-10",
                ),
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Forwarding Rule Externallb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        hc = gcp.compute.RegionHealthCheck("hc",
            check_interval_sec=1,
            timeout_sec=1,
            region="us-central1",
            tcp_health_check=gcp.compute.RegionHealthCheckTcpHealthCheckArgs(
                port=80,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        backend = gcp.compute.RegionBackendService("backend",
            region="us-central1",
            load_balancing_scheme="EXTERNAL",
            health_checks=[hc.id],
            opts=pulumi.ResourceOptions(provider=google_beta))
        # Forwarding rule for External Network Load Balancing using Backend Services
        default = gcp.compute.ForwardingRule("default",
            region="us-central1",
            port_range="80",
            backend_service=backend.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Forwarding Rule Global Internallb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        hc = gcp.compute.HealthCheck("hc",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check=gcp.compute.HealthCheckTcpHealthCheckArgs(
                port=80,
            ))
        backend = gcp.compute.RegionBackendService("backend",
            region="us-central1",
            health_checks=[hc.id])
        default_network = gcp.compute.Network("defaultNetwork", auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("defaultSubnetwork",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=default_network.id)
        # Forwarding rule for Internal Load Balancing
        default_forwarding_rule = gcp.compute.ForwardingRule("defaultForwardingRule",
            region="us-central1",
            load_balancing_scheme="INTERNAL",
            backend_service=backend.id,
            all_ports=True,
            allow_global_access=True,
            network=default_network.name,
            subnetwork=default_subnetwork.name)
        ```
        ### Forwarding Rule Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_target_pool = gcp.compute.TargetPool("defaultTargetPool")
        default_forwarding_rule = gcp.compute.ForwardingRule("defaultForwardingRule",
            target=default_target_pool.id,
            port_range="80")
        ```
        ### Forwarding Rule L3 Default

        ```python
        import pulumi
        import pulumi_gcp as gcp

        health_check = gcp.compute.RegionHealthCheck("healthCheck",
            region="us-central1",
            tcp_health_check=gcp.compute.RegionHealthCheckTcpHealthCheckArgs(
                port=80,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        service = gcp.compute.RegionBackendService("service",
            region="us-central1",
            health_checks=[health_check.id],
            protocol="UNSPECIFIED",
            load_balancing_scheme="EXTERNAL",
            opts=pulumi.ResourceOptions(provider=google_beta))
        fwd_rule = gcp.compute.ForwardingRule("fwdRule",
            backend_service=service.id,
            ip_protocol="L3_DEFAULT",
            all_ports=True,
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Forwarding Rule Internallb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        hc = gcp.compute.HealthCheck("hc",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check=gcp.compute.HealthCheckTcpHealthCheckArgs(
                port=80,
            ))
        backend = gcp.compute.RegionBackendService("backend",
            region="us-central1",
            health_checks=[hc.id])
        default_network = gcp.compute.Network("defaultNetwork", auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("defaultSubnetwork",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=default_network.id)
        # Forwarding rule for Internal Load Balancing
        default_forwarding_rule = gcp.compute.ForwardingRule("defaultForwardingRule",
            region="us-central1",
            load_balancing_scheme="INTERNAL",
            backend_service=backend.id,
            all_ports=True,
            network=default_network.name,
            subnetwork=default_subnetwork.name)
        ```
        ### Forwarding Rule Http Lb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        debian_image = gcp.compute.get_image(family="debian-9",
            project="debian-cloud")
        default_network = gcp.compute.Network("defaultNetwork",
            auto_create_subnetworks=False,
            routing_mode="REGIONAL",
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_subnetwork = gcp.compute.Subnetwork("defaultSubnetwork",
            ip_cidr_range="10.1.2.0/24",
            region="us-central1",
            network=default_network.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        instance_template = gcp.compute.InstanceTemplate("instanceTemplate",
            machine_type="e2-medium",
            network_interfaces=[gcp.compute.InstanceTemplateNetworkInterfaceArgs(
                network=default_network.id,
                subnetwork=default_subnetwork.id,
            )],
            disks=[gcp.compute.InstanceTemplateDiskArgs(
                source_image=debian_image.self_link,
                auto_delete=True,
                boot=True,
            )],
            tags=[
                "allow-ssh",
                "load-balanced-backend",
            ],
            opts=pulumi.ResourceOptions(provider=google_beta))
        rigm = gcp.compute.RegionInstanceGroupManager("rigm",
            region="us-central1",
            versions=[gcp.compute.RegionInstanceGroupManagerVersionArgs(
                instance_template=instance_template.id,
                name="primary",
            )],
            base_instance_name="internal-glb",
            target_size=1,
            opts=pulumi.ResourceOptions(provider=google_beta))
        fw1 = gcp.compute.Firewall("fw1",
            network=default_network.id,
            source_ranges=["10.1.2.0/24"],
            allows=[
                gcp.compute.FirewallAllowArgs(
                    protocol="tcp",
                ),
                gcp.compute.FirewallAllowArgs(
                    protocol="udp",
                ),
                gcp.compute.FirewallAllowArgs(
                    protocol="icmp",
                ),
            ],
            direction="INGRESS",
            opts=pulumi.ResourceOptions(provider=google_beta))
        fw2 = gcp.compute.Firewall("fw2",
            network=default_network.id,
            source_ranges=["0.0.0.0/0"],
            allows=[gcp.compute.FirewallAllowArgs(
                protocol="tcp",
                ports=["22"],
            )],
            target_tags=["allow-ssh"],
            direction="INGRESS",
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[fw1]))
        fw3 = gcp.compute.Firewall("fw3",
            network=default_network.id,
            source_ranges=[
                "130.211.0.0/22",
                "35.191.0.0/16",
            ],
            allows=[gcp.compute.FirewallAllowArgs(
                protocol="tcp",
            )],
            target_tags=["load-balanced-backend"],
            direction="INGRESS",
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[fw2]))
        fw4 = gcp.compute.Firewall("fw4",
            network=default_network.id,
            source_ranges=["10.129.0.0/26"],
            target_tags=["load-balanced-backend"],
            allows=[
                gcp.compute.FirewallAllowArgs(
                    protocol="tcp",
                    ports=["80"],
                ),
                gcp.compute.FirewallAllowArgs(
                    protocol="tcp",
                    ports=["443"],
                ),
                gcp.compute.FirewallAllowArgs(
                    protocol="tcp",
                    ports=["8000"],
                ),
            ],
            direction="INGRESS",
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[fw3]))
        default_region_health_check = gcp.compute.RegionHealthCheck("defaultRegionHealthCheck",
            region="us-central1",
            http_health_check=gcp.compute.RegionHealthCheckHttpHealthCheckArgs(
                port_specification="USE_SERVING_PORT",
            ),
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[fw4]))
        default_region_backend_service = gcp.compute.RegionBackendService("defaultRegionBackendService",
            load_balancing_scheme="INTERNAL_MANAGED",
            backends=[gcp.compute.RegionBackendServiceBackendArgs(
                group=rigm.instance_group,
                balancing_mode="UTILIZATION",
                capacity_scaler=1,
            )],
            region="us-central1",
            protocol="HTTP",
            timeout_sec=10,
            health_checks=[default_region_health_check.id],
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_region_url_map = gcp.compute.RegionUrlMap("defaultRegionUrlMap",
            region="us-central1",
            default_service=default_region_backend_service.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_region_target_http_proxy = gcp.compute.RegionTargetHttpProxy("defaultRegionTargetHttpProxy",
            region="us-central1",
            url_map=default_region_url_map.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        proxy = gcp.compute.Subnetwork("proxy",
            ip_cidr_range="10.129.0.0/26",
            region="us-central1",
            network=default_network.id,
            purpose="INTERNAL_HTTPS_LOAD_BALANCER",
            role="ACTIVE",
            opts=pulumi.ResourceOptions(provider=google_beta))
        # Forwarding rule for Internal Load Balancing
        default_forwarding_rule = gcp.compute.ForwardingRule("defaultForwardingRule",
            region="us-central1",
            ip_protocol="TCP",
            load_balancing_scheme="INTERNAL_MANAGED",
            port_range="80",
            target=default_region_target_http_proxy.id,
            network=default_network.id,
            subnetwork=default_subnetwork.id,
            network_tier="PREMIUM",
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[proxy]))
        ```

        ## Import

        ForwardingRule can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/forwardingRule:ForwardingRule default projects/{{project}}/regions/{{region}}/forwardingRules/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/forwardingRule:ForwardingRule default {{project}}/{{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/forwardingRule:ForwardingRule default {{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/forwardingRule:ForwardingRule default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ForwardingRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ForwardingRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 all_ports: Optional[pulumi.Input[bool]] = None,
                 allow_global_access: Optional[pulumi.Input[bool]] = None,
                 backend_service: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 ip_protocol: Optional[pulumi.Input[str]] = None,
                 is_mirroring_collector: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 network_tier: Optional[pulumi.Input[str]] = None,
                 port_range: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_label: Optional[pulumi.Input[str]] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ForwardingRuleArgs.__new__(ForwardingRuleArgs)

            __props__.__dict__["all_ports"] = all_ports
            __props__.__dict__["allow_global_access"] = allow_global_access
            __props__.__dict__["backend_service"] = backend_service
            __props__.__dict__["description"] = description
            __props__.__dict__["ip_address"] = ip_address
            __props__.__dict__["ip_protocol"] = ip_protocol
            __props__.__dict__["is_mirroring_collector"] = is_mirroring_collector
            __props__.__dict__["labels"] = labels
            __props__.__dict__["load_balancing_scheme"] = load_balancing_scheme
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            __props__.__dict__["network_tier"] = network_tier
            __props__.__dict__["port_range"] = port_range
            __props__.__dict__["ports"] = ports
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["service_label"] = service_label
            __props__.__dict__["subnetwork"] = subnetwork
            __props__.__dict__["target"] = target
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["label_fingerprint"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["service_name"] = None
        super(ForwardingRule, __self__).__init__(
            'gcp:compute/forwardingRule:ForwardingRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            all_ports: Optional[pulumi.Input[bool]] = None,
            allow_global_access: Optional[pulumi.Input[bool]] = None,
            backend_service: Optional[pulumi.Input[str]] = None,
            creation_timestamp: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            ip_protocol: Optional[pulumi.Input[str]] = None,
            is_mirroring_collector: Optional[pulumi.Input[bool]] = None,
            label_fingerprint: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            load_balancing_scheme: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network: Optional[pulumi.Input[str]] = None,
            network_tier: Optional[pulumi.Input[str]] = None,
            port_range: Optional[pulumi.Input[str]] = None,
            ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            project: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            service_label: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            subnetwork: Optional[pulumi.Input[str]] = None,
            target: Optional[pulumi.Input[str]] = None) -> 'ForwardingRule':
        """
        Get an existing ForwardingRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] all_ports: This field can be used with internal load balancer or network load balancer
               when the forwarding rule references a backend service, or with the target
               field when it references a TargetInstance. Set this to true to
               allow packets addressed to any ports to be forwarded to the backends configured
               with this forwarding rule. This can be used when the protocol is TCP/UDP, and it
               must be set to true when the protocol is set to L3_DEFAULT.
               Cannot be set if port or portRange are set.
        :param pulumi.Input[bool] allow_global_access: If true, clients can access ILB from all regions.
               Otherwise only allows from the local region the ILB is located at.
        :param pulumi.Input[str] backend_service: A BackendService to receive the matched traffic. This is used only
               for INTERNAL load balancing.
        :param pulumi.Input[str] creation_timestamp: [Output Only] Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[str] ip_address: The IP address that this forwarding rule serves. When a client sends
               traffic to this IP address, the forwarding rule directs the traffic to
               the target that you specify in the forwarding rule. The
               loadBalancingScheme and the forwarding rule's target determine the
               type of IP address that you can use. For detailed information, refer
               to [IP address specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               An address can be specified either by a literal IP address or a
               reference to an existing Address resource. If you don't specify a
               reserved IP address, an ephemeral IP address is assigned.
               The value must be set to 0.0.0.0 when the target is a targetGrpcProxy
               that has validateForProxyless field set to true.
               For Private Service Connect forwarding rules that forward traffic to
               Google APIs, IP address must be provided.
        :param pulumi.Input[str] ip_protocol: The IP protocol to which this rule applies.
               When the load balancing scheme is INTERNAL, only TCP and UDP are
               valid.
               Possible values are `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`, and `L3_DEFAULT`.
        :param pulumi.Input[bool] is_mirroring_collector: Indicates whether or not this load balancer can be used
               as a collector for packet mirroring. To prevent mirroring loops,
               instances behind this load balancer will not have their traffic
               mirrored even if a PacketMirroring rule applies to them. This
               can only be set to true for load balancers that have their
               loadBalancingScheme set to INTERNAL.
        :param pulumi.Input[str] label_fingerprint: Used internally during label updates.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this forwarding rule.  A list of key->value pairs.
        :param pulumi.Input[str] load_balancing_scheme: This signifies what the ForwardingRule will be used for and can be
               EXTERNAL, INTERNAL, or INTERNAL_MANAGED. EXTERNAL is used for Classic
               Cloud VPN gateways, protocol forwarding to VMs from an external IP address,
               and HTTP(S), SSL Proxy, TCP Proxy, and Network TCP/UDP load balancers.
               INTERNAL is used for protocol forwarding to VMs from an internal IP address,
               and internal TCP/UDP load balancers.
               INTERNAL_MANAGED is used for internal HTTP(S) load balancers.
               Default value is `EXTERNAL`.
               Possible values are `EXTERNAL`, `INTERNAL`, and `INTERNAL_MANAGED`.
        :param pulumi.Input[str] name: Name of the resource; provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[str] network: For internal load balancing, this field identifies the network that
               the load balanced IP should belong to for this Forwarding Rule. If
               this field is not specified, the default network will be used.
               This field is only used for INTERNAL load balancing.
        :param pulumi.Input[str] network_tier: The networking tier used for configuring this address. If this field is not
               specified, it is assumed to be PREMIUM.
               Possible values are `PREMIUM` and `STANDARD`.
        :param pulumi.Input[str] port_range: This field is used along with the target field for TargetHttpProxy,
               TargetHttpsProxy, TargetSslProxy, TargetTcpProxy, TargetVpnGateway,
               TargetPool, TargetInstance.
               Applicable only when IPProtocol is TCP, UDP, or SCTP, only packets
               addressed to ports in the specified range will be forwarded to target.
               Forwarding rules with the same [IPAddress, IPProtocol] pair must have
               disjoint port ranges.
               Some types of forwarding target have constraints on the acceptable
               ports:
               * TargetHttpProxy: 80, 8080
               * TargetHttpsProxy: 443
               * TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
               1883, 5222
               * TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
               1883, 5222
               * TargetVpnGateway: 500, 4500
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ports: This field is used along with internal load balancing and network
               load balancer when the forwarding rule references a backend service
               and when protocol is not L3_DEFAULT.
               A single port or a comma separated list of ports can be configured.
               Only packets addressed to these ports will be forwarded to the backends
               configured with this forwarding rule.
               You can only use one of ports and portRange, or allPorts.
               The three are mutually exclusive.
               You may specify a maximum of up to 5 ports, which can be non-contiguous.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: A reference to the region where the regional forwarding rule resides.
               This field is not applicable to global forwarding rules.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] service_label: An optional prefix to the service name for this Forwarding Rule.
               If specified, will be the first label of the fully qualified service
               name.
               The label must be 1-63 characters long, and comply with RFC1035.
               Specifically, the label must be 1-63 characters long and match the
               regular expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters
               must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
               This field is only used for INTERNAL load balancing.
        :param pulumi.Input[str] service_name: [Output Only] The internal fully qualified service name for this Forwarding Rule. This field is only used for internal
               load balancing.
        :param pulumi.Input[str] subnetwork: The subnetwork that the load balanced IP should belong to for this
               Forwarding Rule.  This field is only used for INTERNAL load balancing.
               If the network specified is in auto subnet mode, this field is
               optional. However, if the network is in custom subnet mode, a
               subnetwork must be specified.
        :param pulumi.Input[str] target: The URL of the target resource to receive the matched traffic.
               The target must live in the same region as the forwarding rule.
               The forwarded traffic must be of a type appropriate to the target
               object.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ForwardingRuleState.__new__(_ForwardingRuleState)

        __props__.__dict__["all_ports"] = all_ports
        __props__.__dict__["allow_global_access"] = allow_global_access
        __props__.__dict__["backend_service"] = backend_service
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["ip_protocol"] = ip_protocol
        __props__.__dict__["is_mirroring_collector"] = is_mirroring_collector
        __props__.__dict__["label_fingerprint"] = label_fingerprint
        __props__.__dict__["labels"] = labels
        __props__.__dict__["load_balancing_scheme"] = load_balancing_scheme
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["network_tier"] = network_tier
        __props__.__dict__["port_range"] = port_range
        __props__.__dict__["ports"] = ports
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["service_label"] = service_label
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["subnetwork"] = subnetwork
        __props__.__dict__["target"] = target
        return ForwardingRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allPorts")
    def all_ports(self) -> pulumi.Output[Optional[bool]]:
        """
        This field can be used with internal load balancer or network load balancer
        when the forwarding rule references a backend service, or with the target
        field when it references a TargetInstance. Set this to true to
        allow packets addressed to any ports to be forwarded to the backends configured
        with this forwarding rule. This can be used when the protocol is TCP/UDP, and it
        must be set to true when the protocol is set to L3_DEFAULT.
        Cannot be set if port or portRange are set.
        """
        return pulumi.get(self, "all_ports")

    @property
    @pulumi.getter(name="allowGlobalAccess")
    def allow_global_access(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, clients can access ILB from all regions.
        Otherwise only allows from the local region the ILB is located at.
        """
        return pulumi.get(self, "allow_global_access")

    @property
    @pulumi.getter(name="backendService")
    def backend_service(self) -> pulumi.Output[Optional[str]]:
        """
        A BackendService to receive the matched traffic. This is used only
        for INTERNAL load balancing.
        """
        return pulumi.get(self, "backend_service")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[str]:
        """
        [Output Only] Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        The IP address that this forwarding rule serves. When a client sends
        traffic to this IP address, the forwarding rule directs the traffic to
        the target that you specify in the forwarding rule. The
        loadBalancingScheme and the forwarding rule's target determine the
        type of IP address that you can use. For detailed information, refer
        to [IP address specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
        An address can be specified either by a literal IP address or a
        reference to an existing Address resource. If you don't specify a
        reserved IP address, an ephemeral IP address is assigned.
        The value must be set to 0.0.0.0 when the target is a targetGrpcProxy
        that has validateForProxyless field set to true.
        For Private Service Connect forwarding rules that forward traffic to
        Google APIs, IP address must be provided.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> pulumi.Output[str]:
        """
        The IP protocol to which this rule applies.
        When the load balancing scheme is INTERNAL, only TCP and UDP are
        valid.
        Possible values are `TCP`, `UDP`, `ESP`, `AH`, `SCTP`, `ICMP`, and `L3_DEFAULT`.
        """
        return pulumi.get(self, "ip_protocol")

    @property
    @pulumi.getter(name="isMirroringCollector")
    def is_mirroring_collector(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether or not this load balancer can be used
        as a collector for packet mirroring. To prevent mirroring loops,
        instances behind this load balancer will not have their traffic
        mirrored even if a PacketMirroring rule applies to them. This
        can only be set to true for load balancers that have their
        loadBalancingScheme set to INTERNAL.
        """
        return pulumi.get(self, "is_mirroring_collector")

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> pulumi.Output[str]:
        """
        Used internally during label updates.
        """
        return pulumi.get(self, "label_fingerprint")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Labels to apply to this forwarding rule.  A list of key->value pairs.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> pulumi.Output[Optional[str]]:
        """
        This signifies what the ForwardingRule will be used for and can be
        EXTERNAL, INTERNAL, or INTERNAL_MANAGED. EXTERNAL is used for Classic
        Cloud VPN gateways, protocol forwarding to VMs from an external IP address,
        and HTTP(S), SSL Proxy, TCP Proxy, and Network TCP/UDP load balancers.
        INTERNAL is used for protocol forwarding to VMs from an internal IP address,
        and internal TCP/UDP load balancers.
        INTERNAL_MANAGED is used for internal HTTP(S) load balancers.
        Default value is `EXTERNAL`.
        Possible values are `EXTERNAL`, `INTERNAL`, and `INTERNAL_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource; provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[str]:
        """
        For internal load balancing, this field identifies the network that
        the load balanced IP should belong to for this Forwarding Rule. If
        this field is not specified, the default network will be used.
        This field is only used for INTERNAL load balancing.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="networkTier")
    def network_tier(self) -> pulumi.Output[str]:
        """
        The networking tier used for configuring this address. If this field is not
        specified, it is assumed to be PREMIUM.
        Possible values are `PREMIUM` and `STANDARD`.
        """
        return pulumi.get(self, "network_tier")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> pulumi.Output[Optional[str]]:
        """
        This field is used along with the target field for TargetHttpProxy,
        TargetHttpsProxy, TargetSslProxy, TargetTcpProxy, TargetVpnGateway,
        TargetPool, TargetInstance.
        Applicable only when IPProtocol is TCP, UDP, or SCTP, only packets
        addressed to ports in the specified range will be forwarded to target.
        Forwarding rules with the same [IPAddress, IPProtocol] pair must have
        disjoint port ranges.
        Some types of forwarding target have constraints on the acceptable
        ports:
        * TargetHttpProxy: 80, 8080
        * TargetHttpsProxy: 443
        * TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
        1883, 5222
        * TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995,
        1883, 5222
        * TargetVpnGateway: 500, 4500
        """
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter
    def ports(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        This field is used along with internal load balancing and network
        load balancer when the forwarding rule references a backend service
        and when protocol is not L3_DEFAULT.
        A single port or a comma separated list of ports can be configured.
        Only packets addressed to these ports will be forwarded to the backends
        configured with this forwarding rule.
        You can only use one of ports and portRange, or allPorts.
        The three are mutually exclusive.
        You may specify a maximum of up to 5 ports, which can be non-contiguous.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        A reference to the region where the regional forwarding rule resides.
        This field is not applicable to global forwarding rules.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="serviceLabel")
    def service_label(self) -> pulumi.Output[Optional[str]]:
        """
        An optional prefix to the service name for this Forwarding Rule.
        If specified, will be the first label of the fully qualified service
        name.
        The label must be 1-63 characters long, and comply with RFC1035.
        Specifically, the label must be 1-63 characters long and match the
        regular expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters
        must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        This field is only used for INTERNAL load balancing.
        """
        return pulumi.get(self, "service_label")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        [Output Only] The internal fully qualified service name for this Forwarding Rule. This field is only used for internal
        load balancing.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def subnetwork(self) -> pulumi.Output[str]:
        """
        The subnetwork that the load balanced IP should belong to for this
        Forwarding Rule.  This field is only used for INTERNAL load balancing.
        If the network specified is in auto subnet mode, this field is
        optional. However, if the network is in custom subnet mode, a
        subnetwork must be specified.
        """
        return pulumi.get(self, "subnetwork")

    @property
    @pulumi.getter
    def target(self) -> pulumi.Output[Optional[str]]:
        """
        The URL of the target resource to receive the matched traffic.
        The target must live in the same region as the forwarding rule.
        The forwarded traffic must be of a type appropriate to the target
        object.
        """
        return pulumi.get(self, "target")

