'''
MIT License

Copyright (c) 2017-2020, Mayple.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
'''

# Based on https://developers.facebook.com/docs/marketing-api/reference/ad-account/timezone-ids/v7.0

# 1 -> TZ_AMERICA_LOS_ANGELES
facebookTimezoneIdToTimezoneCode = {
    0: 'TZ_UNKNOWN',
    1: 'TZ_AMERICA_LOS_ANGELES',
    2: 'TZ_AMERICA_DENVER',
    3: 'TZ_PACIFIC_HONOLULU',
    4: 'TZ_AMERICA_ANCHORAGE',
    5: 'TZ_AMERICA_PHOENIX',
    6: 'TZ_AMERICA_CHICAGO',
    7: 'TZ_AMERICA_NEW_YORK',
    8: 'TZ_ASIA_DUBAI',
    9: 'TZ_AMERICA_ARGENTINA_SAN_LUIS',
    10: 'TZ_AMERICA_ARGENTINA_BUENOS_AIRES',
    11: 'TZ_AMERICA_ARGENTINA_SALTA',
    12: 'TZ_EUROPE_VIENNA',
    13: 'TZ_AUSTRALIA_PERTH',
    14: 'TZ_AUSTRALIA_BROKEN_HILL',
    15: 'TZ_AUSTRALIA_SYDNEY',
    16: 'TZ_EUROPE_SARAJEVO',
    17: 'TZ_ASIA_DHAKA',
    18: 'TZ_EUROPE_BRUSSELS',
    19: 'TZ_EUROPE_SOFIA',
    20: 'TZ_ASIA_BAHRAIN',
    21: 'TZ_AMERICA_LA_PAZ',
    22: 'TZ_AMERICA_NORONHA',
    23: 'TZ_AMERICA_CAMPO_GRANDE',
    24: 'TZ_AMERICA_BELEM',
    25: 'TZ_AMERICA_SAO_PAULO',
    26: 'TZ_AMERICA_NASSAU',
    27: 'TZ_AMERICA_DAWSON',
    28: 'TZ_AMERICA_VANCOUVER',
    29: 'TZ_AMERICA_DAWSON_CREEK',
    30: 'TZ_AMERICA_EDMONTON',
    31: 'TZ_AMERICA_RAINY_RIVER',
    32: 'TZ_AMERICA_REGINA',
    33: 'TZ_AMERICA_ATIKOKAN',
    34: 'TZ_AMERICA_IQALUIT',
    35: 'TZ_AMERICA_TORONTO',
    36: 'TZ_AMERICA_BLANC_SABLON',
    37: 'TZ_AMERICA_HALIFAX',
    38: 'TZ_AMERICA_ST_JOHNS',
    39: 'TZ_EUROPE_ZURICH',
    40: 'TZ_PACIFIC_EASTER',
    41: 'TZ_AMERICA_SANTIAGO',
    42: 'TZ_ASIA_SHANGHAI',
    43: 'TZ_AMERICA_BOGOTA',
    44: 'TZ_AMERICA_COSTA_RICA',
    45: 'TZ_ASIA_NICOSIA',
    46: 'TZ_EUROPE_PRAGUE',
    47: 'TZ_EUROPE_BERLIN',
    48: 'TZ_EUROPE_COPENHAGEN',
    49: 'TZ_AMERICA_SANTO_DOMINGO',
    50: 'TZ_PACIFIC_GALAPAGOS',
    51: 'TZ_AMERICA_GUAYAQUIL',
    52: 'TZ_EUROPE_TALLINN',
    53: 'TZ_AFRICA_CAIRO',
    54: 'TZ_ATLANTIC_CANARY',
    55: 'TZ_EUROPE_MADRID',
    56: 'TZ_EUROPE_HELSINKI',
    57: 'TZ_EUROPE_PARIS',
    58: 'TZ_EUROPE_LONDON',
    59: 'TZ_AFRICA_ACCRA',
    60: 'TZ_EUROPE_ATHENS',
    61: 'TZ_AMERICA_GUATEMALA',
    62: 'TZ_ASIA_HONG_KONG',
    63: 'TZ_AMERICA_TEGUCIGALPA',
    64: 'TZ_EUROPE_ZAGREB',
    65: 'TZ_EUROPE_BUDAPEST',
    66: 'TZ_ASIA_JAKARTA',
    67: 'TZ_ASIA_MAKASSAR',
    68: 'TZ_ASIA_JAYAPURA',
    69: 'TZ_EUROPE_DUBLIN',
    70: 'TZ_ASIA_JERUSALEM',
    71: 'TZ_ASIA_KOLKATA',
    72: 'TZ_ASIA_BAGHDAD',
    73: 'TZ_ATLANTIC_REYKJAVIK',
    74: 'TZ_EUROPE_ROME',
    75: 'TZ_AMERICA_JAMAICA',
    76: 'TZ_ASIA_AMMAN',
    77: 'TZ_ASIA_TOKYO',
    78: 'TZ_AFRICA_NAIROBI',
    79: 'TZ_ASIA_SEOUL',
    80: 'TZ_ASIA_KUWAIT',
    81: 'TZ_ASIA_BEIRUT',
    82: 'TZ_ASIA_COLOMBO',
    83: 'TZ_EUROPE_VILNIUS',
    84: 'TZ_EUROPE_LUXEMBOURG',
    85: 'TZ_EUROPE_RIGA',
    86: 'TZ_AFRICA_CASABLANCA',
    87: 'TZ_EUROPE_SKOPJE',
    88: 'TZ_EUROPE_MALTA',
    89: 'TZ_INDIAN_MAURITIUS',
    90: 'TZ_INDIAN_MALDIVES',
    91: 'TZ_AMERICA_TIJUANA',
    92: 'TZ_AMERICA_HERMOSILLO',
    93: 'TZ_AMERICA_MAZATLAN',
    94: 'TZ_AMERICA_MEXICO_CITY',
    95: 'TZ_ASIA_KUALA_LUMPUR',
    96: 'TZ_AFRICA_LAGOS',
    97: 'TZ_AMERICA_MANAGUA',
    98: 'TZ_EUROPE_AMSTERDAM',
    99: 'TZ_EUROPE_OSLO',
    100: 'TZ_PACIFIC_AUCKLAND',
    101: 'TZ_ASIA_MUSCAT',
    102: 'TZ_AMERICA_PANAMA',
    103: 'TZ_AMERICA_LIMA',
    104: 'TZ_ASIA_MANILA',
    105: 'TZ_ASIA_KARACHI',
    106: 'TZ_EUROPE_WARSAW',
    107: 'TZ_AMERICA_PUERTO_RICO',
    108: 'TZ_ASIA_GAZA',
    109: 'TZ_ATLANTIC_AZORES',
    110: 'TZ_EUROPE_LISBON',
    111: 'TZ_AMERICA_ASUNCION',
    112: 'TZ_ASIA_QATAR',
    113: 'TZ_EUROPE_BUCHAREST',
    114: 'TZ_EUROPE_BELGRADE',
    115: 'TZ_EUROPE_KALININGRAD',
    116: 'TZ_EUROPE_MOSCOW',
    117: 'TZ_EUROPE_SAMARA',
    118: 'TZ_ASIA_YEKATERINBURG',
    119: 'TZ_ASIA_OMSK',
    120: 'TZ_ASIA_KRASNOYARSK',
    121: 'TZ_ASIA_IRKUTSK',
    122: 'TZ_ASIA_YAKUTSK',
    123: 'TZ_ASIA_VLADIVOSTOK',
    124: 'TZ_ASIA_MAGADAN',
    125: 'TZ_ASIA_KAMCHATKA',
    126: 'TZ_ASIA_RIYADH',
    127: 'TZ_EUROPE_STOCKHOLM',
    128: 'TZ_ASIA_SINGAPORE',
    129: 'TZ_EUROPE_LJUBLJANA',
    130: 'TZ_EUROPE_BRATISLAVA',
    131: 'TZ_AMERICA_EL_SALVADOR',
    132: 'TZ_ASIA_BANGKOK',
    133: 'TZ_AFRICA_TUNIS',
    134: 'TZ_EUROPE_ISTANBUL',
    135: 'TZ_AMERICA_PORT_OF_SPAIN',
    136: 'TZ_ASIA_TAIPEI',
    137: 'TZ_EUROPE_KIEV',
    138: 'TZ_AMERICA_MONTEVIDEO',
    139: 'TZ_AMERICA_CARACAS',
    140: 'TZ_ASIA_HO_CHI_MINH',
    141: 'TZ_AFRICA_JOHANNESBURG',
    142: 'TZ_AMERICA_WINNIPEG',
    143: 'TZ_AMERICA_DETROIT',
    144: 'TZ_AUSTRALIA_MELBOURNE',
    145: 'TZ_ASIA_KATHMANDU',
    146: 'TZ_ASIA_BAKU',
    147: 'TZ_AFRICA_ABIDJAN',
    148: 'TZ_AFRICA_ADDIS_ABABA',
    149: 'TZ_AFRICA_ALGIERS',
    150: 'TZ_AFRICA_ASMARA',
    151: 'TZ_AFRICA_BAMAKO',
    152: 'TZ_AFRICA_BANGUI',
    153: 'TZ_AFRICA_BANJUL',
    154: 'TZ_AFRICA_BISSAU',
    155: 'TZ_AFRICA_BLANTYRE',
    156: 'TZ_AFRICA_BRAZZAVILLE',
    157: 'TZ_AFRICA_BUJUMBURA',
    158: 'TZ_AFRICA_CEUTA',
    159: 'TZ_AFRICA_CONAKRY',
    160: 'TZ_AFRICA_DAKAR',
    161: 'TZ_AFRICA_DAR_ES_SALAAM',
    162: 'TZ_AFRICA_DJIBOUTI',
    163: 'TZ_AFRICA_DOUALA',
    164: 'TZ_AFRICA_EL_AAIUN',
    165: 'TZ_AFRICA_FREETOWN',
    166: 'TZ_AFRICA_GABORONE',
    167: 'TZ_AFRICA_HARARE',
    168: 'TZ_AFRICA_JUBA',
    169: 'TZ_AFRICA_KAMPALA',
    170: 'TZ_AFRICA_KHARTOUM',
    171: 'TZ_AFRICA_KIGALI',
    172: 'TZ_AFRICA_KINSHASA',
    173: 'TZ_AFRICA_LIBREVILLE',
    174: 'TZ_AFRICA_LOME',
    175: 'TZ_AFRICA_LUANDA',
    176: 'TZ_AFRICA_LUBUMBASHI',
    177: 'TZ_AFRICA_LUSAKA',
    178: 'TZ_AFRICA_MALABO',
    179: 'TZ_AFRICA_MAPUTO',
    180: 'TZ_AFRICA_MASERU',
    181: 'TZ_AFRICA_MBABANE',
    182: 'TZ_AFRICA_MOGADISHU',
    183: 'TZ_AFRICA_MONROVIA',
    184: 'TZ_AFRICA_NDJAMENA',
    185: 'TZ_AFRICA_NIAMEY',
    186: 'TZ_AFRICA_NOUAKCHOTT',
    187: 'TZ_AFRICA_OUAGADOUGOU',
    188: 'TZ_AFRICA_PORTO_NOVO',
    189: 'TZ_AFRICA_SAO_TOME',
    190: 'TZ_AFRICA_TRIPOLI',
    191: 'TZ_AFRICA_WINDHOEK',
    192: 'TZ_AMERICA_ADAK',
    193: 'TZ_AMERICA_ANGUILLA',
    194: 'TZ_AMERICA_ANTIGUA',
    195: 'TZ_AMERICA_ARAGUAINA',
    196: 'TZ_AMERICA_ARGENTINA_CATAMARCA',
    197: 'TZ_AMERICA_ARGENTINA_CORDOBA',
    198: 'TZ_AMERICA_ARGENTINA_JUJUY',
    199: 'TZ_AMERICA_ARGENTINA_LA_RIOJA',
    200: 'TZ_AMERICA_ARGENTINA_MENDOZA',
    201: 'TZ_AMERICA_ARGENTINA_RIO_GALLEGOS',
    202: 'TZ_AMERICA_ARGENTINA_SAN_JUAN',
    203: 'TZ_AMERICA_ARGENTINA_TUCUMAN',
    204: 'TZ_AMERICA_ARGENTINA_USHUAIA',
    205: 'TZ_AMERICA_ARUBA',
    206: 'TZ_AMERICA_BAHIA',
    207: 'TZ_AMERICA_BAHIA_BANDERAS',
    208: 'TZ_AMERICA_BARBADOS',
    209: 'TZ_AMERICA_BELIZE',
    210: 'TZ_AMERICA_BOA_VISTA',
    211: 'TZ_AMERICA_BOISE',
    212: 'TZ_AMERICA_CAMBRIDGE_BAY',
    213: 'TZ_AMERICA_CANCUN',
    214: 'TZ_AMERICA_CAYENNE',
    215: 'TZ_AMERICA_CAYMAN',
    216: 'TZ_AMERICA_CHIHUAHUA',
    217: 'TZ_AMERICA_CRESTON',
    218: 'TZ_AMERICA_CUIABA',
    219: 'TZ_AMERICA_CURACAO',
    220: 'TZ_AMERICA_DANMARKSHAVN',
    221: 'TZ_AMERICA_DOMINICA',
    222: 'TZ_AMERICA_EIRUNEPE',
    223: 'TZ_AMERICA_FORT_NELSON',
    224: 'TZ_AMERICA_FORTALEZA',
    225: 'TZ_AMERICA_GLACE_BAY',
    226: 'TZ_AMERICA_GODTHAB',
    227: 'TZ_AMERICA_GOOSE_BAY',
    228: 'TZ_AMERICA_GRAND_TURK',
    229: 'TZ_AMERICA_GRENADA',
    230: 'TZ_AMERICA_GUADELOUPE',
    231: 'TZ_AMERICA_GUYANA',
    232: 'TZ_AMERICA_HAVANA',
    233: 'TZ_AMERICA_INDIANA_INDIANAPOLIS',
    234: 'TZ_AMERICA_INDIANA_KNOX',
    235: 'TZ_AMERICA_INDIANA_MARENGO',
    236: 'TZ_AMERICA_INDIANA_PETERSBURG',
    237: 'TZ_AMERICA_INDIANA_TELL_CITY',
    238: 'TZ_AMERICA_INDIANA_VEVAY',
    239: 'TZ_AMERICA_INDIANA_VINCENNES',
    240: 'TZ_AMERICA_INDIANA_WINAMAC',
    241: 'TZ_AMERICA_INDIANAPOLIS',
    242: 'TZ_AMERICA_INUVIK',
    243: 'TZ_AMERICA_JUNEAU',
    244: 'TZ_AMERICA_KENTUCKY_LOUISVILLE',
    245: 'TZ_AMERICA_KENTUCKY_MONTICELLO',
    246: 'TZ_AMERICA_KRALENDIJK',
    247: 'TZ_AMERICA_LOWER_PRINCES',
    248: 'TZ_AMERICA_MACEIO',
    249: 'TZ_AMERICA_MANAUS',
    250: 'TZ_AMERICA_MARIGOT',
    251: 'TZ_AMERICA_MARTINIQUE',
    252: 'TZ_AMERICA_MATAMOROS',
    253: 'TZ_AMERICA_MENOMINEE',
    254: 'TZ_AMERICA_MERIDA',
    255: 'TZ_AMERICA_METLAKATLA',
    256: 'TZ_AMERICA_MIQUELON',
    257: 'TZ_AMERICA_MONCTON',
    258: 'TZ_AMERICA_MONTERREY',
    259: 'TZ_AMERICA_MONTREAL',
    260: 'TZ_AMERICA_MONTSERRAT',
    261: 'TZ_AMERICA_NIPIGON',
    262: 'TZ_AMERICA_NOME',
    263: 'TZ_AMERICA_NORTH_DAKOTA_BEULAH',
    264: 'TZ_AMERICA_NORTH_DAKOTA_CENTER',
    265: 'TZ_AMERICA_NORTH_DAKOTA_NEW_SALEM',
    266: 'TZ_AMERICA_OJINAGA',
    267: 'TZ_AMERICA_PANGNIRTUNG',
    268: 'TZ_AMERICA_PARAMARIBO',
    269: 'TZ_AMERICA_PORT_AU_PRINCE',
    270: 'TZ_AMERICA_PORTO_VELHO',
    271: 'TZ_AMERICA_PUNTA_ARENAS',
    272: 'TZ_AMERICA_RANKIN_INLET',
    273: 'TZ_AMERICA_RECIFE',
    274: 'TZ_AMERICA_RESOLUTE',
    275: 'TZ_AMERICA_RIO_BRANCO',
    276: 'TZ_AMERICA_SANTAREM',
    277: 'TZ_AMERICA_SCORESBYSUND',
    278: 'TZ_AMERICA_SITKA',
    279: 'TZ_AMERICA_ST_BARTHELEMY',
    280: 'TZ_AMERICA_ST_KITTS',
    281: 'TZ_AMERICA_ST_LUCIA',
    282: 'TZ_AMERICA_ST_THOMAS',
    283: 'TZ_AMERICA_ST_VINCENT',
    284: 'TZ_AMERICA_SWIFT_CURRENT',
    285: 'TZ_AMERICA_THULE',
    286: 'TZ_AMERICA_THUNDER_BAY',
    287: 'TZ_AMERICA_TORTOLA',
    288: 'TZ_AMERICA_WHITEHORSE',
    289: 'TZ_AMERICA_YAKUTAT',
    290: 'TZ_AMERICA_YELLOWKNIFE',
    291: 'TZ_ANTARCTICA_CASEY',
    292: 'TZ_ANTARCTICA_DAVIS',
    293: 'TZ_ANTARCTICA_DUMONTDURVILLE',
    294: 'TZ_ANTARCTICA_MACQUARIE',
    295: 'TZ_ANTARCTICA_MAWSON',
    296: 'TZ_ANTARCTICA_MCMURDO',
    297: 'TZ_ANTARCTICA_PALMER',
    298: 'TZ_ANTARCTICA_ROTHERA',
    299: 'TZ_ANTARCTICA_SYOWA',
    300: 'TZ_ANTARCTICA_TROLL',
    301: 'TZ_ANTARCTICA_VOSTOK',
    302: 'TZ_ARCTIC_LONGYEARBYEN',
    303: 'TZ_ASIA_ADEN',
    304: 'TZ_ASIA_ALMATY',
    305: 'TZ_ASIA_ANADYR',
    306: 'TZ_ASIA_AQTAU',
    307: 'TZ_ASIA_AQTOBE',
    308: 'TZ_ASIA_ASHGABAT',
    309: 'TZ_ASIA_ATYRAU',
    310: 'TZ_ASIA_BARNAUL',
    311: 'TZ_ASIA_BISHKEK',
    312: 'TZ_ASIA_BRUNEI',
    313: 'TZ_ASIA_CHITA',
    314: 'TZ_ASIA_CHOIBALSAN',
    315: 'TZ_ASIA_DAMASCUS',
    316: 'TZ_ASIA_DILI',
    317: 'TZ_ASIA_DUSHANBE',
    318: 'TZ_ASIA_FAMAGUSTA',
    319: 'TZ_ASIA_HEBRON',
    320: 'TZ_ASIA_HOVD',
    321: 'TZ_ASIA_ISTANBUL',
    322: 'TZ_ASIA_KABUL',
    323: 'TZ_ASIA_KHANDYGA',
    324: 'TZ_ASIA_KUCHING',
    325: 'TZ_ASIA_MACAU',
    326: 'TZ_ASIA_NOVOKUZNETSK',
    327: 'TZ_ASIA_NOVOSIBIRSK',
    328: 'TZ_ASIA_ORAL',
    329: 'TZ_ASIA_PHNOM_PENH',
    330: 'TZ_ASIA_PONTIANAK',
    331: 'TZ_ASIA_PYONGYANG',
    332: 'TZ_ASIA_QOSTANAY',
    333: 'TZ_ASIA_QYZYLORDA',
    334: 'TZ_ASIA_SAKHALIN',
    335: 'TZ_ASIA_SAMARKAND',
    336: 'TZ_ASIA_SREDNEKOLYMSK',
    337: 'TZ_ASIA_TASHKENT',
    338: 'TZ_ASIA_TBILISI',
    339: 'TZ_ASIA_TEHRAN',
    340: 'TZ_ASIA_THIMPHU',
    341: 'TZ_ASIA_TOMSK',
    342: 'TZ_ASIA_ULAANBAATAR',
    343: 'TZ_ASIA_URUMQI',
    344: 'TZ_ASIA_UST_NERA',
    345: 'TZ_ASIA_VIENTIANE',
    346: 'TZ_ASIA_YANGON',
    347: 'TZ_ASIA_YEREVAN',
    348: 'TZ_ATLANTIC_BERMUDA',
    349: 'TZ_ATLANTIC_CAPE_VERDE',
    350: 'TZ_ATLANTIC_FAROE',
    351: 'TZ_ATLANTIC_MADEIRA',
    352: 'TZ_ATLANTIC_SOUTH_GEORGIA',
    353: 'TZ_ATLANTIC_ST_HELENA',
    354: 'TZ_ATLANTIC_STANLEY',
    355: 'TZ_AUSTRALIA_ADELAIDE',
    356: 'TZ_AUSTRALIA_BRISBANE',
    357: 'TZ_AUSTRALIA_CURRIE',
    358: 'TZ_AUSTRALIA_DARWIN',
    359: 'TZ_AUSTRALIA_EUCLA',
    360: 'TZ_AUSTRALIA_HOBART',
    361: 'TZ_AUSTRALIA_LINDEMAN',
    362: 'TZ_AUSTRALIA_LORD_HOWE',
    363: 'TZ_CET',
    364: 'TZ_CST6CDT',
    365: 'TZ_EET',
    366: 'TZ_EST',
    367: 'TZ_EST5EDT',
    368: 'TZ_ETC_GMT',
    369: 'TZ_ETC_GMT_PLUS_0',
    370: 'TZ_ETC_GMT_PLUS_1',
    371: 'TZ_ETC_GMT_PLUS_10',
    372: 'TZ_ETC_GMT_PLUS_11',
    373: 'TZ_ETC_GMT_PLUS_12',
    374: 'TZ_ETC_GMT_PLUS_2',
    375: 'TZ_ETC_GMT_PLUS_3',
    376: 'TZ_ETC_GMT_PLUS_4',
    377: 'TZ_ETC_GMT_PLUS_5',
    378: 'TZ_ETC_GMT_PLUS_6',
    379: 'TZ_ETC_GMT_PLUS_7',
    380: 'TZ_ETC_GMT_PLUS_8',
    381: 'TZ_ETC_GMT_PLUS_9',
    382: 'TZ_ETC_GMT_MINUS_0',
    383: 'TZ_ETC_GMT_MINUS_1',
    384: 'TZ_ETC_GMT_MINUS_10',
    385: 'TZ_ETC_GMT_MINUS_11',
    386: 'TZ_ETC_GMT_MINUS_12',
    387: 'TZ_ETC_GMT_MINUS_13',
    388: 'TZ_ETC_GMT_MINUS_14',
    389: 'TZ_ETC_GMT_MINUS_2',
    390: 'TZ_ETC_GMT_MINUS_3',
    391: 'TZ_ETC_GMT_MINUS_4',
    392: 'TZ_ETC_GMT_MINUS_5',
    393: 'TZ_ETC_GMT_MINUS_6',
    394: 'TZ_ETC_GMT_MINUS_7',
    395: 'TZ_ETC_GMT_MINUS_8',
    396: 'TZ_ETC_GMT_MINUS_9',
    397: 'TZ_ETC_GMT0',
    398: 'TZ_ETC_GREENWICH',
    399: 'TZ_ETC_UNIVERSAL',
    400: 'TZ_ETC_ZULU',
    401: 'TZ_EUROPE_ANDORRA',
    402: 'TZ_EUROPE_ASTRAKHAN',
    403: 'TZ_EUROPE_BUSINGEN',
    404: 'TZ_EUROPE_CHISINAU',
    405: 'TZ_EUROPE_GIBRALTAR',
    406: 'TZ_EUROPE_GUERNSEY',
    407: 'TZ_EUROPE_ISLE_OF_MAN',
    408: 'TZ_EUROPE_JERSEY',
    409: 'TZ_EUROPE_KIROV',
    410: 'TZ_EUROPE_MARIEHAMN',
    411: 'TZ_EUROPE_MINSK',
    412: 'TZ_EUROPE_MONACO',
    413: 'TZ_EUROPE_NICOSIA',
    414: 'TZ_EUROPE_PODGORICA',
    415: 'TZ_EUROPE_SAN_MARINO',
    416: 'TZ_EUROPE_SARATOV',
    417: 'TZ_EUROPE_SIMFEROPOL',
    418: 'TZ_EUROPE_TIRANE',
    419: 'TZ_EUROPE_ULYANOVSK',
    420: 'TZ_EUROPE_UZHGOROD',
    421: 'TZ_EUROPE_VADUZ',
    422: 'TZ_EUROPE_VATICAN',
    423: 'TZ_EUROPE_VOLGOGRAD',
    424: 'TZ_EUROPE_ZAPOROZHYE',
    425: 'TZ_GMT',
    426: 'TZ_HST',
    427: 'TZ_INDIAN_ANTANANARIVO',
    428: 'TZ_INDIAN_CHAGOS',
    429: 'TZ_INDIAN_CHRISTMAS',
    430: 'TZ_INDIAN_COCOS',
    431: 'TZ_INDIAN_COMORO',
    432: 'TZ_INDIAN_KERGUELEN',
    433: 'TZ_INDIAN_MAHE',
    434: 'TZ_INDIAN_MAYOTTE',
    435: 'TZ_INDIAN_REUNION',
    436: 'TZ_MET',
    437: 'TZ_MST',
    438: 'TZ_MST7MDT',
    439: 'TZ_PST8PDT',
    440: 'TZ_PACIFIC_APIA',
    441: 'TZ_PACIFIC_BOUGAINVILLE',
    442: 'TZ_PACIFIC_CHATHAM',
    443: 'TZ_PACIFIC_CHUUK',
    444: 'TZ_PACIFIC_EFATE',
    445: 'TZ_PACIFIC_ENDERBURY',
    446: 'TZ_PACIFIC_FAKAOFO',
    447: 'TZ_PACIFIC_FIJI',
    448: 'TZ_PACIFIC_FUNAFUTI',
    449: 'TZ_PACIFIC_GAMBIER',
    450: 'TZ_PACIFIC_GUADALCANAL',
    451: 'TZ_PACIFIC_GUAM',
    452: 'TZ_PACIFIC_KIRITIMATI',
    453: 'TZ_PACIFIC_KOSRAE',
    454: 'TZ_PACIFIC_KWAJALEIN',
    455: 'TZ_PACIFIC_MAJURO',
    456: 'TZ_PACIFIC_MARQUESAS',
    457: 'TZ_PACIFIC_MIDWAY',
    458: 'TZ_PACIFIC_NAURU',
    459: 'TZ_PACIFIC_NIUE',
    460: 'TZ_PACIFIC_NORFOLK',
    461: 'TZ_PACIFIC_NOUMEA',
    462: 'TZ_PACIFIC_PAGO_PAGO',
    463: 'TZ_PACIFIC_PALAU',
    464: 'TZ_PACIFIC_PITCAIRN',
    465: 'TZ_PACIFIC_POHNPEI',
    466: 'TZ_PACIFIC_PORT_MORESBY',
    467: 'TZ_PACIFIC_RAROTONGA',
    468: 'TZ_PACIFIC_SAIPAN',
    469: 'TZ_PACIFIC_TAHITI',
    470: 'TZ_PACIFIC_TARAWA',
    471: 'TZ_PACIFIC_TONGATAPU',
    472: 'TZ_PACIFIC_WAKE',
    473: 'TZ_PACIFIC_WALLIS',
    474: 'TZ_UTC',
    475: 'TZ_WET',
}
# TZ_AMERICA_LOS_ANGELES -> 1
facebookTimezoneCodeToTimezoneId = {v: k for k, v in facebookTimezoneIdToTimezoneCode.items()}

# 1 -> TZ_AMERICA_LOS_ANGELES
facebookTimezoneIdToTimezoneName = {
    0: 'Unknown',
    1: 'America/Los_Angeles',
    2: 'America/Denver',
    3: 'Pacific/Honolulu',
    4: 'America/Anchorage',
    5: 'America/Phoenix',
    6: 'America/Chicago',
    7: 'America/New_York',
    8: 'Asia/Dubai',
    9: 'America/Argentina_San_Luis',
    10: 'America/Argentina_Buenos_Aires',
    11: 'America/Argentina_Salta',
    12: 'Europe/Vienna',
    13: 'Australia/Perth',
    14: 'Australia/Broken_Hill',
    15: 'Australia/Sydney',
    16: 'Europe/Sarajevo',
    17: 'Asia/Dhaka',
    18: 'Europe/Brussels',
    19: 'Europe/Sofia',
    20: 'Asia/Bahrain',
    21: 'America/La_Paz',
    22: 'America/Noronha',
    23: 'America/Campo_Grande',
    24: 'America/Belem',
    25: 'America/Sao_Paulo',
    26: 'America/Nassau',
    27: 'America/Dawson',
    28: 'America/Vancouver',
    29: 'America/Dawson_Creek',
    30: 'America/Edmonton',
    31: 'America/Rainy_River',
    32: 'America/Regina',
    33: 'America/Atikokan',
    34: 'America/Iqaluit',
    35: 'America/Toronto',
    36: 'America/Blanc_Sablon',
    37: 'America/Halifax',
    38: 'America/St_Johns',
    39: 'Europe/Zurich',
    40: 'Pacific/Easter',
    41: 'America/Santiago',
    42: 'Asia/Shanghai',
    43: 'America/Bogota',
    44: 'America/Costa_Rica',
    45: 'Asia/Nicosia',
    46: 'Europe/Prague',
    47: 'Europe/Berlin',
    48: 'Europe/Copenhagen',
    49: 'America/Santo_Domingo',
    50: 'Pacific/Galapagos',
    51: 'America/Guayaquil',
    52: 'Europe/Tallinn',
    53: 'Africa/Cairo',
    54: 'Atlantic/Canary',
    55: 'Europe/Madrid',
    56: 'Europe/Helsinki',
    57: 'Europe/Paris',
    58: 'Europe/London',
    59: 'Africa/Accra',
    60: 'Europe/Athens',
    61: 'America/Guatemala',
    62: 'Asia/Hong_Kong',
    63: 'America/Tegucigalpa',
    64: 'Europe/Zagreb',
    65: 'Europe/Budapest',
    66: 'Asia/Jakarta',
    67: 'Asia/Makassar',
    68: 'Asia/Jayapura',
    69: 'Europe/Dublin',
    70: 'Asia/Jerusalem',
    71: 'Asia/Kolkata',
    72: 'Asia/Baghdad',
    73: 'Atlantic/Reykjavik',
    74: 'Europe/Rome',
    75: 'America/Jamaica',
    76: 'Asia/Amman',
    77: 'Asia/Tokyo',
    78: 'Africa/Nairobi',
    79: 'Asia/Seoul',
    80: 'Asia/Kuwait',
    81: 'Asia/Beirut',
    82: 'Asia/Colombo',
    83: 'Europe/Vilnius',
    84: 'Europe/Luxembourg',
    85: 'Europe/Riga',
    86: 'Africa/Casablanca',
    87: 'Europe/Skopje',
    88: 'Europe/Malta',
    89: 'Indian/Mauritius',
    90: 'Indian/Maldives',
    91: 'America/Tijuana',
    92: 'America/Hermosillo',
    93: 'America/Mazatlan',
    94: 'America/Mexico_City',
    95: 'Asia/Kuala_Lumpur',
    96: 'Africa/Lagos',
    97: 'America/Managua',
    98: 'Europe/Amsterdam',
    99: 'Europe/Oslo',
    100: 'Pacific/Auckland',
    101: 'Asia/Muscat',
    102: 'America/Panama',
    103: 'America/Lima',
    104: 'Asia/Manila',
    105: 'Asia/Karachi',
    106: 'Europe/Warsaw',
    107: 'America/Puerto_Rico',
    108: 'Asia/Gaza',
    109: 'Atlantic/Azores',
    110: 'Europe/Lisbon',
    111: 'America/Asuncion',
    112: 'Asia/Qatar',
    113: 'Europe/Bucharest',
    114: 'Europe/Belgrade',
    115: 'Europe/Kaliningrad',
    116: 'Europe/Moscow',
    117: 'Europe/Samara',
    118: 'Asia/Yekaterinburg',
    119: 'Asia/Omsk',
    120: 'Asia/Krasnoyarsk',
    121: 'Asia/Irkutsk',
    122: 'Asia/Yakutsk',
    123: 'Asia/Vladivostok',
    124: 'Asia/Magadan',
    125: 'Asia/Kamchatka',
    126: 'Asia/Riyadh',
    127: 'Europe/Stockholm',
    128: 'Asia/Singapore',
    129: 'Europe/Ljubljana',
    130: 'Europe/Bratislava',
    131: 'America/El_Salvador',
    132: 'Asia/Bangkok',
    133: 'Africa/Tunis',
    134: 'Europe/Istanbul',
    135: 'America/Port_Of_Spain',
    136: 'Asia/Taipei',
    137: 'Europe/Kiev',
    138: 'America/Montevideo',
    139: 'America/Caracas',
    140: 'Asia/Ho_Chi_Minh',
    141: 'Africa/Johannesburg',
    142: 'America/Winnipeg',
    143: 'America/Detroit',
    144: 'Australia/Melbourne',
    145: 'Asia/Kathmandu',
    146: 'Asia/Baku',
    147: 'Africa/Abidjan',
    148: 'Africa/Addis_Ababa',
    149: 'Africa/Algiers',
    150: 'Africa/Asmara',
    151: 'Africa/Bamako',
    152: 'Africa/Bangui',
    153: 'Africa/Banjul',
    154: 'Africa/Bissau',
    155: 'Africa/Blantyre',
    156: 'Africa/Brazzaville',
    157: 'Africa/Bujumbura',
    158: 'Africa/Ceuta',
    159: 'Africa/Conakry',
    160: 'Africa/Dakar',
    161: 'Africa/Dar_Es_Salaam',
    162: 'Africa/Djibouti',
    163: 'Africa/Douala',
    164: 'Africa/El_Aaiun',
    165: 'Africa/Freetown',
    166: 'Africa/Gaborone',
    167: 'Africa/Harare',
    168: 'Africa/Juba',
    169: 'Africa/Kampala',
    170: 'Africa/Khartoum',
    171: 'Africa/Kigali',
    172: 'Africa/Kinshasa',
    173: 'Africa/Libreville',
    174: 'Africa/Lome',
    175: 'Africa/Luanda',
    176: 'Africa/Lubumbashi',
    177: 'Africa/Lusaka',
    178: 'Africa/Malabo',
    179: 'Africa/Maputo',
    180: 'Africa/Maseru',
    181: 'Africa/Mbabane',
    182: 'Africa/Mogadishu',
    183: 'Africa/Monrovia',
    184: 'Africa/Ndjamena',
    185: 'Africa/Niamey',
    186: 'Africa/Nouakchott',
    187: 'Africa/Ouagadougou',
    188: 'Africa/Porto_Novo',
    189: 'Africa/Sao_Tome',
    190: 'Africa/Tripoli',
    191: 'Africa/Windhoek',
    192: 'America/Adak',
    193: 'America/Anguilla',
    194: 'America/Antigua',
    195: 'America/Araguaina',
    196: 'America/Argentina/Catamarca',
    197: 'America/Argentina/Cordoba',
    198: 'America/Argentina/Jujuy',
    199: 'America/Argentina/La_Rioja',
    200: 'America/Argentina/Mendoza',
    201: 'America/Argentina/Rio_Gallegos',
    202: 'America/Argentina/San_Juan',
    203: 'America/Argentina/Tucuman',
    204: 'America/Argentina/Ushuaia',
    205: 'America/Aruba',
    206: 'America/Bahia',
    207: 'America/Bahia/Banderas',
    208: 'America/Barbados',
    209: 'America/Belize',
    210: 'America/Boa_Vista',
    211: 'America/Boise',
    212: 'America/Cambridge_Bay',
    213: 'America/Cancun',
    214: 'America/Cayenne',
    215: 'America/Cayman',
    216: 'America/Chihuahua',
    217: 'America/Creston',
    218: 'America/Cuiaba',
    219: 'America/Curacao',
    220: 'America/Danmarkshavn',
    221: 'America/Dominica',
    222: 'America/Eirunepe',
    223: 'America/Fort_Nelson',
    224: 'America/Fortaleza',
    225: 'America/Glace_Bay',
    226: 'America/Godthab',
    227: 'America/Goose_Bay',
    228: 'America/Grand_Turk',
    229: 'America/Grenada',
    230: 'America/Guadeloupe',
    231: 'America/Guyana',
    232: 'America/Havana',
    233: 'America/Indiana/Indianapolis',
    234: 'America/Indiana/Knox',
    235: 'America/Indiana/Marengo',
    236: 'America/Indiana/Petersburg',
    237: 'America/Indiana/Tell_City',
    238: 'America/Indiana/Vevay',
    239: 'America/Indiana/Vincennes',
    240: 'America/Indiana/Winamac',
    241: 'America/Indianapolis',
    242: 'America/Inuvik',
    243: 'America/Juneau',
    244: 'America/Kentucky/Louisville',
    245: 'America/Kentucky/Monticello',
    246: 'America/Kralendijk',
    247: 'America/Lower_Princes',
    248: 'America/Maceio',
    249: 'America/Manaus',
    250: 'America/Marigot',
    251: 'America/Martinique',
    252: 'America/Matamoros',
    253: 'America/Menominee',
    254: 'America/Merida',
    255: 'America/Metlakatla',
    256: 'America/Miquelon',
    257: 'America/Moncton',
    258: 'America/Monterrey',
    259: 'America/Montreal',
    260: 'America/Montserrat',
    261: 'America/Nipigon',
    262: 'America/Nome',
    263: 'America/North_Dakota/Beulah',
    264: 'America/North_Dakota/Center',
    265: 'America/North_Dakota/New_Salem',
    266: 'America/Ojinaga',
    267: 'America/Pangnirtung',
    268: 'America/Paramaribo',
    269: 'America/Port_Au_Prince',
    270: 'America/Porto_Velho',
    271: 'America/Punta_Arenas',
    272: 'America/Rankin_Inlet',
    273: 'America/Recife',
    274: 'America/Resolute',
    275: 'America/Rio_Branco',
    276: 'America/Santarem',
    277: 'America/Scoresbysund',
    278: 'America/Sitka',
    279: 'America/St_Barthelemy',
    280: 'America/St_Kitts',
    281: 'America/St_Lucia',
    282: 'America/St_Thomas',
    283: 'America/St_Vincent',
    284: 'America/Swift_Current',
    285: 'America/Thule',
    286: 'America/Thunder_Bay',
    287: 'America/Tortola',
    288: 'America/Whitehorse',
    289: 'America/Yakutat',
    290: 'America/Yellowknife',
    291: 'Antarctica/Casey',
    292: 'Antarctica/Davis',
    293: 'Antarctica/Dumontdurville',
    294: 'Antarctica/Macquarie',
    295: 'Antarctica/Mawson',
    296: 'Antarctica/Mcmurdo',
    297: 'Antarctica/Palmer',
    298: 'Antarctica/Rothera',
    299: 'Antarctica/Syowa',
    300: 'Antarctica/Troll',
    301: 'Antarctica/Vostok',
    302: 'Arctic/Longyearbyen',
    303: 'Asia/Aden',
    304: 'Asia/Almaty',
    305: 'Asia/Anadyr',
    306: 'Asia/Aqtau',
    307: 'Asia/Aqtobe',
    308: 'Asia/Ashgabat',
    309: 'Asia/Atyrau',
    310: 'Asia/Barnaul',
    311: 'Asia/Bishkek',
    312: 'Asia/Brunei',
    313: 'Asia/Chita',
    314: 'Asia/Choibalsan',
    315: 'Asia/Damascus',
    316: 'Asia/Dili',
    317: 'Asia/Dushanbe',
    318: 'Asia/Famagusta',
    319: 'Asia/Hebron',
    320: 'Asia/Hovd',
    321: 'Asia/Istanbul',
    322: 'Asia/Kabul',
    323: 'Asia/Khandyga',
    324: 'Asia/Kuching',
    325: 'Asia/Macau',
    326: 'Asia/Novokuznetsk',
    327: 'Asia/Novosibirsk',
    328: 'Asia/Oral',
    329: 'Asia/Phnom_Penh',
    330: 'Asia/Pontianak',
    331: 'Asia/Pyongyang',
    332: 'Asia/Qostanay',
    333: 'Asia/Qyzylorda',
    334: 'Asia/Sakhalin',
    335: 'Asia/Samarkand',
    336: 'Asia/Srednekolymsk',
    337: 'Asia/Tashkent',
    338: 'Asia/Tbilisi',
    339: 'Asia/Tehran',
    340: 'Asia/Thimphu',
    341: 'Asia/Tomsk',
    342: 'Asia/Ulaanbaatar',
    343: 'Asia/Urumqi',
    344: 'Asia/Ust_Nera',
    345: 'Asia/Vientiane',
    346: 'Asia/Yangon',
    347: 'Asia/Yerevan',
    348: 'Atlantic/Bermuda',
    349: 'Atlantic/Cape_Verde',
    350: 'Atlantic/Faroe',
    351: 'Atlantic/Madeira',
    352: 'Atlantic/South_Georgia',
    353: 'Atlantic/St_Helena',
    354: 'Atlantic/Stanley',
    355: 'Australia/Adelaide',
    356: 'Australia/Brisbane',
    357: 'Australia/Currie',
    358: 'Australia/Darwin',
    359: 'Australia/Eucla',
    360: 'Australia/Hobart',
    361: 'Australia/Lindeman',
    362: 'Australia/Lord_Howe',
    363: 'CET',
    364: 'CST6CDT',
    365: 'EET',
    366: 'EST',
    367: 'EST5EDT',
    368: 'Etc/GMT',
    369: 'Etc/GMT+0',
    370: 'Etc/GMT+1',
    371: 'Etc/GMT+10',
    372: 'Etc/GMT+11',
    373: 'Etc/GMT+12',
    374: 'Etc/GMT+2',
    375: 'Etc/GMT+3',
    376: 'Etc/GMT+4',
    377: 'Etc/GMT+5',
    378: 'Etc/GMT+6',
    379: 'Etc/GMT+7',
    380: 'Etc/GMT+8',
    381: 'Etc/GMT+9',
    382: 'Etc/GMT-0',
    383: 'Etc/GMT-1',
    384: 'Etc/GMT-10',
    385: 'Etc/GMT-11',
    386: 'Etc/GMT-12',
    387: 'Etc/GMT-13',
    388: 'Etc/GMT-14',
    389: 'Etc/GMT-2',
    390: 'Etc/GMT-3',
    391: 'Etc/GMT-4',
    392: 'Etc/GMT-5',
    393: 'Etc/GMT-6',
    394: 'Etc/GMT-7',
    395: 'Etc/GMT-8',
    396: 'Etc/GMT-9',
    397: 'Etc/GMT0',
    398: 'Etc/Greenwich',
    399: 'Etc/Universal',
    400: 'Etc/Zulu',
    401: 'Europe/Andorra',
    402: 'Europe/Astrakhan',
    403: 'Europe/Busingen',
    404: 'Europe/Chisinau',
    405: 'Europe/Gibraltar',
    406: 'Europe/Guernsey',
    407: 'Europe/Isle_Of_Man',
    408: 'Europe/Jersey',
    409: 'Europe/Kirov',
    410: 'Europe/Mariehamn',
    411: 'Europe/Minsk',
    412: 'Europe/Monaco',
    413: 'Europe/Nicosia',
    414: 'Europe/Podgorica',
    415: 'Europe/San_Marino',
    416: 'Europe/Saratov',
    417: 'Europe/Simferopol',
    418: 'Europe/Tirane',
    419: 'Europe/Ulyanovsk',
    420: 'Europe/Uzhgorod',
    421: 'Europe/Vaduz',
    422: 'Europe/Vatican',
    423: 'Europe/Volgograd',
    424: 'Europe/Zaporozhye',
    425: 'GMT',
    426: 'HST',
    427: 'Indian/Antananarivo',
    428: 'Indian/Chagos',
    429: 'Indian/Christmas',
    430: 'Indian/Cocos',
    431: 'Indian/Comoro',
    432: 'Indian/Kerguelen',
    433: 'Indian/Mahe',
    434: 'Indian/Mayotte',
    435: 'Indian/Reunion',
    436: 'MET',
    437: 'MST',
    438: 'MST7MDT',
    439: 'PST8PDT',
    440: 'Pacific/Apia',
    441: 'Pacific/Bougainville',
    442: 'Pacific/Chatham',
    443: 'Pacific/Chuuk',
    444: 'Pacific/Efate',
    445: 'Pacific/Enderbury',
    446: 'Pacific/Fakaofo',
    447: 'Pacific/Fiji',
    448: 'Pacific/Funafuti',
    449: 'Pacific/Gambier',
    450: 'Pacific/Guadalcanal',
    451: 'Pacific/Guam',
    452: 'Pacific/Kiritimati',
    453: 'Pacific/Kosrae',
    454: 'Pacific/Kwajalein',
    455: 'Pacific/Majuro',
    456: 'Pacific/Marquesas',
    457: 'Pacific/Midway',
    458: 'Pacific/Nauru',
    459: 'Pacific/Niue',
    460: 'Pacific/Norfolk',
    461: 'Pacific/Noumea',
    462: 'Pacific/Pago_Pago',
    463: 'Pacific/Palau',
    464: 'Pacific/Pitcairn',
    465: 'Pacific/Pohnpei',
    466: 'Pacific/Port_Moresby',
    467: 'Pacific/Rarotonga',
    468: 'Pacific/Saipan',
    469: 'Pacific/Tahiti',
    470: 'Pacific/Tarawa',
    471: 'Pacific/Tongatapu',
    472: 'Pacific/Wake',
    473: 'Pacific/Wallis',
    474: 'UTC',
    475: 'WET',

}
# TZ_AMERICA_LOS_ANGELES -> 1
facebookTimezoneNameToTimezoneId = {v: k for k, v in facebookTimezoneIdToTimezoneName.items()}

# TZ_AMERICA_LOS_ANGELES -> America/Los_Angeles
facebookTimezoneCodeToTimezoneName = \
    {k: facebookTimezoneIdToTimezoneName[v] for (k, v) in facebookTimezoneCodeToTimezoneId.items()}
# America/Los_Angeles -> TZ_AMERICA_LOS_ANGELES
facebookTimezoneNameToTimezoneCode = {v: k for k, v in facebookTimezoneCodeToTimezoneName.items()}

# 5 -> Etc/GMT+5
def timezoneNameFromTimezoneOffset(timezoneOffset):
    '''
    Returns a timezone based on the timezone offset, as returned in the 'timezone' field of:
    https://developers.facebook.com/docs/graph-api/reference/v2.12/user

    :param timezoneOffset: Float, -24.0 to 24.0
    :return: timezoneName
    '''

    # TODO: Handle 0.25, 0.5 and 0.75 values - these actually exist
    timezoneOffset = round(timezoneOffset)

    # unfortunately we need these 2 ifs, because pytz doesn't support +13 adn +14 timezones
    if timezoneOffset == 13:
        return 'Pacific/Auckland'
    elif timezoneOffset == 14:
        return 'Pacific/Kiritimati'
    elif timezoneOffset > 0:
        return 'Etc/GMT+%d' % timezoneOffset
    elif timezoneOffset == 0:
        return 'Etc/GMT'
    else:
        return 'Etc/GMT%d' % timezoneOffset