"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs");
const core_1 = require("@aws-cdk/core");
const datadog_dashboard_1 = require("./dashboards/datadog-dashboard");
const datadog_monitor_1 = require("./monitors/datadog-monitor");
const properties_1 = require("./monitors/properties");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'CdkDatadogResourcesTestStack');
const datadogCredentials = {
    apiKey: process.env.DATADOG_API_KEY,
    applicationKey: process.env.DATADOG_APP_KEY,
};
new datadog_monitor_1.DatadogMonitor(stack, 'TestMonitor', {
    datadogCredentials,
    query: 'avg(last_1h):sum:system.cpu.system{host:host0} > 100',
    type: properties_1.MonitorType.QUERY_ALERT,
    name: 'Test Monitor',
    options: {
        thresholds: {
            critical: 100,
            warning: 80,
            oK: 90,
        },
        notifyNoData: true,
        evaluationDelay: 60,
    },
});
new datadog_dashboard_1.DatadogDashboard(stack, 'TestDashboard', {
    datadogCredentials,
    dashboardDefinition: fs.readFileSync(`${__dirname}/../test/dashboards/dashboard-def.json`).toString(),
});
//# sourceMappingURL=data:application/json;base64,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