# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AlertPolicyAlertStrategy',
    'AlertPolicyAlertStrategyNotificationRateLimit',
    'AlertPolicyCondition',
    'AlertPolicyConditionConditionAbsent',
    'AlertPolicyConditionConditionAbsentAggregation',
    'AlertPolicyConditionConditionAbsentTrigger',
    'AlertPolicyConditionConditionMatchedLog',
    'AlertPolicyConditionConditionMonitoringQueryLanguage',
    'AlertPolicyConditionConditionMonitoringQueryLanguageTrigger',
    'AlertPolicyConditionConditionThreshold',
    'AlertPolicyConditionConditionThresholdAggregation',
    'AlertPolicyConditionConditionThresholdDenominatorAggregation',
    'AlertPolicyConditionConditionThresholdTrigger',
    'AlertPolicyCreationRecord',
    'AlertPolicyDocumentation',
    'CustomServiceTelemetry',
    'MetricDescriptorLabel',
    'MetricDescriptorMetadata',
    'NotificationChannelSensitiveLabels',
    'SloBasicSli',
    'SloBasicSliAvailability',
    'SloBasicSliLatency',
    'SloRequestBasedSli',
    'SloRequestBasedSliDistributionCut',
    'SloRequestBasedSliDistributionCutRange',
    'SloRequestBasedSliGoodTotalRatio',
    'SloWindowsBasedSli',
    'SloWindowsBasedSliGoodTotalRatioThreshold',
    'SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance',
    'SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability',
    'SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency',
    'SloWindowsBasedSliGoodTotalRatioThresholdPerformance',
    'SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut',
    'SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange',
    'SloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio',
    'SloWindowsBasedSliMetricMeanInRange',
    'SloWindowsBasedSliMetricMeanInRangeRange',
    'SloWindowsBasedSliMetricSumInRange',
    'SloWindowsBasedSliMetricSumInRangeRange',
    'UptimeCheckConfigContentMatcher',
    'UptimeCheckConfigHttpCheck',
    'UptimeCheckConfigHttpCheckAuthInfo',
    'UptimeCheckConfigMonitoredResource',
    'UptimeCheckConfigResourceGroup',
    'UptimeCheckConfigTcpCheck',
    'GetAppEngineServiceTelemetryResult',
    'GetClusterIstioServiceTelemetryResult',
    'GetIstioCanonicalServiceTelemetryResult',
    'GetMeshIstioServiceTelemetryResult',
    'GetNotificationChannelSensitiveLabelResult',
    'GetUptimeCheckIPsUptimeCheckIpResult',
]

@pulumi.output_type
class AlertPolicyAlertStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoClose":
            suggest = "auto_close"
        elif key == "notificationRateLimit":
            suggest = "notification_rate_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyAlertStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyAlertStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyAlertStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_close: Optional[str] = None,
                 notification_rate_limit: Optional['outputs.AlertPolicyAlertStrategyNotificationRateLimit'] = None):
        """
        :param str auto_close: If an alert policy that was active has no data for this long, any open incidents will close.
        :param 'AlertPolicyAlertStrategyNotificationRateLimitArgs' notification_rate_limit: Required for alert policies with a LogMatch condition.
               This limit is not implemented for alert policies that are not log-based.
               Structure is documented below.
        """
        if auto_close is not None:
            pulumi.set(__self__, "auto_close", auto_close)
        if notification_rate_limit is not None:
            pulumi.set(__self__, "notification_rate_limit", notification_rate_limit)

    @property
    @pulumi.getter(name="autoClose")
    def auto_close(self) -> Optional[str]:
        """
        If an alert policy that was active has no data for this long, any open incidents will close.
        """
        return pulumi.get(self, "auto_close")

    @property
    @pulumi.getter(name="notificationRateLimit")
    def notification_rate_limit(self) -> Optional['outputs.AlertPolicyAlertStrategyNotificationRateLimit']:
        """
        Required for alert policies with a LogMatch condition.
        This limit is not implemented for alert policies that are not log-based.
        Structure is documented below.
        """
        return pulumi.get(self, "notification_rate_limit")


@pulumi.output_type
class AlertPolicyAlertStrategyNotificationRateLimit(dict):
    def __init__(__self__, *,
                 period: Optional[str] = None):
        """
        :param str period: Not more than one notification per period.
        """
        if period is not None:
            pulumi.set(__self__, "period", period)

    @property
    @pulumi.getter
    def period(self) -> Optional[str]:
        """
        Not more than one notification per period.
        """
        return pulumi.get(self, "period")


@pulumi.output_type
class AlertPolicyCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "conditionAbsent":
            suggest = "condition_absent"
        elif key == "conditionMatchedLog":
            suggest = "condition_matched_log"
        elif key == "conditionMonitoringQueryLanguage":
            suggest = "condition_monitoring_query_language"
        elif key == "conditionThreshold":
            suggest = "condition_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: str,
                 condition_absent: Optional['outputs.AlertPolicyConditionConditionAbsent'] = None,
                 condition_matched_log: Optional['outputs.AlertPolicyConditionConditionMatchedLog'] = None,
                 condition_monitoring_query_language: Optional['outputs.AlertPolicyConditionConditionMonitoringQueryLanguage'] = None,
                 condition_threshold: Optional['outputs.AlertPolicyConditionConditionThreshold'] = None,
                 name: Optional[str] = None):
        """
        :param str display_name: A short name or phrase used to identify the
               condition in dashboards, notifications, and
               incidents. To avoid confusion, don't use the same
               display name for multiple conditions in the same
               policy.
        :param 'AlertPolicyConditionConditionAbsentArgs' condition_absent: A condition that checks that a time series
               continues to receive new data points.
               Structure is documented below.
        :param 'AlertPolicyConditionConditionMatchedLogArgs' condition_matched_log: A condition that checks for log messages matching given constraints.
               If set, no other conditions can be present.
               Structure is documented below.
        :param 'AlertPolicyConditionConditionMonitoringQueryLanguageArgs' condition_monitoring_query_language: A Monitoring Query Language query that outputs a boolean stream
               Structure is documented below.
        :param 'AlertPolicyConditionConditionThresholdArgs' condition_threshold: A condition that compares a time series against a
               threshold.
               Structure is documented below.
        :param str name: -
               The unique resource name for this condition.
               Its syntax is:
               projects/[PROJECT_ID]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
               [CONDITION_ID] is assigned by Stackdriver Monitoring when
               the condition is created as part of a new or updated alerting
               policy.
        """
        pulumi.set(__self__, "display_name", display_name)
        if condition_absent is not None:
            pulumi.set(__self__, "condition_absent", condition_absent)
        if condition_matched_log is not None:
            pulumi.set(__self__, "condition_matched_log", condition_matched_log)
        if condition_monitoring_query_language is not None:
            pulumi.set(__self__, "condition_monitoring_query_language", condition_monitoring_query_language)
        if condition_threshold is not None:
            pulumi.set(__self__, "condition_threshold", condition_threshold)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A short name or phrase used to identify the
        condition in dashboards, notifications, and
        incidents. To avoid confusion, don't use the same
        display name for multiple conditions in the same
        policy.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="conditionAbsent")
    def condition_absent(self) -> Optional['outputs.AlertPolicyConditionConditionAbsent']:
        """
        A condition that checks that a time series
        continues to receive new data points.
        Structure is documented below.
        """
        return pulumi.get(self, "condition_absent")

    @property
    @pulumi.getter(name="conditionMatchedLog")
    def condition_matched_log(self) -> Optional['outputs.AlertPolicyConditionConditionMatchedLog']:
        """
        A condition that checks for log messages matching given constraints.
        If set, no other conditions can be present.
        Structure is documented below.
        """
        return pulumi.get(self, "condition_matched_log")

    @property
    @pulumi.getter(name="conditionMonitoringQueryLanguage")
    def condition_monitoring_query_language(self) -> Optional['outputs.AlertPolicyConditionConditionMonitoringQueryLanguage']:
        """
        A Monitoring Query Language query that outputs a boolean stream
        Structure is documented below.
        """
        return pulumi.get(self, "condition_monitoring_query_language")

    @property
    @pulumi.getter(name="conditionThreshold")
    def condition_threshold(self) -> Optional['outputs.AlertPolicyConditionConditionThreshold']:
        """
        A condition that compares a time series against a
        threshold.
        Structure is documented below.
        """
        return pulumi.get(self, "condition_threshold")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        -
        The unique resource name for this condition.
        Its syntax is:
        projects/[PROJECT_ID]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
        [CONDITION_ID] is assigned by Stackdriver Monitoring when
        the condition is created as part of a new or updated alerting
        policy.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AlertPolicyConditionConditionAbsent(dict):
    def __init__(__self__, *,
                 duration: str,
                 aggregations: Optional[Sequence['outputs.AlertPolicyConditionConditionAbsentAggregation']] = None,
                 filter: Optional[str] = None,
                 trigger: Optional['outputs.AlertPolicyConditionConditionAbsentTrigger'] = None):
        """
        :param str duration: The amount of time that a time series must
               violate the threshold to be considered
               failing. Currently, only values that are a
               multiple of a minute--e.g., 0, 60, 120, or
               300 seconds--are supported. If an invalid
               value is given, an error will be returned.
               When choosing a duration, it is useful to
               keep in mind the frequency of the underlying
               time series data (which may also be affected
               by any alignments specified in the
               aggregations field); a good duration is long
               enough so that a single outlier does not
               generate spurious alerts, but short enough
               that unhealthy states are detected and
               alerted on quickly.
        :param Sequence['AlertPolicyConditionConditionAbsentAggregationArgs'] aggregations: Specifies the alignment of data points in
               individual time series as well as how to
               combine the retrieved time series together
               (such as when aggregating multiple streams
               on each resource to a single stream for each
               resource or when aggregating streams across
               all members of a group of resources).
               Multiple aggregations are applied in the
               order specified.This field is similar to the
               one in the MetricService.ListTimeSeries
               request. It is advisable to use the
               ListTimeSeries method when debugging this
               field.
               Structure is documented below.
        :param str filter: A logs-based filter.
        :param 'AlertPolicyConditionConditionAbsentTriggerArgs' trigger: The number/percent of time series for which
               the comparison must hold in order for the
               condition to trigger. If unspecified, then
               the condition will trigger if the comparison
               is true for any of the time series that have
               been identified by filter and aggregations,
               or by the ratio, if denominator_filter and
               denominator_aggregations are specified.
               Structure is documented below.
        """
        pulumi.set(__self__, "duration", duration)
        if aggregations is not None:
            pulumi.set(__self__, "aggregations", aggregations)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        The amount of time that a time series must
        violate the threshold to be considered
        failing. Currently, only values that are a
        multiple of a minute--e.g., 0, 60, 120, or
        300 seconds--are supported. If an invalid
        value is given, an error will be returned.
        When choosing a duration, it is useful to
        keep in mind the frequency of the underlying
        time series data (which may also be affected
        by any alignments specified in the
        aggregations field); a good duration is long
        enough so that a single outlier does not
        generate spurious alerts, but short enough
        that unhealthy states are detected and
        alerted on quickly.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def aggregations(self) -> Optional[Sequence['outputs.AlertPolicyConditionConditionAbsentAggregation']]:
        """
        Specifies the alignment of data points in
        individual time series as well as how to
        combine the retrieved time series together
        (such as when aggregating multiple streams
        on each resource to a single stream for each
        resource or when aggregating streams across
        all members of a group of resources).
        Multiple aggregations are applied in the
        order specified.This field is similar to the
        one in the MetricService.ListTimeSeries
        request. It is advisable to use the
        ListTimeSeries method when debugging this
        field.
        Structure is documented below.
        """
        return pulumi.get(self, "aggregations")

    @property
    @pulumi.getter
    def filter(self) -> Optional[str]:
        """
        A logs-based filter.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def trigger(self) -> Optional['outputs.AlertPolicyConditionConditionAbsentTrigger']:
        """
        The number/percent of time series for which
        the comparison must hold in order for the
        condition to trigger. If unspecified, then
        the condition will trigger if the comparison
        is true for any of the time series that have
        been identified by filter and aggregations,
        or by the ratio, if denominator_filter and
        denominator_aggregations are specified.
        Structure is documented below.
        """
        return pulumi.get(self, "trigger")


@pulumi.output_type
class AlertPolicyConditionConditionAbsentAggregation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alignmentPeriod":
            suggest = "alignment_period"
        elif key == "crossSeriesReducer":
            suggest = "cross_series_reducer"
        elif key == "groupByFields":
            suggest = "group_by_fields"
        elif key == "perSeriesAligner":
            suggest = "per_series_aligner"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyConditionConditionAbsentAggregation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyConditionConditionAbsentAggregation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyConditionConditionAbsentAggregation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alignment_period: Optional[str] = None,
                 cross_series_reducer: Optional[str] = None,
                 group_by_fields: Optional[Sequence[str]] = None,
                 per_series_aligner: Optional[str] = None):
        """
        :param str alignment_period: The alignment period for per-time
               series alignment. If present,
               alignmentPeriod must be at least
               60 seconds. After per-time series
               alignment, each time series will
               contain data points only on the
               period boundaries. If
               perSeriesAligner is not specified
               or equals ALIGN_NONE, then this
               field is ignored. If
               perSeriesAligner is specified and
               does not equal ALIGN_NONE, then
               this field must be defined;
               otherwise an error is returned.
        :param str cross_series_reducer: The approach to be used to combine
               time series. Not all reducer
               functions may be applied to all
               time series, depending on the
               metric type and the value type of
               the original time series.
               Reduction may change the metric
               type of value type of the time
               series.Time series data must be
               aligned in order to perform cross-
               time series reduction. If
               crossSeriesReducer is specified,
               then perSeriesAligner must be
               specified and not equal ALIGN_NONE
               and alignmentPeriod must be
               specified; otherwise, an error is
               returned.
               Possible values are `REDUCE_NONE`, `REDUCE_MEAN`, `REDUCE_MIN`, `REDUCE_MAX`, `REDUCE_SUM`, `REDUCE_STDDEV`, `REDUCE_COUNT`, `REDUCE_COUNT_TRUE`, `REDUCE_COUNT_FALSE`, `REDUCE_FRACTION_TRUE`, `REDUCE_PERCENTILE_99`, `REDUCE_PERCENTILE_95`, `REDUCE_PERCENTILE_50`, and `REDUCE_PERCENTILE_05`.
        :param Sequence[str] group_by_fields: The set of fields to preserve when
               crossSeriesReducer is specified.
               The groupByFields determine how
               the time series are partitioned
               into subsets prior to applying the
               aggregation function. Each subset
               contains time series that have the
               same value for each of the
               grouping fields. Each individual
               time series is a member of exactly
               one subset. The crossSeriesReducer
               is applied to each subset of time
               series. It is not possible to
               reduce across different resource
               types, so this field implicitly
               contains resource.type. Fields not
               specified in groupByFields are
               aggregated away. If groupByFields
               is not specified and all the time
               series have the same resource
               type, then the time series are
               aggregated into a single output
               time series. If crossSeriesReducer
               is not defined, this field is
               ignored.
        :param str per_series_aligner: The approach to be used to align
               individual time series. Not all
               alignment functions may be applied
               to all time series, depending on
               the metric type and value type of
               the original time series.
               Alignment may change the metric
               type or the value type of the time
               series.Time series data must be
               aligned in order to perform cross-
               time series reduction. If
               crossSeriesReducer is specified,
               then perSeriesAligner must be
               specified and not equal ALIGN_NONE
               and alignmentPeriod must be
               specified; otherwise, an error is
               returned.
               Possible values are `ALIGN_NONE`, `ALIGN_DELTA`, `ALIGN_RATE`, `ALIGN_INTERPOLATE`, `ALIGN_NEXT_OLDER`, `ALIGN_MIN`, `ALIGN_MAX`, `ALIGN_MEAN`, `ALIGN_COUNT`, `ALIGN_SUM`, `ALIGN_STDDEV`, `ALIGN_COUNT_TRUE`, `ALIGN_COUNT_FALSE`, `ALIGN_FRACTION_TRUE`, `ALIGN_PERCENTILE_99`, `ALIGN_PERCENTILE_95`, `ALIGN_PERCENTILE_50`, `ALIGN_PERCENTILE_05`, and `ALIGN_PERCENT_CHANGE`.
        """
        if alignment_period is not None:
            pulumi.set(__self__, "alignment_period", alignment_period)
        if cross_series_reducer is not None:
            pulumi.set(__self__, "cross_series_reducer", cross_series_reducer)
        if group_by_fields is not None:
            pulumi.set(__self__, "group_by_fields", group_by_fields)
        if per_series_aligner is not None:
            pulumi.set(__self__, "per_series_aligner", per_series_aligner)

    @property
    @pulumi.getter(name="alignmentPeriod")
    def alignment_period(self) -> Optional[str]:
        """
        The alignment period for per-time
        series alignment. If present,
        alignmentPeriod must be at least
        60 seconds. After per-time series
        alignment, each time series will
        contain data points only on the
        period boundaries. If
        perSeriesAligner is not specified
        or equals ALIGN_NONE, then this
        field is ignored. If
        perSeriesAligner is specified and
        does not equal ALIGN_NONE, then
        this field must be defined;
        otherwise an error is returned.
        """
        return pulumi.get(self, "alignment_period")

    @property
    @pulumi.getter(name="crossSeriesReducer")
    def cross_series_reducer(self) -> Optional[str]:
        """
        The approach to be used to combine
        time series. Not all reducer
        functions may be applied to all
        time series, depending on the
        metric type and the value type of
        the original time series.
        Reduction may change the metric
        type of value type of the time
        series.Time series data must be
        aligned in order to perform cross-
        time series reduction. If
        crossSeriesReducer is specified,
        then perSeriesAligner must be
        specified and not equal ALIGN_NONE
        and alignmentPeriod must be
        specified; otherwise, an error is
        returned.
        Possible values are `REDUCE_NONE`, `REDUCE_MEAN`, `REDUCE_MIN`, `REDUCE_MAX`, `REDUCE_SUM`, `REDUCE_STDDEV`, `REDUCE_COUNT`, `REDUCE_COUNT_TRUE`, `REDUCE_COUNT_FALSE`, `REDUCE_FRACTION_TRUE`, `REDUCE_PERCENTILE_99`, `REDUCE_PERCENTILE_95`, `REDUCE_PERCENTILE_50`, and `REDUCE_PERCENTILE_05`.
        """
        return pulumi.get(self, "cross_series_reducer")

    @property
    @pulumi.getter(name="groupByFields")
    def group_by_fields(self) -> Optional[Sequence[str]]:
        """
        The set of fields to preserve when
        crossSeriesReducer is specified.
        The groupByFields determine how
        the time series are partitioned
        into subsets prior to applying the
        aggregation function. Each subset
        contains time series that have the
        same value for each of the
        grouping fields. Each individual
        time series is a member of exactly
        one subset. The crossSeriesReducer
        is applied to each subset of time
        series. It is not possible to
        reduce across different resource
        types, so this field implicitly
        contains resource.type. Fields not
        specified in groupByFields are
        aggregated away. If groupByFields
        is not specified and all the time
        series have the same resource
        type, then the time series are
        aggregated into a single output
        time series. If crossSeriesReducer
        is not defined, this field is
        ignored.
        """
        return pulumi.get(self, "group_by_fields")

    @property
    @pulumi.getter(name="perSeriesAligner")
    def per_series_aligner(self) -> Optional[str]:
        """
        The approach to be used to align
        individual time series. Not all
        alignment functions may be applied
        to all time series, depending on
        the metric type and value type of
        the original time series.
        Alignment may change the metric
        type or the value type of the time
        series.Time series data must be
        aligned in order to perform cross-
        time series reduction. If
        crossSeriesReducer is specified,
        then perSeriesAligner must be
        specified and not equal ALIGN_NONE
        and alignmentPeriod must be
        specified; otherwise, an error is
        returned.
        Possible values are `ALIGN_NONE`, `ALIGN_DELTA`, `ALIGN_RATE`, `ALIGN_INTERPOLATE`, `ALIGN_NEXT_OLDER`, `ALIGN_MIN`, `ALIGN_MAX`, `ALIGN_MEAN`, `ALIGN_COUNT`, `ALIGN_SUM`, `ALIGN_STDDEV`, `ALIGN_COUNT_TRUE`, `ALIGN_COUNT_FALSE`, `ALIGN_FRACTION_TRUE`, `ALIGN_PERCENTILE_99`, `ALIGN_PERCENTILE_95`, `ALIGN_PERCENTILE_50`, `ALIGN_PERCENTILE_05`, and `ALIGN_PERCENT_CHANGE`.
        """
        return pulumi.get(self, "per_series_aligner")


@pulumi.output_type
class AlertPolicyConditionConditionAbsentTrigger(dict):
    def __init__(__self__, *,
                 count: Optional[int] = None,
                 percent: Optional[float] = None):
        """
        :param int count: The absolute number of time series
               that must fail the predicate for the
               condition to be triggered.
        :param float percent: The percentage of time series that
               must fail the predicate for the
               condition to be triggered.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if percent is not None:
            pulumi.set(__self__, "percent", percent)

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        The absolute number of time series
        that must fail the predicate for the
        condition to be triggered.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def percent(self) -> Optional[float]:
        """
        The percentage of time series that
        must fail the predicate for the
        condition to be triggered.
        """
        return pulumi.get(self, "percent")


@pulumi.output_type
class AlertPolicyConditionConditionMatchedLog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labelExtractors":
            suggest = "label_extractors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyConditionConditionMatchedLog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyConditionConditionMatchedLog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyConditionConditionMatchedLog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter: str,
                 label_extractors: Optional[Mapping[str, str]] = None):
        """
        :param str filter: A logs-based filter.
        :param Mapping[str, str] label_extractors: A map from a label key to an extractor expression, which is used to
               extract the value for this label key. Each entry in this map is
               a specification for how data should be extracted from log entries that
               match filter. Each combination of extracted values is treated as
               a separate rule for the purposes of triggering notifications.
               Label keys and corresponding values can be used in notifications
               generated by this condition.
        """
        pulumi.set(__self__, "filter", filter)
        if label_extractors is not None:
            pulumi.set(__self__, "label_extractors", label_extractors)

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        A logs-based filter.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="labelExtractors")
    def label_extractors(self) -> Optional[Mapping[str, str]]:
        """
        A map from a label key to an extractor expression, which is used to
        extract the value for this label key. Each entry in this map is
        a specification for how data should be extracted from log entries that
        match filter. Each combination of extracted values is treated as
        a separate rule for the purposes of triggering notifications.
        Label keys and corresponding values can be used in notifications
        generated by this condition.
        """
        return pulumi.get(self, "label_extractors")


@pulumi.output_type
class AlertPolicyConditionConditionMonitoringQueryLanguage(dict):
    def __init__(__self__, *,
                 duration: str,
                 query: str,
                 trigger: Optional['outputs.AlertPolicyConditionConditionMonitoringQueryLanguageTrigger'] = None):
        """
        :param str duration: The amount of time that a time series must
               violate the threshold to be considered
               failing. Currently, only values that are a
               multiple of a minute--e.g., 0, 60, 120, or
               300 seconds--are supported. If an invalid
               value is given, an error will be returned.
               When choosing a duration, it is useful to
               keep in mind the frequency of the underlying
               time series data (which may also be affected
               by any alignments specified in the
               aggregations field); a good duration is long
               enough so that a single outlier does not
               generate spurious alerts, but short enough
               that unhealthy states are detected and
               alerted on quickly.
        :param str query: Monitoring Query Language query that outputs a boolean stream.
        :param 'AlertPolicyConditionConditionMonitoringQueryLanguageTriggerArgs' trigger: The number/percent of time series for which
               the comparison must hold in order for the
               condition to trigger. If unspecified, then
               the condition will trigger if the comparison
               is true for any of the time series that have
               been identified by filter and aggregations,
               or by the ratio, if denominator_filter and
               denominator_aggregations are specified.
               Structure is documented below.
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "query", query)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        The amount of time that a time series must
        violate the threshold to be considered
        failing. Currently, only values that are a
        multiple of a minute--e.g., 0, 60, 120, or
        300 seconds--are supported. If an invalid
        value is given, an error will be returned.
        When choosing a duration, it is useful to
        keep in mind the frequency of the underlying
        time series data (which may also be affected
        by any alignments specified in the
        aggregations field); a good duration is long
        enough so that a single outlier does not
        generate spurious alerts, but short enough
        that unhealthy states are detected and
        alerted on quickly.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        Monitoring Query Language query that outputs a boolean stream.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter
    def trigger(self) -> Optional['outputs.AlertPolicyConditionConditionMonitoringQueryLanguageTrigger']:
        """
        The number/percent of time series for which
        the comparison must hold in order for the
        condition to trigger. If unspecified, then
        the condition will trigger if the comparison
        is true for any of the time series that have
        been identified by filter and aggregations,
        or by the ratio, if denominator_filter and
        denominator_aggregations are specified.
        Structure is documented below.
        """
        return pulumi.get(self, "trigger")


@pulumi.output_type
class AlertPolicyConditionConditionMonitoringQueryLanguageTrigger(dict):
    def __init__(__self__, *,
                 count: Optional[int] = None,
                 percent: Optional[float] = None):
        """
        :param int count: The absolute number of time series
               that must fail the predicate for the
               condition to be triggered.
        :param float percent: The percentage of time series that
               must fail the predicate for the
               condition to be triggered.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if percent is not None:
            pulumi.set(__self__, "percent", percent)

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        The absolute number of time series
        that must fail the predicate for the
        condition to be triggered.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def percent(self) -> Optional[float]:
        """
        The percentage of time series that
        must fail the predicate for the
        condition to be triggered.
        """
        return pulumi.get(self, "percent")


@pulumi.output_type
class AlertPolicyConditionConditionThreshold(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "denominatorAggregations":
            suggest = "denominator_aggregations"
        elif key == "denominatorFilter":
            suggest = "denominator_filter"
        elif key == "thresholdValue":
            suggest = "threshold_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyConditionConditionThreshold. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyConditionConditionThreshold.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyConditionConditionThreshold.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 comparison: str,
                 duration: str,
                 aggregations: Optional[Sequence['outputs.AlertPolicyConditionConditionThresholdAggregation']] = None,
                 denominator_aggregations: Optional[Sequence['outputs.AlertPolicyConditionConditionThresholdDenominatorAggregation']] = None,
                 denominator_filter: Optional[str] = None,
                 filter: Optional[str] = None,
                 threshold_value: Optional[float] = None,
                 trigger: Optional['outputs.AlertPolicyConditionConditionThresholdTrigger'] = None):
        """
        :param str comparison: The comparison to apply between the time
               series (indicated by filter and aggregation)
               and the threshold (indicated by
               threshold_value). The comparison is applied
               on each time series, with the time series on
               the left-hand side and the threshold on the
               right-hand side. Only COMPARISON_LT and
               COMPARISON_GT are supported currently.
               Possible values are `COMPARISON_GT`, `COMPARISON_GE`, `COMPARISON_LT`, `COMPARISON_LE`, `COMPARISON_EQ`, and `COMPARISON_NE`.
        :param str duration: The amount of time that a time series must
               violate the threshold to be considered
               failing. Currently, only values that are a
               multiple of a minute--e.g., 0, 60, 120, or
               300 seconds--are supported. If an invalid
               value is given, an error will be returned.
               When choosing a duration, it is useful to
               keep in mind the frequency of the underlying
               time series data (which may also be affected
               by any alignments specified in the
               aggregations field); a good duration is long
               enough so that a single outlier does not
               generate spurious alerts, but short enough
               that unhealthy states are detected and
               alerted on quickly.
        :param Sequence['AlertPolicyConditionConditionThresholdAggregationArgs'] aggregations: Specifies the alignment of data points in
               individual time series as well as how to
               combine the retrieved time series together
               (such as when aggregating multiple streams
               on each resource to a single stream for each
               resource or when aggregating streams across
               all members of a group of resources).
               Multiple aggregations are applied in the
               order specified.This field is similar to the
               one in the MetricService.ListTimeSeries
               request. It is advisable to use the
               ListTimeSeries method when debugging this
               field.
               Structure is documented below.
        :param Sequence['AlertPolicyConditionConditionThresholdDenominatorAggregationArgs'] denominator_aggregations: Specifies the alignment of data points in
               individual time series selected by
               denominatorFilter as well as how to combine
               the retrieved time series together (such as
               when aggregating multiple streams on each
               resource to a single stream for each
               resource or when aggregating streams across
               all members of a group of resources).When
               computing ratios, the aggregations and
               denominator_aggregations fields must use the
               same alignment period and produce time
               series that have the same periodicity and
               labels.This field is similar to the one in
               the MetricService.ListTimeSeries request. It
               is advisable to use the ListTimeSeries
               method when debugging this field.
               Structure is documented below.
        :param str denominator_filter: A filter that identifies a time series that
               should be used as the denominator of a ratio
               that will be compared with the threshold. If
               a denominator_filter is specified, the time
               series specified by the filter field will be
               used as the numerator.The filter is similar
               to the one that is specified in the
               MetricService.ListTimeSeries request (that
               call is useful to verify the time series
               that will be retrieved / processed) and must
               specify the metric type and optionally may
               contain restrictions on resource type,
               resource labels, and metric labels. This
               field may not exceed 2048 Unicode characters
               in length.
        :param str filter: A logs-based filter.
        :param float threshold_value: A value against which to compare the time
               series.
        :param 'AlertPolicyConditionConditionThresholdTriggerArgs' trigger: The number/percent of time series for which
               the comparison must hold in order for the
               condition to trigger. If unspecified, then
               the condition will trigger if the comparison
               is true for any of the time series that have
               been identified by filter and aggregations,
               or by the ratio, if denominator_filter and
               denominator_aggregations are specified.
               Structure is documented below.
        """
        pulumi.set(__self__, "comparison", comparison)
        pulumi.set(__self__, "duration", duration)
        if aggregations is not None:
            pulumi.set(__self__, "aggregations", aggregations)
        if denominator_aggregations is not None:
            pulumi.set(__self__, "denominator_aggregations", denominator_aggregations)
        if denominator_filter is not None:
            pulumi.set(__self__, "denominator_filter", denominator_filter)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if threshold_value is not None:
            pulumi.set(__self__, "threshold_value", threshold_value)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)

    @property
    @pulumi.getter
    def comparison(self) -> str:
        """
        The comparison to apply between the time
        series (indicated by filter and aggregation)
        and the threshold (indicated by
        threshold_value). The comparison is applied
        on each time series, with the time series on
        the left-hand side and the threshold on the
        right-hand side. Only COMPARISON_LT and
        COMPARISON_GT are supported currently.
        Possible values are `COMPARISON_GT`, `COMPARISON_GE`, `COMPARISON_LT`, `COMPARISON_LE`, `COMPARISON_EQ`, and `COMPARISON_NE`.
        """
        return pulumi.get(self, "comparison")

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        The amount of time that a time series must
        violate the threshold to be considered
        failing. Currently, only values that are a
        multiple of a minute--e.g., 0, 60, 120, or
        300 seconds--are supported. If an invalid
        value is given, an error will be returned.
        When choosing a duration, it is useful to
        keep in mind the frequency of the underlying
        time series data (which may also be affected
        by any alignments specified in the
        aggregations field); a good duration is long
        enough so that a single outlier does not
        generate spurious alerts, but short enough
        that unhealthy states are detected and
        alerted on quickly.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def aggregations(self) -> Optional[Sequence['outputs.AlertPolicyConditionConditionThresholdAggregation']]:
        """
        Specifies the alignment of data points in
        individual time series as well as how to
        combine the retrieved time series together
        (such as when aggregating multiple streams
        on each resource to a single stream for each
        resource or when aggregating streams across
        all members of a group of resources).
        Multiple aggregations are applied in the
        order specified.This field is similar to the
        one in the MetricService.ListTimeSeries
        request. It is advisable to use the
        ListTimeSeries method when debugging this
        field.
        Structure is documented below.
        """
        return pulumi.get(self, "aggregations")

    @property
    @pulumi.getter(name="denominatorAggregations")
    def denominator_aggregations(self) -> Optional[Sequence['outputs.AlertPolicyConditionConditionThresholdDenominatorAggregation']]:
        """
        Specifies the alignment of data points in
        individual time series selected by
        denominatorFilter as well as how to combine
        the retrieved time series together (such as
        when aggregating multiple streams on each
        resource to a single stream for each
        resource or when aggregating streams across
        all members of a group of resources).When
        computing ratios, the aggregations and
        denominator_aggregations fields must use the
        same alignment period and produce time
        series that have the same periodicity and
        labels.This field is similar to the one in
        the MetricService.ListTimeSeries request. It
        is advisable to use the ListTimeSeries
        method when debugging this field.
        Structure is documented below.
        """
        return pulumi.get(self, "denominator_aggregations")

    @property
    @pulumi.getter(name="denominatorFilter")
    def denominator_filter(self) -> Optional[str]:
        """
        A filter that identifies a time series that
        should be used as the denominator of a ratio
        that will be compared with the threshold. If
        a denominator_filter is specified, the time
        series specified by the filter field will be
        used as the numerator.The filter is similar
        to the one that is specified in the
        MetricService.ListTimeSeries request (that
        call is useful to verify the time series
        that will be retrieved / processed) and must
        specify the metric type and optionally may
        contain restrictions on resource type,
        resource labels, and metric labels. This
        field may not exceed 2048 Unicode characters
        in length.
        """
        return pulumi.get(self, "denominator_filter")

    @property
    @pulumi.getter
    def filter(self) -> Optional[str]:
        """
        A logs-based filter.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="thresholdValue")
    def threshold_value(self) -> Optional[float]:
        """
        A value against which to compare the time
        series.
        """
        return pulumi.get(self, "threshold_value")

    @property
    @pulumi.getter
    def trigger(self) -> Optional['outputs.AlertPolicyConditionConditionThresholdTrigger']:
        """
        The number/percent of time series for which
        the comparison must hold in order for the
        condition to trigger. If unspecified, then
        the condition will trigger if the comparison
        is true for any of the time series that have
        been identified by filter and aggregations,
        or by the ratio, if denominator_filter and
        denominator_aggregations are specified.
        Structure is documented below.
        """
        return pulumi.get(self, "trigger")


@pulumi.output_type
class AlertPolicyConditionConditionThresholdAggregation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alignmentPeriod":
            suggest = "alignment_period"
        elif key == "crossSeriesReducer":
            suggest = "cross_series_reducer"
        elif key == "groupByFields":
            suggest = "group_by_fields"
        elif key == "perSeriesAligner":
            suggest = "per_series_aligner"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyConditionConditionThresholdAggregation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyConditionConditionThresholdAggregation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyConditionConditionThresholdAggregation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alignment_period: Optional[str] = None,
                 cross_series_reducer: Optional[str] = None,
                 group_by_fields: Optional[Sequence[str]] = None,
                 per_series_aligner: Optional[str] = None):
        """
        :param str alignment_period: The alignment period for per-time
               series alignment. If present,
               alignmentPeriod must be at least
               60 seconds. After per-time series
               alignment, each time series will
               contain data points only on the
               period boundaries. If
               perSeriesAligner is not specified
               or equals ALIGN_NONE, then this
               field is ignored. If
               perSeriesAligner is specified and
               does not equal ALIGN_NONE, then
               this field must be defined;
               otherwise an error is returned.
        :param str cross_series_reducer: The approach to be used to combine
               time series. Not all reducer
               functions may be applied to all
               time series, depending on the
               metric type and the value type of
               the original time series.
               Reduction may change the metric
               type of value type of the time
               series.Time series data must be
               aligned in order to perform cross-
               time series reduction. If
               crossSeriesReducer is specified,
               then perSeriesAligner must be
               specified and not equal ALIGN_NONE
               and alignmentPeriod must be
               specified; otherwise, an error is
               returned.
               Possible values are `REDUCE_NONE`, `REDUCE_MEAN`, `REDUCE_MIN`, `REDUCE_MAX`, `REDUCE_SUM`, `REDUCE_STDDEV`, `REDUCE_COUNT`, `REDUCE_COUNT_TRUE`, `REDUCE_COUNT_FALSE`, `REDUCE_FRACTION_TRUE`, `REDUCE_PERCENTILE_99`, `REDUCE_PERCENTILE_95`, `REDUCE_PERCENTILE_50`, and `REDUCE_PERCENTILE_05`.
        :param Sequence[str] group_by_fields: The set of fields to preserve when
               crossSeriesReducer is specified.
               The groupByFields determine how
               the time series are partitioned
               into subsets prior to applying the
               aggregation function. Each subset
               contains time series that have the
               same value for each of the
               grouping fields. Each individual
               time series is a member of exactly
               one subset. The crossSeriesReducer
               is applied to each subset of time
               series. It is not possible to
               reduce across different resource
               types, so this field implicitly
               contains resource.type. Fields not
               specified in groupByFields are
               aggregated away. If groupByFields
               is not specified and all the time
               series have the same resource
               type, then the time series are
               aggregated into a single output
               time series. If crossSeriesReducer
               is not defined, this field is
               ignored.
        :param str per_series_aligner: The approach to be used to align
               individual time series. Not all
               alignment functions may be applied
               to all time series, depending on
               the metric type and value type of
               the original time series.
               Alignment may change the metric
               type or the value type of the time
               series.Time series data must be
               aligned in order to perform cross-
               time series reduction. If
               crossSeriesReducer is specified,
               then perSeriesAligner must be
               specified and not equal ALIGN_NONE
               and alignmentPeriod must be
               specified; otherwise, an error is
               returned.
               Possible values are `ALIGN_NONE`, `ALIGN_DELTA`, `ALIGN_RATE`, `ALIGN_INTERPOLATE`, `ALIGN_NEXT_OLDER`, `ALIGN_MIN`, `ALIGN_MAX`, `ALIGN_MEAN`, `ALIGN_COUNT`, `ALIGN_SUM`, `ALIGN_STDDEV`, `ALIGN_COUNT_TRUE`, `ALIGN_COUNT_FALSE`, `ALIGN_FRACTION_TRUE`, `ALIGN_PERCENTILE_99`, `ALIGN_PERCENTILE_95`, `ALIGN_PERCENTILE_50`, `ALIGN_PERCENTILE_05`, and `ALIGN_PERCENT_CHANGE`.
        """
        if alignment_period is not None:
            pulumi.set(__self__, "alignment_period", alignment_period)
        if cross_series_reducer is not None:
            pulumi.set(__self__, "cross_series_reducer", cross_series_reducer)
        if group_by_fields is not None:
            pulumi.set(__self__, "group_by_fields", group_by_fields)
        if per_series_aligner is not None:
            pulumi.set(__self__, "per_series_aligner", per_series_aligner)

    @property
    @pulumi.getter(name="alignmentPeriod")
    def alignment_period(self) -> Optional[str]:
        """
        The alignment period for per-time
        series alignment. If present,
        alignmentPeriod must be at least
        60 seconds. After per-time series
        alignment, each time series will
        contain data points only on the
        period boundaries. If
        perSeriesAligner is not specified
        or equals ALIGN_NONE, then this
        field is ignored. If
        perSeriesAligner is specified and
        does not equal ALIGN_NONE, then
        this field must be defined;
        otherwise an error is returned.
        """
        return pulumi.get(self, "alignment_period")

    @property
    @pulumi.getter(name="crossSeriesReducer")
    def cross_series_reducer(self) -> Optional[str]:
        """
        The approach to be used to combine
        time series. Not all reducer
        functions may be applied to all
        time series, depending on the
        metric type and the value type of
        the original time series.
        Reduction may change the metric
        type of value type of the time
        series.Time series data must be
        aligned in order to perform cross-
        time series reduction. If
        crossSeriesReducer is specified,
        then perSeriesAligner must be
        specified and not equal ALIGN_NONE
        and alignmentPeriod must be
        specified; otherwise, an error is
        returned.
        Possible values are `REDUCE_NONE`, `REDUCE_MEAN`, `REDUCE_MIN`, `REDUCE_MAX`, `REDUCE_SUM`, `REDUCE_STDDEV`, `REDUCE_COUNT`, `REDUCE_COUNT_TRUE`, `REDUCE_COUNT_FALSE`, `REDUCE_FRACTION_TRUE`, `REDUCE_PERCENTILE_99`, `REDUCE_PERCENTILE_95`, `REDUCE_PERCENTILE_50`, and `REDUCE_PERCENTILE_05`.
        """
        return pulumi.get(self, "cross_series_reducer")

    @property
    @pulumi.getter(name="groupByFields")
    def group_by_fields(self) -> Optional[Sequence[str]]:
        """
        The set of fields to preserve when
        crossSeriesReducer is specified.
        The groupByFields determine how
        the time series are partitioned
        into subsets prior to applying the
        aggregation function. Each subset
        contains time series that have the
        same value for each of the
        grouping fields. Each individual
        time series is a member of exactly
        one subset. The crossSeriesReducer
        is applied to each subset of time
        series. It is not possible to
        reduce across different resource
        types, so this field implicitly
        contains resource.type. Fields not
        specified in groupByFields are
        aggregated away. If groupByFields
        is not specified and all the time
        series have the same resource
        type, then the time series are
        aggregated into a single output
        time series. If crossSeriesReducer
        is not defined, this field is
        ignored.
        """
        return pulumi.get(self, "group_by_fields")

    @property
    @pulumi.getter(name="perSeriesAligner")
    def per_series_aligner(self) -> Optional[str]:
        """
        The approach to be used to align
        individual time series. Not all
        alignment functions may be applied
        to all time series, depending on
        the metric type and value type of
        the original time series.
        Alignment may change the metric
        type or the value type of the time
        series.Time series data must be
        aligned in order to perform cross-
        time series reduction. If
        crossSeriesReducer is specified,
        then perSeriesAligner must be
        specified and not equal ALIGN_NONE
        and alignmentPeriod must be
        specified; otherwise, an error is
        returned.
        Possible values are `ALIGN_NONE`, `ALIGN_DELTA`, `ALIGN_RATE`, `ALIGN_INTERPOLATE`, `ALIGN_NEXT_OLDER`, `ALIGN_MIN`, `ALIGN_MAX`, `ALIGN_MEAN`, `ALIGN_COUNT`, `ALIGN_SUM`, `ALIGN_STDDEV`, `ALIGN_COUNT_TRUE`, `ALIGN_COUNT_FALSE`, `ALIGN_FRACTION_TRUE`, `ALIGN_PERCENTILE_99`, `ALIGN_PERCENTILE_95`, `ALIGN_PERCENTILE_50`, `ALIGN_PERCENTILE_05`, and `ALIGN_PERCENT_CHANGE`.
        """
        return pulumi.get(self, "per_series_aligner")


@pulumi.output_type
class AlertPolicyConditionConditionThresholdDenominatorAggregation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alignmentPeriod":
            suggest = "alignment_period"
        elif key == "crossSeriesReducer":
            suggest = "cross_series_reducer"
        elif key == "groupByFields":
            suggest = "group_by_fields"
        elif key == "perSeriesAligner":
            suggest = "per_series_aligner"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyConditionConditionThresholdDenominatorAggregation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyConditionConditionThresholdDenominatorAggregation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyConditionConditionThresholdDenominatorAggregation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alignment_period: Optional[str] = None,
                 cross_series_reducer: Optional[str] = None,
                 group_by_fields: Optional[Sequence[str]] = None,
                 per_series_aligner: Optional[str] = None):
        """
        :param str alignment_period: The alignment period for per-time
               series alignment. If present,
               alignmentPeriod must be at least
               60 seconds. After per-time series
               alignment, each time series will
               contain data points only on the
               period boundaries. If
               perSeriesAligner is not specified
               or equals ALIGN_NONE, then this
               field is ignored. If
               perSeriesAligner is specified and
               does not equal ALIGN_NONE, then
               this field must be defined;
               otherwise an error is returned.
        :param str cross_series_reducer: The approach to be used to combine
               time series. Not all reducer
               functions may be applied to all
               time series, depending on the
               metric type and the value type of
               the original time series.
               Reduction may change the metric
               type of value type of the time
               series.Time series data must be
               aligned in order to perform cross-
               time series reduction. If
               crossSeriesReducer is specified,
               then perSeriesAligner must be
               specified and not equal ALIGN_NONE
               and alignmentPeriod must be
               specified; otherwise, an error is
               returned.
               Possible values are `REDUCE_NONE`, `REDUCE_MEAN`, `REDUCE_MIN`, `REDUCE_MAX`, `REDUCE_SUM`, `REDUCE_STDDEV`, `REDUCE_COUNT`, `REDUCE_COUNT_TRUE`, `REDUCE_COUNT_FALSE`, `REDUCE_FRACTION_TRUE`, `REDUCE_PERCENTILE_99`, `REDUCE_PERCENTILE_95`, `REDUCE_PERCENTILE_50`, and `REDUCE_PERCENTILE_05`.
        :param Sequence[str] group_by_fields: The set of fields to preserve when
               crossSeriesReducer is specified.
               The groupByFields determine how
               the time series are partitioned
               into subsets prior to applying the
               aggregation function. Each subset
               contains time series that have the
               same value for each of the
               grouping fields. Each individual
               time series is a member of exactly
               one subset. The crossSeriesReducer
               is applied to each subset of time
               series. It is not possible to
               reduce across different resource
               types, so this field implicitly
               contains resource.type. Fields not
               specified in groupByFields are
               aggregated away. If groupByFields
               is not specified and all the time
               series have the same resource
               type, then the time series are
               aggregated into a single output
               time series. If crossSeriesReducer
               is not defined, this field is
               ignored.
        :param str per_series_aligner: The approach to be used to align
               individual time series. Not all
               alignment functions may be applied
               to all time series, depending on
               the metric type and value type of
               the original time series.
               Alignment may change the metric
               type or the value type of the time
               series.Time series data must be
               aligned in order to perform cross-
               time series reduction. If
               crossSeriesReducer is specified,
               then perSeriesAligner must be
               specified and not equal ALIGN_NONE
               and alignmentPeriod must be
               specified; otherwise, an error is
               returned.
               Possible values are `ALIGN_NONE`, `ALIGN_DELTA`, `ALIGN_RATE`, `ALIGN_INTERPOLATE`, `ALIGN_NEXT_OLDER`, `ALIGN_MIN`, `ALIGN_MAX`, `ALIGN_MEAN`, `ALIGN_COUNT`, `ALIGN_SUM`, `ALIGN_STDDEV`, `ALIGN_COUNT_TRUE`, `ALIGN_COUNT_FALSE`, `ALIGN_FRACTION_TRUE`, `ALIGN_PERCENTILE_99`, `ALIGN_PERCENTILE_95`, `ALIGN_PERCENTILE_50`, `ALIGN_PERCENTILE_05`, and `ALIGN_PERCENT_CHANGE`.
        """
        if alignment_period is not None:
            pulumi.set(__self__, "alignment_period", alignment_period)
        if cross_series_reducer is not None:
            pulumi.set(__self__, "cross_series_reducer", cross_series_reducer)
        if group_by_fields is not None:
            pulumi.set(__self__, "group_by_fields", group_by_fields)
        if per_series_aligner is not None:
            pulumi.set(__self__, "per_series_aligner", per_series_aligner)

    @property
    @pulumi.getter(name="alignmentPeriod")
    def alignment_period(self) -> Optional[str]:
        """
        The alignment period for per-time
        series alignment. If present,
        alignmentPeriod must be at least
        60 seconds. After per-time series
        alignment, each time series will
        contain data points only on the
        period boundaries. If
        perSeriesAligner is not specified
        or equals ALIGN_NONE, then this
        field is ignored. If
        perSeriesAligner is specified and
        does not equal ALIGN_NONE, then
        this field must be defined;
        otherwise an error is returned.
        """
        return pulumi.get(self, "alignment_period")

    @property
    @pulumi.getter(name="crossSeriesReducer")
    def cross_series_reducer(self) -> Optional[str]:
        """
        The approach to be used to combine
        time series. Not all reducer
        functions may be applied to all
        time series, depending on the
        metric type and the value type of
        the original time series.
        Reduction may change the metric
        type of value type of the time
        series.Time series data must be
        aligned in order to perform cross-
        time series reduction. If
        crossSeriesReducer is specified,
        then perSeriesAligner must be
        specified and not equal ALIGN_NONE
        and alignmentPeriod must be
        specified; otherwise, an error is
        returned.
        Possible values are `REDUCE_NONE`, `REDUCE_MEAN`, `REDUCE_MIN`, `REDUCE_MAX`, `REDUCE_SUM`, `REDUCE_STDDEV`, `REDUCE_COUNT`, `REDUCE_COUNT_TRUE`, `REDUCE_COUNT_FALSE`, `REDUCE_FRACTION_TRUE`, `REDUCE_PERCENTILE_99`, `REDUCE_PERCENTILE_95`, `REDUCE_PERCENTILE_50`, and `REDUCE_PERCENTILE_05`.
        """
        return pulumi.get(self, "cross_series_reducer")

    @property
    @pulumi.getter(name="groupByFields")
    def group_by_fields(self) -> Optional[Sequence[str]]:
        """
        The set of fields to preserve when
        crossSeriesReducer is specified.
        The groupByFields determine how
        the time series are partitioned
        into subsets prior to applying the
        aggregation function. Each subset
        contains time series that have the
        same value for each of the
        grouping fields. Each individual
        time series is a member of exactly
        one subset. The crossSeriesReducer
        is applied to each subset of time
        series. It is not possible to
        reduce across different resource
        types, so this field implicitly
        contains resource.type. Fields not
        specified in groupByFields are
        aggregated away. If groupByFields
        is not specified and all the time
        series have the same resource
        type, then the time series are
        aggregated into a single output
        time series. If crossSeriesReducer
        is not defined, this field is
        ignored.
        """
        return pulumi.get(self, "group_by_fields")

    @property
    @pulumi.getter(name="perSeriesAligner")
    def per_series_aligner(self) -> Optional[str]:
        """
        The approach to be used to align
        individual time series. Not all
        alignment functions may be applied
        to all time series, depending on
        the metric type and value type of
        the original time series.
        Alignment may change the metric
        type or the value type of the time
        series.Time series data must be
        aligned in order to perform cross-
        time series reduction. If
        crossSeriesReducer is specified,
        then perSeriesAligner must be
        specified and not equal ALIGN_NONE
        and alignmentPeriod must be
        specified; otherwise, an error is
        returned.
        Possible values are `ALIGN_NONE`, `ALIGN_DELTA`, `ALIGN_RATE`, `ALIGN_INTERPOLATE`, `ALIGN_NEXT_OLDER`, `ALIGN_MIN`, `ALIGN_MAX`, `ALIGN_MEAN`, `ALIGN_COUNT`, `ALIGN_SUM`, `ALIGN_STDDEV`, `ALIGN_COUNT_TRUE`, `ALIGN_COUNT_FALSE`, `ALIGN_FRACTION_TRUE`, `ALIGN_PERCENTILE_99`, `ALIGN_PERCENTILE_95`, `ALIGN_PERCENTILE_50`, `ALIGN_PERCENTILE_05`, and `ALIGN_PERCENT_CHANGE`.
        """
        return pulumi.get(self, "per_series_aligner")


@pulumi.output_type
class AlertPolicyConditionConditionThresholdTrigger(dict):
    def __init__(__self__, *,
                 count: Optional[int] = None,
                 percent: Optional[float] = None):
        """
        :param int count: The absolute number of time series
               that must fail the predicate for the
               condition to be triggered.
        :param float percent: The percentage of time series that
               must fail the predicate for the
               condition to be triggered.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if percent is not None:
            pulumi.set(__self__, "percent", percent)

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        The absolute number of time series
        that must fail the predicate for the
        condition to be triggered.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def percent(self) -> Optional[float]:
        """
        The percentage of time series that
        must fail the predicate for the
        condition to be triggered.
        """
        return pulumi.get(self, "percent")


@pulumi.output_type
class AlertPolicyCreationRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mutateTime":
            suggest = "mutate_time"
        elif key == "mutatedBy":
            suggest = "mutated_by"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyCreationRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyCreationRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyCreationRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mutate_time: Optional[str] = None,
                 mutated_by: Optional[str] = None):
        if mutate_time is not None:
            pulumi.set(__self__, "mutate_time", mutate_time)
        if mutated_by is not None:
            pulumi.set(__self__, "mutated_by", mutated_by)

    @property
    @pulumi.getter(name="mutateTime")
    def mutate_time(self) -> Optional[str]:
        return pulumi.get(self, "mutate_time")

    @property
    @pulumi.getter(name="mutatedBy")
    def mutated_by(self) -> Optional[str]:
        return pulumi.get(self, "mutated_by")


@pulumi.output_type
class AlertPolicyDocumentation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mimeType":
            suggest = "mime_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertPolicyDocumentation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertPolicyDocumentation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertPolicyDocumentation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: Optional[str] = None,
                 mime_type: Optional[str] = None):
        """
        :param str content: The text of the documentation, interpreted according to mimeType.
               The content may not exceed 8,192 Unicode characters and may not
               exceed more than 10,240 bytes when encoded in UTF-8 format,
               whichever is smaller.
        :param str mime_type: The format of the content field. Presently, only the value
               "text/markdown" is supported.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if mime_type is not None:
            pulumi.set(__self__, "mime_type", mime_type)

    @property
    @pulumi.getter
    def content(self) -> Optional[str]:
        """
        The text of the documentation, interpreted according to mimeType.
        The content may not exceed 8,192 Unicode characters and may not
        exceed more than 10,240 bytes when encoded in UTF-8 format,
        whichever is smaller.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> Optional[str]:
        """
        The format of the content field. Presently, only the value
        "text/markdown" is supported.
        """
        return pulumi.get(self, "mime_type")


@pulumi.output_type
class CustomServiceTelemetry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceName":
            suggest = "resource_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomServiceTelemetry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomServiceTelemetry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomServiceTelemetry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_name: Optional[str] = None):
        """
        :param str resource_name: The full name of the resource that defines this service.
               Formatted as described in
               https://cloud.google.com/apis/design/resource_names.
        """
        if resource_name is not None:
            pulumi.set(__self__, "resource_name", resource_name)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[str]:
        """
        The full name of the resource that defines this service.
        Formatted as described in
        https://cloud.google.com/apis/design/resource_names.
        """
        return pulumi.get(self, "resource_name")


@pulumi.output_type
class MetricDescriptorLabel(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueType":
            suggest = "value_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricDescriptorLabel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricDescriptorLabel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricDescriptorLabel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 description: Optional[str] = None,
                 value_type: Optional[str] = None):
        """
        :param str key: The key for this label. The key must not exceed 100 characters. The first character of the key must be an upper- or lower-case letter, the remaining characters must be letters, digits or underscores, and the key must match the regular expression [a-zA-Z][a-zA-Z0-9_]*
        :param str description: A human-readable description for the label.
        :param str value_type: The type of data that can be assigned to the label.
               Default value is `STRING`.
               Possible values are `STRING`, `BOOL`, and `INT64`.
        """
        pulumi.set(__self__, "key", key)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if value_type is not None:
            pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key for this label. The key must not exceed 100 characters. The first character of the key must be an upper- or lower-case letter, the remaining characters must be letters, digits or underscores, and the key must match the regular expression [a-zA-Z][a-zA-Z0-9_]*
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A human-readable description for the label.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> Optional[str]:
        """
        The type of data that can be assigned to the label.
        Default value is `STRING`.
        Possible values are `STRING`, `BOOL`, and `INT64`.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class MetricDescriptorMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ingestDelay":
            suggest = "ingest_delay"
        elif key == "samplePeriod":
            suggest = "sample_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricDescriptorMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricDescriptorMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricDescriptorMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ingest_delay: Optional[str] = None,
                 sample_period: Optional[str] = None):
        """
        :param str ingest_delay: The delay of data points caused by ingestion. Data points older than this age are guaranteed to be ingested and available to be read, excluding data loss due to errors. In `[duration format](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf?&_ga=2.264881487.1507873253.1593446723-935052455.1591817775#google.protobuf.Duration)`.
        :param str sample_period: The sampling period of metric data points. For metrics which are written periodically, consecutive data points are stored at this time interval, excluding data loss due to errors. Metrics with a higher granularity have a smaller sampling period. In `[duration format](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf?&_ga=2.264881487.1507873253.1593446723-935052455.1591817775#google.protobuf.Duration)`.
        """
        if ingest_delay is not None:
            pulumi.set(__self__, "ingest_delay", ingest_delay)
        if sample_period is not None:
            pulumi.set(__self__, "sample_period", sample_period)

    @property
    @pulumi.getter(name="ingestDelay")
    def ingest_delay(self) -> Optional[str]:
        """
        The delay of data points caused by ingestion. Data points older than this age are guaranteed to be ingested and available to be read, excluding data loss due to errors. In `[duration format](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf?&_ga=2.264881487.1507873253.1593446723-935052455.1591817775#google.protobuf.Duration)`.
        """
        return pulumi.get(self, "ingest_delay")

    @property
    @pulumi.getter(name="samplePeriod")
    def sample_period(self) -> Optional[str]:
        """
        The sampling period of metric data points. For metrics which are written periodically, consecutive data points are stored at this time interval, excluding data loss due to errors. Metrics with a higher granularity have a smaller sampling period. In `[duration format](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf?&_ga=2.264881487.1507873253.1593446723-935052455.1591817775#google.protobuf.Duration)`.
        """
        return pulumi.get(self, "sample_period")


@pulumi.output_type
class NotificationChannelSensitiveLabels(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authToken":
            suggest = "auth_token"
        elif key == "serviceKey":
            suggest = "service_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationChannelSensitiveLabels. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationChannelSensitiveLabels.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationChannelSensitiveLabels.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_token: Optional[str] = None,
                 password: Optional[str] = None,
                 service_key: Optional[str] = None):
        """
        :param str auth_token: An authorization token for a notification channel. Channel types that support this field include: slack
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str password: An password for a notification channel. Channel types that support this field include: webhook_basicauth
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str service_key: An servicekey token for a notification channel. Channel types that support this field include: pagerduty
               **Note**: This property is sensitive and will not be displayed in the plan.
        """
        if auth_token is not None:
            pulumi.set(__self__, "auth_token", auth_token)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if service_key is not None:
            pulumi.set(__self__, "service_key", service_key)

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional[str]:
        """
        An authorization token for a notification channel. Channel types that support this field include: slack
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "auth_token")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        An password for a notification channel. Channel types that support this field include: webhook_basicauth
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="serviceKey")
    def service_key(self) -> Optional[str]:
        """
        An servicekey token for a notification channel. Channel types that support this field include: pagerduty
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "service_key")


@pulumi.output_type
class SloBasicSli(dict):
    def __init__(__self__, *,
                 availability: Optional['outputs.SloBasicSliAvailability'] = None,
                 latency: Optional['outputs.SloBasicSliLatency'] = None,
                 locations: Optional[Sequence[str]] = None,
                 methods: Optional[Sequence[str]] = None,
                 versions: Optional[Sequence[str]] = None):
        """
        :param 'SloBasicSliAvailabilityArgs' availability: Availability based SLI, dervied from count of requests made to this service that return successfully.
               Structure is documented below.
        :param 'SloBasicSliLatencyArgs' latency: Parameters for a latency threshold SLI.
               Structure is documented below.
        :param Sequence[str] locations: An optional set of locations to which this SLI is relevant.
               Telemetry from other locations will not be used to calculate
               performance for this SLI. If omitted, this SLI applies to all
               locations in which the Service has activity. For service types
               that don't support breaking down by location, setting this
               field will result in an error.
        :param Sequence[str] methods: An optional set of RPCs to which this SLI is relevant.
               Telemetry from other methods will not be used to calculate
               performance for this SLI. If omitted, this SLI applies to all
               the Service's methods. For service types that don't support
               breaking down by method, setting this field will result in an
               error.
        :param Sequence[str] versions: The set of API versions to which this SLI is relevant.
               Telemetry from other API versions will not be used to
               calculate performance for this SLI. If omitted,
               this SLI applies to all API versions. For service types
               that don't support breaking down by version, setting this
               field will result in an error.
        """
        if availability is not None:
            pulumi.set(__self__, "availability", availability)
        if latency is not None:
            pulumi.set(__self__, "latency", latency)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if methods is not None:
            pulumi.set(__self__, "methods", methods)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @property
    @pulumi.getter
    def availability(self) -> Optional['outputs.SloBasicSliAvailability']:
        """
        Availability based SLI, dervied from count of requests made to this service that return successfully.
        Structure is documented below.
        """
        return pulumi.get(self, "availability")

    @property
    @pulumi.getter
    def latency(self) -> Optional['outputs.SloBasicSliLatency']:
        """
        Parameters for a latency threshold SLI.
        Structure is documented below.
        """
        return pulumi.get(self, "latency")

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence[str]]:
        """
        An optional set of locations to which this SLI is relevant.
        Telemetry from other locations will not be used to calculate
        performance for this SLI. If omitted, this SLI applies to all
        locations in which the Service has activity. For service types
        that don't support breaking down by location, setting this
        field will result in an error.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def methods(self) -> Optional[Sequence[str]]:
        """
        An optional set of RPCs to which this SLI is relevant.
        Telemetry from other methods will not be used to calculate
        performance for this SLI. If omitted, this SLI applies to all
        the Service's methods. For service types that don't support
        breaking down by method, setting this field will result in an
        error.
        """
        return pulumi.get(self, "methods")

    @property
    @pulumi.getter
    def versions(self) -> Optional[Sequence[str]]:
        """
        The set of API versions to which this SLI is relevant.
        Telemetry from other API versions will not be used to
        calculate performance for this SLI. If omitted,
        this SLI applies to all API versions. For service types
        that don't support breaking down by version, setting this
        field will result in an error.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class SloBasicSliAvailability(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        :param bool enabled: Whether an availability SLI is enabled or not. Must be set to `true. Defaults to `true`.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether an availability SLI is enabled or not. Must be set to `true. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class SloBasicSliLatency(dict):
    def __init__(__self__, *,
                 threshold: str):
        """
        :param str threshold: A duration string, e.g. 10s.
               Good service is defined to be the count of requests made to
               this service that return in no more than threshold.
        """
        pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def threshold(self) -> str:
        """
        A duration string, e.g. 10s.
        Good service is defined to be the count of requests made to
        this service that return in no more than threshold.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class SloRequestBasedSli(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "distributionCut":
            suggest = "distribution_cut"
        elif key == "goodTotalRatio":
            suggest = "good_total_ratio"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SloRequestBasedSli. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SloRequestBasedSli.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SloRequestBasedSli.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distribution_cut: Optional['outputs.SloRequestBasedSliDistributionCut'] = None,
                 good_total_ratio: Optional['outputs.SloRequestBasedSliGoodTotalRatio'] = None):
        """
        :param 'SloRequestBasedSliDistributionCutArgs' distribution_cut: Used when good_service is defined by a count of values aggregated in a
               Distribution that fall into a good range. The total_service is the
               total count of all values aggregated in the Distribution.
               Defines a distribution TimeSeries filter and thresholds used for
               measuring good service and total service.
               Structure is documented below.
        :param 'SloRequestBasedSliGoodTotalRatioArgs' good_total_ratio: A means to compute a ratio of `good_service` to `total_service`.
               Defines computing this ratio with two TimeSeries [monitoring filters](https://cloud.google.com/monitoring/api/v3/filters)
               Must specify exactly two of good, bad, and total service filters.
               The relationship good_service + bad_service = total_service
               will be assumed.
               Structure is documented below.
        """
        if distribution_cut is not None:
            pulumi.set(__self__, "distribution_cut", distribution_cut)
        if good_total_ratio is not None:
            pulumi.set(__self__, "good_total_ratio", good_total_ratio)

    @property
    @pulumi.getter(name="distributionCut")
    def distribution_cut(self) -> Optional['outputs.SloRequestBasedSliDistributionCut']:
        """
        Used when good_service is defined by a count of values aggregated in a
        Distribution that fall into a good range. The total_service is the
        total count of all values aggregated in the Distribution.
        Defines a distribution TimeSeries filter and thresholds used for
        measuring good service and total service.
        Structure is documented below.
        """
        return pulumi.get(self, "distribution_cut")

    @property
    @pulumi.getter(name="goodTotalRatio")
    def good_total_ratio(self) -> Optional['outputs.SloRequestBasedSliGoodTotalRatio']:
        """
        A means to compute a ratio of `good_service` to `total_service`.
        Defines computing this ratio with two TimeSeries [monitoring filters](https://cloud.google.com/monitoring/api/v3/filters)
        Must specify exactly two of good, bad, and total service filters.
        The relationship good_service + bad_service = total_service
        will be assumed.
        Structure is documented below.
        """
        return pulumi.get(self, "good_total_ratio")


@pulumi.output_type
class SloRequestBasedSliDistributionCut(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "distributionFilter":
            suggest = "distribution_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SloRequestBasedSliDistributionCut. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SloRequestBasedSliDistributionCut.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SloRequestBasedSliDistributionCut.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distribution_filter: str,
                 range: 'outputs.SloRequestBasedSliDistributionCutRange'):
        """
        :param str distribution_filter: A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
               aggregating values to quantify the good service provided.
               Must have ValueType = DISTRIBUTION and
               MetricKind = DELTA or MetricKind = CUMULATIVE.
        :param 'SloRequestBasedSliDistributionCutRangeArgs' range: Range of numerical values. The computed good_service
               will be the count of values x in the Distribution such
               that range.min <= x <= range.max. inclusive of min and
               max. Open ranges can be defined by setting
               just one of min or max. Summed value `X` should satisfy
               `range.min <= X <= range.max` for a good window.
               Structure is documented below.
        """
        pulumi.set(__self__, "distribution_filter", distribution_filter)
        pulumi.set(__self__, "range", range)

    @property
    @pulumi.getter(name="distributionFilter")
    def distribution_filter(self) -> str:
        """
        A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        aggregating values to quantify the good service provided.
        Must have ValueType = DISTRIBUTION and
        MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        return pulumi.get(self, "distribution_filter")

    @property
    @pulumi.getter
    def range(self) -> 'outputs.SloRequestBasedSliDistributionCutRange':
        """
        Range of numerical values. The computed good_service
        will be the count of values x in the Distribution such
        that range.min <= x <= range.max. inclusive of min and
        max. Open ranges can be defined by setting
        just one of min or max. Summed value `X` should satisfy
        `range.min <= X <= range.max` for a good window.
        Structure is documented below.
        """
        return pulumi.get(self, "range")


@pulumi.output_type
class SloRequestBasedSliDistributionCutRange(dict):
    def __init__(__self__, *,
                 max: Optional[float] = None,
                 min: Optional[float] = None):
        """
        :param float max: max value for the range (inclusive). If not given,
               will be set to "infinity", defining an open range
               ">= range.min"
        :param float min: Min value for the range (inclusive). If not given,
               will be set to "-infinity", defining an open range
               "< range.max"
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[float]:
        """
        max value for the range (inclusive). If not given,
        will be set to "infinity", defining an open range
        ">= range.min"
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[float]:
        """
        Min value for the range (inclusive). If not given,
        will be set to "-infinity", defining an open range
        "< range.max"
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class SloRequestBasedSliGoodTotalRatio(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "badServiceFilter":
            suggest = "bad_service_filter"
        elif key == "goodServiceFilter":
            suggest = "good_service_filter"
        elif key == "totalServiceFilter":
            suggest = "total_service_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SloRequestBasedSliGoodTotalRatio. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SloRequestBasedSliGoodTotalRatio.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SloRequestBasedSliGoodTotalRatio.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bad_service_filter: Optional[str] = None,
                 good_service_filter: Optional[str] = None,
                 total_service_filter: Optional[str] = None):
        """
        :param str bad_service_filter: A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
               quantifying bad service provided, either demanded service that
               was not provided or demanded service that was of inadequate
               quality. Exactly two of
               good, bad, or total service filter must be defined (where
               good + bad = total is assumed)
               Must have ValueType = DOUBLE or ValueType = INT64 and
               must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        :param str good_service_filter: A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
               quantifying good service provided. Exactly two of
               good, bad, or total service filter must be defined (where
               good + bad = total is assumed)
               Must have ValueType = DOUBLE or ValueType = INT64 and
               must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        :param str total_service_filter: A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
               quantifying total demanded service. Exactly two of
               good, bad, or total service filter must be defined (where
               good + bad = total is assumed)
               Must have ValueType = DOUBLE or ValueType = INT64 and
               must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        if bad_service_filter is not None:
            pulumi.set(__self__, "bad_service_filter", bad_service_filter)
        if good_service_filter is not None:
            pulumi.set(__self__, "good_service_filter", good_service_filter)
        if total_service_filter is not None:
            pulumi.set(__self__, "total_service_filter", total_service_filter)

    @property
    @pulumi.getter(name="badServiceFilter")
    def bad_service_filter(self) -> Optional[str]:
        """
        A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        quantifying bad service provided, either demanded service that
        was not provided or demanded service that was of inadequate
        quality. Exactly two of
        good, bad, or total service filter must be defined (where
        good + bad = total is assumed)
        Must have ValueType = DOUBLE or ValueType = INT64 and
        must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        return pulumi.get(self, "bad_service_filter")

    @property
    @pulumi.getter(name="goodServiceFilter")
    def good_service_filter(self) -> Optional[str]:
        """
        A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        quantifying good service provided. Exactly two of
        good, bad, or total service filter must be defined (where
        good + bad = total is assumed)
        Must have ValueType = DOUBLE or ValueType = INT64 and
        must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        return pulumi.get(self, "good_service_filter")

    @property
    @pulumi.getter(name="totalServiceFilter")
    def total_service_filter(self) -> Optional[str]:
        """
        A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        quantifying total demanded service. Exactly two of
        good, bad, or total service filter must be defined (where
        good + bad = total is assumed)
        Must have ValueType = DOUBLE or ValueType = INT64 and
        must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        return pulumi.get(self, "total_service_filter")


@pulumi.output_type
class SloWindowsBasedSli(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "goodBadMetricFilter":
            suggest = "good_bad_metric_filter"
        elif key == "goodTotalRatioThreshold":
            suggest = "good_total_ratio_threshold"
        elif key == "metricMeanInRange":
            suggest = "metric_mean_in_range"
        elif key == "metricSumInRange":
            suggest = "metric_sum_in_range"
        elif key == "windowPeriod":
            suggest = "window_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SloWindowsBasedSli. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SloWindowsBasedSli.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SloWindowsBasedSli.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 good_bad_metric_filter: Optional[str] = None,
                 good_total_ratio_threshold: Optional['outputs.SloWindowsBasedSliGoodTotalRatioThreshold'] = None,
                 metric_mean_in_range: Optional['outputs.SloWindowsBasedSliMetricMeanInRange'] = None,
                 metric_sum_in_range: Optional['outputs.SloWindowsBasedSliMetricSumInRange'] = None,
                 window_period: Optional[str] = None):
        """
        :param str good_bad_metric_filter: A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
               with ValueType = BOOL. The window is good if any true values
               appear in the window. One of `good_bad_metric_filter`,
               `good_total_ratio_threshold`, `metric_mean_in_range`,
               `metric_sum_in_range` must be set for `windows_based_sli`.
        :param 'SloWindowsBasedSliGoodTotalRatioThresholdArgs' good_total_ratio_threshold: Criterion that describes a window as good if its performance is
               high enough. One of `good_bad_metric_filter`,
               `good_total_ratio_threshold`, `metric_mean_in_range`,
               `metric_sum_in_range` must be set for `windows_based_sli`.
               Structure is documented below.
        :param 'SloWindowsBasedSliMetricMeanInRangeArgs' metric_mean_in_range: Criterion that describes a window as good if the metric's value
               is in a good range, *averaged* across returned streams.
               One of `good_bad_metric_filter`,
               `good_total_ratio_threshold`, `metric_mean_in_range`,
               `metric_sum_in_range` must be set for `windows_based_sli`.
               Average value X of `time_series` should satisfy
               `range.min <= X <= range.max` for a good window.
               Structure is documented below.
        :param 'SloWindowsBasedSliMetricSumInRangeArgs' metric_sum_in_range: Criterion that describes a window as good if the metric's value
               is in a good range, *summed* across returned streams.
               Summed value `X` of `time_series` should satisfy
               `range.min <= X <= range.max` for a good window.
               One of `good_bad_metric_filter`,
               `good_total_ratio_threshold`, `metric_mean_in_range`,
               `metric_sum_in_range` must be set for `windows_based_sli`.
               Structure is documented below.
        :param str window_period: Duration over which window quality is evaluated, given as a
               duration string "{X}s" representing X seconds. Must be an
               integer fraction of a day and at least 60s.
        """
        if good_bad_metric_filter is not None:
            pulumi.set(__self__, "good_bad_metric_filter", good_bad_metric_filter)
        if good_total_ratio_threshold is not None:
            pulumi.set(__self__, "good_total_ratio_threshold", good_total_ratio_threshold)
        if metric_mean_in_range is not None:
            pulumi.set(__self__, "metric_mean_in_range", metric_mean_in_range)
        if metric_sum_in_range is not None:
            pulumi.set(__self__, "metric_sum_in_range", metric_sum_in_range)
        if window_period is not None:
            pulumi.set(__self__, "window_period", window_period)

    @property
    @pulumi.getter(name="goodBadMetricFilter")
    def good_bad_metric_filter(self) -> Optional[str]:
        """
        A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        with ValueType = BOOL. The window is good if any true values
        appear in the window. One of `good_bad_metric_filter`,
        `good_total_ratio_threshold`, `metric_mean_in_range`,
        `metric_sum_in_range` must be set for `windows_based_sli`.
        """
        return pulumi.get(self, "good_bad_metric_filter")

    @property
    @pulumi.getter(name="goodTotalRatioThreshold")
    def good_total_ratio_threshold(self) -> Optional['outputs.SloWindowsBasedSliGoodTotalRatioThreshold']:
        """
        Criterion that describes a window as good if its performance is
        high enough. One of `good_bad_metric_filter`,
        `good_total_ratio_threshold`, `metric_mean_in_range`,
        `metric_sum_in_range` must be set for `windows_based_sli`.
        Structure is documented below.
        """
        return pulumi.get(self, "good_total_ratio_threshold")

    @property
    @pulumi.getter(name="metricMeanInRange")
    def metric_mean_in_range(self) -> Optional['outputs.SloWindowsBasedSliMetricMeanInRange']:
        """
        Criterion that describes a window as good if the metric's value
        is in a good range, *averaged* across returned streams.
        One of `good_bad_metric_filter`,
        `good_total_ratio_threshold`, `metric_mean_in_range`,
        `metric_sum_in_range` must be set for `windows_based_sli`.
        Average value X of `time_series` should satisfy
        `range.min <= X <= range.max` for a good window.
        Structure is documented below.
        """
        return pulumi.get(self, "metric_mean_in_range")

    @property
    @pulumi.getter(name="metricSumInRange")
    def metric_sum_in_range(self) -> Optional['outputs.SloWindowsBasedSliMetricSumInRange']:
        """
        Criterion that describes a window as good if the metric's value
        is in a good range, *summed* across returned streams.
        Summed value `X` of `time_series` should satisfy
        `range.min <= X <= range.max` for a good window.
        One of `good_bad_metric_filter`,
        `good_total_ratio_threshold`, `metric_mean_in_range`,
        `metric_sum_in_range` must be set for `windows_based_sli`.
        Structure is documented below.
        """
        return pulumi.get(self, "metric_sum_in_range")

    @property
    @pulumi.getter(name="windowPeriod")
    def window_period(self) -> Optional[str]:
        """
        Duration over which window quality is evaluated, given as a
        duration string "{X}s" representing X seconds. Must be an
        integer fraction of a day and at least 60s.
        """
        return pulumi.get(self, "window_period")


@pulumi.output_type
class SloWindowsBasedSliGoodTotalRatioThreshold(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicSliPerformance":
            suggest = "basic_sli_performance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SloWindowsBasedSliGoodTotalRatioThreshold. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SloWindowsBasedSliGoodTotalRatioThreshold.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SloWindowsBasedSliGoodTotalRatioThreshold.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_sli_performance: Optional['outputs.SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance'] = None,
                 performance: Optional['outputs.SloWindowsBasedSliGoodTotalRatioThresholdPerformance'] = None,
                 threshold: Optional[float] = None):
        """
        :param 'SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceArgs' basic_sli_performance: Basic SLI to evaluate to judge window quality.
               Structure is documented below.
        :param 'SloWindowsBasedSliGoodTotalRatioThresholdPerformanceArgs' performance: Request-based SLI to evaluate to judge window quality.
               Structure is documented below.
        :param float threshold: A duration string, e.g. 10s.
               Good service is defined to be the count of requests made to
               this service that return in no more than threshold.
        """
        if basic_sli_performance is not None:
            pulumi.set(__self__, "basic_sli_performance", basic_sli_performance)
        if performance is not None:
            pulumi.set(__self__, "performance", performance)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter(name="basicSliPerformance")
    def basic_sli_performance(self) -> Optional['outputs.SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance']:
        """
        Basic SLI to evaluate to judge window quality.
        Structure is documented below.
        """
        return pulumi.get(self, "basic_sli_performance")

    @property
    @pulumi.getter
    def performance(self) -> Optional['outputs.SloWindowsBasedSliGoodTotalRatioThresholdPerformance']:
        """
        Request-based SLI to evaluate to judge window quality.
        Structure is documented below.
        """
        return pulumi.get(self, "performance")

    @property
    @pulumi.getter
    def threshold(self) -> Optional[float]:
        """
        A duration string, e.g. 10s.
        Good service is defined to be the count of requests made to
        this service that return in no more than threshold.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance(dict):
    def __init__(__self__, *,
                 availability: Optional['outputs.SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability'] = None,
                 latency: Optional['outputs.SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency'] = None,
                 locations: Optional[Sequence[str]] = None,
                 methods: Optional[Sequence[str]] = None,
                 versions: Optional[Sequence[str]] = None):
        """
        :param 'SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailabilityArgs' availability: Availability based SLI, dervied from count of requests made to this service that return successfully.
               Structure is documented below.
        :param 'SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatencyArgs' latency: Parameters for a latency threshold SLI.
               Structure is documented below.
        :param Sequence[str] locations: An optional set of locations to which this SLI is relevant.
               Telemetry from other locations will not be used to calculate
               performance for this SLI. If omitted, this SLI applies to all
               locations in which the Service has activity. For service types
               that don't support breaking down by location, setting this
               field will result in an error.
        :param Sequence[str] methods: An optional set of RPCs to which this SLI is relevant.
               Telemetry from other methods will not be used to calculate
               performance for this SLI. If omitted, this SLI applies to all
               the Service's methods. For service types that don't support
               breaking down by method, setting this field will result in an
               error.
        :param Sequence[str] versions: The set of API versions to which this SLI is relevant.
               Telemetry from other API versions will not be used to
               calculate performance for this SLI. If omitted,
               this SLI applies to all API versions. For service types
               that don't support breaking down by version, setting this
               field will result in an error.
        """
        if availability is not None:
            pulumi.set(__self__, "availability", availability)
        if latency is not None:
            pulumi.set(__self__, "latency", latency)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if methods is not None:
            pulumi.set(__self__, "methods", methods)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @property
    @pulumi.getter
    def availability(self) -> Optional['outputs.SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability']:
        """
        Availability based SLI, dervied from count of requests made to this service that return successfully.
        Structure is documented below.
        """
        return pulumi.get(self, "availability")

    @property
    @pulumi.getter
    def latency(self) -> Optional['outputs.SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency']:
        """
        Parameters for a latency threshold SLI.
        Structure is documented below.
        """
        return pulumi.get(self, "latency")

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence[str]]:
        """
        An optional set of locations to which this SLI is relevant.
        Telemetry from other locations will not be used to calculate
        performance for this SLI. If omitted, this SLI applies to all
        locations in which the Service has activity. For service types
        that don't support breaking down by location, setting this
        field will result in an error.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def methods(self) -> Optional[Sequence[str]]:
        """
        An optional set of RPCs to which this SLI is relevant.
        Telemetry from other methods will not be used to calculate
        performance for this SLI. If omitted, this SLI applies to all
        the Service's methods. For service types that don't support
        breaking down by method, setting this field will result in an
        error.
        """
        return pulumi.get(self, "methods")

    @property
    @pulumi.getter
    def versions(self) -> Optional[Sequence[str]]:
        """
        The set of API versions to which this SLI is relevant.
        Telemetry from other API versions will not be used to
        calculate performance for this SLI. If omitted,
        this SLI applies to all API versions. For service types
        that don't support breaking down by version, setting this
        field will result in an error.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        :param bool enabled: Whether an availability SLI is enabled or not. Must be set to `true. Defaults to `true`.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether an availability SLI is enabled or not. Must be set to `true. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class SloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency(dict):
    def __init__(__self__, *,
                 threshold: str):
        """
        :param str threshold: A duration string, e.g. 10s.
               Good service is defined to be the count of requests made to
               this service that return in no more than threshold.
        """
        pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def threshold(self) -> str:
        """
        A duration string, e.g. 10s.
        Good service is defined to be the count of requests made to
        this service that return in no more than threshold.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class SloWindowsBasedSliGoodTotalRatioThresholdPerformance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "distributionCut":
            suggest = "distribution_cut"
        elif key == "goodTotalRatio":
            suggest = "good_total_ratio"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SloWindowsBasedSliGoodTotalRatioThresholdPerformance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SloWindowsBasedSliGoodTotalRatioThresholdPerformance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SloWindowsBasedSliGoodTotalRatioThresholdPerformance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distribution_cut: Optional['outputs.SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut'] = None,
                 good_total_ratio: Optional['outputs.SloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio'] = None):
        """
        :param 'SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutArgs' distribution_cut: Used when good_service is defined by a count of values aggregated in a
               Distribution that fall into a good range. The total_service is the
               total count of all values aggregated in the Distribution.
               Defines a distribution TimeSeries filter and thresholds used for
               measuring good service and total service.
               Structure is documented below.
        :param 'SloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatioArgs' good_total_ratio: A means to compute a ratio of `good_service` to `total_service`.
               Defines computing this ratio with two TimeSeries [monitoring filters](https://cloud.google.com/monitoring/api/v3/filters)
               Must specify exactly two of good, bad, and total service filters.
               The relationship good_service + bad_service = total_service
               will be assumed.
               Structure is documented below.
        """
        if distribution_cut is not None:
            pulumi.set(__self__, "distribution_cut", distribution_cut)
        if good_total_ratio is not None:
            pulumi.set(__self__, "good_total_ratio", good_total_ratio)

    @property
    @pulumi.getter(name="distributionCut")
    def distribution_cut(self) -> Optional['outputs.SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut']:
        """
        Used when good_service is defined by a count of values aggregated in a
        Distribution that fall into a good range. The total_service is the
        total count of all values aggregated in the Distribution.
        Defines a distribution TimeSeries filter and thresholds used for
        measuring good service and total service.
        Structure is documented below.
        """
        return pulumi.get(self, "distribution_cut")

    @property
    @pulumi.getter(name="goodTotalRatio")
    def good_total_ratio(self) -> Optional['outputs.SloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio']:
        """
        A means to compute a ratio of `good_service` to `total_service`.
        Defines computing this ratio with two TimeSeries [monitoring filters](https://cloud.google.com/monitoring/api/v3/filters)
        Must specify exactly two of good, bad, and total service filters.
        The relationship good_service + bad_service = total_service
        will be assumed.
        Structure is documented below.
        """
        return pulumi.get(self, "good_total_ratio")


@pulumi.output_type
class SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "distributionFilter":
            suggest = "distribution_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distribution_filter: str,
                 range: 'outputs.SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange'):
        """
        :param str distribution_filter: A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
               aggregating values to quantify the good service provided.
               Must have ValueType = DISTRIBUTION and
               MetricKind = DELTA or MetricKind = CUMULATIVE.
        :param 'SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRangeArgs' range: Range of numerical values. The computed good_service
               will be the count of values x in the Distribution such
               that range.min <= x <= range.max. inclusive of min and
               max. Open ranges can be defined by setting
               just one of min or max. Summed value `X` should satisfy
               `range.min <= X <= range.max` for a good window.
               Structure is documented below.
        """
        pulumi.set(__self__, "distribution_filter", distribution_filter)
        pulumi.set(__self__, "range", range)

    @property
    @pulumi.getter(name="distributionFilter")
    def distribution_filter(self) -> str:
        """
        A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        aggregating values to quantify the good service provided.
        Must have ValueType = DISTRIBUTION and
        MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        return pulumi.get(self, "distribution_filter")

    @property
    @pulumi.getter
    def range(self) -> 'outputs.SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange':
        """
        Range of numerical values. The computed good_service
        will be the count of values x in the Distribution such
        that range.min <= x <= range.max. inclusive of min and
        max. Open ranges can be defined by setting
        just one of min or max. Summed value `X` should satisfy
        `range.min <= X <= range.max` for a good window.
        Structure is documented below.
        """
        return pulumi.get(self, "range")


@pulumi.output_type
class SloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange(dict):
    def __init__(__self__, *,
                 max: Optional[float] = None,
                 min: Optional[float] = None):
        """
        :param float max: max value for the range (inclusive). If not given,
               will be set to "infinity", defining an open range
               ">= range.min"
        :param float min: Min value for the range (inclusive). If not given,
               will be set to "-infinity", defining an open range
               "< range.max"
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[float]:
        """
        max value for the range (inclusive). If not given,
        will be set to "infinity", defining an open range
        ">= range.min"
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[float]:
        """
        Min value for the range (inclusive). If not given,
        will be set to "-infinity", defining an open range
        "< range.max"
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class SloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "badServiceFilter":
            suggest = "bad_service_filter"
        elif key == "goodServiceFilter":
            suggest = "good_service_filter"
        elif key == "totalServiceFilter":
            suggest = "total_service_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bad_service_filter: Optional[str] = None,
                 good_service_filter: Optional[str] = None,
                 total_service_filter: Optional[str] = None):
        """
        :param str bad_service_filter: A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
               quantifying bad service provided, either demanded service that
               was not provided or demanded service that was of inadequate
               quality. Exactly two of
               good, bad, or total service filter must be defined (where
               good + bad = total is assumed)
               Must have ValueType = DOUBLE or ValueType = INT64 and
               must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        :param str good_service_filter: A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
               quantifying good service provided. Exactly two of
               good, bad, or total service filter must be defined (where
               good + bad = total is assumed)
               Must have ValueType = DOUBLE or ValueType = INT64 and
               must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        :param str total_service_filter: A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
               quantifying total demanded service. Exactly two of
               good, bad, or total service filter must be defined (where
               good + bad = total is assumed)
               Must have ValueType = DOUBLE or ValueType = INT64 and
               must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        if bad_service_filter is not None:
            pulumi.set(__self__, "bad_service_filter", bad_service_filter)
        if good_service_filter is not None:
            pulumi.set(__self__, "good_service_filter", good_service_filter)
        if total_service_filter is not None:
            pulumi.set(__self__, "total_service_filter", total_service_filter)

    @property
    @pulumi.getter(name="badServiceFilter")
    def bad_service_filter(self) -> Optional[str]:
        """
        A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        quantifying bad service provided, either demanded service that
        was not provided or demanded service that was of inadequate
        quality. Exactly two of
        good, bad, or total service filter must be defined (where
        good + bad = total is assumed)
        Must have ValueType = DOUBLE or ValueType = INT64 and
        must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        return pulumi.get(self, "bad_service_filter")

    @property
    @pulumi.getter(name="goodServiceFilter")
    def good_service_filter(self) -> Optional[str]:
        """
        A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        quantifying good service provided. Exactly two of
        good, bad, or total service filter must be defined (where
        good + bad = total is assumed)
        Must have ValueType = DOUBLE or ValueType = INT64 and
        must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        return pulumi.get(self, "good_service_filter")

    @property
    @pulumi.getter(name="totalServiceFilter")
    def total_service_filter(self) -> Optional[str]:
        """
        A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        quantifying total demanded service. Exactly two of
        good, bad, or total service filter must be defined (where
        good + bad = total is assumed)
        Must have ValueType = DOUBLE or ValueType = INT64 and
        must have MetricKind = DELTA or MetricKind = CUMULATIVE.
        """
        return pulumi.get(self, "total_service_filter")


@pulumi.output_type
class SloWindowsBasedSliMetricMeanInRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeSeries":
            suggest = "time_series"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SloWindowsBasedSliMetricMeanInRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SloWindowsBasedSliMetricMeanInRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SloWindowsBasedSliMetricMeanInRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 range: 'outputs.SloWindowsBasedSliMetricMeanInRangeRange',
                 time_series: str):
        """
        :param 'SloWindowsBasedSliMetricMeanInRangeRangeArgs' range: Range of numerical values. The computed good_service
               will be the count of values x in the Distribution such
               that range.min <= x <= range.max. inclusive of min and
               max. Open ranges can be defined by setting
               just one of min or max. Summed value `X` should satisfy
               `range.min <= X <= range.max` for a good window.
               Structure is documented below.
        :param str time_series: A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
               specifying the TimeSeries to use for evaluating window
               quality. The provided TimeSeries must have
               ValueType = INT64 or ValueType = DOUBLE and
               MetricKind = GAUGE.
               Summed value `X` should satisfy
               `range.min <= X <= range.max` for a good window.
        """
        pulumi.set(__self__, "range", range)
        pulumi.set(__self__, "time_series", time_series)

    @property
    @pulumi.getter
    def range(self) -> 'outputs.SloWindowsBasedSliMetricMeanInRangeRange':
        """
        Range of numerical values. The computed good_service
        will be the count of values x in the Distribution such
        that range.min <= x <= range.max. inclusive of min and
        max. Open ranges can be defined by setting
        just one of min or max. Summed value `X` should satisfy
        `range.min <= X <= range.max` for a good window.
        Structure is documented below.
        """
        return pulumi.get(self, "range")

    @property
    @pulumi.getter(name="timeSeries")
    def time_series(self) -> str:
        """
        A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        specifying the TimeSeries to use for evaluating window
        quality. The provided TimeSeries must have
        ValueType = INT64 or ValueType = DOUBLE and
        MetricKind = GAUGE.
        Summed value `X` should satisfy
        `range.min <= X <= range.max` for a good window.
        """
        return pulumi.get(self, "time_series")


@pulumi.output_type
class SloWindowsBasedSliMetricMeanInRangeRange(dict):
    def __init__(__self__, *,
                 max: Optional[float] = None,
                 min: Optional[float] = None):
        """
        :param float max: max value for the range (inclusive). If not given,
               will be set to "infinity", defining an open range
               ">= range.min"
        :param float min: Min value for the range (inclusive). If not given,
               will be set to "-infinity", defining an open range
               "< range.max"
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[float]:
        """
        max value for the range (inclusive). If not given,
        will be set to "infinity", defining an open range
        ">= range.min"
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[float]:
        """
        Min value for the range (inclusive). If not given,
        will be set to "-infinity", defining an open range
        "< range.max"
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class SloWindowsBasedSliMetricSumInRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeSeries":
            suggest = "time_series"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SloWindowsBasedSliMetricSumInRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SloWindowsBasedSliMetricSumInRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SloWindowsBasedSliMetricSumInRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 range: 'outputs.SloWindowsBasedSliMetricSumInRangeRange',
                 time_series: str):
        """
        :param 'SloWindowsBasedSliMetricSumInRangeRangeArgs' range: Range of numerical values. The computed good_service
               will be the count of values x in the Distribution such
               that range.min <= x <= range.max. inclusive of min and
               max. Open ranges can be defined by setting
               just one of min or max. Summed value `X` should satisfy
               `range.min <= X <= range.max` for a good window.
               Structure is documented below.
        :param str time_series: A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
               specifying the TimeSeries to use for evaluating window
               quality. The provided TimeSeries must have
               ValueType = INT64 or ValueType = DOUBLE and
               MetricKind = GAUGE.
               Summed value `X` should satisfy
               `range.min <= X <= range.max` for a good window.
        """
        pulumi.set(__self__, "range", range)
        pulumi.set(__self__, "time_series", time_series)

    @property
    @pulumi.getter
    def range(self) -> 'outputs.SloWindowsBasedSliMetricSumInRangeRange':
        """
        Range of numerical values. The computed good_service
        will be the count of values x in the Distribution such
        that range.min <= x <= range.max. inclusive of min and
        max. Open ranges can be defined by setting
        just one of min or max. Summed value `X` should satisfy
        `range.min <= X <= range.max` for a good window.
        Structure is documented below.
        """
        return pulumi.get(self, "range")

    @property
    @pulumi.getter(name="timeSeries")
    def time_series(self) -> str:
        """
        A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        specifying the TimeSeries to use for evaluating window
        quality. The provided TimeSeries must have
        ValueType = INT64 or ValueType = DOUBLE and
        MetricKind = GAUGE.
        Summed value `X` should satisfy
        `range.min <= X <= range.max` for a good window.
        """
        return pulumi.get(self, "time_series")


@pulumi.output_type
class SloWindowsBasedSliMetricSumInRangeRange(dict):
    def __init__(__self__, *,
                 max: Optional[float] = None,
                 min: Optional[float] = None):
        """
        :param float max: max value for the range (inclusive). If not given,
               will be set to "infinity", defining an open range
               ">= range.min"
        :param float min: Min value for the range (inclusive). If not given,
               will be set to "-infinity", defining an open range
               "< range.max"
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[float]:
        """
        max value for the range (inclusive). If not given,
        will be set to "infinity", defining an open range
        ">= range.min"
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[float]:
        """
        Min value for the range (inclusive). If not given,
        will be set to "-infinity", defining an open range
        "< range.max"
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class UptimeCheckConfigContentMatcher(dict):
    def __init__(__self__, *,
                 content: str,
                 matcher: Optional[str] = None):
        """
        :param str content: String or regex content to match (max 1024 bytes)
        :param str matcher: The type of content matcher that will be applied to the server output, compared to the content string when the check is run.
               Default value is `CONTAINS_STRING`.
               Possible values are `CONTAINS_STRING`, `NOT_CONTAINS_STRING`, `MATCHES_REGEX`, and `NOT_MATCHES_REGEX`.
        """
        pulumi.set(__self__, "content", content)
        if matcher is not None:
            pulumi.set(__self__, "matcher", matcher)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        String or regex content to match (max 1024 bytes)
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def matcher(self) -> Optional[str]:
        """
        The type of content matcher that will be applied to the server output, compared to the content string when the check is run.
        Default value is `CONTAINS_STRING`.
        Possible values are `CONTAINS_STRING`, `NOT_CONTAINS_STRING`, `MATCHES_REGEX`, and `NOT_MATCHES_REGEX`.
        """
        return pulumi.get(self, "matcher")


@pulumi.output_type
class UptimeCheckConfigHttpCheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authInfo":
            suggest = "auth_info"
        elif key == "contentType":
            suggest = "content_type"
        elif key == "maskHeaders":
            suggest = "mask_headers"
        elif key == "requestMethod":
            suggest = "request_method"
        elif key == "useSsl":
            suggest = "use_ssl"
        elif key == "validateSsl":
            suggest = "validate_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UptimeCheckConfigHttpCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UptimeCheckConfigHttpCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UptimeCheckConfigHttpCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_info: Optional['outputs.UptimeCheckConfigHttpCheckAuthInfo'] = None,
                 body: Optional[str] = None,
                 content_type: Optional[str] = None,
                 headers: Optional[Mapping[str, str]] = None,
                 mask_headers: Optional[bool] = None,
                 path: Optional[str] = None,
                 port: Optional[int] = None,
                 request_method: Optional[str] = None,
                 use_ssl: Optional[bool] = None,
                 validate_ssl: Optional[bool] = None):
        """
        :param 'UptimeCheckConfigHttpCheckAuthInfoArgs' auth_info: The authentication information. Optional when creating an HTTP check; defaults to empty.
               Structure is documented below.
        :param str body: The request body associated with the HTTP POST request. If contentType is URL_ENCODED, the body passed in must be URL-encoded. Users can provide a Content-Length header via the headers field or the API will do so. If the requestMethod is GET and body is not empty, the API will return an error. The maximum byte size is 1 megabyte. Note - As with all bytes fields JSON representations are base64 encoded. e.g. "foo=bar" in URL-encoded form is "foo%3Dbar" and in base64 encoding is "Zm9vJTI1M0RiYXI=".
        :param str content_type: The content type to use for the check.
               Possible values are `TYPE_UNSPECIFIED` and `URL_ENCODED`.
        :param Mapping[str, str] headers: The list of headers to send as part of the uptime check request. If two headers have the same key and different values, they should be entered as a single header, with the value being a comma-separated list of all the desired values as described at https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31). Entering two separate headers with the same key in a Create call will cause the first to be overwritten by the second. The maximum number of headers allowed is 100.
        :param bool mask_headers: Boolean specifying whether to encrypt the header information. Encryption should be specified for any headers related to authentication that you do not wish to be seen when retrieving the configuration. The server will be responsible for encrypting the headers. On Get/List calls, if mask_headers is set to True then the headers will be obscured with ******.
        :param str path: The path to the page to run the check against. Will be combined with the host (specified within the MonitoredResource) and port to construct the full URL. Optional (defaults to "/").
        :param int port: The port to the page to run the check against. Will be combined with host (specified within the MonitoredResource) to construct the full URL.
        :param str request_method: The HTTP request method to use for the check. If set to METHOD_UNSPECIFIED then requestMethod defaults to GET.
               Default value is `GET`.
               Possible values are `METHOD_UNSPECIFIED`, `GET`, and `POST`.
        :param bool use_ssl: If true, use HTTPS instead of HTTP to run the check.
        :param bool validate_ssl: Boolean specifying whether to include SSL certificate validation as a part of the Uptime check. Only applies to checks where monitoredResource is set to uptime_url. If useSsl is false, setting validateSsl to true has no effect.
        """
        if auth_info is not None:
            pulumi.set(__self__, "auth_info", auth_info)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if mask_headers is not None:
            pulumi.set(__self__, "mask_headers", mask_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if request_method is not None:
            pulumi.set(__self__, "request_method", request_method)
        if use_ssl is not None:
            pulumi.set(__self__, "use_ssl", use_ssl)
        if validate_ssl is not None:
            pulumi.set(__self__, "validate_ssl", validate_ssl)

    @property
    @pulumi.getter(name="authInfo")
    def auth_info(self) -> Optional['outputs.UptimeCheckConfigHttpCheckAuthInfo']:
        """
        The authentication information. Optional when creating an HTTP check; defaults to empty.
        Structure is documented below.
        """
        return pulumi.get(self, "auth_info")

    @property
    @pulumi.getter
    def body(self) -> Optional[str]:
        """
        The request body associated with the HTTP POST request. If contentType is URL_ENCODED, the body passed in must be URL-encoded. Users can provide a Content-Length header via the headers field or the API will do so. If the requestMethod is GET and body is not empty, the API will return an error. The maximum byte size is 1 megabyte. Note - As with all bytes fields JSON representations are base64 encoded. e.g. "foo=bar" in URL-encoded form is "foo%3Dbar" and in base64 encoding is "Zm9vJTI1M0RiYXI=".
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[str]:
        """
        The content type to use for the check.
        Possible values are `TYPE_UNSPECIFIED` and `URL_ENCODED`.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Mapping[str, str]]:
        """
        The list of headers to send as part of the uptime check request. If two headers have the same key and different values, they should be entered as a single header, with the value being a comma-separated list of all the desired values as described at https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31). Entering two separate headers with the same key in a Create call will cause the first to be overwritten by the second. The maximum number of headers allowed is 100.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="maskHeaders")
    def mask_headers(self) -> Optional[bool]:
        """
        Boolean specifying whether to encrypt the header information. Encryption should be specified for any headers related to authentication that you do not wish to be seen when retrieving the configuration. The server will be responsible for encrypting the headers. On Get/List calls, if mask_headers is set to True then the headers will be obscured with ******.
        """
        return pulumi.get(self, "mask_headers")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to the page to run the check against. Will be combined with the host (specified within the MonitoredResource) and port to construct the full URL. Optional (defaults to "/").
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port to the page to run the check against. Will be combined with host (specified within the MonitoredResource) to construct the full URL.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="requestMethod")
    def request_method(self) -> Optional[str]:
        """
        The HTTP request method to use for the check. If set to METHOD_UNSPECIFIED then requestMethod defaults to GET.
        Default value is `GET`.
        Possible values are `METHOD_UNSPECIFIED`, `GET`, and `POST`.
        """
        return pulumi.get(self, "request_method")

    @property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> Optional[bool]:
        """
        If true, use HTTPS instead of HTTP to run the check.
        """
        return pulumi.get(self, "use_ssl")

    @property
    @pulumi.getter(name="validateSsl")
    def validate_ssl(self) -> Optional[bool]:
        """
        Boolean specifying whether to include SSL certificate validation as a part of the Uptime check. Only applies to checks where monitoredResource is set to uptime_url. If useSsl is false, setting validateSsl to true has no effect.
        """
        return pulumi.get(self, "validate_ssl")


@pulumi.output_type
class UptimeCheckConfigHttpCheckAuthInfo(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: The password to authenticate.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str username: The username to authenticate.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password to authenticate.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The username to authenticate.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class UptimeCheckConfigMonitoredResource(dict):
    def __init__(__self__, *,
                 labels: Mapping[str, str],
                 type: str):
        """
        :param Mapping[str, str] labels: Values for all of the labels listed in the associated monitored resource descriptor. For example, Compute Engine VM instances use the labels "project_id", "instance_id", and "zone".
        :param str type: The monitored resource type. This field must match the type field of a MonitoredResourceDescriptor (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.monitoredResourceDescriptors#MonitoredResourceDescriptor) object. For example, the type of a Compute Engine VM instance is gce_instance. For a list of types, see Monitoring resource types (https://cloud.google.com/monitoring/api/resources) and Logging resource types (https://cloud.google.com/logging/docs/api/v2/resource-list).
        """
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Values for all of the labels listed in the associated monitored resource descriptor. For example, Compute Engine VM instances use the labels "project_id", "instance_id", and "zone".
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The monitored resource type. This field must match the type field of a MonitoredResourceDescriptor (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.monitoredResourceDescriptors#MonitoredResourceDescriptor) object. For example, the type of a Compute Engine VM instance is gce_instance. For a list of types, see Monitoring resource types (https://cloud.google.com/monitoring/api/resources) and Logging resource types (https://cloud.google.com/logging/docs/api/v2/resource-list).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class UptimeCheckConfigResourceGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupId":
            suggest = "group_id"
        elif key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UptimeCheckConfigResourceGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UptimeCheckConfigResourceGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UptimeCheckConfigResourceGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_id: Optional[str] = None,
                 resource_type: Optional[str] = None):
        """
        :param str group_id: The group of resources being monitored. Should be the `name` of a group
        :param str resource_type: The resource type of the group members.
               Possible values are `RESOURCE_TYPE_UNSPECIFIED`, `INSTANCE`, and `AWS_ELB_LOAD_BALANCER`.
        """
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[str]:
        """
        The group of resources being monitored. Should be the `name` of a group
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[str]:
        """
        The resource type of the group members.
        Possible values are `RESOURCE_TYPE_UNSPECIFIED`, `INSTANCE`, and `AWS_ELB_LOAD_BALANCER`.
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class UptimeCheckConfigTcpCheck(dict):
    def __init__(__self__, *,
                 port: int):
        """
        :param int port: The port to the page to run the check against. Will be combined with host (specified within the MonitoredResource) to construct the full URL.
        """
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port to the page to run the check against. Will be combined with host (specified within the MonitoredResource) to construct the full URL.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetAppEngineServiceTelemetryResult(dict):
    def __init__(__self__, *,
                 resource_name: str):
        pulumi.set(__self__, "resource_name", resource_name)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> str:
        return pulumi.get(self, "resource_name")


@pulumi.output_type
class GetClusterIstioServiceTelemetryResult(dict):
    def __init__(__self__, *,
                 resource_name: str):
        pulumi.set(__self__, "resource_name", resource_name)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> str:
        return pulumi.get(self, "resource_name")


@pulumi.output_type
class GetIstioCanonicalServiceTelemetryResult(dict):
    def __init__(__self__, *,
                 resource_name: str):
        pulumi.set(__self__, "resource_name", resource_name)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> str:
        return pulumi.get(self, "resource_name")


@pulumi.output_type
class GetMeshIstioServiceTelemetryResult(dict):
    def __init__(__self__, *,
                 resource_name: str):
        pulumi.set(__self__, "resource_name", resource_name)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> str:
        return pulumi.get(self, "resource_name")


@pulumi.output_type
class GetNotificationChannelSensitiveLabelResult(dict):
    def __init__(__self__, *,
                 auth_token: str,
                 password: str,
                 service_key: str):
        pulumi.set(__self__, "auth_token", auth_token)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "service_key", service_key)

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> str:
        return pulumi.get(self, "auth_token")

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="serviceKey")
    def service_key(self) -> str:
        return pulumi.get(self, "service_key")


@pulumi.output_type
class GetUptimeCheckIPsUptimeCheckIpResult(dict):
    def __init__(__self__, *,
                 ip_address: str,
                 location: str,
                 region: str):
        """
        :param str ip_address: The IP address from which the Uptime check originates. This is a fully specified IP address
               (not an IP address range). Most IP addresses, as of this publication, are in IPv4 format; however, one should not
               rely on the IP addresses being in IPv4 format indefinitely, and should support interpreting this field in either
               IPv4 or IPv6 format.
        :param str location: A more specific location within the region that typically encodes a particular city/town/metro
               (and its containing state/province or country) within the broader umbrella region category.
        :param str region: A broad region category in which the IP address is located.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address from which the Uptime check originates. This is a fully specified IP address
        (not an IP address range). Most IP addresses, as of this publication, are in IPv4 format; however, one should not
        rely on the IP addresses being in IPv4 format indefinitely, and should support interpreting this field in either
        IPv4 or IPv6 format.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        A more specific location within the region that typically encodes a particular city/town/metro
        (and its containing state/province or country) within the broader umbrella region category.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        A broad region category in which the IP address is located.
        """
        return pulumi.get(self, "region")


